/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.IntegrationTestHarness;
import kafka.durability.exception.MemoryLimitExceededException;
import kafka.durability.utils.DurabilityOffsetMapUtils$;
import kafka.durability.utils.OffsetInfo;
import kafka.log.AbstractLog;
import kafka.log.CleanedTransactionMetadata;
import kafka.log.LogManager;
import kafka.log.TierLogSegment;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;
import kafka.utils.CoreUtils$;
import kafka.utils.Throttler;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.SortedMap;
import scala.collection.mutable.SortedMap$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\u0005]g\u0001B\u0010!\u0001\u0015BQ\u0001\f\u0001\u0005\u00025BQ\u0001\r\u0001\u0005REBQ\u0001\u000f\u0001\u0005\neBq!\u0010\u0001C\u0002\u0013%a\b\u0003\u0004H\u0001\u0001\u0006Ia\u0010\u0005\b\u0011\u0002\u0011\r\u0011\"\u00032\u0011\u0019I\u0005\u0001)A\u0005e!9!\n\u0001b\u0001\n\u0013\t\u0004BB&\u0001A\u0003%!\u0007C\u0004M\u0001\u0001\u0007I\u0011B\u0019\t\u000f5\u0003\u0001\u0019!C\u0005\u001d\"1\u0011\u000b\u0001Q!\nIBqA\u0015\u0001C\u0002\u0013%1\u000b\u0003\u0004]\u0001\u0001\u0006I\u0001\u0016\u0005\u0006;\u0002!IA\u0018\u0005\bm\u0002\u0011\r\u0011\"\u0001x\u0011\u001d\t)\u0001\u0001Q\u0001\naDq!a\u0002\u0001\t\u0003\nI\u0001\u0003\u0004\u0002*\u0001!\t%\u000f\u0005\b\u0003g\u0001A\u0011BA\u001b\u0011\u001d\t\u0019\u0004\u0001C\u0005\u0003wAa!!\u0014\u0001\t\u0013I\u0004bBA(\u0001\u0011%\u0011\u0011\u000b\u0005\n\u0003;\u0002\u0011\u0013!C\u0005\u0003?Ba!!\u001e\u0001\t\u0013I\u0004BBA<\u0001\u0011%\u0011\b\u0003\u0004\u0002z\u0001!I!\u000f\u0005\b\u0003w\u0002A\u0011AA?\u0011\u001d\ty\f\u0001C\u0001\u0003\u0003Dq!a3\u0001\t\u0003\tiMA\tPM\u001a\u001cX\r^'ba\u001aKG.\u001a+fgRT!!\t\u0012\u0002\tQLWM\u001d\u0006\u0002G\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001'!\t9#&D\u0001)\u0015\tI#%A\u0002ba&L!a\u000b\u0015\u0003-%sG/Z4sCRLwN\u001c+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#\u0001\u0018\u0011\u0005=\u0002Q\"\u0001\u0011\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u000b\u0002eA\u00111GN\u0007\u0002i)\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028i\t\u0019\u0011J\u001c;\u0002\u001b\r|gNZ5hkJ,Wj\\2l)\u0005Q\u0004CA\u001a<\u0013\taDG\u0001\u0003V]&$\u0018!\u0002;pa&\u001cW#A \u0011\u0005\u0001+U\"A!\u000b\u0005\t\u001b\u0015\u0001\u00027b]\u001eT\u0011\u0001R\u0001\u0005U\u00064\u0018-\u0003\u0002G\u0003\n11\u000b\u001e:j]\u001e\fa\u0001^8qS\u000e\u0004\u0013A\u00039beRLG/[8og\u0006Y\u0001/\u0019:uSRLwN\\:!\u00035i\u0017\r\u001f(v[J+7m\u001c:eg\u0006qQ.\u0019=Ok6\u0014VmY8sIN\u0004\u0013A\u00058v[B\u0013x\u000eZ;dK\u0012\u0014VmY8sIN\faC\\;n!J|G-^2fIJ+7m\u001c:eg~#S-\u001d\u000b\u0003u=Cq\u0001U\u0006\u0002\u0002\u0003\u0007!'A\u0002yIE\n1C\\;n!J|G-^2fIJ+7m\u001c:eg\u0002\nq\u0002\u001d:pIV\u001cW\r\u001a*fG>\u0014Hm]\u000b\u0002)B!QK\u0017\u001a3\u001b\u00051&BA,Y\u0003\u001diW\u000f^1cY\u0016T!!\u0017\u001b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002\\-\n\u0019Q*\u00199\u0002!A\u0014x\u000eZ;dK\u0012\u0014VmY8sIN\u0004\u0013a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0016\u0003}\u00032\u0001\u00195l\u001d\t\tgM\u0004\u0002cK6\t1M\u0003\u0002eI\u00051AH]8pizJ\u0011!N\u0005\u0003OR\nq\u0001]1dW\u0006<W-\u0003\u0002jU\n\u00191+Z9\u000b\u0005\u001d$\u0004C\u00017u\u001b\u0005i'B\u00018p\u0003\u0019\u0019w.\\7p]*\u00111\u0005\u001d\u0006\u0003cJ\fa!\u00199bG\",'\"A:\u0002\u0007=\u0014x-\u0003\u0002v[\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017AB3ySR,G-F\u0001y!\rI\u0018\u0011A\u0007\u0002u*\u00111\u0010`\u0001\u0007CR|W.[2\u000b\u0005ut\u0018AC2p]\u000e,(O]3oi*\u0011qpQ\u0001\u0005kRLG.C\u0002\u0002\u0004i\u0014Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017aB3ySR,G\rI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0004u\u0005-\u0001bBA\u0007%\u0001\u0007\u0011qB\u0001\ti\u0016\u001cH/\u00138g_B!\u0011\u0011CA\u000f\u001b\t\t\u0019BC\u0002*\u0003+QA!a\u0006\u0002\u001a\u00059!.\u001e9ji\u0016\u0014(bAA\u000ee\u0006)!.\u001e8ji&!\u0011qDA\n\u0005!!Vm\u001d;J]\u001a|\u0007f\u0001\n\u0002$A!\u0011\u0011CA\u0013\u0013\u0011\t9#a\u0005\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\r\u0019\u0012Q\u0006\t\u0005\u0003#\ty#\u0003\u0003\u00022\u0005M!!C!gi\u0016\u0014X)Y2i\u0003M\u0001(o\u001c3vG\u0016\\U-_3e%\u0016\u001cwN\u001d3t)\rQ\u0014q\u0007\u0005\u0007\u0003s!\u0002\u0019\u0001\u001a\u0002\u00159,XNU3d_J$7\u000fF\u0002;\u0003{Aq!a\u0010\u0016\u0001\u0004\t\t%A\u0005lKf4\u0016\r\\;fgB)\u0001-a\u0011\u0002H%\u0019\u0011Q\t6\u0003\t1K7\u000f\u001e\t\u0006g\u0005%#GM\u0005\u0004\u0003\u0017\"$A\u0002+va2,''A\u0012xC&$XK\u001c;jYN+w-\\3oiN$\u0016.\u001a:fI\u0006sGmQ8na\u0006\u001cG/\u001a3\u0002\u001f\u0019LG\u000e^3s\u001f\u001a47/\u001a;NCB$2AOA*\u0011%\t)f\u0006I\u0001\u0002\u0004\t9&\u0001\npM\u001a\u001cX\r^'baNK'0\u001a'j[&$\bcA\u001a\u0002Z%\u0019\u00111\f\u001b\u0003\t1{gnZ\u0001\u001aM&dG/\u001a:PM\u001a\u001cX\r^'ba\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002b)\"\u0011qKA2W\t\t)\u0007\u0005\u0003\u0002h\u0005ETBAA5\u0015\u0011\tY'!\u001c\u0002\u0013Ut7\r[3dW\u0016$'bAA8i\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0014\u0011\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001E2mK\u0006tW\u000f\u001d+f[B4\u0015\u000e\\3t\u0003-\u0019G.Z1okB$Vm\u001d;\u0002\u001fY,'/\u001b4z\u001f\u001a47/\u001a;NCB\fa\u0003^3ti>3gm]3u\u001b\u0006\u0004(+\u001a;sS\u00164\u0018\r\u001c\u000b\u0004u\u0005}\u0004bBAA9\u0001\u0007\u00111Q\u0001\u0007cV|'/^7\u0011\t\u0005\u0015\u0015Q\u0012\b\u0005\u0003\u000f\u000bI\t\u0005\u0002ci%\u0019\u00111\u0012\u001b\u0002\rA\u0013X\rZ3g\u0013\r1\u0015q\u0012\u0006\u0004\u0003\u0017#\u0004f\u0002\u000f\u0002\u0014\u0006}\u0015\u0011\u0015\t\u0005\u0003+\u000bY*\u0004\u0002\u0002\u0018*!\u0011\u0011TA\u000b\u0003\u0019\u0001\u0018M]1ng&!\u0011QTAL\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0005]\u0006lW-\t\u0002\u0002$\u0006\u00113\u0010Z5ta2\f\u0017PT1nKvt30\u0019:hk6,g\u000e^:XSRDg*Y7fgvDs\u0001HAT\u0003g\u000b)\f\u0005\u0003\u0002*\u0006=VBAAV\u0015\u0011\ti+a&\u0002\u0011A\u0014xN^5eKJLA!!-\u0002,\nYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONdC!a.\u0002<\u0006\u0012\u0011\u0011X\u0001\u0003u.\f#!!0\u0002\u000b-\u0014\u0018M\u001a;\u0002\u001bQ,7\u000f^'fe\u001e,g)\u001b7f)\rQ\u00141\u0019\u0005\b\u0003\u0003k\u0002\u0019AABQ\u001di\u00121SAP\u0003CCs!HAT\u0003g\u000bI\r\f\u0003\u00028\u0006m\u0016A\u000e3b\u0007>l\u0007/Y2uS>t'+\u001e8Jg\u0006\u0013wN\u001d;fI&3wJ\u001a4tKRl\u0015\r]*ju\u0016,\u0005pY3fIN$\u0006.\u001a'j[&$Hc\u0001\u001e\u0002P\"9\u0011\u0011\u0011\u0010A\u0002\u0005\r\u0005f\u0002\u0010\u0002\u0014\u0006}\u0015\u0011\u0015\u0015\b=\u0005\u001d\u00161WAkY\u0011\t9,a/")
public class OffsetMapFileTest
extends IntegrationTestHarness {
    private final String topic;
    private final int partitions;
    private final int maxNumRecords;
    private int numProducedRecords;
    private final Map<Object, Object> producedRecords;
    private final AtomicBoolean exited;

    @Override
    public int brokerCount() {
        return 1;
    }

    private void configureMock() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), "mybucket");
    }

    private String topic() {
        return this.topic;
    }

    private int partitions() {
        return this.partitions;
    }

    private int maxNumRecords() {
        return this.maxNumRecords;
    }

    private int numProducedRecords() {
        return this.numProducedRecords;
    }

    private void numProducedRecords_$eq(int x$1) {
        this.numProducedRecords = x$1;
    }

    private Map<Object, Object> producedRecords() {
        return this.producedRecords;
    }

    private Seq<TopicPartition> topicPartitions() {
        return package$.MODULE$.Range().apply(0, this.partitions()).map((Function1 & Serializable)p -> OffsetMapFileTest.$anonfun$topicPartitions$1(this, BoxesRunTime.unboxToInt((Object)p)));
    }

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        Exit.setExitProcedure((x$1, x$2) -> this.exited().set(true));
        super.setUp(testInfo);
        this.numProducedRecords_$eq(0);
        this.producedRecords().clear();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        this.numProducedRecords_$eq(0);
        this.producedRecords().clear();
        Assertions.assertFalse((boolean)this.exited().get());
    }

    private void produceKeyedRecords(int numRecords) {
        Random random = new Random();
        List keyValues = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).toList().map((Function1 & Serializable)i -> OffsetMapFileTest.$anonfun$produceKeyedRecords$1(this, random, BoxesRunTime.unboxToInt((Object)i)));
        this.produceKeyedRecords((List<Tuple2<Object, Object>>)keyValues);
        this.numProducedRecords_$eq(this.numProducedRecords() + numRecords);
    }

    private void produceKeyedRecords(List<Tuple2<Object, Object>> keyValues) {
        try (KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());){
            keyValues.grouped(10).foreach((Function1 & Serializable)group -> group.map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    int k = x0$1._1$mcI$sp();
                    int v = x0$1._2$mcI$sp();
                    this.producedRecords().put((Object)BoxesRunTime.boxToInteger((int)k), (Object)BoxesRunTime.boxToInteger((int)v));
                    long timestamp = System.currentTimeMillis();
                    return new ProducerRecord(this.topic(), null, Predef$.MODULE$.long2Long(timestamp), (Object)Integer.toString(k).getBytes(StandardCharsets.UTF_8), (Object)Integer.toString(v).getBytes(StandardCharsets.UTF_8));
                }
                throw new MatchError(null);
            }).map((Function1 & Serializable)x$1 -> producer.send(x$1)).map((Function1 & Serializable)x$3 -> (RecordMetadata)x$3.get(10L, TimeUnit.SECONDS)));
        }
    }

    private void waitUntilSegmentsTieredAndCompacted() {
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            OffsetMapFileTest.$anonfun$waitUntilSegmentsTieredAndCompacted$1(this, tp);
            return BoxedUnit.UNIT;
        });
    }

    private void filterOffsetMap(long offsetMapSizeLimit) {
        Throttler throttler = new Throttler(100000.0, 100L, true, "throttler", "entries", Time.SYSTEM);
        ByteBuffer readBuffer = ByteBuffer.allocate(0x100000);
        MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore((Time)new MockTime(), new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1)));
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            OffsetMapFileTest.$anonfun$filterOffsetMap$1(this, tierObjectStore, throttler, readBuffer, offsetMapSizeLimit, tp);
            return BoxedUnit.UNIT;
        });
    }

    private long filterOffsetMap$default$1() {
        return 5000L;
    }

    private void cleanupTempFiles() {
        new File(".", "mergedFile.tmp").delete();
        new File(".", "newFile.tmp").delete();
    }

    private void cleanupTest() {
        new File(".", "mergedFile").delete();
        new File(".", "combinedFile").delete();
    }

    private void verifyOffsetMap() {
        this.cleanupTempFiles();
        this.cleanupTest();
        BooleanRef first = BooleanRef.create((boolean)true);
        ByteBuffer readBuffer = ByteBuffer.allocate(1024);
        Throttler throttler = new Throttler(100000.0, 100L, true, "throttler", "entries", Time.SYSTEM);
        SortedMap combinedMap = (SortedMap)SortedMap$.MODULE$.apply((Seq)Nil$.MODULE$, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        MockInMemoryTierObjectStore tierObjectStore = new MockInMemoryTierObjectStore((Time)new MockTime(), new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1)));
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            OffsetMapFileTest.$anonfun$verifyOffsetMap$1(this, tierObjectStore, throttler, readBuffer, combinedMap, first, tp);
            return BoxedUnit.UNIT;
        });
        DurabilityOffsetMapUtils$.MODULE$.storeOffsetMapInFile((scala.collection.SortedMap)combinedMap, Paths.get(".", "combinedFile").toFile(), false);
        Assertions.assertEquals((int)0, (int)DurabilityOffsetMapUtils$.MODULE$.checkCongruentOffsetMapFile(new TopicIdPartition(((TopicPartition)this.topicPartitions().head()).topic(), CoreUtils$.MODULE$.toJavaUUID(Uuid.randomUuid()), ((TopicPartition)this.topicPartitions().head()).partition()), new File(".", "combinedFile"), new File(".", "mergedFile")));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testOffsetMapRetrieval(String quorum) {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("retention.bytes", "-1");
        props.put("cleanup.policy", "compact");
        props.put("confluent.tier.cleaner.compact.min.efficiency", Double.toString(0.1));
        this.createTopic(this.topic(), this.partitions(), 1, props, this.createTopic$default$5(), this.createTopic$default$6());
        this.produceKeyedRecords(5000);
        this.waitUntilSegmentsTieredAndCompacted();
        this.filterOffsetMap(5000L);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testMergeFile(String quorum) {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("retention.bytes", "-1");
        props.put("cleanup.policy", "compact");
        props.put("confluent.tier.cleaner.compact.min.efficiency", Double.toString(0.1));
        this.createTopic(this.topic(), this.partitions(), 1, props, this.createTopic$default$5(), this.createTopic$default$6());
        this.produceKeyedRecords(5000);
        this.waitUntilSegmentsTieredAndCompacted();
        this.verifyOffsetMap();
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void daCompactionRunIsAbortedIfOffsetMapSizeExceedsTheLimit(String quorum) {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("retention.bytes", "-1");
        props.put("cleanup.policy", "compact");
        props.put("confluent.tier.cleaner.compact.min.efficiency", Double.toString(0.1));
        this.createTopic(this.topic(), this.partitions(), 1, props, this.createTopic$default$5(), this.createTopic$default$6());
        this.produceKeyedRecords(5000);
        this.waitUntilSegmentsTieredAndCompacted();
        Assertions.assertThrows(MemoryLimitExceededException.class, () -> this.filterOffsetMap(100L));
    }

    public static final /* synthetic */ TopicPartition $anonfun$topicPartitions$1(OffsetMapFileTest $this, int p) {
        return new TopicPartition($this.topic(), p);
    }

    public static final /* synthetic */ Tuple2 $anonfun$produceKeyedRecords$1(OffsetMapFileTest $this, Random random$1, int i) {
        return new Tuple2.mcII.sp(random$1.nextInt($this.maxNumRecords() / 10), $this.numProducedRecords() + i);
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilSegmentsTieredAndCompacted$3(TierPartitionState tierPartitionState$1, AbstractLog log$1) {
        tierPartitionState$1.flush();
        CollectionConverters$.MODULE$.IteratorHasAsScala(tierPartitionState$1.segments()).asScala().foreach((Function1 & Serializable)seg -> {
            Predef$.MODULE$.assert(!seg.metadata().hasAbortedTxns() && seg.metadata().hasEpochState() && seg.metadata().hasProducerState());
            return BoxedUnit.UNIT;
        });
        return log$1.tierableLogSegments().isEmpty() && tierPartitionState$1.compactDirtyStartOffset() > tierPartitionState$1.endOffset() && tierPartitionState$1.endOffset() == tierPartitionState$1.committedEndOffset();
    }

    public static final /* synthetic */ String $anonfun$waitUntilSegmentsTieredAndCompacted$5(AbstractLog log$1, TierPartitionState tierPartitionState$1) {
        return new StringBuilder(168).append("timeout waiting for tiered segments to be compacted.").append(" tierable segments: ").append(log$1.tierableLogSegments()).append(",").append(" local segments ").append(log$1.localLogSegments()).append(",").append(" tiered segments: ").append(CollectionConverters$.MODULE$.IteratorHasAsScala(tierPartitionState$1.segments()).asScala().toList()).append(",").append(" end offset: ").append(tierPartitionState$1.endOffset()).append(",").append(" committed end offset: ").append(tierPartitionState$1.committedEndOffset()).append(",").append(" dirty start offset: ").append(tierPartitionState$1.compactDirtyStartOffset()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$waitUntilSegmentsTieredAndCompacted$2(TopicPartition tp$1, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$1.getLog(tp$1, x$2).get();
        TierPartitionState tierPartitionState = log.tierPartitionState();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 90000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!OffsetMapFileTest.$anonfun$waitUntilSegmentsTieredAndCompacted$3(tierPartitionState, log)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)OffsetMapFileTest.$anonfun$waitUntilSegmentsTieredAndCompacted$5(log, tierPartitionState));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        CollectionConverters$.MODULE$.IteratorHasAsScala(tierPartitionState.segments()).asScala().foreach((Function1 & Serializable)seg -> {
            Predef$.MODULE$.assert(!seg.metadata().hasAbortedTxns() && seg.metadata().hasEpochState() && seg.metadata().hasProducerState());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$waitUntilSegmentsTieredAndCompacted$1(OffsetMapFileTest $this, TopicPartition tp) {
        $this.brokers().foreach((Function1 & Serializable)broker -> {
            OffsetMapFileTest.$anonfun$waitUntilSegmentsTieredAndCompacted$2(tp, broker);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$filterOffsetMap$3(KafkaBroker broker$1, MockInMemoryTierObjectStore tierObjectStore$1, Throttler throttler$1, ByteBuffer readBuffer$1, CleanedTransactionMetadata transactionMetadata$1, long offsetMapSizeLimit$1, TierLogSegment seg) {
        TierObjectStoreResponse response = ((TierObjectStore)broker$1.tierObjectStoreOpt().getOrElse((Function0 & Serializable)() -> tierObjectStore$1)).getObjectStoreFragment((ObjectStoreMetadata)seg.metadata(), FragmentType.SEGMENT);
        SortedMap map = DurabilityOffsetMapUtils$.MODULE$.filterKeysAndOffset(throttler$1, response.getInputStream(), readBuffer$1, transactionMetadata$1, seg.baseOffset(), seg.endOffset(), offsetMapSizeLimit$1);
        Predef$.MODULE$.assert(map.nonEmpty());
    }

    public static final /* synthetic */ void $anonfun$filterOffsetMap$2(TopicPartition tp$2, MockInMemoryTierObjectStore tierObjectStore$1, Throttler throttler$1, ByteBuffer readBuffer$1, long offsetMapSizeLimit$1, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        TierPartitionState tierPartitionState = ((AbstractLog)qual$1.getLog(tp$2, x$2).get()).tierPartitionState();
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        CollectionConverters$.MODULE$.IteratorHasAsScala(tierPartitionState.segments()).asScala().foreach((Function1 & Serializable)seg -> {
            OffsetMapFileTest.$anonfun$filterOffsetMap$3(broker, tierObjectStore$1, throttler$1, readBuffer$1, transactionMetadata, offsetMapSizeLimit$1, seg);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$filterOffsetMap$1(OffsetMapFileTest $this, MockInMemoryTierObjectStore tierObjectStore$1, Throttler throttler$1, ByteBuffer readBuffer$1, long offsetMapSizeLimit$1, TopicPartition tp) {
        $this.brokers().foreach((Function1 & Serializable)broker -> {
            OffsetMapFileTest.$anonfun$filterOffsetMap$2(tp, tierObjectStore$1, throttler$1, readBuffer$1, offsetMapSizeLimit$1, broker);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$verifyOffsetMap$3(OffsetMapFileTest $this, KafkaBroker broker$2, MockInMemoryTierObjectStore tierObjectStore$2, Throttler throttler$2, ByteBuffer readBuffer$2, CleanedTransactionMetadata transactionMetadata$2, SortedMap combinedMap$1, BooleanRef first$1, TierLogSegment seg) {
        TierObjectStoreResponse response = ((TierObjectStore)broker$2.tierObjectStoreOpt().getOrElse((Function0 & Serializable)() -> tierObjectStore$2)).getObjectStoreFragment((ObjectStoreMetadata)seg.metadata(), FragmentType.SEGMENT);
        SortedMap map = DurabilityOffsetMapUtils$.MODULE$.filterKeysAndOffset(throttler$2, response.getInputStream(), readBuffer$2, transactionMetadata$2, seg.baseOffset(), seg.endOffset(), DurabilityOffsetMapUtils$.MODULE$.filterKeysAndOffset$default$7());
        map.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                ByteBuffer k = (ByteBuffer)x0$1._1();
                OffsetInfo v = (OffsetInfo)x0$1._2();
                return combinedMap$1.put((Object)k, (Object)v);
            }
            throw new MatchError(null);
        });
        if (first$1.elem) {
            DurabilityOffsetMapUtils$.MODULE$.storeOffsetMapInFile((scala.collection.SortedMap)map, Paths.get(".", "mergedFile.tmp").toFile(), false);
        } else {
            DurabilityOffsetMapUtils$.MODULE$.storeOffsetMapInFile((scala.collection.SortedMap)map, Paths.get(".", "newFile.tmp").toFile(), false);
            DurabilityOffsetMapUtils$.MODULE$.mergeOffsetMapFile(new File(".", "mergedFile"), new File(".", "newFile.tmp"), new File(".", "mergedFile.tmp"));
            first$1.elem = false;
        }
        new File(".", "mergedFile").delete();
        new File(".", "mergedFile.tmp").renameTo(new File(".", "mergedFile"));
        $this.cleanupTempFiles();
    }

    public static final /* synthetic */ void $anonfun$verifyOffsetMap$2(OffsetMapFileTest $this, TopicPartition tp$3, MockInMemoryTierObjectStore tierObjectStore$2, Throttler throttler$2, ByteBuffer readBuffer$2, SortedMap combinedMap$1, BooleanRef first$1, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        TierPartitionState tierPartitionState = ((AbstractLog)qual$1.getLog(tp$3, x$2).get()).tierPartitionState();
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        CollectionConverters$.MODULE$.IteratorHasAsScala(tierPartitionState.segments()).asScala().foreach((Function1 & Serializable)seg -> {
            OffsetMapFileTest.$anonfun$verifyOffsetMap$3($this, broker, tierObjectStore$2, throttler$2, readBuffer$2, transactionMetadata, combinedMap$1, first$1, seg);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$verifyOffsetMap$1(OffsetMapFileTest $this, MockInMemoryTierObjectStore tierObjectStore$2, Throttler throttler$2, ByteBuffer readBuffer$2, SortedMap combinedMap$1, BooleanRef first$1, TopicPartition tp) {
        $this.brokers().foreach((Function1 & Serializable)broker -> {
            OffsetMapFileTest.$anonfun$verifyOffsetMap$2($this, tp, tierObjectStore$2, throttler$2, readBuffer$2, combinedMap$1, first$1, broker);
            return BoxedUnit.UNIT;
        });
    }

    public OffsetMapFileTest() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierEnableProp(), "false");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierCleanerFeatureEnableProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierCleanerEnableProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "5");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierCleanerCompactMinEfficiencyProp(), "0.001");
        this.serverConfig().put(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), "10");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFetcherMemoryPoolSizeBytesProp(), Integer.toString(0x100000));
        this.serverConfig().setProperty("confluent.durability.audit.enable", Boolean.toString(true));
        this.serverConfig().setProperty("confluent.durability.topic.replication.factor", "1");
        this.serverConfig().setProperty("confluent.durability.topic.partition.count", "1");
        this.serverConfig().setProperty("confluent.durability.audit.batch.flush.frequency.ms", "1500");
        this.serverConfig().setProperty("confluent.durability.events.allowed", "OffsetChangeType,EpochChangeType,IsrExpandType,DeleteRecordsType,RetentionChangeType,StartOffsetChangeType,DeletePartitionType,HealthCheckType");
        this.serverConfig().setProperty("confluent.durability.audit.idempotent.producer", Boolean.toString(false));
        this.configureMock();
        this.topic = "test_topic";
        this.partitions = 1;
        this.maxNumRecords = 5000;
        this.numProducedRecords = 0;
        this.producedRecords = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.exited = new AtomicBoolean(false);
    }
}

