/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.api.IntegrationTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.tier.state.TierPartitionState;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ma\u0001B\t\u0013\u0001]AQA\b\u0001\u0005\u0002}AQA\t\u0001\u0005R\rBQA\u000b\u0001\u0005\n-Bqa\f\u0001C\u0002\u0013%\u0001\u0007\u0003\u0004:\u0001\u0001\u0006I!\r\u0005\bu\u0001\u0011\r\u0011\"\u0003$\u0011\u0019Y\u0004\u0001)A\u0005I!)A\b\u0001C\u0005{!9Q\u000b\u0001b\u0001\n\u00031\u0006BB1\u0001A\u0003%q\u000bC\u0003c\u0001\u0011\u00053\rC\u0003t\u0001\u0011\u00053\u0006C\u0003y\u0001\u0011\u00051\u0006C\u0003~\u0001\u0011%a\u0010\u0003\u0004\u0002\u0010\u0001!Ia\u000b\u0005\u0007\u0003#\u0001A\u0011B\u0016\u0003KQKWM]\"p[B\f7\r^5p]\u000e{W\u000e]1di\u0012+G.\u001a;f'R\u0014Xm]:UKN$(BA\n\u0015\u0003\u0011!\u0018.\u001a:\u000b\u0003U\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00011A\u0011\u0011\u0004H\u0007\u00025)\u00111\u0004F\u0001\u0004CBL\u0017BA\u000f\u001b\u0005YIe\u000e^3he\u0006$\u0018n\u001c8UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001!!\t\t\u0003!D\u0001\u0013\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0016\u0003\u0011\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u00121!\u00138u\u00035\u0019wN\u001c4jOV\u0014X-T8dWR\tA\u0006\u0005\u0002&[%\u0011aF\n\u0002\u0005+:LG/A\u0003u_BL7-F\u00012!\t\u0011t'D\u00014\u0015\t!T'\u0001\u0003mC:<'\"\u0001\u001c\u0002\t)\fg/Y\u0005\u0003qM\u0012aa\u0015;sS:<\u0017A\u0002;pa&\u001c\u0007%\u0001\u0006qCJ$\u0018\u000e^5p]N\f1\u0002]1si&$\u0018n\u001c8tA\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t7/F\u0001?!\rytI\u0013\b\u0003\u0001\u0016s!!\u0011#\u000e\u0003\tS!a\u0011\f\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0013B\u0001$'\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001S%\u0003\u0007M+\u0017O\u0003\u0002GMA\u00111jU\u0007\u0002\u0019*\u0011QJT\u0001\u0007G>lWn\u001c8\u000b\u0005Uy%B\u0001)R\u0003\u0019\t\u0007/Y2iK*\t!+A\u0002pe\u001eL!\u0001\u0016'\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u00061Q\r_5uK\u0012,\u0012a\u0016\t\u00031~k\u0011!\u0017\u0006\u00035n\u000ba!\u0019;p[&\u001c'B\u0001/^\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003=V\nA!\u001e;jY&\u0011\u0001-\u0017\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002\u000f\u0015D\u0018\u000e^3eA\u0005)1/\u001a;VaR\u0011A\u0006\u001a\u0005\u0006K.\u0001\rAZ\u0001\ti\u0016\u001cH/\u00138g_B\u0011q-\\\u0007\u0002Q*\u00111$\u001b\u0006\u0003U.\fqA[;qSR,'O\u0003\u0002m#\u0006)!.\u001e8ji&\u0011a\u000e\u001b\u0002\t)\u0016\u001cH/\u00138g_\"\u00121\u0002\u001d\t\u0003OFL!A\u001d5\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\taQ\u000f\u0005\u0002hm&\u0011q\u000f\u001b\u0002\n\u0003\u001a$XM]#bG\"\fq\u0003^3tiN#(/Z:t\u0007>l\u0007/Y2u\t\u0016dW\r^3)\u00055Q\bCA4|\u0013\ta\bN\u0001\u0003UKN$\u0018a\u00059s_\u0012,8-Z&fs\u0016$'+Z2pe\u0012\u001cHC\u0001\u0017\u0000\u0011\u001d\t\tA\u0004a\u0001\u0003\u0007\t\u0011b[3z-\u0006dW/Z:\u0011\u000b}\n)!!\u0003\n\u0007\u0005\u001d\u0011J\u0001\u0003MSN$\b#B\u0013\u0002\f\u0011\"\u0013bAA\u0007M\t1A+\u001e9mKJ\n1e^1jiVsG/\u001b7TK\u001elWM\u001c;t)&,'/\u001a3B]\u0012\u001cu.\u001c9bGR,G-\u0001\bwC2LG-\u0019;f\u000bJ\u0014xN]:")
public class TierCompactionCompactDeleteStressTest
extends IntegrationTestHarness {
    private final String topic;
    private final int partitions;
    private final AtomicBoolean exited;

    @Override
    public int brokerCount() {
        return 3;
    }

    private void configureMock() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), "mybucket");
    }

    private String topic() {
        return this.topic;
    }

    private int partitions() {
        return this.partitions;
    }

    private Seq<TopicPartition> topicPartitions() {
        return package$.MODULE$.Range().apply(0, this.partitions()).map((Function1 & Serializable)p -> TierCompactionCompactDeleteStressTest.$anonfun$topicPartitions$1(this, BoxesRunTime.unboxToInt((Object)p)));
    }

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        Exit.setExitProcedure((x$1, x$2) -> this.exited().set(true));
        super.setUp(testInfo);
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        Assertions.assertFalse((boolean)this.exited().get());
    }

    @Test
    public void testStressCompactDelete() {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "30000");
        props.put("confluent.tier.local.hotset.bytes", "0");
        props.put("retention.bytes", "50000");
        props.put("cleanup.policy", "compact,delete");
        props.put("confluent.tier.cleaner.enable", "true");
        props.put("confluent.tier.cleaner.compact.min.efficiency", Double.toString(1.0E-4));
        this.createTopic(this.topic(), this.partitions(), 3, props, this.createTopic$default$5(), this.createTopic$default$6());
        int nRecords = 100000;
        Random random = new Random();
        List kvs = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), nRecords).toList().map((Function1 & Serializable)i -> TierCompactionCompactDeleteStressTest.$anonfun$testStressCompactDelete$1(random, nRecords, BoxesRunTime.unboxToInt((Object)i)));
        this.produceKeyedRecords((List<Tuple2<Object, Object>>)kvs);
        this.waitUntilSegmentsTieredAndCompacted();
        this.validateErrors();
    }

    private void produceKeyedRecords(List<Tuple2<Object, Object>> keyValues) {
        try (KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());){
            keyValues.grouped(10).foreach((Function1 & Serializable)group -> group.map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    int k = x0$1._1$mcI$sp();
                    int v = x0$1._2$mcI$sp();
                    long timestamp = System.currentTimeMillis();
                    return new ProducerRecord(this.topic(), null, Predef$.MODULE$.long2Long(timestamp), (Object)Integer.toString(k).getBytes(StandardCharsets.UTF_8), (Object)Integer.toString(v).getBytes(StandardCharsets.UTF_8));
                }
                throw new MatchError(null);
            }).map((Function1 & Serializable)x$1 -> producer.send(x$1)).map((Function1 & Serializable)x$3 -> (RecordMetadata)x$3.get(10L, TimeUnit.SECONDS)));
        }
    }

    private void waitUntilSegmentsTieredAndCompacted() {
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            TierCompactionCompactDeleteStressTest.$anonfun$waitUntilSegmentsTieredAndCompacted$1(this, tp);
            return BoxedUnit.UNIT;
        });
    }

    private void validateErrors() {
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            TierCompactionCompactDeleteStressTest.$anonfun$validateErrors$1(this, tp);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ TopicPartition $anonfun$topicPartitions$1(TierCompactionCompactDeleteStressTest $this, int p) {
        return new TopicPartition($this.topic(), p);
    }

    public static final /* synthetic */ Tuple2 $anonfun$testStressCompactDelete$1(Random random$1, int nRecords$1, int i) {
        return new Tuple2.mcII.sp(random$1.nextInt(nRecords$1 / 10), i);
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilSegmentsTieredAndCompacted$3(TierPartitionState tierPartitionState$1, AbstractLog log$1) {
        tierPartitionState$1.flush();
        CollectionConverters$.MODULE$.IteratorHasAsScala(tierPartitionState$1.segments()).asScala().foreach((Function1 & Serializable)seg -> {
            Predef$.MODULE$.assert(!seg.metadata().hasAbortedTxns() && seg.metadata().hasEpochState() && seg.metadata().hasProducerState());
            return BoxedUnit.UNIT;
        });
        Assertions.assertFalse((boolean)tierPartitionState$1.status().hasError());
        return log$1.tierableLogSegments().isEmpty() && log$1.localLogSegments().size() == 1 && tierPartitionState$1.compactDirtyStartOffset() > tierPartitionState$1.endOffset() && tierPartitionState$1.endOffset() == tierPartitionState$1.committedEndOffset();
    }

    public static final /* synthetic */ String $anonfun$waitUntilSegmentsTieredAndCompacted$5(AbstractLog log$1, TierPartitionState tierPartitionState$1) {
        return new StringBuilder(185).append("timeout waiting for tier partition state to contain a single segment.").append(" tierable segments: ").append(log$1.tierableLogSegments()).append(",").append(" local segments ").append(log$1.localLogSegments()).append(",").append(" tiered segments: ").append(CollectionConverters$.MODULE$.IteratorHasAsScala(tierPartitionState$1.segments()).asScala().toList()).append(",").append(" end offset: ").append(tierPartitionState$1.endOffset()).append(",").append(" committed end offset: ").append(tierPartitionState$1.committedEndOffset()).append(",").append(" dirty start offset: ").append(tierPartitionState$1.compactDirtyStartOffset()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$waitUntilSegmentsTieredAndCompacted$2(TopicPartition tp$1, KafkaServer server) {
        LogManager qual$1 = server.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$1.getLog(tp$1, x$2).get();
        TierPartitionState tierPartitionState = log.tierPartitionState();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 90000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierCompactionCompactDeleteStressTest.$anonfun$waitUntilSegmentsTieredAndCompacted$3(tierPartitionState, log)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierCompactionCompactDeleteStressTest.$anonfun$waitUntilSegmentsTieredAndCompacted$5(log, tierPartitionState));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        CollectionConverters$.MODULE$.IteratorHasAsScala(tierPartitionState.segments()).asScala().foreach((Function1 & Serializable)seg -> {
            Predef$.MODULE$.assert(!seg.metadata().hasAbortedTxns() && seg.metadata().hasEpochState() && seg.metadata().hasProducerState());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$waitUntilSegmentsTieredAndCompacted$1(TierCompactionCompactDeleteStressTest $this, TopicPartition tp) {
        $this.servers().foreach((Function1 & Serializable)server -> {
            TierCompactionCompactDeleteStressTest.$anonfun$waitUntilSegmentsTieredAndCompacted$2(tp, server);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$validateErrors$2(TopicPartition tp$2, KafkaServer server) {
        LogManager qual$1 = server.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Assertions.assertFalse((boolean)((AbstractLog)qual$1.getLog(tp$2, x$2).get()).tierPartitionState().status().hasError());
    }

    public static final /* synthetic */ int $anonfun$validateErrors$3(Attribute attr) {
        return BoxesRunTime.unboxToInt((Object)attr.getValue());
    }

    public static final /* synthetic */ double $anonfun$validateErrors$4(Attribute attr) {
        return BoxesRunTime.unboxToDouble((Object)attr.getValue());
    }

    public static final /* synthetic */ double $anonfun$validateErrors$5(Attribute attr) {
        return BoxesRunTime.unboxToDouble((Object)attr.getValue());
    }

    public static final /* synthetic */ void $anonfun$validateErrors$1(TierCompactionCompactDeleteStressTest $this, TopicPartition tp) {
        $this.servers().foreach((Function1 & Serializable)server -> {
            TierCompactionCompactDeleteStressTest.$anonfun$validateErrors$2(tp, server);
            return BoxedUnit.UNIT;
        });
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        int partitionsTaskInError = BoxesRunTime.unboxToInt((Object)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(mBeanServer.getAttributes(new ObjectName("kafka.tier.tasks:type=TierTasks,name=NumPartitionsInError"), new String[]{"Value"}).asList()).asScala().map((Function1 & Serializable)attr -> BoxesRunTime.boxToInteger((int)TierCompactionCompactDeleteStressTest.$anonfun$validateErrors$3(attr)))).head());
        Assertions.assertEquals((int)0, (int)partitionsTaskInError, (String)"task shows no partitions in error state");
        Assertions.assertTrue((BoxesRunTime.unboxToDouble((Object)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(mBeanServer.getAttributes(new ObjectName("kafka.log:type=CleanerStats,name=CompactionThroughputBytesPerSec,op=read,form=tier"), new String[]{"MeanRate"}).asList()).asScala().map((Function1 & Serializable)attr -> BoxesRunTime.boxToDouble((double)TierCompactionCompactDeleteStressTest.$anonfun$validateErrors$4(attr)))).head()) > 0.0 ? 1 : 0) != 0, (String)"Compaction read throughput should be > 0");
        Assertions.assertTrue((BoxesRunTime.unboxToDouble((Object)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(mBeanServer.getAttributes(new ObjectName("kafka.log:type=CleanerStats,name=CompactionThroughputBytesPerSec,op=write,form=tier"), new String[]{"MeanRate"}).asList()).asScala().map((Function1 & Serializable)attr -> BoxesRunTime.boxToDouble((double)TierCompactionCompactDeleteStressTest.$anonfun$validateErrors$5(attr)))).head()) > 0.0 ? 1 : 0) != 0, (String)"Compaction write throughput should be > 0");
    }

    public TierCompactionCompactDeleteStressTest() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierEnableProp(), "false");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierCleanerFeatureEnableProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "3");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "3");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "5");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierCleanerCompactMinEfficiencyProp(), "0.001");
        this.serverConfig().put(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), "10");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFetcherMemoryPoolSizeBytesProp(), Integer.toString(0x100000));
        this.configureMock();
        this.topic = "test_topic";
        this.partitions = 1;
        this.exited = new AtomicBoolean(false);
    }
}

