/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metric;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.api.IntegrationTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.MergedLog;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.tier.state.TierPartitionState;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@Tag(value="bazel:shard_count:8")
@ScalaSignature(bytes="\u0006\u0005\t}h\u0001\u0002\u0017.\u0001IBQ!\u000f\u0001\u0005\u0002iBQ!\u0010\u0001\u0005RyBQ!\u0012\u0001\u0005\n\u0019CqA\u0013\u0001C\u0002\u0013%1\n\u0003\u0004U\u0001\u0001\u0006I\u0001\u0014\u0005\b+\u0002\u0011\r\u0011\"\u0003?\u0011\u00191\u0006\u0001)A\u0005\u007f!9q\u000b\u0001a\u0001\n\u0013A\u0006bB1\u0001\u0001\u0004%IA\u0019\u0005\u0007K\u0002\u0001\u000b\u0015B-\t\u000f\u0019\u0004!\u0019!C\u0005}!1q\r\u0001Q\u0001\n}Bq\u0001\u001b\u0001A\u0002\u0013%a\bC\u0004j\u0001\u0001\u0007I\u0011\u00026\t\r1\u0004\u0001\u0015)\u0003@\u0011\u001di\u0007A1A\u0005\n9Da\u0001\u001e\u0001!\u0002\u0013y\u0007\"B;\u0001\t\u00131\b\"CA\u000f\u0001\t\u0007I\u0011AA\u0010\u0011!\t)\u0004\u0001Q\u0001\n\u0005\u0005\u0002bBA\u001c\u0001\u0011\u0005\u0013\u0011\b\u0005\u0007\u00033\u0002A\u0011\t$\t\u000f\u0005\r\u0004\u0001\"\u0001\u0002f!9\u0011q\u0015\u0001\u0005\u0002\u0005%\u0006bBAZ\u0001\u0011\u0005\u0011Q\u0017\u0005\b\u0003\u007f\u0003A\u0011AAa\u0011\u001d\tY\r\u0001C\u0001\u0003\u001bDq!a6\u0001\t\u0003\tI\u000eC\u0004\u0002d\u0002!I!!:\t\u000f\t]\u0001\u0001\"\u0003\u0003\u001a!9!q\u0003\u0001\u0005\n\t}\u0001b\u0002B\u0019\u0001\u0011%!1\u0007\u0005\b\u0005\u0003\u0002A\u0011\u0002B\"\u0011\u0019\u0011)\u0007\u0001C\u0005\r\"1!q\r\u0001\u0005\n\u0019CaA!\u001b\u0001\t\u00131\u0005B\u0002B6\u0001\u0011%a\tC\u0004\u0003n\u0001!IAa\u001c\t\u000f\t\u001d\u0005\u0001\"\u0003\u0003\n\"I!Q\u0013\u0001\u0012\u0002\u0013%!q\u0013\u0005\b\u0005\u000f\u0003A\u0011\u0002BW\u0011\u001d\u0011)\f\u0001C\u0005\u0005oCqAa6\u0001\t\u0013\u0011IN\u0001\u000eUS\u0016\u00148i\\7qC\u000e$\u0018n\u001c8F]\u0012$v.\u00128e)\u0016\u001cHO\u0003\u0002/_\u0005!A/[3s\u0015\u0005\u0001\u0014!B6bM.\f7\u0001A\n\u0003\u0001M\u0002\"\u0001N\u001c\u000e\u0003UR!AN\u0018\u0002\u0007\u0005\u0004\u0018.\u0003\u00029k\t1\u0012J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002wA\u0011A\bA\u0007\u0002[\u0005Y!M]8lKJ\u001cu.\u001e8u+\u0005y\u0004C\u0001!D\u001b\u0005\t%\"\u0001\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\u000b%aA%oi\u0006i1m\u001c8gS\u001e,(/Z'pG.$\u0012a\u0012\t\u0003\u0001\"K!!S!\u0003\tUs\u0017\u000e^\u0001\u0006i>\u0004\u0018nY\u000b\u0002\u0019B\u0011QJU\u0007\u0002\u001d*\u0011q\nU\u0001\u0005Y\u0006twMC\u0001R\u0003\u0011Q\u0017M^1\n\u0005Ms%AB*ue&tw-\u0001\u0004u_BL7\rI\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\u0018a\u00039beRLG/[8og\u0002\n\u0001\u0003]1si&$\u0018n\u001c8MK\u0006$WM]:\u0016\u0003e\u0003BAW0@\u007f5\t1L\u0003\u0002];\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003=\u0006\u000b!bY8mY\u0016\u001cG/[8o\u0013\t\u00017LA\u0002NCB\fA\u0003]1si&$\u0018n\u001c8MK\u0006$WM]:`I\u0015\fHCA$d\u0011\u001d!\u0017\"!AA\u0002e\u000b1\u0001\u001f\u00132\u0003E\u0001\u0018M\u001d;ji&|g\u000eT3bI\u0016\u00148\u000fI\u0001\u000e[\u0006Dh*^7SK\u000e|'\u000fZ:\u0002\u001d5\f\u0007PT;n%\u0016\u001cwN\u001d3tA\u0005\u0011b.^7Qe>$WoY3e%\u0016\u001cwN\u001d3t\u0003YqW/\u001c)s_\u0012,8-\u001a3SK\u000e|'\u000fZ:`I\u0015\fHCA$l\u0011\u001d!g\"!AA\u0002}\n1C\\;n!J|G-^2fIJ+7m\u001c:eg\u0002\nq\u0002\u001d:pIV\u001cW\r\u001a*fG>\u0014Hm]\u000b\u0002_B!\u0001o] @\u001b\u0005\t(B\u0001:^\u0003\u001diW\u000f^1cY\u0016L!\u0001Y9\u0002!A\u0014x\u000eZ;dK\u0012\u0014VmY8sIN\u0004\u0013a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0016\u0003]\u0004R\u0001_A\u0001\u0003\u000fq!!\u001f@\u000f\u0005ilX\"A>\u000b\u0005q\f\u0014A\u0002\u001fs_>$h(C\u0001C\u0013\ty\u0018)A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\r\u0011Q\u0001\u0002\u0004'\u0016\f(BA@B!\u0011\tI!!\u0007\u000e\u0005\u0005-!\u0002BA\u0007\u0003\u001f\taaY8n[>t'b\u0001\u0019\u0002\u0012)!\u00111CA\u000b\u0003\u0019\t\u0007/Y2iK*\u0011\u0011qC\u0001\u0004_J<\u0017\u0002BA\u000e\u0003\u0017\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\u0004fq&$X\rZ\u000b\u0003\u0003C\u0001B!a\t\u000225\u0011\u0011Q\u0005\u0006\u0005\u0003O\tI#\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0003W\ti#\u0001\u0006d_:\u001cWO\u001d:f]RT1!a\fQ\u0003\u0011)H/\u001b7\n\t\u0005M\u0012Q\u0005\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002\u000f\u0015D\u0018\u000e^3eA\u0005)1/\u001a;VaR\u0019q)a\u000f\t\u000f\u0005uR\u00031\u0001\u0002@\u0005AA/Z:u\u0013:4w\u000e\u0005\u0003\u0002B\u00055SBAA\"\u0015\r1\u0014Q\t\u0006\u0005\u0003\u000f\nI%A\u0004kkBLG/\u001a:\u000b\t\u0005-\u0013QC\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003\u001f\n\u0019E\u0001\u0005UKN$\u0018J\u001c4pQ\r)\u00121\u000b\t\u0005\u0003\u0003\n)&\u0003\u0003\u0002X\u0005\r#A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eK\u0002\u0017\u0003;\u0002B!!\u0011\u0002`%!\u0011\u0011MA\"\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u0010uKN$\u0018I]2iSZ,7i\\7qC\u000e$\u0018I\u001c3US\u0016\u0014h)\u001a;dQR\u0019q)a\u001a\t\u000f\u0005%t\u00031\u0001\u0002l\u00051\u0011/^8sk6\u0004B!!\u001c\u0002v9!\u0011qNA9!\tQ\u0018)C\u0002\u0002t\u0005\u000ba\u0001\u0015:fI\u00164\u0017bA*\u0002x)\u0019\u00111O!)\u000f]\tY(a\"\u0002\nB!\u0011QPAB\u001b\t\tyH\u0003\u0003\u0002\u0002\u0006\u0015\u0013A\u00029be\u0006l7/\u0003\u0003\u0002\u0006\u0006}$!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\t\tY)\u0001\u0012|I&\u001c\b\u000f\\1z\u001d\u0006lW- \u0018|CJ<W/\\3oiN<\u0016\u000e\u001e5OC6,7/ \u0015\b/\u0005=\u00151TAO!\u0011\t\t*a&\u000e\u0005\u0005M%\u0002BAK\u0003\u007f\n\u0001\u0002\u001d:pm&$WM]\u0005\u0005\u00033\u000b\u0019JA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0005\u0003?\u000b\u0019+\t\u0002\u0002\"\u0006\u0011!p[\u0011\u0003\u0003K\u000bQa\u001b:bMR\fQ\u0005^3ti\u0012+G.\u001a;f\u0007>l\u0007/Y2uK\u0012\u001cVmZ7f]R\u001chI]8n\u0011>$8/\u001a;\u0015\u0007\u001d\u000bY\u000bC\u0004\u0002ja\u0001\r!a\u001b)\u000fa\tY(a\"\u0002\n\":\u0001$a$\u0002\u001c\u0006EF\u0006BAP\u0003G\u000bA\u0004^3ti6+GO]5dg:{G/Q2rk&\u0014X\rT8h\u0019>\u001c7\u000eF\u0002H\u0003oCq!!\u001b\u001a\u0001\u0004\tY\u0007K\u0004\u001a\u0003w\n9)!#)\u000fe\ty)a'\u0002>2\"\u0011qTAR\u0003Q\"Xm\u001d;D_:\u001cWO\u001d:f]RdunY1m\u0003:$G+[3s\u0007>l\u0007/Y2uS>tWI\\1cY\u0016\fe\u000e\u001a#jg\u0006\u0014G.\u001a\u000b\u0004\u000f\u0006\r\u0007bBA55\u0001\u0007\u00111\u000e\u0015\b5\u0005m\u0014qQAEQ\u001dQ\u0012qRAN\u0003\u0013dC!a(\u0002$\u00069D/Z:u\u0007>t7-\u001e:sK:$Hj\\2bY\u0006sG\rV5fe\u000e{W\u000e]1di&|gnV5uQB\u0013XMZ3s)&,'OR3uG\"$2aRAh\u0011\u001d\tIg\u0007a\u0001\u0003WBsaGA>\u0003\u000f\u000bI\tK\u0004\u001c\u0003\u001f\u000bY*!6-\t\u0005}\u00151U\u0001;i\u0016\u001cHoQ8oGV\u0014(/\u001a8u\u0019>\u001c\u0017\r\\!oIRKWM]\"p[B\f7\r^5p]\u0012K7/\u00192mK2{7-\u00197D_6\u0004\u0018m\u0019;j_:$2aRAn\u0011\u001d\tI\u0007\ba\u0001\u0003WBs\u0001HA>\u0003\u000f\u000bI\tK\u0004\u001d\u0003\u001f\u000bY*!9-\t\u0005}\u00151U\u0001$m\u0016\u0014\u0018NZ=NKR\u0014\u0018nY:DC2d'-Y2l\u001d>$xI]1c\u0019><Gj\\2l)-9\u0015q]Av\u0003{\u00149Aa\u0005\t\r\u0005%X\u00041\u0001@\u0003!awnZ%oI\u0016D\bbBAw;\u0001\u0007\u0011q^\u0001\u0005Y><7\u000fE\u0003y\u0003\u0003\t\t\u0010\u0005\u0003\u0002t\u0006eXBAA{\u0015\r\t9pL\u0001\u0004Y><\u0017\u0002BA~\u0003k\u00141\"\u00112tiJ\f7\r\u001e'pO\"9\u0011q`\u000fA\u0002\t\u0005\u0011A\u00032h)\"\u0014X-\u00193J\tB!\u00111\u0005B\u0002\u0013\u0011\u0011)!!\n\u0003\u0015\u0005#x.\\5d\u0019>tw\rC\u0004\u0003\nu\u0001\rAa\u0003\u0002\u000b1\fGo\u00195\u0011\t\t5!qB\u0007\u0003\u0003SIAA!\u0005\u0002*\tq1i\\;oi\u0012{wO\u001c'bi\u000eD\u0007b\u0002B\u000b;\u0001\u0007\u0011\u0011E\u0001\u0017[\u0016$(/[2t\u0007>l\u0007/\u001e;f\u0007>l\u0007\u000f\\3uK\u0006\u0019\u0002O]8ek\u000e,7*Z=fIJ+7m\u001c:egR\u0019qIa\u0007\t\r\tua\u00041\u0001@\u0003)qW/\u001c*fG>\u0014Hm\u001d\u000b\u0004\u000f\n\u0005\u0002b\u0002B\u0012?\u0001\u0007!QE\u0001\nW\u0016Lh+\u00197vKN\u0004R\u0001\u001fB\u0014\u0005WIAA!\u000b\u0002\u0006\t!A*[:u!\u0015\u0001%QF @\u0013\r\u0011y#\u0011\u0002\u0007)V\u0004H.\u001a\u001a\u0002/\r|gNZ5hkJ,G)^1m\u0007>l\u0007/Y2uS>tGcA$\u00036!9!q\u0007\u0011A\u0002\te\u0012!\u00029s_B\u001c\b\u0003\u0002B\u001e\u0005{i!!!\f\n\t\t}\u0012Q\u0006\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018\u0001E1mi\u0016\u0014Hk\u001c9jG\u000e{gNZ5h)\u0011\u0011)E!\u0016\u0011\t\t\u001d#\u0011K\u0007\u0003\u0005\u0013RAAa\u0013\u0003N\u0005)\u0011\rZ7j]*!!qJA\b\u0003\u001d\u0019G.[3oiNLAAa\u0015\u0003J\t\u0011\u0012\t\u001c;fe\u000e{gNZ5hgJ+7/\u001e7u\u0011\u001d\u00119&\ta\u0001\u00053\nQbY8oM&<WI\u001c;sS\u0016\u001c\bC\u0002B\u001e\u00057\u0012y&\u0003\u0003\u0003^\u00055\"!C!se\u0006LH*[:u!\u0011\u00119E!\u0019\n\t\t\r$\u0011\n\u0002\u000e\u00032$XM]\"p]\u001aLwm\u00149\u0002G]\f\u0017\u000e^+oi&d7+Z4nK:$8\u000fV5fe\u0016$\u0017I\u001c3D_6\u0004\u0018m\u0019;fI\u0006\ts/Y5u+:$\u0018\u000e\\*fO6,g\u000e^:M_\u000e\fG\u000e\\=D_6\u0004\u0018m\u0019;fI\u0006)s/Y5u+:$\u0018\u000e\\!mYN+w-\\3oiN$U\r\\3uK\u00124%o\\7I_R\u001cX\r^\u00012o\u0006LG/\u00168uS2\u001cVmZ7f]R\u001cHj\\2bY2L8i\\7qC\u000e$X\rZ!oIRKWM]\"p[B\f7\r^3e\u000311\u0018\r\\5eCR,Gj\\4t)\r9%\u0011\u000f\u0005\b\u0005g2\u0003\u0019\u0001B;\u0003%1\u0018\r\\5eCR|'\u000f\u0005\u0005A\u0005o\u0012Y(!=H\u0013\r\u0011I(\u0011\u0002\n\rVt7\r^5p]J\u0002BA! \u0003\u00046\u0011!q\u0010\u0006\u0004\u0005\u0003{\u0013AB:feZ,'/\u0003\u0003\u0003\u0006\n}$aC&bM.\f'I]8lKJ\f1dY8ogVlW-\u00118e-\u0006d\u0017\u000eZ1uKRKWM\u001d$fi\u000eDGcA$\u0003\f\"I!QR\u0014\u0011\u0002\u0003\u0007!qR\u0001\u0011SN$U/\u00197D_6\u0004\u0018m\u0019;j_:\u00042\u0001\u0011BI\u0013\r\u0011\u0019*\u0011\u0002\b\u0005>|G.Z1o\u0003\u0015\u001awN\\:v[\u0016\fe\u000e\u001a,bY&$\u0017\r^3US\u0016\u0014h)\u001a;dQ\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003\u001a*\"!q\u0012BNW\t\u0011i\n\u0005\u0003\u0003 \n%VB\u0001BQ\u0015\u0011\u0011\u0019K!*\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BT\u0003\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t-&\u0011\u0015\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,G#B$\u00030\nM\u0006B\u0002BYS\u0001\u0007q.A\u0006lmN,\u0005\u0010]3di\u0016$\u0007b\u0002BGS\u0001\u0007!qR\u0001\u0012O\u0016$XJQ3b]\u0006#HO]5ckR,W\u0003\u0002B]\u0005\u007f#bAa/\u0003R\nM\u0007\u0003\u0002B_\u0005\u007fc\u0001\u0001B\u0004\u0003B*\u0012\rAa1\u0003\u0003Q\u000bBA!2\u0003LB\u0019\u0001Ia2\n\u0007\t%\u0017IA\u0004O_RD\u0017N\\4\u0011\u0007\u0001\u0013i-C\u0002\u0003P\u0006\u00131!\u00118z\u0011\u001d\t9I\u000ba\u0001\u0003WBqA!6+\u0001\u0004\tY'A\u0005biR\u0014\u0018NY;uK\u0006\tr-\u001a;NKR\u0014\u0018nY(o\u0019\u0016\fG-\u001a:\u0015\t\tm'q\u001d\t\u0005\u0005;\u0014\u0019/\u0004\u0002\u0003`*!!\u0011]A\u0006\u0003\u001diW\r\u001e:jGNLAA!:\u0003`\nY1*\u00194lC6+GO]5d\u0011\u001d\u0011Io\u000ba\u0001\u0005W\f!\"\\3ue&\u001cg*Y7f!\u0011\tIA!<\n\t\t=\u00181\u0002\u0002\u000b\u001b\u0016$(/[2OC6,\u0007f\u0002\u0001\u0003t\ne(1 \t\u0005\u0003\u0003\u0012)0\u0003\u0003\u0003x\u0006\r#a\u0001+bO\u0006)a/\u00197vK\u0006\u0012!Q`\u0001\u0014E\u0006TX\r\u001c\u001etQ\u0006\u0014HmX2pk:$(\b\u000f")
public class TierCompactionEndToEndTest
extends IntegrationTestHarness {
    private final String topic;
    private final int partitions;
    private Map<Object, Object> partitionLeaders;
    private final int maxNumRecords;
    private int numProducedRecords;
    private final scala.collection.mutable.Map<Object, Object> producedRecords;
    private final AtomicBoolean exited;

    @Override
    public int brokerCount() {
        return 3;
    }

    private void configureMock() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), "mybucket");
    }

    private String topic() {
        return this.topic;
    }

    private int partitions() {
        return this.partitions;
    }

    private Map<Object, Object> partitionLeaders() {
        return this.partitionLeaders;
    }

    private void partitionLeaders_$eq(Map<Object, Object> x$1) {
        this.partitionLeaders = x$1;
    }

    private int maxNumRecords() {
        return this.maxNumRecords;
    }

    private int numProducedRecords() {
        return this.numProducedRecords;
    }

    private void numProducedRecords_$eq(int x$1) {
        this.numProducedRecords = x$1;
    }

    private scala.collection.mutable.Map<Object, Object> producedRecords() {
        return this.producedRecords;
    }

    private Seq<TopicPartition> topicPartitions() {
        return package$.MODULE$.Range().apply(0, this.partitions()).map((Function1 & Serializable)p -> TierCompactionEndToEndTest.$anonfun$topicPartitions$1(this, BoxesRunTime.unboxToInt((Object)p)));
    }

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        Exit.setExitProcedure((x$1, x$2) -> this.exited().set(true));
        super.setUp(testInfo);
        this.numProducedRecords_$eq(0);
        this.producedRecords().clear();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        this.numProducedRecords_$eq(0);
        this.producedRecords().clear();
        Assertions.assertFalse((boolean)this.exited().get());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testArchiveCompactAndTierFetch(String quorum) {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("retention.bytes", "-1");
        props.put("cleanup.policy", "compact");
        props.put("confluent.tier.cleaner.compact.min.efficiency", Double.toString(0.1));
        this.partitionLeaders_$eq(this.createTopic(this.topic(), this.partitions(), 3, props, this.createTopic$default$5(), this.createTopic$default$6()));
        this.produceKeyedRecords(5000);
        this.waitUntilSegmentsTieredAndCompacted();
        this.waitUntilAllSegmentsDeletedFromHotset();
        this.consumeAndValidateTierFetch(false);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteCompactedSegmentsFromHotset(String quorum) {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("retention.bytes", "-1");
        props.put("cleanup.policy", "compact");
        props.put("confluent.tier.local.hotset.bytes", "-1");
        props.put("confluent.tier.local.hotset.ms", "86400000");
        props.put("confluent.tier.cleaner.compact.min.efficiency", Double.toString(0.1));
        this.partitionLeaders_$eq(this.createTopic(this.topic(), this.partitions(), 3, props, this.createTopic$default$5(), this.createTopic$default$6()));
        this.produceKeyedRecords(5000);
        this.waitUntilSegmentsTieredAndCompacted();
        this.waitUntilAllSegmentsDeletedFromHotset();
        this.consumeAndValidateTierFetch(false);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testMetricsNotAcquireLogLock(String quorum) {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("retention.bytes", "-1");
        props.put("cleanup.policy", "compact,delete");
        props.put("confluent.tier.cleaner.compact.min.efficiency", Double.toString(0.1));
        this.partitionLeaders_$eq(this.createTopic(this.topic(), this.partitions(), 3, props, this.createTopic$default$5(), this.createTopic$default$6()));
        this.produceKeyedRecords(5000);
        this.waitUntilSegmentsTieredAndCompacted();
        this.waitUntilAllSegmentsDeletedFromHotset();
        Seq logs = (Seq)this.brokers().toSeq().flatMap((Function1 & Serializable)broker -> broker.logManager().allLogs());
        CountDownLatch latch = new CountDownLatch(1);
        AtomicBoolean metricsComputeComplete = new AtomicBoolean(false);
        AtomicLong bgThreadID = new AtomicLong(-1L);
        Runnable computeMetrics = () -> {
            bgThreadID.set(Thread.currentThread().getId());
            latch.await();
            CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)TierCompactionEndToEndTest.$anonfun$testMetricsNotAcquireLogLock$3(check$ifrefutable$1))).foreach((Function1 & Serializable)x$3 -> {
                Metric gauge;
                if (x$3 != null && (gauge = (Metric)x$3._2()) instanceof Gauge) {
                    return ((Gauge)gauge).value();
                }
                throw new MatchError(x$3);
            });
            metricsComputeComplete.set(true);
        };
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<?> future = executor.submit(computeMetrics);
            this.verifyMetricsCallbackNotGrabLogLock(0, (Seq<AbstractLog>)logs, bgThreadID, latch, metricsComputeComplete);
            future.get();
        }
        finally {
            executor.shutdownNow();
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testConcurrentLocalAndTierCompactionEnableAndDisable(String quorum) {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("confluent.tier.cleaner.enable", "false");
        props.put("segment.bytes", "10000");
        props.put("retention.bytes", "-1");
        props.put("cleanup.policy", "compact");
        this.partitionLeaders_$eq(this.createTopic(this.topic(), this.partitions(), 3, props, this.createTopic$default$5(), this.createTopic$default$6()));
        this.produceKeyedRecords(5000);
        Function2 & Serializable validateLogs_validator = (Function2 & Serializable)(x$4, log) -> {
            TierCompactionEndToEndTest.$anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$1(x$4, log);
            return BoxedUnit.UNIT;
        };
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            TierCompactionEndToEndTest.$anonfun$validateLogs$1(this, validateLogs_validator, tp);
            return BoxedUnit.UNIT;
        });
        Object var6_3 = null;
        this.waitUntilSegmentsLocallyCompacted();
        ArrayList<AlterConfigOp> newConfigs1 = new ArrayList<AlterConfigOp>();
        newConfigs1.add(new AlterConfigOp(new ConfigEntry("confluent.tier.cleaner.enable", "true"), AlterConfigOp.OpType.SET));
        newConfigs1.add(new AlterConfigOp(new ConfigEntry("confluent.tier.cleaner.dual.compaction", "true"), AlterConfigOp.OpType.SET));
        newConfigs1.add(new AlterConfigOp(new ConfigEntry("min.cleanable.dirty.ratio", Double.toString(0.1)), AlterConfigOp.OpType.SET));
        newConfigs1.add(new AlterConfigOp(new ConfigEntry("confluent.tier.cleaner.min.cleanable.ratio", Double.toString(0.1)), AlterConfigOp.OpType.SET));
        this.alterTopicConfig(newConfigs1);
        Function2 & Serializable validateLogs_validator2 = (Function2 & Serializable)(x$5, log) -> {
            TierCompactionEndToEndTest.$anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$2(x$5, log);
            return BoxedUnit.UNIT;
        };
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            TierCompactionEndToEndTest.$anonfun$validateLogs$1(this, validateLogs_validator, tp);
            return BoxedUnit.UNIT;
        });
        Object var7_5 = null;
        Function2 & Serializable validateLogs_validator3 = (Function2 & Serializable)(x$6, log) -> {
            log.isTierCompactable();
            return BoxedUnit.UNIT;
        };
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            TierCompactionEndToEndTest.$anonfun$validateLogs$1(this, validateLogs_validator, tp);
            return BoxedUnit.UNIT;
        });
        Object var8_6 = null;
        Function2 & Serializable validateLogs_validator4 = (Function2 & Serializable)(x$7, log) -> {
            log.isLocallyCompactable();
            return BoxedUnit.UNIT;
        };
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            TierCompactionEndToEndTest.$anonfun$validateLogs$1(this, validateLogs_validator, tp);
            return BoxedUnit.UNIT;
        });
        Object var9_7 = null;
        this.waitUntilSegmentsLocallyCompactedAndTierCompacted();
        this.produceKeyedRecords(2000);
        this.waitUntilSegmentsLocallyCompactedAndTierCompacted();
        ArrayList<AlterConfigOp> newConfigs2 = new ArrayList<AlterConfigOp>();
        newConfigs2.add(new AlterConfigOp(new ConfigEntry("confluent.tier.cleaner.enable", "false"), AlterConfigOp.OpType.SET));
        this.alterTopicConfig(newConfigs2);
        Function2 & Serializable validateLogs_validator5 = (Function2 & Serializable)(x$8, log) -> {
            TierCompactionEndToEndTest.$anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$7(x$8, log);
            return BoxedUnit.UNIT;
        };
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            TierCompactionEndToEndTest.$anonfun$validateLogs$1(this, validateLogs_validator, tp);
            return BoxedUnit.UNIT;
        });
        Object var10_9 = null;
        Function2 & Serializable validateLogs_validator6 = (Function2 & Serializable)(x$9, log) -> {
            log.isTierCompactable();
            return BoxedUnit.UNIT;
        };
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            TierCompactionEndToEndTest.$anonfun$validateLogs$1(this, validateLogs_validator, tp);
            return BoxedUnit.UNIT;
        });
        Object var11_10 = null;
        Function2 & Serializable validateLogs_validator7 = (Function2 & Serializable)(x$10, log) -> {
            log.isLocallyCompactable();
            return BoxedUnit.UNIT;
        };
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            TierCompactionEndToEndTest.$anonfun$validateLogs$1(this, validateLogs_validator, tp);
            return BoxedUnit.UNIT;
        });
        Object var12_11 = null;
        this.produceKeyedRecords(2000);
        this.waitUntilSegmentsLocallyCompacted();
        ArrayList<AlterConfigOp> newConfigs3 = new ArrayList<AlterConfigOp>();
        newConfigs3.add(new AlterConfigOp(new ConfigEntry("confluent.tier.cleaner.enable", "true"), AlterConfigOp.OpType.SET));
        this.alterTopicConfig(newConfigs3);
        Function2 & Serializable validateLogs_validator8 = (Function2 & Serializable)(x$11, log) -> {
            TierCompactionEndToEndTest.$anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$12(x$11, log);
            return BoxedUnit.UNIT;
        };
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            TierCompactionEndToEndTest.$anonfun$validateLogs$1(this, validateLogs_validator, tp);
            return BoxedUnit.UNIT;
        });
        Object var13_13 = null;
        Function2 & Serializable validateLogs_validator9 = (Function2 & Serializable)(x$12, log) -> {
            log.isTierCompactable();
            return BoxedUnit.UNIT;
        };
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            TierCompactionEndToEndTest.$anonfun$validateLogs$1(this, validateLogs_validator, tp);
            return BoxedUnit.UNIT;
        });
        Object var14_14 = null;
        Function2 & Serializable validateLogs_validator10 = (Function2 & Serializable)(x$13, log) -> {
            log.isLocallyCompactable();
            return BoxedUnit.UNIT;
        };
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            TierCompactionEndToEndTest.$anonfun$validateLogs$1(this, validateLogs_validator, tp);
            return BoxedUnit.UNIT;
        });
        Object var15_15 = null;
        this.waitUntilSegmentsLocallyCompactedAndTierCompacted();
        this.produceKeyedRecords(3000);
        this.waitUntilSegmentsLocallyCompactedAndTierCompacted();
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testConcurrentLocalAndTierCompactionWithPreferTierFetch(String quorum) {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("retention.bytes", "-1");
        props.put("cleanup.policy", "compact");
        props.put("confluent.tier.cleaner.compact.min.efficiency", Double.toString(0.1));
        this.configureDualCompaction(props);
        this.partitionLeaders_$eq(this.createTopic(this.topic(), this.partitions(), 3, props, this.createTopic$default$5(), this.createTopic$default$6()));
        this.produceKeyedRecords(6000);
        this.waitUntilSegmentsLocallyCompactedAndTierCompacted();
        this.consumeAndValidateTierFetch(true);
        MetricName bytesFetchedTotalMetricName = new MetricName("BytesFetchedTotal", "TierFetcher", "", Collections.emptyMap());
        Assertions.assertTrue((BoxesRunTime.unboxToDouble((Object)this.getMetricOnLeader(bytesFetchedTotalMetricName).metricValue()) == 0.0 ? 1 : 0) != 0);
        int preferTierFetchMs = 0;
        ArrayList<AlterConfigOp> newConfigs = new ArrayList<AlterConfigOp>();
        newConfigs.add(new AlterConfigOp(new ConfigEntry("confluent.compacted.topic.prefer.tier.fetch.ms", Integer.toString(preferTierFetchMs)), AlterConfigOp.OpType.SET));
        this.alterTopicConfig(newConfigs);
        Function2 & Serializable validateLogs_validator = (Function2 & Serializable)(x$14, log) -> {
            TierCompactionEndToEndTest.$anonfun$testConcurrentLocalAndTierCompactionWithPreferTierFetch$1(preferTierFetchMs, x$14, log);
            return BoxedUnit.UNIT;
        };
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            TierCompactionEndToEndTest.$anonfun$validateLogs$1(this, validateLogs_validator, tp);
            return BoxedUnit.UNIT;
        });
        Object var6_6 = null;
        this.consumeAndValidateTierFetch(true);
        Assertions.assertTrue((BoxesRunTime.unboxToDouble((Object)this.getMetricOnLeader(bytesFetchedTotalMetricName).metricValue()) > 0.0 ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testConcurrentLocalAndTierCompactionDisableLocalCompaction(String quorum) {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("retention.bytes", "-1");
        props.put("cleanup.policy", "compact");
        props.put("confluent.tier.cleaner.compact.min.efficiency", Double.toString(0.1));
        this.configureDualCompaction(props);
        this.partitionLeaders_$eq(this.createTopic(this.topic(), this.partitions(), 3, props, this.createTopic$default$5(), this.createTopic$default$6()));
        this.produceKeyedRecords(5000);
        this.waitUntilSegmentsLocallyCompactedAndTierCompacted();
        ArrayList<AlterConfigOp> newConfigs = new ArrayList<AlterConfigOp>();
        newConfigs.add(new AlterConfigOp(new ConfigEntry("confluent.tier.cleaner.dual.compaction", "false"), AlterConfigOp.OpType.SET));
        this.alterTopicConfig(newConfigs);
        Function2 & Serializable validateLogs_validator = (Function2 & Serializable)(x$15, log) -> {
            TierCompactionEndToEndTest.$anonfun$testConcurrentLocalAndTierCompactionDisableLocalCompaction$1(x$15, log);
            return BoxedUnit.UNIT;
        };
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            TierCompactionEndToEndTest.$anonfun$validateLogs$1(this, validateLogs_validator, tp);
            return BoxedUnit.UNIT;
        });
        Object var4_4 = null;
        Function2 & Serializable validateLogs_validator2 = (Function2 & Serializable)(x$16, log) -> {
            log.isTierCompactable();
            return BoxedUnit.UNIT;
        };
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            TierCompactionEndToEndTest.$anonfun$validateLogs$1(this, validateLogs_validator, tp);
            return BoxedUnit.UNIT;
        });
        Object var5_5 = null;
        Function2 & Serializable validateLogs_validator3 = (Function2 & Serializable)(x$17, log) -> {
            log.isLocallyCompactable();
            return BoxedUnit.UNIT;
        };
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            TierCompactionEndToEndTest.$anonfun$validateLogs$1(this, validateLogs_validator, tp);
            return BoxedUnit.UNIT;
        });
        Object var6_6 = null;
        this.waitUntilAllSegmentsDeletedFromHotset();
        this.consumeAndValidateTierFetch(true);
        this.produceKeyedRecords(3000);
        this.waitUntilSegmentsTieredAndCompacted();
        this.waitUntilAllSegmentsDeletedFromHotset();
        this.consumeAndValidateTierFetch(true);
    }

    private void verifyMetricsCallbackNotGrabLogLock(int logIndex, Seq<AbstractLog> logs, AtomicLong bgThreadID, CountDownLatch latch, AtomicBoolean metricsComputeComplete) {
        if (logIndex < logs.size()) {
            Object object = ((MergedLog)logs.apply(logIndex)).lock();
            synchronized (object) {
                this.verifyMetricsCallbackNotGrabLogLock(logIndex + 1, logs, bgThreadID, latch, metricsComputeComplete);
                return;
            }
        }
        latch.countDown();
        while (!metricsComputeComplete.get()) {
            ThreadInfo bgThreadInfo;
            Thread.sleep(500L);
            if (bgThreadID.get() <= 0L || (bgThreadInfo = ManagementFactory.getThreadMXBean().getThreadInfo(bgThreadID.get())) == null) continue;
            Assertions.assertNotEquals((Object)((Object)Thread.State.BLOCKED), (Object)((Object)bgThreadInfo.getThreadState()));
        }
    }

    private void produceKeyedRecords(int numRecords) {
        Random random = new Random();
        List keyValues = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).toList().map((Function1 & Serializable)i -> TierCompactionEndToEndTest.$anonfun$produceKeyedRecords$1(this, random, BoxesRunTime.unboxToInt((Object)i)));
        this.produceKeyedRecords((List<Tuple2<Object, Object>>)keyValues);
        this.numProducedRecords_$eq(this.numProducedRecords() + numRecords);
    }

    private void produceKeyedRecords(List<Tuple2<Object, Object>> keyValues) {
        try (KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());){
            keyValues.grouped(10).foreach((Function1 & Serializable)group -> group.map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    int k = x0$1._1$mcI$sp();
                    int v = x0$1._2$mcI$sp();
                    this.producedRecords().put((Object)BoxesRunTime.boxToInteger((int)k), (Object)BoxesRunTime.boxToInteger((int)v));
                    long timestamp = System.currentTimeMillis();
                    return new ProducerRecord(this.topic(), null, Predef$.MODULE$.long2Long(timestamp), (Object)Integer.toString(k).getBytes(StandardCharsets.UTF_8), (Object)Integer.toString(v).getBytes(StandardCharsets.UTF_8));
                }
                throw new MatchError(null);
            }).map((Function1 & Serializable)x$1 -> producer.send(x$1)).map((Function1 & Serializable)x$18 -> (RecordMetadata)x$18.get(10L, TimeUnit.SECONDS)));
        }
    }

    private void configureDualCompaction(Properties props) {
        props.put("confluent.tier.cleaner.dual.compaction", "true");
        props.put("min.cleanable.dirty.ratio", Double.toString(0.1));
    }

    private AlterConfigsResult alterTopicConfig(ArrayList<AlterConfigOp> configEntries) {
        AlterConfigsResult alterConfigsResult;
        HashMap<ConfigResource, ArrayList<AlterConfigOp>> configs = new HashMap<ConfigResource, ArrayList<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.topic()), configEntries);
        try (ConfluentAdmin adminClient = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());){
            alterConfigsResult = adminClient.incrementalAlterConfigs(configs);
        }
        return alterConfigsResult;
    }

    private void waitUntilSegmentsTieredAndCompacted() {
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            TierCompactionEndToEndTest.$anonfun$waitUntilSegmentsTieredAndCompacted$1(this, tp);
            return BoxedUnit.UNIT;
        });
    }

    private void waitUntilSegmentsLocallyCompacted() {
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            TierCompactionEndToEndTest.$anonfun$waitUntilSegmentsLocallyCompacted$1(this, tp);
            return BoxedUnit.UNIT;
        });
    }

    private void waitUntilAllSegmentsDeletedFromHotset() {
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            TierCompactionEndToEndTest.$anonfun$waitUntilAllSegmentsDeletedFromHotset$1(this, tp);
            return BoxedUnit.UNIT;
        });
    }

    private void waitUntilSegmentsLocallyCompactedAndTierCompacted() {
        this.waitUntilSegmentsTieredAndCompacted();
        this.waitUntilSegmentsLocallyCompacted();
    }

    private void validateLogs(Function2<KafkaBroker, AbstractLog, BoxedUnit> validator) {
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            TierCompactionEndToEndTest.$anonfun$validateLogs$1(this, validateLogs_validator, tp);
            return BoxedUnit.UNIT;
        });
    }

    private void consumeAndValidateTierFetch(boolean isDualCompaction) {
        this.consumeAndValidateTierFetch(this.producedRecords(), isDualCompaction);
    }

    private void consumeAndValidateTierFetch(scala.collection.mutable.Map<Object, Object> kvsExpected, boolean isDualCompaction) {
        TopicPartition topicPartition = (TopicPartition)this.topicPartitions().head();
        Consumer consumer = this.createConsumer(new StringDeserializer(), new StringDeserializer(), this.createConsumer$default$3(), this.createConsumer$default$4());
        java.util.List<TopicPartition> partitions = Collections.singletonList(topicPartition);
        consumer.assign(partitions);
        consumer.seekToBeginning(partitions);
        ArrayList kvsRead = new ArrayList();
        int timeout = 5000;
        ConsumerRecords records = consumer.poll(Duration.ofMillis(timeout));
        do {
            records.forEach((java.util.function.Consumer)new java.util.function.Consumer<ConsumerRecord<String, String>>(null, kvsRead){
                private final ArrayList kvsRead$1;

                public java.util.function.Consumer<ConsumerRecord<String, String>> andThen(java.util.function.Consumer<? super ConsumerRecord<String, String>> x$1) {
                    return java.util.function.Consumer.super.andThen(x$1);
                }

                public void accept(ConsumerRecord<String, String> r) {
                    this.kvsRead$1.add(new Tuple2.mcII.sp(Integer.parseInt((String)r.key()), Integer.parseInt((String)r.value())));
                }
                {
                    this.kvsRead$1 = kvsRead$1;
                }
            });
        } while (!(records = consumer.poll(Duration.ofMillis(timeout))).isEmpty());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.ListHasAsScala(kvsRead).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), kvsExpected);
        Assertions.assertTrue((BoxesRunTime.unboxToDouble(this.getMBeanAttribute("kafka.log:type=CleanerStats,name=CompactionThroughputBytesPerSec,op=read,form=tier", "MeanRate")) > 0.0 ? 1 : 0) != 0, (String)"Compaction read throughput should be > 0");
        Assertions.assertTrue((BoxesRunTime.unboxToDouble(this.getMBeanAttribute("kafka.log:type=CleanerStats,name=CompactionThroughputBytesPerSec,op=write,form=tier", "MeanRate")) > 0.0 ? 1 : 0) != 0, (String)"Compaction write throughput should be > 0");
        int partitionsTaskInError = BoxesRunTime.unboxToInt(this.getMBeanAttribute("kafka.tier.tasks:type=TierTasks,name=NumPartitionsInError", "Value"));
        Assertions.assertEquals((int)0, (int)partitionsTaskInError, (String)"task shows no partitions in error state");
        if (isDualCompaction) {
            Assertions.assertTrue((BoxesRunTime.unboxToDouble(this.getMBeanAttribute("kafka.log:type=CleanerStats,name=CompactionValidationPassedPerSec,form=tier", "MeanRate")) > 0.0 ? 1 : 0) != 0, (String)"Compaction validation passed > 0");
            double compactionValidationFailed = BoxesRunTime.unboxToDouble(this.getMBeanAttribute("kafka.log:type=CleanerStats,name=CompactionValidationFailedPerSec,form=tier", "MeanRate"));
            Assertions.assertEquals((double)0.0, (double)compactionValidationFailed, (String)"Compaction validation failed count shall be 0");
            return;
        }
    }

    private boolean consumeAndValidateTierFetch$default$1() {
        return false;
    }

    private <T> T getMBeanAttribute(String name, String attribute) {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        return (T)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(mBeanServer.getAttributes(new ObjectName(name), new String[]{attribute}).asList()).asScala().map((Function1 & Serializable)attr -> attr.getValue())).head();
    }

    private KafkaMetric getMetricOnLeader(MetricName metricName) {
        int leaderId = BoxesRunTime.unboxToInt((Object)this.partitionLeaders().apply((Object)BoxesRunTime.boxToInteger((int)0)));
        return (KafkaMetric)((IterableOnceOps)((IterableOps)this.brokers().filter((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)TierCompactionEndToEndTest.$anonfun$getMetricOnLeader$1(leaderId, x$19)))).map((Function1 & Serializable)x$20 -> x$20.metrics().metric(metricName))).toList().head();
    }

    public static final /* synthetic */ TopicPartition $anonfun$topicPartitions$1(TierCompactionEndToEndTest $this, int p) {
        return new TopicPartition($this.topic(), p);
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsNotAcquireLogLock$3(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null && (Metric)check$ifrefutable$1._2() instanceof Gauge;
    }

    public static final /* synthetic */ void $anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$1(KafkaBroker x$4, AbstractLog log) {
        log.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ boolean $anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$3(AbstractLog log$1) {
        return log$1.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$4() {
        return "TierPartitionState#tieringEnabled flag set to true";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$2(KafkaBroker x$5, AbstractLog log) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 5000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierCompactionEndToEndTest.$anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$3(log)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"TierPartitionState#tieringEnabled flag set to true");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$8(AbstractLog log$2) {
        return !log$2.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$9() {
        return "TierPartitionState#tieringEnabled flag set to false";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$7(KafkaBroker x$8, AbstractLog log) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 5000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierCompactionEndToEndTest.$anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$8(log)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"TierPartitionState#tieringEnabled flag set to false");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$13(AbstractLog log$3) {
        return log$3.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$14() {
        return "TierPartitionState#tieringEnabled flag set to true";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$12(KafkaBroker x$11, AbstractLog log) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 5000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierCompactionEndToEndTest.$anonfun$testConcurrentLocalAndTierCompactionEnableAndDisable$13(log)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"TierPartitionState#tieringEnabled flag set to true");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testConcurrentLocalAndTierCompactionWithPreferTierFetch$2(AbstractLog log$4, int preferTierFetchMs$1) {
        return log$4.config().confluentLogConfig().preferTierFetchMs == (long)preferTierFetchMs$1;
    }

    public static final /* synthetic */ String $anonfun$testConcurrentLocalAndTierCompactionWithPreferTierFetch$3() {
        return "Timeout setting PreferTierFetchMs";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testConcurrentLocalAndTierCompactionWithPreferTierFetch$1(int preferTierFetchMs$1, KafkaBroker x$14, AbstractLog log) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 5000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierCompactionEndToEndTest.$anonfun$testConcurrentLocalAndTierCompactionWithPreferTierFetch$2(log, preferTierFetchMs$1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timeout setting PreferTierFetchMs");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testConcurrentLocalAndTierCompactionDisableLocalCompaction$2(AbstractLog log$5) {
        return !log$5.config().confluentLogConfig().tierCleanerDualCompaction;
    }

    public static final /* synthetic */ String $anonfun$testConcurrentLocalAndTierCompactionDisableLocalCompaction$3() {
        return "Timeout setting TierCleanerDualCompaction to false";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testConcurrentLocalAndTierCompactionDisableLocalCompaction$1(KafkaBroker x$15, AbstractLog log) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 5000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierCompactionEndToEndTest.$anonfun$testConcurrentLocalAndTierCompactionDisableLocalCompaction$2(log)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timeout setting TierCleanerDualCompaction to false");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ Tuple2 $anonfun$produceKeyedRecords$1(TierCompactionEndToEndTest $this, Random random$1, int i) {
        return new Tuple2.mcII.sp(random$1.nextInt($this.maxNumRecords() / 10), $this.numProducedRecords() + i);
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilSegmentsTieredAndCompacted$3(TierPartitionState tierPartitionState$1, AbstractLog log$6) {
        tierPartitionState$1.flush();
        CollectionConverters$.MODULE$.IteratorHasAsScala(tierPartitionState$1.segments()).asScala().foreach((Function1 & Serializable)seg -> {
            Predef$.MODULE$.assert(!seg.metadata().hasAbortedTxns() && seg.metadata().hasEpochState() && seg.metadata().hasProducerState());
            return BoxedUnit.UNIT;
        });
        return log$6.tierableLogSegments().isEmpty() && tierPartitionState$1.compactDirtyStartOffset() > tierPartitionState$1.endOffset() && tierPartitionState$1.endOffset() == tierPartitionState$1.committedEndOffset();
    }

    public static final /* synthetic */ String $anonfun$waitUntilSegmentsTieredAndCompacted$5(AbstractLog log$6, TierPartitionState tierPartitionState$1) {
        return new StringBuilder(168).append("timeout waiting for tiered segments to be compacted.").append(" tierable segments: ").append(log$6.tierableLogSegments()).append(",").append(" local segments ").append(log$6.localLogSegments()).append(",").append(" tiered segments: ").append(CollectionConverters$.MODULE$.IteratorHasAsScala(tierPartitionState$1.segments()).asScala().toList()).append(",").append(" end offset: ").append(tierPartitionState$1.endOffset()).append(",").append(" committed end offset: ").append(tierPartitionState$1.committedEndOffset()).append(",").append(" dirty start offset: ").append(tierPartitionState$1.compactDirtyStartOffset()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$waitUntilSegmentsTieredAndCompacted$2(TopicPartition tp$1, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$1.getLog(tp$1, x$2).get();
        TierPartitionState tierPartitionState = log.tierPartitionState();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 90000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierCompactionEndToEndTest.$anonfun$waitUntilSegmentsTieredAndCompacted$3(tierPartitionState, log)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierCompactionEndToEndTest.$anonfun$waitUntilSegmentsTieredAndCompacted$5(log, tierPartitionState));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        CollectionConverters$.MODULE$.IteratorHasAsScala(tierPartitionState.segments()).asScala().foreach((Function1 & Serializable)seg -> {
            Predef$.MODULE$.assert(!seg.metadata().hasAbortedTxns() && seg.metadata().hasEpochState() && seg.metadata().hasProducerState());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$waitUntilSegmentsTieredAndCompacted$1(TierCompactionEndToEndTest $this, TopicPartition tp) {
        $this.brokers().foreach((Function1 & Serializable)broker -> {
            TierCompactionEndToEndTest.$anonfun$waitUntilSegmentsTieredAndCompacted$2(tp, broker);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$waitUntilSegmentsLocallyCompacted$2(TopicPartition tp$2, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$1.getLog(tp$2, x$2).get();
        TierPartitionState tierPartitionState = log.tierPartitionState();
        Assertions.assertTrue((boolean)broker.logManager().cleaner().awaitCleaned(tp$2, tierPartitionState.compactDirtyStartOffset(), 90000L), (String)new StringBuilder(208).append("timeout waiting for local segments to be compacted.").append(" tierable segments: ").append(log.tierableLogSegments()).append(",").append(" local segments ").append(log.localLogSegments()).append(",").append(" tiered segments: ").append(CollectionConverters$.MODULE$.IteratorHasAsScala(tierPartitionState.segments()).asScala().toList()).append(",").append(" end offset: ").append(tierPartitionState.endOffset()).append(",").append(" committed end offset: ").append(tierPartitionState.committedEndOffset()).append(",").append(" tier cleaner dirty start offset: ").append(tierPartitionState.compactDirtyStartOffset()).append(",").append(" local cleaner checkpoint: ").append(broker.logManager().cleaner().cleanerManager().allCleanerCheckpoints().get((Object)tp$2)).toString());
    }

    public static final /* synthetic */ void $anonfun$waitUntilSegmentsLocallyCompacted$1(TierCompactionEndToEndTest $this, TopicPartition tp) {
        $this.brokers().foreach((Function1 & Serializable)broker -> {
            TierCompactionEndToEndTest.$anonfun$waitUntilSegmentsLocallyCompacted$2(tp, broker);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilAllSegmentsDeletedFromHotset$3(AbstractLog log$7) {
        return log$7.localLogSegments().size() == 1;
    }

    public static final /* synthetic */ String $anonfun$waitUntilAllSegmentsDeletedFromHotset$4(AbstractLog log$7) {
        return new StringBuilder(82).append("Timeout waiting for local segments from being removed from hotset. local segments ").append(log$7.localLogSegments()).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$waitUntilAllSegmentsDeletedFromHotset$2(TopicPartition tp$3, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$1.getLog(tp$3, x$2).get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 90000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierCompactionEndToEndTest.$anonfun$waitUntilAllSegmentsDeletedFromHotset$3(log)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierCompactionEndToEndTest.$anonfun$waitUntilAllSegmentsDeletedFromHotset$4(log));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ void $anonfun$waitUntilAllSegmentsDeletedFromHotset$1(TierCompactionEndToEndTest $this, TopicPartition tp) {
        $this.brokers().foreach((Function1 & Serializable)broker -> {
            TierCompactionEndToEndTest.$anonfun$waitUntilAllSegmentsDeletedFromHotset$2(tp, broker);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$validateLogs$2(TopicPartition tp$4, Function2 validator$1, KafkaBroker broker) {
        LogManager qual$1 = broker.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$1.getLog(tp$4, x$2).get();
        validator$1.apply((Object)broker, (Object)log);
    }

    public static final /* synthetic */ void $anonfun$validateLogs$1(TierCompactionEndToEndTest $this, Function2 validator$1, TopicPartition tp) {
        $this.brokers().foreach((Function1 & Serializable)broker -> {
            TierCompactionEndToEndTest.$anonfun$validateLogs$2(tp, validator$1, broker);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getMetricOnLeader$1(int leaderId$1, KafkaBroker x$19) {
        return x$19.config().brokerId() == leaderId$1;
    }

    public TierCompactionEndToEndTest() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierEnableProp(), "false");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierCleanerFeatureEnableProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierCleanerEnableProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierCleanerDualCompactionValidationPercentProp(), "100");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "3");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "3");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "5");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierCleanerCompactMinEfficiencyProp(), "0.001");
        this.serverConfig().put(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), "10");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFetcherMemoryPoolSizeBytesProp(), Integer.toString(0x100000));
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCleanupEnableProp(), Boolean.toString(true));
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCleanupIntervalMsProp(), "0");
        this.configureMock();
        this.topic = "test_topic";
        this.partitions = 1;
        this.partitionLeaders = null;
        this.maxNumRecords = 5000;
        this.numProducedRecords = 0;
        this.producedRecords = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.exited = new AtomicBoolean(false);
    }
}

