/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import io.confluent.kafka.storage.checksum.ChecksumParams;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Supplier;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.LogTestUtils$;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.TierLogComponents;
import kafka.log.TierLogSegment;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.InternalAdmin;
import kafka.server.LeaderEndpointSupplier;
import kafka.server.ReplicaManager;
import kafka.tier.TierCompactionIntegrationTest$;
import kafka.tier.TierDeletedPartitionsCoordinator;
import kafka.tier.TierReplicaManager;
import kafka.tier.TierTopicManagerCommitter;
import kafka.tier.TopicIdPartition;
import kafka.tier.client.MockConsumerSupplier;
import kafka.tier.client.MockProducerSupplier;
import kafka.tier.fetcher.TierStateFetcher;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;
import kafka.tier.tasks.TierTaskQueue;
import kafka.tier.tasks.TierTasks;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.compaction.CompactionTask;
import kafka.tier.tasks.compaction.TierLogCleanerManager;
import kafka.tier.tasks.config.CompactionTasksConfig;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicAppender;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicDataLossValidator;
import kafka.tier.topic.TierTopicManager;
import kafka.tier.topic.TierTopicManagerConfig;
import kafka.utils.Pool;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Short$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\u0011ub\u0001\u0002&L\u0001ACQa\u0016\u0001\u0005\u0002aCqa\u0017\u0001C\u0002\u0013%A\f\u0003\u0004k\u0001\u0001\u0006I!\u0018\u0005\bW\u0002\u0011\r\u0011\"\u0001m\u0011\u0019Q\b\u0001)A\u0005[\"I1\u0010\u0001a\u0001\u0002\u0004%\t\u0001 \u0005\f\u0003\u000f\u0001\u0001\u0019!a\u0001\n\u0003\tI\u0001\u0003\u0006\u0002\u0016\u0001\u0001\r\u0011!Q!\nuD1\"a\u0006\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u001a!Y\u0011\u0011\u0005\u0001A\u0002\u0003\u0007I\u0011AA\u0012\u0011-\t9\u0003\u0001a\u0001\u0002\u0003\u0006K!a\u0007\t\u0017\u0005%\u0002\u00011AA\u0002\u0013\u0005\u00111\u0006\u0005\f\u0003s\u0001\u0001\u0019!a\u0001\n\u0003\tY\u0004C\u0006\u0002@\u0001\u0001\r\u0011!Q!\n\u00055\u0002bCA!\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0007B1\"!\u0015\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002T!Y\u0011q\u000b\u0001A\u0002\u0003\u0005\u000b\u0015BA#\u0011%\tI\u0006\u0001b\u0001\n\u0003\tY\u0006\u0003\u0005\u0002d\u0001\u0001\u000b\u0011BA/\u0011%\t)\u0007\u0001b\u0001\n\u0003\t9\u0007\u0003\u0005\u0002z\u0001\u0001\u000b\u0011BA5\u0011%\tY\b\u0001b\u0001\n\u0003\ti\b\u0003\u0005\u0002\u0006\u0002\u0001\u000b\u0011BA@\u0011-\t9\t\u0001a\u0001\u0002\u0004%\t!!#\t\u0017\u0005M\u0005\u00011AA\u0002\u0013\u0005\u0011Q\u0013\u0005\f\u00033\u0003\u0001\u0019!A!B\u0013\tY\tC\u0006\u0002\u001c\u0002\u0001\r\u00111A\u0005\u0002\u0005u\u0005bCAU\u0001\u0001\u0007\t\u0019!C\u0001\u0003WC1\"a,\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002 \"Y\u0011\u0011\u0017\u0001A\u0002\u0003\u0007I\u0011AAZ\u0011-\t\t\r\u0001a\u0001\u0002\u0004%\t!a1\t\u0017\u0005\u001d\u0007\u00011A\u0001B\u0003&\u0011Q\u0017\u0005\n\u0003\u0013\u0004\u0001\u0019!C\u0001\u0003\u0017D\u0011\"a5\u0001\u0001\u0004%\t!!6\t\u0011\u0005e\u0007\u0001)Q\u0005\u0003\u001bD\u0011\"a7\u0001\u0001\u0004%\t!!8\t\u0013\u0005-\b\u00011A\u0005\u0002\u00055\b\u0002CAy\u0001\u0001\u0006K!a8\t\u0017\u0005M\b\u00011AA\u0002\u0013\u0005\u0011Q\u001f\u0005\f\u0005+\u0001\u0001\u0019!a\u0001\n\u0003\u00119\u0002C\u0006\u0003\u001c\u0001\u0001\r\u0011!Q!\n\u0005]\bb\u0003B\u000f\u0001\u0001\u0007\t\u0019!C\u0001\u0005?A1Ba\n\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003*!Y!Q\u0006\u0001A\u0002\u0003\u0005\u000b\u0015\u0002B\u0011\u0011-\u0011y\u0003\u0001a\u0001\u0002\u0004%\tA!\r\t\u0017\t-\u0003\u00011AA\u0002\u0013\u0005!Q\n\u0005\f\u0005#\u0002\u0001\u0019!A!B\u0013\u0011\u0019\u0004C\u0005\u0003T\u0001\u0011\r\u0011\"\u0001\u0002\\!A!Q\u000b\u0001!\u0002\u0013\ti\u0006C\u0005\u0003X\u0001\u0011\r\u0011\"\u0001\u0003Z!A!\u0011\r\u0001!\u0002\u0013\u0011Y\u0006C\u0004\u0003d\u0001!\tA!\u001a\t\u0013\t}\u0004!%A\u0005\u0002\t\u0005\u0005\"\u0003BL\u0001E\u0005I\u0011\u0001BA\u0011\u001d\u0011I\n\u0001C\u0001\u00057CqAa-\u0001\t\u0003\u0011Y\nC\u0004\u0003>\u0002!\tAa0\t\u000f\t5\b\u0001\"\u0001\u0003p\"91q\u0001\u0001\u0005\u0002\r%\u0001bBB\n\u0001\u0011\u00051Q\u0003\u0005\b\u0007?\u0001A\u0011BB\u0011\u0011\u001d\u0019)\u0003\u0001C\u0005\u0007OA\u0011ba\u000e\u0001#\u0003%Ia!\u000f\t\u000f\ru\u0002\u0001\"\u0003\u0004@!91q\f\u0001\u0005\n\r\u0005\u0004bBB:\u0001\u0011%!1\u0014\u0005\b\u0007k\u0002A\u0011BB<\u0011\u001d\u0019i\n\u0001C\u0005\u0007?Cqaa)\u0001\t\u0013\u0019)\u000bC\u0004\u0004>\u0002!Iaa0\t\u000f\r\u0015\b\u0001\"\u0003\u0004h\"91\u0011 \u0001\u0005\n\rm\bb\u0002C\u0018\u0001\u0011%!1\u0014\u0002\u001e)&,'oQ8na\u0006\u001cG/[8o\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u0011A*T\u0001\u0005i&,'OC\u0001O\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A)\u0011\u0005I+V\"A*\u000b\u0003Q\u000bQa]2bY\u0006L!AV*\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011\f\u0005\u0002[\u00015\t1*\u0001\u0005n_\u000e\\G+[7f+\u0005i\u0006C\u00010i\u001b\u0005y&B\u00011b\u0003\u0011)H/\u001b7\u000b\u0005\t\u001c\u0017AB:feZ,'O\u0003\u0002OI*\u0011QMZ\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\f1a\u001c:h\u0013\tIwL\u0001\u0005N_\u000e\\G+[7f\u0003%iwnY6US6,\u0007%A\u0004m_\u001e$\u0015N]:\u0016\u00035\u00042A\u001c:u\u001b\u0005y'B\u00011q\u0015\u0005\t\u0018\u0001\u00026bm\u0006L!a]8\u0003\u0013\u0005\u0013(/Y=MSN$\bCA;y\u001b\u00051(BA<q\u0003\u0011a\u0017M\\4\n\u0005e4(AB*ue&tw-\u0001\u0005m_\u001e$\u0015N]:!\u0003Y!\u0018.\u001a:U_BL7-T1oC\u001e,'oQ8oM&<W#A?\u0011\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\taS\u0001\u0006i>\u0004\u0018nY\u0005\u0004\u0003\u000by(A\u0006+jKJ$v\u000e]5d\u001b\u0006t\u0017mZ3s\u0007>tg-[4\u00025QLWM\u001d+pa&\u001cW*\u00198bO\u0016\u00148i\u001c8gS\u001e|F%Z9\u0015\t\u0005-\u0011\u0011\u0003\t\u0004%\u00065\u0011bAA\b'\n!QK\\5u\u0011!\t\u0019bBA\u0001\u0002\u0004i\u0018a\u0001=%c\u00059B/[3s)>\u0004\u0018nY'b]\u0006<WM]\"p]\u001aLw\rI\u0001\u0012i&,'\u000fV8qS\u000e\u001cuN\\:v[\u0016\u0014XCAA\u000e!\rq\u0018QD\u0005\u0004\u0003?y(!\u0005+jKJ$v\u000e]5d\u0007>t7/^7fe\u0006)B/[3s)>\u0004\u0018nY\"p]N,X.\u001a:`I\u0015\fH\u0003BA\u0006\u0003KA\u0011\"a\u0005\u000b\u0003\u0003\u0005\r!a\u0007\u0002%QLWM\u001d+pa&\u001c7i\u001c8tk6,'\u000fI\u0001\u0012i&,'\u000fT8h\u0007>l\u0007o\u001c8f]R\u001cXCAA\u0017!\u0011\ty#!\u000e\u000e\u0005\u0005E\"bAA\u001a\u001b\u0006\u0019An\\4\n\t\u0005]\u0012\u0011\u0007\u0002\u0012)&,'\u000fT8h\u0007>l\u0007o\u001c8f]R\u001c\u0018!\u0006;jKJdunZ\"p[B|g.\u001a8ug~#S-\u001d\u000b\u0005\u0003\u0017\ti\u0004C\u0005\u0002\u00145\t\t\u00111\u0001\u0002.\u0005\u0011B/[3s\u0019><7i\\7q_:,g\u000e^:!\u0003\u001d!X-\u001c9ESJ,\"!!\u0012\u0011\t\u0005\u001d\u0013QJ\u0007\u0003\u0003\u0013R1!a\u0013q\u0003\tIw.\u0003\u0003\u0002P\u0005%#\u0001\u0002$jY\u0016\f1\u0002^3na\u0012K'o\u0018\u0013fcR!\u00111BA+\u0011%\t\u0019\u0002EA\u0001\u0002\u0004\t)%\u0001\u0005uK6\u0004H)\u001b:!\u0003)qW/\u001c+ie\u0016\fGm]\u000b\u0003\u0003;\u00022AUA0\u0013\r\t\tg\u0015\u0002\u0004\u0013:$\u0018a\u00038v[RC'/Z1eg\u0002\n\u0001\u0004^5fe\u000e{W\u000e]1di&|g\u000eV1tW\u000e{gNZ5h+\t\tI\u0007\u0005\u0003\u0002l\u0005UTBAA7\u0015\u0011\ty'!\u001d\u0002\r\r|gNZ5h\u0015\r\t\u0019hS\u0001\u0006i\u0006\u001c8n]\u0005\u0005\u0003o\niGA\u000bD_6\u0004\u0018m\u0019;j_:$\u0016m]6t\u0007>tg-[4\u00023QLWM]\"p[B\f7\r^5p]R\u000b7o[\"p]\u001aLw\rI\u0001\u0010i&,'\u000fV1tWN\u001cuN\u001c4jOV\u0011\u0011q\u0010\t\u0005\u0003W\n\t)\u0003\u0003\u0002\u0004\u00065$a\u0004+jKJ$\u0016m]6t\u0007>tg-[4\u0002!QLWM\u001d+bg.\u001c8i\u001c8gS\u001e\u0004\u0013!\u0003;jKJ$\u0016m]6t+\t\tY\t\u0005\u0003\u0002\u000e\u0006=UBAA9\u0013\u0011\t\t*!\u001d\u0003\u0013QKWM\u001d+bg.\u001c\u0018!\u0004;jKJ$\u0016m]6t?\u0012*\u0017\u000f\u0006\u0003\u0002\f\u0005]\u0005\"CA\n3\u0005\u0005\t\u0019AAF\u0003)!\u0018.\u001a:UCN\\7\u000fI\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s+\t\ty\n\u0005\u0003\u0002\"\u0006\u0015VBAAR\u0015\t\u0011W*\u0003\u0003\u0002(\u0006\r&A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0013e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002\f\u00055\u0006\"CA\n9\u0005\u0005\t\u0019AAP\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0013a\u0004;jKJ|%M[3diN#xN]3\u0016\u0005\u0005U\u0006\u0003BA\\\u0003{k!!!/\u000b\u0007\u0005m6*A\u0003ti>\u0014X-\u0003\u0003\u0002@\u0006e&aG'pG.Le.T3n_JLH+[3s\u001f\nTWm\u0019;Ti>\u0014X-A\nuS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f?\u0012*\u0017\u000f\u0006\u0003\u0002\f\u0005\u0015\u0007\"CA\n?\u0005\u0005\t\u0019AA[\u0003A!\u0018.\u001a:PE*,7\r^*u_J,\u0007%\u0001\u0011uS\u0016\u0014H)\u001a7fi\u0016$\u0007+\u0019:uSRLwN\\:D_>\u0014H-\u001b8bi>\u0014XCAAg!\rQ\u0016qZ\u0005\u0004\u0003#\\%\u0001\t+jKJ$U\r\\3uK\u0012\u0004\u0016M\u001d;ji&|gn]\"p_J$\u0017N\\1u_J\fA\u0005^5fe\u0012+G.\u001a;fIB\u000b'\u000f^5uS>t7oQ8pe\u0012Lg.\u0019;pe~#S-\u001d\u000b\u0005\u0003\u0017\t9\u000eC\u0005\u0002\u0014\t\n\t\u00111\u0001\u0002N\u0006\tC/[3s\t\u0016dW\r^3e!\u0006\u0014H/\u001b;j_:\u001c8i\\8sI&t\u0017\r^8sA\u0005\u0001B/[3s'R\fG/\u001a$fi\u000eDWM]\u000b\u0003\u0003?\u0004B!!9\u0002h6\u0011\u00111\u001d\u0006\u0004\u0003K\\\u0015a\u00024fi\u000eDWM]\u0005\u0005\u0003S\f\u0019O\u0001\tUS\u0016\u00148\u000b^1uK\u001a+Go\u00195fe\u0006!B/[3s'R\fG/\u001a$fi\u000eDWM]0%KF$B!a\u0003\u0002p\"I\u00111C\u0013\u0002\u0002\u0003\u0007\u0011q\\\u0001\u0012i&,'o\u0015;bi\u00164U\r^2iKJ\u0004\u0013\u0001\u00027pON,\"!a>\u0011\r\u0005e(\u0011\u0002B\b\u001d\u0011\tYP!\u0002\u000f\t\u0005u(1A\u0007\u0003\u0003\u007fT1A!\u0001P\u0003\u0019a$o\\8u}%\tA+C\u0002\u0003\bM\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0003\f\t5!aA*fc*\u0019!qA*\u0011\t\u0005=\"\u0011C\u0005\u0005\u0005'\t\tDA\u0005NKJ<W\r\u001a'pO\u0006AAn\\4t?\u0012*\u0017\u000f\u0006\u0003\u0002\f\te\u0001\"CA\nQ\u0005\u0005\t\u0019AA|\u0003\u0015awnZ:!\u0003A!\u0018.\u001a:U_BL7-T1oC\u001e,'/\u0006\u0002\u0003\"A\u0019aPa\t\n\u0007\t\u0015rP\u0001\tUS\u0016\u0014Hk\u001c9jG6\u000bg.Y4fe\u0006!B/[3s)>\u0004\u0018nY'b]\u0006<WM]0%KF$B!a\u0003\u0003,!I\u00111C\u0016\u0002\u0002\u0003\u0007!\u0011E\u0001\u0012i&,'\u000fV8qS\u000el\u0015M\\1hKJ\u0004\u0013\u0001E2p]N,X.\u001a:TkB\u0004H.[3s+\t\u0011\u0019\u0004\u0005\u0005\u00036\tm\"q\bB \u001b\t\u00119DC\u0002\u0003:-\u000baa\u00197jK:$\u0018\u0002\u0002B\u001f\u0005o\u0011A#T8dW\u000e{gn];nKJ\u001cV\u000f\u001d9mS\u0016\u0014\b#\u0002*\u0003B\t\u0015\u0013b\u0001B\"'\n)\u0011I\u001d:bsB\u0019!Ka\u0012\n\u0007\t%3K\u0001\u0003CsR,\u0017\u0001F2p]N,X.\u001a:TkB\u0004H.[3s?\u0012*\u0017\u000f\u0006\u0003\u0002\f\t=\u0003\"CA\n]\u0005\u0005\t\u0019\u0001B\u001a\u0003E\u0019wN\\:v[\u0016\u00148+\u001e9qY&,'\u000fI\u0001\u000e[\u0006Dx+Y5u)&lW-T:\u0002\u001d5\f\u0007pV1jiRKW.Z'tA\u0005\u0011B/[3s%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s+\t\u0011Y\u0006E\u0002[\u0005;J1Aa\u0018L\u0005I!\u0016.\u001a:SKBd\u0017nY1NC:\fw-\u001a:\u0002'QLWM\u001d*fa2L7-Y'b]\u0006<WM\u001d\u0011\u0002\u000bM,G/\u001e9\u0015\u0011\u0005-!q\rB9\u0005wBqA!\u001b5\u0001\u0004\u0011Y'\u0001\u0016uS\u0016\u0014Hk\u001c9jG6\u000bG/\u001a:jC2L'0\u0019;j_:4%o\\7T]\u0006\u00048\u000f[8u\u000b:\f'\r\\3\u0011\u0007I\u0013i'C\u0002\u0003pM\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0003tQ\u0002\n\u00111\u0001\u0003v\u0005qa.^7D_6\u0004\u0018m\u0019;M_\u001e\u001c\bcA;\u0003x%\u0019!\u0011\u0010<\u0003\u000f%sG/Z4fe\"I!Q\u0010\u001b\u0011\u0002\u0003\u0007!QO\u0001\u000e]VlG)\u001a7fi\u0016dunZ:\u0002\u001fM,G/\u001e9%I\u00164\u0017-\u001e7uII*\"Aa!+\t\tU$QQ\u0016\u0003\u0005\u000f\u0003BA!#\u0003\u00146\u0011!1\u0012\u0006\u0005\u0005\u001b\u0013y)A\u0005v]\u000eDWmY6fI*\u0019!\u0011S*\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0016\n-%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006y1/\u001a;va\u0012\"WMZ1vYR$3'\u0001\u0004cK\u001a|'/\u001a\u000b\u0003\u0003\u0017A3a\u000eBP!\u0011\u0011\tKa,\u000e\u0005\t\r&\u0002\u0002BS\u0005O\u000b1!\u00199j\u0015\u0011\u0011IKa+\u0002\u000f),\b/\u001b;fe*\u0019!Q\u00164\u0002\u000b),h.\u001b;\n\t\tE&1\u0015\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$wn\u001e8)\u0007a\u00129\f\u0005\u0003\u0003\"\ne\u0016\u0002\u0002B^\u0005G\u0013\u0011\"\u00114uKJ,\u0015m\u00195\u0002/Q,7\u000f^\"p[B\f7\r^5p]&kW.[4sCR,G\u0003BA\u0006\u0005\u0003DqA!\u001b:\u0001\u0004\u0011Y\u0007K\u0004:\u0005\u000b\u0014\tNa5\u0011\t\t\u001d'QZ\u0007\u0003\u0005\u0013TAAa3\u0003(\u00061\u0001/\u0019:b[NLAAa4\u0003J\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u0003\u0005+\fag\u001f3jgBd\u0017-\u001f(b[\u0016lh\u0006^5feR{\u0007/[2NCR,'/[1mSj\fG/[8o\rJ|Wn\u00158baNDw\u000e^\u001f|auDs!\u000fBm\u0005K\u00149\u000f\u0005\u0003\u0003\\\n\u0005XB\u0001Bo\u0015\u0011\u0011yN!3\u0002\u0011A\u0014xN^5eKJLAAa9\u0003^\nYa+\u00197vKN{WO]2f\u0003!\u0011wn\u001c7fC:\u001cH\u0006\u0002Bu\u0005WL\u0012!A\r\u0002\u0001\u0005\u0019C/Z:u\u0007>l\u0007/Y2u\u0003:$G)\u001a7fi\u0016\u001cE.Z1okB\u0004v\u000e\\5dS\u0016\u001cH\u0003BA\u0006\u0005cDqA!\u001b;\u0001\u0004\u0011Y\u0007K\u0004;\u0005k\u0014YP!@\u0011\t\t\u0005&q_\u0005\u0005\u0005s\u0014\u0019K\u0001\u0005ESN\f'\r\\3e\u0003\u00151\u0018\r\\;fC\t\u0011y0A\u0007L'R{%+Q$F[I\u0002\u0004\u0007\r\u0015\bu\t\u0015'\u0011\u001bBjQ\u001dQ$\u0011\u001cBs\u0007\u000baCA!;\u0003l\u0006\u0011B/Z:u)&,'/\u00118e\u0007>l\u0007/Y2u)\u0011\tYaa\u0003\t\u000f\t%4\b1\u0001\u0003l!:1H!2\u0003R\nM\u0007fB\u001e\u0003Z\n\u00158\u0011\u0003\u0017\u0005\u0005S\u0014Y/A\ruKN$H+[3s)\u0006\u001c8n]\"p]\u001aLw-\u00169eCR,G\u0003BA\u0006\u0007/AqA!\u001b=\u0001\u0004\u0011Y\u0007K\u0004=\u0005\u000b\u0014\tNa5)\u000fq\u0012IN!:\u0004\u001e1\"!\u0011\u001eBv\u0003q\u0019'/Z1uKRKWM\u001d+pa&\u001cW*\u00198bO\u0016\u00148i\u001c8gS\u001e$2!`B\u0012\u0011\u001d\u0011I'\u0010a\u0001\u0005W\n!c^1ji\u001a{'/S7nS\u001e\u0014\u0018\r^5p]Ra\u00111BB\u0015\u0007W\u0019yc!\r\u00044!9\u00111\u001f A\u0002\u0005]\bbBB\u0017}\u0001\u0007\u0011QL\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007\u000eC\u0004\u0002\bz\u0002\r!a#\t\u000f\t=b\b1\u0001\u00034!I1Q\u0007 \u0011\u0002\u0003\u0007!1N\u0001\rE\u0016\u001cw.\\3MK\u0006$WM]\u0001\u001do\u0006LGOR8s\u00136l\u0017n\u001a:bi&|g\u000e\n3fM\u0006,H\u000e\u001e\u00136+\t\u0019YD\u000b\u0003\u0003l\t\u0015\u0015\u0001F7bi\u0016\u0014\u0018.\u00197ju\u0016,f\u000e^5m)J,X\r\u0006\u0005\u0002\f\r\u000531JB/\u0011\u001d\u0019\u0019\u0005\u0011a\u0001\u0007\u000b\nA\u0001\u001d:fIB)!ka\u0012\u0003l%\u00191\u0011J*\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004bBB'\u0001\u0002\u00071qJ\u0001\u0004[N<\u0007\u0003BB)\u00073rAaa\u0015\u0004VA\u0019\u0011Q`*\n\u0007\r]3+\u0001\u0004Qe\u0016$WMZ\u0005\u0004s\u000em#bAB,'\"9!q\u0006!A\u0002\tM\u0012\u0001\f<bY&$\u0017\r^3QCJ$\u0018\u000e^5p]N#\u0018\r^3D_:$\u0018-\u001b8fI&swJ\u00196fGR\u001cFo\u001c:f)\u0019\tYaa\u0019\u0004f!9\u0011\u0011W!A\u0002\u0005U\u0006bBAz\u0003\u0002\u00071q\r\t\u0007\u0003s\u001cIg!\u001c\n\t\r-$Q\u0002\u0002\t\u0013R,'/\u00192mKB!\u0011qFB8\u0013\u0011\u0019\t(!\r\u0003\u0017\u0005\u00137\u000f\u001e:bGRdunZ\u0001\u0014g\u0016$X\u000f\u001d+jKJ\u001cu.\u001c9p]\u0016tGo]\u0001\u000bGJ,\u0017\r^3M_\u001e\u001cH\u0003DB=\u0007\u007f\u001a\tia!\u0004\u0006\u000e\u001d\u0005CBA}\u0007w\u0012y!\u0003\u0003\u0004~\t5!AC%oI\u0016DX\rZ*fc\"9!1O\"A\u0002\u0005u\u0003b\u0002B?\u0007\u0002\u0007\u0011Q\f\u0005\b\u0003\u0003\u001a\u0005\u0019AA#\u0011\u001d\tIc\u0011a\u0001\u0003[Aqa!#D\u0001\u0004\u0019Y)\u0001\u000bm_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\u001c\t\u0005\u0007\u001b\u001bI*\u0004\u0002\u0004\u0010*!\u00111GBI\u0015\u0011\u0019\u0019j!&\u0002\u0013%tG/\u001a:oC2\u001c(bABLG\u000691\u000f^8sC\u001e,\u0017\u0002BBN\u0007\u001f\u0013A\u0003T8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0017AE7pG.\u0014V\r\u001d7jG\u0006l\u0015M\\1hKJ$B!a(\u0004\"\"9\u00111\u001f#A\u0002\r\u001d\u0014AE<sSR,'+Z2pe\u0012\u0014\u0015\r^2iKN$B\"a\u0003\u0004(\u000e%61VB[\u0007sCq!a\rF\u0001\u0004\u0019i\u0007C\u0004\u0004.\u0015\u0003\r!!\u0018\t\u000f\r5V\t1\u0001\u00040\u0006Q!-Y:f\u001f\u001a47/\u001a;\u0011\u0007I\u001b\t,C\u0002\u00044N\u0013A\u0001T8oO\"91qW#A\u0002\u0005u\u0013a\u00022bi\u000eDWm\u001d\u0005\b\u0007w+\u0005\u0019AA/\u0003=\u0011XmY8sIN\u0004VM\u001d\"bi\u000eD\u0017!D2sK\u0006$XMU3d_J$7\u000f\u0006\u0006\u0004B\u000eE7Q\\Bp\u0007C\u0004Baa1\u0004N6\u00111Q\u0019\u0006\u0005\u0007\u000f\u001cI-\u0001\u0004sK\u000e|'\u000f\u001a\u0006\u0004\u0007\u0017\u001c\u0017AB2p[6|g.\u0003\u0003\u0004P\u000e\u0015'!D'f[>\u0014\u0018PU3d_J$7\u000fC\u0004\u0004T\u001a\u0003\ra!6\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B!1q[Bm\u001b\t\u0019I-\u0003\u0003\u0004\\\u000e%'A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0007[1\u0005\u0019AA/\u0011\u001d\u0019iK\u0012a\u0001\u0007_Cqaa9G\u0001\u0004\ti&\u0001\u0006ok6\u0014VmY8sIN\f!\u0003^5feB\u000b'\u000f^5uS>t7\u000b^1uKR!1\u0011^B{!\u0011\u0019Yo!=\u000e\u0005\r5(bABx\u0017\u0006)1\u000f^1uK&!11_Bw\u0005I!\u0016.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3\t\u000f\r]x\t1\u0001\u0004V\u0006I\u0001/\u0019:uSRLwN\\\u0001\tO\u0016$x)Y;hKV!1Q C\u000e)\u0011\u0019y\u0010\"\f\u0011\r\u0011\u0005A1\u0003C\f\u001b\t!\u0019A\u0003\u0003\u0005\u0006\u0011\u001d\u0011\u0001B2pe\u0016TA\u0001\"\u0003\u0005\f\u00059Q.\u001a;sS\u000e\u001c(\u0002\u0002C\u0007\t\u001f\ta!_1n[\u0016\u0014(B\u0001C\t\u0003\r\u0019w.\\\u0005\u0005\t+!\u0019AA\u0003HCV<W\r\u0005\u0003\u0005\u001a\u0011mA\u0002\u0001\u0003\b\t;A%\u0019\u0001C\u0010\u0005\u0005!\u0016\u0003\u0002C\u0011\tO\u00012A\u0015C\u0012\u0013\r!)c\u0015\u0002\b\u001d>$\b.\u001b8h!\r\u0011F\u0011F\u0005\u0004\tW\u0019&aA!os\"9!\u0011\u001b%A\u0002\r=\u0013!\u0004<fe&4\u00170T3ue&\u001c7\u000fK\u0004\u0001\tg\u0011Y\u0010\"\u000f\u0011\t\t\u0005FQG\u0005\u0005\to\u0011\u0019KA\u0002UC\u001e\f#\u0001b\u000f\u0002\u0017%tG/Z4sCRLwN\u001c")
public class TierCompactionIntegrationTest {
    private final MockTime mockTime = new MockTime();
    private final ArrayList<String> logDirs = new ArrayList<String>(Collections.singleton(TestUtils.tempDirectory(null, null).getAbsolutePath()));
    private TierTopicManagerConfig tierTopicManagerConfig;
    private TierTopicConsumer tierTopicConsumer;
    private TierLogComponents tierLogComponents;
    private File tempDir;
    private final int numThreads;
    private final CompactionTasksConfig tierCompactionTaskConfig = new CompactionTasksConfig(120, 0.9, 524288, 0x100000, Double.MAX_VALUE, 300, 0, 0x40000000L);
    private final TierTasksConfig tierTasksConfig;
    private TierTasks tierTasks;
    private ReplicaManager replicaManager;
    private MockInMemoryTierObjectStore tierObjectStore;
    private TierDeletedPartitionsCoordinator tierDeletedPartitionsCoordinator;
    private TierStateFetcher tierStateFetcher;
    private Seq<MergedLog> logs;
    private TierTopicManager tierTopicManager;
    private MockConsumerSupplier<byte[], byte[]> consumerSupplier;
    private final int maxWaitTimeMs;
    private final TierReplicaManager tierReplicaManager;

    private MockTime mockTime() {
        return this.mockTime;
    }

    public ArrayList<String> logDirs() {
        return this.logDirs;
    }

    public TierTopicManagerConfig tierTopicManagerConfig() {
        return this.tierTopicManagerConfig;
    }

    public void tierTopicManagerConfig_$eq(TierTopicManagerConfig x$1) {
        this.tierTopicManagerConfig = x$1;
    }

    public TierTopicConsumer tierTopicConsumer() {
        return this.tierTopicConsumer;
    }

    public void tierTopicConsumer_$eq(TierTopicConsumer x$1) {
        this.tierTopicConsumer = x$1;
    }

    public TierLogComponents tierLogComponents() {
        return this.tierLogComponents;
    }

    public void tierLogComponents_$eq(TierLogComponents x$1) {
        this.tierLogComponents = x$1;
    }

    public File tempDir() {
        return this.tempDir;
    }

    public void tempDir_$eq(File x$1) {
        this.tempDir = x$1;
    }

    public int numThreads() {
        return this.numThreads;
    }

    public CompactionTasksConfig tierCompactionTaskConfig() {
        return this.tierCompactionTaskConfig;
    }

    public TierTasksConfig tierTasksConfig() {
        return this.tierTasksConfig;
    }

    public TierTasks tierTasks() {
        return this.tierTasks;
    }

    public void tierTasks_$eq(TierTasks x$1) {
        this.tierTasks = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public MockInMemoryTierObjectStore tierObjectStore() {
        return this.tierObjectStore;
    }

    public void tierObjectStore_$eq(MockInMemoryTierObjectStore x$1) {
        this.tierObjectStore = x$1;
    }

    public TierDeletedPartitionsCoordinator tierDeletedPartitionsCoordinator() {
        return this.tierDeletedPartitionsCoordinator;
    }

    public void tierDeletedPartitionsCoordinator_$eq(TierDeletedPartitionsCoordinator x$1) {
        this.tierDeletedPartitionsCoordinator = x$1;
    }

    public TierStateFetcher tierStateFetcher() {
        return this.tierStateFetcher;
    }

    public void tierStateFetcher_$eq(TierStateFetcher x$1) {
        this.tierStateFetcher = x$1;
    }

    public Seq<MergedLog> logs() {
        return this.logs;
    }

    public void logs_$eq(Seq<MergedLog> x$1) {
        this.logs = x$1;
    }

    public TierTopicManager tierTopicManager() {
        return this.tierTopicManager;
    }

    public void tierTopicManager_$eq(TierTopicManager x$1) {
        this.tierTopicManager = x$1;
    }

    public MockConsumerSupplier<byte[], byte[]> consumerSupplier() {
        return this.consumerSupplier;
    }

    public void consumerSupplier_$eq(MockConsumerSupplier<byte[], byte[]> x$1) {
        this.consumerSupplier = x$1;
    }

    public int maxWaitTimeMs() {
        return this.maxWaitTimeMs;
    }

    public TierReplicaManager tierReplicaManager() {
        return this.tierReplicaManager;
    }

    public void setup(boolean tierTopicMaterializationFromSnapshotEnable, Integer numCompactLogs, Integer numDeleteLogs) {
        this.tierTopicManagerConfig_$eq(this.createTierTopicManagerConfig(tierTopicMaterializationFromSnapshotEnable));
        this.tierObjectStore_$eq(new MockInMemoryTierObjectStore((Time)this.mockTime(), new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1))));
        this.setupTierComponents();
        int numTotalLogs = Predef$.MODULE$.Integer2int(numCompactLogs) + Predef$.MODULE$.Integer2int(numDeleteLogs);
        File tempDir = TestUtils.tempDirectory(null, null);
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(numTotalLogs);
        this.logs_$eq((Seq<MergedLog>)this.createLogs(Predef$.MODULE$.Integer2int(numCompactLogs), Predef$.MODULE$.Integer2int(numDeleteLogs), tempDir, this.tierLogComponents(), logDirFailureChannel));
        ReplicaManager replicaManager = this.mockReplicaManager((Iterable<AbstractLog>)this.logs());
        Pool logPool = new Pool((Option)None$.MODULE$);
        this.logs().map((Function1 & Serializable)log -> (AbstractLog)logPool.put((Object)log.topicPartition(), log));
        this.tierTasks_$eq(new TierTasks(this.tierTasksConfig(), replicaManager, this.tierReplicaManager(), this.tierDeletedPartitionsCoordinator(), (TierTopicAppender)this.tierTopicManager(), (TierObjectStore)this.tierObjectStore(), (Time)this.mockTime(), (Option)None$.MODULE$));
        this.replicaManager_$eq(replicaManager);
        this.logs_$eq(this.logs());
        this.tempDir_$eq(tempDir);
    }

    public Integer setup$default$2() {
        return Predef$.MODULE$.int2Integer(2);
    }

    public Integer setup$default$3() {
        return Predef$.MODULE$.int2Integer(0);
    }

    @BeforeEach
    public void before() {
        TestUtils$.MODULE$.clearYammerMetrics();
        TestUtils$.MODULE$.verifyNoUnexpectedThreads("@Before");
    }

    @AfterEach
    public void teardown() {
        this.tierTasks().shutdown();
        this.tierTopicManager().shutdown();
        this.tierTopicConsumer().shutdown();
        ReplicaManager qual$1 = this.replicaManager();
        boolean x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        this.tierObjectStore().close();
        this.logs().foreach((Function1 & Serializable)x$11 -> {
            x$11.close();
            return BoxedUnit.UNIT;
        });
        CollectionConverters$.MODULE$.ListHasAsScala(this.logDirs()).asScala().foreach((Function1 & Serializable)path -> {
            TierCompactionIntegrationTest.$anonfun$teardown$2(path);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.verifyNoUnexpectedThreads("@After");
        TestUtils$.MODULE$.clearYammerMetrics();
        Mockito.framework().clearInlineMocks();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.tierTopicMaterializationFromSnapshot={0}")
    @ValueSource(booleans={true, false})
    public void testCompactionImmigrate(boolean tierTopicMaterializationFromSnapshotEnable) {
        this.setup(tierTopicMaterializationFromSnapshotEnable, this.setup$default$2(), this.setup$default$3());
        this.tierTasks().start();
        this.waitForImmigration(this.logs(), 1, this.tierTasks(), this.consumerSupplier(), true);
        this.tierReplicaManager().becomeFollower(this.tierPartitionState(((MergedLog)this.logs().head()).topicPartition()));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 2000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierCompactionIntegrationTest.$anonfun$testCompactionImmigrate$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Tier Log Cleaner Manager should process pending emigrations");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.tierReplicaManager().becomeLeader(this.tierPartitionState(((MergedLog)this.logs().head()).topicPartition()), 2);
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 2000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierCompactionIntegrationTest.$anonfun$testCompactionImmigrate$4(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Tier Log Cleaner Manager should process pending immigrations");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Disabled(value="KSTORAGE-2000")
    @ParameterizedTest(name="{displayName}.tierTopicMaterializationFromSnapshot={0}")
    @ValueSource(booleans={true, false})
    public void testCompactAndDeleteCleanupPolicies(boolean tierTopicMaterializationFromSnapshotEnable) {
        void materializeUntilTrue_consumerSupplier;
        void materializeUntilTrue_consumerSupplier2;
        void materializeUntilTrue_consumerSupplier3;
        void materializeUntilTrue_consumerSupplier4;
        int numCompactLogs = 10;
        int numDeleteLogs = 10;
        this.setup(tierTopicMaterializationFromSnapshotEnable, Predef$.MODULE$.int2Integer(numCompactLogs), Predef$.MODULE$.int2Integer(numDeleteLogs));
        this.tierTasks().start();
        int leaderEpoch = 1;
        this.logs().foreach((Function1 & Serializable)log -> {
            this.writeRecordBatches((AbstractLog)log, leaderEpoch, 0L, 6, 4);
            return BoxedUnit.UNIT;
        });
        this.waitForImmigration(this.logs(), leaderEpoch, this.tierTasks(), this.consumerSupplier(), true);
        this.logs().foreach((Function1 & Serializable)log -> {
            TierCompactionIntegrationTest.$anonfun$testCompactAndDeleteCleanupPolicies$2(leaderEpoch, log);
            return BoxedUnit.UNIT;
        });
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier = this.consumerSupplier();
        String string = "Should have materialized at least two segments";
        JFunction0.mcZ.sp & Serializable materializeUntilTrue_pred = (JFunction0.mcZ.sp & Serializable)() -> this.logs().forall((Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)TierCompactionIntegrationTest.$anonfun$testCompactAndDeleteCleanupPolicies$4(log)));
        long l = 100L;
        long materializeUntilTrue_waitUntilTrue_waitTimeMs = this.maxWaitTimeMs();
        long materializeUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierCompactionIntegrationTest.$anonfun$materializeUntilTrue$1(this, (MockConsumerSupplier)materializeUntilTrue_consumerSupplier4, (Function0)materializeUntilTrue_pred)) {
            void materializeUntilTrue_waitUntilTrue_pause;
            if (System.currentTimeMillis() > materializeUntilTrue_waitUntilTrue_startTime + materializeUntilTrue_waitUntilTrue_waitTimeMs) {
                void materializeUntilTrue_msg;
                Assertions.fail((String)materializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(materializeUntilTrue_waitUntilTrue_waitTimeMs), (long)materializeUntilTrue_waitUntilTrue_pause));
        }
        Object var5_7 = null;
        string = null;
        mockConsumerSupplier = null;
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier2 = this.consumerSupplier();
        String string2 = "Archiver should have tasks for all logs";
        JFunction0.mcZ.sp & Serializable materializeUntilTrue_pred2 = (JFunction0.mcZ.sp & Serializable)() -> BoxesRunTime.unboxToBoolean((Object)this.tierTasks().archiverTaskQueue().withAllTasks((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)TierCompactionIntegrationTest.$anonfun$testCompactAndDeleteCleanupPolicies$6(numCompactLogs, numDeleteLogs, x$14))));
        long l2 = 100L;
        long materializeUntilTrue_waitUntilTrue_waitTimeMs2 = this.maxWaitTimeMs();
        long materializeUntilTrue_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierCompactionIntegrationTest.$anonfun$materializeUntilTrue$1(this, (MockConsumerSupplier)materializeUntilTrue_consumerSupplier3, (Function0)materializeUntilTrue_pred2)) {
            void materializeUntilTrue_waitUntilTrue_pause;
            if (System.currentTimeMillis() > materializeUntilTrue_waitUntilTrue_startTime2 + materializeUntilTrue_waitUntilTrue_waitTimeMs2) {
                void materializeUntilTrue_msg;
                Assertions.fail((String)materializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(materializeUntilTrue_waitUntilTrue_waitTimeMs2), (long)materializeUntilTrue_waitUntilTrue_pause));
        }
        Object var14_13 = null;
        string2 = null;
        mockConsumerSupplier2 = null;
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier3 = this.consumerSupplier();
        String string3 = "Tier Log Cleaner Manager should have tasks for all logs, though not all will be scheduled";
        JFunction0.mcZ.sp & Serializable materializeUntilTrue_pred3 = (JFunction0.mcZ.sp & Serializable)() -> BoxesRunTime.unboxToBoolean((Object)((TierTaskQueue)this.tierTasks().compactionTaskQueue().get()).withAllTasks((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)TierCompactionIntegrationTest.$anonfun$testCompactAndDeleteCleanupPolicies$8(numCompactLogs, numDeleteLogs, x$15))));
        long l3 = 100L;
        long materializeUntilTrue_waitUntilTrue_waitTimeMs3 = this.maxWaitTimeMs();
        long materializeUntilTrue_waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!TierCompactionIntegrationTest.$anonfun$materializeUntilTrue$1(this, (MockConsumerSupplier)materializeUntilTrue_consumerSupplier2, (Function0)materializeUntilTrue_pred3)) {
            void materializeUntilTrue_waitUntilTrue_pause;
            if (System.currentTimeMillis() > materializeUntilTrue_waitUntilTrue_startTime3 + materializeUntilTrue_waitUntilTrue_waitTimeMs3) {
                void materializeUntilTrue_msg;
                Assertions.fail((String)materializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(materializeUntilTrue_waitUntilTrue_waitTimeMs3), (long)materializeUntilTrue_waitUntilTrue_pause));
        }
        Object var23_19 = null;
        string3 = null;
        mockConsumerSupplier3 = null;
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier4 = this.consumerSupplier();
        String string4 = "Tier Log Cleaner Manager should have found all of the compactable tasks did compact";
        JFunction0.mcZ.sp & Serializable materializeUntilTrue_pred4 = (JFunction0.mcZ.sp & Serializable)() -> BoxesRunTime.unboxToInt((Object)((TierTaskQueue)this.tierTasks().compactionTaskQueue().get()).withAllTasks((Function1 & Serializable)x$16 -> BoxesRunTime.boxToInteger((int)TierCompactionIntegrationTest.$anonfun$testCompactAndDeleteCleanupPolicies$10(x$16)))) == numCompactLogs;
        long l4 = 100L;
        long materializeUntilTrue_waitUntilTrue_waitTimeMs4 = this.maxWaitTimeMs();
        long materializeUntilTrue_waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!TierCompactionIntegrationTest.$anonfun$materializeUntilTrue$1(this, (MockConsumerSupplier)materializeUntilTrue_consumerSupplier, (Function0)materializeUntilTrue_pred4)) {
            void materializeUntilTrue_waitUntilTrue_pause;
            if (System.currentTimeMillis() > materializeUntilTrue_waitUntilTrue_startTime4 + materializeUntilTrue_waitUntilTrue_waitTimeMs4) {
                void materializeUntilTrue_msg;
                Assertions.fail((String)materializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(materializeUntilTrue_waitUntilTrue_waitTimeMs4), (long)materializeUntilTrue_waitUntilTrue_pause));
        }
        Object var32_25 = null;
        string4 = null;
        mockConsumerSupplier4 = null;
        ((TierTaskQueue)this.tierTasks().compactionTaskQueue().get()).poll();
        this.verifyMetrics();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.tierTopicMaterializationFromSnapshot={0}")
    @ValueSource(booleans={true, false})
    public void testTierAndCompact(boolean tierTopicMaterializationFromSnapshotEnable) {
        void materializeUntilTrue_consumerSupplier;
        void materializeUntilTrue_consumerSupplier2;
        this.setup(tierTopicMaterializationFromSnapshotEnable, Predef$.MODULE$.int2Integer(10), this.setup$default$3());
        this.tierTasks().start();
        ((ThreadPoolExecutor)this.tierTasks().cleaningExecutor()).prestartAllCoreThreads();
        int numBatches = 6;
        int leaderEpoch = 1;
        this.logs().foreach((Function1 & Serializable)log -> {
            this.writeRecordBatches((AbstractLog)log, leaderEpoch, 0L, numBatches, 4);
            return BoxedUnit.UNIT;
        });
        this.waitForImmigration(this.logs(), leaderEpoch, this.tierTasks(), this.consumerSupplier(), true);
        this.logs().foreach((Function1 & Serializable)log -> {
            TierCompactionIntegrationTest.$anonfun$testTierAndCompact$2(leaderEpoch, log);
            return BoxedUnit.UNIT;
        });
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier = this.consumerSupplier();
        String string = "Should have materialized at least two segments";
        JFunction0.mcZ.sp & Serializable materializeUntilTrue_pred = (JFunction0.mcZ.sp & Serializable)() -> this.logs().forall((Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)TierCompactionIntegrationTest.$anonfun$testTierAndCompact$4(log)));
        long l = 100L;
        long materializeUntilTrue_waitUntilTrue_waitTimeMs = this.maxWaitTimeMs();
        long materializeUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierCompactionIntegrationTest.$anonfun$materializeUntilTrue$1(this, (MockConsumerSupplier)materializeUntilTrue_consumerSupplier2, (Function0)materializeUntilTrue_pred)) {
            void materializeUntilTrue_waitUntilTrue_pause;
            if (System.currentTimeMillis() > materializeUntilTrue_waitUntilTrue_startTime + materializeUntilTrue_waitUntilTrue_waitTimeMs) {
                void materializeUntilTrue_msg;
                Assertions.fail((String)materializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(materializeUntilTrue_waitUntilTrue_waitTimeMs), (long)materializeUntilTrue_waitUntilTrue_pause));
        }
        Object var4_6 = null;
        string = null;
        mockConsumerSupplier = null;
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        Assertions.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)this.getGauge("compaction-cpu-utilization-percent").value()), (String)"The first call to CPU stats should return 0 as we do not have reference values");
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier2 = this.consumerSupplier();
        String string2 = "Should also eventually compact down to one segment each";
        JFunction0.mcZ.sp & Serializable materializeUntilTrue_pred2 = (JFunction0.mcZ.sp & Serializable)() -> this.logs().forall((Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)TierCompactionIntegrationTest.$anonfun$testTierAndCompact$6(log)));
        long l2 = 100L;
        long materializeUntilTrue_waitUntilTrue_waitTimeMs2 = this.maxWaitTimeMs();
        long materializeUntilTrue_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierCompactionIntegrationTest.$anonfun$materializeUntilTrue$1(this, (MockConsumerSupplier)materializeUntilTrue_consumerSupplier, (Function0)materializeUntilTrue_pred2)) {
            void materializeUntilTrue_waitUntilTrue_pause;
            if (System.currentTimeMillis() > materializeUntilTrue_waitUntilTrue_startTime2 + materializeUntilTrue_waitUntilTrue_waitTimeMs2) {
                void materializeUntilTrue_msg;
                Assertions.fail((String)materializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(materializeUntilTrue_waitUntilTrue_waitTimeMs2), (long)materializeUntilTrue_waitUntilTrue_pause));
        }
        Object var13_12 = null;
        string2 = null;
        mockConsumerSupplier2 = null;
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        ((TierTaskQueue)this.tierTasks().compactionTaskQueue().get()).poll();
        Assertions.assertNotEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)this.getGauge("compaction-cpu-utilization-percent").value()), (String)"The subsequents calls to CPU stats metric after some valid cleanup should return a non-zero value");
        this.verifyMetrics();
    }

    @ParameterizedTest(name="{displayName}.tierTopicMaterializationFromSnapshot={0}")
    @ValueSource(booleans={true, false})
    public void testTierTasksConfigUpdate(boolean tierTopicMaterializationFromSnapshotEnable) {
        this.setup(tierTopicMaterializationFromSnapshotEnable, this.setup$default$2(), this.setup$default$3());
        Assertions.assertEquals((int)this.tierTasksConfig().numCleanerThreads(), (int)((ThreadPoolExecutor)this.tierTasks().cleaningExecutor()).getCorePoolSize());
        Assertions.assertEquals((Object)this.tierTasksConfig(), (Object)((TierLogCleanerManager)this.tierTasks().tierLogCleanerManager().get()).config());
        CompactionTasksConfig newCompactionTasksConfig = new CompactionTasksConfig(240, 0.9, 0x100000, 0x100000, Double.MAX_VALUE, 300, 0, 0x40000000L);
        int x$1 = this.tierTasksConfig().numCleanerThreads();
        int x$2 = this.tierTasksConfig().numCleanerThreads() + 2;
        int x$3 = this.tierTasksConfig().numSnapshotThreads();
        int x$4 = this.tierTasksConfig().brokerId();
        int x$5 = this.tierTasksConfig().maxRetryBackoffMs();
        boolean x$6 = this.tierTasksConfig().tierCleanerFeatureEnable();
        Some x$7 = new Some((Object)newCompactionTasksConfig);
        long x$8 = 600000L;
        long x$9 = 500L;
        int x$10 = 50;
        boolean x$11 = false;
        None$ x$12 = None$.MODULE$;
        TierTasksConfig newTierTasksConfig = new TierTasksConfig(x$1, x$2, x$3, x$4, x$8, x$9, x$10, x$5, x$6, x$11, (Option)x$7, (Option)x$12);
        this.tierTasks().reconfigure(this.tierTasksConfig(), newTierTasksConfig);
        Assertions.assertEquals((Object)newTierTasksConfig, (Object)((TierLogCleanerManager)this.tierTasks().tierLogCleanerManager().get()).config());
        Assertions.assertEquals((int)(this.tierTasksConfig().numCleanerThreads() + 2), (int)((ThreadPoolExecutor)this.tierTasks().cleaningExecutor()).getCorePoolSize());
    }

    private TierTopicManagerConfig createTierTopicManagerConfig(boolean tierTopicMaterializationFromSnapshotEnable) {
        return new TierTopicManagerConfig(() -> Collections.singletonMap("bootstrap.servers", "bootstrap"), null, (short)1, (short)1, 33, "cluster99", Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.int2Integer(500), Predef$.MODULE$.int2Integer(500), Predef$.MODULE$.long2Long(-1L), this.logDirs(), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicProducerEnableIdempotence()), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicDataLossDetectionEnable()), Defaults$.MODULE$.TierTopicDataLossDetectionMaxTimeoutMs(), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicFencingDuringDataLossEnable()), Predef$.MODULE$.boolean2Boolean(tierTopicMaterializationFromSnapshotEnable));
    }

    /*
     * WARNING - void declaration
     */
    private void waitForImmigration(Seq<MergedLog> logs, int leaderEpoch, TierTasks tierTasks, MockConsumerSupplier<byte[], byte[]> consumerSupplier, boolean becomeLeader) {
        if (becomeLeader) {
            logs.foreach((Function1 & Serializable)log -> {
                TierCompactionIntegrationTest.$anonfun$waitForImmigration$1(this, leaderEpoch, log);
                return BoxedUnit.UNIT;
            });
        }
        String string = "Expect leadership to materialize";
        JFunction0.mcZ.sp & Serializable materializeUntilTrue_pred = (JFunction0.mcZ.sp & Serializable)() -> logs.forall((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)TierCompactionIntegrationTest.$anonfun$waitForImmigration$3(x$18)));
        long l = 100L;
        long materializeUntilTrue_waitUntilTrue_waitTimeMs = this.maxWaitTimeMs();
        long materializeUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierCompactionIntegrationTest.$anonfun$materializeUntilTrue$1(this, consumerSupplier, (Function0)materializeUntilTrue_pred)) {
            void materializeUntilTrue_waitUntilTrue_pause;
            if (System.currentTimeMillis() > materializeUntilTrue_waitUntilTrue_startTime + materializeUntilTrue_waitUntilTrue_waitTimeMs) {
                void materializeUntilTrue_msg;
                Assertions.fail((String)materializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(materializeUntilTrue_waitUntilTrue_waitTimeMs), (long)materializeUntilTrue_waitUntilTrue_pause));
        }
        Object var6_7 = null;
        string = null;
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierCompactionIntegrationTest.$anonfun$waitForImmigration$4(this, consumerSupplier, tierTasks, logs)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierCompactionIntegrationTest.$anonfun$waitForImmigration$7(tierTasks));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private boolean waitForImmigration$default$5() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void materializeUntilTrue(Function0<Object> pred, String msg, MockConsumerSupplier<byte[], byte[]> consumerSupplier) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = this.maxWaitTimeMs();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierCompactionIntegrationTest.$anonfun$materializeUntilTrue$1(this, consumerSupplier, pred)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void validatePartitionStateContainedInObjectStore(MockInMemoryTierObjectStore tierObjectStore, Iterable<AbstractLog> logs) {
        logs.foreach((Function1 & Serializable)log -> {
            TierCompactionIntegrationTest.$anonfun$validatePartitionStateContainedInObjectStore$1(tierObjectStore, log);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private void setupTierComponents() {
        String tierTopicName = TierTopic.topicName((String)this.tierTopicManagerConfig().tierNamespace);
        MockProducerSupplier producerSupplier = new MockProducerSupplier();
        this.consumerSupplier_$eq(new MockConsumerSupplier<byte[], byte[]>("primary", TierTopicManager.partitions((String)tierTopicName, (int)this.tierTopicManagerConfig().configuredNumPartitions), producerSupplier.producer()));
        InternalAdmin internalAdmin = (InternalAdmin)Mockito.mock(InternalAdmin.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)internalAdmin.ensureTopic((String)ArgumentMatchers.eq((Object)tierTopicName), ArgumentMatchers.eq((int)this.tierTopicManagerConfig().configuredNumPartitions), ArgumentMatchers.eq((short)this.tierTopicManagerConfig().configuredReplicationFactor), (Properties)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToInteger((int)Short$.MODULE$.short2int(this.tierTopicManagerConfig().configuredNumPartitions)));
        this.tierTopicConsumer_$eq(new TierTopicConsumer(this.tierTopicManagerConfig(), this.consumerSupplier(), this.consumerSupplier(), this.consumerSupplier(), new TierTopicManagerCommitter(this.tierTopicManagerConfig(), (LogDirFailureChannel)Mockito.mock(LogDirFailureChannel.class)), this.tierStateFetcher(), Optional.empty(), (Time)this.mockTime()));
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        TierTopic tierTopic = new TierTopic(this.tierTopicManagerConfig().tierNamespace);
        TierObjectStore tierObjectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
        TierTopicDataLossValidator tierTopicDataLossValidator = new TierTopicDataLossValidator(this.tierTopicManagerConfig(), tierTopic, tierObjectStore, replicaManager, (Supplier)new Supplier<ConfluentAdmin>(null){

            public ConfluentAdmin get() {
                return (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
            }
        }, (LeaderEndpointSupplier)Mockito.mock(LeaderEndpointSupplier.class), (Time)this.mockTime(), (Metrics)Mockito.mock(Metrics.class));
        this.tierTopicManager_$eq(new TierTopicManager(this.tierTopicManagerConfig(), tierTopic, this.tierTopicConsumer(), producerSupplier, () -> internalAdmin, tierTopicDataLossValidator));
        this.tierLogComponents_$eq(new TierLogComponents((Option)new Some((Object)this.tierTopicConsumer()), (Option)new Some((Object)tierObjectStore), new TierPartitionStateFactory(true, false, true, new TierPartitionStateCleanupConfig(true, Defaults$.MODULE$.TierPartitionStateCleanupDelayMs(), 0L), false, -1), (Option)None$.MODULE$));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierCompactionIntegrationTest.$anonfun$setupTierComponents$2(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for TierTopicManager to be ready");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private IndexedSeq<MergedLog> createLogs(int numCompactLogs, int numDeleteLogs, File tempDir, TierLogComponents tierLogComponents, LogDirFailureChannel logDirFailureChannel) {
        int segmentBytes = 150;
        int indexIntervalBytes = 1;
        int maxMessageBytes = 65536;
        long x$6 = 604800000L;
        long x$7 = 604800000L;
        long x$8 = -2L;
        long x$9 = -1L;
        long x$10 = -2L;
        long x$11 = 0L;
        int x$12 = 0xA00000;
        String x$13 = LogConfig.DEFAULT_MESSAGE_FORMAT_VERSION;
        long x$14 = 60000L;
        long x$15 = -1L;
        long x$16 = 86400000L;
        int x$17 = 0x6400000;
        long x$18 = -1L;
        boolean x$19 = true;
        long x$20 = 1L;
        long x$21 = Long.MAX_VALUE;
        boolean x$22 = false;
        LogConfig compactLogConfig = LogTestUtils$.MODULE$.createLogConfig(x$6, segmentBytes, x$7, x$8, x$9, x$10, x$11, "compact", maxMessageBytes, indexIntervalBytes, x$12, x$13, x$14, true, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22);
        long x$28 = 604800000L;
        long x$29 = 604800000L;
        long x$30 = -2L;
        long x$31 = -1L;
        long x$32 = -2L;
        long x$33 = 0L;
        int x$34 = 0xA00000;
        String x$35 = LogConfig.DEFAULT_MESSAGE_FORMAT_VERSION;
        long x$36 = 60000L;
        long x$37 = -1L;
        long x$38 = 86400000L;
        int x$39 = 0x6400000;
        long x$40 = -1L;
        boolean x$41 = true;
        long x$42 = 1L;
        long x$43 = Long.MAX_VALUE;
        boolean x$44 = false;
        LogConfig deleteLogConfig = LogTestUtils$.MODULE$.createLogConfig(x$28, segmentBytes, x$29, x$30, x$31, x$32, x$33, "delete", maxMessageBytes, indexIntervalBytes, x$34, x$35, x$36, true, x$37, x$38, x$39, x$40, x$41, x$42, x$43, x$44);
        IndexedSeq compactLogs = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numCompactLogs).map((Function1 & Serializable)i -> TierCompactionIntegrationTest.$anonfun$createLogs$1(this, tempDir, compactLogConfig, logDirFailureChannel, tierLogComponents, BoxesRunTime.unboxToInt((Object)i)));
        IndexedSeq deleteLogs = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numDeleteLogs).map((Function1 & Serializable)i -> TierCompactionIntegrationTest.$anonfun$createLogs$2(this, tempDir, deleteLogConfig, logDirFailureChannel, tierLogComponents, BoxesRunTime.unboxToInt((Object)i)));
        return (IndexedSeq)compactLogs.$plus$plus((IterableOnce)deleteLogs);
    }

    private ReplicaManager mockReplicaManager(Iterable<AbstractLog> logs) {
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.time()).thenReturn((Object)new MockTime());
        Mockito.when((Object)replicaManager.getLog((TopicPartition)ArgumentMatchers.any(TopicPartition.class))).thenAnswer((Answer)new Answer<Option<AbstractLog>>(null, logs){
            private final Iterable logs$2;

            public Option<AbstractLog> answer(InvocationOnMock invocation) {
                TopicPartition target = (TopicPartition)invocation.getArgument(0);
                return this.logs$2.find((Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)$anon$2.$anonfun$answer$1(target, log)));
            }

            public static final /* synthetic */ boolean $anonfun$answer$1(TopicPartition target$1, AbstractLog log) {
                TopicPartition topicPartition = log.topicPartition();
                return !(topicPartition != null ? !topicPartition.equals(target$1) : target$1 != null);
            }
            {
                this.logs$2 = logs$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$answer$1$adapted(org.apache.kafka.common.TopicPartition kafka.log.AbstractLog )}, serializedLambda);
            }
        });
        Iterable partitions = (Iterable)logs.map((Function1 & Serializable)log -> {
            Partition partition = (Partition)Mockito.mock(Partition.class);
            Mockito.when((Object)partition.log()).thenReturn((Object)new Some(log));
            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
            Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
            Mockito.when((Object)replicaManager.getPartitionOrError(log.topicPartition())).thenReturn((Object)package$.MODULE$.Right().apply((Object)partition));
            return partition;
        });
        Mockito.when((Object)replicaManager.leaderPartitionsIterator()).thenAnswer(x$20 -> partitions.iterator());
        return replicaManager;
    }

    private void writeRecordBatches(AbstractLog log, int leaderEpoch, long baseOffset, int batches, int recordsPerBatch) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), batches).foreach((Function1 & Serializable)idx -> TierCompactionIntegrationTest.$anonfun$writeRecordBatches$1(this, log, leaderEpoch, baseOffset, recordsPerBatch, BoxesRunTime.unboxToInt((Object)idx)));
        log.flush(false);
        log.updateHighWatermark((long)(batches * recordsPerBatch));
    }

    private MemoryRecords createRecords(TopicPartition topicPartition, int leaderEpoch, long baseOffset, int numRecords) {
        IndexedSeq recList = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable)x$21 -> TierCompactionIntegrationTest.$anonfun$createRecords$1(BoxesRunTime.unboxToInt((Object)x$21)));
        byte x$3 = 2;
        CompressionType x$4 = CompressionType.NONE;
        long x$5 = -1L;
        short x$6 = -1;
        int x$7 = -1;
        int x$8 = -1;
        MemoryRecords records = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)recList, x$3, x$4, x$5, x$6, x$7, baseOffset, x$8);
        ByteBuffer filtered = ByteBuffer.allocate(100 * numRecords);
        CollectionConverters$.MODULE$.IterableHasAsScala(records.batches()).asScala().foreach((Function1 & Serializable)x$22 -> {
            x$22.setPartitionLeaderEpoch(leaderEpoch);
            return BoxedUnit.UNIT;
        });
        records.filterTo(topicPartition, new MemoryRecords.RecordFilter(null){

            public MemoryRecords.RecordFilter.BatchRetentionResult checkBatchRetention(RecordBatch batch) {
                return new MemoryRecords.RecordFilter.BatchRetentionResult(MemoryRecords.RecordFilter.BatchRetention.DELETE_EMPTY, false);
            }

            public boolean shouldRetainRecord(RecordBatch recordBatch, Record record) {
                return true;
            }
        }, filtered, Integer.MAX_VALUE, BufferSupplier.NO_CACHING);
        filtered.flip();
        return new MemoryRecords(filtered);
    }

    private TierPartitionState tierPartitionState(TopicPartition partition) {
        return (TierPartitionState)this.logs().find((Function1 & Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)TierCompactionIntegrationTest.$anonfun$tierPartitionState$1(partition, x$23))).map((Function1 & Serializable)x$24 -> x$24.tierPartitionState()).get();
    }

    private <T> Gauge<T> getGauge(String name) {
        Map allMetrics = KafkaYammerMetrics.defaultRegistry().allMetrics();
        MetricName metricName = allMetrics.keySet().stream().filter(m -> {
            String string = m.getName();
            return !(string != null ? !string.equals(name) : name != null);
        }).findFirst().get();
        return (Gauge)allMetrics.get(metricName);
    }

    private void verifyMetrics() {
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierCompactionIntegrationTest.$anonfun$verifyMetrics$3(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierCompactionIntegrationTest.$anonfun$verifyMetrics$4(this));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ void $anonfun$teardown$2(String path) {
        Utils.delete((File)new File(path), (boolean)false);
    }

    public static final /* synthetic */ boolean $anonfun$testCompactionImmigrate$2(Set x$12) {
        return x$12.size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testCompactionImmigrate$1(TierCompactionIntegrationTest $this) {
        return BoxesRunTime.unboxToBoolean((Object)((TierTaskQueue)$this.tierTasks().compactionTaskQueue().get()).withAllTasks((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)TierCompactionIntegrationTest.$anonfun$testCompactionImmigrate$2(x$12))));
    }

    public static final /* synthetic */ String $anonfun$testCompactionImmigrate$3() {
        return "Tier Log Cleaner Manager should process pending emigrations";
    }

    public static final /* synthetic */ boolean $anonfun$testCompactionImmigrate$5(Set x$13) {
        return x$13.size() == 2;
    }

    public static final /* synthetic */ boolean $anonfun$testCompactionImmigrate$4(TierCompactionIntegrationTest $this) {
        $this.consumerSupplier().moveRecordsFromProducer();
        $this.tierTopicConsumer().doWork();
        return BoxesRunTime.unboxToBoolean((Object)((TierTaskQueue)$this.tierTasks().compactionTaskQueue().get()).withAllTasks((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)TierCompactionIntegrationTest.$anonfun$testCompactionImmigrate$5(x$13))));
    }

    public static final /* synthetic */ String $anonfun$testCompactionImmigrate$6() {
        return "Tier Log Cleaner Manager should process pending immigrations";
    }

    public static final /* synthetic */ void $anonfun$testCompactAndDeleteCleanupPolicies$2(int leaderEpoch$1, MergedLog log) {
        String tierPartitionStateStr = log.tierPartitionState().toString();
        Assertions.assertEquals((int)log.tierPartitionState().tierEpoch(), (int)leaderEpoch$1, (String)new StringBuilder(55).append("topic manager should materialize entry with epoch ").append(leaderEpoch$1).append(" for ").append(tierPartitionStateStr).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testCompactAndDeleteCleanupPolicies$4(MergedLog log) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        if (tierPartitionState.numSegments() >= 2) {
            tierPartitionState.flush();
            return true;
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testCompactAndDeleteCleanupPolicies$6(int numCompactLogs$1, int numDeleteLogs$1, Set x$14) {
        return x$14.size() == numCompactLogs$1 + numDeleteLogs$1;
    }

    public static final /* synthetic */ boolean $anonfun$testCompactAndDeleteCleanupPolicies$8(int numCompactLogs$1, int numDeleteLogs$1, Set x$15) {
        return x$15.size() == numCompactLogs$1 + numDeleteLogs$1;
    }

    public static final /* synthetic */ boolean $anonfun$testCompactAndDeleteCleanupPolicies$11(CompactionTask t) {
        return BoxesRunTime.unboxToLong((Object)t.state().cleanerStats().map((Function1 & Serializable)x$17 -> BoxesRunTime.boxToLong((long)x$17.bytesRead())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)) > 0L;
    }

    public static final /* synthetic */ int $anonfun$testCompactAndDeleteCleanupPolicies$10(Set x$16) {
        return x$16.toList().count((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)TierCompactionIntegrationTest.$anonfun$testCompactAndDeleteCleanupPolicies$11(t)));
    }

    public static final /* synthetic */ void $anonfun$testTierAndCompact$2(int leaderEpoch$2, MergedLog log) {
        String tierPartitionStateStr = log.tierPartitionState().toString();
        Assertions.assertEquals((int)log.tierPartitionState().tierEpoch(), (int)leaderEpoch$2, (String)new StringBuilder(55).append("topic manager should materialize entry with epoch ").append(leaderEpoch$2).append(" for ").append(tierPartitionStateStr).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testTierAndCompact$4(MergedLog log) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        tierPartitionState.flush();
        return tierPartitionState.numSegments() >= 2 && tierPartitionState.committedEndOffset() == tierPartitionState.endOffset() && tierPartitionState.endOffset() >= 10L;
    }

    public static final /* synthetic */ boolean $anonfun$testTierAndCompact$6(MergedLog log) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        tierPartitionState.flush();
        return log.tierableLogSegments().isEmpty() && tierPartitionState.numSegments() == 1;
    }

    public static final /* synthetic */ void $anonfun$waitForImmigration$1(TierCompactionIntegrationTest $this, int leaderEpoch$3, MergedLog log) {
        TopicIdPartition topicIdPartition = new TopicIdPartition(log.topicPartition().topic(), UUID.randomUUID(), log.topicPartition().partition());
        log.assignTopicId(topicIdPartition.kafkaTopicId(), log.assignTopicId$default$2());
        $this.tierReplicaManager().becomeLeader(log.tierPartitionState(), leaderEpoch$3);
    }

    public static final /* synthetic */ boolean $anonfun$waitForImmigration$3(MergedLog x$18) {
        TierPartitionStatus tierPartitionStatus = x$18.tierPartitionState().status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$waitForImmigration$6(ArchiveTask x$19) {
        return !(x$19.state() instanceof BeforeLeader);
    }

    public static final /* synthetic */ boolean $anonfun$waitForImmigration$5(Seq logs$1, Set tasks) {
        return tasks.size() == logs$1.size() && tasks.forall((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)TierCompactionIntegrationTest.$anonfun$waitForImmigration$6(x$19)));
    }

    public static final /* synthetic */ boolean $anonfun$waitForImmigration$4(TierCompactionIntegrationTest $this, MockConsumerSupplier consumerSupplier$1, TierTasks tierTasks$1, Seq logs$1) {
        consumerSupplier$1.moveRecordsFromProducer();
        $this.tierTopicConsumer().doWork();
        return BoxesRunTime.unboxToBoolean((Object)tierTasks$1.archiverTaskQueue().withAllTasks((Function1 & Serializable)tasks -> BoxesRunTime.boxToBoolean((boolean)TierCompactionIntegrationTest.$anonfun$waitForImmigration$5(logs$1, tasks))));
    }

    public static final /* synthetic */ String $anonfun$waitForImmigration$7(TierTasks tierTasks$1) {
        return new StringBuilder(28).append("Expect zero BeforeLeader in ").append(tierTasks$1.archiverTaskQueue()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$materializeUntilTrue$1(TierCompactionIntegrationTest $this, MockConsumerSupplier consumerSupplier$2, Function0 pred$1) {
        consumerSupplier$2.moveRecordsFromProducer();
        $this.tierTopicConsumer().doWork();
        return pred$1.apply$mcZ$sp();
    }

    public static final /* synthetic */ String $anonfun$materializeUntilTrue$2(String msg$1) {
        return msg$1;
    }

    public static final /* synthetic */ void $anonfun$validatePartitionStateContainedInObjectStore$2(MockInMemoryTierObjectStore tierObjectStore$1, TierLogSegment seg) {
        Assertions.assertNotNull((Object)tierObjectStore$1.getObjectStoreFragment((ObjectStoreMetadata)seg.metadata(), FragmentType.SEGMENT, Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.long2Long(1000L)));
    }

    public static final /* synthetic */ void $anonfun$validatePartitionStateContainedInObjectStore$1(MockInMemoryTierObjectStore tierObjectStore$1, AbstractLog log) {
        CollectionConverters$.MODULE$.IteratorHasAsScala(log.tierPartitionState().segments()).asScala().foreach((Function1 & Serializable)seg -> {
            TierCompactionIntegrationTest.$anonfun$validatePartitionStateContainedInObjectStore$2(tierObjectStore$1, seg);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$setupTierComponents$2(TierCompactionIntegrationTest $this) {
        $this.tierTopicManager().tryBecomeReady(false);
        return $this.tierTopicManager().isReadyForWrites();
    }

    public static final /* synthetic */ String $anonfun$setupTierComponents$3() {
        return "Timed out waiting for TierTopicManager to be ready";
    }

    public static final /* synthetic */ MergedLog $anonfun$createLogs$1(TierCompactionIntegrationTest $this, File tempDir$1, LogConfig compactLogConfig$1, LogDirFailureChannel logDirFailureChannel$1, TierLogComponents tierLogComponents$1, int i) {
        File logDir = tempDir$1.toPath().resolve(new StringBuilder(19).append("tierCompactLogTest-").append(i).toString()).toFile();
        logDir.mkdir();
        MockScheduler x$49 = $this.mockTime().scheduler;
        BrokerTopicStats x$50 = new BrokerTopicStats();
        Metrics x$51 = new Metrics();
        MockTime x$52 = $this.mockTime();
        ProducerStateManagerConfig x$54 = new ProducerStateManagerConfig(3600000, false);
        None$ x$56 = None$.MODULE$;
        None$ x$60 = None$.MODULE$;
        None$ x$62 = None$.MODULE$;
        ChecksumParams x$63 = ChecksumParams.EMPTY;
        LogOffsetsListener x$64 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        ConcurrentHashMap x$65 = new ConcurrentHashMap();
        return MergedLog$.MODULE$.apply(logDir, compactLogConfig$1, 0L, 0L, (Scheduler)x$49, x$50, x$51, (Time)x$52, 300000, x$54, 600000, (Option)x$56, logDirFailureChannel$1, tierLogComponents$1, true, (Option)x$60, true, x$64, (Option)x$62, x$65, x$63);
    }

    public static final /* synthetic */ MergedLog $anonfun$createLogs$2(TierCompactionIntegrationTest $this, File tempDir$1, LogConfig deleteLogConfig$1, LogDirFailureChannel logDirFailureChannel$1, TierLogComponents tierLogComponents$1, int i) {
        File logDir = tempDir$1.toPath().resolve(new StringBuilder(18).append("tierDeleteLogTest-").append(i).toString()).toFile();
        logDir.mkdir();
        MockScheduler x$70 = $this.mockTime().scheduler;
        BrokerTopicStats x$71 = new BrokerTopicStats();
        Metrics x$72 = new Metrics();
        MockTime x$73 = $this.mockTime();
        ProducerStateManagerConfig x$75 = new ProducerStateManagerConfig(3600000, false);
        None$ x$77 = None$.MODULE$;
        None$ x$81 = None$.MODULE$;
        None$ x$83 = None$.MODULE$;
        ChecksumParams x$84 = ChecksumParams.EMPTY;
        LogOffsetsListener x$85 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        ConcurrentHashMap x$86 = new ConcurrentHashMap();
        return MergedLog$.MODULE$.apply(logDir, deleteLogConfig$1, 0L, 0L, (Scheduler)x$70, x$71, x$72, (Time)x$73, 300000, x$75, 600000, (Option)x$77, logDirFailureChannel$1, tierLogComponents$1, true, (Option)x$81, true, x$85, (Option)x$83, x$86, x$84);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$writeRecordBatches$1(TierCompactionIntegrationTest $this, AbstractLog log$1, int leaderEpoch$4, long baseOffset$1, int recordsPerBatch$1, int idx) {
        MemoryRecords records = $this.createRecords(log$1.topicPartition(), leaderEpoch$4, baseOffset$1 + (long)(idx * recordsPerBatch$1), recordsPerBatch$1);
        return log$1.appendAsFollower(records);
    }

    public static final /* synthetic */ SimpleRecord $anonfun$createRecords$1(int x$21) {
        return new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes());
    }

    public static final /* synthetic */ boolean $anonfun$tierPartitionState$1(TopicPartition partition$1, MergedLog x$23) {
        TopicPartition topicPartition = x$23.topicPartition();
        return !(topicPartition != null ? !topicPartition.equals(partition$1) : partition$1 != null);
    }

    private final long cleanBytes$1() {
        return BoxesRunTime.unboxToLong((Object)this.getGauge("cleanable-partitions-clean-bytes-last-run").value());
    }

    private final long cleanableBytes$1() {
        return BoxesRunTime.unboxToLong((Object)this.getGauge("cleanable-partitions-cleanable-bytes-last-run").value());
    }

    private final long uncleanableBytes$1() {
        return BoxesRunTime.unboxToLong((Object)this.getGauge("cleanable-partitions-uncleanable-bytes-last-run").value());
    }

    public static final /* synthetic */ boolean $anonfun$verifyMetrics$1(MergedLog x$25) {
        return x$25.config().compact();
    }

    private final long totalSize$1() {
        return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)((IterableOps)this.logs().filter((Function1 & Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)TierCompactionIntegrationTest.$anonfun$verifyMetrics$1(x$25)))).map((Function1 & Serializable)x$26 -> BoxesRunTime.boxToLong((long)x$26.size()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$verifyMetrics$3(TierCompactionIntegrationTest $this) {
        return $this.totalSize$1() == $this.cleanBytes$1() + $this.cleanableBytes$1() + $this.uncleanableBytes$1();
    }

    public static final /* synthetic */ String $anonfun$verifyMetrics$4(TierCompactionIntegrationTest $this) {
        return new StringBuilder(131).append("total size didn't end up matching clean/cleanable/uncleanable bytes. cleanBytes: ").append($this.cleanBytes$1()).append(", cleanableBytes: ").append($this.cleanableBytes$1()).append(", uncleanableBytes: ").append($this.uncleanableBytes$1()).append(", totalSize=").append($this.totalSize$1()).toString();
    }

    public TierCompactionIntegrationTest() {
        this.numThreads = 3;
        int x$1 = this.numThreads();
        int x$2 = this.numThreads();
        int x$3 = this.numThreads();
        Some x$7 = new Some((Object)this.tierCompactionTaskConfig());
        long x$8 = 600000L;
        long x$9 = 500L;
        int x$10 = 50;
        boolean x$11 = false;
        None$ x$12 = None$.MODULE$;
        this.tierTasksConfig = new TierTasksConfig(x$1, x$2, x$3, 1, x$8, x$9, x$10, 20, true, x$11, (Option)x$7, (Option)x$12);
        this.tierDeletedPartitionsCoordinator = (TierDeletedPartitionsCoordinator)Mockito.mock(TierDeletedPartitionsCoordinator.class);
        this.tierStateFetcher = (TierStateFetcher)Mockito.mock(TierStateFetcher.class);
        this.maxWaitTimeMs = 20000;
        this.tierReplicaManager = new TierReplicaManager();
    }
}

