/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import io.confluent.kafka.storage.checksum.ChecksumParams;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import kafka.cluster.Partition;
import kafka.common.TenantHelpers;
import kafka.log.AbstractLog;
import kafka.log.LocalLog$;
import kafka.log.LogTestUtils$;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.HostedPartition;
import kafka.server.ReplicaManager;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.tier.AwaitingDeleteComplete$;
import kafka.tier.Config;
import kafka.tier.DeletedPartitionsChangeListener;
import kafka.tier.DeletionState;
import kafka.tier.ImmigratedTierTopicPartition;
import kafka.tier.InProgressDeletion;
import kafka.tier.MaterializationComplete$;
import kafka.tier.MaterializingState$;
import kafka.tier.TierDeletedPartitionsCoordinator;
import kafka.tier.TierObjectGarbageCollector;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.AbstractTierSegmentMetadata;
import kafka.tier.domain.TierMetadataSnapshotUploadComplete;
import kafka.tier.domain.TierPartitionDeleteComplete;
import kafka.tier.domain.TierPartitionDeleteInitiate;
import kafka.tier.domain.TierPartitionDeletePreInitiate;
import kafka.tier.domain.TierSegmentDeleteComplete;
import kafka.tier.domain.TierSegmentDeleteInitiate;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.CheckedFileIOTestUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.AclsImage;
import org.apache.kafka.image.BrokerReplicaExclusionsImage;
import org.apache.kafka.image.CellImage;
import org.apache.kafka.image.ClientQuotasImage;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.ClusterLinksImage;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.image.DelegationTokenImage;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.ProducerIdsImage;
import org.apache.kafka.image.ScramImage;
import org.apache.kafka.image.TenantImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.NoOpMetadataEncryptor;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\rUf\u0001\u0002 @\u0001\u0011CQa\u0013\u0001\u0005\u00021Cqa\u0014\u0001C\u0002\u0013%\u0001\u000b\u0003\u0004X\u0001\u0001\u0006I!\u0015\u0005\b1\u0002\u0011\r\u0011\"\u0003Z\u0011\u0019\u0001\u0007\u0001)A\u00055\"9\u0011\r\u0001b\u0001\n\u0013\u0011\u0007BB5\u0001A\u0003%1\rC\u0004k\u0001\t\u0007I\u0011B6\t\r=\u0004\u0001\u0015!\u0003m\u0011\u001d\u0001\bA1A\u0005\nEDaA \u0001!\u0002\u0013\u0011\b\u0002C@\u0001\u0005\u0004%I!!\u0001\t\u0011\u0005%\u0001\u0001)A\u0005\u0003\u0007A\u0011\"a\u0003\u0001\u0005\u0004%I!!\u0004\t\u0011\u0005=\u0003\u0001)A\u0005\u0003\u001fA1\"!\u0015\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002T!Y\u00111\f\u0001A\u0002\u0003\u0007I\u0011BA/\u0011-\tI\u0007\u0001a\u0001\u0002\u0003\u0006K!!\u0016\t\u0013\u0005-\u0004A1A\u0005\n\u00055\u0004\u0002CA@\u0001\u0001\u0006I!a\u001c\t\u0013\u0005\u0005\u0005A1A\u0005\n\u00055\u0004\u0002CAB\u0001\u0001\u0006I!a\u001c\t\u0013\u0005\u0015\u0005A1A\u0005\n\u0005\u001d\u0005\u0002CAK\u0001\u0001\u0006I!!#\t\u0013\u0005]\u0005A1A\u0005\n\u0005e\u0005\u0002CAQ\u0001\u0001\u0006I!a'\t\u000f\u0005\r\u0006\u0001\"\u0001\u0002&\"9\u0011Q\u0018\u0001\u0005\u0002\u0005\u0015\u0006bBAd\u0001\u0011\u0005\u0011\u0011\u001a\u0005\b\u0003s\u0004A\u0011AA~\u0011\u001d\u0011)\u0001\u0001C\u0001\u0005\u000fAqA!\u0005\u0001\t\u0003\u0011\u0019\u0002C\u0004\u0003\u001e\u0001!\tAa\b\t\u000f\t%\u0002\u0001\"\u0001\u0003,!9!Q\u0007\u0001\u0005\u0002\t]\u0002b\u0002B!\u0001\u0011\u0005!1\t\u0005\b\u0005\u001b\u0002A\u0011\u0001B(\u0011\u001d\u0011I\u0006\u0001C\u0001\u0003KCqAa\u0019\u0001\t\u0003\t)\u000bC\u0004\u0003h\u0001!\t!!*\t\u000f\t-\u0004\u0001\"\u0003\u0003n!9!1\u0014\u0001\u0005\n\tu\u0005b\u0002BW\u0001\u0011%!q\u0016\u0005\b\u0005k\u0003A\u0011\u0002B\\\u0011\u001d\u0011i\f\u0001C\u0005\u0005\u007fCqA!;\u0001\t\u0013\u0011Y\u000fC\u0004\u0003p\u0002!IA!=\t\u000f\tU\b\u0001\"\u0003\u0003x\"91q\u0001\u0001\u0005\n\r%\u0001\"CB0\u0001E\u0005I\u0011BB1\u0011%\u00199\bAI\u0001\n\u0013\u0019I\bC\u0005\u0004~\u0001\t\n\u0011\"\u0003\u0004\u0000!I11\u0011\u0001\u0012\u0002\u0013%1q\u0010\u0005\n\u0007\u000b\u0003\u0011\u0013!C\u0005\u0007\u000fC\u0011ba#\u0001#\u0003%Ia!$\t\u0013\rE\u0005!%A\u0005\n\rM\u0005\"CBL\u0001E\u0005I\u0011BBJ\r\u0019\u0019I\n\u0001\u0003\u0004\u001c\"11J\u000fC\u0001\u0007GCqA!;;\t\u0003\u001aI\u000bC\u0004\u00040j\"\te!-\u0003IQKWM\u001d#fY\u0016$X\r\u001a)beRLG/[8og\u000e{wN\u001d3j]\u0006$xN\u001d+fgRT!\u0001Q!\u0002\tQLWM\u001d\u0006\u0002\u0005\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001F!\t1\u0015*D\u0001H\u0015\u0005A\u0015!B:dC2\f\u0017B\u0001&H\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u0014\t\u0003\u001d\u0002i\u0011aP\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s+\u0005\t\u0006C\u0001*V\u001b\u0005\u0019&B\u0001+B\u0003\u0019\u0019XM\u001d<fe&\u0011ak\u0015\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0013!\u0005;jKJ$v\u000e]5d\u0007>t7/^7feV\t!\f\u0005\u0002\\=6\tAL\u0003\u0002^\u007f\u0005)Ao\u001c9jG&\u0011q\f\u0018\u0002\u0012)&,'\u000fV8qS\u000e\u001cuN\\:v[\u0016\u0014\u0018A\u0005;jKJ$v\u000e]5d\u0007>t7/^7fe\u0002\nQ\"\\3uC\u0012\fG/Y\"bG\",W#A2\u0011\u0005\u0011<W\"A3\u000b\u0005\u0019\u001c\u0016\u0001C7fi\u0006$\u0017\r^1\n\u0005!,'AE&SC\u001a$X*\u001a;bI\u0006$\u0018mQ1dQ\u0016\fa\"\\3uC\u0012\fG/Y\"bG\",\u0007%\u0001\tuS\u0016\u0014Hk\u001c9jG6\u000bg.Y4feV\tA\u000e\u0005\u0002\\[&\u0011a\u000e\u0018\u0002\u0011)&,'\u000fV8qS\u000el\u0015M\\1hKJ\f\u0011\u0003^5feR{\u0007/[2NC:\fw-\u001a:!\u0003\u0011!\u0018.\\3\u0016\u0003I\u0004\"a\u001d?\u000e\u0003QT!!\u001e<\u0002\tU$\u0018\u000e\u001c\u0006\u0003)^T!A\u0011=\u000b\u0005eT\u0018AB1qC\u000eDWMC\u0001|\u0003\ry'oZ\u0005\u0003{R\u0014\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\ng\u000eDW\rZ;mKJ,\"!a\u0001\u0011\u0007M\f)!C\u0002\u0002\bQ\u0014Q\"T8dWN\u001b\u0007.\u001a3vY\u0016\u0014\u0018AC:dQ\u0016$W\u000f\\3sA\u0005iA/[3sK\u0012|%M[3diN,\"!a\u0004\u0011\u0011\u0005E\u00111DA\u0010\u0003Ki!!a\u0005\u000b\t\u0005U\u0011qC\u0001\b[V$\u0018M\u00197f\u0015\r\tIbR\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u000f\u0003'\u00111!T1q!\rq\u0015\u0011E\u0005\u0004\u0003Gy$\u0001\u0005+pa&\u001c\u0017\n\u001a)beRLG/[8o!\u0019\t9#a\u000e\u0002>9!\u0011\u0011FA\u001a\u001d\u0011\tY#!\r\u000e\u0005\u00055\"bAA\u0018\u0007\u00061AH]8pizJ\u0011\u0001S\u0005\u0004\u0003k9\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003s\tYD\u0001\u0003MSN$(bAA\u001b\u000fB!\u0011qHA&\u001b\t\t\tEC\u0002g\u0003\u0007RA!!\u0012\u0002H\u00059qN\u00196fGR\u001c(bAA%\u007f\u0005)1\u000f^8sK&!\u0011QJA!\u00059y%M[3di6+G/\u00193bi\u0006\fa\u0002^5fe\u0016$wJ\u00196fGR\u001c\b%\u0001\u000feK2,G/\u001a3QCJ$\u0018\u000e^5p]N\u001cun\u001c:eS:\fGo\u001c:\u0016\u0005\u0005U\u0003c\u0001(\u0002X%\u0019\u0011\u0011L \u0003AQKWM\u001d#fY\u0016$X\r\u001a)beRLG/[8og\u000e{wN\u001d3j]\u0006$xN]\u0001!I\u0016dW\r^3e!\u0006\u0014H/\u001b;j_:\u001c8i\\8sI&t\u0017\r^8s?\u0012*\u0017\u000f\u0006\u0003\u0002`\u0005\u0015\u0004c\u0001$\u0002b%\u0019\u00111M$\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003O\n\u0012\u0011!a\u0001\u0003+\n1\u0001\u001f\u00132\u0003u!W\r\\3uK\u0012\u0004\u0016M\u001d;ji&|gn]\"p_J$\u0017N\\1u_J\u0004\u0013a\u00013jeV\u0011\u0011q\u000e\t\u0005\u0003c\nY(\u0004\u0002\u0002t)!\u0011QOA<\u0003\tIwN\u0003\u0002\u0002z\u0005!!.\u0019<b\u0013\u0011\ti(a\u001d\u0003\t\u0019KG.Z\u0001\u0005I&\u0014\b%\u0001\u0004m_\u001e$\u0015N]\u0001\bY><G)\u001b:!\u0003I!\u0018.\u001a:U_BL7\rU1si&$\u0018n\u001c8\u0016\u0005\u0005%\u0005\u0003BAF\u0003#k!!!$\u000b\u0007\u0005=u/\u0001\u0004d_6lwN\\\u0005\u0005\u0003'\u000biI\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002'QLWM\u001d+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0011\u0002!%t\u0017\u000e^5bY\n\u000b7m[8gM6\u001bXCAAN!\r1\u0015QT\u0005\u0004\u0003?;%\u0001\u0002'p]\u001e\f\u0011#\u001b8ji&\fGNQ1dW>4g-T:!\u0003\u0015\u0019X\r^;q)\t\ty\u0006K\u0002\u001c\u0003S\u0003B!a+\u0002:6\u0011\u0011Q\u0016\u0006\u0005\u0003_\u000b\t,A\u0002ba&TA!a-\u00026\u00069!.\u001e9ji\u0016\u0014(bAA\\u\u0006)!.\u001e8ji&!\u00111XAW\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fZ8x]\"\u001aA$!1\u0011\t\u0005-\u00161Y\u0005\u0005\u0003\u000b\fiKA\u0005BMR,'/R1dQ\u0006!B/Z:u\u0013:LG/[1uK\u0012+G.\u001a;j_:$B!a\u0018\u0002L\"9\u0011QZ\u000fA\u0002\u0005=\u0017a\u00045bgRKWM](cU\u0016\u001cGoR\"\u0011\u0007\u0019\u000b\t.C\u0002\u0002T\u001e\u0013qAQ8pY\u0016\fg\u000eK\u0002\u001e\u0003/\u0004B!!7\u0002`6\u0011\u00111\u001c\u0006\u0005\u0003;\f\t,\u0001\u0004qCJ\fWn]\u0005\u0005\u0003C\fYNA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgRDs!HAs\u0003c\f\u0019\u0010\u0005\u0003\u0002h\u00065XBAAu\u0015\u0011\tY/a7\u0002\u0011A\u0014xN^5eKJLA!a<\u0002j\nYa+\u00197vKN{WO]2f\u0003!\u0011wn\u001c7fC:\u001cH\u0006BA{\u0003oL\u0012!A\r\u0002\u0001\u0005!B/Z:u\u0007>l\u0007\u000f\\3uK\u0012+G.\u001a;j_:$B!a\u0018\u0002~\"9\u0011Q\u001a\u0010A\u0002\u0005=\u0007f\u0001\u0010\u0002X\":a$!:\u0002r\n\rA\u0006BA{\u0003o\f\u0001\u0004^3ti\n+w-\u001b8NCR,'/[1mSj\fG/[8o)\u0011\tyF!\u0003\t\u000f\u00055w\u00041\u0001\u0002P\"\u001aq$a6)\u000f}\t)/!=\u0003\u00101\"\u0011Q_A|\u0003M!Xm\u001d;EK2,G/\u001a)beRLG/[8o)\u0011\tyF!\u0006\t\u000f\u00055\u0007\u00051\u0001\u0002P\"\u001a\u0001%a6)\u000f\u0001\n)/!=\u0003\u001c1\"\u0011Q_A|\u0003m!Xm\u001d;EkBd\u0017nY1uK\u0012+G.\u001a;f\u0013:LG/[1uKR!\u0011q\fB\u0011\u0011\u001d\ti-\ta\u0001\u0003\u001fD3!IAlQ\u001d\t\u0013Q]Ay\u0005OaC!!>\u0002x\u0006yC/Z:u\u0007>dG.Z2u\t\u0016dW\r^3e!\u0006\u0014H/\u001b;j_:\u001cx+\u001b;i\u001f:d\u0017N\\3QCJ$\u0018\u000e^5p]R!\u0011q\fB\u0017\u0011\u001d\tiM\ta\u0001\u0003\u001fD3AIAlQ\u001d\u0011\u0013Q]Ay\u0005gaC!!>\u0002x\u0006\u0001D/Z:u\u0007>dG.Z2u\t\u0016dW\r^3e!\u0006\u0014H/\u001b;j_:\u001cx+\u001b;i\u001f\u001a4G.\u001b8f!\u0006\u0014H/\u001b;j_:$B!a\u0018\u0003:!9\u0011QZ\u0012A\u0002\u0005=\u0007fA\u0012\u0002X\":1%!:\u0002r\n}B\u0006BA{\u0003o\fQ\u0006^3ti\u000e{G\u000e\\3di\u0012+G.\u001a;fIB\u000b'\u000f^5uS>t7oV5uQ:{g.\u001a)beRLG/[8o)\u0011\tyF!\u0012\t\u000f\u00055G\u00051\u0001\u0002P\"\u001aA%a6)\u000f\u0011\n)/!=\u0003L1\"\u0011Q_A|\u0003Q\"Xm\u001d;D_2dWm\u0019;EK2,G/\u001a3QCJ$\u0018\u000e^5p]N<\u0016\u000e\u001e5F[&<'/\u0019;j_:$UO]5oOJ+\u0017\r\u001a\u000b\u0005\u0003?\u0012\t\u0006C\u0004\u0002N\u0016\u0002\r!a4)\u0007\u0015\n9\u000eK\u0004&\u0003K\f\tPa\u0016-\t\u0005U\u0018q_\u0001\u0014i\u0016\u001cHOU3d_:4\u0017nZ;sCRLwN\u001c\u0015\u0004M\tu\u0003\u0003BAV\u0005?JAA!\u0019\u0002.\n!A+Z:u\u0003q!Xm\u001d;D_2dWm\u0019;EK2,G/\u00192mKN+w-\\3oiND3a\nB/\u0003Q!Xm\u001d;HCJ\u0014\u0017mZ3D_2dWm\u0019;pe\"\u001a\u0001F!\u0018\u0002'\r\u0014X-\u0019;f\u001b\u0016$\u0018\rZ1uC&k\u0017mZ3\u0015\r\t=$1\u0010BF!\u0011\u0011\tHa\u001e\u000e\u0005\tM$b\u0001B;o\u0006)\u0011.\\1hK&!!\u0011\u0010B:\u00055iU\r^1eCR\f\u0017*\\1hK\"9!QP\u0015A\u0002\t}\u0014a\u0003;pa&\u001c\u0017*\\1hKN\u0004b!a\n\u0003\u0002\n\u0015\u0015\u0002\u0002BB\u0003w\u00111aU3r!\u0011\u0011\tHa\"\n\t\t%%1\u000f\u0002\u000b)>\u0004\u0018nY%nC\u001e,\u0007b\u0002BGS\u0001\u0007!qR\u0001\u0014S6\fw-Z(gMN,G/\u00118e\u000bB|7\r\u001b\t\u0005\u0005#\u00139*\u0004\u0002\u0003\u0014*\u0019!QS<\u0002\tI\fg\r^\u0005\u0005\u00053\u0013\u0019J\u0001\bPM\u001a\u001cX\r^!oI\u0016\u0003xn\u00195\u00027Y,'/\u001b4z\t\u0016dW\r^3Qe\u0016Le.\u001b;jCR,7)\u00197m)\u0019\tyFa(\u0003$\"9!\u0011\u0015\u0016A\u0002\u0005}\u0011\u0001\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8o\u0011\u001d\u0011)K\u000ba\u0001\u0005O\u000b1\u0002^5nKN\u001c\u0015\r\u001c7fIB\u0019aI!+\n\u0007\t-vIA\u0002J]R\f\u0001D^3sS\u001aLH)\u001a7fi\u0016Le.\u001b;jCR,7)\u00197m)\u0019\tyF!-\u00034\"9!\u0011U\u0016A\u0002\u0005}\u0001b\u0002BSW\u0001\u0007!qU\u0001'GJ,\u0017\r^3US\u0016\u0014H)\u001a7fi\u0016$\u0007+\u0019:uSRLwN\\:D_>\u0014H-\u001b8bi>\u0014H\u0003BA0\u0005sCqAa/-\u0001\u0004\ty-A\tiCN$\u0016.\u001a:fI>\u0013'.Z2u\u000f\u000e\u000bQ#\u001b8ji&\fG/Z*fO6,g\u000e^+qY>\fG\r\u0006\u0007\u0003B\n5'q\u001aBj\u0005C\u0014)\u000f\u0005\u0003\u0003D\n%WB\u0001Bc\u0015\u0011\u00119-!$\u0002\rI,7m\u001c:e\u0013\u0011\u0011YM!2\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011\u001d\u0011\t+\fa\u0001\u0003?AqA!5.\u0001\u0004\u00119+A\u0006mK\u0006$WM]#q_\u000eD\u0007b\u0002Bk[\u0001\u0007!q[\u0001\t_\nTWm\u0019;JIB!!\u0011\u001cBo\u001b\t\u0011YNC\u0002v\u0003oJAAa8\u0003\\\n!Q+V%E\u0011\u001d\u0011\u0019/\fa\u0001\u00037\u000b!BY1tK>3gm]3u\u0011\u001d\u00119/\fa\u0001\u00037\u000b\u0011\"\u001a8e\u001f\u001a47/\u001a;\u00023%t\u0017\u000e^5bi\u0016\u0004\u0016M\u001d;ji&|g\u000eR3mKRLwN\u001c\u000b\u0005\u0005\u0003\u0014i\u000fC\u0004\u0003\":\u0002\r!a\b\u00023\r|W\u000e\u001d7fi\u0016\u0004\u0016M\u001d;ji&|g\u000eR3mKRLwN\u001c\u000b\u0005\u0005\u0003\u0014\u0019\u0010C\u0004\u0003\">\u0002\r!a\b\u0002\u001b5,Wn\u001c:z%\u0016\u001cwN\u001d3t)\u0011\u0011\tM!?\t\r\u0019\u0004\u0004\u0019\u0001B~!\u0011\u0011ipa\u0001\u000e\u0005\t}(bAB\u0001\u007f\u00051Am\\7bS:LAa!\u0002\u0003\u0000\n!\u0012IY:ue\u0006\u001cG\u000fV5fe6+G/\u00193bi\u0006\f\u0011b\u0019:fCR,Gj\\4\u0015)\r-1qCB\r\u0007_\u0019Id!\u0010\u0004B\r%3qKB.!\u0011\u0019iaa\u0005\u000e\u0005\r=!bAB\t\u0003\u0006\u0019An\\4\n\t\rU1q\u0002\u0002\f\u0003\n\u001cHO]1di2{w\rC\u0004\u0002lE\u0002\r!a\u001c\t\u0013\rm\u0011\u0007%AA\u0002\ru\u0011AB2p]\u001aLw\r\u0005\u0003\u0004 \r-RBAB\u0011\u0015\u0011\u0019\tba\t\u000b\t\r\u00152qE\u0001\nS:$XM\u001d8bYNT1a!\u000bx\u0003\u001d\u0019Ho\u001c:bO\u0016LAa!\f\u0004\"\tIAj\\4D_:4\u0017n\u001a\u0005\n\u0007c\t\u0004\u0013!a\u0001\u0007g\t\u0001C\u0019:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\u0011\u0007I\u001b)$C\u0002\u00048M\u0013\u0001C\u0011:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\t\u0013\rm\u0012\u0007%AA\u0002\u0005m\u0015A\u00047pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0005\n\u0007\u007f\t\u0004\u0013!a\u0001\u00037\u000bQB]3d_Z,'/\u001f)pS:$\b\u0002C@2!\u0003\u0005\raa\u0011\u0011\u0007M\u001c)%C\u0002\u0004HQ\u0014\u0011bU2iK\u0012,H.\u001a:\t\u0011A\f\u0004\u0013!a\u0001\u0007\u0017\u0002Ba!\u0014\u0004T5\u00111q\n\u0006\u0005\u0007#\ni)A\u0003vi&d7/\u0003\u0003\u0004V\r=#\u0001\u0002+j[\u0016D\u0011b!\u00172!\u0003\u0005\rAa*\u000235\f\u0007\u0010\u0015:pIV\u001cWM]%e\u000bb\u0004\u0018N]1uS>tWj\u001d\u0005\n\u0007;\n\u0004\u0013!a\u0001\u0005O\u000b1\u0005\u001d:pIV\u001cWM]%e\u000bb\u0004\u0018N]1uS>t7\t[3dW&sG/\u001a:wC2l5/A\nde\u0016\fG/\u001a'pO\u0012\"WMZ1vYR$#'\u0006\u0002\u0004d)\"1QDB3W\t\u00199\u0007\u0005\u0003\u0004j\rMTBAB6\u0015\u0011\u0019iga\u001c\u0002\u0013Ut7\r[3dW\u0016$'bAB9\u000f\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\rU41\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aE2sK\u0006$X\rT8hI\u0011,g-Y;mi\u0012\u001aTCAB>U\u0011\u0019\u0019d!\u001a\u0002'\r\u0014X-\u0019;f\u0019><G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r\u0005%\u0006BAN\u0007K\n1c\u0019:fCR,Gj\\4%I\u00164\u0017-\u001e7uIU\n1c\u0019:fCR,Gj\\4%I\u00164\u0017-\u001e7uIY*\"a!#+\t\r\r3QM\u0001\u0014GJ,\u0017\r^3M_\u001e$C-\u001a4bk2$HeN\u000b\u0003\u0007\u001fSCaa\u0013\u0004f\u0005\u00192M]3bi\u0016dun\u001a\u0013eK\u001a\fW\u000f\u001c;%qU\u00111Q\u0013\u0016\u0005\u0005O\u001b)'A\nde\u0016\fG/\u001a'pO\u0012\"WMZ1vYR$\u0013H\u0001\u0005MSN$XM\\3s'\u0011QTi!(\u0011\u00079\u001by*C\u0002\u0004\"~\u0012q\u0004R3mKR,G\rU1si&$\u0018n\u001c8t\u0007\"\fgnZ3MSN$XM\\3s)\t\u0019)\u000bE\u0002\u0004(jj\u0011\u0001\u0001\u000b\u0007\u0003?\u001aYk!,\t\u000f\t\u0005F\b1\u0001\u0002 !9\u00111\u0002\u001fA\u0002\u0005\u0015\u0012!F:u_B\u0004\u0016M\u001d;ji&|g\u000eR3mKRLwN\u001c\u000b\u0005\u0003?\u001a\u0019\fC\u0004\u0003\"v\u0002\r!a\b")
public class TierDeletedPartitionsCoordinatorTest {
    private final ReplicaManager kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final TierTopicConsumer kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer = (TierTopicConsumer)Mockito.mock(TierTopicConsumer.class);
    private final KRaftMetadataCache metadataCache = new KRaftMetadataCache(0);
    private final TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
    private final MockTime kafka$tier$TierDeletedPartitionsCoordinatorTest$$time = new MockTime();
    private final MockScheduler kafka$tier$TierDeletedPartitionsCoordinatorTest$$scheduler;
    private final scala.collection.mutable.Map<TopicIdPartition, List<ObjectMetadata>> tieredObjects;
    private TierDeletedPartitionsCoordinator deletedPartitionsCoordinator;
    private final File dir;
    private final File logDir;
    private final TopicPartition tierTopicPartition;
    private final long initialBackoffMs;

    public ReplicaManager kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager() {
        return this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager;
    }

    public TierTopicConsumer kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer() {
        return this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer;
    }

    private KRaftMetadataCache metadataCache() {
        return this.metadataCache;
    }

    private TierTopicManager tierTopicManager() {
        return this.tierTopicManager;
    }

    public MockTime kafka$tier$TierDeletedPartitionsCoordinatorTest$$time() {
        return this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time;
    }

    public MockScheduler kafka$tier$TierDeletedPartitionsCoordinatorTest$$scheduler() {
        return this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$scheduler;
    }

    private scala.collection.mutable.Map<TopicIdPartition, List<ObjectMetadata>> tieredObjects() {
        return this.tieredObjects;
    }

    private TierDeletedPartitionsCoordinator deletedPartitionsCoordinator() {
        return this.deletedPartitionsCoordinator;
    }

    private void deletedPartitionsCoordinator_$eq(TierDeletedPartitionsCoordinator x$1) {
        this.deletedPartitionsCoordinator = x$1;
    }

    private File dir() {
        return this.dir;
    }

    private File logDir() {
        return this.logDir;
    }

    private TopicPartition tierTopicPartition() {
        return this.tierTopicPartition;
    }

    private long initialBackoffMs() {
        return this.initialBackoffMs;
    }

    @BeforeEach
    public void setup() {
        Mockito.when((Object)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager().liveLogDirs()).thenReturn((Object)new .colon.colon((Object)Paths.get("/tmp/", new String[0]).toFile(), (List)Nil$.MODULE$));
    }

    @AfterEach
    public void teardown() {
        this.dir().delete();
        Mockito.framework().clearInlineMocks();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testInitiateDeletion(boolean hasTierObjectGC) {
        this.createTierDeletedPartitionsCoordinator(hasTierObjectGC);
        scala.collection.immutable.Map deletedPartitionsMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{new TopicIdPartition("foo-1", UUID.randomUUID(), 0), new TopicIdPartition("foo-2", UUID.randomUUID(), 2)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{new TopicIdPartition("foo-3", UUID.randomUUID(), 0)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$))}));
        deletedPartitionsMap.keySet().foreach((Function1)(JFunction1.mcVI.sp & Serializable)tierTopicPartitionId -> this.deletedPartitionsCoordinator().handleImmigration(tierTopicPartitionId));
        deletedPartitionsMap.foreach((Function1 & Serializable)x0$1 -> {
            TierDeletedPartitionsCoordinatorTest.$anonfun$testInitiateDeletion$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
        scala.collection.mutable.Map immigratedPartitions = this.deletedPartitionsCoordinator().immigratedPartitions();
        Assertions.assertEquals((Object)deletedPartitionsMap, (Object)immigratedPartitions.map((Function1 & Serializable)x0$2 -> {
            if (x0$2 != null) {
                int tierTopicPartitionId = x0$2._1$mcI$sp();
                ImmigratedTierTopicPartition immigratedPartition = (ImmigratedTierTopicPartition)x0$2._2();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId), (Object)immigratedPartition.pendingDeletions().keySet());
            }
            throw new MatchError(null);
        }));
        Assertions.assertEquals((long)3L, (long)BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.deletedPartitionsCoordinator().immigratedPartitions().values().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)TierDeletedPartitionsCoordinatorTest.$anonfun$testInitiateDeletion$5(x$2)))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        deletedPartitionsMap.keySet().foreach((Function1)(JFunction1.mcVI.sp & Serializable)tierTopicPartitionId -> this.deletedPartitionsCoordinator().handleImmigration(tierTopicPartitionId));
        Assertions.assertEquals((long)3L, (long)BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.deletedPartitionsCoordinator().immigratedPartitions().values().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)TierDeletedPartitionsCoordinatorTest.$anonfun$testInitiateDeletion$7(x$3)))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(1, new TopicIdPartition("foo", UUID.randomUUID(), 0), 20L);
        Assertions.assertEquals((Object)deletedPartitionsMap, (Object)immigratedPartitions.map((Function1 & Serializable)x0$3 -> {
            if (x0$3 != null) {
                int tierTopicPartitionId = x0$3._1$mcI$sp();
                ImmigratedTierTopicPartition immigratedPartition = (ImmigratedTierTopicPartition)x0$3._2();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId), (Object)immigratedPartition.pendingDeletions().keySet());
            }
            throw new MatchError(null);
        }));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testCompleteDeletion(boolean hasTierObjectGC) {
        this.createTierDeletedPartitionsCoordinator(hasTierObjectGC);
        TopicIdPartition foo_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition foo_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 2);
        TopicIdPartition foo_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 5);
        LongRef offset = LongRef.create((long)0L);
        scala.collection.immutable.Map deletedPartitionsMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo_1, foo_2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo_3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$))}));
        deletedPartitionsMap.keySet().foreach((Function1)(JFunction1.mcVI.sp & Serializable)tierTopicPartitionId -> this.deletedPartitionsCoordinator().handleImmigration(tierTopicPartitionId));
        deletedPartitionsMap.foreach((Function1 & Serializable)x0$1 -> {
            TierDeletedPartitionsCoordinatorTest.$anonfun$testCompleteDeletion$2(this, offset, x0$1);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)3L, (long)BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.deletedPartitionsCoordinator().immigratedPartitions().values().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)TierDeletedPartitionsCoordinatorTest.$anonfun$testCompleteDeletion$4(x$4)))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        this.deletedPartitionsCoordinator().trackCompletePartitionDelete(0, foo_1);
        this.deletedPartitionsCoordinator().trackCompletePartitionDelete(3, foo_3);
        deletedPartitionsMap.keySet().foreach((Function1)(JFunction1.mcVI.sp & Serializable)tierTopicPartitionId -> this.deletedPartitionsCoordinator().handleImmigration(tierTopicPartitionId));
        scala.collection.mutable.Map immigratedPartitions = this.deletedPartitionsCoordinator().immigratedPartitions();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo_2})), (Object)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)0))).pendingDeletions().keySet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)3))).pendingDeletions().keySet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)5))).pendingDeletions().keySet());
        Assertions.assertEquals((int)3, (int)immigratedPartitions.size());
        this.deletedPartitionsCoordinator().handleEmigration(0);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 5})), (Object)immigratedPartitions.keySet());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testBeginMaterialization(boolean hasTierObjectGC) {
        this.createTierDeletedPartitionsCoordinator(hasTierObjectGC);
        Tuple2 foo_1 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new TopicIdPartition("foo-1", UUID.randomUUID(), 0));
        Tuple2 foo_2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new TopicIdPartition("foo-2", UUID.randomUUID(), 2));
        Tuple2 foo_3 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new TopicIdPartition("foo-3", UUID.randomUUID(), 2));
        Tuple2 foo_4 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)new TopicIdPartition("foo-4", UUID.randomUUID(), 5));
        this.deletedPartitionsCoordinator().handleImmigration(0);
        this.deletedPartitionsCoordinator().handleImmigration(3);
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_1._1$mcI$sp(), (TopicIdPartition)foo_1._2(), 10L);
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_2._1$mcI$sp(), (TopicIdPartition)foo_2._2(), 20L);
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_4._1$mcI$sp(), (TopicIdPartition)foo_4._2(), 30L);
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_1._1$mcI$sp(), (TopicIdPartition)foo_1._2(), 31L);
        this.deletedPartitionsCoordinator().maybeBeginMaterialization();
        scala.collection.mutable.Map immigratedPartitions = this.deletedPartitionsCoordinator().immigratedPartitions();
        Assertions.assertTrue((boolean)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)foo_1._1$mcI$sp()))).inProgressDeletions().contains(foo_1._2()));
        Assertions.assertTrue((boolean)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)foo_2._1$mcI$sp()))).inProgressDeletions().contains(foo_2._2()));
        Assertions.assertTrue((boolean)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)foo_4._1$mcI$sp()))).inProgressDeletions().contains(foo_4._2()));
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)((IterableOnceOps)immigratedPartitions.values().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)TierDeletedPartitionsCoordinatorTest.$anonfun$testBeginMaterialization$1(x$5)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_1._1$mcI$sp(), (TopicIdPartition)foo_1._2(), 32L);
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_2._1$mcI$sp(), (TopicIdPartition)foo_2._2(), 34L);
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)((IterableOnceOps)immigratedPartitions.values().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)TierDeletedPartitionsCoordinatorTest.$anonfun$testBeginMaterialization$2(x$6)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
        new .colon.colon((Object)((TopicIdPartition)foo_1._2()), (List)new .colon.colon((Object)((TopicIdPartition)foo_2._2()), (List)new .colon.colon((Object)((TopicIdPartition)foo_4._2()), (List)Nil$.MODULE$))).foreach((Function1 & Serializable)topicIdPartition -> {
            TierDeletedPartitionsCoordinatorTest.$anonfun$testBeginMaterialization$3(this, topicIdPartition);
            return BoxedUnit.UNIT;
        });
        ((TierTopicConsumer)Mockito.verify((Object)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer(), (VerificationMode)Mockito.times((int)1))).register((Map)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<Map<TopicIdPartition, TierTopicConsumer.ClientCtx>>(null, foo_1, foo_2, foo_4){
            private final Tuple2 foo_1$1;
            private final Tuple2 foo_2$1;
            private final Tuple2 foo_4$1;

            public Class<?> type() {
                return super.type();
            }

            public boolean matches(Map<TopicIdPartition, TierTopicConsumer.ClientCtx> argument) {
                Set set = CollectionConverters$.MODULE$.SetHasAsScala(argument.keySet()).asScala();
                Object object = Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{(TopicIdPartition)this.foo_1$1._2(), (TopicIdPartition)this.foo_2$1._2(), (TopicIdPartition)this.foo_4$1._2()}));
                return !(set != null ? !set.equals(object) : object != null);
            }
            {
                this.foo_1$1 = foo_1$1;
                this.foo_2$1 = foo_2$1;
                this.foo_4$1 = foo_4$1;
            }
        }));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer()});
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_3._1$mcI$sp(), (TopicIdPartition)foo_3._2(), 100L);
        this.deletedPartitionsCoordinator().maybeBeginMaterialization();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{(TopicIdPartition)foo_3._2()})), (Object)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)foo_3._1$mcI$sp()))).pendingDeletions().keySet());
        this.deletedPartitionsCoordinator().trackCompletePartitionDelete(foo_1._1$mcI$sp(), (TopicIdPartition)foo_1._2());
        this.deletedPartitionsCoordinator().trackCompletePartitionDelete(foo_2._1$mcI$sp(), (TopicIdPartition)foo_2._2());
        this.deletedPartitionsCoordinator().maybeBeginMaterialization();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{(TopicIdPartition)foo_3._2()})), (Object)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)foo_3._1$mcI$sp()))).inProgressDeletions().keySet());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDeletePartition(boolean hasTierObjectGC) {
        this.createTierDeletedPartitionsCoordinator(hasTierObjectGC);
        int tierTopicPartition = 1;
        TopicIdPartition deletedPartition_1 = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int deleteInitiateOffset_1 = 10;
        TopicIdPartition deletedPartition_2 = new TopicIdPartition("bar", UUID.randomUUID(), 0);
        int deleteInitiateOffset_2 = 20;
        IndexedSeq tieredSegments_1 = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)i -> TierDeletedPartitionsCoordinatorTest.$anonfun$testDeletePartition$1(deletedPartition_1, BoxesRunTime.unboxToInt((Object)i)));
        this.tieredObjects().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)deletedPartition_1), (Object)tieredSegments_1.toList()));
        this.deletedPartitionsCoordinator().handleImmigration(tierTopicPartition);
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(tierTopicPartition, deletedPartition_1, (long)deleteInitiateOffset_1);
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(tierTopicPartition, deletedPartition_2, (long)deleteInitiateOffset_2);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{deletedPartition_1, deletedPartition_2})), (Object)((ImmigratedTierTopicPartition)this.deletedPartitionsCoordinator().immigratedPartitions().apply((Object)BoxesRunTime.boxToInteger((int)tierTopicPartition))).pendingDeletions().keySet());
        this.deletedPartitionsCoordinator().maybeBeginMaterialization();
        scala.collection.mutable.Map inProgressPartitions = ((ImmigratedTierTopicPartition)this.deletedPartitionsCoordinator().immigratedPartitions().apply((Object)BoxesRunTime.boxToInteger((int)tierTopicPartition))).inProgressDeletions();
        Assertions.assertEquals((int)2, (int)inProgressPartitions.size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{deletedPartition_1, deletedPartition_2})), (Object)inProgressPartitions.keySet());
        Assertions.assertEquals((Object)new .colon.colon((Object)MaterializingState$.MODULE$, (List)new .colon.colon((Object)MaterializingState$.MODULE$, (List)Nil$.MODULE$)), (Object)inProgressPartitions.values().map((Function1 & Serializable)x$7 -> x$7.currentState()));
        Assertions.assertTrue((boolean)((ImmigratedTierTopicPartition)this.deletedPartitionsCoordinator().immigratedPartitions().apply((Object)BoxesRunTime.boxToInteger((int)tierTopicPartition))).pendingDeletions().isEmpty());
        int numCompacted = 2;
        LongRef offset = LongRef.create((long)0L);
        InProgressDeletion inProgress_1 = (InProgressDeletion)inProgressPartitions.apply((Object)deletedPartition_1);
        ((IterableOnceOps)tieredSegments_1.take(numCompacted)).foreach((Function1 & Serializable)segment -> {
            OffsetAndEpoch stateOffsetAndEpoch = new OffsetAndEpoch(offset$2.elem, Optional.of(Predef$.MODULE$.int2Integer(0)));
            ++offset$2.elem;
            return inProgress_1.process((AbstractTierMetadata)new TierSegmentUploadInitiate(segment.topicIdPartition(), segment.tierEpoch(), segment.objectId(), segment.baseOffset(), segment.baseOffset() + 1L, 0L, 100L, 100, false, false, false, TierUploadType.Compaction, stateOffsetAndEpoch, OpaqueData.ZEROED), stateOffsetAndEpoch);
        });
        ((IterableOnceOps)tieredSegments_1.drop(numCompacted)).foreach((Function1 & Serializable)segment -> {
            OffsetAndEpoch stateOffsetAndEpoch = new OffsetAndEpoch(offset$2.elem, Optional.of(Predef$.MODULE$.int2Integer(0)));
            ++offset$2.elem;
            return inProgress_1.process((AbstractTierMetadata)new TierSegmentUploadInitiate(segment.topicIdPartition(), segment.tierEpoch(), segment.objectId(), segment.baseOffset(), segment.baseOffset() + 1L, 0L, 100L, 100, false, false, false, TierUploadType.Archive, stateOffsetAndEpoch, OpaqueData.ZEROED), stateOffsetAndEpoch);
        });
        inProgress_1.process((AbstractTierMetadata)new TierPartitionDeleteInitiate(deletedPartition_1, 0, UUID.randomUUID()), new OffsetAndEpoch((long)deleteInitiateOffset_1, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Assertions.assertEquals((Object)MaterializationComplete$.MODULE$, (Object)inProgress_1.deletionState());
        this.deletedPartitionsCoordinator().maybeBeginDeletion();
        Assertions.assertEquals((Object)AwaitingDeleteComplete$.MODULE$, (Object)inProgress_1.deletionState());
        this.deletedPartitionsCoordinator().trackCompletePartitionDelete(tierTopicPartition, deletedPartition_1);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{deletedPartition_2})), (Object)inProgressPartitions.keySet());
        Assertions.assertEquals((Object)new .colon.colon((Object)MaterializingState$.MODULE$, (List)Nil$.MODULE$), (Object)inProgressPartitions.values().map((Function1 & Serializable)x$8 -> x$8.currentState()));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDuplicateDeleteInitiate(boolean hasTierObjectGC) {
        this.createTierDeletedPartitionsCoordinator(hasTierObjectGC);
        int tierTopicPartition = 1;
        TopicIdPartition partition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int deleteInitiateOffset_1 = 10;
        int deleteCompleteOffset_1 = 15;
        int deleteInitiateOffset_2 = 20;
        IndexedSeq tieredSegments = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)i -> TierDeletedPartitionsCoordinatorTest.$anonfun$testDuplicateDeleteInitiate$1(partition, BoxesRunTime.unboxToInt((Object)i)));
        this.tieredObjects().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)tieredSegments.toList()));
        this.deletedPartitionsCoordinator().handleImmigration(tierTopicPartition);
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(tierTopicPartition, partition, (long)deleteInitiateOffset_2);
        this.deletedPartitionsCoordinator().maybeBeginMaterialization();
        InProgressDeletion inProgress = (InProgressDeletion)((ImmigratedTierTopicPartition)this.deletedPartitionsCoordinator().immigratedPartitions().apply((Object)BoxesRunTime.boxToInteger((int)tierTopicPartition))).inProgressDeletions().apply((Object)partition);
        LongRef offset = LongRef.create((long)0L);
        tieredSegments.foreach((Function1 & Serializable)segment -> {
            TierDeletedPartitionsCoordinatorTest.$anonfun$testDuplicateDeleteInitiate$2(offset, inProgress, segment);
            return BoxedUnit.UNIT;
        });
        Mockito.reset((Object[])new TierTopicConsumer[]{this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer()});
        inProgress.process((AbstractTierMetadata)new TierPartitionDeleteInitiate(partition, 0, UUID.randomUUID()), new OffsetAndEpoch((long)deleteInitiateOffset_1, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Assertions.assertEquals((Object)MaterializingState$.MODULE$, (Object)inProgress.deletionState());
        inProgress.process((AbstractTierMetadata)new TierPartitionDeleteComplete(partition, UUID.randomUUID()), new OffsetAndEpoch((long)deleteCompleteOffset_1, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Assertions.assertEquals((Object)MaterializingState$.MODULE$, (Object)inProgress.deletionState());
        ((TierTopicConsumer)Mockito.verify((Object)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer(), (VerificationMode)Mockito.never())).deregister(partition);
        inProgress.process((AbstractTierMetadata)new TierPartitionDeleteInitiate(partition, 0, UUID.randomUUID()), new OffsetAndEpoch((long)deleteInitiateOffset_2, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Assertions.assertEquals((Object)MaterializationComplete$.MODULE$, (Object)inProgress.deletionState());
        inProgress.process((AbstractTierMetadata)new TierPartitionDeleteComplete(partition, UUID.randomUUID()), new OffsetAndEpoch((long)(deleteInitiateOffset_2 + 1), Optional.of(Predef$.MODULE$.int2Integer(0))));
        ((TierTopicConsumer)Mockito.verify((Object)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer(), (VerificationMode)Mockito.times((int)1))).deregister(partition);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testCollectDeletedPartitionsWithOnlinePartition(boolean hasTierObjectGC) {
        void var9_9;
        this.createTierDeletedPartitionsCoordinator(hasTierObjectGC);
        AbstractLog log = this.createLog(this.logDir(), this.createLog$default$2(), new BrokerTopicStats(), 0L, 0L, (Scheduler)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$scheduler(), (Time)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time(), 3600000, 600000);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        int leaderEpoch = 0;
        this.deletedPartitionsCoordinator().handleImmigration(this.tierTopicPartition().partition());
        Mockito.when((Object)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager().getPartition(this.tierTopicPartition())).thenReturn((Object)new HostedPartition.Online(partition));
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        TopicIdPartition topicIdPartition_1 = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        TopicIdPartition topicIdPartition_2 = new TopicIdPartition("bar", UUID.randomUUID(), 3);
        new .colon.colon((Object)this.initiateSegmentUpload(topicIdPartition_1, 0, UUID.randomUUID(), 0L, 100L), (List)new .colon.colon((Object)this.initiatePartitionDeletion(topicIdPartition_1), (List)new .colon.colon((Object)this.initiateSegmentUpload(topicIdPartition_2, 0, UUID.randomUUID(), 100L, 1000L), (List)new .colon.colon((Object)this.initiatePartitionDeletion(topicIdPartition_2), (List)new .colon.colon((Object)this.completePartitionDeletion(topicIdPartition_1), (List)Nil$.MODULE$))))).foreach((Function1 & Serializable)record -> log.appendAsLeader(record, leaderEpoch, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6()));
        log.updateHighWatermark(log.logEndOffset());
        ByteBuffer buffer = ByteBuffer.allocate(200);
        Tuple2 tuple2 = this.deletedPartitionsCoordinator().collectDeletedPartitions(this.tierTopicPartition(), 0L, buffer);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long lastReadOffset = tuple2._1$mcJ$sp();
        Assertions.assertEquals((long)log.logEndOffset(), (long)var9_9);
        ImmigratedTierTopicPartition immigratedPartition = (ImmigratedTierTopicPartition)this.deletedPartitionsCoordinator().immigratedPartitions().apply((Object)BoxesRunTime.boxToInteger((int)this.tierTopicPartition().partition()));
        Assertions.assertEquals((Object)new .colon.colon((Object)topicIdPartition_2, (List)Nil$.MODULE$), (Object)immigratedPartition.pendingDeletions().keySet().toList());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testCollectDeletedPartitionsWithOfflinePartition(boolean hasTierObjectGC) {
        void var5_5;
        this.createTierDeletedPartitionsCoordinator(hasTierObjectGC);
        Mockito.when((Object)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager().getPartition(this.tierTopicPartition())).thenReturn((Object)new HostedPartition.Offline((Option)None$.MODULE$));
        ByteBuffer buffer = ByteBuffer.allocate(200);
        int startOffset = 0;
        Tuple2 tuple2 = this.deletedPartitionsCoordinator().collectDeletedPartitions(this.tierTopicPartition(), (long)startOffset, buffer);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long lastReadOffset = tuple2._1$mcJ$sp();
        Assertions.assertEquals((long)var5_5, (long)startOffset);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testCollectDeletedPartitionsWithNonePartition(boolean hasTierObjectGC) {
        void var5_5;
        this.createTierDeletedPartitionsCoordinator(hasTierObjectGC);
        Mockito.when((Object)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager().getPartition(this.tierTopicPartition())).thenReturn((Object)HostedPartition.None$.MODULE$);
        ByteBuffer buffer = ByteBuffer.allocate(200);
        int startOffset = 0;
        Tuple2 tuple2 = this.deletedPartitionsCoordinator().collectDeletedPartitions(this.tierTopicPartition(), (long)startOffset, buffer);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long lastReadOffset = tuple2._1$mcJ$sp();
        Assertions.assertEquals((long)var5_5, (long)startOffset);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testCollectDeletedPartitionsWithEmigrationDuringRead(boolean hasTierObjectGC) {
        void var9_9;
        this.createTierDeletedPartitionsCoordinator(hasTierObjectGC);
        AbstractLog log = this.createLog(this.logDir(), this.createLog$default$2(), new BrokerTopicStats(), 0L, 0L, (Scheduler)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$scheduler(), (Time)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time(), 3600000, 600000);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        int leaderEpoch = 0;
        this.deletedPartitionsCoordinator().handleImmigration(this.tierTopicPartition().partition());
        Mockito.when((Object)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager().getPartition(this.tierTopicPartition())).thenReturn((Object)new HostedPartition.Online(partition));
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        TopicIdPartition topicIdPartition_1 = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        TopicIdPartition topicIdPartition_2 = new TopicIdPartition("bar", UUID.randomUUID(), 3);
        new .colon.colon((Object)this.initiateSegmentUpload(topicIdPartition_1, 0, UUID.randomUUID(), 0L, 100L), (List)new .colon.colon((Object)this.initiatePartitionDeletion(topicIdPartition_1), (List)new .colon.colon((Object)this.initiateSegmentUpload(topicIdPartition_2, 0, UUID.randomUUID(), 100L, 1000L), (List)new .colon.colon((Object)this.initiatePartitionDeletion(topicIdPartition_2), (List)new .colon.colon((Object)this.completePartitionDeletion(topicIdPartition_1), (List)Nil$.MODULE$))))).foreach((Function1 & Serializable)record -> log.appendAsLeader(record, leaderEpoch, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6()));
        log.updateHighWatermark(log.logEndOffset());
        this.deletedPartitionsCoordinator().handleEmigration(this.tierTopicPartition().partition());
        ByteBuffer buffer = ByteBuffer.allocate(200);
        Tuple2 tuple2 = this.deletedPartitionsCoordinator().collectDeletedPartitions(this.tierTopicPartition(), 0L, buffer);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long lastReadOffset = tuple2._1$mcJ$sp();
        Assertions.assertEquals((long)0L, (long)var9_9);
        Assertions.assertEquals((int)0, (int)this.deletedPartitionsCoordinator().immigratedPartitions().size());
    }

    @Test
    public void testReconfiguration() {
        ListBuffer heartbeats = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        int initialDelayMs = 100;
        ObjectRef config = ObjectRef.create((Object)new Config(200L, 100, 15000L));
        TierDeletedPartitionsCoordinator coordinator = new TierDeletedPartitionsCoordinator(this, config, heartbeats){
            private final /* synthetic */ TierDeletedPartitionsCoordinatorTest $outer;
            private final ListBuffer heartbeats$1;

            public void heartbeat() {
                super.heartbeat();
                this.heartbeats$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)this.$outer.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().milliseconds()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.heartbeats$1 = heartbeats$1;
                super((Scheduler)$outer.kafka$tier$TierDeletedPartitionsCoordinatorTest$$scheduler(), $outer.kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager(), $outer.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer(), ((Config)config$1.elem).intervalMs(), ((Config)config$1.elem).maxInprogressPartitions(), ((Config)config$1.elem).deleteBackoffMs(), "foo", (Time)$outer.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time(), (Option)None$.MODULE$);
            }
        };
        coordinator.startup();
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep((long)initialDelayMs);
        Assertions.assertEquals((int)1, (int)heartbeats.size());
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(((Config)config.elem).intervalMs());
        Assertions.assertEquals((int)2, (int)heartbeats.size());
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(((Config)config.elem).intervalMs() / 2L);
        Assertions.assertEquals((int)2, (int)heartbeats.size());
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(((Config)config.elem).intervalMs() / 2L + 1L);
        Assertions.assertEquals((int)3, (int)heartbeats.size());
        config.elem = new Config(10L, 100, 15000L);
        coordinator.reconfigure((Config)config.elem);
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(1L);
        Assertions.assertEquals((int)4, (int)heartbeats.size());
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(((Config)config.elem).intervalMs());
        Assertions.assertEquals((int)5, (int)heartbeats.size());
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(((Config)config.elem).intervalMs() / 2L);
        Assertions.assertEquals((int)5, (int)heartbeats.size());
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(((Config)config.elem).intervalMs() / 2L + 1L);
        Assertions.assertEquals((int)6, (int)heartbeats.size());
        coordinator.shutdown();
    }

    @Test
    public void testCollectDeletableSegments() {
        TierTestUtils$.MODULE$.setTierTopicOffsetAndEpoch(new OffsetAndEpoch(0L, Optional.of(Predef$.MODULE$.int2Integer(0))));
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        TierTopicInitLeader initLeader = new TierTopicInitLeader(topicIdPartition, 0, UUID.randomUUID(), 0);
        UUID objectId1 = UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate1 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectId1, 0L, 10L, 100L, 100L, 100, false, false, false, TierUploadType.Archive, new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(3))), OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete1 = new TierSegmentUploadComplete(topicIdPartition, 0, objectId1, new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(3))));
        UUID objectId2 = UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate2 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectId2, 10L, 20L, 100L, 100L, 100, false, false, false, TierUploadType.Archive, new OffsetAndEpoch(4L, Optional.of(Predef$.MODULE$.int2Integer(3))), OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete2 = new TierSegmentUploadComplete(topicIdPartition, 0, objectId2, new OffsetAndEpoch(5L, Optional.of(Predef$.MODULE$.int2Integer(5))));
        TierSegmentDeleteInitiate deleteInitiate1 = new TierSegmentDeleteInitiate(topicIdPartition, 0, objectId1, new OffsetAndEpoch(6L, Optional.of(Predef$.MODULE$.int2Integer(5))));
        TierSegmentDeleteComplete deleteComplete1 = new TierSegmentDeleteComplete(topicIdPartition, 0, objectId1, Optional.of(new OffsetAndEpoch(7L, Optional.of(Predef$.MODULE$.int2Integer(5)))));
        .colon.colon metadataList = new .colon.colon((Object)initLeader, (List)new .colon.colon((Object)uploadInitiate1, (List)new .colon.colon((Object)uploadComplete1, (List)new .colon.colon((Object)uploadInitiate2, (List)new .colon.colon((Object)uploadComplete2, (List)new .colon.colon((Object)deleteInitiate1, (List)new .colon.colon((Object)deleteComplete1, (List)Nil$.MODULE$)))))));
        ReplicaManager x$5 = this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager();
        MockScheduler x$6 = this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().scheduler;
        MockTime x$7 = this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time();
        scala.collection.mutable.Map x$8 = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        TierPartitionStatus x$9 = TierPartitionStatus.INIT;
        MaterializingState$ x$10 = MaterializingState$.MODULE$;
        InProgressDeletion inProgressDeletion = new InProgressDeletion(0, topicIdPartition, 0L, null, x$8, x$9, (DeletionState)x$10, x$5, (Scheduler)x$6, (Time)x$7);
        Mockito.when((Object)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager().liveLogDirs()).thenReturn((Object)new .colon.colon((Object)this.dir(), (List)Nil$.MODULE$));
        metadataList.foreach((Function1 & Serializable)metadata -> inProgressDeletion.process(metadata, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((int)1, (int)inProgressDeletion.tieredObjects().size());
        Assertions.assertEquals((long)TierTestUtils$.MODULE$.currentOffsetAndEpoch().offset(), (long)inProgressDeletion.localMaterializedOffset());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{objectId2})), (Object)inProgressDeletion.tieredObjects().keySet());
        Assertions.assertEquals((Object)TierTestUtils$.MODULE$.currentOffsetAndEpoch(), (Object)inProgressDeletion.materializedOffsetAndEpoch());
        FileTierPartitionState state = new FileTierPartitionState(this.dir(), new LogDirFailureChannel(1), topicIdPartition.topicPartition(), true, (Scheduler)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().scheduler, true, false, (Time)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time(), new TierPartitionStateCleanupConfig(false, Defaults$.MODULE$.TierPartitionStateCleanupDelayMs(), 0L), true, 0);
        state.setTopicId(topicIdPartition.topicId());
        state.beginCatchup();
        state.onCatchUpComplete();
        UUID objectId3 = UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate3 = new TierSegmentUploadInitiate(topicIdPartition, 0, objectId3, 20L, 30L, 100L, 100L, 100, false, false, false, TierUploadType.Archive, new OffsetAndEpoch(8L, Optional.of(Predef$.MODULE$.int2Integer(5))), OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete3 = new TierSegmentUploadComplete(topicIdPartition, 0, objectId3, new OffsetAndEpoch(8L, Optional.of(Predef$.MODULE$.int2Integer(5))));
        TierSegmentDeleteInitiate deleteInitiate2 = new TierSegmentDeleteInitiate(topicIdPartition, 0, objectId2, new OffsetAndEpoch(9L, Optional.of(Predef$.MODULE$.int2Integer(5))));
        TierSegmentDeleteComplete deleteComplete2 = new TierSegmentDeleteComplete(topicIdPartition, 0, objectId2, Optional.of(new OffsetAndEpoch(10L, Optional.of(Predef$.MODULE$.int2Integer(5)))));
        metadataList.foreach((Function1 & Serializable)metadata -> {
            TierDeletedPartitionsCoordinatorTest.$anonfun$testCollectDeletableSegments$2(state, metadata);
            return BoxedUnit.UNIT;
        });
        new .colon.colon((Object)uploadInitiate3, (List)new .colon.colon((Object)uploadComplete3, (List)new .colon.colon((Object)deleteInitiate2, (List)new .colon.colon((Object)deleteComplete2, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)metadata -> {
            TierDeletedPartitionsCoordinatorTest.$anonfun$testCollectDeletableSegments$3(state, metadata);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FENCED, (Object)state.append((AbstractTierMetadata)uploadInitiate3, TierTestUtils$.MODULE$.currentOffsetAndEpoch()));
        Assertions.assertTrue((boolean)state.flush());
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)state.status());
        Assertions.assertEquals((Object)TierTestUtils$.MODULE$.currentOffsetAndEpoch(), (Object)state.lastLocalMaterializedSrcOffsetAndEpoch());
        ByteBuffer ftpsBuffer = CheckedFileIOTestUtils$.MODULE$.readAllBytes(Paths.get(state.flushedPath(), new String[0]));
        OffsetAndEpoch snapshotOffsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        TierMetadataSnapshotUploadComplete snapshotUploadComplete = new TierMetadataSnapshotUploadComplete(topicIdPartition, 0, UUID.randomUUID(), snapshotOffsetAndEpoch, snapshotOffsetAndEpoch, 0L, 1, Optional.of(new org.apache.kafka.raft.OffsetAndEpoch(0L, 0)));
        Assertions.assertEquals((Object)TierPartitionState.RestoreResult.SUCCEEDED, (Object)inProgressDeletion.processSnapshotMaterializationEvent(snapshotUploadComplete, ftpsBuffer, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((int)1, (int)inProgressDeletion.tieredObjects().size());
        Assertions.assertEquals((long)snapshotOffsetAndEpoch.offset(), (long)inProgressDeletion.localMaterializedOffset());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.IteratorHasAsScala(state.segments()).asScala().map((Function1 & Serializable)segment -> segment.objectId()).toSet(), (Object)inProgressDeletion.tieredObjects().keySet());
        Assertions.assertEquals((Object)snapshotOffsetAndEpoch, (Object)inProgressDeletion.materializedOffsetAndEpoch());
    }

    @Test
    public void testGarbageCollector() {
        this.createTierDeletedPartitionsCoordinator(true);
        .colon.colon topicPartitions = new .colon.colon((Object)new TopicIdPartition("foo-1", UUID.randomUUID(), 0), (List)new .colon.colon((Object)new TopicIdPartition("foo-2", UUID.randomUUID(), 2), (List)new .colon.colon((Object)new TopicIdPartition("foo-3", UUID.randomUUID(), 0), (List)Nil$.MODULE$)));
        this.deletedPartitionsCoordinator().handleImmigration(0);
        this.deletedPartitionsCoordinator().trackInitLeaderAndSnapshotUploadComplete(0, (TopicIdPartition)topicPartitions.apply(0), (Option)new Some((Object)new org.apache.kafka.raft.OffsetAndEpoch(0L, 0)));
        this.deletedPartitionsCoordinator().handleImmigration(1);
        this.deletedPartitionsCoordinator().trackInitLeaderAndSnapshotUploadComplete(1, (TopicIdPartition)topicPartitions.apply(1), (Option)new Some((Object)new org.apache.kafka.raft.OffsetAndEpoch(0L, 0)));
        this.deletedPartitionsCoordinator().handleImmigration(2);
        this.deletedPartitionsCoordinator().trackInitLeaderAndSnapshotUploadComplete(2, (TopicIdPartition)topicPartitions.apply(2), (Option)new Some((Object)new org.apache.kafka.raft.OffsetAndEpoch(0L, 0)));
        TopicImage topicImage1 = new TopicImage(((TopicIdPartition)topicPartitions.apply(0)).topic(), new Uuid(((TopicIdPartition)topicPartitions.apply(0)).topicId().getMostSignificantBits(), ((TopicIdPartition)topicPartitions.apply(0)).topicId().getLeastSignificantBits()), null, null);
        this.metadataCache().setImage(this.createMetadataImage((Seq<TopicImage>)new .colon.colon((Object)topicImage1, (List)Nil$.MODULE$), new org.apache.kafka.raft.OffsetAndEpoch(0L, 0)));
        CompletableFuture future = new CompletableFuture();
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(future);
        this.deletedPartitionsCoordinator().runGarbageCollectorTasks();
        this.verifyDeletePreInitiateCall((TopicIdPartition)topicPartitions.apply(0), 0);
        this.verifyDeletePreInitiateCall((TopicIdPartition)topicPartitions.apply(1), 1);
        this.verifyDeletePreInitiateCall((TopicIdPartition)topicPartitions.apply(2), 1);
        this.deletedPartitionsCoordinator().trackPreInitiatePartitionDelete(1, (TopicIdPartition)topicPartitions.apply(1), this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().milliseconds());
        this.deletedPartitionsCoordinator().trackPreInitiatePartitionDelete(2, (TopicIdPartition)topicPartitions.apply(2), this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().milliseconds());
        this.deletedPartitionsCoordinator().trackInitLeaderAndSnapshotUploadComplete(1, (TopicIdPartition)topicPartitions.apply(1), (Option)new Some((Object)new org.apache.kafka.raft.OffsetAndEpoch(0L, 0)));
        this.deletedPartitionsCoordinator().trackInitLeaderAndSnapshotUploadComplete(2, (TopicIdPartition)topicPartitions.apply(2), (Option)new Some((Object)new org.apache.kafka.raft.OffsetAndEpoch(0L, 0)));
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(this.initialBackoffMs() - 5L);
        this.deletedPartitionsCoordinator().runGarbageCollectorTasks();
        this.verifyDeletePreInitiateCall((TopicIdPartition)topicPartitions.apply(0), 0);
        this.verifyDeletePreInitiateCall((TopicIdPartition)topicPartitions.apply(1), 1);
        this.verifyDeletePreInitiateCall((TopicIdPartition)topicPartitions.apply(2), 1);
        this.verifyDeleteInitiateCall((TopicIdPartition)topicPartitions.apply(0), 0);
        this.verifyDeleteInitiateCall((TopicIdPartition)topicPartitions.apply(1), 0);
        this.verifyDeleteInitiateCall((TopicIdPartition)topicPartitions.apply(2), 0);
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(this.initialBackoffMs());
        this.deletedPartitionsCoordinator().runGarbageCollectorTasks();
        this.verifyDeletePreInitiateCall((TopicIdPartition)topicPartitions.apply(0), 0);
        this.verifyDeletePreInitiateCall((TopicIdPartition)topicPartitions.apply(1), 1);
        this.verifyDeletePreInitiateCall((TopicIdPartition)topicPartitions.apply(2), 1);
        this.verifyDeleteInitiateCall((TopicIdPartition)topicPartitions.apply(0), 0);
        this.verifyDeleteInitiateCall((TopicIdPartition)topicPartitions.apply(1), 1);
        this.verifyDeleteInitiateCall((TopicIdPartition)topicPartitions.apply(2), 1);
    }

    private MetadataImage createMetadataImage(Seq<TopicImage> topicImages, org.apache.kafka.raft.OffsetAndEpoch imageOffsetAndEpoch) {
        ObjectRef image = ObjectRef.create((Object)TopicsImage.EMPTY);
        topicImages.foreach((Function1 & Serializable)t -> {
            image.elem = ((TopicsImage)image.elem).including(t, TenantHelpers.NAME_TO_NULL_CALLBACK);
            return BoxedUnit.UNIT;
        });
        return new MetadataImage(new MetadataProvenance(imageOffsetAndEpoch.offset(), imageOffsetAndEpoch.epoch(), 0L), FeaturesImage.EMPTY, ClusterImage.EMPTY, (TopicsImage)image.elem, ConfigurationsImage.EMPTY, ClientQuotasImage.EMPTY, ProducerIdsImage.EMPTY, AclsImage.EMPTY, ClusterLinksImage.EMPTY, BrokerReplicaExclusionsImage.EMPTY, CellImage.EMPTY, TenantImage.EMPTY, ScramImage.EMPTY, DelegationTokenImage.EMPTY, (MetadataEncryptor)NoOpMetadataEncryptor.INSTANCE);
    }

    private void verifyDeletePreInitiateCall(TopicIdPartition topicIdPartition, int timesCalled) {
        ((TierTopicManager)Mockito.verify((Object)this.tierTopicManager(), (VerificationMode)Mockito.times((int)timesCalled))).addMetadata((AbstractTierMetadata)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<TierPartitionDeletePreInitiate>(null, topicIdPartition){
            private final TopicIdPartition topicIdPartition$2;

            public Class<?> type() {
                return super.type();
            }

            public boolean matches(TierPartitionDeletePreInitiate argument) {
                TopicIdPartition topicIdPartition = argument.topicIdPartition();
                TopicIdPartition topicIdPartition2 = this.topicIdPartition$2;
                return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition2) : topicIdPartition2 != null);
            }
            {
                this.topicIdPartition$2 = topicIdPartition$2;
            }
        }));
    }

    private void verifyDeleteInitiateCall(TopicIdPartition topicIdPartition, int timesCalled) {
        ((TierTopicManager)Mockito.verify((Object)this.tierTopicManager(), (VerificationMode)Mockito.times((int)timesCalled))).addMetadata((AbstractTierMetadata)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<TierPartitionDeleteInitiate>(null, topicIdPartition){
            private final TopicIdPartition topicIdPartition$3;

            public Class<?> type() {
                return super.type();
            }

            public boolean matches(TierPartitionDeleteInitiate argument) {
                TopicIdPartition topicIdPartition = argument.topicIdPartition();
                TopicIdPartition topicIdPartition2 = this.topicIdPartition$3;
                return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition2) : topicIdPartition2 != null);
            }
            {
                this.topicIdPartition$3 = topicIdPartition$3;
            }
        }));
    }

    private void createTierDeletedPartitionsCoordinator(boolean hasTieredObjectGC) {
        None$ tieredObjectGC = hasTieredObjectGC ? new Some((Function0 & Serializable)() -> new TierObjectGarbageCollector(this.tierTopicManager(), this.metadataCache(), (Time)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time())) : None$.MODULE$;
        this.deletedPartitionsCoordinator_$eq(new TierDeletedPartitionsCoordinator((Scheduler)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$scheduler(), this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager(), this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer(), 1L, 100, this.initialBackoffMs(), "foo", (Time)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time(), (Option)tieredObjectGC));
        this.deletedPartitionsCoordinator().registerListener((DeletedPartitionsChangeListener)new Listener());
    }

    private MemoryRecords initiateSegmentUpload(TopicIdPartition topicIdPartition, int leaderEpoch, UUID objectId, long baseOffset, long endOffset) {
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, leaderEpoch, objectId, baseOffset, endOffset, 10L, 100L, 500, true, true, true, TierUploadType.Archive, new OffsetAndEpoch(0L, Optional.of(Predef$.MODULE$.int2Integer(0))), OpaqueData.ZEROED);
        return this.memoryRecords((AbstractTierMetadata)uploadInitiate);
    }

    private MemoryRecords initiatePartitionDeletion(TopicIdPartition topicIdPartition) {
        return this.memoryRecords((AbstractTierMetadata)new TierPartitionDeleteInitiate(topicIdPartition, 0, UUID.randomUUID()));
    }

    private MemoryRecords completePartitionDeletion(TopicIdPartition topicIdPartition) {
        return this.memoryRecords((AbstractTierMetadata)new TierPartitionDeleteComplete(topicIdPartition, UUID.randomUUID()));
    }

    /*
     * WARNING - void declaration
     */
    private MemoryRecords memoryRecords(AbstractTierMetadata metadata) {
        void withRecords_records;
        void withRecords_compressionType;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(0L, metadata.serializeKey(), metadata.serializeValue())};
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = 0L;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        return MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
    }

    private AbstractLog createLog(File dir, LogConfig config, BrokerTopicStats brokerTopicStats, long logStartOffset, long recoveryPoint, Scheduler scheduler, Time time, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs) {
        ProducerStateManagerConfig x$8 = new ProducerStateManagerConfig(maxProducerIdExpirationMs, false);
        ChecksumParams x$10 = TestUtils$.MODULE$.createChecksumParams();
        int x$11 = 300000;
        TierLogComponents x$12 = TierLogComponents$.MODULE$.EMPTY();
        LogDirFailureChannel x$13 = new LogDirFailureChannel(10);
        LogOffsetsListener x$14 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        boolean x$15 = true;
        None$ x$16 = None$.MODULE$;
        boolean x$17 = true;
        ConcurrentHashMap<String, Object> x$18 = new ConcurrentHashMap<String, Object>();
        return LogTestUtils$.MODULE$.createLog(dir, config, brokerTopicStats, scheduler, time, logStartOffset, recoveryPoint, x$11, x$8, producerIdExpirationCheckIntervalMs, x$12, x$13, x$14, x$15, (Option<Uuid>)x$16, x$17, x$18, x$10);
    }

    private LogConfig createLog$default$2() {
        return LogTestUtils$.MODULE$.createLogConfig(604800000L, 0x40000000, 604800000L, -2L, -1L, -2L, 0L, "delete", 0x10000C, 4096, 0xA00000, LogConfig.DEFAULT_MESSAGE_FORMAT_VERSION, 60000L, false, -1L, 86400000L, 0x6400000, -1L, true, 1L, Long.MAX_VALUE, false);
    }

    private BrokerTopicStats createLog$default$3() {
        return new BrokerTopicStats();
    }

    private long createLog$default$4() {
        return 0L;
    }

    private long createLog$default$5() {
        return 0L;
    }

    private Scheduler createLog$default$6() {
        return this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$scheduler();
    }

    private Time createLog$default$7() {
        return this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time();
    }

    private int createLog$default$8() {
        return 3600000;
    }

    private int createLog$default$9() {
        return 600000;
    }

    public static final /* synthetic */ void $anonfun$testInitiateDeletion$3(TierDeletedPartitionsCoordinatorTest $this, int tierTopicPartitionId$1, TopicIdPartition deletedPartition) {
        $this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(tierTopicPartitionId$1, deletedPartition, 10L);
    }

    public static final /* synthetic */ void $anonfun$testInitiateDeletion$2(TierDeletedPartitionsCoordinatorTest $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            int tierTopicPartitionId = x0$1._1$mcI$sp();
            ((scala.collection.immutable.Set)x0$1._2()).foreach((Function1 & Serializable)deletedPartition -> {
                TierDeletedPartitionsCoordinatorTest.$anonfun$testInitiateDeletion$3($this, tierTopicPartitionId, deletedPartition);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ long $anonfun$testInitiateDeletion$5(ImmigratedTierTopicPartition x$2) {
        return x$2.pendingDeletions().size();
    }

    public static final /* synthetic */ long $anonfun$testInitiateDeletion$7(ImmigratedTierTopicPartition x$3) {
        return x$3.pendingDeletions().size();
    }

    public static final /* synthetic */ void $anonfun$testCompleteDeletion$3(TierDeletedPartitionsCoordinatorTest $this, int tierTopicPartitionId$2, LongRef offset$1, TopicIdPartition deletedPartition) {
        $this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(tierTopicPartitionId$2, deletedPartition, offset$1.elem);
        ++offset$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testCompleteDeletion$2(TierDeletedPartitionsCoordinatorTest $this, LongRef offset$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            int tierTopicPartitionId = x0$1._1$mcI$sp();
            ((scala.collection.immutable.Set)x0$1._2()).foreach((Function1 & Serializable)deletedPartition -> {
                TierDeletedPartitionsCoordinatorTest.$anonfun$testCompleteDeletion$3($this, tierTopicPartitionId, offset$1, deletedPartition);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ long $anonfun$testCompleteDeletion$4(ImmigratedTierTopicPartition x$4) {
        return x$4.pendingDeletions().size();
    }

    public static final /* synthetic */ int $anonfun$testBeginMaterialization$1(ImmigratedTierTopicPartition x$5) {
        return x$5.pendingDeletions().size();
    }

    public static final /* synthetic */ int $anonfun$testBeginMaterialization$2(ImmigratedTierTopicPartition x$6) {
        return x$6.pendingDeletions().size();
    }

    public static final /* synthetic */ void $anonfun$testBeginMaterialization$3(TierDeletedPartitionsCoordinatorTest $this, TopicIdPartition topicIdPartition) {
        ((TierTopicConsumer)Mockito.verify((Object)$this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer(), (VerificationMode)Mockito.times((int)1))).deregister((TopicIdPartition)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<TopicIdPartition>(null, topicIdPartition){
            private final TopicIdPartition topicIdPartition$1;

            public Class<?> type() {
                return super.type();
            }

            public boolean matches(TopicIdPartition argument) {
                TopicIdPartition topicIdPartition = argument;
                TopicIdPartition topicIdPartition2 = this.topicIdPartition$1;
                return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition2) : topicIdPartition2 != null);
            }
            {
                this.topicIdPartition$1 = topicIdPartition$1;
            }
        }));
    }

    public static final /* synthetic */ ObjectMetadata $anonfun$testDeletePartition$1(TopicIdPartition deletedPartition_1$1, int i) {
        return new ObjectMetadata(deletedPartition_1$1, UUID.randomUUID(), 0, (long)i, false, false, false, OpaqueData.ZEROED, null);
    }

    public static final /* synthetic */ ObjectMetadata $anonfun$testDuplicateDeleteInitiate$1(TopicIdPartition partition$1, int i) {
        return new ObjectMetadata(partition$1, UUID.randomUUID(), 0, (long)i, false, false, false, OpaqueData.ZEROED, null);
    }

    public static final /* synthetic */ void $anonfun$testDuplicateDeleteInitiate$2(LongRef offset$3, InProgressDeletion inProgress$1, ObjectMetadata segment) {
        OffsetAndEpoch stateOffsetAndEpoch = new OffsetAndEpoch(offset$3.elem, Optional.of(Predef$.MODULE$.int2Integer(0)));
        inProgress$1.process((AbstractTierMetadata)new TierSegmentUploadInitiate(segment.topicIdPartition(), segment.tierEpoch(), segment.objectId(), segment.baseOffset(), segment.baseOffset() + 1L, 0L, 100L, 100, false, false, false, TierUploadType.Archive, stateOffsetAndEpoch, OpaqueData.ZEROED), stateOffsetAndEpoch);
        ++offset$3.elem;
    }

    public static final /* synthetic */ void $anonfun$testCollectDeletableSegments$2(FileTierPartitionState state$1, AbstractTierMetadata metadata) {
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state$1.append(metadata, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
    }

    public static final /* synthetic */ void $anonfun$testCollectDeletableSegments$3(FileTierPartitionState state$1, AbstractTierSegmentMetadata metadata) {
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state$1.append((AbstractTierMetadata)metadata, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
    }

    public TierDeletedPartitionsCoordinatorTest() {
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$scheduler = this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().scheduler;
        this.tieredObjects = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.dir = TestUtils.tempDirectory(null, null);
        this.logDir = TestUtils$.MODULE$.randomPartitionForTopicLogDir(this.dir(), "kafka");
        File parseTopicPartitionName_dir = this.logDir();
        this.tierTopicPartition = LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir);
        this.initialBackoffMs = 10L;
    }

    private class Listener
    implements DeletedPartitionsChangeListener {
        public void initiatePartitionDeletion(TopicIdPartition topicIdPartition, List<ObjectMetadata> tieredObjects) {
        }

        public void stopPartitionDeletion(TopicIdPartition topicIdPartition) {
        }

        public /* synthetic */ TierDeletedPartitionsCoordinatorTest kafka$tier$TierDeletedPartitionsCoordinatorTest$Listener$$$outer() {
            return TierDeletedPartitionsCoordinatorTest.this;
        }

        public Listener() {
            if (TierDeletedPartitionsCoordinatorTest.this == null) {
                throw null;
            }
        }
    }
}

