/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import io.confluent.kafka.storage.checksum.Algorithm;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.api.IntegrationTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.TierLogSegment;
import kafka.restore.ResetTierPartitionState;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.MemoryTracker;
import kafka.tier.fetcher.TierFetcher;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.FileTierPartitionStateUploadObject;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreFunctionUtils;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.FileTierPartitionStateRecoveryUploadMetadata;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;
import kafka.tier.tools.RecoveryTestUtils;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.TierMetadataComparator;
import kafka.tier.tools.TierPartitionStateRestoreTrigger;
import kafka.tier.tools.TierPartitionUnfreezeLogStartOffsetTrigger;
import kafka.tier.tools.common.FenceEventInfo;
import kafka.tier.tools.common.RestoreComparatorInfo;
import kafka.tier.tools.common.RestoreRawOutputInfoLocal;
import kafka.tier.tools.common.RestoreRawOutputInfoRemoteURI;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Tag(value="bazel:shard_count:5")
@ScalaSignature(bytes="\u0006\u0005\rea\u0001\u0002\u0014(\u00011BQa\r\u0001\u0005\u0002QBQa\u000e\u0001\u0005RaBQa\u0010\u0001\u0005\n\u0001Cq\u0001\u0012\u0001C\u0002\u0013%Q\t\u0003\u0004O\u0001\u0001\u0006IA\u0012\u0005\b\u001f\u0002\u0011\r\u0011\"\u00039\u0011\u0019\u0001\u0006\u0001)A\u0005s!)\u0011\u000b\u0001C\u0005%\"9!\u000e\u0001b\u0001\n\u0003Y\u0007B\u0002<\u0001A\u0003%A\u000eC\u0003x\u0001\u0011\u0005\u0003\u0010\u0003\u0004\u0002\u0012\u0001!\t\u0005\u0011\u0005\b\u00037\u0001A\u0011AA\u000f\u0011\u001d\ty\u0006\u0001C\u0001\u0003CBq!a\u001b\u0001\t\u0013\ti\u0007C\u0004\u0002>\u0002!I!a0\t\u000f\u00055\u0007\u0001\"\u0003\u0002P\"9\u0011Q\u001a\u0001\u0005\u0002\u0005u\u0007bBAt\u0001\u0011\u0005\u0011\u0011\u001e\u0005\b\u0003g\u0004A\u0011AA{\u0011\u001d\ty\u0010\u0001C\u0005\u0005\u0003AqA!\u0002\u0001\t\u0013\u00119\u0001C\u0004\u0003\u0016\u0001!\tAa\u0006\t\u000f\t\u0005\u0002\u0001\"\u0001\u0003$!9!Q\u0006\u0001\u0005\u0002\t=\u0002b\u0002B\u001b\u0001\u0011\u0005!q\u0007\u0005\b\u0005\u0003\u0002A\u0011\u0001B\"\u0011\u001d\u0011i\u0005\u0001C\u0005\u0005\u001fBqA!\u0017\u0001\t\u0013\u0011Y\u0006C\u0004\u0003j\u0001!IAa\u001b\t\u000f\tM\u0004\u0001\"\u0003\u0003v!9!\u0011\u0010\u0001\u0005\n\tm\u0004b\u0002B=\u0001\u0011%!1\u0011\u0005\b\u0005\u001b\u0003A\u0011\u0002BH\u0011\u001d\u0011\t\f\u0001C\u0005\u0005gCqAa6\u0001\t\u0013\u0011I\u000eC\u0004\u0003b\u0002!IAa9\u00037QKWM]%oi\u0016<'/\u0019;j_:,e\u000e\u001a+p\u000b:$G+Z:u\u0015\tA\u0013&\u0001\u0003uS\u0016\u0014(\"\u0001\u0016\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\f\t\u0003]Ej\u0011a\f\u0006\u0003a%\n1!\u00199j\u0013\t\u0011tF\u0001\fJ]R,wM]1uS>tG+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\tQ\u0007\u0005\u00027\u00015\tq%A\u0006ce>\\WM]\"pk:$X#A\u001d\u0011\u0005ijT\"A\u001e\u000b\u0003q\nQa]2bY\u0006L!AP\u001e\u0003\u0007%sG/A\u0007d_:4\u0017nZ;sK6{7m\u001b\u000b\u0002\u0003B\u0011!HQ\u0005\u0003\u0007n\u0012A!\u00168ji\u0006)Ao\u001c9jGV\ta\t\u0005\u0002H\u00196\t\u0001J\u0003\u0002J\u0015\u0006!A.\u00198h\u0015\u0005Y\u0015\u0001\u00026bm\u0006L!!\u0014%\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005Q\u0001/\u0019:uSRLwN\\:\u0002\u0017A\f'\u000f^5uS>t7\u000fI\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8ogV\t1\u000bE\u0002U9~s!!\u0016.\u000f\u0005YKV\"A,\u000b\u0005a[\u0013A\u0002\u001fs_>$h(C\u0001=\u0013\tY6(A\u0004qC\u000e\\\u0017mZ3\n\u0005us&aA*fc*\u00111l\u000f\t\u0003A\"l\u0011!\u0019\u0006\u0003E\u000e\faaY8n[>t'B\u0001\u0016e\u0015\t)g-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0006\u0019qN]4\n\u0005%\f'A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0007KbLG/\u001a3\u0016\u00031\u0004\"!\u001c;\u000e\u00039T!a\u001c9\u0002\r\u0005$x.\\5d\u0015\t\t(/\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u001d&\u0002\tU$\u0018\u000e\\\u0005\u0003k:\u0014Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017aB3ySR,G\rI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u0003fDQA_\u0006A\u0002m\f\u0001\u0002^3ti&sgm\u001c\t\u0004y\u0006\u0015Q\"A?\u000b\u0005Ar(bA@\u0002\u0002\u00059!.\u001e9ji\u0016\u0014(bAA\u0002M\u0006)!.\u001e8ji&\u0019\u0011qA?\u0003\u0011Q+7\u000f^%oM>D3aCA\u0006!\ra\u0018QB\u0005\u0004\u0003\u001fi(A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eK\u0002\r\u0003+\u00012\u0001`A\f\u0013\r\tI\" \u0002\n\u0003\u001a$XM]#bG\"\fq\u0003^3ti\u0006\u00138\r[5wK\u0006sG\rV5fe\u001a+Go\u00195\u0015\u0007\u0005\u000by\u0002C\u0004\u0002\"5\u0001\r!a\t\u0002\rE,xN];n!\u0011\t)#!\f\u000f\t\u0005\u001d\u0012\u0011\u0006\t\u0003-nJ1!a\u000b<\u0003\u0019\u0001&/\u001a3fM&\u0019Q*a\f\u000b\u0007\u0005-2\bK\u0004\u000e\u0003g\ty$!\u0011\u0011\t\u0005U\u00121H\u0007\u0003\u0003oQ1!!\u000f\u007f\u0003\u0019\u0001\u0018M]1ng&!\u0011QHA\u001c\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0005]\u0006lW-\t\u0002\u0002D\u0005\u00113\u0010Z5ta2\f\u0017PT1nKvt30\u0019:hk6,g\u000e^:XSRDg*Y7fgvDs!DA$\u0003'\n)\u0006\u0005\u0003\u0002J\u0005=SBAA&\u0015\u0011\ti%a\u000e\u0002\u0011A\u0014xN^5eKJLA!!\u0015\u0002L\tYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONdC!a\u0016\u0002\\\u0005\u0012\u0011\u0011L\u0001\u0003u.\f#!!\u0018\u0002\u000b-\u0014\u0018M\u001a;\u0002AQ,7\u000f^!sG\"Lg/Z!oIB\u0013XMZ3se\u0016$G+[3s\r\u0016$8\r\u001b\u000b\u0004\u0003\u0006\r\u0004bBA\u0011\u001d\u0001\u0007\u00111\u0005\u0015\b\u001d\u0005M\u0012qHA!Q\u001dq\u0011qIA*\u0003SbC!a\u0016\u0002\\\u0005Ab/\u00197jI\u0006$XMR3oG\u0016$vn\u001c7SKN,H\u000e^:\u0015\u0013\u0005\u000by'!#\u0002 \u00065\u0006bBA9\u001f\u0001\u0007\u00111O\u0001\fM\u0016t7-Z#wK:$8\u000f\u0005\u0004\u0002v\u0005]\u00141P\u0007\u0002e&\u0019\u0011\u0011\u0010:\u0003\t1K7\u000f\u001e\t\u0005\u0003{\n))\u0004\u0002\u0002\u0000)\u0019!-!!\u000b\u0007\u0005\ru%A\u0003u_>d7/\u0003\u0003\u0002\b\u0006}$A\u0004$f]\u000e,WI^3oi&sgm\u001c\u0005\b\u0003\u0017{\u0001\u0019AAG\u0003=!\b/\u00133t)>\u0014UMR3oG\u0016$\u0007\u0003CA;\u0003\u001f\u000b\u0019*!'\n\u0007\u0005E%OA\u0002NCB\u00042ANAK\u0013\r\t9j\n\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u00042aRAN\u0013\r\ti\n\u0013\u0002\b\u0005>|G.Z1o\u0011\u001d\t\tk\u0004a\u0001\u0003G\u000b1\u0001\\8h!\u0011\t)+!+\u000e\u0005\u0005\u001d&bAAQS%!\u00111VAT\u0005%iUM]4fI2{w\rC\u0004\u00020>\u0001\r!!-\u0002%QLWM\u001d)beRLG/[8o'R\fG/\u001a\t\u0005\u0003g\u000bI,\u0004\u0002\u00026*\u0019\u0011qW\u0014\u0002\u000bM$\u0018\r^3\n\t\u0005m\u0016Q\u0017\u0002\u0013)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$X-A\u000ewC2LG-\u0019;f%\u0016\u001cHo\u001c:f)>|Gn\u001d*fgVdGo\u001d\u000b\f\u0003\u0006\u0005\u00171YAd\u0003\u0013\fY\rC\u0004\u0002rA\u0001\r!a\u001d\t\u000f\u0005\u0015\u0007\u00031\u0001\u0002$\u0005\t\"/Z:u_J,w*\u001e;qkRT5o\u001c8\t\u000f\u0005-\u0005\u00031\u0001\u0002\u000e\"9\u0011\u0011\u0015\tA\u0002\u0005\r\u0006bBAX!\u0001\u0007\u0011\u0011W\u0001(i\u0016\u001cH/\u0011:dQ&4X-\u00118e)&,'OR3uG\"4UM\\2f\u0003:$'+Z2pm\u0016\u0014\u0018\u0010F\u0003B\u0003#\fI\u000eC\u0004\u0002TF\u0001\r!!6\u0002%U\u001cXMU3ti>\u0014XMU1x\u0013:\u0004X\u000f\u001e\t\u0004u\u0005]\u0017bAAOw!9\u00111\\\tA\u0002\u0005U\u0017A\u00074sK\u0016TX-T3sO\u0016$Gj\\4Ti\u0006\u0014Ho\u00144gg\u0016$HcA!\u0002`\"9\u0011\u0011\u0005\nA\u0002\u0005\r\u0002f\u0002\n\u00024\u0005}\u0012\u0011\t\u0015\b%\u0005\u001d\u00131KAsY\u0011\t9&a\u0017\u0002uQ,7\u000f^!sG\"Lg/Z!oIRKWM\u001d$fi\u000eDg)\u001a8dK\u0006sGMU3d_Z,'/_,ji\"\u0014Vm\u001d;pe\u0016\u0014\u0016m^%oaV$HcA!\u0002l\"9\u0011\u0011E\nA\u0002\u0005\r\u0002fB\n\u00024\u0005}\u0012\u0011\t\u0015\b'\u0005\u001d\u00131KAyY\u0011\t9&a\u0017\u0002\u000bR,7\u000f^!sG\"Lg/Z!oIRKWM\u001d$fi\u000eDg)\u001a8dK\u0006sGMU3d_Z,'/_,ji\"lUM]4fI2{wm\u0015;beR|eMZ:fi\u001a\u0013xN_3o)\r\t\u0015q\u001f\u0005\b\u0003C!\u0002\u0019AA\u0012Q\u001d!\u00121GA \u0003\u0003Bs\u0001FA$\u0003'\ni\u0010\f\u0003\u0002X\u0005m\u0013\u0001\u000e;fgR\f%o\u00195jm\u0016\fe\u000e\u001a+jKJ4U\r^2i\r\u0016t7-Z!oIJ+7m\u001c<fef<\u0016\u000e\u001e5SK6|G/Z+S\u0013R\u0019\u0011Ia\u0001\t\u000f\u0005mW\u00031\u0001\u0002V\u0006Ac/\u00197jI\u0006$XMU3ti>\u0014X\rV8pYN<\u0016\u000e\u001e5SK6|G/Z+S\u0013J+7/\u001e7ugRY\u0011I!\u0003\u0003\f\t=!\u0011\u0003B\n\u0011\u001d\t\tH\u0006a\u0001\u0003gBqA!\u0004\u0017\u0001\u0004\t\u0019#\u0001\u0010sKN$xN]3XSRD'+Z7pi\u0016,&+S(viB,HOS:p]\"9\u00111\u0012\fA\u0002\u00055\u0005bBAQ-\u0001\u0007\u00111\u0015\u0005\b\u0003_3\u0002\u0019AAY\u0003U\"Xm\u001d;Be\u000eD\u0017N^3B]\u0012$\u0016.\u001a:GKR\u001c\u0007NR3oG\u0016\fe\u000e\u001a*fG>4XM]=XSRD'+Z7pi\u0016,&+S:\u0015\u0007\u0005\u0013I\u0002C\u0004\u0002\"]\u0001\r!a\t)\u000f]\t\u0019$a\u0010\u0002B!:q#a\u0012\u0002T\t}A\u0006BA,\u00037\nq\n^3ti\u0006\u00138\r[5wK\u0006sG\rV5fe\u001a+Go\u00195GK:\u001cW-\u00118e%\u0016\u001cwN^3ssJ+Wn\u001c;f+JK5oV5uQ6+'oZ3e\u0019><7\u000b^1si>3gm]3u\rJ|'0\u001a8\u0015\u0007\u0005\u0013)\u0003C\u0004\u0002\"a\u0001\r!a\t)\u000fa\t\u0019$a\u0010\u0002B!:\u0001$a\u0012\u0002T\t-B\u0006BA,\u00037\nA\u0003^3ti\u000ecW-\u0019:BY2$\u0016.\u001a:ECR\fGcA!\u00032!9!1G\rA\u0002\u0005U\u0017!C5t\u0007>l\u0007/Y2u\u0003!\"Xm\u001d;DY\u0016\f'/\u00117m)&,'\u000fR1uC\u001a{'OT8o\u0007>l\u0007/Y2uK\u0012$v\u000e]5d)\r\t%\u0011\b\u0005\b\u0003CQ\u0002\u0019AA\u0012Q\u001dQ\u00121GA \u0003\u0003BsAGA$\u0003'\u0012y\u0004\f\u0003\u0002X\u0005m\u0013!\n;fgR\u001cE.Z1s\u00032dG+[3s\t\u0006$\u0018MR8s\u0007>l\u0007/Y2uK\u0012$v\u000e]5d)\r\t%Q\t\u0005\b\u0003CY\u0002\u0019AA\u0012Q\u001dY\u00121GA \u0003\u0003BsaGA$\u0003'\u0012Y\u0005\f\u0003\u0002X\u0005m\u0013A\u00049s_\u0012,8-\u001a*fG>\u0014Hm\u001d\u000b\u0006\u0003\nE#Q\u000b\u0005\u0007\u0005'b\u0002\u0019A\u001d\u0002\u00119\u0014\u0015\r^2iKNDaAa\u0016\u001d\u0001\u0004I\u0014a\u0004:fG>\u0014Hm\u001d)fe\n\u000bGo\u00195\u00025\u001d,G\u000fT3bI\u0016\u0014hi\u001c:U_BL7\rU1si&$\u0018n\u001c8\u0015\u000be\u0012iF!\u0019\t\r\t}S\u00041\u0001`\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:DqAa\u0019\u001e\u0001\u0004\u0011)'\u0001\u000bqCJ$\u0018\u000e^5p]R{G*Z1eKJl\u0015\r\u001d\t\u0007\u0003K\u00119'O\u001d\n\t\u0005E\u0015qF\u0001\u0018o\u0006LG/\u00168uS2\u001cVmZ7f]R\u001cH+[3sK\u0012$R!\u0011B7\u0005cBaAa\u001c\u001f\u0001\u0004I\u0014AD7j]:+XnU3h[\u0016tGo\u001d\u0005\b\u0005Gr\u0002\u0019\u0001B3\u0003E\u0019\u0018.\\;mCR,'+\u001a;f]RLwN\u001c\u000b\u0004\u0003\n]\u0004b\u0002B2?\u0001\u0007!QM\u0001\u001cG>t7/^7f\u0003:$g+\u00197jI\u0006$X\rV5fe\u001a+Go\u00195\u0015\u000f\u0005\u0013iHa \u0003\u0002\"9!1\r\u0011A\u0002\t\u0015\u0004B\u0002B*A\u0001\u0007\u0011\b\u0003\u0004\u0003X\u0001\u0002\r!\u000f\u000b\n\u0003\n\u0015%q\u0011BE\u0005\u0017CqAa\u0019\"\u0001\u0004\u0011)\u0007\u0003\u0004\u0003T\u0005\u0002\r!\u000f\u0005\u0007\u0005/\n\u0003\u0019A\u001d\t\u000f\tM\u0012\u00051\u0001\u0002V\u0006\u0011rO]5uKJ+7m\u001c<fe\u000e{gNZ5h)!\u0011\tJ!(\u0003*\n5\u0006\u0003\u0002BJ\u00053k!A!&\u000b\u0007\t]%*\u0001\u0002j_&!!1\u0014BK\u0005\u00111\u0015\u000e\\3\t\u000f\t}%\u00051\u0001\u0003\"\u0006\u0001B/[3s\u00072LWM\u001c;D_:4\u0017n\u001a\t\t\u0003k\ny)a\t\u0003$B\u0019qI!*\n\u0007\t\u001d\u0006J\u0001\u0004PE*,7\r\u001e\u0005\b\u0005W\u0013\u0003\u0019\u0001BI\u0003)9xN]6j]\u001e$\u0015N\u001d\u0005\b\u0005_\u0013\u0003\u0019\u0001BI\u0003E\u0011'o\\6fe^{'o\u001b3je2K7\u000f^\u0001&CN\u001cXM\u001d;US6,7\u000f^1na\u001a{'o\u00144gg\u0016$Hj\\8lkB\u001cuN\u001d:fGR$\u0012\"\u0011B[\u0005o\u0013IMa5\t\r\t}3\u00051\u0001`\u0011\u001d\u0011Il\ta\u0001\u0005w\u000b\u0001bY8ogVlWM\u001d\t\t\u0005{\u0013)-a\t\u0002$5\u0011!q\u0018\u0006\u0005\u0005s\u0013\tMC\u0002\u0003D\u000e\fqa\u00197jK:$8/\u0003\u0003\u0003H\n}&\u0001C\"p]N,X.\u001a:\t\u000f\t-7\u00051\u0001\u0003N\u0006IA/[7fgR\fW\u000e\u001d\t\u0004u\t=\u0017b\u0001Biw\t!Aj\u001c8h\u0011\u001d\u0011)n\ta\u0001\u0005\u001b\fa\"\u001a=qK\u000e$X\rZ(gMN,G/A\u0013bgN,'\u000f\u001e+j[\u0016\u001cH/Y7q\r>\u0014xJ\u001a4tKRdun\\6va6K7o]5oOR9\u0011Ia7\u0003^\n}\u0007B\u0002B0I\u0001\u0007q\fC\u0004\u0003:\u0012\u0002\rAa/\t\u000f\t-G\u00051\u0001\u0003N\u0006Y1M]3bi\u0016$v\u000e]5d)1\u0011)Oa=\u0003v\ne(Q`B\u0004!\u0019\u00119O!=:s5\u0011!\u0011\u001e\u0006\u0005\u0005W\u0014i/A\u0005j[6,H/\u00192mK*\u0019!q^\u001e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0012\n%\bB\u0002#&\u0001\u0004\t\u0019\u0003\u0003\u0004\u0003x\u0016\u0002\r!O\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\t\r\tmX\u00051\u0001:\u0003E\u0011X\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\u0005\b\u0005\u007f,\u0003\u0019AB\u0001\u0003-!x\u000e]5d\u0007>tg-[4\u0011\t\u0005U41A\u0005\u0004\u0007\u000b\u0011(A\u0003)s_B,'\u000f^5fg\"91\u0011B\u0013A\u0002\r\u0005\u0011!E1e[&t7\t\\5f]R\u001cuN\u001c4jO\":\u0001a!\u0004\u0004\u0014\rU\u0001c\u0001?\u0004\u0010%\u00191\u0011C?\u0003\u0007Q\u000bw-A\u0003wC2,X-\t\u0002\u0004\u0018\u0005\u0019\"-\u0019>fYj\u001a\b.\u0019:e?\u000e|WO\u001c;;k\u0001")
public class TierIntegrationEndToEndTest
extends IntegrationTestHarness {
    private final String topic;
    private final int partitions;
    private final AtomicBoolean exited;

    @Override
    public int brokerCount() {
        return 1;
    }

    private void configureMock() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), "mybucket");
    }

    private String topic() {
        return this.topic;
    }

    private int partitions() {
        return this.partitions;
    }

    private scala.collection.immutable.Seq<TopicPartition> topicPartitions() {
        return package$.MODULE$.Range().apply(0, this.partitions()).map((Function1 & Serializable)p -> TierIntegrationEndToEndTest.$anonfun$topicPartitions$1(this, BoxesRunTime.unboxToInt((Object)p)));
    }

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        Exit.setExitProcedure((x$1, x$2) -> this.exited().set(true));
        super.setUp(testInfo);
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        Assertions.assertFalse((boolean)this.exited().get());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testArchiveAndTierFetch(String quorum) {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("confluent.tier.local.hotset.bytes", "5000");
        props.put("retention.bytes", "-1");
        scala.collection.immutable.Map<Object, Object> partitionToLeaderMap = this.createTopic(this.topic(), this.partitions(), 1, props, this.adminClientConfig());
        int nBatches = 100;
        int recordsPerBatch = 100;
        this.produceRecords(nBatches, recordsPerBatch);
        this.waitUntilSegmentsTiered(5, partitionToLeaderMap);
        this.simulateRetention(partitionToLeaderMap);
        this.consumeAndValidateTierFetch(partitionToLeaderMap, nBatches, recordsPerBatch);
        Predef$.MODULE$.assert(((KafkaBroker)this.brokers().head()).brokerTopicStats().allTopicsStats().logAppendLatencyMs().count() > 0L);
        Predef$.MODULE$.assert(((KafkaBroker)this.brokers().head()).brokerTopicStats().allTopicsStats().logAppendDataSizeInBytes().count() > 0L);
        Predef$.MODULE$.assert(((KafkaBroker)this.brokers().head()).brokerTopicStats().allTopicsStats().logAppendRate().count() > 0L);
        Predef$.MODULE$.assert(((KafkaBroker)this.brokers().head()).brokerTopicStats().allTopicsStats().tierLogFetchLatencyMs().count() > 0L);
        Predef$.MODULE$.assert(((KafkaBroker)this.brokers().head()).brokerTopicStats().allTopicsStats().localLogFetchLatencyMs().count() > 0L);
        Predef$.MODULE$.assert(((KafkaBroker)this.brokers().head()).brokerTopicStats().allTopicsStats().logFetchDataSizeInBytes().count() > 0L);
        Predef$.MODULE$.assert(((KafkaBroker)this.brokers().head()).brokerTopicStats().allTopicsStats().logFetchRate().count() > 0L);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testArchiveAndPreferredTierFetch(String quorum) {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("retention.bytes", "-1");
        props.put("confluent.tier.local.hotset.ms", "-1");
        props.put("confluent.tier.local.hotset.bytes", "-1");
        props.put("confluent.prefer.tier.fetch.ms", "0");
        scala.collection.immutable.Map<Object, Object> partitionToLeaderMap = this.createTopic(this.topic(), this.partitions(), 1, props, this.adminClientConfig());
        int nBatches = 100;
        int recordsPerBatch = 100;
        this.produceRecords(nBatches, recordsPerBatch);
        this.waitUntilSegmentsTiered(5, partitionToLeaderMap);
        this.consumeAndValidateTierFetch(partitionToLeaderMap, nBatches, recordsPerBatch);
    }

    /*
     * WARNING - void declaration
     */
    private void validateFenceToolResults(java.util.List<FenceEventInfo> fenceEvents, java.util.Map<TopicIdPartition, Boolean> tpIdsToBeFenced, MergedLog log, TierPartitionState tierPartitionState) {
        Map.Entry<TopicIdPartition, Boolean> entry = tpIdsToBeFenced.entrySet().iterator().next();
        TopicIdPartition topicIdToBeFenced = entry.getKey();
        Boolean freezeMergedLogStartOffset = entry.getValue();
        Assertions.assertTrue((fenceEvents.size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((new TopicIdPartition(fenceEvents.get(0).topic(), CoreUtils$.MODULE$.uuidFromBase64(fenceEvents.get((int)0).topicIdBase64), fenceEvents.get((int)0).partition).equals(topicIdToBeFenced) ? 1 : 0) != 0);
        Boolean bl = fenceEvents.get((int)0).freezeMergedLogStartOffset;
        Assertions.assertTrue((!(bl != null ? !((Object)bl).equals(freezeMergedLogStartOffset) : freezeMergedLogStartOffset != null) ? 1 : 0) != 0);
        if (Predef$.MODULE$.Boolean2boolean(freezeMergedLogStartOffset)) {
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TierIntegrationEndToEndTest.$anonfun$validateFenceToolResults$1(tierPartitionState, log)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"timeout waiting for partition to be transitioned to the required status");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            return;
        }
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationEndToEndTest.$anonfun$validateFenceToolResults$3(tierPartitionState, log)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"timeout waiting for partition to be transitioned to the required status");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void validateRestoreToolsResults(java.util.List<FenceEventInfo> fenceEvents, String restoreOutputJson, java.util.Map<TopicIdPartition, Boolean> tpIdsToBeFenced, MergedLog log, TierPartitionState tierPartitionState) {
        freezeMergedLogStartOffset = tpIdsToBeFenced.entrySet().iterator().next().getValue();
        restoreRawOutputList = RestoreRawOutputInfoLocal.readJsonFromFile((Path)Paths.get(restoreOutputJson, new String[0]));
        if (restoreRawOutputList.size() != 1) ** GOTO lbl-1000
        v0 = ((RestoreRawOutputInfoLocal)restoreRawOutputList.get((int)0)).input().fenceEventInfo().freezeMergedLogStartOffset;
        var8_8 = fenceEvents.get((int)0).freezeMergedLogStartOffset;
        if (!(v0 != null ? v0.equals(var8_8) == false : var8_8 != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        Assertions.assertTrue((boolean)v1);
        if (Predef$.MODULE$.Boolean2boolean(freezeMergedLogStartOffset)) {
            var11_9 = 100L;
            waitUntilTrue_waitTimeMs = 15000L;
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TierIntegrationEndToEndTest.$anonfun$validateRestoreToolsResults$1(tierPartitionState, log)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"log and/or tier partition state is in unexpected status");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            return;
        }
        var17_12 = 100L;
        waitUntilTrue_waitTimeMs = 15000L;
        waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationEndToEndTest.$anonfun$validateRestoreToolsResults$3(tierPartitionState, log)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"log and/or tier partition state is in unexpected status");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void testArchiveAndTierFetchFenceAndRecovery(boolean useRestoreRawInput, boolean freezeMergedLogStartOffset) {
        props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("confluent.tier.local.hotset.bytes", "5000");
        props.put("retention.bytes", "-1");
        partitionToLeaderMap = this.createTopic(this.topic(), this.partitions(), 1, props, this.adminClientConfig());
        nBatches = 100;
        recordsPerBatch = 100;
        this.produceRecords(nBatches, recordsPerBatch);
        this.waitUntilSegmentsTiered(5, partitionToLeaderMap);
        this.simulateRetention(partitionToLeaderMap);
        fenceTopicPartition = (TopicPartition)this.topicPartitions().head();
        leaderId = this.getLeaderForTopicPartition(fenceTopicPartition, partitionToLeaderMap);
        qual$1 = ((KafkaBroker)this.brokerForId(leaderId).get()).logManager();
        x$2 = qual$1.getLog$default$2();
        log = (AbstractLog)qual$1.getLog(fenceTopicPartition, x$2).get();
        tierPartitionState = (FileTierPartitionState)log.tierPartitionState();
        tpIdsToBeFenced = new HashMap<TopicIdPartition, Boolean>();
        tpIdsToBeFenced.put((TopicIdPartition)tierPartitionState.topicIdPartition().get(), Predef$.MODULE$.boolean2Boolean(freezeMergedLogStartOffset));
        topicIdPartitionsFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        RecoveryTestUtils.writeFencingFile(topicIdPartitionsFile, tpIdsToBeFenced);
        workingDir = TestUtils.tempDirectory(null);
        brokerWorkdirList = TestUtils.tempDirectory((Path)workingDir.toPath(), null);
        recoveryConfFile = this.writeRecoverConfig((java.util.Map)((KafkaBroker)this.brokers().head()).tieredStorageInterBrokerClientConfigsSupplier().get(), workingDir, brokerWorkdirList);
        outputDir = TestUtils.tempDirectory(null);
        fenceOutFile = new StringBuilder(18).append(outputDir.getAbsolutePath()).append("/fence-output.json").toString();
        RecoveryTestUtils.executeFencingTool(recoveryConfFile.getAbsolutePath(), topicIdPartitionsFile.getAbsolutePath(), fenceOutFile);
        fenceEvents = FenceEventInfo.jsonToList((Path)Paths.get(fenceOutFile, new String[0]));
        this.validateFenceToolResults(fenceEvents, tpIdsToBeFenced, (MergedLog)log, (TierPartitionState)tierPartitionState);
        tierPartitionState.flush();
        Assertions.assertTrue((boolean)brokerWorkdirList.mkdir());
        tpDir = Paths.get(brokerWorkdirList.getAbsolutePath(), new String[]{tierPartitionState.topicPartition().toString()}).toFile();
        tpDir.mkdir();
        flushedPath = Paths.get(tierPartitionState.flushedPath(), new String[0]);
        Files.copy(flushedPath, Paths.get(tpDir.getAbsolutePath(), new String[]{flushedPath.getFileName().toString()}), new CopyOption[0]);
        comparatorOutputJson = new StringBuilder(23).append(outputDir.getAbsolutePath()).append("/comparator-output.json").toString();
        TierMetadataComparator.main((String[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), recoveryConfFile.getAbsolutePath(), RecoveryUtils.makeArgument((String)"input.json"), fenceOutFile, RecoveryUtils.makeArgument((String)"output.json"), comparatorOutputJson});
        comparatorOutput = RestoreComparatorInfo.RestoreComparatorInput.readJsonFromFile((Path)Paths.get(comparatorOutputJson, new String[0]));
        if (comparatorOutput.size() != 1) ** GOTO lbl-1000
        v0 = ((RestoreComparatorInfo.RestoreComparatorInput)comparatorOutput.get((int)0)).input().freezeMergedLogStartOffset;
        var25_25 = ((FenceEventInfo)fenceEvents.get((int)0)).freezeMergedLogStartOffset;
        if (!(v0 != null ? v0.equals(var25_25) == false : var25_25 != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        Predef$.MODULE$.assert(v1);
        restoreOutputJson = new StringBuilder(20).append(outputDir.getAbsolutePath()).append("/restore-output.json").toString();
        if (useRestoreRawInput) {
            TierPartitionStateRestoreTrigger.main((String[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), recoveryConfFile.getAbsolutePath(), RecoveryUtils.makeArgument((String)"fence.json"), fenceOutFile, RecoveryUtils.makeArgument((String)"restore.tier.state.root.dir"), brokerWorkdirList.getAbsolutePath(), RecoveryUtils.makeArgument((String)"output.json"), restoreOutputJson});
            this.validateRestoreToolsResults(fenceEvents, restoreOutputJson, tpIdsToBeFenced, (MergedLog)log, (TierPartitionState)tierPartitionState);
        } else {
            TierPartitionStateRestoreTrigger.main((String[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), recoveryConfFile.getAbsolutePath(), RecoveryUtils.makeArgument((String)"comparator.json"), comparatorOutputJson, RecoveryUtils.makeArgument((String)"output.json"), restoreOutputJson});
            if (freezeMergedLogStartOffset) {
                var32_27 = 100L;
                waitUntilTrue_waitTimeMs = 15000L;
                waitUntilTrue_startTime = System.currentTimeMillis();
                while (!TierIntegrationEndToEndTest.$anonfun$testArchiveAndTierFetchFenceAndRecovery$1(tierPartitionState, log)) {
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)"log and/or tier partition state is in unexpected status");
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
            } else {
                var38_30 = 100L;
                waitUntilTrue_waitTimeMs = 15000L;
                waitUntilTrue_startTime = System.currentTimeMillis();
                while (!TierIntegrationEndToEndTest.$anonfun$testArchiveAndTierFetchFenceAndRecovery$3(tierPartitionState, log)) {
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)"log and/or tier partition state is in unexpected status");
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
            }
        }
        if (freezeMergedLogStartOffset && !useRestoreRawInput) {
            return;
        }
        if (freezeMergedLogStartOffset) {
            unfreezeOutputJson = new StringBuilder(29).append(outputDir.getAbsolutePath()).append("/unfreeze-trigger-output.json").toString();
            TierPartitionUnfreezeLogStartOffsetTrigger.main((String[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), recoveryConfFile.getAbsolutePath(), RecoveryUtils.makeArgument((String)"restore.json"), restoreOutputJson, RecoveryUtils.makeArgument((String)"output.json"), unfreezeOutputJson, RecoveryUtils.makeArgument((String)"remote.uri.supported"), "false"});
            var44_34 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            waitUntilTrue_waitTimeMs = 15000L;
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TierIntegrationEndToEndTest.$anonfun$testArchiveAndTierFetchFenceAndRecovery$5(tierPartitionState, log)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"timed out waiting for partition to be restored to ONLINE status");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
        this.consumeAndValidateTierFetch(partitionToLeaderMap, nBatches, recordsPerBatch);
        endOffset = tierPartitionState.endOffset();
        this.produceRecords(nBatches, recordsPerBatch);
        var50_38 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        waitUntilTrue_waitTimeMs = TestUtils$.MODULE$.waitUntilTrue$default$3();
        waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationEndToEndTest.$anonfun$testArchiveAndTierFetchFenceAndRecovery$7(endOffset, tierPartitionState)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"timeout waiting for endOffset to advance after tiered partition has recovered and more records produced");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testArchiveAndTierFetchFenceAndRecovery(String quorum) {
        this.testArchiveAndTierFetchFenceAndRecovery(false, false);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testArchiveAndTierFetchFenceAndRecoveryWithRestoreRawInput(String quorum) {
        this.testArchiveAndTierFetchFenceAndRecovery(true, false);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testArchiveAndTierFetchFenceAndRecoveryWithMergedLogStartOffsetFrozen(String quorum) {
        this.testArchiveAndTierFetchFenceAndRecovery(true, true);
    }

    /*
     * WARNING - void declaration
     */
    private void testArchiveAndTierFetchFenceAndRecoveryWithRemoteURI(boolean freezeMergedLogStartOffset) {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("confluent.tier.local.hotset.bytes", "5000");
        props.put("retention.bytes", "-1");
        scala.collection.immutable.Map<Object, Object> partitionToLeaderMap = this.createTopic(this.topic(), this.partitions(), 1, props, this.adminClientConfig());
        int nBatches = 100;
        int recordsPerBatch = 100;
        this.produceRecords(nBatches, recordsPerBatch);
        this.waitUntilSegmentsTiered(5, partitionToLeaderMap);
        this.simulateRetention(partitionToLeaderMap);
        TopicPartition fenceTopicPartition = (TopicPartition)this.topicPartitions().head();
        int leaderId = this.getLeaderForTopicPartition(fenceTopicPartition, partitionToLeaderMap);
        LogManager qual$1 = ((KafkaBroker)this.brokerForId(leaderId).get()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$1.getLog(fenceTopicPartition, x$2).get();
        FileTierPartitionState tierPartitionState = (FileTierPartitionState)log.tierPartitionState();
        HashMap<TopicIdPartition, Boolean> tpIdsToBeFenced = new HashMap<TopicIdPartition, Boolean>();
        tpIdsToBeFenced.put((TopicIdPartition)tierPartitionState.topicIdPartition().get(), Predef$.MODULE$.boolean2Boolean(freezeMergedLogStartOffset));
        File topicIdPartitionsFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        RecoveryTestUtils.writeFencingFile(topicIdPartitionsFile, tpIdsToBeFenced);
        File workingDir = TestUtils.tempDirectory(null, null);
        File brokerWorkdirList = TestUtils.tempDirectory((Path)workingDir.toPath(), null);
        File recoveryConfFile = this.writeRecoverConfig((java.util.Map)((KafkaBroker)this.brokers().head()).tieredStorageInterBrokerClientConfigsSupplier().get(), workingDir, brokerWorkdirList);
        File outputDir = TestUtils.tempDirectory(null, null);
        String fenceOutFile = new StringBuilder(18).append(outputDir.getAbsolutePath()).append("/fence-output.json").toString();
        RecoveryTestUtils.executeFencingTool(recoveryConfFile.getAbsolutePath(), topicIdPartitionsFile.getAbsolutePath(), fenceOutFile);
        java.util.List fenceEvents = FenceEventInfo.jsonToList((Path)Paths.get(fenceOutFile, new String[0]));
        this.validateFenceToolResults(fenceEvents, tpIdsToBeFenced, (MergedLog)log, (TierPartitionState)tierPartitionState);
        tierPartitionState.flush();
        Assertions.assertTrue((boolean)brokerWorkdirList.mkdir());
        Path flushedPath = Paths.get(tierPartitionState.flushedPath(), new String[0]);
        Buffer<KafkaBroker> replicas = this.brokers();
        replicas.indices().foreach((Function1 & Serializable)i -> TierIntegrationEndToEndTest.$anonfun$testArchiveAndTierFetchFenceAndRecoveryWithRemoteURI$1(replicas, tierPartitionState, flushedPath, BoxesRunTime.unboxToInt((Object)i)));
        Path remoteURIsFile = Files.createTempFile("remote-uri-input", ".json", new FileAttribute[0]);
        RecoveryTestUtils.writeRemoteURIInfoFile(remoteURIsFile.toFile(), tpIdsToBeFenced);
        File outputDirRemoteURI = TestUtils.tempDirectory(null, null);
        String restoreWithRemoteURIOutputJson = new StringBuilder(36).append(outputDirRemoteURI.getAbsolutePath()).append("/restore-with-remote-url-output.json").toString();
        TierPartitionStateRestoreTrigger.main((String[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), recoveryConfFile.getAbsolutePath(), RecoveryUtils.makeArgument((String)"fence.json"), fenceOutFile, RecoveryUtils.makeArgument((String)"restore.remote.tier.state.uris.file"), ((Object)remoteURIsFile).toString(), RecoveryUtils.makeArgument((String)"output.json"), restoreWithRemoteURIOutputJson});
        this.validateRestoreToolsWithRemoteURIResults(fenceEvents, restoreWithRemoteURIOutputJson, tpIdsToBeFenced, (MergedLog)log, (TierPartitionState)tierPartitionState);
        if (freezeMergedLogStartOffset) {
            String unfreezeOutputJson = new StringBuilder(29).append(outputDir.getAbsolutePath()).append("/unfreeze-trigger-output.json").toString();
            TierPartitionUnfreezeLogStartOffsetTrigger.main((String[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), recoveryConfFile.getAbsolutePath(), RecoveryUtils.makeArgument((String)"restore.json"), restoreWithRemoteURIOutputJson, RecoveryUtils.makeArgument((String)"output.json"), unfreezeOutputJson, RecoveryUtils.makeArgument((String)"remote.uri.supported"), "true"});
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TierIntegrationEndToEndTest.$anonfun$testArchiveAndTierFetchFenceAndRecoveryWithRemoteURI$3(tierPartitionState, log)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"timed out waiting for partition to be restored to ONLINE status");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
        this.consumeAndValidateTierFetch(partitionToLeaderMap, nBatches, recordsPerBatch);
        long endOffset = tierPartitionState.endOffset();
        this.produceRecords(nBatches, recordsPerBatch);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationEndToEndTest.$anonfun$testArchiveAndTierFetchFenceAndRecoveryWithRemoteURI$5(endOffset, tierPartitionState)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"timeout waiting for endOffset to advance after tiered partition has recovered and more records produced");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void validateRestoreToolsWithRemoteURIResults(java.util.List<FenceEventInfo> fenceEvents, String restoreWithRemoteURIOutputJson, java.util.Map<TopicIdPartition, Boolean> tpIdsToBeFenced, MergedLog log, TierPartitionState tierPartitionState) {
        freezeMergedLogStartOffset = tpIdsToBeFenced.entrySet().iterator().next().getValue();
        restoreRawOutputRemoteURIList = RestoreRawOutputInfoRemoteURI.readJsonFromFile((Path)Paths.get(restoreWithRemoteURIOutputJson, new String[0]));
        if (restoreRawOutputRemoteURIList.size() != 1) ** GOTO lbl-1000
        v0 = ((RestoreRawOutputInfoRemoteURI)restoreRawOutputRemoteURIList.get((int)0)).input().fenceEventInfo().freezeMergedLogStartOffset;
        var8_8 = fenceEvents.get((int)0).freezeMergedLogStartOffset;
        if (!(v0 != null ? v0.equals(var8_8) == false : var8_8 != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        Assertions.assertTrue((boolean)v1);
        if (Predef$.MODULE$.Boolean2boolean(freezeMergedLogStartOffset)) {
            var11_9 = 100L;
            waitUntilTrue_waitTimeMs = 15000L;
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TierIntegrationEndToEndTest.$anonfun$validateRestoreToolsWithRemoteURIResults$1(tierPartitionState, log)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"log and/or tier partition state is in unexpected status");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            return;
        }
        var17_12 = 100L;
        waitUntilTrue_waitTimeMs = 15000L;
        waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationEndToEndTest.$anonfun$validateRestoreToolsWithRemoteURIResults$3(tierPartitionState, log)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"log and/or tier partition state is in unexpected status");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testArchiveAndTierFetchFenceAndRecoveryWithRemoteURIs(String quorum) {
        this.testArchiveAndTierFetchFenceAndRecoveryWithRemoteURI(false);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testArchiveAndTierFetchFenceAndRecoveryRemoteURIsWithMergedLogStartOffsetFrozen(String quorum) {
        this.testArchiveAndTierFetchFenceAndRecoveryWithRemoteURI(true);
    }

    /*
     * WARNING - void declaration
     */
    public void testClearAllTierData(boolean isCompact) {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("retention.bytes", "-1");
        props.put("confluent.tier.local.hotset.ms", "-1");
        props.put("confluent.tier.local.hotset.bytes", "-1");
        props.put("confluent.prefer.tier.fetch.ms", "0");
        if (isCompact) {
            props.put("cleanup.policy", "compact");
            props.put("confluent.tier.cleaner.compact.min.efficiency", Double.toString(0.1));
            props.put("confluent.compacted.topic.prefer.tier.fetch.ms", "0");
        }
        scala.collection.immutable.Map<Object, Object> partitionToLeaderMap = this.createTopic(this.topic(), this.partitions(), 1, props, this.adminClientConfig());
        int nBatches = 100;
        int recordsPerBatch = 100;
        this.produceRecords(nBatches, recordsPerBatch);
        this.waitUntilSegmentsTiered(5, partitionToLeaderMap);
        this.consumeAndValidateTierFetch(partitionToLeaderMap, nBatches, recordsPerBatch, isCompact);
        TopicPartition fenceTopicPartition = (TopicPartition)this.topicPartitions().head();
        int leaderId = this.getLeaderForTopicPartition(fenceTopicPartition, partitionToLeaderMap);
        LogManager qual$1 = ((KafkaBroker)this.brokerForId(leaderId).get()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$1.getLog(fenceTopicPartition, x$2).get();
        FileTierPartitionState tierPartitionState = (FileTierPartitionState)log.tierPartitionState();
        List segmentsBeforeClearing = CollectionConverters$.MODULE$.IteratorHasAsScala(tierPartitionState.segments()).asScala().toList();
        HashMap<TopicIdPartition, Boolean> tpIdsToBeFenced = new HashMap<TopicIdPartition, Boolean>();
        tpIdsToBeFenced.put((TopicIdPartition)tierPartitionState.topicIdPartition().get(), Predef$.MODULE$.boolean2Boolean(false));
        File topicIdPartitionsFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        RecoveryTestUtils.writeFencingFile(topicIdPartitionsFile, tpIdsToBeFenced);
        File workingDir = TestUtils.tempDirectory(null, null);
        File brokerWorkdirList = TestUtils.tempDirectory((Path)workingDir.toPath(), null);
        File recoveryConfFile = this.writeRecoverConfig((java.util.Map)((KafkaBroker)this.brokers().head()).tieredStorageInterBrokerClientConfigsSupplier().get(), workingDir, brokerWorkdirList);
        File outputDir = TestUtils.tempDirectory(null, null);
        String fenceOutFile = new StringBuilder(18).append(outputDir.getAbsolutePath()).append("/fence-output.json").toString();
        RecoveryTestUtils.executeFencingTool(recoveryConfFile.getAbsolutePath(), topicIdPartitionsFile.getAbsolutePath(), fenceOutFile);
        java.util.List fenceEvents = FenceEventInfo.jsonToList((Path)Paths.get(fenceOutFile, new String[0]));
        this.validateFenceToolResults(fenceEvents, tpIdsToBeFenced, (MergedLog)log, (TierPartitionState)tierPartitionState);
        tierPartitionState.flush();
        Assertions.assertTrue((boolean)brokerWorkdirList.mkdir());
        File tpDir = Paths.get(brokerWorkdirList.getAbsolutePath(), tierPartitionState.topicPartition().toString()).toFile();
        tpDir.mkdir();
        Path flushedPath = Paths.get(tierPartitionState.flushedPath(), new String[0]);
        Path copiedTierStateFilePath = Paths.get(tpDir.getAbsolutePath(), ((Object)flushedPath.getFileName()).toString());
        Files.copy(flushedPath, copiedTierStateFilePath, new CopyOption[0]);
        ResetTierPartitionState.main((String[])new String[]{RecoveryUtils.makeArgument((String)"topic"), fenceTopicPartition.topic(), RecoveryUtils.makeArgument((String)"partition"), Integer.toString(fenceTopicPartition.partition()), RecoveryUtils.makeArgument((String)"ftps"), ((Object)copiedTierStateFilePath).toString()});
        Assertions.assertTrue((boolean)Paths.get(ResetTierPartitionState.outputFilePath((String)((Object)copiedTierStateFilePath).toString()), new String[0]).toFile().exists());
        Assertions.assertTrue((boolean)copiedTierStateFilePath.toFile().delete());
        String restoreOutputJson = new StringBuilder(20).append(outputDir.getAbsolutePath()).append("/restore-output.json").toString();
        TierPartitionStateRestoreTrigger.main((String[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), recoveryConfFile.getAbsolutePath(), RecoveryUtils.makeArgument((String)"fence.json"), fenceOutFile, RecoveryUtils.makeArgument((String)"restore.tier.state.root.dir"), tpDir.getParent(), RecoveryUtils.makeArgument((String)"output.json"), restoreOutputJson});
        this.validateRestoreToolsResults(fenceEvents, restoreOutputJson, tpIdsToBeFenced, (MergedLog)log, (TierPartitionState)tierPartitionState);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationEndToEndTest.$anonfun$testClearAllTierData$1(tierPartitionState, log)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"timed out waiting for partition to be restored to ONLINE status");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.waitUntilSegmentsTiered(5, partitionToLeaderMap);
        this.consumeAndValidateTierFetch(partitionToLeaderMap, nBatches, recordsPerBatch, isCompact);
        List segmentsAfterClearing = CollectionConverters$.MODULE$.IteratorHasAsScala(tierPartitionState.segments()).asScala().toList();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 4).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            TierLogSegment seg1 = (TierLogSegment)segmentsBeforeClearing.apply(i);
            TierLogSegment seg2 = (TierLogSegment)segmentsAfterClearing.apply(i);
            Assertions.assertEquals((long)seg1.baseOffset(), (long)seg2.baseOffset());
            Assertions.assertEquals((long)seg1.endOffset(), (long)seg2.endOffset());
            Assertions.assertNotEquals((Object)seg1.objectId(), (Object)seg2.objectId());
        });
        long endOffset = tierPartitionState.endOffset();
        this.produceRecords(nBatches, recordsPerBatch);
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierIntegrationEndToEndTest.$anonfun$testClearAllTierData$4(endOffset, tierPartitionState)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"timeout waiting for endOffset to advance after tiered partition has recovered and more records produced");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testClearAllTierDataForNonCompactedTopic(String quorum) {
        this.testClearAllTierData(false);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testClearAllTierDataForCompactedTopic(String quorum) {
        this.testClearAllTierData(true);
    }

    private void produceRecords(int nBatches, int recordsPerBatch) {
        try (KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());){
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), nBatches).foreach((Function1 & Serializable)b -> TierIntegrationEndToEndTest.$anonfun$produceRecords$1(this, recordsPerBatch, producer, BoxesRunTime.unboxToInt((Object)b)));
        }
    }

    private int getLeaderForTopicPartition(TopicPartition topicPartition, scala.collection.immutable.Map<Object, Object> partitionToLeaderMap) {
        return BoxesRunTime.unboxToInt((Object)partitionToLeaderMap.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
    }

    private void waitUntilSegmentsTiered(int minNumSegments, scala.collection.immutable.Map<Object, Object> partitionToLeaderMap) {
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            TierIntegrationEndToEndTest.$anonfun$waitUntilSegmentsTiered$1(this, partitionToLeaderMap, minNumSegments, tp);
            return BoxedUnit.UNIT;
        });
    }

    private void simulateRetention(scala.collection.immutable.Map<Object, Object> partitionToLeaderMap) {
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            TierIntegrationEndToEndTest.$anonfun$simulateRetention$1(this, partitionToLeaderMap, tp);
            return BoxedUnit.UNIT;
        });
    }

    private void consumeAndValidateTierFetch(scala.collection.immutable.Map<Object, Object> partitionToLeaderMap, int nBatches, int recordsPerBatch) {
        this.consumeAndValidateTierFetch(partitionToLeaderMap, nBatches, recordsPerBatch, false);
    }

    /*
     * WARNING - void declaration
     */
    private void consumeAndValidateTierFetch(scala.collection.immutable.Map<Object, Object> partitionToLeaderMap, int nBatches, int recordsPerBatch, boolean isCompact) {
        void var33_29;
        SeqOps seqOps;
        void var19_19;
        void var21_20;
        List memoryTrackerMetrics;
        MBeanServer mBeanServer;
        block21: {
            List list;
            block20: {
                void var29_26;
                SeqOps seqOps2;
                block19: {
                    List list2;
                    block18: {
                        void var25_23;
                        SeqOps seqOps3;
                        block17: {
                            List list3;
                            block16: {
                                SeqOps seqOps4;
                                block15: {
                                    List list4;
                                    block14: {
                                        TopicPartition topicPartition = (TopicPartition)this.topicPartitions().head();
                                        Consumer consumer = this.createConsumer(new StringDeserializer(), new StringDeserializer(), this.createConsumer$default$3(), this.createConsumer$default$4());
                                        java.util.List<TopicPartition> partitions = Collections.singletonList(topicPartition);
                                        consumer.assign(partitions);
                                        consumer.seekToBeginning(partitions);
                                        ArrayList valuesRead = new ArrayList();
                                        ArrayList timestampsOffsets = new ArrayList();
                                        ConsumerRecords records = consumer.poll(Duration.ofMillis(1000L));
                                        do {
                                            records.forEach((java.util.function.Consumer)new java.util.function.Consumer<ConsumerRecord<String, String>>(null, valuesRead, timestampsOffsets){
                                                private final ArrayList valuesRead$1;
                                                private final ArrayList timestampsOffsets$1;

                                                public java.util.function.Consumer<ConsumerRecord<String, String>> andThen(java.util.function.Consumer<? super ConsumerRecord<String, String>> x$1) {
                                                    return java.util.function.Consumer.super.andThen(x$1);
                                                }

                                                public void accept(ConsumerRecord<String, String> r) {
                                                    this.valuesRead$1.add(BoxesRunTime.boxToInteger((int)Integer.parseInt((String)r.value())));
                                                    this.timestampsOffsets$1.add(new Tuple2.mcJJ.sp(r.timestamp(), r.offset()));
                                                }
                                                {
                                                    this.valuesRead$1 = valuesRead$1;
                                                    this.timestampsOffsets$1 = timestampsOffsets$1;
                                                }
                                            });
                                        } while (!(records = consumer.poll(Duration.ofMillis(1000L))).isEmpty());
                                        if (!isCompact) {
                                            Assertions.assertEquals(new ArrayList(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Range().apply(0, nBatches * recordsPerBatch)).asJava()), valuesRead);
                                            CollectionConverters$.MODULE$.ListHasAsScala(timestampsOffsets).asScala().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$4 -> {
                                                TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$2(this, timestampsOffsets, topicPartition, consumer, x$4);
                                                return BoxedUnit.UNIT;
                                            });
                                            this.assertTimestampForOffsetLookupCorrect(topicPartition, consumer, 0L, 0L);
                                            this.assertTimestampForOffsetLookupMissing(topicPartition, consumer, Long.MAX_VALUE);
                                        }
                                        mBeanServer = ManagementFactory.getPlatformMBeanServer();
                                        int partitionsInErrorDuringArchivalCount = BoxesRunTime.unboxToInt((Object)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(mBeanServer.getAttributes(new ObjectName("kafka.tier.tasks:type=TierTasks,name=NumPartitionsInErrorDuringArchival"), new String[]{"Value"}).asList()).asScala().map((Function1 & Serializable)attr -> BoxesRunTime.boxToInteger((int)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$4(attr)))).head());
                                        Assertions.assertEquals((int)0, (int)partitionsInErrorDuringArchivalCount, (String)"tier archiver shows partitions in error state during archival");
                                        int partitionsInErrorDuringDeletionCount = BoxesRunTime.unboxToInt((Object)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(mBeanServer.getAttributes(new ObjectName("kafka.tier.tasks:type=TierTasks,name=NumPartitionsInErrorDuringDeletion"), new String[]{"Value"}).asList()).asScala().map((Function1 & Serializable)attr -> BoxesRunTime.boxToInteger((int)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$5(attr)))).head());
                                        Assertions.assertEquals((int)0, (int)partitionsInErrorDuringDeletionCount, (String)"tier deletion process shows partitions in error state during deletion");
                                        memoryTrackerMetrics = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(mBeanServer.getAttributes(new ObjectName("kafka.server:type=TierFetcherMemoryTracker"), new String[]{"Leased", "PoolSize", "MaxLeaseLagMs"}).asList()).asScala().map((Function1 & Serializable)attr -> BoxesRunTime.boxToDouble((double)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$6(attr)))).toList();
                                        String bean = "kafka.server:type=TierFetcher";
                                        String[] attrs = new String[]{"BytesFetchedTotal", "OffsetCacheHitRatio"};
                                        list4 = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(mBeanServer.getAttributes(new ObjectName(bean), attrs).asList()).asScala().map((Function1 & Serializable)attr -> BoxesRunTime.boxToDouble((double)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$7(attr)))).toList();
                                        if (list4 == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps4 = package$.MODULE$.List().unapplySeq((SeqOps)list4))) break block14;
                                        new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4));
                                        if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 2) == 0) break block15;
                                    }
                                    throw new MatchError((Object)list4);
                                }
                                double bytesFetchedTotal = BoxesRunTime.unboxToDouble((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 0));
                                double offsetCacheHitRatio = BoxesRunTime.unboxToDouble((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps4), 1));
                                Assertions.assertEquals((double)1.0, (double)var21_20, (double)1.0E-6, (String)"offset cache should not have shown misses");
                                list3 = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(mBeanServer.getAttributes(new ObjectName("kafka.server:type=TierTopicConsumer"), new String[]{"HeartbeatMs"}).asList()).asScala().map((Function1 & Serializable)attr -> BoxesRunTime.boxToDouble((double)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$8(attr)))).toList();
                                if (list3 == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps3 = package$.MODULE$.List().unapplySeq((SeqOps)list3))) break block16;
                                new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3));
                                if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 1) == 0) break block17;
                            }
                            throw new MatchError((Object)list3);
                        }
                        double heartbeat = BoxesRunTime.unboxToDouble((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 0));
                        Assertions.assertTrue((var25_23 < (double)2000 ? 1 : 0) != 0, (String)"tier topic consumer heartbeat is alive");
                        list2 = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(mBeanServer.getAttributes(new ObjectName("kafka.tier.tasks:type=TierTasks,name=HeartbeatMs"), new String[]{"Value"}).asList()).asScala().map((Function1 & Serializable)attr -> BoxesRunTime.boxToLong((long)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$9(attr)))).toList();
                        if (list2 == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.List().unapplySeq((SeqOps)list2))) break block18;
                        new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2));
                        if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0) break block19;
                    }
                    throw new MatchError((Object)list2);
                }
                long tierTasksHeartbeat = BoxesRunTime.unboxToLong((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0));
                Assertions.assertTrue((var29_26 < 10000L ? 1 : 0) != 0, (String)"tier tasks heartbeat is alive");
                Assertions.assertTrue((var19_19 > (double)100 ? 1 : 0) != 0, (String)"tier fetch metric shows no data fetched from tiered storage");
                list = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(mBeanServer.getAttributes(new ObjectName("kafka.tier.tasks.archive:type=TierArchiver,name=BytesPerSec"), new String[]{"MeanRate"}).asList()).asScala().map((Function1 & Serializable)attr -> BoxesRunTime.boxToDouble((double)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$10(attr)))).toList();
                if (list == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list))) break block20;
                new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) break block21;
            }
            throw new MatchError((Object)list);
        }
        double meanArchiveRate = BoxesRunTime.unboxToDouble((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0));
        Assertions.assertTrue((var33_29 > (double)100 ? 1 : 0) != 0, (String)"tier archiver mean rate shows no data uploaded to tiered storage");
        Buffer partitionsStatusCounts = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(mBeanServer.getAttributes(new ObjectName("kafka.server:type=TierTopicConsumer"), new String[]{"ImmigratingPartitions", "CatchupConsumerPartitions", "PrimaryConsumerPartitions", "ErrorPartitions"}).asList()).asScala().map((Function1 & Serializable)attr -> BoxesRunTime.boxToDouble((double)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$11(attr)));
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 1.0, 0.0})), (Object)partitionsStatusCounts.toList(), (String)"tier topic manager fully immigrated the partitions");
        int partitionsInErrorCount = BoxesRunTime.unboxToInt((Object)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(mBeanServer.getAttributes(new ObjectName("kafka.tier.tasks:type=TierTasks,name=NumPartitionsInError"), new String[]{"Value"}).asList()).asScala().map((Function1 & Serializable)attr -> BoxesRunTime.boxToInteger((int)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$12(attr)))).head());
        Assertions.assertEquals((int)0, (int)partitionsInErrorCount, (String)"tier archiver shows no partitions in error state");
        Assertions.assertEquals((double)1.0, (double)var21_20, (double)1.0E-6, (String)"offset cache should not have shown misses");
        Assertions.assertTrue((var19_19 > (double)100 ? 1 : 0) != 0, (String)new StringBuilder(61).append("tier fetch metric shows no data fetched from tiered storage: ").append((double)var19_19).toString());
        Assertions.assertEquals((double)BoxesRunTime.unboxToDouble((Object)memoryTrackerMetrics.head()), (double)0.0, (double)0.0, (String)"expected all leased memory to be returned to the MemoryTracker");
        Assertions.assertEquals((double)BoxesRunTime.unboxToDouble((Object)memoryTrackerMetrics.apply(1)), (double)1048576.0, (double)0.0, (String)"expected all leased memory to be returned to the MemoryTracker");
        Assertions.assertEquals((double)BoxesRunTime.unboxToDouble((Object)memoryTrackerMetrics.last()), (double)0.0, (double)0.0, (String)"expected no value for oldestLease, since all leases should be reclaimed");
        this.brokers().foreach((Function1 & Serializable)server -> {
            TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$13(server);
            return BoxedUnit.UNIT;
        });
    }

    private File writeRecoverConfig(java.util.Map<String, Object> tierClientConfig, File workingDir, File brokerWorkdirList) {
        File recoveryConfFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
        Properties props = Utils.mkProperties((java.util.Map)new HashMap<String, String>(this, workingDir, brokerWorkdirList){
            {
                this.put(KafkaConfig$.MODULE$.TierBackendProp(), "Mock");
                this.put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), $outer.serverConfig().get(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp()).toString());
                this.put("bootstrap.servers", $outer.bootstrapServers($outer.bootstrapServers$default$1()));
                this.put("confluent.tier.recovery.working.dir", workingDir$1.getAbsolutePath());
                this.put("confluent.tier.recovery.validate", "false");
                this.put("confluent.tier.recovery.materialize", "true");
                this.put("confluent.tier.recovery.dump.events", "false");
                this.put("confluent.tier.recovery.broker.workdir.list", brokerWorkdirList$1.getAbsolutePath());
            }
        });
        props.putAll(tierClientConfig);
        props.store(new PrintWriter(recoveryConfFile), "");
        return recoveryConfFile;
    }

    private void assertTimestampForOffsetLookupCorrect(TopicPartition topicPartition, Consumer<String, String> consumer, long timestamp, long expectedOffset) {
        HashMap<TopicPartition, Long> timestampsToSearch = new HashMap<TopicPartition, Long>();
        timestampsToSearch.put(topicPartition, Predef$.MODULE$.long2Long(timestamp));
        Assertions.assertEquals((long)expectedOffset, (long)((OffsetAndTimestamp)consumer.offsetsForTimes(timestampsToSearch).get(topicPartition)).offset(), (String)"timestamp should match offset read");
    }

    private void assertTimestampForOffsetLookupMissing(TopicPartition topicPartition, Consumer<String, String> consumer, long timestamp) {
        HashMap<TopicPartition, Long> timestampsToSearch = new HashMap<TopicPartition, Long>();
        timestampsToSearch.put(topicPartition, Predef$.MODULE$.long2Long(timestamp));
        Assertions.assertEquals(null, consumer.offsetsForTimes(timestampsToSearch).get(topicPartition), (String)"offset should not be returned");
    }

    private scala.collection.immutable.Map<Object, Object> createTopic(String topic, int numPartitions, int replicationFactor, Properties topicConfig, Properties adminClientConfig) {
        scala.collection.immutable.Map map;
        try (Admin resource_resource = this.createAdminClient(this.listenerName(), adminClientConfig);){
            map = TierIntegrationEndToEndTest.$anonfun$createTopic$1(this, topic, numPartitions, replicationFactor, topicConfig, resource_resource);
        }
        return map;
    }

    public static final /* synthetic */ TopicPartition $anonfun$topicPartitions$1(TierIntegrationEndToEndTest $this, int p) {
        return new TopicPartition($this.topic(), p);
    }

    public static final /* synthetic */ boolean $anonfun$validateFenceToolResults$1(TierPartitionState tierPartitionState$1, MergedLog log$1) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$1.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.FROZEN_LOG_START_OFFSET;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && log$1.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$validateFenceToolResults$2() {
        return "timeout waiting for partition to be transitioned to the required status";
    }

    public static final /* synthetic */ boolean $anonfun$validateFenceToolResults$3(TierPartitionState tierPartitionState$1, MergedLog log$1) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$1.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ERROR;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && !log$1.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$validateFenceToolResults$4() {
        return "timeout waiting for partition to be transitioned to the required status";
    }

    public static final /* synthetic */ boolean $anonfun$validateRestoreToolsResults$1(TierPartitionState tierPartitionState$2, MergedLog log$2) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$2.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.FROZEN_LOG_START_OFFSET;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && log$2.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$validateRestoreToolsResults$2() {
        return "log and/or tier partition state is in unexpected status";
    }

    public static final /* synthetic */ boolean $anonfun$validateRestoreToolsResults$3(TierPartitionState tierPartitionState$2, MergedLog log$2) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$2.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && !log$2.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$validateRestoreToolsResults$4() {
        return "log and/or tier partition state is in unexpected status";
    }

    public static final /* synthetic */ boolean $anonfun$testArchiveAndTierFetchFenceAndRecovery$1(FileTierPartitionState tierPartitionState$3, AbstractLog log$3) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$3.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.FROZEN_LOG_START_OFFSET;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && log$3.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$testArchiveAndTierFetchFenceAndRecovery$2() {
        return "log and/or tier partition state is in unexpected status";
    }

    public static final /* synthetic */ boolean $anonfun$testArchiveAndTierFetchFenceAndRecovery$3(FileTierPartitionState tierPartitionState$3, AbstractLog log$3) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$3.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && !log$3.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$testArchiveAndTierFetchFenceAndRecovery$4() {
        return "log and/or tier partition state is in unexpected status";
    }

    public static final /* synthetic */ boolean $anonfun$testArchiveAndTierFetchFenceAndRecovery$5(FileTierPartitionState tierPartitionState$3, AbstractLog log$3) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$3.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && !log$3.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$testArchiveAndTierFetchFenceAndRecovery$6() {
        return "timed out waiting for partition to be restored to ONLINE status";
    }

    public static final /* synthetic */ boolean $anonfun$testArchiveAndTierFetchFenceAndRecovery$7(long endOffset$1, FileTierPartitionState tierPartitionState$3) {
        return endOffset$1 < tierPartitionState$3.endOffset();
    }

    public static final /* synthetic */ String $anonfun$testArchiveAndTierFetchFenceAndRecovery$8() {
        return "timeout waiting for endOffset to advance after tiered partition has recovered and more records produced";
    }

    public static final /* synthetic */ String $anonfun$testArchiveAndTierFetchFenceAndRecoveryWithRemoteURI$1(Buffer replicas$1, FileTierPartitionState tierPartitionState$4, Path flushedPath$1, int i) {
        TierObjectStore store = (TierObjectStore)((KafkaBroker)replicas$1.apply(i)).tierObjectStoreOpt().get();
        String identifier = "rcca-1234";
        UUID topicId = ((TopicIdPartition)tierPartitionState$4.topicIdPartition().get()).topicId();
        String topic = ((TopicIdPartition)tierPartitionState$4.topicIdPartition().get()).topic();
        int partition = ((TopicIdPartition)tierPartitionState$4.topicIdPartition().get()).partition();
        TopicIdPartition topicIdPartition = new TopicIdPartition(topic, topicId, partition);
        Integer broker = Predef$.MODULE$.int2Integer(0);
        FileTierPartitionStateUploadObject fileTierPartitionStateUploadObject = new FileTierPartitionStateUploadObject(MergedLog$.MODULE$.tierStateFileName(0L, ""), Algorithm.NO_CHECKSUM);
        FileTierPartitionStateRecoveryUploadMetadata metadata = FileTierPartitionStateRecoveryUploadMetadata.fromPath((String)new FileTierPartitionStateRecoveryUploadMetadata(identifier, broker, topicIdPartition, fileTierPartitionStateUploadObject).toPath(TierObjectStore.DataTypePathPrefix.TIER_RECOVERY_DATA_UPLOAD.prefix, ObjectType.FILE_TIER_PARTITION_STATE_UPLOAD));
        return TierObjectStoreFunctionUtils.putObject(() -> Predef$.MODULE$.boolean2Boolean(false), (TierObjectStore)store, (File)flushedPath$1.toFile(), (ObjectStoreMetadata)metadata, (ObjectType)ObjectType.FILE_TIER_PARTITION_STATE_UPLOAD);
    }

    public static final /* synthetic */ boolean $anonfun$testArchiveAndTierFetchFenceAndRecoveryWithRemoteURI$3(FileTierPartitionState tierPartitionState$4, AbstractLog log$4) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$4.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && !log$4.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$testArchiveAndTierFetchFenceAndRecoveryWithRemoteURI$4() {
        return "timed out waiting for partition to be restored to ONLINE status";
    }

    public static final /* synthetic */ boolean $anonfun$testArchiveAndTierFetchFenceAndRecoveryWithRemoteURI$5(long endOffset$2, FileTierPartitionState tierPartitionState$4) {
        return endOffset$2 < tierPartitionState$4.endOffset();
    }

    public static final /* synthetic */ String $anonfun$testArchiveAndTierFetchFenceAndRecoveryWithRemoteURI$6() {
        return "timeout waiting for endOffset to advance after tiered partition has recovered and more records produced";
    }

    public static final /* synthetic */ boolean $anonfun$validateRestoreToolsWithRemoteURIResults$1(TierPartitionState tierPartitionState$5, MergedLog log$5) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$5.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.FROZEN_LOG_START_OFFSET;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && log$5.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$validateRestoreToolsWithRemoteURIResults$2() {
        return "log and/or tier partition state is in unexpected status";
    }

    public static final /* synthetic */ boolean $anonfun$validateRestoreToolsWithRemoteURIResults$3(TierPartitionState tierPartitionState$5, MergedLog log$5) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$5.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && !log$5.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$validateRestoreToolsWithRemoteURIResults$4() {
        return "log and/or tier partition state is in unexpected status";
    }

    public static final /* synthetic */ boolean $anonfun$testClearAllTierData$1(FileTierPartitionState tierPartitionState$6, AbstractLog log$6) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$6.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && !log$6.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$testClearAllTierData$2() {
        return "timed out waiting for partition to be restored to ONLINE status";
    }

    public static final /* synthetic */ boolean $anonfun$testClearAllTierData$4(long endOffset$3, FileTierPartitionState tierPartitionState$6) {
        return endOffset$3 < tierPartitionState$6.endOffset();
    }

    public static final /* synthetic */ String $anonfun$testClearAllTierData$5() {
        return "timeout waiting for endOffset to advance after tiered partition has recovered and more records produced";
    }

    public static final /* synthetic */ ProducerRecord $anonfun$produceRecords$2(TierIntegrationEndToEndTest $this, int recordsPerBatch$1, int b$1, long timestamp$1, int i) {
        String k = TestUtils.randomString((int)3);
        int m = recordsPerBatch$1 * b$1 + i;
        return new ProducerRecord($this.topic(), null, Predef$.MODULE$.long2Long(timestamp$1), (Object)k.getBytes(StandardCharsets.UTF_8), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)m)).getBytes(StandardCharsets.UTF_8));
    }

    public static final /* synthetic */ IndexedSeq $anonfun$produceRecords$1(TierIntegrationEndToEndTest $this, int recordsPerBatch$1, KafkaProducer producer$1, int b) {
        long timestamp = System.currentTimeMillis();
        return (IndexedSeq)((IndexedSeqOps)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), recordsPerBatch$1).map((Function1 & Serializable)i -> TierIntegrationEndToEndTest.$anonfun$produceRecords$2($this, recordsPerBatch$1, b, timestamp, BoxesRunTime.unboxToInt((Object)i))).map((Function1 & Serializable)x$1 -> producer$1.send(x$1))).map((Function1 & Serializable)x$3 -> (RecordMetadata)x$3.get(10L, TimeUnit.SECONDS));
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilSegmentsTiered$2(TierPartitionState tierPartitionState$7, int minNumSegments$1) {
        return tierPartitionState$7.numSegments() > minNumSegments$1 && tierPartitionState$7.endOffset() == tierPartitionState$7.committedEndOffset();
    }

    public static final /* synthetic */ String $anonfun$waitUntilSegmentsTiered$3(int minNumSegments$1) {
        return new StringBuilder(61).append("timeout waiting for at least ").append(minNumSegments$1).append(" to be archived and materialized").toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$waitUntilSegmentsTiered$1(TierIntegrationEndToEndTest $this, scala.collection.immutable.Map partitionToLeaderMap$1, int minNumSegments$1, TopicPartition tp) {
        int leaderId = $this.getLeaderForTopicPartition(tp, (scala.collection.immutable.Map<Object, Object>)partitionToLeaderMap$1);
        LogManager qual$1 = ((KafkaBroker)$this.brokerForId(leaderId).get()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        TierPartitionState tierPartitionState = ((AbstractLog)qual$1.getLog(tp, x$2).get()).tierPartitionState();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationEndToEndTest.$anonfun$waitUntilSegmentsTiered$2(tierPartitionState, minNumSegments$1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierIntegrationEndToEndTest.$anonfun$waitUntilSegmentsTiered$3(minNumSegments$1));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ void $anonfun$simulateRetention$1(TierIntegrationEndToEndTest $this, scala.collection.immutable.Map partitionToLeaderMap$2, TopicPartition tp) {
        boolean x$2;
        int leaderId = $this.getLeaderForTopicPartition(tp, (scala.collection.immutable.Map<Object, Object>)partitionToLeaderMap$2);
        LogManager qual$1 = ((KafkaBroker)$this.brokerForId(leaderId).get()).replicaManager().logManager();
        Assertions.assertTrue((((AbstractLog)qual$1.getLog(tp, x$2 = qual$1.getLog$default$2()).get()).deleteOldSegments() > 0 ? 1 : 0) != 0, (String)"tiered segments should have been deleted");
    }

    public static final /* synthetic */ boolean $anonfun$consumeAndValidateTierFetch$1(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$consumeAndValidateTierFetch$3(long timestamp$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            return x0$1._1$mcJ$sp() >= timestamp$2;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$consumeAndValidateTierFetch$2(TierIntegrationEndToEndTest $this, ArrayList timestampsOffsets$1, TopicPartition topicPartition$1, Consumer consumer$1, Tuple2 x$4) {
        if (x$4 != null) {
            long timestamp = x$4._1$mcJ$sp();
            long expectedOffset = ((Tuple2)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)timestampsOffsets$1).asScala().find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$3(timestamp, x0$1))).get())._2$mcJ$sp();
            $this.assertTimestampForOffsetLookupCorrect(topicPartition$1, (Consumer<String, String>)consumer$1, timestamp, expectedOffset);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ int $anonfun$consumeAndValidateTierFetch$4(Attribute attr) {
        return BoxesRunTime.unboxToInt((Object)attr.getValue());
    }

    public static final /* synthetic */ int $anonfun$consumeAndValidateTierFetch$5(Attribute attr) {
        return BoxesRunTime.unboxToInt((Object)attr.getValue());
    }

    public static final /* synthetic */ double $anonfun$consumeAndValidateTierFetch$6(Attribute attr) {
        return BoxesRunTime.unboxToDouble((Object)attr.getValue());
    }

    public static final /* synthetic */ double $anonfun$consumeAndValidateTierFetch$7(Attribute attr) {
        return BoxesRunTime.unboxToDouble((Object)attr.getValue());
    }

    public static final /* synthetic */ double $anonfun$consumeAndValidateTierFetch$8(Attribute attr) {
        return BoxesRunTime.unboxToDouble((Object)attr.getValue());
    }

    public static final /* synthetic */ long $anonfun$consumeAndValidateTierFetch$9(Attribute attr) {
        return BoxesRunTime.unboxToLong((Object)attr.getValue());
    }

    public static final /* synthetic */ double $anonfun$consumeAndValidateTierFetch$10(Attribute attr) {
        return BoxesRunTime.unboxToDouble((Object)attr.getValue());
    }

    public static final /* synthetic */ double $anonfun$consumeAndValidateTierFetch$11(Attribute attr) {
        return BoxesRunTime.unboxToDouble((Object)attr.getValue());
    }

    public static final /* synthetic */ int $anonfun$consumeAndValidateTierFetch$12(Attribute attr) {
        return BoxesRunTime.unboxToInt((Object)attr.getValue());
    }

    public static final /* synthetic */ void $anonfun$consumeAndValidateTierFetch$13(KafkaBroker server) {
        MemoryTracker memoryTracker = ((TierFetcher)server.tierFetcherOpt().get()).memoryTracker();
        Assertions.assertEquals((long)0L, (long)memoryTracker.leased(), (String)new StringBuilder(54).append("expected leased TierFetcher memory for broker ").append(server.config().brokerId()).append(" to be 0").toString());
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$createTopic$1(TierIntegrationEndToEndTest $this, String topic$1, int numPartitions$1, int replicationFactor$1, Properties topicConfig$1, Admin admin) {
        Buffer<KafkaBroker> x$6 = $this.brokers();
        Seq<ControllerServer> x$7 = $this.controllerServers();
        Map x$8 = (Map)Map$.MODULE$.empty();
        return TestUtils$.MODULE$.createTopicWithAdmin(admin, topic$1, x$6, x$7, numPartitions$1, replicationFactor$1, (Map<Object, Seq<Object>>)x$8, topicConfig$1);
    }

    public TierIntegrationEndToEndTest() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "5");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierEnableProp(), "false");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierCleanerFeatureEnableProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierCleanerEnableProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierCleanerDualCompactionValidationPercentProp(), "100");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierCleanerCompactMinEfficiencyProp(), "0.001");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "3");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), Integer.toString(Integer.MAX_VALUE));
        this.serverConfig().put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFetcherMemoryPoolSizeBytesProp(), Integer.toString(0x100000));
        this.serverConfig().put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "false");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCleanupEnableProp(), Boolean.toString(true));
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCleanupIntervalMsProp(), "0");
        this.serverConfig().put("confluent.checksum.enabled.files", "none");
        this.configureMock();
        this.topic = "test_topic";
        this.partitions = 1;
        this.exited = new AtomicBoolean(false);
    }
}

