/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import io.confluent.kafka.storage.checksum.ChecksumParams;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.management.MBeanServer;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LocalLog$;
import kafka.log.LogManager;
import kafka.log.LogTestUtils$;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.TierLogComponents;
import kafka.log.TierLogSegment;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.InternalAdmin;
import kafka.server.LeaderEndpointSupplier;
import kafka.server.ReplicaManager;
import kafka.tier.TierDeletedPartitionsCoordinator;
import kafka.tier.TierIntegrationTest$;
import kafka.tier.TierReplicaManager;
import kafka.tier.TierTopicManagerCommitter;
import kafka.tier.client.MockConsumerSupplier;
import kafka.tier.client.MockProducerSupplier;
import kafka.tier.fetcher.TierStateFetcher;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;
import kafka.tier.tasks.TierTasks;
import kafka.tier.tasks.TierTasks$;
import kafka.tier.tasks.archive.AfterUpload;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicAppender;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicDataLossValidator;
import kafka.tier.topic.TierTopicManager;
import kafka.tier.topic.TierTopicManagerConfig;
import kafka.utils.Pool;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\u0011\u001db\u0001\u0002&L\u0001ACQa\u0016\u0001\u0005\u0002aCqa\u0017\u0001C\u0002\u0013%A\f\u0003\u0004k\u0001\u0001\u0006I!\u0018\u0005\bW\u0002\u0011\r\u0011\"\u0001m\u0011\u0019Q\b\u0001)A\u0005[\"I1\u0010\u0001a\u0001\u0002\u0004%\t\u0001 \u0005\f\u0003\u000f\u0001\u0001\u0019!a\u0001\n\u0003\tI\u0001\u0003\u0006\u0002\u0016\u0001\u0001\r\u0011!Q!\nuD1\"a\u0006\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u001a!Y\u0011\u0011\u0005\u0001A\u0002\u0003\u0007I\u0011AA\u0012\u0011-\t9\u0003\u0001a\u0001\u0002\u0003\u0006K!a\u0007\t\u0017\u0005%\u0002\u00011AA\u0002\u0013\u0005\u00111\u0006\u0005\f\u0003s\u0001\u0001\u0019!a\u0001\n\u0003\tY\u0004C\u0006\u0002@\u0001\u0001\r\u0011!Q!\n\u00055\u0002bCA!\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0007B1\"!\u0015\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002T!Y\u0011q\u000b\u0001A\u0002\u0003\u0005\u000b\u0015BA#\u0011-\tI\u0006\u0001a\u0001\u0002\u0004%\t!a\u0017\t\u0017\u0005%\u0004\u00011AA\u0002\u0013\u0005\u00111\u000e\u0005\f\u0003_\u0002\u0001\u0019!A!B\u0013\ti\u0006C\u0006\u0002r\u0001\u0001\r\u00111A\u0005\u0002\u0005M\u0004bCA@\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0003C1\"!\"\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002v!Y\u0011q\u0011\u0001A\u0002\u0003\u0007I\u0011AAE\u0011-\t9\n\u0001a\u0001\u0002\u0004%\t!!'\t\u0017\u0005u\u0005\u00011A\u0001B\u0003&\u00111\u0012\u0005\n\u0003?\u0003\u0001\u0019!C\u0001\u0003CC\u0011\"!+\u0001\u0001\u0004%\t!a+\t\u0011\u0005=\u0006\u0001)Q\u0005\u0003GC\u0011\"!-\u0001\u0001\u0004%\t!a-\t\u0013\u0005\u0005\u0007\u00011A\u0005\u0002\u0005\r\u0007\u0002CAd\u0001\u0001\u0006K!!.\t\u0017\u0005%\u0007\u00011AA\u0002\u0013\u0005\u00111\u001a\u0005\f\u0003W\u0004\u0001\u0019!a\u0001\n\u0003\ti\u000fC\u0006\u0002r\u0002\u0001\r\u0011!Q!\n\u00055\u0007bCAz\u0001\u0001\u0007\t\u0019!C\u0001\u0003kD1\"!@\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0000\"Y!1\u0001\u0001A\u0002\u0003\u0005\u000b\u0015BA|\u0011-\u0011)\u0001\u0001a\u0001\u0002\u0004%\tAa\u0002\t\u0017\t\u0005\u0002\u00011AA\u0002\u0013\u0005!1\u0005\u0005\f\u0005O\u0001\u0001\u0019!A!B\u0013\u0011I\u0001C\u0005\u0003*\u0001\u0011\r\u0011\"\u0001\u0003,!A!1\u0007\u0001!\u0002\u0013\u0011i\u0003C\u0005\u00036\u0001\u0011\r\u0011\"\u0001\u00038!A!q\b\u0001!\u0002\u0013\u0011I\u0004C\u0005\u0003B\u0001\u0011\r\u0011\"\u0001\u0003D!A!Q\u000b\u0001!\u0002\u0013\u0011)\u0005C\u0004\u0003X\u0001!\tA!\u0017\t\u000f\t\u0005\u0004\u0001\"\u0001\u0003Z!9!1\r\u0001\u0005\u0002\t\u0015\u0004b\u0002B:\u0001\u0011\u0005!Q\u000f\u0005\n\u0005\u0013\u0003\u0011\u0013!C\u0001\u0005\u0017C\u0011B!)\u0001#\u0003%\tAa#\t\u000f\t\r\u0006\u0001\"\u0001\u0003&\"9!Q\u0018\u0001\u0005\u0002\t\u0015\u0006b\u0002Bd\u0001\u0011\u0005!\u0011\u001a\u0005\b\u0005o\u0004A\u0011\u0001BS\u0011\u001d\u0019\t\u0001\u0001C\u0001\u0007\u0007Aqa!\u0004\u0001\t\u0003\u0019y\u0001C\u0004\u0004\u001a\u0001!\taa\u0007\t\u000f\r\u0015\u0002\u0001\"\u0001\u0004(!91\u0011\u0007\u0001\u0005\n\rM\u0002bBB\u001c\u0001\u0011%1\u0011\b\u0005\n\u0007\u0013\u0002\u0011\u0013!C\u0005\u0007\u0017Bqaa\u0014\u0001\t\u0013\u0019\t\u0006C\u0004\u0004r\u0001!Iaa\u001d\t\u000f\r\u0015\u0005\u0001\"\u0003\u0003&\"91q\u0011\u0001\u0005\n\r%\u0005bBB]\u0001\u0011%11\u0018\u0005\b\u0007\u007f\u0003A\u0011BBa\u0011\u001d\u0019I\u000e\u0001C\u0005\u00077Dq\u0001\"\u0001\u0001\t\u0013!\u0019\u0001C\u0004\u0005\f\u0001!I\u0001\"\u0004\u0003'QKWM]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u00051k\u0015\u0001\u0002;jKJT\u0011AT\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u000b\u0005\u0002S+6\t1KC\u0001U\u0003\u0015\u00198-\u00197b\u0013\t16K\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0003\"A\u0017\u0001\u000e\u0003-\u000b\u0001\"\\8dWRKW.Z\u000b\u0002;B\u0011a\f[\u0007\u0002?*\u0011\u0001-Y\u0001\u0005kRLGN\u0003\u0002cG\u000611/\u001a:wKJT!A\u00143\u000b\u0005\u00154\u0017AB1qC\u000eDWMC\u0001h\u0003\ry'oZ\u0005\u0003S~\u0013\u0001\"T8dWRKW.Z\u0001\n[>\u001c7\u000eV5nK\u0002\nq\u0001\\8h\t&\u00148/F\u0001n!\rq'\u000f^\u0007\u0002_*\u0011\u0001\r\u001d\u0006\u0002c\u0006!!.\u0019<b\u0013\t\u0019xNA\u0005BeJ\f\u0017\u0010T5tiB\u0011Q\u000f_\u0007\u0002m*\u0011q\u000f]\u0001\u0005Y\u0006tw-\u0003\u0002zm\n11\u000b\u001e:j]\u001e\f\u0001\u0002\\8h\t&\u00148\u000fI\u0001\u0017i&,'\u000fV8qS\u000el\u0015M\\1hKJ\u001cuN\u001c4jOV\tQ\u0010E\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u0003Y\u0015!\u0002;pa&\u001c\u0017bAA\u0003\u007f\n1B+[3s)>\u0004\u0018nY'b]\u0006<WM]\"p]\u001aLw-\u0001\u000euS\u0016\u0014Hk\u001c9jG6\u000bg.Y4fe\u000e{gNZ5h?\u0012*\u0017\u000f\u0006\u0003\u0002\f\u0005E\u0001c\u0001*\u0002\u000e%\u0019\u0011qB*\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003'9\u0011\u0011!a\u0001{\u0006\u0019\u0001\u0010J\u0019\u0002/QLWM\u001d+pa&\u001cW*\u00198bO\u0016\u00148i\u001c8gS\u001e\u0004\u0013!\u0005;jKJ$v\u000e]5d\u0007>t7/^7feV\u0011\u00111\u0004\t\u0004}\u0006u\u0011bAA\u0010\u007f\n\tB+[3s)>\u0004\u0018nY\"p]N,X.\u001a:\u0002+QLWM\u001d+pa&\u001c7i\u001c8tk6,'o\u0018\u0013fcR!\u00111BA\u0013\u0011%\t\u0019BCA\u0001\u0002\u0004\tY\"\u0001\nuS\u0016\u0014Hk\u001c9jG\u000e{gn];nKJ\u0004\u0013!\u0005;jKJdunZ\"p[B|g.\u001a8ugV\u0011\u0011Q\u0006\t\u0005\u0003_\t)$\u0004\u0002\u00022)\u0019\u00111G'\u0002\u00071|w-\u0003\u0003\u00028\u0005E\"!\u0005+jKJdunZ\"p[B|g.\u001a8ug\u0006)B/[3s\u0019><7i\\7q_:,g\u000e^:`I\u0015\fH\u0003BA\u0006\u0003{A\u0011\"a\u0005\u000e\u0003\u0003\u0005\r!!\f\u0002%QLWM\u001d'pO\u000e{W\u000e]8oK:$8\u000fI\u0001\bi\u0016l\u0007\u000fR5s+\t\t)\u0005\u0005\u0003\u0002H\u00055SBAA%\u0015\r\tY\u0005]\u0001\u0003S>LA!a\u0014\u0002J\t!a)\u001b7f\u0003-!X-\u001c9ESJ|F%Z9\u0015\t\u0005-\u0011Q\u000b\u0005\n\u0003'\u0001\u0012\u0011!a\u0001\u0003\u000b\n\u0001\u0002^3na\u0012K'\u000fI\u0001\ni&,'\u000fV1tWN,\"!!\u0018\u0011\t\u0005}\u0013QM\u0007\u0003\u0003CR1!a\u0019L\u0003\u0015!\u0018m]6t\u0013\u0011\t9'!\u0019\u0003\u0013QKWM\u001d+bg.\u001c\u0018!\u0004;jKJ$\u0016m]6t?\u0012*\u0017\u000f\u0006\u0003\u0002\f\u00055\u0004\"CA\n'\u0005\u0005\t\u0019AA/\u0003)!\u0018.\u001a:UCN\\7\u000fI\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s+\t\t)\b\u0005\u0003\u0002x\u0005mTBAA=\u0015\t\u0011W*\u0003\u0003\u0002~\u0005e$A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0013e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002\f\u0005\r\u0005\"CA\n-\u0005\u0005\t\u0019AA;\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0013a\u0004;jKJ|%M[3diN#xN]3\u0016\u0005\u0005-\u0005\u0003BAG\u0003'k!!a$\u000b\u0007\u0005E5*A\u0003ti>\u0014X-\u0003\u0003\u0002\u0016\u0006=%aG'pG.Le.T3n_JLH+[3s\u001f\nTWm\u0019;Ti>\u0014X-A\nuS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f?\u0012*\u0017\u000f\u0006\u0003\u0002\f\u0005m\u0005\"CA\n3\u0005\u0005\t\u0019AAF\u0003A!\u0018.\u001a:PE*,7\r^*u_J,\u0007%\u0001\u0011uS\u0016\u0014H)\u001a7fi\u0016$\u0007+\u0019:uSRLwN\\:D_>\u0014H-\u001b8bi>\u0014XCAAR!\rQ\u0016QU\u0005\u0004\u0003O[%\u0001\t+jKJ$U\r\\3uK\u0012\u0004\u0016M\u001d;ji&|gn]\"p_J$\u0017N\\1u_J\fA\u0005^5fe\u0012+G.\u001a;fIB\u000b'\u000f^5uS>t7oQ8pe\u0012Lg.\u0019;pe~#S-\u001d\u000b\u0005\u0003\u0017\ti\u000bC\u0005\u0002\u0014q\t\t\u00111\u0001\u0002$\u0006\tC/[3s\t\u0016dW\r^3e!\u0006\u0014H/\u001b;j_:\u001c8i\\8sI&t\u0017\r^8sA\u0005\u0001B/[3s'R\fG/\u001a$fi\u000eDWM]\u000b\u0003\u0003k\u0003B!a.\u0002>6\u0011\u0011\u0011\u0018\u0006\u0004\u0003w[\u0015a\u00024fi\u000eDWM]\u0005\u0005\u0003\u007f\u000bIL\u0001\tUS\u0016\u00148\u000b^1uK\u001a+Go\u00195fe\u0006!B/[3s'R\fG/\u001a$fi\u000eDWM]0%KF$B!a\u0003\u0002F\"I\u00111C\u0010\u0002\u0002\u0003\u0007\u0011QW\u0001\u0012i&,'o\u0015;bi\u00164U\r^2iKJ\u0004\u0013\u0001\u00027pON,\"!!4\u0011\r\u0005=\u0017q\\As\u001d\u0011\t\t.a7\u000f\t\u0005M\u0017\u0011\\\u0007\u0003\u0003+T1!a6P\u0003\u0019a$o\\8u}%\tA+C\u0002\u0002^N\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002b\u0006\r(aA*fc*\u0019\u0011Q\\*\u0011\t\u0005=\u0012q]\u0005\u0005\u0003S\f\tDA\u0005NKJ<W\r\u001a'pO\u0006AAn\\4t?\u0012*\u0017\u000f\u0006\u0003\u0002\f\u0005=\b\"CA\nE\u0005\u0005\t\u0019AAg\u0003\u0015awnZ:!\u0003A!\u0018.\u001a:U_BL7-T1oC\u001e,'/\u0006\u0002\u0002xB\u0019a0!?\n\u0007\u0005mxP\u0001\tUS\u0016\u0014Hk\u001c9jG6\u000bg.Y4fe\u0006!B/[3s)>\u0004\u0018nY'b]\u0006<WM]0%KF$B!a\u0003\u0003\u0002!I\u00111C\u0013\u0002\u0002\u0003\u0007\u0011q_\u0001\u0012i&,'\u000fV8qS\u000el\u0015M\\1hKJ\u0004\u0013\u0001E2p]N,X.\u001a:TkB\u0004H.[3s+\t\u0011I\u0001\u0005\u0005\u0003\f\tE!Q\u0003B\u000b\u001b\t\u0011iAC\u0002\u0003\u0010-\u000baa\u00197jK:$\u0018\u0002\u0002B\n\u0005\u001b\u0011A#T8dW\u000e{gn];nKJ\u001cV\u000f\u001d9mS\u0016\u0014\b#\u0002*\u0003\u0018\tm\u0011b\u0001B\r'\n)\u0011I\u001d:bsB\u0019!K!\b\n\u0007\t}1K\u0001\u0003CsR,\u0017\u0001F2p]N,X.\u001a:TkB\u0004H.[3s?\u0012*\u0017\u000f\u0006\u0003\u0002\f\t\u0015\u0002\"CA\nQ\u0005\u0005\t\u0019\u0001B\u0005\u0003E\u0019wN\\:v[\u0016\u00148+\u001e9qY&,'\u000fI\u0001\u000e[\u0006Dx+Y5u)&lW-T:\u0016\u0005\t5\u0002c\u0001*\u00030%\u0019!\u0011G*\u0003\u0007%sG/\u0001\bnCb<\u0016-\u001b;US6,Wj\u001d\u0011\u0002%QLWM\u001d*fa2L7-Y'b]\u0006<WM]\u000b\u0003\u0005s\u00012A\u0017B\u001e\u0013\r\u0011id\u0013\u0002\u0013)&,'OU3qY&\u001c\u0017-T1oC\u001e,'/A\nuS\u0016\u0014(+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b%A\u0006n\u0005\u0016\fgnU3sm\u0016\u0014XC\u0001B#!\u0011\u00119E!\u0015\u000e\u0005\t%#\u0002\u0002B&\u0005\u001b\n!\"\\1oC\u001e,W.\u001a8u\u0015\t\u0011y%A\u0003kCZ\f\u00070\u0003\u0003\u0003T\t%#aC'CK\u0006t7+\u001a:wKJ\fA\"\u001c\"fC:\u001cVM\u001d<fe\u0002\nqb\u00195fG.\u001cX/\\#oC\ndW\rZ\u000b\u0003\u00057\u00022A\u0015B/\u0013\r\u0011yf\u0015\u0002\b\u0005>|G.Z1o\u00039\u0019G.Z1okB,e.\u00192mK\u0012\fQb\u00197fC:,\boQ8oM&<WC\u0001B4!\u0011\u0011IGa\u001c\u000e\u0005\t-$b\u0001B7\u0017\u0006)1\u000f^1uK&!!\u0011\u000fB6\u0005}!\u0016.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3DY\u0016\fg.\u001e9D_:4\u0017nZ\u0001\u0006g\u0016$X\u000f\u001d\u000b\t\u0003\u0017\u00119Ha\u001f\u0003\u0006\"9!\u0011P\u001aA\u0002\tm\u0013A\u000b;jKJ$v\u000e]5d\u001b\u0006$XM]5bY&T\u0018\r^5p]\u001a\u0013x.\\*oCB\u001c\bn\u001c;F]\u0006\u0014G.\u001a\u0005\n\u0005{\u001a\u0004\u0013!a\u0001\u0005\u007f\nqA\\;n\u0019><7\u000fE\u0002v\u0005\u0003K1Aa!w\u0005\u001dIe\u000e^3hKJD\u0011Ba\"4!\u0003\u0005\rAa \u0002%9,X.\u0011:dQ&4XM\u001d+ie\u0016\fGm]\u0001\u0010g\u0016$X\u000f\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!Q\u0012\u0016\u0005\u0005\u007f\u0012yi\u000b\u0002\u0003\u0012B!!1\u0013BO\u001b\t\u0011)J\u0003\u0003\u0003\u0018\ne\u0015!C;oG\",7m[3e\u0015\r\u0011YjU\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002BP\u0005+\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003=\u0019X\r^;qI\u0011,g-Y;mi\u0012\u001a\u0014A\u00022fM>\u0014X\r\u0006\u0002\u0002\f!\u001aaG!+\u0011\t\t-&\u0011X\u0007\u0003\u0005[SAAa,\u00032\u0006\u0019\u0011\r]5\u000b\t\tM&QW\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\u00119LZ\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0005w\u0013iK\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012|wO\u001c\u0015\u0004o\t\u0005\u0007\u0003\u0002BV\u0005\u0007LAA!2\u0003.\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0016i\u0016\u001cH/\u0011:dQ&4XM]%n[&<'/\u0019;f)\u0011\tYAa3\t\u000f\te\u0004\b1\u0001\u0003\\!:\u0001Ha4\u0003\\\nu\u0007\u0003\u0002Bi\u0005/l!Aa5\u000b\t\tU'\u0011W\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\te'1\u001b\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\u00028b[\u0016\f#Aa8\u0002mm$\u0017n\u001d9mCft\u0015-\\3~]QLWM\u001d+pa&\u001cW*\u0019;fe&\fG.\u001b>bi&|gN\u0012:p[Ns\u0017\r]:i_Rl4\u0010M?)\u000fa\u0012\u0019Oa<\u0003rB!!Q\u001dBv\u001b\t\u00119O\u0003\u0003\u0003j\nM\u0017\u0001\u00039s_ZLG-\u001a:\n\t\t5(q\u001d\u0002\f-\u0006dW/Z*pkJ\u001cW-\u0001\u0005c_>dW-\u00198tY\u0011\u0011\u0019P!>\u001a\u0003\u0005I\u0012\u0001A\u0001\u0012i\u0016\u001cH\u000fT8h'&TX\rR3uC&d\u0007fA\u001d\u0003|B!!1\u0016B\u007f\u0013\u0011\u0011yP!,\u0003\tQ+7\u000f^\u0001!i\u0016\u001cH/\u0011:dQ&4XM]+qY>\fG-\u00118e\u001b\u0006$XM]5bY&TX\r\u0006\u0003\u0002\f\r\u0015\u0001b\u0002B=u\u0001\u0007!1\f\u0015\bu\t='1\u001cBoQ\u001dQ$1\u001dBx\u0007\u0017aCAa=\u0003v\u0006\tE/Z:u\u0003J\u001c\u0007.\u001b<feV\u0003Hn\\1e\u0003:$W*\u0019;fe&\fG.\u001b>f/\",gn\u0016:ji\u0016D\u0015\r\u001d9f]N\fe\r^3s\u0005\u0016\u001cw.\\3MK\u0006$WM\u001d\u000b\u0005\u0003\u0017\u0019\t\u0002C\u0004\u0003zm\u0002\rAa\u0017)\u000fm\u0012yMa7\u0003^\":1Ha9\u0003p\u000e]A\u0006\u0002Bz\u0005k\fa\u0006^3ti\u0006\u00138\r[5wKJ,\u0006\u000f\\8bI^KG\u000f\u001b'j[&$X\rZ+qY>\fGmQ8oGV\u0014(/\u001a8dsR!\u00111BB\u000f\u0011\u001d\u0011I\b\u0010a\u0001\u00057Bs\u0001\u0010Bh\u00057\u0014i\u000eK\u0004=\u0005G\u0014yoa\t-\t\tM(Q_\u0001\u0017i\u0016\u001cH/\u0011:dQ&4XM\u001d'bO6+GO]5dgR!\u00111BB\u0015\u0011\u001d\u0011I(\u0010a\u0001\u00057Bs!\u0010Bh\u00057\u0014i\u000eK\u0004>\u0005G\u0014yoa\f-\t\tM(Q_\u0001\u001dGJ,\u0017\r^3US\u0016\u0014Hk\u001c9jG6\u000bg.Y4fe\u000e{gNZ5h)\ri8Q\u0007\u0005\b\u0005sr\u0004\u0019\u0001B.\u0003I9\u0018-\u001b;G_JLU.\\5he\u0006$\u0018n\u001c8\u0015\u0019\u0005-11HB\u001f\u0007\u0003\u001a\u0019e!\u0012\t\u000f\u0005%w\b1\u0001\u0002N\"91qH A\u0002\t5\u0012a\u00037fC\u0012,'/\u00129pG\"Dq!!\u0017@\u0001\u0004\ti\u0006C\u0004\u0003\u0006}\u0002\rA!\u0003\t\u0013\r\u001ds\b%AA\u0002\tm\u0013\u0001\u00042fG>lW\rT3bI\u0016\u0014\u0018\u0001H<bSR4uN]%n[&<'/\u0019;j_:$C-\u001a4bk2$H%N\u000b\u0003\u0007\u001bRCAa\u0017\u0003\u0010\u0006q\u0012M]2iSZ,\u0017I\u001c3NCR,'/[1mSj,WK\u001c;jYR\u0013X/\u001a\u000b\t\u0003\u0017\u0019\u0019f!\u0018\u0004p!91QK!A\u0002\r]\u0013\u0001\u00029sK\u0012\u0004RAUB-\u00057J1aa\u0017T\u0005%1UO\\2uS>t\u0007\u0007C\u0004\u0004`\u0005\u0003\ra!\u0019\u0002\u00075\u001cx\r\u0005\u0003\u0004d\r-d\u0002BB3\u0007O\u00022!a5T\u0013\r\u0019IgU\u0001\u0007!J,G-\u001a4\n\u0007e\u001ciGC\u0002\u0004jMCqA!\u0002B\u0001\u0004\u0011I!\u0001\u0017wC2LG-\u0019;f!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0007>tG/Y5oK\u0012Len\u00142kK\u000e$8\u000b^8sKR1\u00111BB;\u0007oBq!a\"C\u0001\u0004\tY\tC\u0004\u0002J\n\u0003\ra!\u001f\u0011\r\u0005=71PB@\u0013\u0011\u0019i(a9\u0003\u0011%#XM]1cY\u0016\u0004B!a\f\u0004\u0002&!11QA\u0019\u0005-\t%m\u001d;sC\u000e$Hj\\4\u0002'M,G/\u001e9US\u0016\u00148i\\7q_:,g\u000e^:\u0002\u0015\r\u0014X-\u0019;f\u0019><7\u000f\u0006\u0007\u0004\f\u000eE5QSBV\u0007[\u001by\u000b\u0005\u0004\u0002P\u000e5\u0015Q]\u0005\u0005\u0007\u001f\u000b\u0019O\u0001\u0006J]\u0012,\u00070\u001a3TKFDqaa%E\u0001\u0004\u0011i#A\u0001o\u0011\u001d\u00199\n\u0012a\u0001\u00073\u000b\u0011\u0002\\8h\u0007>tg-[4\u0011\t\rm5qU\u0007\u0003\u0007;SA!a\r\u0004 *!1\u0011UBR\u0003%Ig\u000e^3s]\u0006d7OC\u0002\u0004&\u000e\fqa\u001d;pe\u0006<W-\u0003\u0003\u0004*\u000eu%!\u0003'pO\u000e{gNZ5h\u0011\u001d\t\t\u0005\u0012a\u0001\u0003\u000bBq!!\u000bE\u0001\u0004\ti\u0003C\u0004\u00042\u0012\u0003\raa-\u0002)1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m!\u0011\u0019Yj!.\n\t\r]6Q\u0014\u0002\u0015\u0019><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0002%5|7m\u001b*fa2L7-Y'b]\u0006<WM\u001d\u000b\u0005\u0003k\u001ai\fC\u0004\u0002J\u0016\u0003\ra!\u001f\u0002%]\u0014\u0018\u000e^3SK\u000e|'\u000f\u001a\"bi\u000eDWm\u001d\u000b\r\u0003\u0017\u0019\u0019m!2\u0004H\u000eE7Q\u001b\u0005\b\u0003g1\u0005\u0019AB@\u0011\u001d\u0019yD\u0012a\u0001\u0005[Aqa!3G\u0001\u0004\u0019Y-\u0001\u0006cCN,wJ\u001a4tKR\u00042AUBg\u0013\r\u0019ym\u0015\u0002\u0005\u0019>tw\rC\u0004\u0004T\u001a\u0003\rA!\f\u0002\u000f\t\fGo\u00195fg\"91q\u001b$A\u0002\t5\u0012a\u0004:fG>\u0014Hm\u001d)fe\n\u000bGo\u00195\u0002\u001b\r\u0014X-\u0019;f%\u0016\u001cwN\u001d3t))\u0019in!<\u0004z\u000em8Q \t\u0005\u0007?\u001cI/\u0004\u0002\u0004b*!11]Bs\u0003\u0019\u0011XmY8sI*\u00191q]2\u0002\r\r|W.\\8o\u0013\u0011\u0019Yo!9\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011\u001d\u0019yo\u0012a\u0001\u0007c\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0004t\u000eUXBABs\u0013\u0011\u00199p!:\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"91qH$A\u0002\t5\u0002bBBe\u000f\u0002\u000711\u001a\u0005\b\u0007\u007f<\u0005\u0019\u0001B\u0017\u0003)qW/\u001c*fG>\u0014Hm]\u0001\f[\u0016$(/[2WC2,X\r\u0006\u0004\u0004L\u0012\u0015A\u0011\u0002\u0005\b\t\u000fA\u0005\u0019AB1\u0003)iW\r\u001e:jGRK\b/\u001a\u0005\b\u00057D\u0005\u0019AB1\u0003I!\u0018.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3\u0015\t\u0011=AQ\u0003\t\u0005\u0005S\"\t\"\u0003\u0003\u0005\u0014\t-$A\u0005+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016Dq\u0001b\u0006J\u0001\u0004\u0019\t0A\u0005qCJ$\u0018\u000e^5p]\":\u0001\u0001b\u0007\u0005\"\u0011\r\u0002\u0003\u0002BV\t;IA\u0001b\b\u0003.\n\u0019A+Y4\u0002\u000bY\fG.^3\"\u0005\u0011\u0015\u0012aC5oi\u0016<'/\u0019;j_:\u0004")
public class TierIntegrationTest {
    private final MockTime mockTime = new MockTime(0L, 0L);
    private final ArrayList<String> logDirs = new ArrayList<String>(Collections.singleton(TestUtils.tempDirectory(null, null).getAbsolutePath()));
    private TierTopicManagerConfig tierTopicManagerConfig;
    private TierTopicConsumer tierTopicConsumer;
    private TierLogComponents tierLogComponents;
    private File tempDir;
    private TierTasks tierTasks;
    private ReplicaManager replicaManager;
    private MockInMemoryTierObjectStore tierObjectStore;
    private TierDeletedPartitionsCoordinator tierDeletedPartitionsCoordinator = (TierDeletedPartitionsCoordinator)Mockito.mock(TierDeletedPartitionsCoordinator.class);
    private TierStateFetcher tierStateFetcher = (TierStateFetcher)Mockito.mock(TierStateFetcher.class);
    private Seq<MergedLog> logs;
    private TierTopicManager tierTopicManager;
    private MockConsumerSupplier<byte[], byte[]> consumerSupplier;
    private final int maxWaitTimeMs;
    private final TierReplicaManager tierReplicaManager = new TierReplicaManager();
    private final MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();

    private MockTime mockTime() {
        return this.mockTime;
    }

    public ArrayList<String> logDirs() {
        return this.logDirs;
    }

    public TierTopicManagerConfig tierTopicManagerConfig() {
        return this.tierTopicManagerConfig;
    }

    public void tierTopicManagerConfig_$eq(TierTopicManagerConfig x$1) {
        this.tierTopicManagerConfig = x$1;
    }

    public TierTopicConsumer tierTopicConsumer() {
        return this.tierTopicConsumer;
    }

    public void tierTopicConsumer_$eq(TierTopicConsumer x$1) {
        this.tierTopicConsumer = x$1;
    }

    public TierLogComponents tierLogComponents() {
        return this.tierLogComponents;
    }

    public void tierLogComponents_$eq(TierLogComponents x$1) {
        this.tierLogComponents = x$1;
    }

    public File tempDir() {
        return this.tempDir;
    }

    public void tempDir_$eq(File x$1) {
        this.tempDir = x$1;
    }

    public TierTasks tierTasks() {
        return this.tierTasks;
    }

    public void tierTasks_$eq(TierTasks x$1) {
        this.tierTasks = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public MockInMemoryTierObjectStore tierObjectStore() {
        return this.tierObjectStore;
    }

    public void tierObjectStore_$eq(MockInMemoryTierObjectStore x$1) {
        this.tierObjectStore = x$1;
    }

    public TierDeletedPartitionsCoordinator tierDeletedPartitionsCoordinator() {
        return this.tierDeletedPartitionsCoordinator;
    }

    public void tierDeletedPartitionsCoordinator_$eq(TierDeletedPartitionsCoordinator x$1) {
        this.tierDeletedPartitionsCoordinator = x$1;
    }

    public TierStateFetcher tierStateFetcher() {
        return this.tierStateFetcher;
    }

    public void tierStateFetcher_$eq(TierStateFetcher x$1) {
        this.tierStateFetcher = x$1;
    }

    public Seq<MergedLog> logs() {
        return this.logs;
    }

    public void logs_$eq(Seq<MergedLog> x$1) {
        this.logs = x$1;
    }

    public TierTopicManager tierTopicManager() {
        return this.tierTopicManager;
    }

    public void tierTopicManager_$eq(TierTopicManager x$1) {
        this.tierTopicManager = x$1;
    }

    public MockConsumerSupplier<byte[], byte[]> consumerSupplier() {
        return this.consumerSupplier;
    }

    public void consumerSupplier_$eq(MockConsumerSupplier<byte[], byte[]> x$1) {
        this.consumerSupplier = x$1;
    }

    public int maxWaitTimeMs() {
        return this.maxWaitTimeMs;
    }

    public TierReplicaManager tierReplicaManager() {
        return this.tierReplicaManager;
    }

    public MBeanServer mBeanServer() {
        return this.mBeanServer;
    }

    public boolean checksumEnabled() {
        return false;
    }

    public boolean cleanupEnabled() {
        return false;
    }

    public TierPartitionStateCleanupConfig cleanupConfig() {
        return new TierPartitionStateCleanupConfig(this.cleanupEnabled(), Defaults$.MODULE$.TierPartitionStateCleanupDelayMs(), 0L);
    }

    public void setup(boolean tierTopicMaterializationFromSnapshotEnable, Integer numLogs, Integer numArchiverThreads) {
        TestUtils$.MODULE$.clearYammerMetrics();
        this.tierTopicManagerConfig_$eq(this.createTierTopicManagerConfig(tierTopicMaterializationFromSnapshotEnable));
        this.tierObjectStore_$eq(new MockInMemoryTierObjectStore((Time)this.mockTime(), new MockInMemoryTierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1))));
        this.setupTierComponents();
        long x$5 = 604800000L;
        long x$6 = 604800000L;
        long x$7 = -2L;
        long x$8 = -1L;
        long x$9 = -2L;
        long x$10 = 0L;
        String x$11 = "delete";
        int x$12 = 0xA00000;
        String x$13 = LogConfig.DEFAULT_MESSAGE_FORMAT_VERSION;
        long x$14 = 60000L;
        long x$15 = -1L;
        long x$16 = 86400000L;
        int x$17 = 0x6400000;
        long x$18 = -1L;
        boolean x$19 = true;
        long x$20 = 1L;
        long x$21 = Long.MAX_VALUE;
        boolean x$22 = false;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$5, 150, x$6, x$7, x$8, x$9, x$10, x$11, 65536, 1, x$12, x$13, x$14, true, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22);
        File tempDir = TestUtils.tempDirectory(null, null);
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(Predef$.MODULE$.Integer2int(numLogs));
        IndexedSeq<MergedLog> logs = this.createLogs(Predef$.MODULE$.Integer2int(numLogs), logConfig, tempDir, this.tierLogComponents(), logDirFailureChannel);
        ReplicaManager replicaManager = this.mockReplicaManager((Iterable<AbstractLog>)logs);
        Pool logPool = new Pool((Option)None$.MODULE$);
        logs.map((Function1 & Serializable)log -> (AbstractLog)logPool.put((Object)log.topicPartition(), log));
        int x$23 = Predef$.MODULE$.Integer2int(numArchiverThreads);
        int x$24 = Predef$.MODULE$.Integer2int(numArchiverThreads);
        int x$25 = Predef$.MODULE$.Integer2int(numArchiverThreads);
        long x$28 = 600000L;
        long x$29 = 500L;
        int x$30 = 50;
        boolean x$31 = false;
        boolean x$32 = false;
        None$ x$33 = None$.MODULE$;
        None$ x$34 = None$.MODULE$;
        TierTasks tierTasks = new TierTasks(new TierTasksConfig(x$23, x$24, x$25, 1, x$28, x$29, x$30, 20, x$31, x$32, (Option)x$33, (Option)x$34), replicaManager, this.tierReplicaManager(), this.tierDeletedPartitionsCoordinator(), (TierTopicAppender)this.tierTopicManager(), (TierObjectStore)this.tierObjectStore(), (Time)this.mockTime(), (Option)None$.MODULE$);
        this.tierTasks_$eq(tierTasks);
        this.replicaManager_$eq(replicaManager);
        this.logs_$eq((Seq<MergedLog>)logs);
        this.tempDir_$eq(tempDir);
    }

    public Integer setup$default$2() {
        return Predef$.MODULE$.int2Integer(2);
    }

    public Integer setup$default$3() {
        return Predef$.MODULE$.int2Integer(10);
    }

    @BeforeEach
    public void before() {
        TestUtils$.MODULE$.verifyNoUnexpectedThreads("@Before");
    }

    @AfterEach
    public void teardown() {
        this.tierTasks().shutdown();
        this.tierTopicManager().shutdown();
        this.tierTopicConsumer().shutdown();
        ReplicaManager qual$1 = this.replicaManager();
        boolean x$1 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$1);
        this.tierObjectStore().close();
        this.logs().foreach((Function1 & Serializable)x$11 -> {
            x$11.close();
            return BoxedUnit.UNIT;
        });
        CollectionConverters$.MODULE$.ListHasAsScala(this.logDirs()).asScala().foreach((Function1 & Serializable)path -> {
            TierIntegrationTest.$anonfun$teardown$2(path);
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.verifyNoUnexpectedThreads("@After");
        Mockito.framework().clearInlineMocks();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.tierTopicMaterializationFromSnapshot={0}")
    @ValueSource(booleans={true, false})
    public void testArchiverImmigrate(boolean tierTopicMaterializationFromSnapshotEnable) {
        this.setup(tierTopicMaterializationFromSnapshotEnable, this.setup$default$2(), this.setup$default$3());
        this.tierTasks().start();
        this.waitForImmigration(this.logs(), 1, this.tierTasks(), this.consumerSupplier(), true);
        this.tierReplicaManager().becomeFollower(this.tierPartitionState(((MergedLog)this.logs().head()).topicPartition()));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 2000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$testArchiverImmigrate$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Archiver should process pending emigrations");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.tierReplicaManager().becomeLeader(this.tierPartitionState(((MergedLog)this.logs().head()).topicPartition()), 2);
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 2000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$testArchiverImmigrate$4(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Archiver should process pending immigrations");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLogSizeDetail() {
        void archiveAndMaterializeUntilTrue_consumerSupplier;
        this.setup(true, Predef$.MODULE$.int2Integer(3), this.setup$default$3());
        this.tierTasks().start();
        this.logs().foreach((Function1 & Serializable)log -> {
            this.writeRecordBatches((AbstractLog)log, 1, 0L, 6, 4);
            return BoxedUnit.UNIT;
        });
        this.waitForImmigration(this.logs(), 1, this.tierTasks(), this.consumerSupplier(), true);
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier = this.consumerSupplier();
        String string = "Should materialize segments";
        JFunction0.mcZ.sp & Serializable archiveAndMaterializeUntilTrue_pred = (JFunction0.mcZ.sp & Serializable)() -> this.logs().forall((Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testLogSizeDetail$3(log)));
        long l = 100L;
        long archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs = this.maxWaitTimeMs();
        long archiveAndMaterializeUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, (MockConsumerSupplier)archiveAndMaterializeUntilTrue_consumerSupplier, (Function0)archiveAndMaterializeUntilTrue_pred)) {
            void archiveAndMaterializeUntilTrue_waitUntilTrue_pause;
            if (System.currentTimeMillis() > archiveAndMaterializeUntilTrue_waitUntilTrue_startTime + archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs) {
                void archiveAndMaterializeUntilTrue_msg;
                Assertions.fail((String)archiveAndMaterializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs), (long)archiveAndMaterializeUntilTrue_waitUntilTrue_pause));
        }
        Object var12_3 = null;
        string = null;
        mockConsumerSupplier = null;
        MergedLog logNormal = (MergedLog)this.logs().apply(0);
        MergedLog logDelete = (MergedLog)this.logs().apply(1);
        MergedLog logStray = (MergedLog)this.logs().apply(2);
        long localSize = logNormal.sizeDetails().localSize();
        long tieredSize = logNormal.sizeDetails().tieredSize();
        long untieredSize = logNormal.sizeDetails().untieredSize();
        long totalSize = logNormal.sizeDetails().totalSize();
        Assertions.assertTrue((localSize > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((tieredSize > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((untieredSize > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((totalSize > 0L ? 1 : 0) != 0);
        this.logs().foreach((Function1 & Serializable)log -> {
            TierIntegrationTest.$anonfun$testLogSizeDetail$4(localSize, tieredSize, untieredSize, totalSize, log);
            return BoxedUnit.UNIT;
        });
        TopicPartition logDeleteDirName_topicPartition = logDelete.topicPartition();
        Object var21_14 = null;
        logDelete.renameDir(LocalLog$.MODULE$.logDeleteDirName(logDeleteDirName_topicPartition), false);
        TopicPartition logStrayDirName_topicPartition = logStray.topicPartition();
        Object var22_15 = null;
        logStray.renameDir(LocalLog$.MODULE$.logStrayDirName(logStrayDirName_topicPartition), false);
        Assertions.assertEquals((long)localSize, (long)logDelete.sizeDetails().localSize());
        Assertions.assertEquals((long)0L, (long)logDelete.sizeDetails().tieredSize());
        Assertions.assertEquals((long)0L, (long)logDelete.sizeDetails().untieredSize());
        Assertions.assertEquals((long)totalSize, (long)logDelete.sizeDetails().totalSize());
        Assertions.assertEquals((long)localSize, (long)logStray.sizeDetails().localSize());
        Assertions.assertEquals((long)0L, (long)logStray.sizeDetails().tieredSize());
        Assertions.assertEquals((long)0L, (long)logStray.sizeDetails().untieredSize());
        Assertions.assertEquals((long)totalSize, (long)logStray.sizeDetails().totalSize());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.tierTopicMaterializationFromSnapshot={0}")
    @ValueSource(booleans={true, false})
    public void testArchiverUploadAndMaterialize(boolean tierTopicMaterializationFromSnapshotEnable) {
        void archiveAndMaterializeUntilTrue_consumerSupplier;
        void archiveAndMaterializeUntilTrue_consumerSupplier2;
        void archiveAndMaterializeUntilTrue_consumerSupplier3;
        this.setup(tierTopicMaterializationFromSnapshotEnable, Predef$.MODULE$.int2Integer(10), this.setup$default$3());
        this.tierTasks().start();
        int numBatches = 6;
        int leaderEpoch = 1;
        this.logs().foreach((Function1 & Serializable)log -> {
            this.writeRecordBatches((AbstractLog)log, leaderEpoch, 0L, numBatches, 4);
            return BoxedUnit.UNIT;
        });
        this.waitForImmigration(this.logs(), leaderEpoch, this.tierTasks(), this.consumerSupplier(), true);
        this.logs().foreach((Function1 & Serializable)log -> {
            TierIntegrationTest.$anonfun$testArchiverUploadAndMaterialize$2(leaderEpoch, log);
            return BoxedUnit.UNIT;
        });
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier = this.consumerSupplier();
        String string = "Should materialize segments";
        JFunction0.mcZ.sp & Serializable archiveAndMaterializeUntilTrue_pred = (JFunction0.mcZ.sp & Serializable)() -> this.logs().forall((Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverUploadAndMaterialize$4(log)));
        long l = 100L;
        long archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs = this.maxWaitTimeMs();
        long archiveAndMaterializeUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, (MockConsumerSupplier)archiveAndMaterializeUntilTrue_consumerSupplier3, (Function0)archiveAndMaterializeUntilTrue_pred)) {
            void archiveAndMaterializeUntilTrue_waitUntilTrue_pause;
            if (System.currentTimeMillis() > archiveAndMaterializeUntilTrue_waitUntilTrue_startTime + archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs) {
                void archiveAndMaterializeUntilTrue_msg;
                Assertions.fail((String)archiveAndMaterializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs), (long)archiveAndMaterializeUntilTrue_waitUntilTrue_pause));
        }
        Object var4_6 = null;
        string = null;
        mockConsumerSupplier = null;
        this.logs().foreach((Function1 & Serializable)log -> {
            TierIntegrationTest.$anonfun$testArchiverUploadAndMaterialize$5(log);
            return BoxedUnit.UNIT;
        });
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier2 = this.consumerSupplier();
        String string2 = "Should materialize segments";
        JFunction0.mcZ.sp & Serializable archiveAndMaterializeUntilTrue_pred2 = (JFunction0.mcZ.sp & Serializable)() -> this.logs().forall((Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverUploadAndMaterialize$7(log)));
        long l2 = 100L;
        long archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs2 = this.maxWaitTimeMs();
        long archiveAndMaterializeUntilTrue_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, (MockConsumerSupplier)archiveAndMaterializeUntilTrue_consumerSupplier2, (Function0)archiveAndMaterializeUntilTrue_pred2)) {
            void archiveAndMaterializeUntilTrue_waitUntilTrue_pause;
            if (System.currentTimeMillis() > archiveAndMaterializeUntilTrue_waitUntilTrue_startTime2 + archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs2) {
                void archiveAndMaterializeUntilTrue_msg;
                Assertions.fail((String)archiveAndMaterializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs2), (long)archiveAndMaterializeUntilTrue_waitUntilTrue_pause));
        }
        Object var13_12 = null;
        string2 = null;
        mockConsumerSupplier2 = null;
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        this.logs().foreach((Function1 & Serializable)log -> {
            TierIntegrationTest.$anonfun$testArchiverUploadAndMaterialize$8(log);
            return BoxedUnit.UNIT;
        });
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier3 = this.consumerSupplier();
        String string3 = "Should materialize segments";
        JFunction0.mcZ.sp & Serializable archiveAndMaterializeUntilTrue_pred3 = (JFunction0.mcZ.sp & Serializable)() -> this.logs().forall((Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverUploadAndMaterialize$10(log)));
        long l3 = 100L;
        long archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs3 = this.maxWaitTimeMs();
        long archiveAndMaterializeUntilTrue_waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, (MockConsumerSupplier)archiveAndMaterializeUntilTrue_consumerSupplier, (Function0)archiveAndMaterializeUntilTrue_pred3)) {
            void archiveAndMaterializeUntilTrue_waitUntilTrue_pause;
            if (System.currentTimeMillis() > archiveAndMaterializeUntilTrue_waitUntilTrue_startTime3 + archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs3) {
                void archiveAndMaterializeUntilTrue_msg;
                Assertions.fail((String)archiveAndMaterializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs3), (long)archiveAndMaterializeUntilTrue_waitUntilTrue_pause));
        }
        Object var22_18 = null;
        string3 = null;
        mockConsumerSupplier3 = null;
        this.logs().foreach((Function1 & Serializable)log -> {
            TierIntegrationTest.$anonfun$testArchiverUploadAndMaterialize$11(log);
            return BoxedUnit.UNIT;
        });
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.tierTopicMaterializationFromSnapshot={0}")
    @ValueSource(booleans={true, false})
    public void testArchiverUploadAndMaterializeWhenWriteHappensAfterBecomeLeader(boolean tierTopicMaterializationFromSnapshotEnable) {
        void archiveAndMaterializeUntilTrue_consumerSupplier;
        this.setup(tierTopicMaterializationFromSnapshotEnable, Predef$.MODULE$.int2Integer(10), this.setup$default$3());
        this.tierTasks().start();
        int leaderEpoch = 1;
        this.waitForImmigration(this.logs(), leaderEpoch, this.tierTasks(), this.consumerSupplier(), true);
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        this.logs().foreach((Function1 & Serializable)log -> {
            this.writeRecordBatches((AbstractLog)log, leaderEpoch, 0L, 6, 4);
            return BoxedUnit.UNIT;
        });
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier = this.consumerSupplier();
        String string = "Should materialize segments";
        JFunction0.mcZ.sp & Serializable archiveAndMaterializeUntilTrue_pred = (JFunction0.mcZ.sp & Serializable)() -> this.logs().forall((Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverUploadAndMaterializeWhenWriteHappensAfterBecomeLeader$3(log)));
        long l = 100L;
        long archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs = this.maxWaitTimeMs();
        long archiveAndMaterializeUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, (MockConsumerSupplier)archiveAndMaterializeUntilTrue_consumerSupplier, (Function0)archiveAndMaterializeUntilTrue_pred)) {
            void archiveAndMaterializeUntilTrue_waitUntilTrue_pause;
            if (System.currentTimeMillis() > archiveAndMaterializeUntilTrue_waitUntilTrue_startTime + archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs) {
                void archiveAndMaterializeUntilTrue_msg;
                Assertions.fail((String)archiveAndMaterializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs), (long)archiveAndMaterializeUntilTrue_waitUntilTrue_pause));
        }
        Object var3_5 = null;
        string = null;
        mockConsumerSupplier = null;
        this.logs().foreach((Function1 & Serializable)log -> {
            TierIntegrationTest.$anonfun$testArchiverUploadAndMaterializeWhenWriteHappensAfterBecomeLeader$4(log);
            return BoxedUnit.UNIT;
        });
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.tierTopicMaterializationFromSnapshot={0}")
    @ValueSource(booleans={true, false})
    public void testArchiverUploadWithLimitedUploadConcurrency(boolean tierTopicMaterializationFromSnapshotEnable) {
        void archiveAndMaterializeUntilTrue_consumerSupplier;
        int maxConcurrentUploads = 2;
        int nLogs = 3;
        this.setup(tierTopicMaterializationFromSnapshotEnable, Predef$.MODULE$.int2Integer(nLogs), Predef$.MODULE$.int2Integer(maxConcurrentUploads));
        this.tierTasks().start();
        int batches = 3;
        int recordsPerBatch = 4;
        int leaderEpoch = 1;
        this.waitForImmigration(this.logs(), leaderEpoch, this.tierTasks(), this.consumerSupplier(), true);
        this.logs().foreach((Function1 & Serializable)log -> {
            this.writeRecordBatches((AbstractLog)log, leaderEpoch, 0L, batches, recordsPerBatch);
            return BoxedUnit.UNIT;
        });
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier = this.consumerSupplier();
        String string = "Expected all logs to eventually become tiered";
        JFunction0.mcZ.sp & Serializable archiveAndMaterializeUntilTrue_pred = (JFunction0.mcZ.sp & Serializable)() -> this.logs().forall((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverUploadWithLimitedUploadConcurrency$3(x$13))) && this.logs().forall((Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverUploadWithLimitedUploadConcurrency$4(log)));
        long l = 100L;
        long archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs = this.maxWaitTimeMs();
        long archiveAndMaterializeUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, (MockConsumerSupplier)archiveAndMaterializeUntilTrue_consumerSupplier, (Function0)archiveAndMaterializeUntilTrue_pred)) {
            void archiveAndMaterializeUntilTrue_waitUntilTrue_pause;
            if (System.currentTimeMillis() > archiveAndMaterializeUntilTrue_waitUntilTrue_startTime + archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs) {
                void archiveAndMaterializeUntilTrue_msg;
                Assertions.fail((String)archiveAndMaterializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs), (long)archiveAndMaterializeUntilTrue_waitUntilTrue_pause));
        }
    }

    @ParameterizedTest(name="{displayName}.tierTopicMaterializationFromSnapshot={0}")
    @ValueSource(booleans={true, false})
    public void testArchiverLagMetrics(boolean tierTopicMaterializationFromSnapshotEnable) {
        int numLogs = 5;
        int batches = 6;
        int recordsPerBatch = 4;
        int leaderEpoch = 1;
        this.setup(tierTopicMaterializationFromSnapshotEnable, Predef$.MODULE$.int2Integer(numLogs), this.setup$default$3());
        this.tierTasks().start();
        Assertions.assertEquals((long)0L, (long)this.totalLag$1());
        Assertions.assertEquals((long)0L, (long)this.maxTimeLag$1());
        this.logs().foreach((Function1 & Serializable)log -> {
            TierIntegrationTest.$anonfun$testArchiverLagMetrics$5(this, leaderEpoch, log);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)0L, (long)this.totalLag$1());
        Assertions.assertEquals((long)0L, (long)this.maxTimeLag$1());
        this.logs().foreach((Function1 & Serializable)log -> {
            this.writeRecordBatches((AbstractLog)log, leaderEpoch, 0L, batches, recordsPerBatch);
            return BoxedUnit.UNIT;
        });
        this.mockTime().sleep((long)(TierTasks$.MODULE$.PERIODIC_LOG_LAG_MS() + 1));
        this.tierTasks().maybeLogTierArchiverLagInfo();
        Assertions.assertTrue((this.maxTimeLag$1() > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((long)BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.logs().map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToInteger((int)TierIntegrationTest.$anonfun$testArchiverLagMetrics$7(x$16)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)), (long)this.totalLag$1());
        this.waitForImmigration(this.logs(), leaderEpoch, this.tierTasks(), this.consumerSupplier(), false);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), batches).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)archivedBatches -> this.awaitMaterializeBatchAndAssertLag$1(archivedBatches));
        Assertions.assertEquals((long)0L, (long)this.maxTimeLag$1());
    }

    private TierTopicManagerConfig createTierTopicManagerConfig(boolean tierTopicMaterializationFromSnapshotEnable) {
        return new TierTopicManagerConfig(() -> Collections.singletonMap("bootstrap.servers", "bootstrap"), null, (short)1, (short)1, 33, "cluster99", Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.int2Integer(500), Predef$.MODULE$.int2Integer(500), Predef$.MODULE$.long2Long(-1L), this.logDirs(), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicProducerEnableIdempotence()), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicDataLossDetectionEnable()), Defaults$.MODULE$.TierTopicDataLossDetectionMaxTimeoutMs(), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicFencingDuringDataLossEnable()), Predef$.MODULE$.boolean2Boolean(tierTopicMaterializationFromSnapshotEnable));
    }

    /*
     * WARNING - void declaration
     */
    private void waitForImmigration(Seq<MergedLog> logs, int leaderEpoch, TierTasks tierTasks, MockConsumerSupplier<byte[], byte[]> consumerSupplier, boolean becomeLeader) {
        if (becomeLeader) {
            logs.foreach((Function1 & Serializable)log -> {
                TierIntegrationTest.$anonfun$waitForImmigration$1(this, leaderEpoch, log);
                return BoxedUnit.UNIT;
            });
        }
        String string = "Expect leadership to materialize";
        JFunction0.mcZ.sp & Serializable archiveAndMaterializeUntilTrue_pred = (JFunction0.mcZ.sp & Serializable)() -> logs.forall((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$waitForImmigration$3(x$18)));
        long l = 100L;
        long archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs = this.maxWaitTimeMs();
        long archiveAndMaterializeUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, consumerSupplier, (Function0)archiveAndMaterializeUntilTrue_pred)) {
            void archiveAndMaterializeUntilTrue_waitUntilTrue_pause;
            if (System.currentTimeMillis() > archiveAndMaterializeUntilTrue_waitUntilTrue_startTime + archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs) {
                void archiveAndMaterializeUntilTrue_msg;
                Assertions.fail((String)archiveAndMaterializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs), (long)archiveAndMaterializeUntilTrue_waitUntilTrue_pause));
        }
        Object var6_7 = null;
        string = null;
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$waitForImmigration$4(this, consumerSupplier, tierTasks, logs)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierIntegrationTest.$anonfun$waitForImmigration$7(tierTasks));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private boolean waitForImmigration$default$5() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void archiveAndMaterializeUntilTrue(Function0<Object> pred, String msg, MockConsumerSupplier<byte[], byte[]> consumerSupplier) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = this.maxWaitTimeMs();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, consumerSupplier, pred)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void validatePartitionStateContainedInObjectStore(MockInMemoryTierObjectStore tierObjectStore, Iterable<AbstractLog> logs) {
        logs.foreach((Function1 & Serializable)log -> {
            TierIntegrationTest.$anonfun$validatePartitionStateContainedInObjectStore$1(tierObjectStore, log);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private void setupTierComponents() {
        MockProducerSupplier producerSupplier = new MockProducerSupplier();
        this.consumerSupplier_$eq(new MockConsumerSupplier<byte[], byte[]>("primary", TierTopicManager.partitions((String)TierTopic.topicName((String)this.tierTopicManagerConfig().tierNamespace), (int)this.tierTopicManagerConfig().configuredNumPartitions), producerSupplier.producer()));
        this.tierTopicConsumer_$eq(new TierTopicConsumer(this.tierTopicManagerConfig(), this.consumerSupplier(), this.consumerSupplier(), this.consumerSupplier(), new TierTopicManagerCommitter(this.tierTopicManagerConfig(), (LogDirFailureChannel)Mockito.mock(LogDirFailureChannel.class)), this.tierStateFetcher(), Optional.empty(), (Time)this.mockTime()));
        InternalAdmin internalAdmin = (InternalAdmin)Mockito.mock(InternalAdmin.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)internalAdmin.ensureTopic((String)ArgumentMatchers.any(), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.any()), BoxesRunTime.unboxToShort((Object)ArgumentMatchers.any()), (Properties)ArgumentMatchers.any()))).thenAnswer((Answer)new Answer<Object>(null){

            public int answer(InvocationOnMock invocation) {
                return BoxesRunTime.unboxToInt((Object)invocation.getArgument(1));
            }
        });
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)logManager.allLogs()).thenReturn((Object)package$.MODULE$.Seq().empty());
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        TierTopic tierTopic = new TierTopic(this.tierTopicManagerConfig().tierNamespace);
        TierObjectStore tierObjectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
        TierTopicDataLossValidator tierTopicDataLossValidator = new TierTopicDataLossValidator(this.tierTopicManagerConfig(), tierTopic, tierObjectStore, replicaManager, (Supplier)new Supplier<ConfluentAdmin>(null){

            public ConfluentAdmin get() {
                return (ConfluentAdmin)Mockito.mock(ConfluentAdmin.class);
            }
        }, (LeaderEndpointSupplier)Mockito.mock(LeaderEndpointSupplier.class), (Time)this.mockTime(), (Metrics)Mockito.mock(Metrics.class));
        this.tierTopicManager_$eq(new TierTopicManager(this.tierTopicManagerConfig(), tierTopic, this.tierTopicConsumer(), producerSupplier, () -> internalAdmin, tierTopicDataLossValidator));
        this.tierLogComponents_$eq(new TierLogComponents((Option)new Some((Object)this.tierTopicConsumer()), (Option)new Some((Object)tierObjectStore), new TierPartitionStateFactory(true, this.checksumEnabled(), true, this.cleanupConfig(), true, 0), (Option)None$.MODULE$));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$setupTierComponents$2(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for TierTopicManager to be ready");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private IndexedSeq<MergedLog> createLogs(int n, LogConfig logConfig, File tempDir, TierLogComponents tierLogComponents, LogDirFailureChannel logDirFailureChannel) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), n).map((Function1 & Serializable)i -> TierIntegrationTest.$anonfun$createLogs$1(this, tempDir, logConfig, logDirFailureChannel, tierLogComponents, BoxesRunTime.unboxToInt((Object)i)));
    }

    private ReplicaManager mockReplicaManager(Iterable<AbstractLog> logs) {
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog((TopicPartition)ArgumentMatchers.any(TopicPartition.class))).thenAnswer((Answer)new Answer<Option<AbstractLog>>(null, logs){
            private final Iterable logs$2;

            public Option<AbstractLog> answer(InvocationOnMock invocation) {
                TopicPartition target = (TopicPartition)invocation.getArgument(0);
                return this.logs$2.find((Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)$anon$3.$anonfun$answer$1(target, log)));
            }

            public static final /* synthetic */ boolean $anonfun$answer$1(TopicPartition target$1, AbstractLog log) {
                TopicPartition topicPartition = log.topicPartition();
                return !(topicPartition != null ? !topicPartition.equals(target$1) : target$1 != null);
            }
            {
                this.logs$2 = logs$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$answer$1$adapted(org.apache.kafka.common.TopicPartition kafka.log.AbstractLog )}, serializedLambda);
            }
        });
        Iterable partitions = (Iterable)logs.map((Function1 & Serializable)log -> {
            Partition partition = (Partition)Mockito.mock(Partition.class);
            Mockito.when((Object)partition.log()).thenReturn((Object)new Some(log));
            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
            Mockito.when((Object)partition.metadataOffsetAndEpoch()).thenReturn((Object)None$.MODULE$);
            Mockito.when((Object)replicaManager.getPartitionOrError(log.topicPartition())).thenReturn((Object)package$.MODULE$.Right().apply((Object)partition));
            return partition;
        });
        Mockito.when((Object)replicaManager.leaderPartitionsIterator()).thenAnswer(x$20 -> partitions.iterator());
        return replicaManager;
    }

    private void writeRecordBatches(AbstractLog log, int leaderEpoch, long baseOffset, int batches, int recordsPerBatch) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), batches).foreach((Function1 & Serializable)idx -> TierIntegrationTest.$anonfun$writeRecordBatches$1(this, log, leaderEpoch, baseOffset, recordsPerBatch, BoxesRunTime.unboxToInt((Object)idx)));
        log.flush(false);
        log.updateHighWatermark((long)(batches * recordsPerBatch));
    }

    private MemoryRecords createRecords(TopicPartition topicPartition, int leaderEpoch, long baseOffset, int numRecords) {
        IndexedSeq recList = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable)x$21 -> TierIntegrationTest.$anonfun$createRecords$1(BoxesRunTime.unboxToInt((Object)x$21)));
        byte x$3 = 2;
        CompressionType x$4 = CompressionType.NONE;
        long x$5 = -1L;
        short x$6 = -1;
        int x$7 = -1;
        int x$8 = -1;
        MemoryRecords records = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)recList, x$3, x$4, x$5, x$6, x$7, baseOffset, x$8);
        ByteBuffer filtered = ByteBuffer.allocate(100 * numRecords);
        CollectionConverters$.MODULE$.IterableHasAsScala(records.batches()).asScala().foreach((Function1 & Serializable)x$22 -> {
            x$22.setPartitionLeaderEpoch(leaderEpoch);
            return BoxedUnit.UNIT;
        });
        records.filterTo(topicPartition, new MemoryRecords.RecordFilter(null){

            public MemoryRecords.RecordFilter.BatchRetentionResult checkBatchRetention(RecordBatch batch) {
                return new MemoryRecords.RecordFilter.BatchRetentionResult(MemoryRecords.RecordFilter.BatchRetention.DELETE_EMPTY, false);
            }

            public boolean shouldRetainRecord(RecordBatch recordBatch, Record record) {
                return true;
            }
        }, filtered, Integer.MAX_VALUE, BufferSupplier.NO_CACHING);
        filtered.flip();
        return new MemoryRecords(filtered);
    }

    private long metricValue(String metricType, String name) {
        return BoxesRunTime.unboxToLong((Object)((Gauge)((MapOps)CollectionConverters$.MODULE$.MapHasAsScala(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$metricValue$1(metricType, name, x0$1)))).values().head()).value());
    }

    private TierPartitionState tierPartitionState(TopicPartition partition) {
        return (TierPartitionState)this.logs().find((Function1 & Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$tierPartitionState$1(partition, x$23))).map((Function1 & Serializable)x$24 -> x$24.tierPartitionState()).get();
    }

    public static final /* synthetic */ void $anonfun$teardown$2(String path) {
        Utils.delete((File)new File(path), (boolean)false);
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverImmigrate$2(Set x$12) {
        return x$12.size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverImmigrate$1(TierIntegrationTest $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.tierTasks().archiverTaskQueue().withAllTasks((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverImmigrate$2(x$12))));
    }

    public static final /* synthetic */ String $anonfun$testArchiverImmigrate$3() {
        return "Archiver should process pending emigrations";
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverImmigrate$6(ArchiveTask task) {
        return task.state() instanceof BeforeUpload || task.state() instanceof AfterUpload;
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverImmigrate$4(TierIntegrationTest $this) {
        $this.consumerSupplier().moveRecordsFromProducer();
        $this.tierTopicConsumer().doWork();
        return BoxesRunTime.unboxToBoolean((Object)$this.tierTasks().archiverTaskQueue().withAllTasks((Function1 & Serializable)tasks -> BoxesRunTime.boxToBoolean((boolean)tasks.forall((Function1 & Serializable)task -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverImmigrate$6(task))))));
    }

    public static final /* synthetic */ String $anonfun$testArchiverImmigrate$7() {
        return "Archiver should process pending immigrations";
    }

    public static final /* synthetic */ boolean $anonfun$testLogSizeDetail$3(MergedLog log) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        tierPartitionState.flush();
        return tierPartitionState.numSegments() >= 1;
    }

    public static final /* synthetic */ void $anonfun$testLogSizeDetail$4(long localSize$1, long tieredSize$1, long untieredSize$1, long totalSize$1, MergedLog log) {
        Assertions.assertEquals((long)localSize$1, (long)log.sizeDetails().localSize());
        Assertions.assertEquals((long)tieredSize$1, (long)log.sizeDetails().tieredSize());
        Assertions.assertEquals((long)untieredSize$1, (long)log.sizeDetails().untieredSize());
        Assertions.assertEquals((long)totalSize$1, (long)log.sizeDetails().totalSize());
    }

    public static final /* synthetic */ void $anonfun$testArchiverUploadAndMaterialize$2(int leaderEpoch$1, MergedLog log) {
        Assertions.assertEquals((int)log.tierPartitionState().tierEpoch(), (int)leaderEpoch$1, (String)new StringBuilder(43).append("topic manager should materialize entry for ").append(log.topicPartition()).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverUploadAndMaterialize$4(MergedLog log) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        tierPartitionState.flush();
        return tierPartitionState.numSegments() >= 1;
    }

    public static final /* synthetic */ void $anonfun$testArchiverUploadAndMaterialize$5(MergedLog log) {
        Assertions.assertEquals((long)0L, (long)((TierLogSegment)log.tierPartitionState().metadata(0L).get()).baseOffset(), (String)"batch 1: segment should be materialized with correct offset relationship");
        Assertions.assertTrue((log.tierPartitionState().committedEndOffset() >= 3L ? 1 : 0) != 0, (String)"batch 1: segment should be materialized with correct end offset");
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverUploadAndMaterialize$7(MergedLog log) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        tierPartitionState.flush();
        return tierPartitionState.numSegments() >= 2 && tierPartitionState.committedEndOffset() == tierPartitionState.endOffset();
    }

    public static final /* synthetic */ void $anonfun$testArchiverUploadAndMaterialize$8(MergedLog log) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        Assertions.assertEquals((long)4L, (long)((TierLogSegment)tierPartitionState.metadata(6L).get()).baseOffset(), (String)"batch 2: segment should be materialized with correct offset relationship");
        Assertions.assertTrue((tierPartitionState.committedEndOffset() >= 7L ? 1 : 0) != 0, (String)"batch 2: segment should be materialized with correct end offset");
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverUploadAndMaterialize$10(MergedLog log) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        tierPartitionState.flush();
        return tierPartitionState.numSegments() >= 3 && tierPartitionState.committedEndOffset() == tierPartitionState.endOffset();
    }

    public static final /* synthetic */ void $anonfun$testArchiverUploadAndMaterialize$11(MergedLog log) {
        Assertions.assertEquals((long)8L, (long)((TierLogSegment)log.tierPartitionState().metadata(10L).get()).baseOffset(), (String)"batch 3: segment should be materialized with correct offset relationship");
        Assertions.assertTrue((log.tierPartitionState().committedEndOffset() >= 11L ? 1 : 0) != 0, (String)"batch 3: segment should be materialized with correct end offset");
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverUploadAndMaterializeWhenWriteHappensAfterBecomeLeader$3(MergedLog log) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        tierPartitionState.flush();
        return tierPartitionState.numSegments() > 0 && tierPartitionState.committedEndOffset() == tierPartitionState.endOffset();
    }

    public static final /* synthetic */ void $anonfun$testArchiverUploadAndMaterializeWhenWriteHappensAfterBecomeLeader$4(MergedLog log) {
        Assertions.assertEquals((long)0L, (long)((TierLogSegment)log.tierPartitionState().metadata(0L).get()).baseOffset(), (String)"Segment should be materialized with correct offset relationship");
        Assertions.assertTrue((log.tierPartitionState().committedEndOffset() >= 3L ? 1 : 0) != 0, (String)"Segment should be materialized with correct end offset");
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverUploadWithLimitedUploadConcurrency$3(MergedLog x$13) {
        return x$13.tierableLogSegments().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverUploadWithLimitedUploadConcurrency$4(MergedLog log) {
        return log.tieredLogSegments().nonEmpty();
    }

    private final long totalLag$1() {
        return this.metricValue("TierArchiver", "TotalLag");
    }

    private final long maxTimeLag$1() {
        return this.metricValue("TierArchiver", "PartitionTimeLagMaxValue");
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverLagMetrics$2(int archivedBatches$1, MergedLog log) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        tierPartitionState.flush();
        return tierPartitionState.numSegments() >= archivedBatches$1 && tierPartitionState.committedEndOffset() == tierPartitionState.endOffset();
    }

    public static final /* synthetic */ int $anonfun$testArchiverLagMetrics$3(MergedLog x$14) {
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)x$14.tierableLogSegments().map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    private final void awaitMaterializeBatchAndAssertLag$1(int archivedBatches) {
        void archiveAndMaterializeUntilTrue_consumerSupplier;
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier = this.consumerSupplier();
        String archiveAndMaterializeUntilTrue_msg = new StringBuilder(49).append("Should materialize segments for batch ").append(archivedBatches).append(" or greater").toString();
        JFunction0.mcZ.sp & Serializable archiveAndMaterializeUntilTrue_pred = (JFunction0.mcZ.sp & Serializable)() -> this.logs().forall((Function1 & Serializable)log -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverLagMetrics$2(archivedBatches, log)));
        long l = 100L;
        long archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs = this.maxWaitTimeMs();
        long archiveAndMaterializeUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, (MockConsumerSupplier)archiveAndMaterializeUntilTrue_consumerSupplier, (Function0)archiveAndMaterializeUntilTrue_pred)) {
            void archiveAndMaterializeUntilTrue_waitUntilTrue_pause;
            if (System.currentTimeMillis() > archiveAndMaterializeUntilTrue_waitUntilTrue_startTime + archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)archiveAndMaterializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs), (long)archiveAndMaterializeUntilTrue_waitUntilTrue_pause));
        }
        Object var2_4 = null;
        Object var3_3 = null;
        mockConsumerSupplier = null;
        this.mockTime().sleep((long)(TierTasks$.MODULE$.PERIODIC_LOG_LAG_MS() + 1));
        this.tierTasks().maybeLogTierArchiverLagInfo();
        Assertions.assertEquals((long)BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.logs().map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToInteger((int)TierIntegrationTest.$anonfun$testArchiverLagMetrics$3(x$14)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)), (long)this.totalLag$1());
        if (this.totalLag$1() > 0L) {
            Assertions.assertTrue((this.maxTimeLag$1() > 0L ? 1 : 0) != 0);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testArchiverLagMetrics$5(TierIntegrationTest $this, int leaderEpoch$4, MergedLog log) {
        log.assignTopicId(Uuid.randomUuid(), log.assignTopicId$default$2());
        $this.tierReplicaManager().becomeLeader(log.tierPartitionState(), leaderEpoch$4);
    }

    public static final /* synthetic */ int $anonfun$testArchiverLagMetrics$7(MergedLog x$16) {
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)x$16.tierableLogSegments().map((Function1 & Serializable)x$17 -> BoxesRunTime.boxToInteger((int)x$17.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$waitForImmigration$1(TierIntegrationTest $this, int leaderEpoch$5, MergedLog log) {
        log.assignTopicId(Uuid.randomUuid(), log.assignTopicId$default$2());
        $this.tierReplicaManager().becomeLeader(log.tierPartitionState(), leaderEpoch$5);
    }

    public static final /* synthetic */ boolean $anonfun$waitForImmigration$3(MergedLog x$18) {
        TierPartitionStatus tierPartitionStatus = x$18.tierPartitionState().status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$waitForImmigration$6(ArchiveTask x$19) {
        return x$19.state() instanceof BeforeLeader;
    }

    public static final /* synthetic */ boolean $anonfun$waitForImmigration$5(Seq logs$1, Set tasks) {
        return tasks.size() == logs$1.size() && !tasks.forall((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$waitForImmigration$6(x$19)));
    }

    public static final /* synthetic */ boolean $anonfun$waitForImmigration$4(TierIntegrationTest $this, MockConsumerSupplier consumerSupplier$1, TierTasks tierTasks$1, Seq logs$1) {
        consumerSupplier$1.moveRecordsFromProducer();
        $this.tierTopicConsumer().doWork();
        return BoxesRunTime.unboxToBoolean((Object)tierTasks$1.archiverTaskQueue().withAllTasks((Function1 & Serializable)tasks -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$waitForImmigration$5(logs$1, tasks))));
    }

    public static final /* synthetic */ String $anonfun$waitForImmigration$7(TierTasks tierTasks$1) {
        return new StringBuilder(28).append("Expect zero BeforeLeader in ").append(tierTasks$1.archiverTaskQueue()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$archiveAndMaterializeUntilTrue$1(TierIntegrationTest $this, MockConsumerSupplier consumerSupplier$2, Function0 pred$1) {
        consumerSupplier$2.moveRecordsFromProducer();
        $this.tierTopicConsumer().doWork();
        return pred$1.apply$mcZ$sp();
    }

    public static final /* synthetic */ String $anonfun$archiveAndMaterializeUntilTrue$2(String msg$1) {
        return msg$1;
    }

    public static final /* synthetic */ void $anonfun$validatePartitionStateContainedInObjectStore$2(MockInMemoryTierObjectStore tierObjectStore$1, TierLogSegment tierSegment) {
        Assertions.assertNotNull((Object)tierObjectStore$1.getObjectStoreFragment((ObjectStoreMetadata)tierSegment.metadata(), FragmentType.SEGMENT, Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.long2Long(1000L)));
    }

    public static final /* synthetic */ void $anonfun$validatePartitionStateContainedInObjectStore$1(MockInMemoryTierObjectStore tierObjectStore$1, AbstractLog log) {
        CollectionConverters$.MODULE$.IteratorHasAsScala(log.tierPartitionState().segments()).asScala().foreach((Function1 & Serializable)tierSegment -> {
            TierIntegrationTest.$anonfun$validatePartitionStateContainedInObjectStore$2(tierObjectStore$1, tierSegment);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$setupTierComponents$2(TierIntegrationTest $this) {
        $this.tierTopicManager().tryBecomeReady(false);
        return $this.tierTopicManager().isReadyForWrites();
    }

    public static final /* synthetic */ String $anonfun$setupTierComponents$3() {
        return "Timed out waiting for TierTopicManager to be ready";
    }

    public static final /* synthetic */ MergedLog $anonfun$createLogs$1(TierIntegrationTest $this, File tempDir$1, LogConfig logConfig$1, LogDirFailureChannel logDirFailureChannel$1, TierLogComponents tierLogComponents$1, int i) {
        File logDir = tempDir$1.toPath().resolve(new StringBuilder(12).append("tierlogtest-").append(i).toString()).toFile();
        logDir.mkdir();
        MockScheduler x$5 = $this.mockTime().scheduler;
        BrokerTopicStats x$6 = new BrokerTopicStats();
        Metrics x$7 = new Metrics();
        MockTime x$8 = $this.mockTime();
        ProducerStateManagerConfig x$10 = new ProducerStateManagerConfig(3600000, false);
        None$ x$12 = None$.MODULE$;
        None$ x$17 = None$.MODULE$;
        None$ x$18 = None$.MODULE$;
        ChecksumParams x$19 = TestUtils$.MODULE$.createChecksumParams();
        LogOffsetsListener x$20 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        ConcurrentHashMap x$21 = new ConcurrentHashMap();
        return MergedLog$.MODULE$.apply(logDir, logConfig$1, 0L, 0L, (Scheduler)x$5, x$6, x$7, (Time)x$8, 300000, x$10, 600000, (Option)x$12, logDirFailureChannel$1, tierLogComponents$1, true, (Option)x$17, true, x$20, (Option)x$18, x$21, x$19);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$writeRecordBatches$1(TierIntegrationTest $this, AbstractLog log$1, int leaderEpoch$6, long baseOffset$1, int recordsPerBatch$3, int idx) {
        MemoryRecords records = $this.createRecords(log$1.topicPartition(), leaderEpoch$6, baseOffset$1 + (long)(idx * recordsPerBatch$3), recordsPerBatch$3);
        return log$1.appendAsFollower(records);
    }

    public static final /* synthetic */ SimpleRecord $anonfun$createRecords$1(int x$21) {
        return new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes());
    }

    public static final /* synthetic */ boolean $anonfun$metricValue$1(String metricType$1, String name$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetricName metricName = (MetricName)x0$1._1();
            String string = metricName.getType();
            if (!(string != null ? !string.equals(metricType$1) : metricType$1 != null)) {
                String string2 = metricName.getName();
                if (!(string2 != null ? !string2.equals(name$1) : name$1 != null)) {
                    return true;
                }
            }
            return false;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$tierPartitionState$1(TopicPartition partition$1, MergedLog x$23) {
        TopicPartition topicPartition = x$23.topicPartition();
        return !(topicPartition != null ? !topicPartition.equals(partition$1) : partition$1 != null);
    }

    public TierIntegrationTest() {
        this.maxWaitTimeMs = 20000;
    }
}

