/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.api.IntegrationTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.tier.fetcher.MemoryTracker;
import kafka.tier.fetcher.TierFetcher;
import kafka.tier.state.TierPartitionState;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005]d\u0001B\u000b\u0017\u0001mAQA\t\u0001\u0005\u0002\rBQA\n\u0001\u0005R\u001dBQA\f\u0001\u0005\n=Bq\u0001\u000f\u0001C\u0002\u0013%\u0011\b\u0003\u0004>\u0001\u0001\u0006IA\u000f\u0005\b}\u0001\u0011\r\u0011\"\u0003(\u0011\u0019y\u0004\u0001)A\u0005Q!9\u0001\t\u0001a\u0001\n\u0013\t\u0005bB'\u0001\u0001\u0004%IA\u0014\u0005\u0007)\u0002\u0001\u000b\u0015\u0002\"\t\u000bU\u0003A\u0011\u0002,\t\u000f-\u0004!\u0019!C\u0001Y\"1q\u000f\u0001Q\u0001\n5DQ\u0001\u001f\u0001\u0005BeDq!a\u0005\u0001\t\u0003\n)\u0002C\u0004\u0002 \u0001!I!!\t\t\u000f\u0005-\u0002\u0001\"\u0003\u0002.!9\u00111\u0007\u0001\u0005\n\u0005U\u0002bBA\u001e\u0001\u0011%\u0011Q\u0003\u0005\b\u0003{\u0001A\u0011AA \u0005y!\u0016.\u001a:J]R,wM]1uS>tGK]1og\u0006\u001cG/[8o)\u0016\u001cHO\u0003\u0002\u00181\u0005!A/[3s\u0015\u0005I\u0012!B6bM.\f7\u0001A\n\u0003\u0001q\u0001\"!\b\u0011\u000e\u0003yQ!a\b\r\u0002\u0007\u0005\u0004\u0018.\u0003\u0002\"=\t1\u0012J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002IA\u0011Q\u0005A\u0007\u0002-\u0005Y!M]8lKJ\u001cu.\u001e8u+\u0005A\u0003CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#aA%oi\u0006i1m\u001c8gS\u001e,(/Z'pG.,\u0012\u0001\r\t\u0003cYj\u0011A\r\u0006\u0003gQ\nA\u0001\\1oO*\tQ'\u0001\u0003kCZ\f\u0017BA\u001c3\u0005\u0019y%M[3di\u0006)Ao\u001c9jGV\t!\b\u0005\u00022w%\u0011AH\r\u0002\u0007'R\u0014\u0018N\\4\u0002\rQ|\u0007/[2!\u0003)\u0001\u0018M\u001d;ji&|gn]\u0001\fa\u0006\u0014H/\u001b;j_:\u001c\b%A\tqCJ$\u0018\u000e^5p]R{G*Z1eKJ,\u0012A\u0011\t\u0005\u0007*C\u0003F\u0004\u0002E\u0011B\u0011QIK\u0007\u0002\r*\u0011qIG\u0001\u0007yI|w\u000e\u001e \n\u0005%S\u0013A\u0002)sK\u0012,g-\u0003\u0002L\u0019\n\u0019Q*\u00199\u000b\u0005%S\u0013!\u00069beRLG/[8o)>dU-\u00193fe~#S-\u001d\u000b\u0003\u001fJ\u0003\"!\u000b)\n\u0005ES#\u0001B+oSRDqaU\u0005\u0002\u0002\u0003\u0007!)A\u0002yIE\n!\u0003]1si&$\u0018n\u001c8U_2+\u0017\rZ3sA\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t7/F\u0001X!\rAV\f\u0019\b\u00033ns!!\u0012.\n\u0003-J!\u0001\u0018\u0016\u0002\u000fA\f7m[1hK&\u0011al\u0018\u0002\u0004'\u0016\f(B\u0001/+!\t\t\u0017.D\u0001c\u0015\t\u0019G-\u0001\u0004d_6lwN\u001c\u0006\u00033\u0015T!AZ4\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0017aA8sO&\u0011!N\u0019\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003\u0019)\u00070\u001b;fIV\tQ\u000e\u0005\u0002ok6\tqN\u0003\u0002qc\u00061\u0011\r^8nS\u000eT!A]:\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002ui\u0005!Q\u000f^5m\u0013\t1xNA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\bKbLG/\u001a3!\u0003\u0015\u0019X\r^+q)\ty%\u0010C\u0003|\u001d\u0001\u0007A0\u0001\u0005uKN$\u0018J\u001c4p!\ri\u0018qA\u0007\u0002}*\u0011qd \u0006\u0005\u0003\u0003\t\u0019!A\u0004kkBLG/\u001a:\u000b\u0007\u0005\u0015q-A\u0003kk:LG/C\u0002\u0002\ny\u0014\u0001\u0002V3ti&sgm\u001c\u0015\u0004\u001d\u00055\u0001cA?\u0002\u0010%\u0019\u0011\u0011\u0003@\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<o)\u0005y\u0005fA\b\u0002\u001aA\u0019Q0a\u0007\n\u0007\u0005uaPA\u0005BMR,'/R1dQ\u0006q\u0001O]8ek\u000e,'+Z2pe\u0012\u001cH#B(\u0002$\u0005\u001d\u0002BBA\u0013!\u0001\u0007\u0001&\u0001\u0005o\u0005\u0006$8\r[3t\u0011\u0019\tI\u0003\u0005a\u0001Q\u0005y!/Z2pe\u0012\u001c\b+\u001a:CCR\u001c\u0007.\u0001\u000ehKRdU-\u00193fe\u001a{'\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eF\u0002)\u0003_Aa!!\r\u0012\u0001\u0004\u0001\u0017\u0001\u00067fC\u0012,'\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|g.A\fxC&$XK\u001c;jYN+w-\\3oiN$\u0016.\u001a:fIR\u0019q*a\u000e\t\r\u0005e\"\u00031\u0001)\u00039i\u0017N\u001c(v[N+w-\\3oiN\f\u0011c]5nk2\fG/\u001a*fi\u0016tG/[8o\u0003\u001d\"Xm\u001d;Be\u000eD\u0017N^3B]\u00124U\r^2i'&tw\r\\3U_BL7\rU1si&$\u0018n\u001c8\u0015\u0007=\u000b\t\u0005C\u0004\u0002DQ\u0001\r!!\u0012\u0002\rE,xN];n!\r\u0019\u0015qI\u0005\u0003y1Cs\u0001FA&\u0003/\nI\u0006\u0005\u0003\u0002N\u0005MSBAA(\u0015\r\t\tf`\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\u0005U\u0013q\n\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\u00028b[\u0016\f#!a\u0017\u0002Em$\u0017n\u001d9mCft\u0015-\\3~]m\f'oZ;nK:$8oV5uQ:\u000bW.Z:~Q\u001d!\u0012qLA6\u0003[\u0002B!!\u0019\u0002h5\u0011\u00111\r\u0006\u0005\u0003K\ny%\u0001\u0005qe>4\u0018\u000eZ3s\u0013\u0011\tI'a\u0019\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\u0011\ty'a\u001d\"\u0005\u0005E\u0014A\u0001>lC\t\t)(A\u0003le\u00064G\u000f")
public class TierIntegrationTransactionTest
extends IntegrationTestHarness {
    private final String topic;
    private final int partitions;
    private Map<Object, Object> partitionToLeader;
    private final AtomicBoolean exited;

    @Override
    public int brokerCount() {
        return 1;
    }

    private Object configureMock() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        return this.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), "mybucket");
    }

    private String topic() {
        return this.topic;
    }

    private int partitions() {
        return this.partitions;
    }

    private Map<Object, Object> partitionToLeader() {
        return this.partitionToLeader;
    }

    private void partitionToLeader_$eq(Map<Object, Object> x$1) {
        this.partitionToLeader = x$1;
    }

    private Seq<TopicPartition> topicPartitions() {
        return package$.MODULE$.Range().apply(0, this.partitions()).map((Function1 & Serializable)p -> TierIntegrationTransactionTest.$anonfun$topicPartitions$1(this, BoxesRunTime.unboxToInt((Object)p)));
    }

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        Exit.setExitProcedure((x$1, x$2) -> this.exited().set(true));
        super.setUp(testInfo);
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("confluent.tier.local.hotset.bytes", "5000");
        props.put("retention.bytes", "-1");
        props.put("retention.ms", "-1");
        this.partitionToLeader_$eq(this.createTopic(this.topic(), this.partitions(), 1, props, this.createTopic$default$5(), this.createTopic$default$6()));
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        Assertions.assertFalse((boolean)this.exited().get());
    }

    private void produceRecords(int nBatches, int recordsPerBatch) {
        Properties props = new Properties();
        props.put("transactional.id", "1");
        ByteArraySerializer x$2 = this.createProducer$default$1();
        ByteArraySerializer x$3 = this.createProducer$default$2();
        producer.initTransactions();
        try (KafkaProducer producer = this.createProducer(x$2, x$3, props);){
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), nBatches).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)b -> {
                boolean abortBatch = b % 2 == 0;
                String key = abortBatch ? "aborted" : "committed";
                IndexedSeq producerRecords = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), recordsPerBatch).map((Function1 & Serializable)i -> TierIntegrationTransactionTest.$anonfun$produceRecords$2(this, recordsPerBatch, b, key, BoxesRunTime.unboxToInt((Object)i)));
                producer.beginTransaction();
                producerRecords.foreach((Function1 & Serializable)record -> (RecordMetadata)producer.send(record).get(10L, TimeUnit.SECONDS));
                if (abortBatch) {
                    producer.abortTransaction();
                    return;
                }
                producer.commitTransaction();
            });
        }
    }

    private int getLeaderForTopicPartition(TopicPartition leaderTopicPartition) {
        return BoxesRunTime.unboxToInt((Object)this.partitionToLeader().apply((Object)BoxesRunTime.boxToInteger((int)leaderTopicPartition.partition())));
    }

    /*
     * WARNING - void declaration
     */
    private void waitUntilSegmentsTiered(int minNumSegments) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTransactionTest.$anonfun$waitUntilSegmentsTiered$1(this, minNumSegments)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierIntegrationTransactionTest.$anonfun$waitUntilSegmentsTiered$3(minNumSegments));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void simulateRetention() {
        this.topicPartitions().foreach((Function1 & Serializable)tp -> {
            TierIntegrationTransactionTest.$anonfun$simulateRetention$1(this, tp);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testArchiveAndFetchSingleTopicPartition(String quorum) {
        void var20_19;
        SeqOps seqOps;
        block12: {
            List list;
            block11: {
                void var16_16;
                SeqOps seqOps2;
                MBeanServer mBeanServer;
                block10: {
                    List list2;
                    block9: {
                        String[] attrs;
                        String bean;
                        int nBatches = 100;
                        int recordsPerBatch = 100;
                        this.produceRecords(nBatches, recordsPerBatch);
                        this.waitUntilSegmentsTiered(10);
                        this.simulateRetention();
                        TopicPartition topicPartition = (TopicPartition)this.topicPartitions().head();
                        String brokerList = TestUtils$.MODULE$.bootstrapServers(this.brokers(), this.listenerName());
                        Properties consumerProps = new Properties();
                        consumerProps.put("bootstrap.servers", brokerList);
                        consumerProps.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
                        consumerProps.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
                        consumerProps.put("max.poll.records", "50000");
                        consumerProps.put("isolation.level", "read_committed");
                        this.consumerConfig().setProperty("group.id", "foo");
                        this.consumerConfig().setProperty("client.id", "foo");
                        try (KafkaConsumer consumer = new KafkaConsumer(consumerProps);){
                            ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>();
                            partitions.add(topicPartition);
                            partitions.add(new TopicPartition(this.topic(), 1));
                            consumer.assign(partitions);
                            consumer.seekToBeginning(partitions);
                            ArrayList valuesRead = new ArrayList();
                            while (valuesRead.size() < nBatches * recordsPerBatch / 2 - recordsPerBatch) {
                                consumer.poll(Duration.ofMillis(1000L)).forEach((Consumer)new Consumer<ConsumerRecord<String, String>>(null, valuesRead){
                                    private final ArrayList valuesRead$1;

                                    public Consumer<ConsumerRecord<String, String>> andThen(Consumer<? super ConsumerRecord<String, String>> x$1) {
                                        return Consumer.super.andThen(x$1);
                                    }

                                    public void accept(ConsumerRecord<String, String> r) {
                                        Assertions.assertNotEquals((Object)r.key(), (Object)"aborted", (String)"did not expect to find any aborted records");
                                        this.valuesRead$1.add(BoxesRunTime.boxToInteger((int)Integer.parseInt((String)r.value())));
                                    }
                                    {
                                        this.valuesRead$1 = valuesRead$1;
                                    }
                                });
                            }
                        }
                        mBeanServer = ManagementFactory.getPlatformMBeanServer();
                        list2 = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(mBeanServer.getAttributes(new ObjectName(bean = "kafka.server:type=TierFetcher"), attrs = new String[]{"BytesFetchedTotal"}).asList()).asScala().map((Function1 & Serializable)attr -> BoxesRunTime.boxToDouble((double)TierIntegrationTransactionTest.$anonfun$testArchiveAndFetchSingleTopicPartition$1(attr)))).toList();
                        if (list2 == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.List().unapplySeq((SeqOps)list2))) break block9;
                        new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2));
                        if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1) == 0) break block10;
                    }
                    throw new MatchError((Object)list2);
                }
                double bytesFetchedTotal = BoxesRunTime.unboxToDouble((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0));
                Assertions.assertTrue((var16_16 > 0.0 ? 1 : 0) != 0, (String)"tier fetch metric shows no data fetched from tiered storage");
                list = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(mBeanServer.getAttributes(new ObjectName("kafka.tier.tasks.archive:type=TierArchiver,name=BytesPerSec"), new String[]{"MeanRate"}).asList()).asScala().map((Function1 & Serializable)attr -> BoxesRunTime.boxToDouble((double)TierIntegrationTransactionTest.$anonfun$testArchiveAndFetchSingleTopicPartition$2(attr)))).toList();
                if (list == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list))) break block11;
                new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps));
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) break block12;
            }
            throw new MatchError((Object)list);
        }
        double meanArchiveRate = BoxesRunTime.unboxToDouble((Object)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0));
        Assertions.assertTrue((var20_19 > 0.0 ? 1 : 0) != 0, (String)"tier archiver mean rate shows no data uploaded to tiered storage");
        this.brokers().foreach((Function1 & Serializable)broker -> {
            TierIntegrationTransactionTest.$anonfun$testArchiveAndFetchSingleTopicPartition$3(broker);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ TopicPartition $anonfun$topicPartitions$1(TierIntegrationTransactionTest $this, int p) {
        return new TopicPartition($this.topic(), p);
    }

    public static final /* synthetic */ ProducerRecord $anonfun$produceRecords$2(TierIntegrationTransactionTest $this, int recordsPerBatch$1, int b$1, String key$1, int i) {
        int m = recordsPerBatch$1 * b$1 + i;
        long timestamp = (long)b$1 + 1L * (long)i;
        return new ProducerRecord($this.topic(), null, Predef$.MODULE$.long2Long(timestamp), (Object)key$1.getBytes(StandardCharsets.UTF_8), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)m)).getBytes(StandardCharsets.UTF_8));
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilSegmentsTiered$2(TierIntegrationTransactionTest $this, int minNumSegments$1, TopicPartition tp) {
        int leaderId = $this.getLeaderForTopicPartition(tp);
        LogManager qual$1 = ((KafkaBroker)$this.brokerForId(leaderId).get()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        TierPartitionState tierPartitionState = ((AbstractLog)qual$1.getLog(tp, x$2).get()).tierPartitionState();
        long endOffset = tierPartitionState.endOffset();
        long committedEndOffset = tierPartitionState.committedEndOffset();
        return endOffset > 0L && committedEndOffset > 0L && endOffset == committedEndOffset && tierPartitionState.numSegments() > minNumSegments$1;
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilSegmentsTiered$1(TierIntegrationTransactionTest $this, int minNumSegments$1) {
        return $this.topicPartitions().forall((Function1 & Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTransactionTest.$anonfun$waitUntilSegmentsTiered$2($this, minNumSegments$1, tp)));
    }

    public static final /* synthetic */ String $anonfun$waitUntilSegmentsTiered$3(int minNumSegments$1) {
        return new StringBuilder(61).append("timeout waiting for at least ").append(minNumSegments$1).append(" to be archived and materialized").toString();
    }

    public static final /* synthetic */ void $anonfun$simulateRetention$1(TierIntegrationTransactionTest $this, TopicPartition tp) {
        boolean x$2;
        int leaderId = $this.getLeaderForTopicPartition(tp);
        LogManager qual$1 = ((KafkaBroker)$this.brokerForId(leaderId).get()).replicaManager().logManager();
        Assertions.assertTrue((((AbstractLog)qual$1.getLog(tp, x$2 = qual$1.getLog$default$2()).get()).deleteOldSegments() > 0 ? 1 : 0) != 0, (String)"tiered segments should have been deleted");
    }

    public static final /* synthetic */ double $anonfun$testArchiveAndFetchSingleTopicPartition$1(Attribute attr) {
        return BoxesRunTime.unboxToDouble((Object)attr.getValue());
    }

    public static final /* synthetic */ double $anonfun$testArchiveAndFetchSingleTopicPartition$2(Attribute attr) {
        return BoxesRunTime.unboxToDouble((Object)attr.getValue());
    }

    public static final /* synthetic */ void $anonfun$testArchiveAndFetchSingleTopicPartition$3(KafkaBroker broker) {
        MemoryTracker memoryTracker = ((TierFetcher)broker.tierFetcherOpt().get()).memoryTracker();
        Assertions.assertEquals((long)0L, (long)memoryTracker.leased(), (String)new StringBuilder(54).append("expected leased TierFetcher memory for broker ").append(broker.config().brokerId()).append(" to be 0").toString());
    }

    public TierIntegrationTransactionTest() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "5");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierEnableProp(), "false");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), Integer.toString(Integer.MAX_VALUE));
        this.serverConfig().put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        this.serverConfig().put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), "1");
        this.configureMock();
        this.topic = UUID.randomUUID().toString();
        this.partitions = 1;
        this.partitionToLeader = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        this.exited = new AtomicBoolean(false);
    }
}

