/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kafka.common.TenantHelpers;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.tier.TierObjectGarbageCollector;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierPartitionDeleteInitiate;
import kafka.tier.domain.TierPartitionDeletePreInitiate;
import kafka.tier.state.TierPartitionState;
import kafka.tier.topic.TierTopicManager;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.AclsImage;
import org.apache.kafka.image.BrokerReplicaExclusionsImage;
import org.apache.kafka.image.CellImage;
import org.apache.kafka.image.ClientQuotasImage;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.ClusterLinksImage;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.image.DelegationTokenImage;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.MetadataProvenance;
import org.apache.kafka.image.ProducerIdsImage;
import org.apache.kafka.image.ScramImage;
import org.apache.kafka.image.TenantImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.NoOpMetadataEncryptor;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\u0005]b\u0001\u0002\n\u0014\u0001aAQa\b\u0001\u0005\u0002\u0001Bqa\t\u0001C\u0002\u0013%A\u0005\u0003\u0004,\u0001\u0001\u0006I!\n\u0005\bY\u0001\u0011\r\u0011\"\u0003.\u0011\u0019Y\u0004\u0001)A\u0005]!IA\b\u0001a\u0001\u0002\u0004%I!\u0010\u0005\n\u000b\u0002\u0001\r\u00111A\u0005\n\u0019C\u0011\u0002\u0014\u0001A\u0002\u0003\u0005\u000b\u0015\u0002 \t\u00135\u0003\u0001\u0019!a\u0001\n\u0013q\u0005\"\u0003*\u0001\u0001\u0004\u0005\r\u0011\"\u0003T\u0011%)\u0006\u00011A\u0001B\u0003&q\nC\u0003W\u0001\u0011\u0005q\u000bC\u0003d\u0001\u0011\u0005q\u000bC\u0003i\u0001\u0011\u0005q\u000bC\u0003k\u0001\u0011%1\u000eC\u0004\u0002\u0018\u0001!I!!\u0007\t\u000f\u0005=\u0002\u0001\"\u0003\u00022\tqB+[3s\u001f\nTWm\u0019;HCJ\u0014\u0017mZ3D_2dWm\u0019;peR+7\u000f\u001e\u0006\u0003)U\tA\u0001^5fe*\ta#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001I\u0002C\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002CA\u0011!\u0005A\u0007\u0002'\u0005\u0001B/[3s)>\u0004\u0018nY'b]\u0006<WM]\u000b\u0002KA\u0011a%K\u0007\u0002O)\u0011\u0001fE\u0001\u0006i>\u0004\u0018nY\u0005\u0003U\u001d\u0012\u0001\u0003V5feR{\u0007/[2NC:\fw-\u001a:\u0002#QLWM\u001d+pa&\u001cW*\u00198bO\u0016\u0014\b%\u0001\u0003uS6,W#\u0001\u0018\u0011\u0005=JT\"\u0001\u0019\u000b\u0005E\u0012\u0014\u0001B;uS2T!a\r\u001b\u0002\rM,'O^3s\u0015\t1RG\u0003\u00027o\u00051\u0011\r]1dQ\u0016T\u0011\u0001O\u0001\u0004_J<\u0017B\u0001\u001e1\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013!D7fi\u0006$\u0017\r^1DC\u000eDW-F\u0001?!\ty4)D\u0001A\u0015\t\t%)\u0001\u0005nKR\fG-\u0019;b\u0015\t\u0019T#\u0003\u0002E\u0001\n\u00112JU1gi6+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0003EiW\r^1eCR\f7)Y2iK~#S-\u001d\u000b\u0003\u000f*\u0003\"A\u0007%\n\u0005%[\"\u0001B+oSRDqaS\u0004\u0002\u0002\u0003\u0007a(A\u0002yIE\na\"\\3uC\u0012\fG/Y\"bG\",\u0007%\u0001\u000euS\u0016\u0014xJ\u00196fGR<\u0015M\u001d2bO\u0016\u001cu\u000e\u001c7fGR|'/F\u0001P!\t\u0011\u0003+\u0003\u0002R'\tQB+[3s\u001f\nTWm\u0019;HCJ\u0014\u0017mZ3D_2dWm\u0019;pe\u0006qB/[3s\u001f\nTWm\u0019;HCJ\u0014\u0017mZ3D_2dWm\u0019;pe~#S-\u001d\u000b\u0003\u000fRCqa\u0013\u0006\u0002\u0002\u0003\u0007q*A\u000euS\u0016\u0014xJ\u00196fGR<\u0015M\u001d2bO\u0016\u001cu\u000e\u001c7fGR|'\u000fI\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002\u000f\"\u0012A\"\u0017\t\u00035\u0006l\u0011a\u0017\u0006\u00039v\u000b1!\u00199j\u0015\tqv,A\u0004kkBLG/\u001a:\u000b\u0005\u0001<\u0014!\u00026v]&$\u0018B\u00012\\\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001&i\u0016\u001cH/T1zE\u0016\u0004&/Z%oSRL\u0017\r^3QCJ$\u0018\u000e^5p]\u0012+G.\u001a;j_:D#!D3\u0011\u0005i3\u0017BA4\\\u0005\u0011!Vm\u001d;\u00023Q,7\u000f^'bs\n,G)\u001a7fi\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0003\u001d\u0015\f1c\u0019:fCR,W*\u001a;bI\u0006$\u0018-S7bO\u0016$B\u0001\u001c:\u0002\bA\u0011Q\u000e]\u0007\u0002]*\u0011q\u000eN\u0001\u0006S6\fw-Z\u0005\u0003c:\u0014Q\"T3uC\u0012\fG/Y%nC\u001e,\u0007\"B:\u0010\u0001\u0004!\u0018a\u0003;pa&\u001c\u0017*\\1hKN\u0004B!^?\u0002\u00029\u0011ao\u001f\b\u0003ojl\u0011\u0001\u001f\u0006\u0003s^\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000f\n\u0005q\\\u0012a\u00029bG.\fw-Z\u0005\u0003}~\u00141aU3r\u0015\ta8\u0004E\u0002n\u0003\u0007I1!!\u0002o\u0005)!v\u000e]5d\u00136\fw-\u001a\u0005\b\u0003\u0013y\u0001\u0019AA\u0006\u0003MIW.Y4f\u001f\u001a47/\u001a;B]\u0012,\u0005o\\2i!\u0011\ti!a\u0005\u000e\u0005\u0005=!bAA\ti\u0005!!/\u00194u\u0013\u0011\t)\"a\u0004\u0003\u001d=3gm]3u\u0003:$W\t]8dQ\u0006Yb/\u001a:jMf$U\r\\3uKB\u0013X-\u00138ji&\fG/Z\"bY2$RaRA\u000e\u0003KAq!!\b\u0011\u0001\u0004\ty\"\u0001\tu_BL7-\u00133QCJ$\u0018\u000e^5p]B\u0019!%!\t\n\u0007\u0005\r2C\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\"9\u0011q\u0005\tA\u0002\u0005%\u0012a\u0003;j[\u0016\u001c8)\u00197mK\u0012\u00042AGA\u0016\u0013\r\tic\u0007\u0002\u0004\u0013:$\u0018\u0001\u0007<fe&4\u0017\u0010R3mKR,\u0017J\\5uS\u0006$XmQ1mYR)q)a\r\u00026!9\u0011QD\tA\u0002\u0005}\u0001bBA\u0014#\u0001\u0007\u0011\u0011\u0006")
public class TierObjectGarbageCollectorTest {
    private final TierTopicManager tierTopicManager = (TierTopicManager)Mockito.mock(TierTopicManager.class);
    private final MockTime time = new MockTime();
    private KRaftMetadataCache metadataCache;
    private TierObjectGarbageCollector tierObjectGarbageCollector;

    private TierTopicManager tierTopicManager() {
        return this.tierTopicManager;
    }

    private MockTime time() {
        return this.time;
    }

    private KRaftMetadataCache metadataCache() {
        return this.metadataCache;
    }

    private void metadataCache_$eq(KRaftMetadataCache x$1) {
        this.metadataCache = x$1;
    }

    private TierObjectGarbageCollector tierObjectGarbageCollector() {
        return this.tierObjectGarbageCollector;
    }

    private void tierObjectGarbageCollector_$eq(TierObjectGarbageCollector x$1) {
        this.tierObjectGarbageCollector = x$1;
    }

    @BeforeEach
    public void setup() {
        this.metadataCache_$eq(new KRaftMetadataCache(0));
        this.tierObjectGarbageCollector_$eq(new TierObjectGarbageCollector(this.tierTopicManager(), this.metadataCache(), (Time)this.time()));
    }

    @Test
    public void testMaybePreInitiatePartitionDeletion() {
        UUID topicId1 = UUID.randomUUID();
        UUID topicId2 = UUID.randomUUID();
        TopicIdPartition topic1_0 = new TopicIdPartition("topic1", topicId1, 0);
        TopicIdPartition topic1_1 = new TopicIdPartition("topic1", topicId1, 1);
        TopicIdPartition topic2_0 = new TopicIdPartition("topic2", topicId2, 0);
        TopicIdPartition topic2_1 = new TopicIdPartition("topic2", topicId2, 1);
        this.tierObjectGarbageCollector().addTopicPartition(topic1_0, new OffsetAndEpoch(0L, 0));
        this.tierObjectGarbageCollector().addTopicPartition(topic1_1, new OffsetAndEpoch(1L, 0));
        this.tierObjectGarbageCollector().addTopicPartition(topic2_0, new OffsetAndEpoch(2L, 0));
        this.tierObjectGarbageCollector().addTopicPartition(topic2_1, new OffsetAndEpoch(3L, 0));
        TopicImage topicImage1 = new TopicImage("topic1", new Uuid(topicId1.getMostSignificantBits(), topicId1.getLeastSignificantBits()), null, null);
        this.metadataCache().setImage(this.createMetadataImage((Seq<TopicImage>)new .colon.colon((Object)topicImage1, (List)Nil$.MODULE$), new OffsetAndEpoch(0L, 0)));
        this.tierObjectGarbageCollector().maybePreInitiatePartitionDeletion();
        ((TierTopicManager)Mockito.verify((Object)this.tierTopicManager(), (VerificationMode)Mockito.times((int)0))).addMetadata((AbstractTierMetadata)ArgumentMatchers.any());
        this.metadataCache().setImage(this.createMetadataImage((Seq<TopicImage>)new .colon.colon((Object)topicImage1, (List)Nil$.MODULE$), new OffsetAndEpoch(5L, 0)));
        CompletableFuture<TierPartitionState.AppendResult> future = new CompletableFuture<TierPartitionState.AppendResult>();
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(future);
        this.tierObjectGarbageCollector().maybePreInitiatePartitionDeletion();
        future.completeExceptionally(new Exception());
        this.verifyDeletePreInitiateCall(topic1_0, 0);
        this.verifyDeletePreInitiateCall(topic1_1, 0);
        this.verifyDeletePreInitiateCall(topic2_0, 1);
        this.verifyDeletePreInitiateCall(topic2_1, 1);
        future = new CompletableFuture();
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(future);
        this.tierObjectGarbageCollector().maybePreInitiatePartitionDeletion();
        future.complete(TierPartitionState.AppendResult.ACCEPTED);
        this.verifyDeletePreInitiateCall(topic1_0, 0);
        this.verifyDeletePreInitiateCall(topic1_1, 0);
        this.verifyDeletePreInitiateCall(topic2_0, 2);
        this.verifyDeletePreInitiateCall(topic2_1, 2);
    }

    @Test
    public void testMaybeDeletePartitions() {
        int deleteBackoffMs = 5;
        UUID topicId1 = UUID.randomUUID();
        TopicIdPartition topic1_0 = new TopicIdPartition("topic1", topicId1, 0);
        TopicIdPartition topic1_1 = new TopicIdPartition("topic1", topicId1, 1);
        TopicIdPartition topic1_2 = new TopicIdPartition("topic1", topicId1, 2);
        this.tierObjectGarbageCollector().addTopicPartition(topic1_0, new OffsetAndEpoch(0L, 0));
        this.tierObjectGarbageCollector().addTopicPartition(topic1_1, new OffsetAndEpoch(1L, 0));
        this.tierObjectGarbageCollector().addTopicPartition(topic1_2, new OffsetAndEpoch(2L, 0));
        this.tierObjectGarbageCollector().onPartitionDeletePreInitiate(topic1_0, this.time().milliseconds());
        this.tierObjectGarbageCollector().onPartitionDeletePreInitiate(topic1_1, this.time().milliseconds() + 5L);
        this.tierObjectGarbageCollector().onPartitionDeletePreInitiate(topic1_2, this.time().milliseconds() + 10L);
        this.tierObjectGarbageCollector().maybeDeletePartitions((long)deleteBackoffMs);
        this.verifyDeleteInitiateCall(topic1_0, 0);
        this.verifyDeleteInitiateCall(topic1_1, 0);
        this.verifyDeleteInitiateCall(topic1_2, 0);
        this.time().sleep(6L);
        CompletableFuture<TierPartitionState.AppendResult> future = new CompletableFuture<TierPartitionState.AppendResult>();
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(future);
        this.tierObjectGarbageCollector().maybeDeletePartitions((long)deleteBackoffMs);
        future.complete(TierPartitionState.AppendResult.FENCED);
        this.verifyDeleteInitiateCall(topic1_0, 1);
        this.verifyDeleteInitiateCall(topic1_1, 0);
        this.verifyDeleteInitiateCall(topic1_2, 0);
        this.tierObjectGarbageCollector().onPartitionDeleteInitiate(topic1_0);
        this.time().sleep(5L);
        future = new CompletableFuture();
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(future);
        this.tierObjectGarbageCollector().maybeDeletePartitions((long)deleteBackoffMs);
        future.completeExceptionally(new Exception());
        this.verifyDeleteInitiateCall(topic1_0, 1);
        this.verifyDeleteInitiateCall(topic1_1, 1);
        this.verifyDeleteInitiateCall(topic1_2, 0);
        future = new CompletableFuture();
        Mockito.when((Object)this.tierTopicManager().addMetadata((AbstractTierMetadata)ArgumentMatchers.any())).thenReturn(future);
        this.tierObjectGarbageCollector().maybeDeletePartitions((long)deleteBackoffMs);
        future.complete(TierPartitionState.AppendResult.FENCED);
        this.verifyDeleteInitiateCall(topic1_0, 1);
        this.verifyDeleteInitiateCall(topic1_1, 2);
        this.verifyDeleteInitiateCall(topic1_2, 0);
        this.tierObjectGarbageCollector().onPartitionDeleteInitiate(topic1_1);
        this.tierObjectGarbageCollector().onPartitionDeleteComplete(topic1_0);
        this.tierObjectGarbageCollector().onPartitionDeleteComplete(topic1_1);
    }

    private MetadataImage createMetadataImage(Seq<TopicImage> topicImages, OffsetAndEpoch imageOffsetAndEpoch) {
        ObjectRef image = ObjectRef.create((Object)TopicsImage.EMPTY);
        topicImages.foreach((Function1 & Serializable)t -> {
            image.elem = ((TopicsImage)image.elem).including(t, TenantHelpers.NAME_TO_NULL_CALLBACK);
            return BoxedUnit.UNIT;
        });
        return new MetadataImage(new MetadataProvenance(imageOffsetAndEpoch.offset(), imageOffsetAndEpoch.epoch(), 0L), FeaturesImage.EMPTY, ClusterImage.EMPTY, (TopicsImage)image.elem, ConfigurationsImage.EMPTY, ClientQuotasImage.EMPTY, ProducerIdsImage.EMPTY, AclsImage.EMPTY, ClusterLinksImage.EMPTY, BrokerReplicaExclusionsImage.EMPTY, CellImage.EMPTY, TenantImage.EMPTY, ScramImage.EMPTY, DelegationTokenImage.EMPTY, (MetadataEncryptor)NoOpMetadataEncryptor.INSTANCE);
    }

    private void verifyDeletePreInitiateCall(TopicIdPartition topicIdPartition, int timesCalled) {
        ((TierTopicManager)Mockito.verify((Object)this.tierTopicManager(), (VerificationMode)Mockito.times((int)timesCalled))).addMetadata((AbstractTierMetadata)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<TierPartitionDeletePreInitiate>(null, topicIdPartition){
            private final TopicIdPartition topicIdPartition$1;

            public Class<?> type() {
                return super.type();
            }

            public boolean matches(TierPartitionDeletePreInitiate argument) {
                TopicIdPartition topicIdPartition = argument.topicIdPartition();
                TopicIdPartition topicIdPartition2 = this.topicIdPartition$1;
                return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition2) : topicIdPartition2 != null);
            }
            {
                this.topicIdPartition$1 = topicIdPartition$1;
            }
        }));
    }

    private void verifyDeleteInitiateCall(TopicIdPartition topicIdPartition, int timesCalled) {
        ((TierTopicManager)Mockito.verify((Object)this.tierTopicManager(), (VerificationMode)Mockito.times((int)timesCalled))).addMetadata((AbstractTierMetadata)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<TierPartitionDeleteInitiate>(null, topicIdPartition){
            private final TopicIdPartition topicIdPartition$2;

            public Class<?> type() {
                return super.type();
            }

            public boolean matches(TierPartitionDeleteInitiate argument) {
                TopicIdPartition topicIdPartition = argument.topicIdPartition();
                TopicIdPartition topicIdPartition2 = this.topicIdPartition$2;
                return !(topicIdPartition != null ? !topicIdPartition.equals(topicIdPartition2) : topicIdPartition2 != null);
            }
            {
                this.topicIdPartition$2 = topicIdPartition$2;
            }
        }));
    }
}

