/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.Serializable;
import java.util.Properties;
import java.util.Set;
import kafka.api.IntegrationTestHarness;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.tier.topic.TierTopicManager;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\u0005%g\u0001B\r\u001b\u0001}AQ\u0001\f\u0001\u0005\u00025Bq\u0001\r\u0001C\u0002\u0013%\u0011\u0007\u0003\u00049\u0001\u0001\u0006IA\r\u0005\bs\u0001\u0011\r\u0011\"\u0003;\u0011\u0019\u0019\u0005\u0001)A\u0005w!9A\t\u0001b\u0001\n\u0013\t\u0004BB#\u0001A\u0003%!\u0007C\u0005G\u0001\u0001\u0007\t\u0019!C\u0005\u000f\"I1\f\u0001a\u0001\u0002\u0004%I\u0001\u0018\u0005\nE\u0002\u0001\r\u0011!Q!\n!C\u0011b\u0013\u0001A\u0002\u0003\u0007I\u0011B$\t\u0013\r\u0004\u0001\u0019!a\u0001\n\u0013!\u0007\"\u00034\u0001\u0001\u0004\u0005\t\u0015)\u0003I\u0011%9\u0007\u00011AA\u0002\u0013%\u0001\u000eC\u0005o\u0001\u0001\u0007\t\u0019!C\u0005_\"I\u0011\u000f\u0001a\u0001\u0002\u0003\u0006K!\u001b\u0005\u0006e\u0002!\t&\r\u0005\u0006g\u0002!\t\u0005\u001e\u0005\b\u0003\u000f\u0001A\u0011IA\u0005\u0011\u001d\tI\u0003\u0001C!\u0003WAq!!\u000e\u0001\t\u0013\t9\u0004C\u0004\u0002H\u0001!I!!\u0013\t\u000f\u0005\u001d\u0004\u0001\"\u0003\u0002j!9\u0011\u0011\u000f\u0001\u0005\u0002\u0005M$\u0001\t+jKJ\u0004&o\u001c3vG\u0016\u00148\u000b^1uKJ+\u0007\u000f\\5dCRLwN\u001c+fgRT!a\u0007\u000f\u0002\tQLWM\u001d\u0006\u0002;\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001!MA\u0011\u0011\u0005J\u0007\u0002E)\u00111\u0005H\u0001\u0004CBL\u0017BA\u0013#\u0005YIe\u000e^3he\u0006$\u0018n\u001c8UKN$\b*\u0019:oKN\u001c\bCA\u0014+\u001b\u0005A#BA\u0015\u001d\u0003\u0015)H/\u001b7t\u0013\tY\u0003FA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005q\u0003CA\u0018\u0001\u001b\u0005Q\u0012\u0001D:fO6,g\u000e\u001e\"zi\u0016\u001cX#\u0001\u001a\u0011\u0005M2T\"\u0001\u001b\u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0003\u0007%sG/A\u0007tK\u001elWM\u001c;CsR,7\u000fI\u0001\ni>\u0004\u0018n\u0019(b[\u0016,\u0012a\u000f\t\u0003y\u0005k\u0011!\u0010\u0006\u0003}}\nA\u0001\\1oO*\t\u0001)\u0001\u0003kCZ\f\u0017B\u0001\">\u0005\u0019\u0019FO]5oO\u0006QAo\u001c9jG:\u000bW.\u001a\u0011\u0002#I,\u0007\u000f\\5dCRLwN\u001c$bGR|'/\u0001\nsKBd\u0017nY1uS>tg)Y2u_J\u0004\u0013aD8oKNDw\u000e\u001e)s_\u0012,8-\u001a:\u0016\u0003!\u0003B!S*V+6\t!J\u0003\u0002L\u0019\u0006A\u0001O]8ek\u000e,'O\u0003\u0002N\u001d\u000691\r\\5f]R\u001c(BA\u000fP\u0015\t\u0001\u0016+\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002%\u0006\u0019qN]4\n\u0005QS%!D&bM.\f\u0007K]8ek\u000e,'\u000fE\u00024-bK!a\u0016\u001b\u0003\u000b\u0005\u0013(/Y=\u0011\u0005MJ\u0016B\u0001.5\u0005\u0011\u0011\u0015\u0010^3\u0002'=tWm\u001d5piB\u0013x\u000eZ;dKJ|F%Z9\u0015\u0005u\u0003\u0007CA\u001a_\u0013\tyFG\u0001\u0003V]&$\bbB1\n\u0003\u0003\u0005\r\u0001S\u0001\u0004q\u0012\n\u0014\u0001E8oKNDw\u000e\u001e)s_\u0012,8-\u001a:!\u00031\u0001(o\u001c3vG\u0016\u0014x\fJ3r)\tiV\rC\u0004b\u0019\u0005\u0005\t\u0019\u0001%\u0002\u0013A\u0014x\u000eZ;dKJ\u0004\u0013\u0001C2p]N,X.\u001a:\u0016\u0003%\u0004BA\u001b7V+6\t1N\u0003\u0002h\u0019&\u0011Qn\u001b\u0002\t\u0007>t7/^7fe\u0006a1m\u001c8tk6,'o\u0018\u0013fcR\u0011Q\f\u001d\u0005\bC>\t\t\u00111\u0001j\u0003%\u0019wN\\:v[\u0016\u0014\b%A\u0006ce>\\WM]\"pk:$\u0018!D7pI&4\u0017pQ8oM&<7\u000f\u0006\u0002^k\")aO\u0005a\u0001o\u0006)\u0001O]8qgB\u0019\u0001p_?\u000e\u0003eT!A\u001f\u001b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002}s\n\u00191+Z9\u0011\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\taP\u0001\u0005kRLG.C\u0002\u0002\u0006}\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0003\u0015\u0019X\r^+q)\ri\u00161\u0002\u0005\b\u0003\u001b\u0019\u0002\u0019AA\b\u0003!!Xm\u001d;J]\u001a|\u0007\u0003BA\t\u0003;i!!a\u0005\u000b\u0007\r\n)B\u0003\u0003\u0002\u0018\u0005e\u0011a\u00026va&$XM\u001d\u0006\u0004\u00037\t\u0016!\u00026v]&$\u0018\u0002BA\u0010\u0003'\u0011\u0001\u0002V3ti&sgm\u001c\u0015\u0004'\u0005\r\u0002\u0003BA\t\u0003KIA!a\n\u0002\u0014\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:$\u0012!\u0018\u0015\u0004)\u0005=\u0002\u0003BA\t\u0003cIA!a\r\u0002\u0014\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\raJ|G-^2f\u0005f$Xm\u001d\u000b\u0007\u0003s\ty$a\u0011\u0011\u0007%\u000bY$C\u0002\u0002>)\u0013aBU3d_J$W*\u001a;bI\u0006$\u0018\r\u0003\u0004\u0002BU\u0001\r\u0001S\u0001\u0005aJ|G\r\u0003\u0004\u0002FU\u0001\rAM\u0001\t]Vl')\u001f;fg\u00061A.Z1eKJ$B!a\u0013\u0002XA!\u0011QJA*\u001b\t\tyEC\u0002\u0002Rq\taa]3sm\u0016\u0014\u0018\u0002BA+\u0003\u001f\u00121bS1gW\u0006\u0014%o\\6fe\"9\u0011\u0011\f\fA\u0002\u0005m\u0013A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0005\u0003;\n\u0019'\u0004\u0002\u0002`)\u0019\u0011\u0011\r(\u0002\r\r|W.\\8o\u0013\u0011\t)'a\u0018\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006A\u0011m^1ji&\u001b&\u000bF\u0003^\u0003W\ni\u0007C\u0004\u0002Z]\u0001\r!a\u0017\t\r\u0005=t\u00031\u00013\u0003!)\u0007\u0010]3di\u0016$\u0017!\f;fgR\u0004&o\u001c3vG\u0016\u00148\u000b^1uKJ+7\u000f^8sCRLwN\u001c$s_6$\u0016.\u001a:fIN#xN]1hKR\u0019Q,!\u001e\t\u000f\u0005]\u0004\u00041\u0001\u0002z\u00051\u0011/^8sk6\u0004B!a\u001f\u0002\n:!\u0011QPAC!\r\ty\bN\u0007\u0003\u0003\u0003S1!a!\u001f\u0003\u0019a$o\\8u}%\u0019\u0011q\u0011\u001b\u0002\rA\u0013X\rZ3g\u0013\r\u0011\u00151\u0012\u0006\u0004\u0003\u000f#\u0004f\u0002\r\u0002\u0010\u0006m\u0015Q\u0014\t\u0005\u0003#\u000b9*\u0004\u0002\u0002\u0014*!\u0011QSA\u000b\u0003\u0019\u0001\u0018M]1ng&!\u0011\u0011TAJ\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u0005]\u0006lW-\t\u0002\u0002 \u0006\u00113\u0010Z5ta2\f\u0017PT1nKvt30\u0019:hk6,g\u000e^:XSRDg*Y7fgvDs\u0001GAR\u0003_\u000b\t\f\u0005\u0003\u0002&\u0006-VBAAT\u0015\u0011\tI+a%\u0002\u0011A\u0014xN^5eKJLA!!,\u0002(\nYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONdC!a-\u00028\u0006\u0012\u0011QW\u0001\u0003u.\f#!!/\u0002\u000b-\u0014\u0018M\u001a;)\u000f\u0001\ti,a1\u0002FB!\u0011\u0011CA`\u0013\u0011\t\t-a\u0005\u0003\u0007Q\u000bw-A\u0003wC2,X-\t\u0002\u0002H\u0006Y\u0011N\u001c;fOJ\fG/[8o\u0001")
public class TierProducerStateReplicationTest
extends IntegrationTestHarness {
    private final int segmentBytes;
    private final String topicName;
    private final int replicationFactor = this.brokerCount();
    private KafkaProducer<byte[], byte[]> oneshotProducer;
    private KafkaProducer<byte[], byte[]> producer;
    private Consumer<byte[], byte[]> consumer;

    private int segmentBytes() {
        return this.segmentBytes;
    }

    private String topicName() {
        return this.topicName;
    }

    private int replicationFactor() {
        return this.replicationFactor;
    }

    private KafkaProducer<byte[], byte[]> oneshotProducer() {
        return this.oneshotProducer;
    }

    private void oneshotProducer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.oneshotProducer = x$1;
    }

    private KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    private void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    private Consumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    private void consumer_$eq(Consumer<byte[], byte[]> x$1) {
        this.consumer = x$1;
    }

    @Override
    public int brokerCount() {
        return 3;
    }

    @Override
    public void modifyConfigs(Seq<Properties> props) {
        props.foreach((Function1 & Serializable)p -> {
            p.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
            p.put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
            p.put(KafkaConfig$.MODULE$.TierEnableProp(), "true");
            p.put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
            p.put(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "3");
            p.put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "1");
            p.put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), Integer.toString(this.segmentBytes() * 2));
            p.put(KafkaConfig$.MODULE$.LogSegmentBytesProp(), Integer.toString(this.segmentBytes()));
            return p.put(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), "500");
        });
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        Properties topicProps = new Properties();
        topicProps.put("confluent.tier.enable", "true");
        topicProps.put("retention.bytes", "-1");
        topicProps.put("min.insync.replicas", "2");
        String x$1 = this.topicName();
        int x$2 = this.replicationFactor();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        this.createTopic(x$1, x$3, x$2, x$4, x$5, x$6);
        Properties producerProps = new Properties();
        producerProps.put("enable.idempotence", "true");
        this.oneshotProducer_$eq(this.createProducer(new ByteArraySerializer(), new ByteArraySerializer(), producerProps));
        this.producer_$eq(this.createProducer(new ByteArraySerializer(), new ByteArraySerializer(), producerProps));
        this.consumer_$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()));
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        this.producer().flush();
        this.producer().close();
        this.oneshotProducer().flush();
        this.oneshotProducer().close();
        this.consumer().close();
    }

    private RecordMetadata produceBytes(KafkaProducer<byte[], byte[]> prod, int numBytes) {
        byte[] bytes = TestUtils.randomBytes((int)numBytes);
        return (RecordMetadata)prod.send(new ProducerRecord(this.topicName(), Predef$.MODULE$.int2Integer(0), null, (Object)bytes)).get();
    }

    private KafkaBroker leader(TopicPartition topicPartition) {
        int leaderId = ((UpdateMetadataRequestData.UpdateMetadataPartitionState)((KafkaBroker)((Tuple2)((IterableOps)((IterableOps)this.brokers().zip((IterableOnce)Predef$.MODULE$.wrapBooleanArray(this.alive()))).filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4._2$mcZ$sp()))).head())._1()).metadataCache().getPartitionInfo(topicPartition.topic(), topicPartition.partition()).get()).leader();
        return (KafkaBroker)((IterableOps)this.brokers().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TierProducerStateReplicationTest.$anonfun$leader$2(leaderId, x$5)))).head();
    }

    /*
     * WARNING - void declaration
     */
    private void awaitISR(TopicPartition topicPartition, int expected) {
        long l = 1000L;
        long waitUntilTrue_waitTimeMs = 120000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierProducerStateReplicationTest.$anonfun$awaitISR$1(this, topicPartition, expected)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"timed out waiting for replicas to join the ISR");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testProducerStateRestorationFromTieredStorage(String quorum) {
        void var6_9;
        void var5_8;
        TopicPartition topicPartition = new TopicPartition(this.topicName(), 0);
        long l = 1000L;
        long waitUntilTrue_waitTimeMs = 30000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierProducerStateReplicationTest.$anonfun$testProducerStateRestorationFromTieredStorage$1(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Wait until the tier topic manager is ready for all brokers");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int killedBroker = this.killRandomBroker();
        this.awaitISR(topicPartition, this.replicationFactor() - 1);
        this.produceBytes(this.oneshotProducer(), 512);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 30).foreach((Function1 & Serializable)x$7 -> this.produceBytes(this.producer(), 512));
        Tuple2 tuple2 = this.brokers().partition((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TierProducerStateReplicationTest.$anonfun$testProducerStateRestorationFromTieredStorage$5(killedBroker, x$8)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Buffer deadServers = (Buffer)tuple2._1();
        Buffer livingServers = (Buffer)tuple2._2();
        KafkaBroker deadServer = (KafkaBroker)var5_8.head();
        long l2 = 1000L;
        long waitUntilTrue_waitTimeMs2 = 300000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!((Buffer)var6_9).forall((Function1 & Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)TierProducerStateReplicationTest.$anonfun$testProducerStateRestorationFromTieredStorage$7(topicPartition$2, broker)))) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"expected to tier some segments and advance the local log start offset");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)((AbstractLog)deadServer.replicaManager().getLog(topicPartition).get()).producerStateManager().activeProducers().isEmpty(), (String)"expected the shutdown server to have no active producers");
        Assertions.assertTrue((boolean)var6_9.forall((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)TierProducerStateReplicationTest.$anonfun$testProducerStateRestorationFromTieredStorage$9(topicPartition, x$10))), (String)"expected the active brokers to both have materialized some producer state");
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        this.awaitISR(topicPartition, this.replicationFactor());
        Assertions.assertEquals((int)this.brokers().size(), (int)this.replicationFactor());
        long l3 = 1000L;
        long waitUntilTrue_waitTimeMs3 = 300000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!TierProducerStateReplicationTest.$anonfun$testProducerStateRestorationFromTieredStorage$10(this, topicPartition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"expected all brokers to have matching end offsets");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        Buffer activeProducersAcrossBrokers = (Buffer)this.brokers().map((Function1 & Serializable)broker -> ((AbstractLog)broker.replicaManager().getLog(topicPartition).get()).producerStateManager().activeProducers().keySet());
        activeProducersAcrossBrokers.foreach((Function1 & Serializable)s -> {
            TierProducerStateReplicationTest.$anonfun$testProducerStateRestorationFromTieredStorage$15(activeProducersAcrossBrokers, s);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$leader$2(int leaderId$1, KafkaBroker x$5) {
        return x$5.config().brokerId() == leaderId$1;
    }

    public static final /* synthetic */ boolean $anonfun$awaitISR$1(TierProducerStateReplicationTest $this, TopicPartition topicPartition$1, int expected$1) {
        return ((Partition)$this.leader(topicPartition$1).replicaManager().onlinePartition(topicPartition$1).get()).inSyncReplicaIds().size() == expected$1;
    }

    public static final /* synthetic */ String $anonfun$awaitISR$2() {
        return "timed out waiting for replicas to join the ISR";
    }

    public static final /* synthetic */ boolean $anonfun$testProducerStateRestorationFromTieredStorage$2(KafkaBroker x$6) {
        return ((TierTopicManager)x$6.tierTopicManagerOpt().get()).isReadyForWrites();
    }

    public static final /* synthetic */ boolean $anonfun$testProducerStateRestorationFromTieredStorage$1(TierProducerStateReplicationTest $this) {
        return $this.brokers().forall((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TierProducerStateReplicationTest.$anonfun$testProducerStateRestorationFromTieredStorage$2(x$6)));
    }

    public static final /* synthetic */ String $anonfun$testProducerStateRestorationFromTieredStorage$3() {
        return "Wait until the tier topic manager is ready for all brokers";
    }

    public static final /* synthetic */ boolean $anonfun$testProducerStateRestorationFromTieredStorage$5(int killedBroker$1, KafkaBroker x$8) {
        return x$8.config().brokerId() == killedBroker$1;
    }

    public static final /* synthetic */ boolean $anonfun$testProducerStateRestorationFromTieredStorage$7(TopicPartition topicPartition$2, KafkaBroker broker) {
        boolean x$2;
        LogManager qual$1 = broker.replicaManager().logManager();
        return ((AbstractLog)qual$1.getLog(topicPartition$2, x$2 = qual$1.getLog$default$2()).get()).localLogStartOffset() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testProducerStateRestorationFromTieredStorage$8() {
        return "expected to tier some segments and advance the local log start offset";
    }

    public static final /* synthetic */ boolean $anonfun$testProducerStateRestorationFromTieredStorage$9(TopicPartition topicPartition$2, KafkaBroker x$10) {
        return CollectionConverters$.MODULE$.MapHasAsScala(((AbstractLog)x$10.replicaManager().getLog(topicPartition$2).get()).producerStateManager().activeProducers()).asScala().nonEmpty();
    }

    public static final /* synthetic */ long $anonfun$testProducerStateRestorationFromTieredStorage$11(TopicPartition topicPartition$2, KafkaBroker x$11) {
        return ((AbstractLog)x$11.replicaManager().getLog(topicPartition$2).get()).localLogEndOffset();
    }

    public static final /* synthetic */ boolean $anonfun$testProducerStateRestorationFromTieredStorage$10(TierProducerStateReplicationTest $this, TopicPartition topicPartition$2) {
        Buffer endOffsets = (Buffer)$this.brokers().map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToLong((long)TierProducerStateReplicationTest.$anonfun$testProducerStateRestorationFromTieredStorage$11(topicPartition$2, x$11)));
        return endOffsets.forall((Function1)(JFunction1.mcZJ.sp & Serializable)x$12 -> x$12 == BoxesRunTime.unboxToLong((Object)endOffsets.head()));
    }

    public static final /* synthetic */ String $anonfun$testProducerStateRestorationFromTieredStorage$13() {
        return "expected all brokers to have matching end offsets";
    }

    public static final /* synthetic */ void $anonfun$testProducerStateRestorationFromTieredStorage$15(Buffer activeProducersAcrossBrokers$1, Set s) {
        Assertions.assertEquals((Object)activeProducersAcrossBrokers$1.head(), (Object)s, (String)"expected the set of active producers for all brokers to be the same");
    }

    public TierProducerStateReplicationTest() {
        this.segmentBytes = 1024;
        this.topicName = "topic";
    }
}

