/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.util.Optional;
import java.util.UUID;
import kafka.tier.TierReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.TierPartitionState;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005q3AAD\b\u0001)!)1\u0004\u0001C\u00019!9q\u0004\u0001b\u0001\n\u0013\u0001\u0003BB\u0018\u0001A\u0003%\u0011\u0005C\u00041\u0001\t\u0007I\u0011B\u0019\t\ra\u0002\u0001\u0015!\u00033\u0011\u001dI\u0004A1A\u0005\nEBaA\u000f\u0001!\u0002\u0013\u0011\u0004bB\u001e\u0001\u0005\u0004%I\u0001\u0010\u0005\u0007\u0001\u0002\u0001\u000b\u0011B\u001f\t\u000b\u0005\u0003A\u0011\u0001\"\t\u000bM\u0003A\u0011\u0001\"\t\u000ba\u0003A\u0011\u0001\"\t\u000bi\u0003A\u0011\u0001\"\u0003-QKWM\u001d*fa2L7-Y'b]\u0006<WM\u001d+fgRT!\u0001E\t\u0002\tQLWM\u001d\u0006\u0002%\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0016!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011aD\u0001\tY&\u001cH/\u001a8feV\t\u0011\u0005\u0005\u0002#Y9\u00111E\u000b\b\u0003I%r!!\n\u0015\u000e\u0003\u0019R!aJ\n\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0012B\u0001\t\u0012\u0013\tYs\"\u0001\nUS\u0016\u0014(+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018BA\u0017/\u00059\u0019\u0005.\u00198hK2K7\u000f^3oKJT!aK\b\u0002\u00131L7\u000f^3oKJ\u0004\u0013!\u0007;jKJ,e.\u00192mK\u0012\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016,\u0012A\r\t\u0003gYj\u0011\u0001\u000e\u0006\u0003k=\tQa\u001d;bi\u0016L!a\u000e\u001b\u0003-\u0019KG.\u001a+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\f!\u0004^5fe\u0016s\u0017M\u00197fIB\u000b'\u000f^5uS>t7\u000b^1uK\u0002\n!\u0004^5fe\u0012K7/\u00192mK\u0012\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\f1\u0004^5fe\u0012K7/\u00192mK\u0012\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\u0004\u0013A\u0005;jKJ\u0014V\r\u001d7jG\u0006l\u0015M\\1hKJ,\u0012!\u0010\t\u0003=yJ!aP\b\u0003%QKWM\u001d*fa2L7-Y'b]\u0006<WM]\u0001\u0014i&,'OU3qY&\u001c\u0017-T1oC\u001e,'\u000fI\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002\u0007B\u0011a\u0003R\u0005\u0003\u000b^\u0011A!\u00168ji\"\u0012!b\u0012\t\u0003\u0011Fk\u0011!\u0013\u0006\u0003\u0015.\u000b1!\u00199j\u0015\taU*A\u0004kkBLG/\u001a:\u000b\u00059{\u0015!\u00026v]&$(\"\u0001)\u0002\u0007=\u0014x-\u0003\u0002S\u0013\nQ!)\u001a4pe\u0016,\u0015m\u00195\u00027Q,7\u000f\u001e\"fG>lW\rT3bI\u0016\u0014\bK]8qC\u001e\fG/[8oQ\tYQ\u000b\u0005\u0002I-&\u0011q+\u0013\u0002\u0005)\u0016\u001cH/A\u000fuKN$()Z2p[\u00164u\u000e\u001c7po\u0016\u0014\bK]8qC\u001e\fG/[8oQ\taQ+A\u000buKN$H)\u001a7fi\u0016\u0004&o\u001c9bO\u0006$\u0018n\u001c8)\u00055)\u0006")
public class TierReplicaManagerTest {
    private final TierReplicaManager.ChangeListener listener = (TierReplicaManager.ChangeListener)Mockito.mock(TierReplicaManager.ChangeListener.class);
    private final FileTierPartitionState tierEnabledPartitionState = (FileTierPartitionState)Mockito.mock(FileTierPartitionState.class);
    private final FileTierPartitionState tierDisabledPartitionState = (FileTierPartitionState)Mockito.mock(FileTierPartitionState.class);
    private final TierReplicaManager tierReplicaManager = new TierReplicaManager();

    private TierReplicaManager.ChangeListener listener() {
        return this.listener;
    }

    private FileTierPartitionState tierEnabledPartitionState() {
        return this.tierEnabledPartitionState;
    }

    private FileTierPartitionState tierDisabledPartitionState() {
        return this.tierDisabledPartitionState;
    }

    private TierReplicaManager tierReplicaManager() {
        return this.tierReplicaManager;
    }

    @BeforeEach
    public void setup() {
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.tierEnabledPartitionState().mayContainTieredData())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)this.tierEnabledPartitionState().topicIdPartition()).thenReturn(Optional.of(new TopicIdPartition("foo", UUID.randomUUID(), 0)));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.tierDisabledPartitionState().mayContainTieredData())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)this.tierDisabledPartitionState().topicIdPartition()).thenReturn(Optional.of(new TopicIdPartition("bar", UUID.randomUUID(), 0)));
        this.tierReplicaManager().addListener(this.listener());
    }

    @Test
    public void testBecomeLeaderPropagation() {
        this.tierReplicaManager().becomeLeader((TierPartitionState)this.tierEnabledPartitionState(), 10);
        this.tierReplicaManager().becomeLeader((TierPartitionState)this.tierDisabledPartitionState(), 10);
        ((TierReplicaManager.ChangeListener)Mockito.verify((Object)this.listener(), (VerificationMode)Mockito.times((int)1))).onBecomeLeader((TopicIdPartition)this.tierEnabledPartitionState().topicIdPartition().get(), 10);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.listener()});
    }

    @Test
    public void testBecomeFollowerPropagation() {
        this.tierReplicaManager().becomeFollower((TierPartitionState)this.tierEnabledPartitionState());
        this.tierReplicaManager().becomeFollower((TierPartitionState)this.tierDisabledPartitionState());
        ((TierReplicaManager.ChangeListener)Mockito.verify((Object)this.listener(), (VerificationMode)Mockito.times((int)1))).onBecomeFollower((TopicIdPartition)this.tierEnabledPartitionState().topicIdPartition().get());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.listener()});
    }

    @Test
    public void testDeletePropagation() {
        this.tierReplicaManager().delete((TopicIdPartition)this.tierEnabledPartitionState().topicIdPartition().get());
        this.tierReplicaManager().delete((TopicIdPartition)this.tierDisabledPartitionState().topicIdPartition().get());
        ((TierReplicaManager.ChangeListener)Mockito.verify((Object)this.listener(), (VerificationMode)Mockito.times((int)1))).onDelete((TopicIdPartition)this.tierEnabledPartitionState().topicIdPartition().get());
        ((TierReplicaManager.ChangeListener)Mockito.verify((Object)this.listener(), (VerificationMode)Mockito.times((int)1))).onDelete((TopicIdPartition)this.tierDisabledPartitionState().topicIdPartition().get());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.listener()});
    }
}

