/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.Serializable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.IntegrationTestHarness;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.TierLogSegment;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.tier.state.TierPartitionState;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Ec\u0001\u0002\t\u0012\u0001YAQ!\b\u0001\u0005\u0002yAq!\t\u0001C\u0002\u0013%!\u0005\u0003\u0004,\u0001\u0001\u0006Ia\t\u0005\bY\u0001\u0011\r\u0011\"\u0003.\u0011\u0019!\u0004\u0001)A\u0005]!9Q\u0007\u0001b\u0001\n\u0013i\u0003B\u0002\u001c\u0001A\u0003%a\u0006C\u00038\u0001\u0011ES\u0006C\u00049\u0001\t\u0007I\u0011A\u001d\t\r\u0011\u0003\u0001\u0015!\u0003;\u0011\u0015)\u0005\u0001\"\u0011G\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u0015\t\u0007\u0001\"\u0001c\u0011\u001d\ti\u0001\u0001C\u0005\u0003\u001fAq!!\r\u0001\t\u0013\t\u0019D\u0001\u000fUS\u0016\u0014(+\u001a;f]RLwN\\%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005I\u0019\u0012\u0001\u0002;jKJT\u0011\u0001F\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0003\u0005\u0002\u001975\t\u0011D\u0003\u0002\u001b'\u0005\u0019\u0011\r]5\n\u0005qI\"AF%oi\u0016<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u0011\u0001\u001b\u0005\t\u0012!\u0002;pa&\u001cW#A\u0012\u0011\u0005\u0011JS\"A\u0013\u000b\u0005\u0019:\u0013\u0001\u00027b]\u001eT\u0011\u0001K\u0001\u0005U\u00064\u0018-\u0003\u0002+K\t11\u000b\u001e:j]\u001e\fa\u0001^8qS\u000e\u0004\u0013!\u00048v[B\u000b'\u000f^5uS>t7/F\u0001/!\ty#'D\u00011\u0015\u0005\t\u0014!B:dC2\f\u0017BA\u001a1\u0005\rIe\u000e^\u0001\u000f]Vl\u0007+\u0019:uSRLwN\\:!\u0003-qW/\u001c*fa2L7-Y:\u0002\u00199,XNU3qY&\u001c\u0017m\u001d\u0011\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u0001\u0007KbLG/\u001a3\u0016\u0003i\u0002\"a\u000f\"\u000e\u0003qR!!\u0010 \u0002\r\u0005$x.\\5d\u0015\ty\u0004)\u0001\u0006d_:\u001cWO\u001d:f]RT!!Q\u0014\u0002\tU$\u0018\u000e\\\u0005\u0003\u0007r\u0012Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017aB3ySR,G\rI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u000f*\u0003\"a\f%\n\u0005%\u0003$\u0001B+oSRDQaS\u0006A\u00021\u000b\u0001\u0002^3ti&sgm\u001c\t\u0003\u001bVk\u0011A\u0014\u0006\u00035=S!\u0001U)\u0002\u000f),\b/\u001b;fe*\u0011!kU\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002)\u0006\u0019qN]4\n\u0005Ys%\u0001\u0003+fgRLeNZ8)\u0005-A\u0006CA'Z\u0013\tQfJ\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002\u000f\"\u0012AB\u0018\t\u0003\u001b~K!\u0001\u0019(\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\u0005;fgR\u0014\u0015m]5d%\u0016$XM\u001c;j_:$2aR2p\u0011\u0015!W\u00021\u0001f\u0003\u0019\tXo\u001c:v[B\u0011a-\u001c\b\u0003O.\u0004\"\u0001\u001b\u0019\u000e\u0003%T!A[\u000b\u0002\rq\u0012xn\u001c;?\u0013\ta\u0007'\u0001\u0004Qe\u0016$WMZ\u0005\u0003U9T!\u0001\u001c\u0019\t\u000bAl\u0001\u0019A3\u0002\u0017I,\u0007\u000f\\5dCRLwN\u001c\u0015\u0005\u001bID\u0018\u0010\u0005\u0002tm6\tAO\u0003\u0002v\u001f\u00061\u0001/\u0019:b[NL!a\u001e;\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0003oC6,\u0017%\u0001>\u0002Qm$\u0017n\u001d9mCft\u0015-\\3~]E,xN];n{m\u0004TP\f:fa2L7-\u0019;j_:l40M?)\r5a\u0018QAA\u0004!\ri\u0018\u0011A\u0007\u0002}*\u0011q\u0010^\u0001\taJ|g/\u001b3fe&\u0019\u00111\u0001@\u0003\u00195+G\u000f[8e'>,(oY3\u0002\u000bY\fG.^3-\u0005\u0005%\u0011EAA\u0006\u00031\nE\u000e\\*vaB|'\u000f^3e#V|'/^7B]\u0012\u0014V\r\u001d7jG\u0006$\u0018n\u001c8D_6\u0014\u0017N\\1uS>t7/\u0001\u000exC&$XK\u001c;jY\u0016\u000bX/\u00197P]\u0006cGN\u0011:pW\u0016\u00148\u000fF\u0003H\u0003#\ti\u0003C\u0004\u0002\u00149\u0001\r!!\u0006\u0002\u0013\r|W\u000e];uK\u001as\u0007cB\u0018\u0002\u0018\u0005m\u0011qE\u0005\u0004\u00033\u0001$!\u0003$v]\u000e$\u0018n\u001c82!\u0011\ti\"a\t\u000e\u0005\u0005}!bAA\u0011'\u000511/\u001a:wKJLA!!\n\u0002 \tY1*\u00194lC\n\u0013xn[3s!\r!\u0013\u0011F\u0005\u0004\u0003W)#AB(cU\u0016\u001cG\u000f\u0003\u0004\u000209\u0001\r!Z\u0001\u0004[N<\u0017\u0001C1xC&$\u0018j\u0015*\u0015\u000f\u001d\u000b)$a\u0013\u0002N!9\u0011qG\bA\u0002\u0005e\u0012A\u0001;q!\u0011\tY$a\u0012\u000e\u0005\u0005u\"\u0002BA \u0003\u0003\naaY8n[>t'b\u0001\u000b\u0002D)\u0019\u0011QI*\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\tI%!\u0010\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\")Qg\u0004a\u0001]!9\u0011qJ\bA\u0002\u0005m\u0011A\u00027fC\u0012,'\u000f")
public class TierRetentionIntegrationTest
extends IntegrationTestHarness {
    private final String topic;
    private final int numPartitions;
    private final int numReplicas;
    private final AtomicBoolean exited;

    private String topic() {
        return this.topic;
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    private int numReplicas() {
        return this.numReplicas;
    }

    @Override
    public int brokerCount() {
        return 3;
    }

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        Exit.setExitProcedure((x$1, x$2) -> this.exited().set(true));
        super.setUp(testInfo);
        this.maybeEnablePushReplication(this.serverConfig());
        this.createTopic(this.topic(), this.numPartitions(), this.numReplicas(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        Assertions.assertFalse((boolean)this.exited().get());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}.replication={1}")
    @MethodSource(value={"AllSupportedQuorumAndReplicationCombinations"})
    public void testBasicRetention(String quorum, String replication) {
        TopicPartition topicPartition = new TopicPartition(this.topic(), 0);
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
        int recordSize = ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.byteArrayOps((byte[])record.key())) + ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.byteArrayOps((byte[])record.value()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        PartitionInfo partitionInfo = (PartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(producer.partitionsFor(this.topic())).asScala().find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TierRetentionIntegrationTest.$anonfun$testBasicRetention$1(x$3))).get();
        int leaderBrokerId = partitionInfo.leader().id();
        int[] followers = (int[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.replicas()), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), (ClassTag)ClassTag$.MODULE$.Int())), (Function1)(JFunction1.mcZI.sp & Serializable)x$5 -> x$5 != leaderBrokerId);
        KafkaBroker leader = (KafkaBroker)this.brokers().find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TierRetentionIntegrationTest.$anonfun$testBasicRetention$4(leaderBrokerId, x$6))).get();
        IntRef bytesSent = IntRef.create((int)0);
        while (bytesSent.elem < 1100) {
            producer.send(record).get();
            bytesSent.elem += recordSize;
        }
        LogManager qual$1 = leader.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$1.getLog(topicPartition, x$2).get();
        TierPartitionState tierPartitionState = log.tierPartitionState();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierRetentionIntegrationTest.$anonfun$testBasicRetention$5(tierPartitionState)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for segments to be tiered");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierRetentionIntegrationTest.$anonfun$testBasicRetention$7(tierPartitionState)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Timed out waiting for tier partition state to be flushed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.IteratorHasAsScala(tierPartitionState.segments()).asScala().nonEmpty());
        Assertions.assertEquals((long)0L, (long)log.logStartOffset());
        Assertions.assertEquals((long)0L, (long)((TierLogSegment)CollectionConverters$.MODULE$.IteratorHasAsScala(tierPartitionState.segments()).asScala().next()).baseOffset());
        this.awaitISR(topicPartition, this.numReplicas(), leader);
        this.killBrokerById(followers[0]);
        while (bytesSent.elem < 20000) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).map((Function1 & Serializable)x$7 -> TierRetentionIntegrationTest.$anonfun$testBasicRetention$9(bytesSent, recordSize, producer, record, BoxesRunTime.unboxToInt((Object)x$7))).foreach((Function1 & Serializable)x$8 -> (RecordMetadata)x$8.get());
        }
        this.brokers().foreach((Function1 & Serializable)broker -> {
            TierRetentionIntegrationTest.$anonfun$testBasicRetention$11(this, topicPartition, broker);
            return BoxedUnit.UNIT;
        });
        this.killBrokerById(followers[1]);
        while (bytesSent.elem < 40000) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).map((Function1 & Serializable)x$10 -> TierRetentionIntegrationTest.$anonfun$testBasicRetention$18(bytesSent, recordSize, producer, record, BoxesRunTime.unboxToInt((Object)x$10))).foreach((Function1 & Serializable)x$11 -> (RecordMetadata)x$11.get());
        }
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        this.awaitISR(topicPartition, this.numReplicas(), leader);
        Function1 & Serializable waitUntilEqualOnAllBrokers_computeFn = (Function1 & Serializable)broker -> {
            LogManager qual$3 = broker.logManager();
            boolean x$6 = qual$3.getLog$default$2();
            return Long.toString(((AbstractLog)qual$3.getLog(topicPartition, x$6).get()).logStartOffset());
        };
        long l3 = 100L;
        long waitUntilEqualOnAllBrokers_waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilEqualOnAllBrokers_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!(((IterableOnceOps)this.brokers().map((Function1 & Serializable)broker -> computeFn$1.apply(broker))).toSet().size() == 1)) {
            void waitUntilEqualOnAllBrokers_waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilEqualOnAllBrokers_waitUntilTrue_startTime + waitUntilEqualOnAllBrokers_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilEqualOnAllBrokers_waitUntilTrue_waitTimeMs), (long)waitUntilEqualOnAllBrokers_waitUntilTrue_pause));
        }
        Object var28_22 = null;
        Function1 & Serializable waitUntilEqualOnAllBrokers_computeFn2 = (Function1 & Serializable)broker -> {
            LogManager qual$4 = broker.logManager();
            boolean x$8 = qual$4.getLog$default$2();
            return Long.toString(((AbstractLog)qual$4.getLog(topicPartition, x$8).get()).logEndOffset());
        };
        long l4 = 100L;
        long waitUntilEqualOnAllBrokers_waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilEqualOnAllBrokers_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!(((IterableOnceOps)this.brokers().map((Function1 & Serializable)broker -> computeFn$1.apply(broker))).toSet().size() == 1)) {
            void waitUntilEqualOnAllBrokers_waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilEqualOnAllBrokers_waitUntilTrue_startTime2 + waitUntilEqualOnAllBrokers_waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilEqualOnAllBrokers_waitUntilTrue_waitTimeMs2), (long)waitUntilEqualOnAllBrokers_waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void waitUntilEqualOnAllBrokers(Function1<KafkaBroker, Object> computeFn, String msg) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!(((IterableOnceOps)this.brokers().map((Function1 & Serializable)broker -> computeFn$1.apply(broker))).toSet().size() == 1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void awaitISR(TopicPartition tp, int numReplicas, KafkaBroker leader) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierRetentionIntegrationTest.$anonfun$awaitISR$1(numReplicas, leader, tp)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierRetentionIntegrationTest.$anonfun$awaitISR$2(numReplicas, leader, tp));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testBasicRetention$1(PartitionInfo x$3) {
        return x$3.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testBasicRetention$4(int leaderBrokerId$1, KafkaBroker x$6) {
        return x$6.config().brokerId() == leaderBrokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testBasicRetention$5(TierPartitionState tierPartitionState$1) {
        return tierPartitionState$1.totalSize() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testBasicRetention$6() {
        return "Timed out waiting for segments to be tiered";
    }

    public static final /* synthetic */ boolean $anonfun$testBasicRetention$7(TierPartitionState tierPartitionState$1) {
        return tierPartitionState$1.committedEndOffset() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testBasicRetention$8() {
        return "Timed out waiting for tier partition state to be flushed";
    }

    public static final /* synthetic */ Future $anonfun$testBasicRetention$9(IntRef bytesSent$1, int recordSize$1, KafkaProducer producer$1, ProducerRecord record$1, int x$7) {
        bytesSent$1.elem += recordSize$1;
        return producer$1.send(record$1);
    }

    public static final /* synthetic */ boolean $anonfun$testBasicRetention$12(AbstractLog log$1) {
        return log$1.logStartOffset() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testBasicRetention$13() {
        return "Timed out waiting for retention to kick in";
    }

    public static final /* synthetic */ boolean $anonfun$testBasicRetention$14(TierPartitionState tierPartitionState$2) {
        return BoxesRunTime.unboxToLong((Object)CollectionConverters$.MODULE$.IteratorHasAsScala(tierPartitionState$2.segments()).asScala().toList().headOption().map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.baseOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L)) > 0L;
    }

    public static final /* synthetic */ String $anonfun$testBasicRetention$17() {
        return "Timed out waiting for tiered segment to be deleted";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testBasicRetention$11(TierRetentionIntegrationTest $this, TopicPartition topicPartition$1, KafkaBroker broker) {
        if ($this.alive()[$this.brokers().indexOf((Object)broker)]) {
            LogManager qual$2 = broker.logManager();
            boolean x$4 = qual$2.getLog$default$2();
            AbstractLog log = (AbstractLog)qual$2.getLog(topicPartition$1, x$4).get();
            TierPartitionState tierPartitionState = log.tierPartitionState();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TierRetentionIntegrationTest.$anonfun$testBasicRetention$12(log)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for retention to kick in");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!TierRetentionIntegrationTest.$anonfun$testBasicRetention$14(tierPartitionState)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"Timed out waiting for tiered segment to be deleted");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            return;
        }
    }

    public static final /* synthetic */ Future $anonfun$testBasicRetention$18(IntRef bytesSent$1, int recordSize$1, KafkaProducer producer$1, ProducerRecord record$1, int x$10) {
        bytesSent$1.elem += recordSize$1;
        return producer$1.send(record$1);
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilEqualOnAllBrokers$1(TierRetentionIntegrationTest $this, Function1 computeFn$1) {
        return ((IterableOnceOps)$this.brokers().map((Function1 & Serializable)broker -> computeFn$1.apply(broker))).toSet().size() == 1;
    }

    public static final /* synthetic */ String $anonfun$waitUntilEqualOnAllBrokers$3() {
        return "";
    }

    private static final Set isr$1(KafkaBroker leader$1, TopicPartition tp$1) {
        return ((Partition)leader$1.replicaManager().onlinePartition(tp$1).get()).inSyncReplicaIds();
    }

    public static final /* synthetic */ boolean $anonfun$awaitISR$1(int numReplicas$1, KafkaBroker leader$1, TopicPartition tp$1) {
        return TierRetentionIntegrationTest.isr$1(leader$1, tp$1).size() == numReplicas$1;
    }

    public static final /* synthetic */ String $anonfun$awaitISR$2(int numReplicas$1, KafkaBroker leader$1, TopicPartition tp$1) {
        return new StringBuilder(73).append("Timed out waiting for replicas to join ISR. numReplicas=").append(numReplicas$1).append(", leader=").append(leader$1.config().brokerId()).append(", isr={").append(TierRetentionIntegrationTest.isr$1(leader$1, tp$1)).append("}").toString();
    }

    public TierRetentionIntegrationTest() {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "2");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierFencedSegmentDeleteDelayMsProp(), "5");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "10000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.LogSegmentBytesProp(), "1000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.LogFlushSchedulerIntervalMsProp(), "10");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "10");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), "10");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), "false");
        this.topic = "foo";
        this.numPartitions = 1;
        this.numReplicas = 3;
        this.exited = new AtomicBoolean(false);
    }
}

