/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.exceptions.TierTopicConsumerRewindException;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.OpaqueData;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicConsumerRewindPolicy;
import kafka.tier.topic.TierTopicManager;
import kafka.tier.topic.TierTopicPartitioner;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\u0005Mb\u0001B\u0007\u000f\u0001MAQA\u0007\u0001\u0005\u0002mAqA\b\u0001C\u0002\u0013\u0005q\u0004\u0003\u0004)\u0001\u0001\u0006I\u0001\t\u0005\bS\u0001\u0011\r\u0011\"\u0001+\u0011\u0019\t\u0004\u0001)A\u0005W!)!\u0007\u0001C!g!)!\t\u0001C\u0001\u0007\")!\u000f\u0001C\u0001g\")\u0001\u0010\u0001C\u0001s\")a\u0010\u0001C!\u007f\"9\u0011q\u0002\u0001\u0005\n\u0005E\u0001BBA\u0019\u0001\u0011%qP\u0001\u0014US\u0016\u0014Hk\u001c9jG\u000e{gn];nKJ\u0014Vm^5oI&sG/Z4sCRLwN\u001c+fgRT!a\u0004\t\u0002\tQLWM\u001d\u0006\u0002#\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\t9\u0002#A\u0006j]R,wM]1uS>t\u0017BA\r\u0017\u0005YY\u0015MZ6b'\u0016\u0014h/\u001a:UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001\u001d!\ti\u0002!D\u0001\u000f\u0003=yg/\u001a:sS\u0012Lgn\u001a)s_B\u001cX#\u0001\u0011\u0011\u0005\u00052S\"\u0001\u0012\u000b\u0005\r\"\u0013\u0001B;uS2T\u0011!J\u0001\u0005U\u00064\u0018-\u0003\u0002(E\tQ\u0001K]8qKJ$\u0018.Z:\u0002!=4XM\u001d:jI&tw\r\u0015:paN\u0004\u0013A\u00027pO\u0012K'/F\u0001,!\tas&D\u0001.\u0015\tqC%\u0001\u0002j_&\u0011\u0001'\f\u0002\u0005\r&dW-A\u0004m_\u001e$\u0015N\u001d\u0011\u0002\u001f\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jON,\u0012\u0001\u000e\t\u0004kibT\"\u0001\u001c\u000b\u0005]B\u0014AC2pY2,7\r^5p]*\t\u0011(A\u0003tG\u0006d\u0017-\u0003\u0002<m\t\u00191+Z9\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}\u0002\u0012AB:feZ,'/\u0003\u0002B}\tY1*\u00194lC\u000e{gNZ5h\u0003E!Xm\u001d;SK^Lg\u000e\u001a+p'R\f'\u000f\u001e\u000b\u0003\t\"\u0003\"!\u0012$\u000e\u0003aJ!a\u0012\u001d\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0013\u001e\u0001\rAS\u0001\u0007cV|'/^7\u0011\u0005-\u0013fB\u0001'Q!\ti\u0005(D\u0001O\u0015\ty%#\u0001\u0004=e>|GOP\u0005\u0003#b\na\u0001\u0015:fI\u00164\u0017BA*U\u0005\u0019\u0019FO]5oO*\u0011\u0011\u000b\u000f\u0015\u0005\u000fY\u00137\r\u0005\u0002XA6\t\u0001L\u0003\u0002Z5\u00061\u0001/\u0019:b[NT!a\u0017/\u0002\u000f),\b/\u001b;fe*\u0011QLX\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002?\u0006\u0019qN]4\n\u0005\u0005D&!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\u0005!\u0017AI>eSN\u0004H.Y=OC6,WPL>be\u001e,X.\u001a8ug^KG\u000f\u001b(b[\u0016\u001cX\u0010\u000b\u0003\bM2l\u0007CA4k\u001b\u0005A'BA5Y\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018BA6i\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\u0012a\u000e]\u0011\u0002_\u0006\u0011!p[\u0011\u0002c\u0006)1N]1gi\u0006\u0011B/Z:u%\u0016<\u0018N\u001c3U_>3gm]3u)\t!E\u000fC\u0003J\u0011\u0001\u0007!\n\u000b\u0003\t-\n\u001c\u0007\u0006\u0002\u0005gY^d#A\u001c9\u0002#Q,7\u000f\u001e*fo&tGMR1jYV\u0014X\r\u0006\u0002Eu\")\u0011*\u0003a\u0001\u0015\"\"\u0011B\u00162dQ\u0011Ia\r\\?-\u00059\u0004\u0018\u0001\u0003;fCJ$un\u001e8\u0015\u0003\u0011C3ACA\u0002!\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u00055\u0006\u0019\u0011\r]5\n\t\u00055\u0011q\u0001\u0002\n\u0003\u001a$XM]#bG\"\fqc]3ukB$\u0016.\u001a:U_BL7\rU1si&$\u0018n\u001c8\u0015\u0005\u0005M\u0001cB#\u0002\u0016\u0005e\u0011QE\u0005\u0004\u0003/A$A\u0002+va2,'\u0007\u0005\u0003\u0002\u001c\u0005\u0005RBAA\u000f\u0015\r\ty\u0002J\u0001\u0005Y\u0006tw-\u0003\u0003\u0002$\u0005u!aB%oi\u0016<WM\u001d\t\u0005\u0003O\ti#\u0004\u0002\u0002*)\u0019\u00111\u0006\b\u0002\u000bQ|\u0007/[2\n\t\u0005=\u0012\u0011\u0006\u0002\u0012)&,'\u000fV8qS\u000e\u001cuN\\:v[\u0016\u0014\u0018!G<bSR4uN\u001d+jKJ|eMZ:fiN$vN\u00127vg\"\u0004")
public class TierTopicConsumerRewindIntegrationTest
extends KafkaServerTestHarness {
    private final Properties overridingProps = new Properties();
    private final File logDir;

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public File logDir() {
        return this.logDir;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnectOrNull(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testRewindToStart(String quorum) {
        void var3_3;
        void var4_4;
        Tuple2<Integer, TierTopicConsumer> tuple2 = this.setupTierTopicPartition();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Integer tierTopicPartitionId = (Integer)tuple2._1();
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple2._2();
        this.waitForTierOffsetsToFlush();
        ObjectRef ttcPositions = ObjectRef.create((Object)var4_4.snapshotPositions());
        Assertions.assertTrue((((OffsetAndEpoch)((java.util.Map)ttcPositions.elem).get(var3_3)).offset() > 0L ? 1 : 0) != 0);
        boolean isMissing = false;
        if (((java.util.Map)ttcPositions.elem).keySet().size() < 2) {
            isMissing = true;
        }
        if (isMissing) {
            Assertions$.MODULE$.assertThrows(() -> TierTopicConsumerRewindIntegrationTest.$anonfun$testRewindToStart$1((TierTopicConsumer)var4_4), ClassTag$.MODULE$.apply(TierTopicConsumerRewindException.class), new Position("TierTopicConsumerRewindIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            java.util.Map rewindRes = var4_4.rewindToStart(true, TierTopicConsumerRewindPolicy.SKIP_MISSING_PARTITIONS);
            ((KafkaBroker)this.brokers().last()).config().logDirs().foreach(arg_0 -> TierTopicConsumerRewindIntegrationTest.$anonfun$testRewindToStart$2$adapted(rewindRes, (Integer)var3_3, arg_0));
        } else {
            var4_4.rewindToStart(true, TierTopicConsumerRewindPolicy.FAIL_ON_MISSING_PARTITIONS);
        }
        ttcPositions.elem = var4_4.snapshotPositions();
        ((java.util.Map)ttcPositions.elem).keySet().forEach(tierTopicPartition -> Assertions.assertEquals((long)0L, (long)((OffsetAndEpoch)((java.util.Map)ttcPositions$1.elem).get(tierTopicPartition)).offset()));
        var4_4.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testRewindToOffset(String quorum) {
        void var3_3;
        void var4_4;
        Tuple2<Integer, TierTopicConsumer> tuple2 = this.setupTierTopicPartition();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Integer tierTopicPartitionId = (Integer)tuple2._1();
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple2._2();
        this.waitForTierOffsetsToFlush();
        java.util.Map oldTtcPositions = var4_4.snapshotPositions();
        OffsetAndEpoch curOffset = (OffsetAndEpoch)oldTtcPositions.get(var3_3);
        Assertions.assertTrue((curOffset.offset() > 0L ? 1 : 0) != 0);
        HashMap<void, OffsetAndEpoch> partitionToPosition = new HashMap<void, OffsetAndEpoch>();
        OffsetAndEpoch position = new OffsetAndEpoch(1L, curOffset.epoch());
        partitionToPosition.put(var3_3, position);
        var4_4.rewind(partitionToPosition, true, TierTopicConsumerRewindPolicy.FAIL_ON_MISSING_PARTITIONS);
        java.util.Map ttcPositions = var4_4.snapshotPositions();
        ttcPositions.keySet().forEach(arg_0 -> TierTopicConsumerRewindIntegrationTest.$anonfun$testRewindToOffset$1((Integer)var3_3, oldTtcPositions, ttcPositions, position, arg_0));
        var4_4.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testRewindFailure(String quorum) {
        void var3_3;
        void var4_4;
        Tuple2<Integer, TierTopicConsumer> tuple2 = this.setupTierTopicPartition();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Integer tierTopicPartitionId = (Integer)tuple2._1();
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)tuple2._2();
        this.waitForTierOffsetsToFlush();
        java.util.Map oldTtcPositions = var4_4.snapshotPositions();
        OffsetAndEpoch curOffset = (OffsetAndEpoch)oldTtcPositions.get(var3_3);
        Assertions.assertTrue((curOffset.offset() > 0L ? 1 : 0) != 0);
        HashMap<void, OffsetAndEpoch> partitionToPosition = new HashMap<void, OffsetAndEpoch>();
        OffsetAndEpoch position = new OffsetAndEpoch(curOffset.offset() + 1L, curOffset.epoch());
        partitionToPosition.put(var3_3, position);
        Assertions$.MODULE$.assertThrows(() -> TierTopicConsumerRewindIntegrationTest.$anonfun$testRewindFailure$1((TierTopicConsumer)var4_4, partitionToPosition), ClassTag$.MODULE$.apply(TierTopicConsumerRewindException.class), new Position("TierTopicConsumerRewindIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        Assertions$.MODULE$.assertThrows(() -> TierTopicConsumerRewindIntegrationTest.$anonfun$testRewindFailure$2((TierTopicConsumer)var4_4, partitionToPosition), ClassTag$.MODULE$.apply(TierTopicConsumerRewindException.class), new Position("TierTopicConsumerRewindIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
        Assertions.assertTrue((boolean)Files.deleteIfExists(new File((String)((KafkaBroker)this.brokers().last()).config().logDirs().last(), "/tier.offsets").toPath()));
        Assertions$.MODULE$.assertThrows(() -> TierTopicConsumerRewindIntegrationTest.$anonfun$testRewindFailure$3((TierTopicConsumer)var4_4, partitionToPosition), ClassTag$.MODULE$.apply(TierTopicConsumerRewindException.class), new Position("TierTopicConsumerRewindIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        java.util.Map ttcPositions = var4_4.snapshotPositions();
        Assertions.assertEquals((Object)oldTtcPositions, (Object)ttcPositions);
        var4_4.shutdown();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        TestUtils$.MODULE$.verifyNoUnexpectedThreads("@AfterEach");
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<Integer, TierTopicConsumer> setupTierTopicPartition() {
        Properties properties = new Properties();
        properties.put("confluent.tier.enable", "true");
        properties.put("cleanup.policy", "delete");
        String userTopic = "foo";
        TopicPartition userTopicPartition = new TopicPartition(userTopic, 0);
        int x$4 = this.createTopic$default$3();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        this.createTopic(userTopic, 2, x$4, properties, x$5, x$6);
        TierTopicConsumer tierTopicConsumer = (TierTopicConsumer)((KafkaBroker)this.brokers().last()).tierTopicConsumerOpt().get();
        TierTopicManager tierTopicManager = (TierTopicManager)((KafkaBroker)this.brokers().last()).tierTopicManagerOpt().get();
        LogManager logManager = ((KafkaBroker)this.brokers().last()).logManager();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!tierTopicManager.isReadyForWrites()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"timed out waiting for TierTopicManager to be ready");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierTopicConsumerRewindIntegrationTest.$anonfun$setupTierTopicPartition$3(logManager, userTopicPartition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"InitLeader event not materialized.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        TierPartitionState tierPartitionState = ((AbstractLog)logManager.getLog(userTopicPartition, logManager.getLog$default$2()).get()).tierPartitionState();
        TopicIdPartition topicIdPartition = (TopicIdPartition)tierPartitionState.topicIdPartition().get();
        int tierTopicPartitionId = new TierTopicPartitioner(2).partitionId(topicIdPartition);
        CompletableFuture<TierPartitionState.AppendResult> result = TierTestUtils$.MODULE$.uploadWithMetadata(tierTopicManager, topicIdPartition, 0, UUID.randomUUID(), 0L, 1000L, 15000L, 0L, 100, false, true, false, tierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch(), OpaqueData.ZEROED);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)result.get());
        tierPartitionState.flush();
        Assertions.assertEquals((long)1000L, (long)tierPartitionState.committedEndOffset());
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 500L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!TierTopicConsumerRewindIntegrationTest.$anonfun$setupTierTopicPartition$6(tierPartitionState)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"tierTopicManager consumers catchingUp timed out");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        return new Tuple2((Object)Predef$.MODULE$.int2Integer(tierTopicPartitionId), (Object)tierTopicConsumer);
    }

    private void waitForTierOffsetsToFlush() {
        long waitUntilTrue_pause = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicConsumerRewindIntegrationTest.$anonfun$waitForTierOffsetsToFlush$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"timed out while waiting for tier.offsets to be flushed to disk in all logDirs");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ java.util.Map $anonfun$testRewindToStart$1(TierTopicConsumer tierTopicConsumer$1) {
        return tierTopicConsumer$1.rewindToStart(true, TierTopicConsumerRewindPolicy.FAIL_ON_MISSING_PARTITIONS);
    }

    public static final /* synthetic */ void $anonfun$testRewindToStart$2(java.util.Map rewindRes$1, Integer tierTopicPartitionId$1, String logDir) {
        Set logDirSkippedPartitions = (Set)rewindRes$1.get(logDir);
        Assertions.assertFalse((boolean)logDirSkippedPartitions.contains(tierTopicPartitionId$1));
        Assertions.assertFalse((boolean)logDirSkippedPartitions.isEmpty());
        Assertions.assertTrue((logDirSkippedPartitions.size() == 1 ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testRewindToOffset$1(Integer tierTopicPartitionId$2, java.util.Map oldTtcPositions$1, java.util.Map ttcPositions$2, OffsetAndEpoch position$1, Integer ttp) {
        Integer n = ttp;
        if (n == null ? tierTopicPartitionId$2 != null : !((Object)n).equals(tierTopicPartitionId$2)) {
            Assertions.assertEquals(oldTtcPositions$1.get(ttp), ttcPositions$2.get(ttp));
            return;
        }
        Assertions.assertEquals((long)position$1.offset(), (long)((OffsetAndEpoch)ttcPositions$2.get(tierTopicPartitionId$2)).offset());
    }

    public static final /* synthetic */ java.util.Map $anonfun$testRewindFailure$1(TierTopicConsumer tierTopicConsumer$2, HashMap partitionToPosition$1) {
        return tierTopicConsumer$2.rewind((java.util.Map)partitionToPosition$1, false, TierTopicConsumerRewindPolicy.FAIL_ON_MISSING_PARTITIONS);
    }

    public static final /* synthetic */ java.util.Map $anonfun$testRewindFailure$2(TierTopicConsumer tierTopicConsumer$2, HashMap partitionToPosition$1) {
        return tierTopicConsumer$2.rewind((java.util.Map)partitionToPosition$1, true, TierTopicConsumerRewindPolicy.FAIL_ON_MISSING_PARTITIONS);
    }

    public static final /* synthetic */ java.util.Map $anonfun$testRewindFailure$3(TierTopicConsumer tierTopicConsumer$2, HashMap partitionToPosition$1) {
        return tierTopicConsumer$2.rewind((java.util.Map)partitionToPosition$1, true, TierTopicConsumerRewindPolicy.FAIL_ON_MISSING_PARTITIONS);
    }

    public static final /* synthetic */ boolean $anonfun$setupTierTopicPartition$1(TierTopicManager tierTopicManager$1) {
        return tierTopicManager$1.isReadyForWrites();
    }

    public static final /* synthetic */ String $anonfun$setupTierTopicPartition$2() {
        return "timed out waiting for TierTopicManager to be ready";
    }

    public static final /* synthetic */ boolean $anonfun$setupTierTopicPartition$3(LogManager logManager$1, TopicPartition userTopicPartition$1) {
        Option partitionState = logManager$1.getLog(userTopicPartition$1, logManager$1.getLog$default$2()).map((Function1 & Serializable)x$5 -> x$5.tierPartitionState());
        return partitionState.isDefined() && ((TierPartitionState)partitionState.get()).topicIdPartition().isPresent() && ((TierPartitionState)partitionState.get()).tierEpoch() == 0;
    }

    public static final /* synthetic */ String $anonfun$setupTierTopicPartition$5() {
        return "InitLeader event not materialized.";
    }

    public static final /* synthetic */ boolean $anonfun$setupTierTopicPartition$6(TierPartitionState tierPartitionState$1) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$1.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
    }

    public static final /* synthetic */ String $anonfun$setupTierTopicPartition$7() {
        return "tierTopicManager consumers catchingUp timed out";
    }

    public static final /* synthetic */ boolean $anonfun$waitForTierOffsetsToFlush$2(String logDir) {
        Path tierOffsetsPath = new File(logDir, "/tier.offsets").toPath();
        return Files.exists(tierOffsetsPath, new LinkOption[0]) && Files.lines(tierOffsetsPath).count() > 1L;
    }

    public static final /* synthetic */ boolean $anonfun$waitForTierOffsetsToFlush$1(TierTopicConsumerRewindIntegrationTest $this) {
        return ((KafkaBroker)$this.brokers().last()).config().logDirs().forall((Function1 & Serializable)logDir -> BoxesRunTime.boxToBoolean((boolean)TierTopicConsumerRewindIntegrationTest.$anonfun$waitForTierOffsetsToFlush$2(logDir)));
    }

    public static final /* synthetic */ String $anonfun$waitForTierOffsetsToFlush$3() {
        return "timed out while waiting for tier.offsets to be flushed to disk in all logDirs";
    }

    public TierTopicConsumerRewindIntegrationTest() {
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "2");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "1");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.logDir = TestUtils.tempDirectory(null, null);
    }

    public static final /* synthetic */ Object $anonfun$testRewindToStart$2$adapted(java.util.Map rewindRes$1, Integer tierTopicPartitionId$1, String logDir) {
        TierTopicConsumerRewindIntegrationTest.$anonfun$testRewindToStart$2(rewindRes$1, tierTopicPartitionId$1, logDir);
        return BoxedUnit.UNIT;
    }
}

