/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.Optional;
import java.util.Properties;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.tier.TierTestUtils$;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierRecordType;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.topic.TierTopicDataLossValidator;
import kafka.tier.topic.TierTopicDataLossValidatorMetrics;
import kafka.tier.topic.TierTopicManager;
import kafka.tier.topic.recovery.ValidationSource;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Tag(value="bazel:shard_count:2")
@ScalaSignature(bytes="\u0006\u0005\u0005\u001da\u0001B\u0006\r\u0001EAQ\u0001\u0007\u0001\u0005\u0002eAq\u0001\b\u0001C\u0002\u0013\u0005Q\u0004\u0003\u0004%\u0001\u0001\u0006IA\b\u0005\bK\u0001\u0011\r\u0011\"\u0001'\u0011\u0019Q\u0003\u0001)A\u0005O!91\u0006\u0001b\u0001\n\u0003a\u0003BB\u001b\u0001A\u0003%Q\u0006C\u00037\u0001\u0011\u0005s\u0007C\u0003E\u0001\u0011\u0005Q\tC\u0003t\u0001\u0011\u0005AOA\u0015US\u0016\u0014Hk\u001c9jG\u0012\u000bG/\u0019'pgN4\u0016\r\\5eCR|'/\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003\u001b9\tA\u0001^5fe*\tq\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0017\u001b\u0005!\"BA\u000b\u000f\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u0005]!\"AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005Q\u0002CA\u000e\u0001\u001b\u0005a\u0011A\u00038v[\n\u0013xn[3sgV\ta\u0004\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003EA\u0002J]R\f1B\\;n\u0005J|7.\u001a:tA\u00051B/[3s\u001b\u0016$\u0018\rZ1uCB\u000b'\u000f^5uS>t7/F\u0001(!\ty\u0002&\u0003\u0002*A\t)1\u000b[8si\u00069B/[3s\u001b\u0016$\u0018\rZ1uCB\u000b'\u000f^5uS>t7\u000fI\u0001\u0010_Z,'O]5eS:<\u0007K]8qgV\tQ\u0006\u0005\u0002/g5\tqF\u0003\u00021c\u0005!Q\u000f^5m\u0015\u0005\u0011\u0014\u0001\u00026bm\u0006L!\u0001N\u0018\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\tpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9tA\u0005yq-\u001a8fe\u0006$XmQ8oM&<7/F\u00019!\rIDHP\u0007\u0002u)\u00111\bI\u0001\u000bG>dG.Z2uS>t\u0017BA\u001f;\u0005\r\u0019V-\u001d\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003:\taa]3sm\u0016\u0014\u0018BA\"A\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002=Q,7\u000f\u001e+jKJ$v\u000e]5d\t\u0006$\u0018\rT8tg\u0012+G/Z2uS>tGC\u0001$J!\tyr)\u0003\u0002IA\t!QK\\5u\u0011\u0015Q\u0015\u00021\u0001L\u0003\u0019\tXo\u001c:v[B\u0011Aj\u0015\b\u0003\u001bF\u0003\"A\u0014\u0011\u000e\u0003=S!\u0001\u0015\t\u0002\rq\u0012xn\u001c;?\u0013\t\u0011\u0006%\u0001\u0004Qe\u0016$WMZ\u0005\u0003)V\u0013aa\u0015;sS:<'B\u0001*!Q\u0011Iqk\u00193\u0011\u0005a\u000bW\"A-\u000b\u0005i[\u0016A\u00029be\u0006l7O\u0003\u0002];\u00069!.\u001e9ji\u0016\u0014(B\u00010`\u0003\u0015QWO\\5u\u0015\u0005\u0001\u0017aA8sO&\u0011!-\u0017\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\u00028b[\u0016\f\u0013!Z\u0001#w\u0012L7\u000f\u001d7bs:\u000bW.Z?/w\u0006\u0014x-^7f]R\u001cx+\u001b;i\u001d\u0006lWm]?)\t%9WN\u001c\t\u0003Q.l\u0011!\u001b\u0006\u0003Uf\u000b\u0001\u0002\u001d:pm&$WM]\u0005\u0003Y&\u00141BV1mk\u0016\u001cv.\u001e:dK\u000691\u000f\u001e:j]\u001e\u001cHFA8rC\u0005\u0001\u0018A\u0001>lC\u0005\u0011\u0018!B6sC\u001a$\u0018A\u000b;fgR$\u0016.\u001a:U_BL7\rR1uC2{7o\u001d#fi\u0016\u001cG/[8o\u001b\u0006DH+[7f_V$Xj\u001d\u000b\u0003\rVDQA\u0013\u0006A\u0002-CCAC,dI\"\"!bZ7yY\u0005y\u0007F\u0002\u0001{\u0003\u0003\t\u0019\u0001\u0005\u0002|}6\tAP\u0003\u0002~7\u0006\u0019\u0011\r]5\n\u0005}d(a\u0001+bO\u0006)a/\u00197vK\u0006\u0012\u0011QA\u0001\u0014E\u0006TX\r\u001c\u001etQ\u0006\u0014HmX2pk:$(H\r")
public class TierTopicDataLossValidatorIntegrationTest
extends KafkaServerTestHarness {
    private final int numBrokers;
    private final short tierMetadataPartitions;
    private final Properties overridingProps = new Properties();

    public int numBrokers() {
        return this.numBrokers;
    }

    public short tierMetadataPartitions() {
        return this.tierMetadataPartitions;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numBrokers(), this.zkConnectOrNull(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTierTopicDataLossDetection(String quorum) {
        this.brokers().foreach((Function1 & Serializable)broker -> {
            TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetection$1(broker);
            return BoxedUnit.UNIT;
        });
        Properties userTopicConfig = new Properties();
        userTopicConfig.put("confluent.tier.enable", "true");
        userTopicConfig.put("cleanup.policy", "delete");
        userTopicConfig.put("retention.ms", "-1");
        userTopicConfig.put("retention.bytes", "-1");
        userTopicConfig.put("min.insync.replicas", "2");
        String topic = "foo-data-loss-detection";
        int x$3 = this.numBrokers();
        int x$4 = this.createTopic$default$2();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        this.createTopic(topic, x$4, x$3, userTopicConfig, x$5, x$6);
        TopicPartition userTopicPartition = new TopicPartition(topic, 0);
        this.brokers().foreach((Function1 & Serializable)broker -> {
            TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetection$4(userTopicPartition, broker);
            return BoxedUnit.UNIT;
        });
        this.killAllBrokers();
        this.brokers().foreach((Function1 & Serializable)broker -> {
            TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetection$9(broker);
            return BoxedUnit.UNIT;
        });
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        this.brokers().foreach((Function1 & Serializable)broker -> {
            TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetection$10(broker);
            return BoxedUnit.UNIT;
        });
        this.brokers().foreach((Function1 & Serializable)broker -> {
            TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetection$13(userTopicPartition, broker);
            return BoxedUnit.UNIT;
        });
        this.killAllBrokers();
        this.brokers().foreach((Function1 & Serializable)broker -> {
            TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetection$19(broker);
            return BoxedUnit.UNIT;
        });
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        this.brokers().foreach((Function1 & Serializable)broker -> {
            TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetection$20(broker);
            return BoxedUnit.UNIT;
        });
        ListBuffer<ConsumerRecord<byte[], byte[]>> records = TierTestUtils$.MODULE$.readTierTopicRecords(this.bootstrapServers(this.bootstrapServers$default$1()), this.tierMetadataPartitions());
        IntRef numFencingEvents = IntRef.create((int)0);
        records.foreach((Function1 & Serializable)record -> {
            TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetection$23(userTopicPartition, numFencingEvents, record);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)this.numBrokers(), (int)numFencingEvents.elem);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testTierTopicDataLossDetectionMaxTimeoutMs(String quorum) {
        long newTierTopicDataLossDetectionMaxTimeoutMs = 3600000L;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numBrokers()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> {
            this.adminZkClient().changeBrokerConfig((Option)new Some((Object)BoxesRunTime.boxToInteger((int)brokerId)), CoreUtils$.MODULE$.propsWith((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)KafkaConfig$.MODULE$.TierTopicDataLossDetectionMaxTimeoutMsProp(), (Object)Long.toString(newTierTopicDataLossDetectionMaxTimeoutMs))})));
            ((IterableOnceOps)this.servers().filter((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetectionMaxTimeoutMs$2(brokerId, server)))).foreach((Function1 & Serializable)server -> {
                TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetectionMaxTimeoutMs$3(newTierTopicDataLossDetectionMaxTimeoutMs, server);
                return BoxedUnit.UNIT;
            });
        });
    }

    public static final /* synthetic */ boolean $anonfun$testTierTopicDataLossDetection$2(TierTopicManager eta$0$1$1) {
        return eta$0$1$1.isReadyForWrites();
    }

    public static final /* synthetic */ String $anonfun$testTierTopicDataLossDetection$3() {
        return "timed out waiting for TierTopicManager to be ready";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testTierTopicDataLossDetection$1(KafkaBroker broker) {
        TierTopicManager tierTopicManager = (TierTopicManager)broker.tierTopicManagerOpt().get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!tierTopicManager.isReadyForWrites()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"timed out waiting for TierTopicManager to be ready");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testTierTopicDataLossDetection$5(KafkaBroker broker$1, TopicPartition userTopicPartition$1) {
        boolean x$8;
        LogManager qual$1 = broker$1.logManager();
        Option partitionState = qual$1.getLog(userTopicPartition$1, x$8 = qual$1.getLog$default$2()).map((Function1 & Serializable)x$2 -> x$2.tierPartitionState());
        return partitionState.isDefined() && ((TierPartitionState)partitionState.get()).topicIdPartition().isPresent() && ((TierPartitionState)partitionState.get()).tierEpoch() == 0;
    }

    public static final /* synthetic */ String $anonfun$testTierTopicDataLossDetection$7() {
        return "InitLeader event not materialized.";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testTierTopicDataLossDetection$4(TopicPartition userTopicPartition$1, KafkaBroker broker) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetection$5(broker, userTopicPartition$1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"InitLeader event not materialized.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        LogManager qual$2 = broker.logManager();
        boolean x$10 = qual$2.getLog$default$2();
        OffsetAndEpoch materializedOffsetAndEpoch = ((AbstractLog)qual$2.getLog(userTopicPartition$1, x$10).get()).tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((long)0L, (long)materializedOffsetAndEpoch.offset());
        Assertions.assertEquals((int)0, (Integer)materializedOffsetAndEpoch.epoch().orElseGet(() -> Predef$.MODULE$.int2Integer(-1)));
    }

    public static final /* synthetic */ void $anonfun$testTierTopicDataLossDetection$9(KafkaBroker broker) {
        Assertions.assertTrue((boolean)Files.deleteIfExists(new File((String)broker.config().logDirs().last(), ".kafka_cleanshutdown").toPath()));
    }

    public static final /* synthetic */ boolean $anonfun$testTierTopicDataLossDetection$11(TierTopicManager eta$0$2$1) {
        return eta$0$2$1.isReadyForWrites();
    }

    public static final /* synthetic */ String $anonfun$testTierTopicDataLossDetection$12() {
        return "timed out waiting for TierTopicManager to be ready";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testTierTopicDataLossDetection$10(KafkaBroker broker) {
        TierTopicManager tierTopicManager = (TierTopicManager)broker.tierTopicManagerOpt().get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 300000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!tierTopicManager.isReadyForWrites()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"timed out waiting for TierTopicManager to be ready");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertFalse((boolean)broker.logManager().hadCleanShutdown());
        KafkaMetric metric = TierTestUtils$.MODULE$.getMetricValue(broker.metrics(), "TierTopicDataLossValidator", TierTopicDataLossValidatorMetrics.DataLossDetectionMetricGroup.metricName((ValidationSource)ValidationSource.UNCLEAN_RESTART_VALIDATION, (String)"DataLossDetected"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)metric.metricValue());
    }

    public static final /* synthetic */ boolean $anonfun$testTierTopicDataLossDetection$14(KafkaBroker broker$2, TopicPartition userTopicPartition$1) {
        boolean x$12;
        LogManager qual$3 = broker$2.logManager();
        Option partitionState = qual$3.getLog(userTopicPartition$1, x$12 = qual$3.getLog$default$2()).map((Function1 & Serializable)x$3 -> x$3.tierPartitionState());
        return partitionState.isDefined() && ((TierPartitionState)partitionState.get()).topicIdPartition().isPresent() && ((TierPartitionState)partitionState.get()).tierEpoch() > 0;
    }

    public static final /* synthetic */ String $anonfun$testTierTopicDataLossDetection$16() {
        return "New initLeader event not materialized.";
    }

    public static final /* synthetic */ boolean $anonfun$testTierTopicDataLossDetection$17(KafkaBroker broker$2, TopicPartition userTopicPartition$1) {
        LogManager qual$4 = broker$2.logManager();
        boolean x$14 = qual$4.getLog$default$2();
        TierPartitionStatus tierPartitionStatus = ((AbstractLog)qual$4.getLog(userTopicPartition$1, x$14).get()).tierPartitionState().status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
    }

    public static final /* synthetic */ String $anonfun$testTierTopicDataLossDetection$18() {
        return "FTPS status is not online.";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testTierTopicDataLossDetection$13(TopicPartition userTopicPartition$1, KafkaBroker broker) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetection$14(broker, userTopicPartition$1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"New initLeader event not materialized.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetection$17(broker, userTopicPartition$1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"FTPS status is not online.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ void $anonfun$testTierTopicDataLossDetection$19(KafkaBroker broker) {
        String logDir = (String)broker.config().logDirs().last();
        Assertions.assertTrue((boolean)Files.deleteIfExists(new File(logDir, ".kafka_cleanshutdown").toPath()));
        File tierTopicPartitionDir = new File(new StringBuilder(24).append(logDir).append("/").append("_confluent-tier-state").append("-0").toString());
        long offsetIndexFile_offset = 0L;
        Assertions.assertTrue((boolean)Files.deleteIfExists(LogFileUtils.offsetIndexFile((File)tierTopicPartitionDir, (long)offsetIndexFile_offset, (String)"").toPath()));
        long timeIndexFile_offset = 0L;
        Assertions.assertTrue((boolean)Files.deleteIfExists(LogFileUtils.timeIndexFile((File)tierTopicPartitionDir, (long)timeIndexFile_offset, (String)"").toPath()));
        long logFile_offset = 0L;
        Assertions.assertTrue((boolean)Files.deleteIfExists(LogFileUtils.logFile((File)tierTopicPartitionDir, (long)logFile_offset, (String)"").toPath()));
    }

    public static final /* synthetic */ boolean $anonfun$testTierTopicDataLossDetection$21(TierTopicManager eta$0$3$1) {
        return eta$0$3$1.isReady();
    }

    public static final /* synthetic */ String $anonfun$testTierTopicDataLossDetection$22() {
        return "timed out waiting for TierTopicManager to be ready";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testTierTopicDataLossDetection$20(KafkaBroker broker) {
        TierTopicManager tierTopicManager = (TierTopicManager)broker.tierTopicManagerOpt().get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 300000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!tierTopicManager.isReady()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"timed out waiting for TierTopicManager to be ready");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        KafkaMetric metric = TierTestUtils$.MODULE$.getMetricValue(broker.metrics(), "TierTopicDataLossValidator", TierTopicDataLossValidatorMetrics.DataLossDetectionMetricGroup.metricName((ValidationSource)ValidationSource.UNCLEAN_RESTART_VALIDATION, (String)"DataLossDetected"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)metric.metricValue());
    }

    public static final /* synthetic */ void $anonfun$testTierTopicDataLossDetection$23(TopicPartition userTopicPartition$1, IntRef numFencingEvents$1, ConsumerRecord record) {
        Optional eventOpt = AbstractTierMetadata.deserialize((byte[])((byte[])record.key()), (byte[])((byte[])record.value()), (long)record.timestamp());
        Assertions.assertTrue((boolean)eventOpt.isPresent());
        if (TierRecordType.PartitionFence.equals(((AbstractTierMetadata)eventOpt.get()).type()) && userTopicPartition$1.equals((Object)((AbstractTierMetadata)eventOpt.get()).topicIdPartition().topicPartition())) {
            ++numFencingEvents$1.elem;
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testTierTopicDataLossDetectionMaxTimeoutMs$2(int brokerId$1, KafkaServer server) {
        return server.config().brokerId() == brokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testTierTopicDataLossDetectionMaxTimeoutMs$5(long newTierTopicDataLossDetectionMaxTimeoutMs$1, TierTopicDataLossValidator validator) {
        return validator.dataLossDetectionMaxTimeoutMs() == newTierTopicDataLossDetectionMaxTimeoutMs$1;
    }

    public static final /* synthetic */ boolean $anonfun$testTierTopicDataLossDetectionMaxTimeoutMs$4(KafkaServer server$1, long newTierTopicDataLossDetectionMaxTimeoutMs$1) {
        return server$1.tierTopicDataLossValidatorOpt().exists((Function1 & Serializable)validator -> BoxesRunTime.boxToBoolean((boolean)TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetectionMaxTimeoutMs$5(newTierTopicDataLossDetectionMaxTimeoutMs$1, validator)));
    }

    public static final /* synthetic */ String $anonfun$testTierTopicDataLossDetectionMaxTimeoutMs$6() {
        return new StringBuilder(19).append(KafkaConfig$.MODULE$.TierTopicDataLossDetectionMaxTimeoutMsProp()).append(" propagation failed").toString();
    }

    public static final /* synthetic */ void $anonfun$testTierTopicDataLossDetectionMaxTimeoutMs$3(long newTierTopicDataLossDetectionMaxTimeoutMs$1, KafkaServer server) {
        long x$4 = 15000L;
        long waitUntilTrue_pause = 2000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetectionMaxTimeoutMs$4(server, newTierTopicDataLossDetectionMaxTimeoutMs$1)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + x$4) {
                Assertions.fail((String)TierTopicDataLossValidatorIntegrationTest.$anonfun$testTierTopicDataLossDetectionMaxTimeoutMs$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$4), waitUntilTrue_pause));
        }
    }

    public TierTopicDataLossValidatorIntegrationTest() {
        this.numBrokers = 3;
        this.tierMetadataPartitions = 1;
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), Short.toString(this.tierMetadataPartitions()));
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "3");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierTopicFencingDuringDataLossEnableProp(), "true");
    }
}

