/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import kafka.api.IntegrationTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.tier.TierTopicDeletionIntegrationTest$;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.utils.CoreUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.IndexedSeq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\u0005ec\u0001\u0002\f\u0018\u0001qAQa\t\u0001\u0005\u0002\u0011BQa\n\u0001\u0005R!Bqa\f\u0001C\u0002\u0013%\u0001\u0007\u0003\u0004:\u0001\u0001\u0006I!\r\u0005\bu\u0001\u0011\r\u0011\"\u0003)\u0011\u0019Y\u0004\u0001)A\u0005S!9A\b\u0001b\u0001\n\u0013A\u0003BB\u001f\u0001A\u0003%\u0011\u0006C\u0004?\u0001\t\u0007I\u0011B \t\r)\u0003\u0001\u0015!\u0003A\u0011%Y\u0005\u00011AA\u0002\u0013%A\nC\u0005Y\u0001\u0001\u0007\t\u0019!C\u00053\"Iq\f\u0001a\u0001\u0002\u0003\u0006K!\u0014\u0005\u0006A\u0002!\t%\u0019\u0005\u0006O\u0002!I\u0001\u001b\u0005\u0006]\u0002!\te\u001c\u0005\u0006i\u0002!\t!^\u0004\b\u0003o9\u0002\u0012AA\u001d\r\u00191r\u0003#\u0001\u0002<!11e\u0005C\u0001\u0003\u0007Bq!!\u000b\u0014\t\u0003\t)E\u0001\u0011US\u0016\u0014Hk\u001c9jG\u0012+G.\u001a;j_:Le\u000e^3he\u0006$\u0018n\u001c8UKN$(B\u0001\r\u001a\u0003\u0011!\u0018.\u001a:\u000b\u0003i\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001;A\u0011a$I\u0007\u0002?)\u0011\u0001%G\u0001\u0004CBL\u0017B\u0001\u0012 \u0005YIe\u000e^3he\u0006$\u0018n\u001c8UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001&!\t1\u0003!D\u0001\u0018\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0016\u0003%\u0002\"AK\u0017\u000e\u0003-R\u0011\u0001L\u0001\u0006g\u000e\fG.Y\u0005\u0003]-\u00121!\u00138u\u0003\u0015!x\u000e]5d+\u0005\t\u0004C\u0001\u001a8\u001b\u0005\u0019$B\u0001\u001b6\u0003\u0011a\u0017M\\4\u000b\u0003Y\nAA[1wC&\u0011\u0001h\r\u0002\u0007'R\u0014\u0018N\\4\u0002\rQ|\u0007/[2!\u00035qW/\u001c)beRLG/[8og\u0006qa.^7QCJ$\u0018\u000e^5p]N\u0004\u0013a\u00038v[J+\u0007\u000f\\5dCN\fAB\\;n%\u0016\u0004H.[2bg\u0002\na!\u001a=ji\u0016$W#\u0001!\u0011\u0005\u0005CU\"\u0001\"\u000b\u0005\r#\u0015AB1u_6L7M\u0003\u0002F\r\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\u001d+\u0014\u0001B;uS2L!!\u0013\"\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003\u001d)\u00070\u001b;fI\u0002\n\u0001\u0002^3ti&sgm\\\u000b\u0002\u001bB\u0011aJV\u0007\u0002\u001f*\u0011\u0001\u0005\u0015\u0006\u0003#J\u000bqA[;qSR,'O\u0003\u0002T)\u0006)!.\u001e8ji*\tQ+A\u0002pe\u001eL!aV(\u0003\u0011Q+7\u000f^%oM>\fA\u0002^3ti&sgm\\0%KF$\"AW/\u0011\u0005)Z\u0016B\u0001/,\u0005\u0011)f.\u001b;\t\u000fyc\u0011\u0011!a\u0001\u001b\u0006\u0019\u0001\u0010J\u0019\u0002\u0013Q,7\u000f^%oM>\u0004\u0013!B:fiV\u0003HC\u0001.c\u0011\u0015Ye\u00021\u0001NQ\tqA\r\u0005\u0002OK&\u0011am\u0014\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017!I:fiNs\u0017\r]:i_R\u001cuN\u001c4jO\u0006sGmQ8na2,G/Z*fiV\u0004HC\u0001.j\u0011\u0015Qw\u00021\u0001l\u0003)\"\u0018.\u001a:U_BL7-T1uKJL\u0017\r\\5{CRLwN\u001c$s_6\u001cf.\u00199tQ>$XI\\1cY\u0016\u0004\"A\u000b7\n\u00055\\#a\u0002\"p_2,\u0017M\\\u0001\ti\u0016\f'\u000fR8x]R\t!\f\u000b\u0002\u0011cB\u0011aJ]\u0005\u0003g>\u0013\u0011\"\u00114uKJ,\u0015m\u00195\u0002#Q,7\u000f\u001e+pa&\u001cG)\u001a7fi&|g\u000eF\u0002[m^DQA[\tA\u0002-DQ\u0001_\tA\u0002e\fa!];peVl\u0007c\u0001>\u0002\u00049\u00111p \t\u0003y.j\u0011! \u0006\u0003}n\ta\u0001\u0010:p_Rt\u0014bAA\u0001W\u00051\u0001K]3eK\u001aL1\u0001OA\u0003\u0015\r\t\ta\u000b\u0015\u0004#\u0005%\u0001\u0003BA\u0006\u0003#i!!!\u0004\u000b\u0007\u0005=\u0001+\u0001\u0004qCJ\fWn]\u0005\u0005\u0003'\tiAA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgRDs!EA\f\u0003G\t)\u0003\u0005\u0003\u0002\u001a\u0005}QBAA\u000e\u0015\u0011\ti\"!\u0004\u0002\u0011A\u0014xN^5eKJLA!!\t\u0002\u001c\taQ*\u001a;i_\u0012\u001cv.\u001e:dK\u0006)a/\u00197vK2\u0012\u0011qE\u0011\u0003\u0003S\tQeZ3oKJ\fG/\u001a\"p_2,\u0017M\\\"p[\nLg.\u0019;j_:\u001cx+\u001b;i#V|'/^7)\u000f\u0001\ti#a\t\u00024A\u0019a*a\f\n\u0007\u0005ErJA\u0002UC\u001e\f#!!\u000e\u0002\u0017%tG/Z4sCRLwN\\\u0001!)&,'\u000fV8qS\u000e$U\r\\3uS>t\u0017J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000f\u0005\u0002''M\u00191#!\u0010\u0011\u0007)\ny$C\u0002\u0002B-\u0012a!\u00118z%\u00164GCAA\u001d+\t\t9\u0005\u0005\u0004\u0002J\u0005=\u00131K\u0007\u0003\u0003\u0017R1!!\u0014G\u0003\u0019\u0019HO]3b[&!\u0011\u0011KA&\u0005\u0019\u0019FO]3b[B!\u0011\u0011DA+\u0013\u0011\t9&a\u0007\u0003\u0013\u0005\u0013x-^7f]R\u001c\b")
public class TierTopicDeletionIntegrationTest
extends IntegrationTestHarness {
    private final String topic;
    private final int numPartitions;
    private final int numReplicas;
    private final AtomicBoolean exited = new AtomicBoolean(false);
    private TestInfo testInfo;

    public static Stream<Arguments> generateBooleanCombinationsWithQuorum() {
        return TierTopicDeletionIntegrationTest$.MODULE$.generateBooleanCombinationsWithQuorum();
    }

    @Override
    public int brokerCount() {
        return 3;
    }

    private String topic() {
        return this.topic;
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    private int numReplicas() {
        return this.numReplicas;
    }

    private AtomicBoolean exited() {
        return this.exited;
    }

    private TestInfo testInfo() {
        return this.testInfo;
    }

    private void testInfo_$eq(TestInfo x$1) {
        this.testInfo = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        Exit.setExitProcedure((x$2, x$3) -> this.exited().set(true));
        this.testInfo_$eq(testInfo);
    }

    private void setSnapshotConfigAndCompleteSetup(boolean tierTopicMaterializationFromSnapshotEnable) {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierTopicMaterializationFromSnapshotEnableProp(), Boolean.toString(tierTopicMaterializationFromSnapshotEnable));
        super.setUp(this.testInfo());
        this.createTopic(this.topic(), this.numPartitions(), this.numReplicas(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        Assertions.assertFalse((boolean)this.exited().get());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @MethodSource(value={"generateBooleanCombinationsWithQuorum"})
    public void testTopicDeletion(boolean tierTopicMaterializationFromSnapshotEnable, String quorum) {
        this.setSnapshotConfigAndCompleteSetup(tierTopicMaterializationFromSnapshotEnable);
        IndexedSeq records = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions()).map((Function1 & Serializable)i -> TierTopicDeletionIntegrationTest.$anonfun$testTopicDeletion$1(this, BoxesRunTime.unboxToInt((Object)i)));
        int recordSize = ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.byteArrayOps((byte[])((ProducerRecord)records.head()).key())) + ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.byteArrayOps((byte[])((ProducerRecord)records.head()).value()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        for (int bytesSent = 0; bytesSent < 200; bytesSent += recordSize) {
            records.foreach((Function1 & Serializable)record -> (RecordMetadata)producer.send(record).get());
        }
        MockInMemoryTierObjectStore mockObjectStore = (MockInMemoryTierObjectStore)((KafkaBroker)this.brokers().head()).tierObjectStoreOpt().get();
        ObjectRef topicId = ObjectRef.create(null);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            TopicPartition topicPartition = new TopicPartition(this.topic(), i);
            int leaderBrokerId = ((PartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(producer.partitionsFor(this.topic())).asScala().find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TierTopicDeletionIntegrationTest.$anonfun$testTopicDeletion$4(i, x$4))).get()).leader().id();
            LogManager qual$1 = ((KafkaBroker)this.brokers().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TierTopicDeletionIntegrationTest.$anonfun$testTopicDeletion$5(leaderBrokerId, x$5))).get()).logManager();
            boolean x$2 = qual$1.getLog$default$2();
            TierPartitionState tierPartitionState = ((AbstractLog)qual$1.getLog(topicPartition, x$2).get()).tierPartitionState();
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TierTopicDeletionIntegrationTest.$anonfun$testTopicDeletion$6(tierPartitionState)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Timed out waiting for segments to be tiered");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 15000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!TierTopicDeletionIntegrationTest.$anonfun$testTopicDeletion$8(tierPartitionState)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)"Timed out waiting for tier partition state to be flushed");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            topicId$1.elem = CoreUtils$.MODULE$.uuidToBase64(((TopicIdPartition)tierPartitionState.topicIdPartition().get()).topicId());
        });
        if (tierTopicMaterializationFromSnapshotEnable) {
            this.waitUntilFtpsSnapshotUploaded((String)topicId.elem, this.waitUntilFtpsSnapshotUploaded$default$2());
        }
        Assertions.assertTrue((CollectionConverters$.MODULE$.ListHasAsScala(mockObjectStore.getStoredKeys()).asScala().count((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.contains((String)topicId$1.elem))) >= this.numPartitions() ? 1 : 0) != 0);
        this.createConfluentAdminClient(this.createConfluentAdminClient$default$1()).deleteTopics(Collections.singleton(this.topic())).all().get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 20000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!(CollectionConverters$.MODULE$.ListHasAsScala(mockObjectStore.getStoredKeys()).asScala().count((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.contains((String)topicId$1.elem))) == 0)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for all objects to be deleted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ ProducerRecord $anonfun$testTopicDeletion$1(TierTopicDeletionIntegrationTest $this, int i) {
        return new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(i), (Object)"key".getBytes(), (Object)"value".getBytes());
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletion$4(int i$1, PartitionInfo x$4) {
        return x$4.partition() == i$1;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletion$5(int leaderBrokerId$1, KafkaBroker x$5) {
        return x$5.config().brokerId() == leaderBrokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletion$6(TierPartitionState tierPartitionState$1) {
        return tierPartitionState$1.totalSize() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testTopicDeletion$7() {
        return "Timed out waiting for segments to be tiered";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletion$8(TierPartitionState tierPartitionState$1) {
        return tierPartitionState$1.committedEndOffset() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testTopicDeletion$9() {
        return "Timed out waiting for tier partition state to be flushed";
    }

    private static final int numObjects$1(MockInMemoryTierObjectStore mockObjectStore$1, ObjectRef topicId$1) {
        return CollectionConverters$.MODULE$.ListHasAsScala(mockObjectStore$1.getStoredKeys()).asScala().count((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.contains((String)topicId$1.elem)));
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletion$11(MockInMemoryTierObjectStore mockObjectStore$1, ObjectRef topicId$1) {
        return CollectionConverters$.MODULE$.ListHasAsScala(mockObjectStore$1.getStoredKeys()).asScala().count((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.contains((String)topicId$1.elem))) == 0;
    }

    public static final /* synthetic */ String $anonfun$testTopicDeletion$12() {
        return "Timed out waiting for all objects to be deleted";
    }

    public TierTopicDeletionIntegrationTest() {
        this.topic = "foo";
        this.numPartitions = 4;
        this.numReplicas = 2;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "2");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "2");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierTopicDeleteCheckIntervalMsProp(), "10");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierTopicDeleteBackoffMsProp(), "15000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "10");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "10000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.LogSegmentBytesProp(), "1000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.LogFlushSchedulerIntervalMsProp(), "10");
        Predef$.MODULE$.locally(this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierPartitionStateMetadataSnapshotsEnableProp(), "true"));
    }
}

