/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import kafka.server.Defaults$;
import kafka.tier.TierTopicManagerCommitter;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.topic.TierTopicManagerConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u001d3A\u0001D\u0007\u0001%!)\u0011\u0004\u0001C\u00015!)Q\u0004\u0001C\u0001=!)Q\u0005\u0001C\u0001M!)q\u0007\u0001C\u0001M!)\u0011\b\u0001C\u0001M!)1\b\u0001C\u0001M!)Q\b\u0001C\u0001M!)q\b\u0001C\u0001M!)\u0011\t\u0001C\u0001M!)1\t\u0001C\u0001M!)Q\t\u0001C\u0001M\tiB+[3s)>\u0004\u0018nY'b]\u0006<WM]\"p[6LG\u000f^3s)\u0016\u001cHO\u0003\u0002\u000f\u001f\u0005!A/[3s\u0015\u0005\u0001\u0012!B6bM.\f7\u0001A\n\u0003\u0001M\u0001\"\u0001F\f\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u000e\u0003)!W/\\7z\u000bZ,g\u000e^\u000b\u0002?A\u0011\u0001eI\u0007\u0002C)\u0011!%D\u0001\u0007I>l\u0017-\u001b8\n\u0005\u0011\n#\u0001F!cgR\u0014\u0018m\u0019;US\u0016\u0014X*\u001a;bI\u0006$\u0018-\u0001\nfCJd\u0017.Z:u\u001f\u001a47/\u001a;UKN$H#A\u0014\u0011\u0005QA\u0013BA\u0015\u0016\u0005\u0011)f.\u001b;)\u0005\rY\u0003C\u0001\u00176\u001b\u0005i#B\u0001\u00180\u0003\r\t\u0007/\u001b\u0006\u0003aE\nqA[;qSR,'O\u0003\u00023g\u0005)!.\u001e8ji*\tA'A\u0002pe\u001eL!AN\u0017\u0003\tQ+7\u000f^\u0001\u0014_\u001a47/\u001a;J]>sWMT8u\u001fRDWM\u001d\u0015\u0003\t-\nAc\u001c4gg\u0016$8/R7qifLen\u00148f\t&\u0014\bFA\u0003,\u0003Q\u0011X-\u00193PM\u001a\u001cX\r^:U_\nKH/\u001a\"vM\"\u0012aaK\u0001\u000eoJLG/\u001a*fC\u0012$Vm\u001d;)\u0005\u001dY\u0013!I;ogV\u0004\bo\u001c:uK\u00124VM]:j_:\u0014Vm]3ugB{7/\u001b;j_:\u001c\bF\u0001\u0005,\u0003uIgN^1mS\u00124VM]:j_:\u0014Vm]3ugB{7/\u001b;j_:\u001c\bFA\u0005,\u0003mIgN^1mS\u0012|eMZ:fiNd\u0015N\\3Q_NLG/[8og\"\u0012!bK\u0001\u0013i\u0016\u001cH/\u00169eCR,\u0007k\\:ji&|g\u000e\u000b\u0002\fW\u0001")
public class TierTopicManagerCommitterTest {
    public AbstractTierMetadata dummyEvent() {
        return new TierTopicInitLeader(new TopicIdPartition("dummy", UUID.randomUUID(), 0), 9, UUID.randomUUID(), 0);
    }

    @Test
    public void earliestOffsetTest() {
        Map<Integer, OffsetAndEpoch> positions1 = Collections.singletonMap(3, new OffsetAndEpoch(5L, Optional.of(Predef$.MODULE$.int2Integer(3))));
        Map<Integer, OffsetAndEpoch> positions2 = Collections.singletonMap(3, new OffsetAndEpoch(2L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        Assertions.assertEquals((Object)new OffsetAndEpoch(2L, Optional.of(Predef$.MODULE$.int2Integer(1))), TierTopicManagerCommitter.earliestOffsets(Arrays.asList(positions1, positions2)).get(BoxesRunTime.boxToInteger((int)3)));
        Assertions.assertEquals((Object)new OffsetAndEpoch(2L, Optional.of(Predef$.MODULE$.int2Integer(1))), TierTopicManagerCommitter.earliestOffsets(Arrays.asList(positions2, positions1)).get(BoxesRunTime.boxToInteger((int)3)));
    }

    @Test
    public void offsetInOneNotOther() {
        Map<Integer, OffsetAndEpoch> positions1 = Collections.singletonMap(2, new OffsetAndEpoch(5L, Optional.of(Predef$.MODULE$.int2Integer(2))));
        Map<Integer, OffsetAndEpoch> positions2 = Collections.singletonMap(3, new OffsetAndEpoch(5L, Optional.of(Predef$.MODULE$.int2Integer(3))));
        Assertions.assertTrue((boolean)TierTopicManagerCommitter.earliestOffsets(Arrays.asList(positions1, positions2)).isEmpty(), (String)"Overall offset positions not reset, even though positions were missing.");
    }

    @Test
    public void offsetsEmptyInOneDir() {
        Map positions1 = Collections.emptyMap();
        Map<Integer, OffsetAndEpoch> positions2 = Collections.singletonMap(3, new OffsetAndEpoch(5L, Optional.empty()));
        Assertions.assertTrue((boolean)TierTopicManagerCommitter.earliestOffsets(Arrays.asList(positions1, positions2)).isEmpty(), (String)"Overall offset positions not reset, even though positions were missing.");
    }

    @Test
    public void readOffsetsToByteBuf() {
        String logDir = new StringBuilder(1).append(System.getProperty("java.io.tmpdir")).append("/").append(UUID.randomUUID().toString()).toString();
        new File(logDir).mkdir();
        short numPartitions = 6;
        TierTopicManagerConfig tierTopicManagerConfig = new TierTopicManagerConfig(() -> Collections.singletonMap("bootstrap.servers", "bootstrap"), null, numPartitions, 1, 33, "cluster99", Predef$.MODULE$.long2Long(200L), Predef$.MODULE$.int2Integer(500), Predef$.MODULE$.int2Integer(500), Predef$.MODULE$.long2Long(-1L), Collections.singletonList(logDir), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicProducerEnableIdempotence()), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicDataLossDetectionEnable()), Defaults$.MODULE$.TierTopicDataLossDetectionMaxTimeoutMs(), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicFencingDuringDataLossEnable()), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicMaterializationFromSnapshotEnable()));
        TierTopicManagerCommitter committer = new TierTopicManagerCommitter(tierTopicManagerConfig, (LogDirFailureChannel)Mockito.mock(LogDirFailureChannel.class));
        committer.updatePosition(3, new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(1))), this.dummyEvent());
        committer.updatePosition(5, new OffsetAndEpoch(4L, Optional.of(Predef$.MODULE$.int2Integer(2))), this.dummyEvent());
        committer.updatePosition(5, new OffsetAndEpoch(5L, Optional.empty()), this.dummyEvent());
        committer.writePositionsSnapshot(committer.takePositionsSnapshot());
        Map offsetsToByteBuf = committer.readOffsetsForLogDirsToByteBuf();
        Assertions.assertEquals((Object)ByteBuffer.wrap(Files.readAllBytes(Paths.get(new StringBuilder(13).append(logDir).append("/tier.offsets").toString(), new String[0]))), offsetsToByteBuf.get(logDir));
    }

    @Test
    public void writeReadTest() {
        String logDir = new StringBuilder(1).append(System.getProperty("java.io.tmpdir")).append("/").append(UUID.randomUUID().toString()).toString();
        new File(logDir).mkdir();
        short numPartitions = 6;
        TierTopicManagerConfig tierTopicManagerConfig = new TierTopicManagerConfig(() -> Collections.singletonMap("bootstrap.servers", "bootstrap"), null, numPartitions, 1, 33, "cluster99", Predef$.MODULE$.long2Long(200L), Predef$.MODULE$.int2Integer(500), Predef$.MODULE$.int2Integer(500), Predef$.MODULE$.long2Long(-1L), Collections.singletonList(logDir), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicProducerEnableIdempotence()), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicDataLossDetectionEnable()), Defaults$.MODULE$.TierTopicDataLossDetectionMaxTimeoutMs(), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicFencingDuringDataLossEnable()), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicMaterializationFromSnapshotEnable()));
        TierTopicManagerCommitter committer = new TierTopicManagerCommitter(tierTopicManagerConfig, (LogDirFailureChannel)Mockito.mock(LogDirFailureChannel.class));
        committer.updatePosition(3, new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(1))), this.dummyEvent());
        committer.updatePosition(5, new OffsetAndEpoch(4L, Optional.of(Predef$.MODULE$.int2Integer(2))), this.dummyEvent());
        committer.updatePosition(5, new OffsetAndEpoch(5L, Optional.empty()), this.dummyEvent());
        committer.writePositionsSnapshot(committer.takePositionsSnapshot());
        TierTopicManagerCommitter committer2 = new TierTopicManagerCommitter(tierTopicManagerConfig, (LogDirFailureChannel)Mockito.mock(LogDirFailureChannel.class));
        Option[] expectedPositions = new Option[]{None$.MODULE$, None$.MODULE$, None$.MODULE$, new Some((Object)new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(1)))), None$.MODULE$, new Some((Object)new OffsetAndEpoch(5L, Optional.empty()))};
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), (int)numPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partitionId -> Assertions.assertEquals((Object)expectedPositions[partitionId].getOrElse((Function0 & Serializable)() -> null), (Object)committer2.positionFor(partitionId)));
    }

    @Test
    public void unsupportedVersionResetsPositions() {
        File testDir = TestUtils.tempDirectory(null, null);
        File file = new File(new StringBuilder(13).append(testDir.getAbsolutePath()).append("/tier.offsets").toString());
        try (FileWriter fileWriter = new FileWriter(file);){
            BufferedWriter write = new BufferedWriter(fileWriter);
            try {
                write.write(Integer.toString(TierTopicManagerCommitter.CURRENT_VERSION.version + 1));
                write.newLine();
                write.write("0 3");
                write.newLine();
            }
            finally {
                write.flush();
                write.close();
            }
        }
        Assertions.assertTrue((boolean)TierTopicManagerCommitter.readCommittedOffsetsForLogDirIgnoreException((String)testDir.getAbsolutePath(), (LogDirFailureChannel)((LogDirFailureChannel)Mockito.mock(LogDirFailureChannel.class))).isEmpty());
    }

    @Test
    public void invalidVersionResetsPositions() {
        File testDir = TestUtils.tempDirectory(null, null);
        File file = new File(new StringBuilder(13).append(testDir.getAbsolutePath()).append("/tier.offsets").toString());
        try (FileWriter fileWriter = new FileWriter(file);){
            BufferedWriter write = new BufferedWriter(fileWriter);
            try {
                write.write("aaa");
                write.newLine();
                write.write("0 3");
                write.newLine();
            }
            finally {
                write.flush();
                write.close();
            }
        }
        Assertions.assertTrue((boolean)TierTopicManagerCommitter.readCommittedOffsetsForLogDirIgnoreException((String)testDir.getAbsolutePath(), (LogDirFailureChannel)((LogDirFailureChannel)Mockito.mock(LogDirFailureChannel.class))).isEmpty());
    }

    @Test
    public void invalidOffsetsLinePositions() {
        File testDir = TestUtils.tempDirectory(null, null);
        File file = new File(new StringBuilder(13).append(testDir.getAbsolutePath()).append("/tier.offsets").toString());
        try (FileWriter fileWriter = new FileWriter(file);){
            BufferedWriter write = new BufferedWriter(fileWriter);
            try {
                write.write("0");
                write.newLine();
                write.write("3");
                write.newLine();
                write.write("0 5");
            }
            finally {
                write.flush();
                write.close();
            }
        }
        Assertions.assertTrue((boolean)TierTopicManagerCommitter.readCommittedOffsetsForLogDirIgnoreException((String)testDir.getAbsolutePath(), (LogDirFailureChannel)((LogDirFailureChannel)Mockito.mock(LogDirFailureChannel.class))).isEmpty());
    }

    @Test
    public void testUpdatePosition() {
        String logDir = TestUtils.tempDirectory(null, null).getAbsolutePath();
        new File(logDir).mkdir();
        short numPartitions = 6;
        TierTopicManagerConfig tierTopicManagerConfig = new TierTopicManagerConfig(() -> Collections.singletonMap("bootstrap.servers", "bootstrap"), null, numPartitions, 1, 33, "cluster99", Predef$.MODULE$.long2Long(200L), Predef$.MODULE$.int2Integer(500), Predef$.MODULE$.int2Integer(500), Predef$.MODULE$.long2Long(-1L), Collections.singletonList(logDir), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicProducerEnableIdempotence()), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicDataLossDetectionEnable()), Defaults$.MODULE$.TierTopicDataLossDetectionMaxTimeoutMs(), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicFencingDuringDataLossEnable()), Predef$.MODULE$.boolean2Boolean(Defaults$.MODULE$.TierTopicMaterializationFromSnapshotEnable()));
        int partitionId = 10;
        TierTopicManagerCommitter committer = new TierTopicManagerCommitter(tierTopicManagerConfig, (LogDirFailureChannel)Mockito.mock(LogDirFailureChannel.class));
        committer.updatePosition(partitionId, new OffsetAndEpoch(100L, Optional.of(Predef$.MODULE$.int2Integer(5))), this.dummyEvent());
        committer.updatePosition(partitionId, new OffsetAndEpoch(200L, Optional.of(Predef$.MODULE$.int2Integer(5))), this.dummyEvent());
        Assertions.assertEquals((Object)new OffsetAndEpoch(200L, Optional.of(Predef$.MODULE$.int2Integer(5))), (Object)committer.positionFor(partitionId));
        committer.updatePosition(partitionId, new OffsetAndEpoch(350L, Optional.of(Predef$.MODULE$.int2Integer(7))), this.dummyEvent());
        Assertions.assertEquals((Object)new OffsetAndEpoch(350L, Optional.of(Predef$.MODULE$.int2Integer(7))), (Object)committer.positionFor(partitionId));
        committer.updatePosition(partitionId, new OffsetAndEpoch(375L, Optional.empty()), this.dummyEvent());
        Assertions.assertEquals((Object)new OffsetAndEpoch(375L, Optional.empty()), (Object)committer.positionFor(partitionId));
        committer.updatePosition(partitionId, new OffsetAndEpoch(400L, Optional.of(Predef$.MODULE$.int2Integer(10))), this.dummyEvent());
        Assertions.assertEquals((Object)new OffsetAndEpoch(400L, Optional.of(Predef$.MODULE$.int2Integer(10))), (Object)committer.positionFor(partitionId));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> committer.updatePosition(partitionId, new OffsetAndEpoch(400L, Optional.of(Predef$.MODULE$.int2Integer(10))), this.dummyEvent()), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("TierTopicManagerCommitterTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> committer.updatePosition(partitionId, new OffsetAndEpoch(399L, Optional.of(Predef$.MODULE$.int2Integer(10))), this.dummyEvent()), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("TierTopicManagerCommitterTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> committer.updatePosition(partitionId, new OffsetAndEpoch(500L, Optional.of(Predef$.MODULE$.int2Integer(9))), this.dummyEvent()), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("TierTopicManagerCommitterTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
        Assertions.assertEquals((Object)new OffsetAndEpoch(400L, Optional.of(Predef$.MODULE$.int2Integer(10))), (Object)committer.positionFor(partitionId));
    }
}

