/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.Serializable;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kafka.api.IntegrationTestHarness;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.ActionQueue;
import kafka.server.Defaults$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal;
import kafka.tier.TopicIdPartition;
import kafka.tier.client.TierTopicProducerSupplier;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.OpaqueData;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicManager;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.ProducerStateEntry;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.opentest4j.AssertionFailedError;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\t]a\u0001B\u0010!\u0001\u0015BQ\u0001\f\u0001\u0005\u00025Bq\u0001\r\u0001C\u0002\u0013%\u0011\u0007\u0003\u00049\u0001\u0001\u0006IA\r\u0005\bs\u0001\u0011\r\u0011\"\u0003;\u0011\u0019\u0019\u0005\u0001)A\u0005w!9A\t\u0001b\u0001\n\u0013\t\u0004BB#\u0001A\u0003%!\u0007C\u0004G\u0001\t\u0007I\u0011B$\t\rM\u0003\u0001\u0015!\u0003I\u0011\u001d!\u0006A1A\u0005\n\u001dCa!\u0016\u0001!\u0002\u0013A\u0005b\u0002,\u0001\u0005\u0004%Ia\u0016\u0005\u0007=\u0002\u0001\u000b\u0011\u0002-\t\u000f}\u0003!\u0019!C\u0005A\"1q\r\u0001Q\u0001\n\u0005D\u0011\u0002\u001b\u0001A\u0002\u0003\u0007I\u0011B5\t\u0013]\u0004\u0001\u0019!a\u0001\n\u0013A\b\"\u0003@\u0001\u0001\u0004\u0005\t\u0015)\u0003k\u0011\u0015y\b\u0001\"\u00152\u0011\u001d\t\t\u0001\u0001C!\u0003\u0007Aq!!\u0006\u0001\t\u0003\n9\u0002C\u0004\u00028\u0001!\t%!\u000f\t\u000f\u0005\r\u0003\u0001\"\u0001\u0002F!9\u0011Q\u0012\u0001\u0005\u0002\u0005=\u0005bBAM\u0001\u0011\u0005\u00111\u0014\u0005\b\u0003K\u0003A\u0011AAT\u0011\u001d\tI\r\u0001C\u0001\u0003OCq!a3\u0001\t\u0003\ti\rC\u0004\u0002x\u0002!I!!?\t\u000f\u0005}\b\u0001\"\u0003\u0003\u0002\t\tD+[3s)>\u0004\u0018nY'b]\u0006<WM]%eK6\u0004x\u000e^3oiB\u0013x\u000eZ;dKJLe\u000e^3he\u0006$\u0018n\u001c8UKN$(BA\u0011#\u0003\u0011!\u0018.\u001a:\u000b\u0003\r\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001MA\u0011qEK\u0007\u0002Q)\u0011\u0011FI\u0001\u0004CBL\u0017BA\u0016)\u0005YIe\u000e^3he\u0006$\u0018n\u001c8UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001/!\ty\u0003!D\u0001!\u00031\u0019XmZ7f]R\u0014\u0015\u0010^3t+\u0005\u0011\u0004CA\u001a7\u001b\u0005!$\"A\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]\"$aA%oi\u0006i1/Z4nK:$()\u001f;fg\u0002\n\u0011\u0002^8qS\u000et\u0015-\\3\u0016\u0003m\u0002\"\u0001P!\u000e\u0003uR!AP \u0002\t1\fgn\u001a\u0006\u0002\u0001\u0006!!.\u0019<b\u0013\t\u0011UH\u0001\u0004TiJLgnZ\u0001\u000bi>\u0004\u0018n\u0019(b[\u0016\u0004\u0013!\u0005:fa2L7-\u0019;j_:4\u0015m\u0019;pe\u0006\u0011\"/\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:!\u0003I)8/\u001a:U_BL7\rU1si&$\u0018n\u001c8\u0016\u0003!\u0003\"!S)\u000e\u0003)S!a\u0013'\u0002\r\r|W.\\8o\u0015\t\u0019SJ\u0003\u0002O\u001f\u00061\u0011\r]1dQ\u0016T\u0011\u0001U\u0001\u0004_J<\u0017B\u0001*K\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f1#^:feR{\u0007/[2QCJ$\u0018\u000e^5p]\u0002\n!\u0003^5feR{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u0019B/[3s)>\u0004\u0018n\u0019)beRLG/[8oA\u0005IA/[3s)>\u0004\u0018nY\u000b\u00021B\u0011\u0011\fX\u0007\u00025*\u00111\fI\u0001\u0006i>\u0004\u0018nY\u0005\u0003;j\u0013\u0011\u0002V5feR{\u0007/[2\u0002\u0015QLWM\u001d+pa&\u001c\u0007%A\u0007qe>$WoY3s!J|\u0007o]\u000b\u0002CB\u0011!-Z\u0007\u0002G*\u0011AmP\u0001\u0005kRLG.\u0003\u0002gG\nQ\u0001K]8qKJ$\u0018.Z:\u0002\u001dA\u0014x\u000eZ;dKJ\u0004&o\u001c9tA\u0005A\u0001O]8ek\u000e,'/F\u0001k!\u0011Yw.]9\u000e\u00031T!\u0001[7\u000b\u00059d\u0015aB2mS\u0016tGo]\u0005\u0003a2\u0014QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\bcA\u001asi&\u00111\u000f\u000e\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003gUL!A\u001e\u001b\u0003\t\tKH/Z\u0001\raJ|G-^2fe~#S-\u001d\u000b\u0003sr\u0004\"a\r>\n\u0005m$$\u0001B+oSRDq!`\t\u0002\u0002\u0003\u0007!.A\u0002yIE\n\u0011\u0002\u001d:pIV\u001cWM\u001d\u0011\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u0001\u000e[>$\u0017NZ=D_:4\u0017nZ:\u0015\u0007e\f)\u0001C\u0004\u0002\bQ\u0001\r!!\u0003\u0002\u000bA\u0014x\u000e]:\u0011\u000b\u0005-\u0011\u0011C1\u000e\u0005\u00055!bAA\bi\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005M\u0011Q\u0002\u0002\u0004'\u0016\f\u0018!B:fiV\u0003HcA=\u0002\u001a!9\u00111D\u000bA\u0002\u0005u\u0011\u0001\u0003;fgRLeNZ8\u0011\t\u0005}\u00111F\u0007\u0003\u0003CQ1!KA\u0012\u0015\u0011\t)#a\n\u0002\u000f),\b/\u001b;fe*\u0019\u0011\u0011F(\u0002\u000b),h.\u001b;\n\t\u00055\u0012\u0011\u0005\u0002\t)\u0016\u001cH/\u00138g_\"\u001aQ#!\r\u0011\t\u0005}\u00111G\u0005\u0005\u0003k\t\tC\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002s\"\u001aa#!\u0010\u0011\t\u0005}\u0011qH\u0005\u0005\u0003\u0003\n\tCA\u0005BMR,'/R1dQ\u0006)D/Z:u)&,'\u000fV8qS\u000eLE-Z7q_R,g\u000e\u001e)s_\u0012,8-\u001a:EkBd\u0017nY1uKN+\u0017/^3oG\u0016,%O]8s)\rI\u0018q\t\u0005\b\u0003\u0013:\u0002\u0019AA&\u0003\u0019\tXo\u001c:v[B!\u0011QJA.\u001d\u0011\ty%a\u0016\u0011\u0007\u0005EC'\u0004\u0002\u0002T)\u0019\u0011Q\u000b\u0013\u0002\rq\u0012xn\u001c;?\u0013\r\tI\u0006N\u0001\u0007!J,G-\u001a4\n\u0007\t\u000biFC\u0002\u0002ZQBsaFA1\u0003[\ny\u0007\u0005\u0003\u0002d\u0005%TBAA3\u0015\u0011\t9'a\t\u0002\rA\f'/Y7t\u0013\u0011\tY'!\u001a\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0003oC6,\u0017EAA9\u0003\tZH-[:qY\u0006Lh*Y7f{:Z\u0018M]4v[\u0016tGo],ji\"t\u0015-\\3t{\":q#!\u001e\u0002\u0002\u0006\r\u0005\u0003BA<\u0003{j!!!\u001f\u000b\t\u0005m\u0014QM\u0001\taJ|g/\u001b3fe&!\u0011qPA=\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\"\u0011QQAEC\t\t9)\u0001\u0002{W\u0006\u0012\u00111R\u0001\u0006WJ\fg\r^\u00017i\u0016\u001cH\u000fV5feR{\u0007/[2JI\u0016l\u0007o\u001c;f]R\u0004&o\u001c3vG\u0016\u0014x*\u001e;PM>\u0013H-\u001a:TKF,XM\\2f\u000bJ\u0014xN\u001d\u000b\u0004s\u0006E\u0005bBA%1\u0001\u0007\u00111\n\u0015\b1\u0005\u0005\u0014QNA8Q\u001dA\u0012QOAA\u0003/cC!!\"\u0002\n\u0006\u0019C/Z:u)&,'\u000fV8qS\u000e\u0004&o\u001c3vG\u0016\u0014\u0018J\\5u!&$G+[7f_V$HcA=\u0002\u001e\"9\u0011\u0011J\rA\u0002\u0005-\u0003fB\r\u0002b\u00055\u0014q\u000e\u0015\b3\u0005U\u0014\u0011QARY\u0011\t))!#\u0002EM,g\u000eZ%oSRlU\r^1eCR\fw+\u001b;i\u0007V\u001cHo\\7Qe>$WoY3s)\t\tI\u000b\u0005\u0004\u0002,\u0006E\u0016QW\u0007\u0003\u0003[S1!a,d\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003g\u000biKA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016\u0004B!a.\u0002D:!\u0011\u0011XA`\u001b\t\tYLC\u0002\u0002>\u0002\nQa\u001d;bi\u0016LA!!1\u0002<\u0006\u0011B+[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0013\u0011\t)-a2\u0003\u0019\u0005\u0003\b/\u001a8e%\u0016\u001cX\u000f\u001c;\u000b\t\u0005\u0005\u00171X\u0001\u001fg\u0016tG-T3uC\u0012\fG/Y,ji\"\u001cUo\u001d;p[B\u0013x\u000eZ;dKJ\f\u0011(\u00199qK:$G+[3s\u001b\u0016$\u0018\rZ1uCR{'+\u001a9mS\u000e\fw+\u001b;i\u0007V\u001cHo\\7ju\u0016$\u0017\nZ3na>$XM\u001c;QCJ\fWn\u001d\u000b\u000b\u0003S\u000by-a8\u0002j\u0006M\bbBAi9\u0001\u0007\u00111[\u0001\rY\u0016\fG-\u001a:Ce>\\WM\u001d\t\u0005\u0003+\fY.\u0004\u0002\u0002X*\u0019\u0011\u0011\u001c\u0012\u0002\rM,'O^3s\u0013\u0011\ti.a6\u0003\u0017-\u000bgm[1Ce>\\WM\u001d\u0005\b\u0003Cd\u0002\u0019AAr\u0003)\u0001(o\u001c3vG\u0016\u0014\u0018\n\u0012\t\u0004g\u0005\u0015\u0018bAAti\t!Aj\u001c8h\u0011\u001d\tY\u000f\ba\u0001\u0003[\fQ\u0002\u001d:pIV\u001cWM]#q_\u000eD\u0007cA\u001a\u0002p&\u0019\u0011\u0011\u001f\u001b\u0003\u000bMCwN\u001d;\t\r\u0005UH\u00041\u00013\u0003-\u0019X-];f]\u000e,g*^7\u0002\r1,\u0017\rZ3s)\u0011\t\u0019.a?\t\r\u0005uX\u00041\u0001I\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\f\u0001\"Y<bSRL5K\u0015\u000b\u0006s\n\r!Q\u0001\u0005\u0007\u0003{t\u0002\u0019\u0001%\t\r\t\u001da\u00041\u00013\u0003!)\u0007\u0010]3di\u0016$\u0007f\u0002\u0001\u0003\f\tE!1\u0003\t\u0005\u0003?\u0011i!\u0003\u0003\u0003\u0010\u0005\u0005\"a\u0001+bO\u0006)a/\u00197vK\u0006\u0012!QC\u0001\fS:$Xm\u001a:bi&|g\u000e")
public class TierTopicManagerIdempotentProducerIntegrationTest
extends IntegrationTestHarness {
    private final int segmentBytes;
    private final String topicName;
    private final int replicationFactor = this.brokerCount();
    private final TopicPartition userTopicPartition = new TopicPartition(this.topicName(), 0);
    private final TopicPartition tierTopicPartition = new TopicPartition("_confluent-tier-state", 0);
    private final TierTopic tierTopic = new TierTopic("");
    private final Properties producerProps = new Properties();
    private KafkaProducer<byte[], byte[]> producer;

    private int segmentBytes() {
        return this.segmentBytes;
    }

    private String topicName() {
        return this.topicName;
    }

    private int replicationFactor() {
        return this.replicationFactor;
    }

    private TopicPartition userTopicPartition() {
        return this.userTopicPartition;
    }

    private TopicPartition tierTopicPartition() {
        return this.tierTopicPartition;
    }

    private TierTopic tierTopic() {
        return this.tierTopic;
    }

    private Properties producerProps() {
        return this.producerProps;
    }

    private KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    private void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    @Override
    public int brokerCount() {
        return 3;
    }

    @Override
    public void modifyConfigs(Seq<Properties> props) {
        props.foreach((Function1 & Serializable)p -> {
            p.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
            p.put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
            p.put(KafkaConfig$.MODULE$.TierEnableProp(), "true");
            p.put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
            p.put(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "3");
            p.put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "1");
            p.put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), Integer.toString(this.segmentBytes() * 2));
            p.put(KafkaConfig$.MODULE$.LogSegmentBytesProp(), Integer.toString(this.segmentBytes()));
            return p.put(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), "500");
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        Properties topicProps = new Properties();
        topicProps.put("confluent.tier.enable", "true");
        topicProps.put("retention.bytes", "-1");
        topicProps.put("min.insync.replicas", "2");
        String x$1 = this.topicName();
        int x$2 = this.replicationFactor();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        this.createTopic(x$1, x$3, x$2, x$4, x$5, x$6);
        this.tierTopic().initialize(1);
        this.producerProps().put("enable.idempotence", "true");
        this.producerProps().put("client.id", TierTopicProducerSupplier.clientId((String)"clusterId", (int)0, (long)0L));
        this.producerProps().put("key.serializer", ByteArraySerializer.class.getName());
        this.producerProps().put("value.serializer", ByteArraySerializer.class.getName());
        this.producerProps().put("acks", "all");
        this.producerProps().put("retries", Integer.toString(Integer.MAX_VALUE));
        this.producerProps().put("retry.backoff.ms", Integer.toString(2000));
        this.producerProps().put("delivery.timeout.ms", Integer.toString(Integer.MAX_VALUE));
        this.producerProps().put("request.timeout.ms", Integer.toString(Defaults$.MODULE$.RequestTimeoutMs()));
        this.producerProps().put("max.in.flight.requests.per.connection", Integer.toString(1));
        this.brokers().foreach((Function1 & Serializable)broker -> {
            TierTopicManagerIdempotentProducerIntegrationTest.$anonfun$setUp$1(broker);
            return BoxedUnit.UNIT;
        });
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerIdempotentProducerIntegrationTest.$anonfun$setUp$4(this)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Did not become leader for TierPartitionState.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        this.producer().flush();
        this.producer().close();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTierTopicIdempotentProducerDuplicateSequenceError(String quorum) {
        this.producer_$eq(this.createProducer(new ByteArraySerializer(), new ByteArraySerializer(), this.producerProps()));
        Assertions.assertEquals((Object)this.sendInitMetadataWithCustomProducer().get(), (Object)TierPartitionState.AppendResult.ACCEPTED);
        LogManager qual$1 = this.leader(this.tierTopicPartition()).logManager();
        TopicPartition x$1 = this.tierTopicPartition();
        boolean x$2 = qual$1.getLog$default$2();
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)((Tuple2)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(((AbstractLog)qual$1.getLog(x$1, x$2).get()).producerStateManager().activeProducers()).asScala().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TierTopicManagerIdempotentProducerIntegrationTest.$anonfun$testTierTopicIdempotentProducerDuplicateSequenceError$1(x$3)))).last())._2();
        Assertions.assertEquals((Object)this.appendTierMetadataToReplicaWithCustomizedIdempotentParams(this.leader(this.tierTopicPartition()), producerStateEntry.producerId(), producerStateEntry.producerEpoch(), 1).get(), (Object)TierPartitionState.AppendResult.ACCEPTED);
        CompletableFuture<TierPartitionState.AppendResult> future = this.sendMetadataWithCustomProducer();
        String expectedExceptionContainsText = "timeout waiting for duplicate seq num receipt, as expected";
        String actualExceptionText = "";
        try {
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 5000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!future.isDone()) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)expectedExceptionContainsText);
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
        catch (AssertionFailedError assertionFailedError) {
            actualExceptionText = assertionFailedError.getMessage();
        }
        Assertions.assertTrue((boolean)expectedExceptionContainsText.equals(actualExceptionText));
        Assertions.assertEquals((Object)this.sendMetadataWithCustomProducer().get(), (Object)TierPartitionState.AppendResult.ACCEPTED);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTierTopicIdempotentProducerOutOfOrderSequenceError(String quorum) {
        this.producer_$eq(this.createProducer(new ByteArraySerializer(), new ByteArraySerializer(), this.producerProps()));
        Assertions.assertEquals((Object)this.sendInitMetadataWithCustomProducer().get(), (Object)TierPartitionState.AppendResult.ACCEPTED);
        LogManager qual$1 = this.leader(this.tierTopicPartition()).logManager();
        TopicPartition x$1 = this.tierTopicPartition();
        boolean x$2 = qual$1.getLog$default$2();
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)((Tuple2)((IterableOps)CollectionConverters$.MODULE$.MapHasAsScala(((AbstractLog)qual$1.getLog(x$1, x$2).get()).producerStateManager().activeProducers()).asScala().filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TierTopicManagerIdempotentProducerIntegrationTest.$anonfun$testTierTopicIdempotentProducerOutOfOrderSequenceError$1(x$4)))).last())._2();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 6).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)sequenceNumber -> Assertions.assertEquals((Object)this.appendTierMetadataToReplicaWithCustomizedIdempotentParams(this.leader(this.tierTopicPartition()), producerStateEntry.producerId(), producerStateEntry.producerEpoch(), sequenceNumber).get(), (Object)TierPartitionState.AppendResult.ACCEPTED));
        Assertions.assertEquals((Object)this.sendMetadataWithCustomProducer().get(), (Object)TierPartitionState.AppendResult.ACCEPTED);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTierTopicProducerInitPidTimeout(String quorum) {
        this.killRandomBroker();
        this.producer_$eq(this.createProducer(new ByteArraySerializer(), new ByteArraySerializer(), this.producerProps()));
        this.killRandomBroker();
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        this.awaitISR(this.userTopicPartition(), this.replicationFactor());
        Assertions.assertEquals((int)this.brokers().size(), (int)this.replicationFactor());
        Assertions.assertEquals((Object)this.sendInitMetadataWithCustomProducer().get(), (Object)TierPartitionState.AppendResult.ACCEPTED);
        Assertions.assertEquals((Object)this.sendMetadataWithCustomProducer().get(), (Object)TierPartitionState.AppendResult.ACCEPTED);
    }

    public CompletableFuture<TierPartitionState.AppendResult> sendInitMetadataWithCustomProducer() {
        TopicPartition topicPartition = new TopicPartition(this.topicName(), 0);
        LogManager qual$1 = this.leader(topicPartition).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        TierTopicInitLeader initMsg = new TierTopicInitLeader((TopicIdPartition)((AbstractLog)qual$1.getLog(topicPartition, x$2).get()).tierPartitionState().topicIdPartition().get(), 3, UUID.randomUUID(), this.leader(topicPartition).config().brokerId());
        CompletableFuture<TierPartitionState.AppendResult> future = new CompletableFuture<TierPartitionState.AppendResult>();
        ((TierTopicConsumer)this.leader(topicPartition).tierTopicConsumerOpt().get()).trackMaterialization((AbstractTierMetadata)initMsg, future);
        this.producer().send(new ProducerRecord("_confluent-tier-state", Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(0L), (Object)initMsg.serializeKey(), (Object)initMsg.serializeValue())).get();
        return future;
    }

    public CompletableFuture<TierPartitionState.AppendResult> sendMetadataWithCustomProducer() {
        TopicPartition topicPartition = new TopicPartition(this.topicName(), 0);
        LogManager qual$1 = this.leader(topicPartition).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        LogManager qual$2 = this.leader(topicPartition).logManager();
        boolean x$4 = qual$2.getLog$default$2();
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate((TopicIdPartition)((AbstractLog)qual$1.getLog(topicPartition, x$2).get()).topicIdPartition().get(), 3, UUID.randomUUID(), 0L, 1000L, 15000L, 0L, 100, true, false, false, TierUploadType.Archive, ((AbstractLog)qual$2.getLog(topicPartition, x$4).get()).tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch(), OpaqueData.ZEROED);
        CompletableFuture<TierPartitionState.AppendResult> future = new CompletableFuture<TierPartitionState.AppendResult>();
        ((TierTopicConsumer)this.leader(topicPartition).tierTopicConsumerOpt().get()).trackMaterialization((AbstractTierMetadata)uploadInitiate, future);
        this.producer().send(new ProducerRecord("_confluent-tier-state", Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(0L), (Object)uploadInitiate.serializeKey(), (Object)uploadInitiate.serializeValue())).get();
        return future;
    }

    /*
     * WARNING - void declaration
     */
    public CompletableFuture<TierPartitionState.AppendResult> appendTierMetadataToReplicaWithCustomizedIdempotentParams(KafkaBroker leaderBroker, long producerID, short producerEpoch, int sequenceNum) {
        void withIdempotentRecords_records;
        LogManager qual$1 = this.leader(this.userTopicPartition()).logManager();
        TopicPartition x$1 = this.userTopicPartition();
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(x$1, x$2);
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate((TopicIdPartition)((AbstractLog)log.get()).topicIdPartition().get(), 3, UUID.randomUUID(), 0L, 1000L, 15000L, 0L, 100, true, false, false, TierUploadType.Archive, ((AbstractLog)log.get()).tierPartitionState().lastLocalMaterializedSrcOffsetAndEpoch(), OpaqueData.ZEROED);
        TopicPartition tierTopicPartition = this.tierTopic().toTierTopicPartition((TopicIdPartition)((AbstractLog)log.get()).topicIdPartition().get());
        CompletableFuture<TierPartitionState.AppendResult> future = new CompletableFuture<TierPartitionState.AppendResult>();
        ((TierTopicConsumer)this.leader(this.userTopicPartition()).tierTopicConsumerOpt().get()).trackMaterialization((AbstractTierMetadata)uploadInitiate, future);
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(uploadInitiate.serializeKey(), uploadInitiate.serializeValue())};
        CompressionType withIdempotentRecords_compressionType = CompressionType.NONE;
        Object var23_13 = null;
        simpleRecordArray = null;
        MemoryRecords record = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)producerID, (short)producerEpoch, (int)sequenceNum, (int)-1, (boolean)false, (SimpleRecord[])withIdempotentRecords_records);
        ReplicaManager qual$2 = leaderBroker.replicaManager();
        Map x$6 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tierTopicPartition), (Object)record)}));
        Function1 & Serializable x$7 = (Function1 & Serializable)responses -> {
            TierTopicManagerIdempotentProducerIntegrationTest.appendCallback$1(responses, tierTopicPartition);
            return BoxedUnit.UNIT;
        };
        Function0 x$9 = qual$2.appendRecords$default$7();
        Option x$10 = qual$2.appendRecords$default$8();
        Function1 x$11 = qual$2.appendRecords$default$9();
        RequestLocal x$12 = qual$2.appendRecords$default$10();
        ActionQueue x$13 = qual$2.appendRecords$default$11();
        Map x$14 = qual$2.appendRecords$default$12();
        qual$2.appendRecords(10L, (short)-1, true, AppendOrigin.CLIENT, x$6, (Function1)x$7, x$9, x$10, x$11, x$12, x$13, x$14);
        return future;
    }

    private KafkaBroker leader(TopicPartition topicPartition) {
        int leaderId = ((UpdateMetadataRequestData.UpdateMetadataPartitionState)((KafkaBroker)((Tuple2)((IterableOps)((IterableOps)this.brokers().zip((IterableOnce)Predef$.MODULE$.wrapBooleanArray(this.alive()))).filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5._2$mcZ$sp()))).head())._1()).metadataCache().getPartitionInfo(topicPartition.topic(), topicPartition.partition()).get()).leader();
        return (KafkaBroker)((IterableOps)this.brokers().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TierTopicManagerIdempotentProducerIntegrationTest.$anonfun$leader$2(leaderId, x$6)))).head();
    }

    /*
     * WARNING - void declaration
     */
    private void awaitISR(TopicPartition topicPartition, int expected) {
        long l = 1000L;
        long waitUntilTrue_waitTimeMs = 120000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerIdempotentProducerIntegrationTest.$anonfun$awaitISR$1(this, topicPartition, expected)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"timed out waiting for replicas to join the ISR");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$setUp$2(TierTopicManager eta$0$1$1) {
        return eta$0$1$1.isReadyForWrites();
    }

    public static final /* synthetic */ String $anonfun$setUp$3() {
        return "timed out waiting for TierTopicManager to be ready";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$setUp$1(KafkaBroker broker) {
        TierTopicManager tierTopicManager = (TierTopicManager)broker.tierTopicManagerOpt().get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!tierTopicManager.isReadyForWrites()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"timed out waiting for TierTopicManager to be ready");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$setUp$4(TierTopicManagerIdempotentProducerIntegrationTest $this) {
        boolean x$8;
        TopicPartition x$7;
        LogManager qual$1 = $this.leader($this.userTopicPartition()).logManager();
        Option partitionState = qual$1.getLog(x$7 = $this.userTopicPartition(), x$8 = qual$1.getLog$default$2()).map((Function1 & Serializable)x$2 -> x$2.tierPartitionState());
        return partitionState.isDefined() && ((TierPartitionState)partitionState.get()).topicIdPartition().isPresent() && ((TierPartitionState)partitionState.get()).tierEpoch() == 0;
    }

    public static final /* synthetic */ String $anonfun$setUp$6() {
        return "Did not become leader for TierPartitionState.";
    }

    public static final /* synthetic */ boolean $anonfun$testTierTopicIdempotentProducerDuplicateSequenceError$1(Tuple2 x$3) {
        return ((ProducerStateEntry)x$3._2()).lastTimestamp() == 0L;
    }

    public static final /* synthetic */ boolean $anonfun$testTierTopicIdempotentProducerDuplicateSequenceError$2(CompletableFuture future$1) {
        return future$1.isDone();
    }

    public static final /* synthetic */ String $anonfun$testTierTopicIdempotentProducerDuplicateSequenceError$3(String expectedExceptionContainsText$1) {
        return expectedExceptionContainsText$1;
    }

    public static final /* synthetic */ boolean $anonfun$testTierTopicIdempotentProducerOutOfOrderSequenceError$1(Tuple2 x$4) {
        return ((ProducerStateEntry)x$4._2()).lastTimestamp() == 0L;
    }

    private static final void appendCallback$1(Map responses, TopicPartition tierTopicPartition$1) {
        Assertions.assertTrue((boolean)responses.get((Object)tierTopicPartition$1).isDefined());
    }

    public static final /* synthetic */ boolean $anonfun$leader$2(int leaderId$1, KafkaBroker x$6) {
        return x$6.config().brokerId() == leaderId$1;
    }

    public static final /* synthetic */ boolean $anonfun$awaitISR$1(TierTopicManagerIdempotentProducerIntegrationTest $this, TopicPartition topicPartition$1, int expected$1) {
        return ((Partition)$this.leader(topicPartition$1).replicaManager().onlinePartition(topicPartition$1).get()).inSyncReplicaIds().size() == expected$1;
    }

    public static final /* synthetic */ String $anonfun$awaitISR$2() {
        return "timed out waiting for replicas to join the ISR";
    }

    public TierTopicManagerIdempotentProducerIntegrationTest() {
        this.segmentBytes = 1024;
        this.topicName = "idem-topic";
    }
}

