/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.tier.TierTestUtils$;
import kafka.tier.TierTopicManagerIntegrationTest$;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.OpaqueData;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005\u0005\rb\u0001\u0002\b\u0010\u0001QAQa\u0007\u0001\u0005\u0002qAqa\b\u0001C\u0002\u0013\u0005\u0001\u0005\u0003\u0004*\u0001\u0001\u0006I!\t\u0005\bU\u0001\u0011\r\u0011\"\u0001,\u0011\u0019\u0011\u0004\u0001)A\u0005Y!)1\u0007\u0001C!i!)1\t\u0001C\u0001\t\")1\u000f\u0001C\u0001i\")a\u0010\u0001C\u0005\u007f\u001e9\u0011\u0011A\b\t\u0002\u0005\raA\u0002\b\u0010\u0011\u0003\t)\u0001\u0003\u0004\u001c\u0017\u0011\u0005\u0011Q\u0002\u0005\u0007e.!\t!a\u0004\u0003?QKWM\u001d+pa&\u001cW*\u00198bO\u0016\u0014\u0018J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u0002\u0011#\u0005!A/[3s\u0015\u0005\u0011\u0012!B6bM.\f7\u0001A\n\u0003\u0001U\u0001\"AF\r\u000e\u0003]Q!\u0001G\t\u0002\u0017%tG/Z4sCRLwN\\\u0005\u00035]\u0011acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003=\tqb\u001c<feJLG-\u001b8h!J|\u0007o]\u000b\u0002CA\u0011!eJ\u0007\u0002G)\u0011A%J\u0001\u0005kRLGNC\u0001'\u0003\u0011Q\u0017M^1\n\u0005!\u001a#A\u0003)s_B,'\u000f^5fg\u0006\u0001rN^3se&$\u0017N\\4Qe>\u00048\u000fI\u0001\u0007Y><G)\u001b:\u0016\u00031\u0002\"!\f\u0019\u000e\u00039R!aL\u0013\u0002\u0005%|\u0017BA\u0019/\u0005\u00111\u0015\u000e\\3\u0002\u000f1|w\rR5sA\u0005yq-\u001a8fe\u0006$XmQ8oM&<7/F\u00016!\r14(P\u0007\u0002o)\u0011\u0001(O\u0001\u000bG>dG.Z2uS>t'\"\u0001\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005q:$aA*fcB\u0011a(Q\u0007\u0002\u007f)\u0011\u0001)E\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\t{$aC&bM.\f7i\u001c8gS\u001e\fA\u0003^3tiRKWM\u001d+pa&\u001cW*\u00198bO\u0016\u0014HcA#J\u001dB\u0011aiR\u0007\u0002s%\u0011\u0001*\u000f\u0002\u0005+:LG\u000fC\u0003K\u000f\u0001\u00071*\u0001\u0016uS\u0016\u0014Hk\u001c9jG6\u000bG/\u001a:jC2L'0\u0019;j_:4%o\\7T]\u0006\u00048\u000f[8u\u000b:\f'\r\\3\u0011\u0005\u0019c\u0015BA':\u0005\u001d\u0011un\u001c7fC:DQaT\u0004A\u0002A\u000ba!];peVl\u0007CA)Y\u001d\t\u0011f\u000b\u0005\u0002Ts5\tAK\u0003\u0002V'\u00051AH]8pizJ!aV\u001d\u0002\rA\u0013X\rZ3g\u0013\tI&L\u0001\u0004TiJLgn\u001a\u0006\u0003/fB#a\u0002/\u0011\u0005u3W\"\u00010\u000b\u0005}\u0003\u0017A\u00029be\u0006l7O\u0003\u0002bE\u00069!.\u001e9ji\u0016\u0014(BA2e\u0003\u0015QWO\\5u\u0015\u0005)\u0017aA8sO&\u0011qM\u0018\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\b\u0006B\u0004j_B\u0004\"A[7\u000e\u0003-T!\u0001\u001c0\u0002\u0011A\u0014xN^5eKJL!A\\6\u0003\u00195+G\u000f[8e'>,(oY3\u0002\u000bY\fG.^3-\u0003E\f\u0013A]\u0001&O\u0016tWM]1uK\n{w\u000e\\3b]\u000e{WNY5oCRLwN\\:XSRD\u0017+^8sk6\fqc\u0019:fCR,\u0017\tZ7j]\u000ec\u0017.\u001a8u\u0007>tg-[4\u0015\u0003U\u0004BA\t<Qq&\u0011qo\t\u0002\u0004\u001b\u0006\u0004\bCA=}\u001b\u0005Q(BA>&\u0003\u0011a\u0017M\\4\n\u0005uT(AB(cU\u0016\u001cG/A\u000ebgN,'\u000f\u001e+jKJ\u001cF/\u0019;f)>\u0004\u0018nY\"p]\u001aLwm\u001d\u000b\u0002\u000b\u0006yB+[3s)>\u0004\u0018nY'b]\u0006<WM]%oi\u0016<'/\u0019;j_:$Vm\u001d;\u0011\u0005yY1cA\u0006\u0002\bA\u0019a)!\u0003\n\u0007\u0005-\u0011H\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003\u0007)\"!!\u0005\u0011\r\u0005M\u0011\u0011DA\u000f\u001b\t\t)BC\u0002\u0002\u0018\r\naa\u001d;sK\u0006l\u0017\u0002BA\u000e\u0003+\u0011aa\u0015;sK\u0006l\u0007c\u00016\u0002 %\u0019\u0011\u0011E6\u0003\u0013\u0005\u0013x-^7f]R\u001c\b")
public class TierTopicManagerIntegrationTest
extends KafkaServerTestHarness {
    private final Properties overridingProps = new Properties();
    private final File logDir;

    public static Stream<Arguments> generateBooleanCombinationsWithQuorum() {
        return TierTopicManagerIntegrationTest$.MODULE$.generateBooleanCombinationsWithQuorum();
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public File logDir() {
        return this.logDir;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnectOrNull(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0, false).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @MethodSource(value={"generateBooleanCombinationsWithQuorum"})
    public void testTierTopicManager(boolean tierTopicMaterializationFromSnapshotEnable, String quorum) {
        TierTopicManager tierTopicManager = (TierTopicManager)((KafkaBroker)this.brokers().last()).tierTopicManagerOpt().get();
        LogManager logManager = ((KafkaBroker)this.brokers().last()).logManager();
        Properties properties = new Properties();
        properties.put("confluent.tier.enable", "true");
        properties.put("cleanup.policy", "delete");
        while (!tierTopicManager.isReadyForWrites()) {
            Thread.sleep(5L);
        }
        this.assertTierStateTopicConfigs();
        String topic1 = "foo";
        int x$4 = this.createTopic$default$3();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        this.createTopic(topic1, 2, x$4, properties, x$5, x$6);
        TopicPartition topicPartition = new TopicPartition(topic1, 0);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerIntegrationTest.$anonfun$testTierTopicManager$1(logManager, topicPartition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Did not become leader for TierPartitionState.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        TierPartitionState tierPartitionState1 = ((AbstractLog)logManager.getLog(topicPartition, logManager.getLog$default$2()).get()).tierPartitionState();
        TopicIdPartition topicIdPartition1 = (TopicIdPartition)tierPartitionState1.topicIdPartition().get();
        CompletableFuture<TierPartitionState.AppendResult> result1 = TierTestUtils$.MODULE$.uploadWithMetadata(tierTopicManager, topicIdPartition1, 0, UUID.randomUUID(), 0L, 1000L, 15000L, 0L, 100, false, true, false, tierPartitionState1.lastLocalMaterializedSrcOffsetAndEpoch(), OpaqueData.ZEROED);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)result1.get());
        tierPartitionState1.flush();
        Assertions.assertEquals((long)1000L, (long)tierPartitionState1.committedEndOffset());
        CompletableFuture<TierPartitionState.AppendResult> result2 = TierTestUtils$.MODULE$.uploadWithMetadata(tierTopicManager, topicIdPartition1, 0, UUID.randomUUID(), 0L, 1000L, 15000L, 0L, 200, false, true, false, tierPartitionState1.lastLocalMaterializedSrcOffsetAndEpoch(), OpaqueData.ZEROED);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FENCED, (Object)result2.get());
        tierPartitionState1.flush();
        Assertions.assertEquals((long)1000L, (long)tierPartitionState1.committedEndOffset());
        Assertions.assertEquals((int)1, (int)tierPartitionState1.numSegments());
        if (tierTopicMaterializationFromSnapshotEnable) {
            this.waitUntilFtpsSnapshotUploaded(topicIdPartition1.topicIdAsBase64(), this.waitUntilFtpsSnapshotUploaded$default$2());
        }
        String topic2 = "topic2";
        TopicPartition topicPartition2 = new TopicPartition(topic2, 0);
        String x$7 = topicPartition2.topic();
        int x$9 = this.createTopic$default$2();
        int x$10 = this.createTopic$default$3();
        ListenerName x$11 = this.createTopic$default$5();
        Properties x$12 = this.createTopic$default$6();
        this.createTopic(x$7, x$9, x$10, properties, x$11, x$12);
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierTopicManagerIntegrationTest.$anonfun$testTierTopicManager$4(logManager, topicPartition2)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Did not become leader for TierPartitionState topic2.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        TierPartitionState tierPartitionState2 = ((AbstractLog)logManager.getLog(topicPartition2, logManager.getLog$default$2()).get()).tierPartitionState();
        Assertions.assertTrue((boolean)tierPartitionState2.topicIdPartition().isPresent());
        if (tierTopicMaterializationFromSnapshotEnable) {
            this.waitUntilFtpsSnapshotUploaded(((TopicIdPartition)tierPartitionState2.topicIdPartition().get()).topicIdAsBase64(), this.waitUntilFtpsSnapshotUploaded$default$2());
        }
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 500L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!TierTopicManagerIntegrationTest.$anonfun$testTierTopicManager$7(tierPartitionState1, tierPartitionState2)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"tierTopicManager consumers catchingUp timed out");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        TierPartitionState originalState = ((AbstractLog)logManager.getLog(topicPartition, logManager.getLog$default$2()).get()).tierPartitionState();
        Assertions.assertEquals((int)1, (int)originalState.numSegments());
    }

    public java.util.Map<String, Object> createAdminClientConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        config.put("request.timeout.ms", "20000");
        return config;
    }

    /*
     * WARNING - void declaration
     */
    private void assertTierStateTopicConfigs() {
        java.util.Map<String, Object> create_conf = this.createAdminClientConfig();
        Object var9_1 = null;
        Config config = null;
        try (AdminClient client = (AdminClient)Admin.create(create_conf);){
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                boolean bl;
                try {
                    ConfigResource $anonfun$assertTierStateTopicConfigs$1_existingTopic = new ConfigResource(ConfigResource.Type.TOPIC, "_confluent-tier-state");
                    config = (Config)((KafkaFuture)client.describeConfigs(Collections.singletonList($anonfun$assertTierStateTopicConfigs$1_existingTopic)).values().get($anonfun$assertTierStateTopicConfigs$1_existingTopic)).get();
                    bl = true;
                }
                catch (ExecutionException $anonfun$assertTierStateTopicConfigs$1_ee) {
                    if ($anonfun$assertTierStateTopicConfigs$1_ee.getCause() instanceof UnknownTopicOrPartitionException) {
                        bl = false;
                    }
                    throw $anonfun$assertTierStateTopicConfigs$1_ee.getCause();
                }
                Object var10_7 = null;
                Object var11_8 = null;
                if (!bl) {
                    void waitUntilTrue_pause;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)"timed waiting to find tier state topic");
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                    continue;
                }
                break;
            }
        }
        Assertions.assertEquals((Object)"-1", (Object)((ConfigEntry)CollectionConverters$.MODULE$.CollectionHasAsScala(config.entries()).asScala().find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TierTopicManagerIntegrationTest.$anonfun$assertTierStateTopicConfigs$3(x$4))).get()).value());
        Assertions.assertEquals((Object)"-1", (Object)((ConfigEntry)CollectionConverters$.MODULE$.CollectionHasAsScala(config.entries()).asScala().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TierTopicManagerIntegrationTest.$anonfun$assertTierStateTopicConfigs$4(x$5))).get()).value());
        Assertions.assertEquals((Object)"delete", (Object)((ConfigEntry)CollectionConverters$.MODULE$.CollectionHasAsScala(config.entries()).asScala().find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TierTopicManagerIntegrationTest.$anonfun$assertTierStateTopicConfigs$5(x$6))).get()).value());
        Assertions.assertEquals((Object)"false", (Object)((ConfigEntry)CollectionConverters$.MODULE$.CollectionHasAsScala(config.entries()).asScala().find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)TierTopicManagerIntegrationTest.$anonfun$assertTierStateTopicConfigs$6(x$7))).get()).value());
    }

    public static final /* synthetic */ boolean $anonfun$testTierTopicManager$1(LogManager logManager$1, TopicPartition topicPartition$1) {
        Option partitionState = logManager$1.getLog(topicPartition$1, logManager$1.getLog$default$2()).map((Function1 & Serializable)x$2 -> x$2.tierPartitionState());
        return partitionState.isDefined() && ((TierPartitionState)partitionState.get()).topicIdPartition().isPresent() && ((TierPartitionState)partitionState.get()).tierEpoch() == 0;
    }

    public static final /* synthetic */ String $anonfun$testTierTopicManager$3() {
        return "Did not become leader for TierPartitionState.";
    }

    public static final /* synthetic */ boolean $anonfun$testTierTopicManager$4(LogManager logManager$1, TopicPartition topicPartition2$1) {
        Option partitionState = logManager$1.getLog(topicPartition2$1, logManager$1.getLog$default$2()).map((Function1 & Serializable)x$3 -> x$3.tierPartitionState());
        return partitionState.isDefined() && ((TierPartitionState)partitionState.get()).topicIdPartition().isPresent() && ((TierPartitionState)partitionState.get()).tierEpoch() == 0;
    }

    public static final /* synthetic */ String $anonfun$testTierTopicManager$6() {
        return "Did not become leader for TierPartitionState topic2.";
    }

    public static final /* synthetic */ boolean $anonfun$testTierTopicManager$7(TierPartitionState tierPartitionState1$1, TierPartitionState tierPartitionState2$1) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState1$1.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        if (!(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null)) {
            TierPartitionStatus tierPartitionStatus3 = tierPartitionState2$1.status();
            TierPartitionStatus tierPartitionStatus4 = TierPartitionStatus.ONLINE;
            if (!(tierPartitionStatus3 != null ? !tierPartitionStatus3.equals(tierPartitionStatus4) : tierPartitionStatus4 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testTierTopicManager$8() {
        return "tierTopicManager consumers catchingUp timed out";
    }

    public static final /* synthetic */ boolean $anonfun$assertTierStateTopicConfigs$1(ObjectRef result$1, AdminClient client$1) {
        try {
            ConfigResource existingTopic = new ConfigResource(ConfigResource.Type.TOPIC, "_confluent-tier-state");
            result$1.elem = (Config)((KafkaFuture)client$1.describeConfigs(Collections.singletonList(existingTopic)).values().get(existingTopic)).get();
            return true;
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof UnknownTopicOrPartitionException) {
                return false;
            }
            throw ee.getCause();
        }
    }

    public static final /* synthetic */ String $anonfun$assertTierStateTopicConfigs$2() {
        return "timed waiting to find tier state topic";
    }

    public static final /* synthetic */ boolean $anonfun$assertTierStateTopicConfigs$3(ConfigEntry x$4) {
        String string = x$4.name();
        String string2 = "retention.bytes";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$assertTierStateTopicConfigs$4(ConfigEntry x$5) {
        String string = x$5.name();
        String string2 = "retention.ms";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$assertTierStateTopicConfigs$5(ConfigEntry x$6) {
        String string = x$6.name();
        String string2 = "cleanup.policy";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$assertTierStateTopicConfigs$6(ConfigEntry x$7) {
        String string = x$7.name();
        String string2 = "unclean.leader.election.enable";
        return string != null && string.equals(string2);
    }

    public TierTopicManagerIntegrationTest() {
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "2");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "1");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.LogCleanupPolicyProp(), "compact");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "1000000");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.LogRetentionTimeMillisProp(), "1000000");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierPartitionStateMetadataSnapshotsEnableProp(), "true");
        this.logDir = TestUtils.tempDirectory(null, null);
    }
}

