/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.Serializable;
import java.util.function.Function;
import kafka.tier.backupObjectLifecycle.RetryFramework;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Matchers$;
import org.scalatest.concurrent.Signaler$;
import org.scalatest.concurrent.TimeLimits$;
import org.scalatest.enablers.Timed$;
import org.scalatest.time.Millis$;
import org.scalatest.time.Span$;
import org.scalatest.time.Units;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u00192Aa\u0001\u0003\u0001\u0013!)\u0001\u0003\u0001C\u0001#!)A\u0003\u0001C\u0001+\t!B+[3s)>\u0004\u0018n\u0019*fC\u0012,'\u000fV3tiNT!!\u0002\u0004\u0002\tQLWM\u001d\u0006\u0002\u000f\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u000b!\tYa\"D\u0001\r\u0015\u0005i\u0011!B:dC2\f\u0017BA\b\r\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u0005\t\u0003'\u0001i\u0011\u0001B\u0001\u0018i\u0016\u001cHOU3uef4%/Y7fo>\u00148.\u0012=jiN$\u0012A\u0006\t\u0003\u0017]I!\u0001\u0007\u0007\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005i\u0001\"a\u0007\u0013\u000e\u0003qQ!!\b\u0010\u0002\u0007\u0005\u0004\u0018N\u0003\u0002 A\u00059!.\u001e9ji\u0016\u0014(BA\u0011#\u0003\u0015QWO\\5u\u0015\u0005\u0019\u0013aA8sO&\u0011Q\u0005\b\u0002\u0005)\u0016\u001cH\u000f")
public class TierTopicReaderTests {
    @Test
    public void testRetryFrameworkExits() {
        int maxRetries = 3;
        TopicPartition p1 = new TopicPartition("foo", 0);
        TopicPartition p2 = new TopicPartition("foo", 1);
        TopicPartition p3 = new TopicPartition("foo", 2);
        KafkaConsumer consumer = (KafkaConsumer)Mockito.mock(KafkaConsumer.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)consumer.position(p1))).thenReturn((Object)BoxesRunTime.boxToLong((long)100L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)consumer.position(p2))).thenThrow(new Throwable[]{new TimeoutException()});
        Mockito.when((Object)BoxesRunTime.boxToLong((long)consumer.position(p3))).thenThrow(new Throwable[]{new TimeoutException()}).thenThrow(new Throwable[]{new TimeoutException()}).thenReturn((Object)BoxesRunTime.boxToLong((long)100L));
        Function<TopicPartition, Long> fn = tp -> Predef$.MODULE$.long2Long(consumer.position(tp));
        TimeLimits$.MODULE$.failAfter(Span$.MODULE$.apply(30000L, (Units)Millis$.MODULE$), (Function0)(JFunction0.mcV.sp & Serializable)() -> Predef$.MODULE$.assert(BoxesRunTime.equals((Object)new RetryFramework(maxRetries).call(fn, (Object)p1), (Object)BoxesRunTime.boxToLong((long)100L))), Signaler$.MODULE$.default(), Prettifier$.MODULE$.default(), new Position("TierTopicReaderTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41), Timed$.MODULE$.timed());
        TimeLimits$.MODULE$.failAfter(Span$.MODULE$.apply(30000L, (Units)Millis$.MODULE$), (Function0 & Serializable)() -> Matchers$.MODULE$.assertThrows((Function0 & Serializable)() -> (Long)new RetryFramework(maxRetries).call(fn, (Object)p2), ClassTag$.MODULE$.apply(TimeoutException.class), new Position("TierTopicReaderTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47)), Signaler$.MODULE$.default(), Prettifier$.MODULE$.default(), new Position("TierTopicReaderTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46), Timed$.MODULE$.timed());
        TimeLimits$.MODULE$.failAfter(Span$.MODULE$.apply(30000L, (Units)Millis$.MODULE$), (Function0)(JFunction0.mcV.sp & Serializable)() -> Predef$.MODULE$.assert(BoxesRunTime.equals((Object)new RetryFramework(maxRetries).call(fn, (Object)p3), (Object)BoxesRunTime.boxToLong((long)100L))), Signaler$.MODULE$.default(), Prettifier$.MODULE$.default(), new Position("TierTopicReaderTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53), Timed$.MODULE$.timed());
    }
}

