/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.util.UUID;
import kafka.tier.TopicIdPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TopicIdPartitionTest {
    @Test
    public void fromStringTest() {
        UUID uuid = UUID.randomUUID();
        TopicIdPartition tpId = new TopicIdPartition("topic", uuid, 10);
        TopicIdPartition tpId2 = TopicIdPartition.fromString((String)tpId.toString());
        Assertions.assertEquals((Object)tpId, (Object)tpId2);
        Assertions.assertEquals((Object)"topic", (Object)tpId.topic());
        Assertions.assertEquals((int)10, (int)tpId.partition());
        Assertions.assertEquals((Object)uuid, (Object)tpId.topicId());
    }

    @Test
    public void fromHardcodedStringTest() {
        String tpIdStr = "tqMjVNfwTOKLXyWCLkOcbQ:topicName-5";
        TopicIdPartition tpId = TopicIdPartition.fromString((String)tpIdStr);
        Assertions.assertEquals((Object)"topicName", (Object)tpId.topic());
        Assertions.assertEquals((int)5, (int)tpId.partition());
        Assertions.assertEquals((Object)"tqMjVNfwTOKLXyWCLkOcbQ", (Object)tpId.topicIdAsBase64());
    }

    @Test
    public void missingPartitionSeparatorTest() {
        String tpIdStr = "tqMjVNfwTOKLXyWCLkOcbQ:topicName5";
        Assertions.assertThrows(IllegalArgumentException.class, () -> TopicIdPartition.fromString((String)tpIdStr));
    }

    @Test
    public void invalidTopicIdSeparatorTest() {
        String tpIdStr = "tqMjVNfwTOKLXyWCLkOcbQtopicName-5";
        Assertions.assertThrows(IllegalArgumentException.class, () -> TopicIdPartition.fromString((String)tpIdStr));
    }
}

