/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.backupObjectLifecycle;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpResponse;
import com.azure.storage.blob.models.BlobStorageException;
import com.google.cloud.storage.StorageException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import kafka.tier.TopicIdPartition;
import kafka.tier.backupObjectLifecycle.ObjectStoreUtils;
import kafka.tier.backupObjectLifecycle.ObjectStoreUtilsContext;
import kafka.tier.backupObjectLifecycle.RetryPolicy;
import kafka.tier.backupObjectLifecycle.TierObjectStoreBatchOperationException;
import kafka.tier.exceptions.TierObjectStoreFatalException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.objects.FragmentLocation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.LifecycleManagerStateMetadata;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005-g\u0001\u0002\u0015*\u0001ABQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001C\u0002\u0013\u0005A\b\u0003\u0004F\u0001\u0001\u0006I!\u0010\u0005\b\r\u0002\u0011\r\u0011\"\u0001H\u0011\u0019a\u0005\u0001)A\u0005\u0011\"9Q\n\u0001b\u0001\n\u0003q\u0005B\u0002-\u0001A\u0003%q\nC\u0004Z\u0001\t\u0007I\u0011\u0001.\t\r}\u0003\u0001\u0015!\u0003\\\u0011\u001d\u0001\u0007A1A\u0005\u0002\u0005Da\u0001\u001d\u0001!\u0002\u0013\u0011\u0007bB9\u0001\u0005\u0004%\tA\u001d\u0005\u0007s\u0002\u0001\u000b\u0011B:\t\u000fi\u0004!\u0019!C\u0001w\"9\u0011\u0011\u0004\u0001!\u0002\u0013a\b\"CA\u000e\u0001\t\u0007I\u0011AA\u000f\u0011!\t)\u0003\u0001Q\u0001\n\u0005}\u0001\"CA\u0014\u0001\t\u0007I\u0011AA\u0015\u0011!\t\t\u0004\u0001Q\u0001\n\u0005-\u0002\"CA\u001a\u0001\t\u0007I\u0011AA\u001b\u0011!\ti\u0004\u0001Q\u0001\n\u0005]\u0002\"CA \u0001\u0001\u0007I\u0011AA!\u0011%\ty\u0005\u0001a\u0001\n\u0003\t\t\u0006\u0003\u0005\u0002^\u0001\u0001\u000b\u0015BA\"\u0011%\ty\u0006\u0001b\u0001\n\u0003\t\t\u0007\u0003\u0005\u0002|\u0001\u0001\u000b\u0011BA2\u0011!\ti\b\u0001b\u0001\n\u0003\t\u0007bBA@\u0001\u0001\u0006IA\u0019\u0005\n\u0003\u0003\u0003!\u0019!C\u0001\u0003\u0007C\u0001\"a#\u0001A\u0003%\u0011Q\u0011\u0005\b\u0003\u001b\u0003A\u0011AAH\u0011\u001d\tY\u000b\u0001C\u0001\u0003\u001fCq!a,\u0001\t\u0003\ty\tC\u0004\u00024\u0002!\t!a$\t\u000f\u0005]\u0006\u0001\"\u0001\u0002\u0010\"9\u00111\u0018\u0001\u0005\u0002\u0005=\u0005bBA`\u0001\u0011\u0005\u0011q\u0012\u0005\b\u0003\u0007\u0004A\u0011AAH\u0011\u001d\t9\r\u0001C\u0001\u0003\u001f\u0013Ac\u00142kK\u000e$8\u000b^8sKV#\u0018\u000e\\:UKN$(B\u0001\u0016,\u0003U\u0011\u0017mY6va>\u0013'.Z2u\u0019&4WmY=dY\u0016T!\u0001L\u0017\u0002\tQLWM\u001d\u0006\u0002]\u0005)1.\u00194lC\u000e\u00011C\u0001\u00012!\t\u0011T'D\u00014\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c4\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u000f\t\u0003u\u0001i\u0011!K\u0001\u0005kVLG-F\u0001>!\tq4)D\u0001@\u0015\t\u0001\u0015)\u0001\u0003vi&d'\"\u0001\"\u0002\t)\fg/Y\u0005\u0003\t~\u0012A!V+J\t\u0006)Q/^5eA\u0005!A\u000f]%e+\u0005A\u0005CA%K\u001b\u0005Y\u0013BA&,\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g.A\u0003ua&#\u0007%\u0001\u0005nKR\fG-\u0019;b+\u0005y\u0005C\u0001)W\u001b\u0005\t&BA'S\u0015\t\u0019F+A\u0004pE*,7\r^:\u000b\u0005U[\u0013!B:u_J,\u0017BA,R\u0005ua\u0015NZ3ds\u000edW-T1oC\u001e,'o\u0015;bi\u0016lU\r^1eCR\f\u0017!C7fi\u0006$\u0017\r^1!\u0003-y'M[3diN#xN]3\u0016\u0003m\u0003\"\u0001X/\u000e\u0003QK!A\u0018+\u0003\u001fQKWM](cU\u0016\u001cGo\u0015;pe\u0016\fAb\u001c2kK\u000e$8\u000b^8sK\u0002\nQ\u0001\u001d:paN,\u0012A\u0019\t\u0005}\r,W-\u0003\u0002e\u007f\t9\u0001*Y:i\u001b\u0006\u0004\bC\u00014n\u001d\t97\u000e\u0005\u0002ig5\t\u0011N\u0003\u0002k_\u00051AH]8pizJ!\u0001\\\u001a\u0002\rA\u0013X\rZ3g\u0013\tqwN\u0001\u0004TiJLgn\u001a\u0006\u0003YN\na\u0001\u001d:paN\u0004\u0013A\u00022vM\u001a,'/F\u0001t!\t!x/D\u0001v\u0015\t1\u0018)A\u0002oS>L!\u0001_;\u0003\u0015\tKH/\u001a\"vM\u001a,'/A\u0004ck\u001a4WM\u001d\u0011\u0002\u0019-,\u0017p\u001d+p\t\u0016dW\r^3\u0016\u0003q\u00042AP?\u0000\u0013\tqxHA\u0005BeJ\f\u0017\u0010T5tiB!\u0011\u0011AA\n\u001d\u0011\t\u0019!a\u0004\u000f\t\u0005\u0015\u0011Q\u0002\b\u0005\u0003\u000f\tYAD\u0002i\u0003\u0013I\u0011AL\u0005\u0003Y5J!!V\u0016\n\u0007\u0005EA+A\bUS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f\u0013\u0011\t)\"a\u0006\u0003\u001b-+\u00170\u00118e-\u0016\u00148/[8o\u0015\r\t\t\u0002V\u0001\u000eW\u0016L8\u000fV8EK2,G/\u001a\u0011\u0002\u0017=\u0014'.T3uC\u0012\fG/Y\u000b\u0003\u0003?\u00012\u0001UA\u0011\u0013\r\t\u0019#\u0015\u0002\u0014\u001f\nTWm\u0019;Ti>\u0014X-T3uC\u0012\fG/Y\u0001\r_\nTW*\u001a;bI\u0006$\u0018\rI\u0001\te\u0016\u001c\bo\u001c8tKV\u0011\u00111\u0006\t\u00049\u00065\u0012bAA\u0018)\n9B+[3s\u001f\nTWm\u0019;Ti>\u0014XMU3ta>t7/Z\u0001\ne\u0016\u001c\bo\u001c8tK\u0002\n1a\u0019;y+\t\t9\u0004E\u0002;\u0003sI1!a\u000f*\u0005]y%M[3diN#xN]3Vi&d7oQ8oi\u0016DH/\u0001\u0003dib\u0004\u0013\u0001C3yK\u000e,Ho\u001c:\u0016\u0005\u0005\r\u0003\u0003BA#\u0003\u0017j!!a\u0012\u000b\u0007\u0005%s(\u0001\u0006d_:\u001cWO\u001d:f]RLA!!\u0014\u0002H\t\u0011B\u000b\u001b:fC\u0012\u0004vn\u001c7Fq\u0016\u001cW\u000f^8s\u00031)\u00070Z2vi>\u0014x\fJ3r)\u0011\t\u0019&!\u0017\u0011\u0007I\n)&C\u0002\u0002XM\u0012A!\u00168ji\"I\u00111L\f\u0002\u0002\u0003\u0007\u00111I\u0001\u0004q\u0012\n\u0014!C3yK\u000e,Ho\u001c:!\u00031AG\u000f\u001e9SKN\u0004xN\\:f+\t\t\u0019\u0007\u0005\u0003\u0002f\u0005]TBAA4\u0015\u0011\tI'a\u001b\u0002\t!$H\u000f\u001d\u0006\u0005\u0003[\ny'\u0001\u0003d_J,'\u0002BA9\u0003g\nQ!\u0019>ve\u0016T!!!\u001e\u0002\u0007\r|W.\u0003\u0003\u0002z\u0005\u001d$\u0001\u0004%uiB\u0014Vm\u001d9p]N,\u0017!\u00045uiB\u0014Vm\u001d9p]N,\u0007%A\u0004iK\u0006$WM]:\u0002\u0011!,\u0017\rZ3sg\u0002\n1B]3uef\u0004v\u000e\\5dsV\u0011\u0011Q\u0011\t\u0004u\u0005\u001d\u0015bAAES\tY!+\u001a;ssB{G.[2z\u00031\u0011X\r\u001e:z!>d\u0017nY=!\u0003)\"Xm\u001d;BuV\u0014X\rR3mKRLwN\u001c'p_B4uN\u001d*fiJL\u0018M\u00197f\u000bb\u001cW\r\u001d;j_:$\"!a\u0015)\u0007}\t\u0019\n\u0005\u0003\u0002\u0016\u0006\u001dVBAAL\u0015\u0011\tI*a'\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002\u001e\u0006}\u0015a\u00026va&$XM\u001d\u0006\u0005\u0003C\u000b\u0019+A\u0003kk:LGO\u0003\u0002\u0002&\u0006\u0019qN]4\n\t\u0005%\u0016q\u0013\u0002\u0005)\u0016\u001cH/A\u0012uKN$\u0018I_;sK\u0012+G.\u001a;j_:dun\u001c9G_Jtu.\u0012=dKB$\u0018n\u001c8)\u0007\u0001\n\u0019*\u0001\u0016uKN$\u0018I_;sK\u0012+G.\u001a;j_:dun\u001c9Fq&$8o\u00148GCR\fG.\u0012=dKB$\u0018n\u001c8)\u0007\u0005\n\u0019*\u0001\u0018uKN$\u0018I_;sK\u0012+G.\u001a;j_:dun\u001c9Fq&$8o\u00148SKR\u0014\u00180\u00192mK\u0016C8-\u001a9uS>t\u0007f\u0001\u0012\u0002\u0014\u0006AB/Z:u\u0003j,(/\u001a\"bi\u000eDW\r\u001a#fY\u0016$\u0018n\u001c8)\u0007\r\n\u0019*A\ruKN$H*[:u\u0007\u0006dGNU3uefdun\u001c9F]\u0012\u001c\bf\u0001\u0013\u0002\u0014\u0006\u0019C/Z:u\u0019&\u001cHoQ1mYJ+GO]=M_>\u0004X\t_5ug>s7+^2dKN\u001c\bfA\u0013\u0002\u0014\u0006\u0001D/Z:u\u001f\nTWm\u0019;Ti>\u0014XmQ1mYJ+GO]=M_>\u0004X\t_5ug\u00063G/\u001a:NCb\u0014V\r\u001e:jKND3AJAJ\u0003)\"Xm\u001d;PE*,7\r^*u_J,7)\u00197m%\u0016$(/\u001f'p_B,\u00050\u001b;t\u001f:\u001cVoY2fgND3aJAJ\u0001")
public class ObjectStoreUtilsTest {
    private final UUID uuid = UUID.randomUUID();
    private final TopicIdPartition tpId = new TopicIdPartition("foo", this.uuid(), 0);
    private final LifecycleManagerStateMetadata metadata = new LifecycleManagerStateMetadata("clusterId");
    private final TierObjectStore objectStore = (TierObjectStore)Mockito.mock(TierObjectStore.class);
    private final HashMap<String, String> props;
    private final ByteBuffer buffer;
    private final ArrayList<TierObjectStore.KeyAndVersion> keysToDelete;
    private final ObjectStoreMetadata objMetadata;
    private final TierObjectStoreResponse response;
    private final ObjectStoreUtilsContext ctx;
    private ThreadPoolExecutor executor;
    private final HttpResponse httpResponse;
    private final HashMap<String, String> headers;
    private final RetryPolicy retryPolicy;

    public UUID uuid() {
        return this.uuid;
    }

    public TopicIdPartition tpId() {
        return this.tpId;
    }

    public LifecycleManagerStateMetadata metadata() {
        return this.metadata;
    }

    public TierObjectStore objectStore() {
        return this.objectStore;
    }

    public HashMap<String, String> props() {
        return this.props;
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    public ArrayList<TierObjectStore.KeyAndVersion> keysToDelete() {
        return this.keysToDelete;
    }

    public ObjectStoreMetadata objMetadata() {
        return this.objMetadata;
    }

    public TierObjectStoreResponse response() {
        return this.response;
    }

    public ObjectStoreUtilsContext ctx() {
        return this.ctx;
    }

    public ThreadPoolExecutor executor() {
        return this.executor;
    }

    public void executor_$eq(ThreadPoolExecutor x$1) {
        this.executor = x$1;
    }

    public HttpResponse httpResponse() {
        return this.httpResponse;
    }

    public HashMap<String, String> headers() {
        return this.headers;
    }

    public RetryPolicy retryPolicy() {
        return this.retryPolicy;
    }

    @Test
    public void testAzureDeletionLoopForRetryableException() {
        Mockito.when((Object)this.objectStore().getBackend()).thenReturn((Object)TierObjectStore.Backend.AzureBlockBlob);
        ArrayList<TierObjectStore.KeyAndVersion> keys = new ArrayList<TierObjectStore.KeyAndVersion>();
        keys.add(new TierObjectStore.KeyAndVersion("k1", "v1"));
        keys.add(new TierObjectStore.KeyAndVersion("k2", "v2"));
        try {
            this.executor_$eq((ThreadPoolExecutor)Executors.newFixedThreadPool(2));
            TierObjectStoreRetriableException retryableException = new TierObjectStoreRetriableException("blah", (Throwable)new RuntimeException("meh"));
            ((TierObjectStore)Mockito.doThrow((Throwable[])new Throwable[]{retryableException}).when((Object)this.objectStore())).deleteVersions((List)ArgumentMatchers.any());
            ObjectStoreUtils.deleteVersions((ObjectStoreUtilsContext)this.ctx(), keys, (ThreadPoolExecutor)this.executor(), (RetryPolicy)this.retryPolicy());
            ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)(this.retryPolicy().maxRetries() * keys.size())))).deleteVersions((List)ArgumentMatchers.any());
        }
        finally {
            this.executor().shutdown();
        }
    }

    @Test
    public void testAzureDeletionLoopForNoException() {
        Mockito.when((Object)this.objectStore().getBackend()).thenReturn((Object)TierObjectStore.Backend.AzureBlockBlob);
        ArrayList<TierObjectStore.KeyAndVersion> keys = new ArrayList<TierObjectStore.KeyAndVersion>();
        keys.add(new TierObjectStore.KeyAndVersion("k1", "v1"));
        keys.add(new TierObjectStore.KeyAndVersion("k2", "v2"));
        try {
            this.executor_$eq((ThreadPoolExecutor)Executors.newFixedThreadPool(2));
            ((TierObjectStore)Mockito.doNothing().when((Object)this.objectStore())).deleteVersions((List)ArgumentMatchers.any());
            ObjectStoreUtils.deleteVersions((ObjectStoreUtilsContext)this.ctx(), keys, (ThreadPoolExecutor)this.executor(), (RetryPolicy)this.retryPolicy());
            ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)keys.size()))).deleteVersions((List)ArgumentMatchers.any());
        }
        finally {
            this.executor().shutdown();
        }
    }

    @Test
    public void testAzureDeletionLoopExitsOnFatalException() {
        Mockito.when((Object)this.objectStore().getBackend()).thenReturn((Object)TierObjectStore.Backend.AzureBlockBlob);
        ArrayList<TierObjectStore.KeyAndVersion> keys = new ArrayList<TierObjectStore.KeyAndVersion>();
        keys.add(new TierObjectStore.KeyAndVersion("k1", "v1"));
        keys.add(new TierObjectStore.KeyAndVersion("k2", "v2"));
        try {
            this.executor_$eq((ThreadPoolExecutor)Executors.newFixedThreadPool(2));
            TierObjectStoreFatalException fatalException = new TierObjectStoreFatalException("blah-blah");
            ((TierObjectStore)Mockito.doThrow((Throwable[])new Throwable[]{fatalException}).when((Object)this.objectStore())).deleteVersions((List)ArgumentMatchers.any());
            Assertions.assertThrows(TierObjectStoreFatalException.class, () -> ObjectStoreUtils.deleteVersions((ObjectStoreUtilsContext)this.ctx(), (List)keys, (ThreadPoolExecutor)this.executor(), (RetryPolicy)this.retryPolicy()));
            ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)keys.size()))).deleteVersions((List)ArgumentMatchers.any());
        }
        finally {
            this.executor().shutdown();
        }
    }

    @Test
    public void testAzureDeletionLoopExitsOnRetryableException() {
        Mockito.when((Object)this.objectStore().getBackend()).thenReturn((Object)TierObjectStore.Backend.AzureBlockBlob);
        ArrayList<TierObjectStore.KeyAndVersion> keys = new ArrayList<TierObjectStore.KeyAndVersion>();
        keys.add(new TierObjectStore.KeyAndVersion("k1", "v1"));
        keys.add(new TierObjectStore.KeyAndVersion("k2", "v2"));
        try {
            this.executor_$eq((ThreadPoolExecutor)Executors.newFixedThreadPool(2));
            TierObjectStoreRetriableException retryableException = new TierObjectStoreRetriableException("meh", (Throwable)new RuntimeException("meh"));
            ((TierObjectStore)Mockito.doThrow((Throwable[])new Throwable[]{retryableException}).when((Object)this.objectStore())).deleteVersions((List)ArgumentMatchers.any());
            ObjectStoreUtils.deleteVersions((ObjectStoreUtilsContext)this.ctx(), keys, (ThreadPoolExecutor)this.executor(), (RetryPolicy)this.retryPolicy());
            ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)(keys.size() * this.retryPolicy().maxRetries())))).deleteVersions((List)ArgumentMatchers.any());
        }
        finally {
            this.executor().shutdown();
        }
    }

    @Test
    public void testAzureBatchedDeletion() {
        Mockito.when((Object)this.objectStore().getBackend()).thenReturn((Object)TierObjectStore.Backend.AzureBlockBlob);
        ArrayList<TierObjectStore.KeyAndVersion> keys = new ArrayList<TierObjectStore.KeyAndVersion>();
        keys.add(new TierObjectStore.KeyAndVersion("k1", "v1"));
        keys.add(new TierObjectStore.KeyAndVersion("k2", "v2"));
        keys.add(new TierObjectStore.KeyAndVersion("k3", "v3"));
        try {
            this.executor_$eq((ThreadPoolExecutor)Executors.newFixedThreadPool(2));
            this.headers().put("x-ms-error-code", "BlobNotFound");
            HttpHeaders httpHeaders = new HttpHeaders(this.headers());
            Mockito.when((Object)this.httpResponse().getHeaders()).thenReturn((Object)httpHeaders);
            BlobStorageException blobStorageException = new BlobStorageException("blah", this.httpResponse(), new Object());
            TierObjectStoreRetriableException retryableException = new TierObjectStoreRetriableException("blah", (Throwable)blobStorageException);
            ((TierObjectStore)Mockito.doThrow((Throwable[])new Throwable[]{retryableException}).when((Object)this.objectStore())).deleteVersions((List)ArgumentMatchers.any());
            ObjectStoreUtils.deleteVersionedObjectsAsync((ObjectStoreUtilsContext)this.ctx(), keys, (ThreadPoolExecutor)this.executor());
            this.headers().put("x-ms-error-code", "SomeError");
            httpHeaders = new HttpHeaders(this.headers());
            Mockito.when((Object)this.httpResponse().getHeaders()).thenReturn((Object)httpHeaders);
            blobStorageException = new BlobStorageException("blah", this.httpResponse(), new Object());
            retryableException = new TierObjectStoreRetriableException("blah", (Throwable)blobStorageException);
            ((TierObjectStore)Mockito.doThrow((Throwable[])new Throwable[]{retryableException}).when((Object)this.objectStore())).deleteVersions((List)ArgumentMatchers.any());
            Assertions.assertThrows(TierObjectStoreBatchOperationException.class, () -> ObjectStoreUtils.deleteVersionedObjectsAsync((ObjectStoreUtilsContext)this.ctx(), (List)keys, (ThreadPoolExecutor)this.executor()));
            ((TierObjectStore)Mockito.doNothing().when((Object)this.objectStore())).deleteVersions((List)ArgumentMatchers.any());
            ObjectStoreUtils.deleteVersionedObjectsAsync((ObjectStoreUtilsContext)this.ctx(), keys, (ThreadPoolExecutor)this.executor());
        }
        finally {
            this.executor().shutdown();
        }
    }

    @Test
    public void testListCallRetryLoopEnds() {
        Mockito.when((Object)this.objectStore().listObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean())).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("retry")});
        Assertions.assertThrows(TierObjectStoreFatalException.class, () -> ObjectStoreUtils.verifyObjectNotLive((ObjectStoreUtilsContext)this.ctx(), (TopicIdPartition)this.tpId(), (UUID)this.uuid(), (RetryPolicy)this.retryPolicy()));
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)this.retryPolicy().maxRetries()))).listObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testListCallRetryLoopExitsOnSuccess() {
        HashMap listResponse = new HashMap();
        Mockito.when((Object)this.objectStore().listObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean())).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("retry")}).thenReturn(listResponse);
        Assertions.assertDoesNotThrow(() -> ObjectStoreUtils.verifyObjectNotLive((ObjectStoreUtilsContext)this.ctx(), (TopicIdPartition)this.tpId(), (UUID)this.uuid(), (RetryPolicy)this.retryPolicy()));
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)3))).listObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testObjectStoreCallRetryLoopExitsAfterMaxRetries() {
        Mockito.when((Object)this.objectStore().listObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean())).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("retry")});
        Assertions.assertThrows(TierObjectStoreFatalException.class, () -> ObjectStoreUtils.listObject((ObjectStoreUtilsContext)this.ctx(), (String)ArgumentMatchers.anyString(), (Boolean)Predef$.MODULE$.boolean2Boolean(ArgumentMatchers.anyBoolean()), (RetryPolicy)this.retryPolicy()));
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)this.retryPolicy().maxRetries()))).listObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        Mockito.when((Object)this.objectStore().putBuffer((ObjectStoreMetadata)this.metadata(), this.buffer(), ObjectType.LIFECYCLE_MANAGER_STATE)).thenThrow(new Throwable[]{new StorageException(100, "retry")});
        Assertions.assertThrows(TierObjectStoreFatalException.class, () -> ObjectStoreUtils.putBuffer((ObjectStoreUtilsContext)this.ctx(), (ObjectStoreMetadata)this.metadata(), (ByteBuffer)this.buffer(), (ObjectType)ObjectType.LIFECYCLE_MANAGER_STATE, (RetryPolicy)this.retryPolicy()));
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)this.retryPolicy().maxRetries()))).putBuffer((ObjectStoreMetadata)this.metadata(), this.buffer(), ObjectType.LIFECYCLE_MANAGER_STATE);
        this.objectStore().deleteVersions((List)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("retry")});
        ObjectStoreUtils.deleteVersions((ObjectStoreUtilsContext)this.ctx(), this.keysToDelete(), (ThreadPoolExecutor)this.executor(), (RetryPolicy)this.retryPolicy());
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)this.retryPolicy().maxRetries()))).deleteVersions((List)ArgumentMatchers.any());
        Mockito.when((Object)this.objectStore().getObjectStoreFragment(this.objMetadata(), FragmentType.BACKUP_OBJECTS_LIST)).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("retry")});
        Assertions.assertThrows(TierObjectStoreFatalException.class, () -> ObjectStoreUtils.getObjectStoreFragment((ObjectStoreUtilsContext)this.ctx(), (ObjectStoreMetadata)this.objMetadata(), (FragmentType)FragmentType.BACKUP_OBJECTS_LIST, (RetryPolicy)this.retryPolicy()));
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)this.retryPolicy().maxRetries()))).getObjectStoreFragment(this.objMetadata(), FragmentType.BACKUP_OBJECTS_LIST);
    }

    @Test
    public void testObjectStoreCallRetryLoopExitsOnSuccess() {
        HashMap returnValue = new HashMap();
        Mockito.when((Object)this.objectStore().listObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean())).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("retry")}).thenReturn(returnValue);
        Assertions.assertDoesNotThrow(() -> ObjectStoreUtils.listObject((ObjectStoreUtilsContext)this.ctx(), (String)ArgumentMatchers.anyString(), (Boolean)Predef$.MODULE$.boolean2Boolean(ArgumentMatchers.anyBoolean()), (RetryPolicy)this.retryPolicy()));
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)2))).listObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        Mockito.when((Object)this.objectStore().putBuffer((ObjectStoreMetadata)this.metadata(), this.buffer(), ObjectType.LIFECYCLE_MANAGER_STATE)).thenThrow(new Throwable[]{new StorageException(100, "retry")}).thenAnswer((Answer)new Answer<String>(this){
            private final /* synthetic */ ObjectStoreUtilsTest $outer;

            public String answer(InvocationOnMock invocation) {
                return ((FragmentLocation)this.$outer.metadata().toFragmentLocation("", FragmentType.LIFECYCLE_MANAGER_STATE).get()).objectPath();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ObjectStoreUtils.putBuffer((ObjectStoreUtilsContext)this.ctx(), (ObjectStoreMetadata)this.metadata(), (ByteBuffer)this.buffer(), (ObjectType)ObjectType.LIFECYCLE_MANAGER_STATE, (RetryPolicy)this.retryPolicy());
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)2))).putBuffer((ObjectStoreMetadata)this.metadata(), this.buffer(), ObjectType.LIFECYCLE_MANAGER_STATE);
        this.objectStore().deleteVersions((List)ArgumentMatchers.any());
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("retry")}).thenAnswer((Answer)new Answer<BoxedUnit>(null){

            public void answer(InvocationOnMock invocation) {
            }
        });
        ObjectStoreUtils.deleteVersions((ObjectStoreUtilsContext)this.ctx(), this.keysToDelete(), (ThreadPoolExecutor)this.executor(), (RetryPolicy)this.retryPolicy());
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)2))).deleteVersions((List)ArgumentMatchers.any());
        Mockito.when((Object)this.objectStore().getObjectStoreFragment(this.objMetadata(), FragmentType.BACKUP_OBJECTS_LIST)).thenThrow(new Throwable[]{new TierObjectStoreRetriableException("retry")}).thenAnswer((Answer)new Answer<TierObjectStoreResponse>(this){
            private final /* synthetic */ ObjectStoreUtilsTest $outer;

            public TierObjectStoreResponse answer(InvocationOnMock invocation) {
                return this.$outer.response();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ObjectStoreUtils.getObjectStoreFragment((ObjectStoreUtilsContext)this.ctx(), (ObjectStoreMetadata)this.objMetadata(), (FragmentType)FragmentType.BACKUP_OBJECTS_LIST, (RetryPolicy)this.retryPolicy());
        ((TierObjectStore)Mockito.verify((Object)this.objectStore(), (VerificationMode)Mockito.times((int)2))).getObjectStoreFragment(this.objMetadata(), FragmentType.BACKUP_OBJECTS_LIST);
    }

    public ObjectStoreUtilsTest() {
        Mockito.when((Object)this.objectStore().getBackend()).thenReturn((Object)TierObjectStore.Backend.GCS);
        this.props = new HashMap();
        this.buffer = ByteBuffer.allocate(0);
        this.keysToDelete = new ArrayList();
        this.keysToDelete().add(new TierObjectStore.KeyAndVersion("k1", "v1"));
        this.objMetadata = (ObjectStoreMetadata)Mockito.mock(ObjectStoreMetadata.class);
        this.response = (TierObjectStoreResponse)Mockito.mock(TierObjectStoreResponse.class);
        this.ctx = new ObjectStoreUtilsContext(this.objectStore(), () -> Predef$.MODULE$.boolean2Boolean(true), () -> Predef$.MODULE$.boolean2Boolean(false));
        this.executor = (ThreadPoolExecutor)Mockito.mock(ThreadPoolExecutor.class);
        this.httpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        this.headers = new HashMap();
        this.retryPolicy = new RetryPolicy(10, 10L, 5L);
    }
}

