/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import io.confluent.kafka.storage.checksum.Algorithm;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierMetadataSnapshotUploadComplete;
import kafka.tier.domain.TierMetadataSnapshotUploadInitiate;
import kafka.tier.state.FileTierPartitionStateSnapshotObject;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TierMetadataSnapshotUploadCompleteTest {
    private final TopicIdPartition topicIdPartition = new TopicIdPartition("topic", UUID.randomUUID(), 0);
    private final long snapshotTimestampMs = 123L;
    private final kafka.tier.state.OffsetAndEpoch stateOffsetEpoch = new kafka.tier.state.OffsetAndEpoch(11L, Optional.of(12));
    private final kafka.tier.state.OffsetAndEpoch snapshotOffsetEpoch = new kafka.tier.state.OffsetAndEpoch(12L, Optional.of(12));
    private final int tierEpoch = 5;
    private final List<Optional<OffsetAndEpoch>> partitionCreationOffsetAndEpochOpts = new ArrayList<Optional<OffsetAndEpoch>>(){
        {
            this.add(Optional.of(new OffsetAndEpoch(88L, 2)));
            this.add(Optional.empty());
        }
    };
    private UUID randomId;

    @BeforeEach
    public void setUp() {
        this.randomId = UUID.randomUUID();
    }

    @Test
    public void testTierMetadataSnapshotCompleteSerializationDeserialization() {
        this.partitionCreationOffsetAndEpochOpts.forEach(partitionCreationOffsetAndEpochOpt -> {
            TierMetadataSnapshotUploadComplete actual = new TierMetadataSnapshotUploadComplete(this.topicIdPartition, 5, this.randomId, this.stateOffsetEpoch, this.snapshotOffsetEpoch, 123L, Algorithm.ADLER.id.byteValue(), partitionCreationOffsetAndEpochOpt);
            TierMetadataSnapshotUploadComplete fromSerialized = new TierMetadataSnapshotUploadComplete(this.topicIdPartition, actual.metadata);
            Assertions.assertEquals((Object)actual, (Object)fromSerialized);
            Assertions.assertEquals((Object)fromSerialized.stateOffsetAndEpoch(), (Object)this.stateOffsetEpoch);
            Assertions.assertEquals((Object)fromSerialized.snapshotOffsetAndEpoch(), (Object)this.snapshotOffsetEpoch);
            Assertions.assertEquals((int)fromSerialized.tierEpoch(), (int)5);
            Assertions.assertEquals((Object)fromSerialized.messageId(), (Object)this.randomId);
            Assertions.assertEquals((Object)fromSerialized.topicIdPartition(), (Object)this.topicIdPartition);
            Assertions.assertEquals((long)fromSerialized.snapshotTimestampMs(), (long)123L);
            Assertions.assertEquals((Byte)fromSerialized.checksumAlgorithm().id, (Byte)Algorithm.ADLER.id);
            Assertions.assertEquals((Object)fromSerialized.partitionCreationOffsetAndEpoch(), (Object)partitionCreationOffsetAndEpochOpt);
        });
    }

    @Test
    public void testAbstractTierMetadataCompatibleSerializationDeserialization() {
        this.partitionCreationOffsetAndEpochOpts.forEach(partitionCreationOffsetAndEpochOpt -> {
            TierMetadataSnapshotUploadComplete actual = new TierMetadataSnapshotUploadComplete(this.topicIdPartition, 5, this.randomId, this.stateOffsetEpoch, this.snapshotOffsetEpoch, 123L, Algorithm.ADLER.id.byteValue(), partitionCreationOffsetAndEpochOpt);
            TierMetadataSnapshotUploadComplete derived = (TierMetadataSnapshotUploadComplete)AbstractTierMetadata.deserialize((byte[])actual.serializeKey(), (byte[])actual.serializeValue(), (long)0L).get();
            Assertions.assertEquals((Object)actual, (Object)derived);
        });
    }

    @Test
    public void testConstructFromFTPSSnapshotObject() {
        boolean brokerId = false;
        TierMetadataSnapshotUploadInitiate uploadInitiate = new TierMetadataSnapshotUploadInitiate(this.topicIdPartition, 5, this.randomId, this.stateOffsetEpoch, 0);
        String baseName = "00000000000000000000.tierstate.snapshot.adler";
        FileTierPartitionStateSnapshotObject snapshotObject = new FileTierPartitionStateSnapshotObject(this.randomId, 123L, this.snapshotOffsetEpoch, 5, "00000000000000000000.tierstate.snapshot.adler", Algorithm.ADLER);
        this.partitionCreationOffsetAndEpochOpts.forEach(partitionCreationOffsetAndEpochOpt -> {
            TierMetadataSnapshotUploadComplete actual = new TierMetadataSnapshotUploadComplete(this.topicIdPartition, 5, this.randomId, this.stateOffsetEpoch, this.snapshotOffsetEpoch, 123L, Algorithm.ADLER.id.byteValue(), partitionCreationOffsetAndEpochOpt);
            TierMetadataSnapshotUploadComplete uploadComplete = new TierMetadataSnapshotUploadComplete(uploadInitiate, snapshotObject, partitionCreationOffsetAndEpochOpt);
            Assertions.assertEquals((Object)actual, (Object)uploadComplete);
            Assertions.assertEquals((Object)this.stateOffsetEpoch, (Object)uploadComplete.stateOffsetAndEpoch());
            Assertions.assertEquals((Object)this.snapshotOffsetEpoch, (Object)uploadComplete.snapshotOffsetAndEpoch());
        });
    }
}

