/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.domain;

import io.confluent.kafka.storage.checksum.E2EChecksumUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicPartitionSnapshot;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.store.OpaqueData;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TierTopicPartitionSnapshotTest {
    @Test
    public void testTierTopicSnapshotSerializationDeserialization() throws IOException {
        long time = Time.SYSTEM.milliseconds();
        TopicIdPartition tpid = new TopicIdPartition("foo", UUID.randomUUID(), 10);
        int tierPartition = 0;
        long tierOffset0 = 0L;
        long tierOffset1 = tierOffset0 + 100L;
        TierSegmentUploadInitiate tsui = TierTopicPartitionSnapshotTest.makeTierSegmentUploadInitiate(tpid);
        ConsumerRecord tsuiRecord = TierTopicPartitionSnapshot.makeTierTopicRecord((int)tierPartition, (long)tierOffset0, (long)(time + 200L), (byte[])tsui.serializeKey(), (byte[])tsui.serializeValue(), (int)tsui.tierEpoch());
        TierSegmentUploadComplete tsuc = TierTopicPartitionSnapshotTest.makeTierSegmentUploadComplete(tpid);
        ConsumerRecord tsucRecord = TierTopicPartitionSnapshot.makeTierTopicRecord((int)tierPartition, (long)tierOffset1, (long)(time + 300L), (byte[])tsuc.serializeKey(), (byte[])tsuc.serializeValue(), (int)tsuc.tierEpoch());
        TierTopicPartitionSnapshot snapshot = TierTopicPartitionSnapshotTest.makeTierTopicPartitionSnapshot(Collections.singletonList(Collections.singletonMap(tierPartition, Arrays.asList(tsuiRecord, tsucRecord))));
        List<AbstractTierMetadata> actualEntries = TierTopicPartitionSnapshotTest.deserializeEntries(snapshot.entries());
        Assertions.assertEquals(Arrays.asList(tsui, tsuc), actualEntries);
        ByteBuffer buf = snapshot.payloadBuffer();
        Path tmpPath = File.createTempFile("pre", "suf").toPath();
        FileChannel fc = FileChannel.open(tmpPath, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        fc.write(buf);
        fc.position(0L);
        this.checkDeserialize(TierTopicPartitionSnapshot.read((FileChannel)fc, (Long)(time + 123L), (Long)(time + 456L)), actualEntries);
        fc.close();
        FileInputStream stream = new FileInputStream(tmpPath.toFile());
        this.checkDeserialize(TierTopicPartitionSnapshot.read((InputStream)stream, (Long)(time + 123L), (Long)(time + 456L)), actualEntries);
        buf.flip();
        Assertions.assertDoesNotThrow(() -> E2EChecksumUtils.compute32BitBase64Crc32c((ByteBuffer)buf));
    }

    public void checkDeserialize(TierTopicPartitionSnapshot snapshot, List<AbstractTierMetadata> expectedEntries) {
        List<AbstractTierMetadata> deserializeEntries = TierTopicPartitionSnapshotTest.deserializeEntries(snapshot.entries());
        Assertions.assertEquals(expectedEntries, deserializeEntries);
    }

    @Test
    public void testOffsetRanges() {
        TopicIdPartition tpid = new TopicIdPartition("foo", UUID.randomUUID(), 10);
        int tierPartition = 0;
        long tierOffset0 = 0L;
        long tierOffset1 = tierOffset0 + 100L;
        TierSegmentUploadInitiate tsui = TierTopicPartitionSnapshotTest.makeTierSegmentUploadInitiate(tpid);
        ConsumerRecord tsuiRecord = TierTopicPartitionSnapshot.makeTierTopicRecord((int)tierPartition, (long)tierOffset0, (long)0L, (byte[])tsui.serializeKey(), (byte[])tsui.serializeValue(), (int)tsui.tierEpoch());
        TierSegmentUploadComplete tsuc = TierTopicPartitionSnapshotTest.makeTierSegmentUploadComplete(tpid);
        ConsumerRecord tsucRecord = TierTopicPartitionSnapshot.makeTierTopicRecord((int)tierPartition, (long)tierOffset1, (long)100L, (byte[])tsuc.serializeKey(), (byte[])tsuc.serializeValue(), (int)tsuc.tierEpoch());
        TierTopicPartitionSnapshot ttps = TierTopicPartitionSnapshotTest.makeTierTopicPartitionSnapshot(Collections.singletonList(Collections.singletonMap(tierPartition, Arrays.asList(tsuiRecord, tsucRecord))));
        Assertions.assertEquals((long)tierOffset0, (long)ttps.startOffset(tierPartition), (String)("Unexpected starting offset found in TTPS header for partition " + tierPartition));
        Assertions.assertEquals((long)tierOffset1, (Long)ttps.endOffset(tierPartition), (String)("Unexpected ending offset found in TTPS header for partition " + tierPartition));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ttps.startOffset(1));
    }

    private static TierTopicPartitionSnapshot makeTierTopicPartitionSnapshot(List<Map<Integer, List<ConsumerRecord<byte[], byte[]>>>> input) {
        HashMap recordsMap = new HashMap();
        for (Map<Integer, List<ConsumerRecord<byte[], byte[]>>> inputMap : input) {
            inputMap.forEach((partition, recordList) -> recordsMap.put(new TopicPartition("_confluent-tier-state", partition.intValue()), recordList));
        }
        ConsumerRecords records = new ConsumerRecords(recordsMap);
        List<ConsumerRecords> recordsBuffer = Collections.singletonList(records);
        return new TierTopicPartitionSnapshot(recordsBuffer, new ArrayList(50));
    }

    public static List<AbstractTierMetadata> deserializeEntries(List<ConsumerRecord<byte[], byte[]>> entries) {
        return entries.stream().map(entry -> AbstractTierMetadata.deserialize((byte[])((byte[])entry.key()), (byte[])((byte[])entry.value()), (long)entry.timestamp())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private static TierSegmentUploadInitiate makeTierSegmentUploadInitiate(TopicIdPartition tpid) {
        int tierEpoch = 0;
        UUID objectId = UUID.randomUUID();
        long baseOffset = 0L;
        long endOffset = 500L;
        long maxTimestamp = 1000L;
        long firstBatchTimestamp = 250L;
        int size = 100;
        boolean hasEpochState = false;
        boolean hasAbortedTxns = false;
        boolean hasProducerState = false;
        TierUploadType uploadType = TierUploadType.Archive;
        OffsetAndEpoch stateOffset = new OffsetAndEpoch(0L, Optional.empty());
        OpaqueData opaqueData = OpaqueData.fromByteArray((byte[])new byte[]{0, 1, 2, 3, 4, 5});
        return new TierSegmentUploadInitiate(tpid, tierEpoch, objectId, Optional.empty(), baseOffset, endOffset, maxTimestamp, firstBatchTimestamp, size, hasEpochState, hasAbortedTxns, hasProducerState, uploadType, stateOffset, opaqueData, Optional.empty());
    }

    private static TierSegmentUploadComplete makeTierSegmentUploadComplete(TopicIdPartition tpid) {
        int tierEpoch = 0;
        UUID objectId = UUID.randomUUID();
        OffsetAndEpoch stateOffset = new OffsetAndEpoch(100L, Optional.empty());
        return new TierSegmentUploadComplete(tpid, tierEpoch, objectId, stateOffset);
    }
}

