/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.BucketHealthResult;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.TierObjectAttribute;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.VersionInformation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;
import kafka.utils.Throttler;

class FetchRequestTestUtils {
    FetchRequestTestUtils() {
    }

    static TierObjectStore ioExceptionThrowingTierObjectStore() {
        return new TierObjectStore(){

            public String keyPrefix() {
                return null;
            }

            public TierObjectStore.Backend getBackend() {
                return TierObjectStore.Backend.Mock;
            }

            public Map<String, List<VersionInformation>> listObject(String keyPrefix, boolean getVersionInfo) {
                return null;
            }

            public BucketHealthResult checkBucketHealth() {
                return BucketHealthResult.HEALTHY;
            }

            public TierObjectStoreResponse getObjectStoreFragment(ObjectStoreMetadata objectMetadata, FragmentType fragmentType, Optional<Long> byteOffsetStart, Optional<Long> byteOffsetEndExclusive, VersionInformation versionInformation) throws IOException {
                throw new IOException("");
            }

            public TierObjectStoreResponse getObject(ObjectStoreMetadata objectMetadata, ObjectType objectType, Long byteOffsetStart, Long byteOffsetEndExclusive, VersionInformation versionInformation) throws IOException {
                throw new IOException("");
            }

            public TierObjectStoreResponse getObjectStoreFragment(ObjectStoreMetadata objectMetadata, FragmentType fragmentType, Long byteOffsetStart) throws IOException {
                throw new IOException("");
            }

            public TierObjectStoreResponse getObjectStoreFragment(ObjectStoreMetadata objectMetadata, FragmentType fragmentType) throws IOException {
                throw new IOException("");
            }

            public ByteBuffer getSnapshot(ObjectStoreMetadata metadata, FragmentType fragmentType, int estimatedBufferSize) {
                return null;
            }

            public OpaqueData prepPutSegment() throws TierObjectStoreRetriableException, IOException {
                return OpaqueData.ZEROED;
            }

            public void putSegment(ObjectMetadata objectMetadata, File segmentData, File offsetIndexData, File timestampIndexData, Optional<File> producerStateSnapshotData, Optional<ByteBuffer> transactionIndexData, Optional<ByteBuffer> epochState, Optional<Throttler> throttlerOpt) throws TierObjectStoreRetriableException, IOException {
                throw new IOException("");
            }

            public void putInMemorySegment(ObjectMetadata objectMetadata, File segmentData, File offsetIndexData, File timestampIndexData, Optional<ByteBuffer> producerStateSnapshotData, Optional<ByteBuffer> transactionIndexData, Optional<ByteBuffer> epochState) throws IOException {
                throw new IOException("");
            }

            public String putObject(ObjectStoreMetadata objectMetadata, File file, ObjectType objectType) throws IOException {
                throw new IOException("");
            }

            public String putBuffer(ObjectStoreMetadata objectMetadata, ByteBuffer buffer, ObjectType objectType) throws IOException {
                throw new IOException("");
            }

            public void restoreObjectByCopy(ObjectMetadata objectMetadata, String key, VersionInformation lastLiveVersion) {
            }

            public void deleteSegment(ObjectMetadata objectMetadata) throws IOException {
                throw new IOException("");
            }

            public TierObjectAttribute objectExists(ObjectStoreMetadata objectMetadata, ObjectType type) throws IOException, TierObjectStoreRetriableException {
                throw new IOException("");
            }

            public void deleteVersions(List<TierObjectStore.KeyAndVersion> keys) {
            }

            public void close() {
            }
        };
    }

    static TierObjectStore fileReturningTierObjectStore(final File offsetIndexFile, final File timestampIndexFile) {
        return new TierObjectStore(){

            public String keyPrefix() {
                return "";
            }

            public TierObjectStore.Backend getBackend() {
                return TierObjectStore.Backend.Mock;
            }

            public Map<String, List<VersionInformation>> listObject(String keyPrefix, boolean getVersionInfo) {
                return null;
            }

            public BucketHealthResult checkBucketHealth() {
                return BucketHealthResult.HEALTHY;
            }

            public ByteBuffer getSnapshot(ObjectStoreMetadata metadata, FragmentType fragmentType, int estimatedBufferSize) {
                return null;
            }

            protected TierObjectStoreResponse getObject(ObjectStoreMetadata objectMetadata, ObjectType objectType, Long byteOffsetStart, Long byteOffsetEndExclusive, VersionInformation versionInformation) throws IOException {
                FileInputStream inputStream = null;
                if (byteOffsetEndExclusive != null && byteOffsetStart != null && byteOffsetEndExclusive - 1L <= byteOffsetStart) {
                    throw new IllegalArgumentException("Illegal empty range GET");
                }
                switch (objectType) {
                    case OFFSET_INDEX: {
                        inputStream = new FileInputStream(offsetIndexFile);
                        break;
                    }
                    case TIMESTAMP_INDEX: {
                        inputStream = new FileInputStream(timestampIndexFile);
                    }
                }
                final FileInputStream finalInputStream = inputStream;
                return new TierObjectStoreResponse(){

                    public InputStream getInputStream() {
                        return finalInputStream;
                    }

                    public void close() {
                        try {
                            finalInputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                };
            }

            public TierObjectAttribute objectExists(ObjectStoreMetadata objectMetadata, ObjectType type) throws IOException, TierObjectStoreRetriableException {
                File relevantFile = null;
                switch (type) {
                    case OFFSET_INDEX: {
                        relevantFile = offsetIndexFile;
                        break;
                    }
                    case TIMESTAMP_INDEX: {
                        relevantFile = timestampIndexFile;
                    }
                }
                if (relevantFile == null) {
                    return new TierObjectAttribute(false);
                }
                return new TierObjectAttribute(true, relevantFile.length());
            }

            public OpaqueData prepPutSegment() throws TierObjectStoreRetriableException, IOException {
                return OpaqueData.ZEROED;
            }

            public String putObject(ObjectStoreMetadata objectMetadata, File file, ObjectType objectType) throws IOException {
                throw new IOException("");
            }

            public String putBuffer(ObjectStoreMetadata objectMetadata, ByteBuffer buffer, ObjectType objectType) throws IOException {
                throw new IOException("");
            }

            public void restoreObjectByCopy(ObjectMetadata objectMetadata, String key, VersionInformation lastLiveVersion) {
            }

            public void putSegment(ObjectMetadata objectMetadata, File segmentData, File offsetIndexData, File timestampIndexData, Optional<File> producerStateSnapshotData, Optional<ByteBuffer> transactionIndexData, Optional<ByteBuffer> epochState, Optional<Throttler> throttlerOpt) throws TierObjectStoreRetriableException, IOException {
                throw new IOException("");
            }

            public void putInMemorySegment(ObjectMetadata objectMetadata, File segmentData, File offsetIndexData, File timestampIndexData, Optional<ByteBuffer> producerStateSnapshotData, Optional<ByteBuffer> transactionIndexData, Optional<ByteBuffer> epochState) throws IOException {
                throw new IOException("");
            }

            public void deleteSegment(ObjectMetadata objectMetadata) {
            }

            public void deleteVersions(List<TierObjectStore.KeyAndVersion> keys) {
            }

            public void close() {
            }
        };
    }
}

