/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher;

import io.confluent.kafka.storage.checksum.ChecksumParams;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.fetcher.FetchRequestTestUtils;
import kafka.tier.fetcher.OffsetIndexFetchRequest;
import kafka.tier.state.SegmentAndMetadataLayout;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.FragmentDescriptionWrapper;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import org.apache.kafka.storage.internals.log.OffsetIndex;
import org.apache.kafka.storage.internals.log.OffsetPosition;
import org.apache.kafka.storage.internals.log.TimestampOffset;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class OffsetIndexFetchRequestTest {
    private OffsetIndex offsetIndex = null;
    private final int maxEntries = 3;
    private final long baseOffset = 45L;
    private final TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
    private final ObjectMetadata tierObjectMetadata = new ObjectMetadata(this.topicIdPartition, UUID.randomUUID(), 0, 45L, false, false, false, OpaqueData.ZEROED, null);
    private final long emptyOffsetIndexSize = 0L;
    private final List<FragmentDescriptionWrapper> emptyLayout = FragmentDescriptionWrapper.createFragmentDescriptionsListWithOneFilePerFragment((TopicIdPartition)this.topicIdPartition, (int)10, (long)0L, (long)10L, (int)10, (int)10, (long)10L);
    private final ObjectMetadata objectMetadataWithEmptyOffsetIndex = new ObjectMetadata(this.topicIdPartition, UUID.randomUUID(), 0, 45L, false, false, false, OpaqueData.ZEROED, new SegmentAndMetadataLayout(this.emptyLayout));

    @BeforeEach
    public void setup() throws IOException {
        this.offsetIndex = new OffsetIndex(this.nonExistentTempFile(), 45L, 24, false, true, new ChecksumParams(Optional.of(kafka.utils.TestUtils.createChecksumStore()), true, true));
    }

    @AfterEach
    public void teardown() {
        if (this.offsetIndex != null) {
            this.offsetIndex.file().delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void emptyIndexFileTest() {
        CancellationContext cancellationContext = CancellationContext.newContext();
        TierObjectStore mockTierObjectStore = FetchRequestTestUtils.fileReturningTierObjectStore(this.offsetIndex.file(), null);
        try {
            OffsetPosition result = OffsetIndexFetchRequest.fetchOffsetPositionForStartingOffset((CancellationContext)cancellationContext, (TierObjectStore)mockTierObjectStore, (ObjectMetadata)this.objectMetadataWithEmptyOffsetIndex, (long)55L);
            Assertions.assertEquals((int)0, (int)result.position, (String)"an empty index file should return a segment position of 0");
        }
        catch (Exception e) {
            Assertions.fail((String)"unexpected exception");
        }
        finally {
            cancellationContext.cancel();
            mockTierObjectStore.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void emptyIndexFileAsyncTest(boolean isEndOffsetSpecified) {
        CancellationContext cancellationContext = CancellationContext.newContext();
        TierObjectStore mockTierObjectStore = FetchRequestTestUtils.fileReturningTierObjectStore(this.offsetIndex.file(), null);
        try {
            TimestampOffset[] timestampOffsetArray;
            if (isEndOffsetSpecified) {
                TimestampOffset[] timestampOffsetArray2 = new TimestampOffset[2];
                timestampOffsetArray2[0] = new TimestampOffset(1000L, 55L);
                timestampOffsetArray = timestampOffsetArray2;
                timestampOffsetArray2[1] = new TimestampOffset(2000L, 100L);
            } else {
                TimestampOffset[] timestampOffsetArray3 = new TimestampOffset[2];
                timestampOffsetArray3[0] = new TimestampOffset(1000L, 55L);
                timestampOffsetArray = timestampOffsetArray3;
                timestampOffsetArray3[1] = null;
            }
            TimestampOffset[] timestampOffsets = timestampOffsetArray;
            OffsetPosition[] result = (OffsetPosition[])OffsetIndexFetchRequest.fetchOffsetPositionForStartingOffsetAsync((CancellationContext)cancellationContext, (TierObjectStore)mockTierObjectStore, (ObjectMetadata)this.objectMetadataWithEmptyOffsetIndex, (TimestampOffset[])timestampOffsets).get();
            Assertions.assertEquals((int)0, (int)result[0].position, (String)"an empty index file should return a segment start position of 0");
            Assertions.assertNull((Object)result[1], (String)"an empty index file should return an invalid segment end position");
        }
        catch (Exception e) {
            Assertions.fail((String)"unexpected exception", (Throwable)e);
        }
        finally {
            cancellationContext.cancel();
            mockTierObjectStore.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void seekIndexFileExceptionTest() {
        CancellationContext cancellationContext = CancellationContext.newContext();
        this.offsetIndex.append(50L, 50);
        this.offsetIndex.append(55L, 55);
        this.offsetIndex.append(60L, 60);
        this.offsetIndex.flush();
        TierObjectStore mockTierObjectStore = FetchRequestTestUtils.fileReturningTierObjectStore(this.offsetIndex.file(), null);
        try {
            try {
                OffsetIndexFetchRequest.fetchOffsetPositionForStartingOffset((CancellationContext)cancellationContext, (TierObjectStore)FetchRequestTestUtils.ioExceptionThrowingTierObjectStore(), (ObjectMetadata)this.tierObjectMetadata, (long)30L);
            }
            catch (IOException e) {
                Assertions.assertNotNull((Object)e, (String)"IoExceptions are not propagated correctly");
            }
            catch (Exception e) {
                Assertions.fail((String)("Unexpected exception " + e));
            }
            CancellationContext canceledCancellationContext = CancellationContext.newContext();
            canceledCancellationContext.cancel();
            try {
                OffsetIndexFetchRequest.fetchOffsetPositionForStartingOffset((CancellationContext)canceledCancellationContext, (TierObjectStore)mockTierObjectStore, (ObjectMetadata)this.tierObjectMetadata, (long)30L);
            }
            catch (CancellationException e) {
                Assertions.assertNotNull((Object)e, (String)"CancellationExceptions are not propagated correctly");
            }
            catch (Exception e) {
                Assertions.fail((String)"Unexpected exception");
            }
        }
        finally {
            cancellationContext.cancel();
            mockTierObjectStore.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void seekIndexFileExceptionAsyncTest(boolean isEndOffsetSpecified) {
        TimestampOffset[] timestampOffsetArray;
        CancellationContext cancellationContext = CancellationContext.newContext();
        this.offsetIndex.append(50L, 50);
        this.offsetIndex.append(55L, 55);
        this.offsetIndex.append(60L, 60);
        this.offsetIndex.flush();
        TierObjectStore mockTierObjectStore = FetchRequestTestUtils.fileReturningTierObjectStore(this.offsetIndex.file(), null);
        if (isEndOffsetSpecified) {
            TimestampOffset[] timestampOffsetArray2 = new TimestampOffset[2];
            timestampOffsetArray2[0] = new TimestampOffset(1000L, 30L);
            timestampOffsetArray = timestampOffsetArray2;
            timestampOffsetArray2[1] = new TimestampOffset(2000L, 100L);
        } else {
            TimestampOffset[] timestampOffsetArray3 = new TimestampOffset[2];
            timestampOffsetArray3[0] = new TimestampOffset(1000L, 30L);
            timestampOffsetArray = timestampOffsetArray3;
            timestampOffsetArray3[1] = null;
        }
        TimestampOffset[] timestampOffsets = timestampOffsetArray;
        try {
            try {
                OffsetIndexFetchRequest.fetchOffsetPositionForStartingOffsetAsync((CancellationContext)cancellationContext, (TierObjectStore)FetchRequestTestUtils.ioExceptionThrowingTierObjectStore(), (ObjectMetadata)this.tierObjectMetadata, (TimestampOffset[])timestampOffsets).get();
            }
            catch (ExecutionException e) {
                Assertions.assertNotNull((Object)e);
                Assertions.assertTrue((boolean)(e.getCause() instanceof IOException), (String)"IoExceptions are not propagated correctly");
            }
            catch (Exception e) {
                Assertions.fail((String)("Unexpected exception " + e));
            }
            CancellationContext canceledCancellationContext = CancellationContext.newContext();
            canceledCancellationContext.cancel();
            try {
                OffsetIndexFetchRequest.fetchOffsetPositionForStartingOffsetAsync((CancellationContext)canceledCancellationContext, (TierObjectStore)mockTierObjectStore, (ObjectMetadata)this.tierObjectMetadata, (TimestampOffset[])timestampOffsets).get();
            }
            catch (ExecutionException e) {
                Assertions.assertNotNull((Object)e);
                Assertions.assertTrue((boolean)(e.getCause() instanceof CancellationException), (String)"CancellationExceptions are not propagated correctly");
            }
            catch (Exception e) {
                Assertions.fail((String)"Unexpected exception");
            }
        }
        finally {
            cancellationContext.cancel();
            mockTierObjectStore.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void seekIndexFileTest() {
        CancellationContext cancellationContext = CancellationContext.newContext();
        this.offsetIndex.append(50L, 50);
        this.offsetIndex.append(55L, 55);
        this.offsetIndex.append(60L, 60);
        this.offsetIndex.flush();
        TierObjectStore mockTierObjectStore = FetchRequestTestUtils.fileReturningTierObjectStore(this.offsetIndex.file(), null);
        try {
            OffsetPosition offsetPosition;
            try {
                offsetPosition = OffsetIndexFetchRequest.fetchOffsetPositionForStartingOffset((CancellationContext)cancellationContext, (TierObjectStore)mockTierObjectStore, (ObjectMetadata)this.tierObjectMetadata, (long)55L);
                Assertions.assertEquals((int)55, (int)offsetPosition.position, (String)"the desired offset position matches the appended position");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assertions.fail((String)("unexpected exception " + e));
            }
            try {
                offsetPosition = OffsetIndexFetchRequest.fetchOffsetPositionForStartingOffset((CancellationContext)cancellationContext, (TierObjectStore)mockTierObjectStore, (ObjectMetadata)this.tierObjectMetadata, (long)100L);
                Assertions.assertEquals((int)60, (int)offsetPosition.position, (String)"if the desired offset is out of range, return the highest position in the index file");
            }
            catch (Exception e) {
                Assertions.fail((String)"unexpected exception");
            }
            try {
                offsetPosition = OffsetIndexFetchRequest.fetchOffsetPositionForStartingOffset((CancellationContext)cancellationContext, (TierObjectStore)mockTierObjectStore, (ObjectMetadata)this.tierObjectMetadata, (long)30L);
                Assertions.assertEquals((int)0, (int)offsetPosition.position, (String)"if the desired offset is lower than all recorded offsets, return 0 for position");
            }
            catch (Exception e) {
                Assertions.fail((String)"unexpected exception");
            }
            Assertions.assertFalse((boolean)cancellationContext.isCancelled(), (String)"The CancellationContext is not canceled");
        }
        finally {
            cancellationContext.cancel();
            mockTierObjectStore.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void seekIndexFileAsyncTest(boolean isEndOffsetSpecified) {
        CancellationContext cancellationContext = CancellationContext.newContext();
        this.offsetIndex.append(50L, 500);
        this.offsetIndex.append(55L, 550);
        this.offsetIndex.append(60L, 600);
        this.offsetIndex.flush();
        TierObjectStore mockTierObjectStore = FetchRequestTestUtils.fileReturningTierObjectStore(this.offsetIndex.file(), null);
        try {
            OffsetPosition[] offsetPositions;
            TimestampOffset[] timestampOffsets;
            OffsetPosition[] offsetPositions2;
            try {
                if (isEndOffsetSpecified) {
                    offsetPositions2 = (OffsetPosition[])OffsetIndexFetchRequest.fetchOffsetPositionForStartingOffsetAsync((CancellationContext)cancellationContext, (TierObjectStore)mockTierObjectStore, (ObjectMetadata)this.tierObjectMetadata, (TimestampOffset[])new TimestampOffset[]{new TimestampOffset(1000L, 50L), new TimestampOffset(2000L, 52L)}).get();
                    Assertions.assertEquals((int)500, (int)offsetPositions2[0].position, (String)"the desired start offset position should match the appended position");
                    Assertions.assertEquals((int)600, (int)offsetPositions2[1].position, (String)"the desired end offset position should cover the specified end offset");
                } else {
                    offsetPositions2 = (OffsetPosition[])OffsetIndexFetchRequest.fetchOffsetPositionForStartingOffsetAsync((CancellationContext)cancellationContext, (TierObjectStore)mockTierObjectStore, (ObjectMetadata)this.tierObjectMetadata, (TimestampOffset[])new TimestampOffset[]{new TimestampOffset(1000L, 50L), null}).get();
                    Assertions.assertEquals((int)500, (int)offsetPositions2[0].position, (String)"the desired start offset position should match the appended position");
                    Assertions.assertNull((Object)offsetPositions2[1], (String)"the desired end offset position should be null [EOF]");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Assertions.fail((String)("unexpected exception " + e));
            }
            try {
                if (isEndOffsetSpecified) {
                    offsetPositions2 = (OffsetPosition[])OffsetIndexFetchRequest.fetchOffsetPositionForStartingOffsetAsync((CancellationContext)cancellationContext, (TierObjectStore)mockTierObjectStore, (ObjectMetadata)this.tierObjectMetadata, (TimestampOffset[])new TimestampOffset[]{new TimestampOffset(1000L, 52L), new TimestampOffset(2000L, 55L)}).get();
                    Assertions.assertEquals((int)500, (int)offsetPositions2[0].position, (String)"the desired start offset position should match the appended position");
                    Assertions.assertEquals((int)600, (int)offsetPositions2[1].position, (String)"the desired end offset position should cover the specified end offset");
                } else {
                    offsetPositions2 = (OffsetPosition[])OffsetIndexFetchRequest.fetchOffsetPositionForStartingOffsetAsync((CancellationContext)cancellationContext, (TierObjectStore)mockTierObjectStore, (ObjectMetadata)this.tierObjectMetadata, (TimestampOffset[])new TimestampOffset[]{new TimestampOffset(1000L, 52L), null}).get();
                    Assertions.assertEquals((int)500, (int)offsetPositions2[0].position, (String)"the desired start offset position should match the appended position");
                    Assertions.assertNull((Object)offsetPositions2[1], (String)"the desired end offset position should be null [EOF]");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Assertions.fail((String)("unexpected exception " + e));
            }
            try {
                TimestampOffset[] timestampOffsetArray;
                if (isEndOffsetSpecified) {
                    TimestampOffset[] timestampOffsetArray2 = new TimestampOffset[2];
                    timestampOffsetArray2[0] = new TimestampOffset(1000L, 52L);
                    timestampOffsetArray = timestampOffsetArray2;
                    timestampOffsetArray2[1] = new TimestampOffset(2000L, 58L);
                } else {
                    TimestampOffset[] timestampOffsetArray3 = new TimestampOffset[2];
                    timestampOffsetArray3[0] = new TimestampOffset(1000L, 52L);
                    timestampOffsetArray = timestampOffsetArray3;
                    timestampOffsetArray3[1] = null;
                }
                timestampOffsets = timestampOffsetArray;
                offsetPositions = (OffsetPosition[])OffsetIndexFetchRequest.fetchOffsetPositionForStartingOffsetAsync((CancellationContext)cancellationContext, (TierObjectStore)mockTierObjectStore, (ObjectMetadata)this.tierObjectMetadata, (TimestampOffset[])timestampOffsets).get();
                Assertions.assertEquals((int)500, (int)offsetPositions[0].position, (String)"the desired start offset position should match the appended position");
                Assertions.assertNull((Object)offsetPositions[1], (String)"the desired end offset position should be null [EOF]");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assertions.fail((String)("unexpected exception " + e));
            }
            try {
                TimestampOffset[] timestampOffsetArray;
                if (isEndOffsetSpecified) {
                    TimestampOffset[] timestampOffsetArray4 = new TimestampOffset[2];
                    timestampOffsetArray4[0] = new TimestampOffset(1000L, 100L);
                    timestampOffsetArray = timestampOffsetArray4;
                    timestampOffsetArray4[1] = new TimestampOffset(2000L, 200L);
                } else {
                    TimestampOffset[] timestampOffsetArray5 = new TimestampOffset[2];
                    timestampOffsetArray5[0] = new TimestampOffset(1000L, 100L);
                    timestampOffsetArray = timestampOffsetArray5;
                    timestampOffsetArray5[1] = null;
                }
                timestampOffsets = timestampOffsetArray;
                offsetPositions = (OffsetPosition[])OffsetIndexFetchRequest.fetchOffsetPositionForStartingOffsetAsync((CancellationContext)cancellationContext, (TierObjectStore)mockTierObjectStore, (ObjectMetadata)this.tierObjectMetadata, (TimestampOffset[])timestampOffsets).get();
                Assertions.assertEquals((int)600, (int)offsetPositions[0].position, (String)"if the desired start offset is out of range, return the highest position in the index file");
                Assertions.assertNull((Object)offsetPositions[1], (String)"the desired end offset position should be null [EOF]");
            }
            catch (Exception e) {
                Assertions.fail((String)"unexpected exception");
            }
            try {
                if (isEndOffsetSpecified) {
                    offsetPositions2 = (OffsetPosition[])OffsetIndexFetchRequest.fetchOffsetPositionForStartingOffsetAsync((CancellationContext)cancellationContext, (TierObjectStore)mockTierObjectStore, (ObjectMetadata)this.tierObjectMetadata, (TimestampOffset[])new TimestampOffset[]{new TimestampOffset(1000L, 30L), new TimestampOffset(2000L, 35L)}).get();
                    Assertions.assertEquals((int)0, (int)offsetPositions2[0].position, (String)"if the desired start offset is lower than all recorded offsets, return 0 for position");
                    Assertions.assertEquals((int)550, (int)offsetPositions2[1].position, (String)"return the entry after the first entry");
                } else {
                    offsetPositions2 = (OffsetPosition[])OffsetIndexFetchRequest.fetchOffsetPositionForStartingOffsetAsync((CancellationContext)cancellationContext, (TierObjectStore)mockTierObjectStore, (ObjectMetadata)this.tierObjectMetadata, (TimestampOffset[])new TimestampOffset[]{new TimestampOffset(1000L, 30L), null}).get();
                    Assertions.assertEquals((int)0, (int)offsetPositions2[0].position, (String)"if the desired start offset is lower than all recorded offsets, return 0 for position");
                    Assertions.assertNull((Object)offsetPositions2[1], (String)"the desired end offset position should be null [EOF]");
                }
            }
            catch (Exception e) {
                Assertions.fail((String)"unexpected exception");
            }
            Assertions.assertFalse((boolean)cancellationContext.isCancelled(), (String)"The CancellationContext is not canceled");
        }
        finally {
            cancellationContext.cancel();
            mockTierObjectStore.close();
        }
    }

    private File nonExistentTempFile() {
        File file;
        try {
            file = TestUtils.tempFile();
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            return null;
        }
        return file;
    }
}

