/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher;

import io.confluent.kafka.storage.checksum.ChecksumParams;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.fetcher.FetchRequestTestUtils;
import kafka.tier.fetcher.TimestampIndexFetchRequest;
import kafka.tier.state.SegmentAndMetadataLayout;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.FragmentDescriptionWrapper;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import org.apache.kafka.storage.internals.log.TimeIndex;
import org.apache.kafka.storage.internals.log.TimestampOffset;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TimestampIndexFetchRequestTest {
    private TimeIndex index = null;
    private final int maxEntries = 3;
    private final long baseOffset = 45L;
    private final TopicIdPartition topicIdPartition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
    private final ObjectMetadata tierObjectMetadata = new ObjectMetadata(this.topicIdPartition, UUID.randomUUID(), 0, 45L, false, false, false, OpaqueData.ZEROED, null);
    private final long emptyTimestampIndexSize = 0L;
    private final List<FragmentDescriptionWrapper> emptyLayout = FragmentDescriptionWrapper.createFragmentDescriptionsListWithOneFilePerFragment((TopicIdPartition)this.topicIdPartition, (int)10, (long)10L, (long)0L, (int)10, (int)10, (long)10L);
    private final ObjectMetadata objectMetadataWithEmptyTimestampIndex = new ObjectMetadata(this.topicIdPartition, UUID.randomUUID(), 0, 45L, false, false, false, OpaqueData.ZEROED, new SegmentAndMetadataLayout(this.emptyLayout));

    @BeforeEach
    public void setup() throws IOException {
        this.index = new TimeIndex(this.nonExistentTempFile(), 45L, 36, false, true, new ChecksumParams(Optional.of(kafka.utils.TestUtils.createChecksumStore()), true, true));
    }

    @AfterEach
    public void teardown() {
        if (this.index != null) {
            this.index.file().delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void emptyIndexFileTest() {
        CancellationContext cancellationContext = CancellationContext.newContext();
        TierObjectStore mockTierObjectStore = FetchRequestTestUtils.fileReturningTierObjectStore(null, this.index.file());
        try {
            TimestampOffset result = TimestampIndexFetchRequest.fetchOffsetForTimestamp((CancellationContext)cancellationContext, (TierObjectStore)mockTierObjectStore, (ObjectMetadata)this.objectMetadataWithEmptyTimestampIndex, (long)50L);
            Assertions.assertEquals((long)45L, (long)result.offset, (String)"an empty index file should return the base offset");
        }
        catch (Exception e) {
            Assertions.fail((String)"unexpected exception");
        }
        finally {
            cancellationContext.cancel();
            mockTierObjectStore.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void emptyIndexFileAsyncTest() {
        CancellationContext cancellationContext = CancellationContext.newContext();
        TierObjectStore mockTierObjectStore = FetchRequestTestUtils.fileReturningTierObjectStore(null, this.index.file());
        try {
            TimestampOffset[] result = (TimestampOffset[])TimestampIndexFetchRequest.fetchOffsetForTimestampAsync((CancellationContext)cancellationContext, (TierObjectStore)mockTierObjectStore, (ObjectMetadata)this.objectMetadataWithEmptyTimestampIndex, (long)50L).get();
            Assertions.assertEquals((long)45L, (long)result[0].offset, (String)"an empty index file should return the base offset");
            Assertions.assertNull((Object)result[1], (String)"an empty index file should return an invalid end offset");
        }
        catch (Exception e) {
            Assertions.fail((String)"unexpected exception");
        }
        finally {
            cancellationContext.cancel();
            mockTierObjectStore.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void seekIndexFileExceptionTest() {
        CancellationContext cancellationContext = CancellationContext.newContext();
        this.index.maybeAppend(10L, 50L, true);
        this.index.maybeAppend(20L, 60L, true);
        this.index.maybeAppend(30L, 100L, true);
        this.index.flush();
        TierObjectStore mockTierObjectStore = FetchRequestTestUtils.fileReturningTierObjectStore(null, this.index.file());
        try {
            try {
                TimestampIndexFetchRequest.fetchOffsetForTimestamp((CancellationContext)cancellationContext, (TierObjectStore)FetchRequestTestUtils.ioExceptionThrowingTierObjectStore(), (ObjectMetadata)this.tierObjectMetadata, (long)50L);
            }
            catch (IOException e) {
                Assertions.assertNotNull((Object)e, (String)"IoExceptions are not propagated correctly");
            }
            catch (Exception e) {
                Assertions.fail((String)("Unexpected exception " + e));
            }
            CancellationContext canceledCancellationContext = CancellationContext.newContext();
            canceledCancellationContext.cancel();
            try {
                TimestampIndexFetchRequest.fetchOffsetForTimestamp((CancellationContext)canceledCancellationContext, (TierObjectStore)mockTierObjectStore, (ObjectMetadata)this.tierObjectMetadata, (long)50L);
            }
            catch (CancellationException e) {
                Assertions.assertNotNull((Object)e, (String)"CancellationExceptions are not propagated correctly");
            }
            catch (Exception e) {
                Assertions.fail((String)"Unexpected exception");
            }
        }
        finally {
            cancellationContext.cancel();
            mockTierObjectStore.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void seekIndexFileExceptionAsyncTest() {
        CancellationContext cancellationContext = CancellationContext.newContext();
        this.index.maybeAppend(10L, 50L, true);
        this.index.maybeAppend(20L, 60L, true);
        this.index.maybeAppend(30L, 100L, true);
        this.index.flush();
        TierObjectStore mockTierObjectStore = FetchRequestTestUtils.fileReturningTierObjectStore(null, this.index.file());
        try {
            try {
                TimestampIndexFetchRequest.fetchOffsetForTimestampAsync((CancellationContext)cancellationContext, (TierObjectStore)FetchRequestTestUtils.ioExceptionThrowingTierObjectStore(), (ObjectMetadata)this.tierObjectMetadata, (long)50L).get();
            }
            catch (ExecutionException e) {
                Assertions.assertNotNull((Object)e);
                Assertions.assertTrue((boolean)(e.getCause() instanceof IOException), (String)"IoExceptions are not propagated correctly");
            }
            catch (Exception e) {
                Assertions.fail((String)("Unexpected exception " + e));
            }
            CancellationContext canceledCancellationContext = CancellationContext.newContext();
            canceledCancellationContext.cancel();
            try {
                TimestampIndexFetchRequest.fetchOffsetForTimestampAsync((CancellationContext)canceledCancellationContext, (TierObjectStore)mockTierObjectStore, (ObjectMetadata)this.tierObjectMetadata, (long)50L).get();
            }
            catch (ExecutionException e) {
                Assertions.assertNotNull((Object)e);
                Assertions.assertTrue((boolean)(e.getCause() instanceof CancellationException), (String)"CancellationExceptions are not propagated correctly");
            }
            catch (Exception e) {
                Assertions.fail((String)"Unexpected exception");
            }
        }
        finally {
            cancellationContext.cancel();
            mockTierObjectStore.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void seekIndexFileTest() {
        CancellationContext cancellationContext = CancellationContext.newContext();
        this.index.maybeAppend(10L, 50L, true);
        this.index.maybeAppend(20L, 60L, true);
        this.index.maybeAppend(30L, 100L, true);
        this.index.flush();
        TierObjectStore mockTierObjectStore = FetchRequestTestUtils.fileReturningTierObjectStore(null, this.index.file());
        try {
            TimestampOffset result;
            try {
                result = TimestampIndexFetchRequest.fetchOffsetForTimestamp((CancellationContext)cancellationContext, (TierObjectStore)mockTierObjectStore, (ObjectMetadata)this.tierObjectMetadata, (long)10L);
                Assertions.assertEquals((long)50L, (long)result.offset, (String)"the desired timestamp offset position matches the appended record");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assertions.fail((String)("unexpected exception " + e));
            }
            try {
                result = TimestampIndexFetchRequest.fetchOffsetForTimestamp((CancellationContext)cancellationContext, (TierObjectStore)mockTierObjectStore, (ObjectMetadata)this.tierObjectMetadata, (long)12L);
                Assertions.assertEquals((long)50L, (long)result.offset, (String)"the desired timestamp offset position matches the previous record");
            }
            catch (Exception e) {
                Assertions.fail((String)"unexpected exception");
            }
            try {
                result = TimestampIndexFetchRequest.fetchOffsetForTimestamp((CancellationContext)cancellationContext, (TierObjectStore)mockTierObjectStore, (ObjectMetadata)this.tierObjectMetadata, (long)50L);
                Assertions.assertEquals((long)100L, (long)result.offset, (String)"if the desired timestamp is out of range, return the last entry in the index file");
            }
            catch (Exception e) {
                Assertions.fail((String)"unexpected exception");
            }
            try {
                result = TimestampIndexFetchRequest.fetchOffsetForTimestamp((CancellationContext)cancellationContext, (TierObjectStore)mockTierObjectStore, (ObjectMetadata)this.tierObjectMetadata, (long)1L);
                Assertions.assertEquals((long)45L, (long)result.offset, (String)"if the desired timestamp is smaller than all timestamps, return the base offset");
            }
            catch (Exception e) {
                Assertions.fail((String)"unexpected exception");
            }
            Assertions.assertFalse((boolean)cancellationContext.isCancelled(), (String)"The CancellationContext is not canceled");
        }
        finally {
            cancellationContext.cancel();
            mockTierObjectStore.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void seekIndexFileAsyncTest() {
        CancellationContext cancellationContext = CancellationContext.newContext();
        this.index.maybeAppend(10L, 50L, true);
        this.index.maybeAppend(20L, 60L, true);
        this.index.maybeAppend(30L, 100L, true);
        this.index.flush();
        TierObjectStore mockTierObjectStore = FetchRequestTestUtils.fileReturningTierObjectStore(null, this.index.file());
        try {
            TimestampOffset[] result;
            try {
                result = (TimestampOffset[])TimestampIndexFetchRequest.fetchOffsetForTimestampAsync((CancellationContext)cancellationContext, (TierObjectStore)mockTierObjectStore, (ObjectMetadata)this.tierObjectMetadata, (long)10L).get();
                Assertions.assertEquals((long)50L, (long)result[0].offset, (String)"the desired timestamp offset position matches the appended record");
                Assertions.assertEquals((long)60L, (long)result[1].offset, (String)"the desired timestamp offset position matches the next record");
            }
            catch (Exception e) {
                e.printStackTrace();
                Assertions.fail((String)("unexpected exception " + e));
            }
            try {
                result = (TimestampOffset[])TimestampIndexFetchRequest.fetchOffsetForTimestampAsync((CancellationContext)cancellationContext, (TierObjectStore)mockTierObjectStore, (ObjectMetadata)this.tierObjectMetadata, (long)12L).get();
                Assertions.assertEquals((long)50L, (long)result[0].offset, (String)"the desired timestamp offset position matches the previous record");
                Assertions.assertEquals((long)60L, (long)result[1].offset, (String)"the desired timestamp offset position matches the next record");
            }
            catch (Exception e) {
                Assertions.fail((String)"unexpected exception");
            }
            try {
                result = (TimestampOffset[])TimestampIndexFetchRequest.fetchOffsetForTimestampAsync((CancellationContext)cancellationContext, (TierObjectStore)mockTierObjectStore, (ObjectMetadata)this.tierObjectMetadata, (long)50L).get();
                Assertions.assertEquals((long)100L, (long)result[0].offset, (String)"if the desired timestamp is out of range, return the last entry in the index file");
                Assertions.assertNull((Object)result[1], (String)"the desired timestamp offset should be null [EOF]");
            }
            catch (Exception e) {
                Assertions.fail((String)"unexpected exception");
            }
            try {
                result = (TimestampOffset[])TimestampIndexFetchRequest.fetchOffsetForTimestampAsync((CancellationContext)cancellationContext, (TierObjectStore)mockTierObjectStore, (ObjectMetadata)this.tierObjectMetadata, (long)1L).get();
                Assertions.assertEquals((long)45L, (long)result[0].offset, (String)"if the desired timestamp is smaller than all timestamps, return the base offset");
                Assertions.assertEquals((long)50L, (long)result[1].offset, (String)"the desired timestamp should be the first entry in the index file");
            }
            catch (Exception e) {
                Assertions.fail((String)"unexpected exception");
            }
            Assertions.assertFalse((boolean)cancellationContext.isCancelled(), (String)"The CancellationContext is not canceled");
        }
        finally {
            cancellationContext.cancel();
            mockTierObjectStore.close();
        }
    }

    private File nonExistentTempFile() {
        File file;
        try {
            file = TestUtils.tempFile();
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            return null;
        }
        return file;
    }
}

