/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.management;

import io.confluent.kafka.backupRestore.objectLifecycle.serdes.LifecycleManagerState;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.TierLogSegment;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.backupObjectLifecycle.LifecycleManager;
import kafka.tier.backupObjectLifecycle.NameAndId;
import kafka.tier.backupObjectLifecycle.StateManager;
import kafka.tier.backupObjectLifecycle.StateManagerConfig;
import kafka.tier.backupObjectLifecycle.TierTopicReader;
import kafka.tier.management.BackupObjectLifecycleManagerTestUtils;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.TierObjectStore;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.utils.Exit;
import org.joda.time.DateTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SortedMap;
import scala.collection.mutable.SortedMap$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u00055b\u0001\u0002\u000b\u0016\u0001qAQ!\t\u0001\u0005\u0002\tBq\u0001\n\u0001C\u0002\u0013\u0005Q\u0005\u0003\u00044\u0001\u0001\u0006IA\n\u0005\bi\u0001\u0011\r\u0011\"\u00016\u0011\u0019\t\u0005\u0001)A\u0005m!9!\t\u0001b\u0001\n\u0003)\u0003BB\"\u0001A\u0003%a\u0005C\u0004E\u0001\t\u0007I\u0011A\u001b\t\r\u0015\u0003\u0001\u0015!\u00037\u0011\u001d1\u0005A1A\u0005\u0002\u0015Baa\u0012\u0001!\u0002\u00131\u0003b\u0002%\u0001\u0005\u0004%\t!\u000e\u0005\u0007\u0013\u0002\u0001\u000b\u0011\u0002\u001c\t\u000f)\u0003!\u0019!C\u0001\u0017\"1\u0001\u000b\u0001Q\u0001\n1CQ!\u0015\u0001\u0005BICQA\u001a\u0001\u0005\u0002\u001dDq!a\u0004\u0001\t\u0003\t\t\u0002C\u0004\u0002 \u0001!\t!!\t\u0003C\t\u000b7m[;q\u001f\nTWm\u0019;MS\u001a,7-_2mK6\u000bg.Y4feR+7\u000f^:\u000b\u0005Y9\u0012AC7b]\u0006<W-\\3oi*\u0011\u0001$G\u0001\u0005i&,'OC\u0001\u001b\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u000f\u0011\u0005yyR\"A\u000b\n\u0005\u0001*\"!\n\"bG.,\bo\u00142kK\u000e$H*\u001b4fGf\u001cG.Z'b]\u0006<WM\u001d+fgR,F/\u001b7t\u0003\u0019a\u0014N\\5u}Q\t1\u0005\u0005\u0002\u001f\u0001\u00059Ao\u001c9jG~\u000bT#\u0001\u0014\u0011\u0005\u001d\u0002dB\u0001\u0015/!\tIC&D\u0001+\u0015\tY3$\u0001\u0004=e>|GO\u0010\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006L\u0001\u0007!J,G-\u001a4\n\u0005E\u0012$AB*ue&twM\u0003\u00020Y\u0005AAo\u001c9jG~\u000b\u0004%\u0001\u0003ua~\u000bT#\u0001\u001c\u0011\u0005]zT\"\u0001\u001d\u000b\u0005eR\u0014AB2p[6|gN\u0003\u0002\u001bw)\u0011A(P\u0001\u0007CB\f7\r[3\u000b\u0003y\n1a\u001c:h\u0013\t\u0001\u0005H\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u000bQ\u0004x,\r\u0011\u0002\u000fQ|\u0007/[2`e\u0005AAo\u001c9jG~\u0013\u0004%\u0001\u0003ua~\u0013\u0014!\u0002;q?J\u0002\u0013a\u0002;pa&\u001cwlM\u0001\ti>\u0004\u0018nY04A\u0005!A\u000f]04\u0003\u0015!\boX\u001a!\u00035qW/\u001c)beRLG/[8ogV\tA\n\u0005\u0002N\u001d6\tA&\u0003\u0002PY\t\u0019\u0011J\u001c;\u0002\u001d9,X\u000eU1si&$\u0018n\u001c8tA\u0005)1/\u001a;VaR\u00111K\u0016\t\u0003\u001bRK!!\u0016\u0017\u0003\tUs\u0017\u000e\u001e\u0005\u0006/B\u0001\r\u0001W\u0001\ti\u0016\u001cH/\u00138g_B\u0011\u0011\fY\u0007\u00025*\u00111\fX\u0001\u0004CBL'BA/_\u0003\u001dQW\u000f]5uKJT!aX\u001f\u0002\u000b),h.\u001b;\n\u0005\u0005T&\u0001\u0003+fgRLeNZ8)\u0005A\u0019\u0007CA-e\u0013\t)'L\u0001\u0006CK\u001a|'/Z#bG\"\fA\u0006^3tiN+w-\\3oiN$vNQ3EK2,G/\u001a3U_\u0012\f\u0017pR3ug\u0012+G.\u001a;fIR{G-Y=\u0015\u0005MC\u0007\"B5\u0012\u0001\u00041\u0013AB9v_J,X\u000e\u000b\u0003\u0012WF\u0014\bC\u00017p\u001b\u0005i'B\u00018]\u0003\u0019\u0001\u0018M]1ng&\u0011\u0001/\u001c\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\u00028b[\u0016\f\u0013a]\u0001#w\u0012L7\u000f\u001d7bs:\u000bW.Z?/w\u0006\u0014x-^7f]R\u001cx+\u001b;i\u001d\u0006lWm]?)\tE)\b0\u001f\t\u00033ZL!a\u001e.\u0003\u000fQKW.Z8vi\u0006)a/\u00197vKz\t\u0001\u0010\u000b\u0004\u0012w\u0006\r\u0011Q\u0001\t\u0003y~l\u0011! \u0006\u0003}6\f\u0001\u0002\u001d:pm&$WM]\u0005\u0004\u0003\u0003i(a\u0003,bYV,7k\\;sG\u0016\fqa\u001d;sS:<7\u000f\f\u0003\u0002\b\u0005-\u0011EAA\u0005\u0003\tQ8.\t\u0002\u0002\u000e\u0005)1N]1gi\u0006YB/Z:u\u00072ku)\u001a;t\u00032dGk\u001c9jG6+G/\u00193bi\u0006$2aUA\n\u0011\u0015I'\u00031\u0001'Q\u0011\u00112.\u001d:)\u000bI)\b0!\u0007\u001f\u0003qBcAE>\u0002\u0004\u0005uA\u0006BA\u0004\u0003\u0017\ta\u0004^3ti\u000ecUjQ8ogVlWm\u001d#fY\u0016$X\rZ*fO6,g\u000e^:\u0015\u0007M\u000b\u0019\u0003C\u0003j'\u0001\u0007a\u0005\u000b\u0003\u0014WF\u0014\b&B\nvq\u0006e\u0001FB\n|\u0003\u0007\tY\u0003\f\u0003\u0002\b\u0005-\u0001")
public class BackupObjectLifecycleManagerTests
extends BackupObjectLifecycleManagerTestUtils {
    private final String topic_1;
    private final TopicPartition tp_1 = new TopicPartition(this.topic_1(), 0);
    private final String topic_2;
    private final TopicPartition tp_2 = new TopicPartition(this.topic_2(), 0);
    private final String topic_3;
    private final TopicPartition tp_3 = new TopicPartition(this.topic_3(), 0);
    private final int numPartitions;

    public String topic_1() {
        return this.topic_1;
    }

    public TopicPartition tp_1() {
        return this.tp_1;
    }

    public String topic_2() {
        return this.topic_2;
    }

    public TopicPartition tp_2() {
        return this.tp_2;
    }

    public String topic_3() {
        return this.topic_3;
    }

    public TopicPartition tp_3() {
        return this.tp_3;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        Exit.setExitProcedure((x$1, x$2) -> this.exited().set(true));
        this.serverConfig().put(KafkaConfig$.MODULE$.CLMMaxBackupInDaysProp(), "7");
        this.serverConfig().put(KafkaConfig$.MODULE$.CLMTopicRetentionInDaysToBackupInDaysProp(), "0:0,3:3,4:4,5:5,6:6,7:7");
        this._testInfo_$eq(testInfo);
        super.setUp(this._testInfo());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @Timeout(value=120L)
    @ValueSource(strings={"zk", "kraft"})
    public void testSegmentsToBeDeletedTodayGetsDeletedToday(String quorum) {
        LifecycleManager clm = this.lifecycleManager();
        MockInMemoryTierObjectStore mockInMemoryTierObjectStore = (MockInMemoryTierObjectStore)((KafkaBroker)this.brokers().head()).tierObjectStoreOpt().get();
        String x$1 = this.tp_1().topic();
        Properties x$2 = this.topicProps();
        int x$32 = this.createTopic$default$2();
        int x$42 = this.createTopic$default$3();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        int topic1LeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(x$1, x$32, x$42, x$2, x$5, x$6).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(this.tp_1(), this.brokerForId(topic1LeaderId).toList());
        this.changeTopicConfig("retention.ms", "120000", this.tp_1().topic());
        this.appendMessagesToLeaderAndWaitUntilTiered(this.tp_1(), topic1LeaderId, 1);
        Option leader1Log = ((KafkaBroker)this.brokerForId(topic1LeaderId).get()).replicaManager().getLog(this.tp_1());
        FileTierPartitionState ftps1 = (FileTierPartitionState)((AbstractLog)leader1Log.get()).tierPartitionState();
        ((KafkaBroker)this.brokerForId(topic1LeaderId).get()).replicaManager().deleteRecords(60000L, (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_1()), (Object)BoxesRunTime.boxToLong((long)((AbstractLog)leader1Log.get()).logEndOffset()))})), (Function1 & Serializable)x$3 -> {
            BackupObjectLifecycleManagerTests.$anonfun$testSegmentsToBeDeletedTodayGetsDeletedToday$1(x$3);
            return BoxedUnit.UNIT;
        });
        long l = 500L;
        long waitUntilTrue_waitTimeMs = 600000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BackupObjectLifecycleManagerTests.$anonfun$testSegmentsToBeDeletedTodayGetsDeletedToday$2(ftps1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)BackupObjectLifecycleManagerTests.$anonfun$testSegmentsToBeDeletedTodayGetsDeletedToday$3(this, leader1Log));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        HashSet<UUID> deletedSegmentsTP1 = new HashSet<UUID>();
        deletedSegmentsTP1.addAll(TierTestUtils$.MODULE$.deletedSegments(ftps1, -1L));
        String x$7 = this.tp_2().topic();
        Properties x$8 = this.topicProps();
        int x$9 = this.createTopic$default$2();
        int x$10 = this.createTopic$default$3();
        ListenerName x$11 = this.createTopic$default$5();
        Properties x$12 = this.createTopic$default$6();
        int topic2LeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(x$7, x$9, x$10, x$8, x$11, x$12).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(this.tp_2(), this.brokerForId(topic2LeaderId).toList());
        this.changeTopicConfig("retention.ms", "259200000", this.tp_2().topic());
        this.appendMessagesToLeaderAndWaitUntilTiered(this.tp_2(), topic2LeaderId, 1);
        Option leader2Log = ((KafkaBroker)this.brokerForId(topic2LeaderId).get()).replicaManager().getLog(this.tp_2());
        FileTierPartitionState ftps2 = (FileTierPartitionState)((AbstractLog)leader2Log.get()).tierPartitionState();
        long curTime = System.currentTimeMillis();
        ((KafkaBroker)this.brokerForId(topic2LeaderId).get()).replicaManager().deleteRecords(60000L, (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp_2()), (Object)BoxesRunTime.boxToLong((long)((AbstractLog)leader2Log.get()).logEndOffset()))})), (Function1 & Serializable)x$4 -> {
            BackupObjectLifecycleManagerTests.$anonfun$testSegmentsToBeDeletedTodayGetsDeletedToday$4(x$4);
            return BoxedUnit.UNIT;
        });
        long l2 = 500L;
        long waitUntilTrue_waitTimeMs2 = 60000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!BackupObjectLifecycleManagerTests.$anonfun$testSegmentsToBeDeletedTodayGetsDeletedToday$5(ftps2)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Leader2 logs aren't deleted after retention bytes change");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        HashSet<UUID> deletedSegmentsTP2 = new HashSet<UUID>();
        deletedSegmentsTP2.addAll(TierTestUtils$.MODULE$.deletedSegments(ftps2, -1L));
        Assertions.assertTrue((boolean)this.validateSegmentsAreDeleteMarked((AbstractLog)leader1Log.get()));
        Assertions.assertTrue((boolean)this.validateSegmentsAreDeleteMarked((AbstractLog)leader2Log.get()));
        clm.manageLifecycleForBackedUpSegments();
        this.checkNonCurrentObjectExistence(deletedSegmentsTP1, (TopicIdPartition)ftps1.topicIdPartition().get(), (TierObjectStore)mockInMemoryTierObjectStore, false);
        LifecycleManagerState lifecycleManagerState = StateManager.getState((StateManagerConfig)new StateManagerConfig((TierObjectStore)mockInMemoryTierObjectStore, ((KafkaBroker)this.brokers().head()).clusterId(), () -> Predef$.MODULE$.boolean2Boolean(true), () -> Predef$.MODULE$.boolean2Boolean(false)));
        .colon.colon retentionInfoList = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.RetentionInfo(this, this.tp_1().topic(), 0, -1, false, false), (List)new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.RetentionInfo(this, this.tp_2().topic(), 3, -1, false, false), (List)Nil$.MODULE$));
        .colon.colon latestDataFilesInfoList = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo(this, this.convertToDate(curTime, 3), "00000001"), (List)Nil$.MODULE$);
        BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState lifecycleManagerExpectedState = new BackupObjectLifecycleManagerTestUtils.LifecycleManagerExpectedState(this, (List<BackupObjectLifecycleManagerTestUtils.RetentionInfo>)retentionInfoList, (List<BackupObjectLifecycleManagerTestUtils.LatestDataFilesInfo>)latestDataFilesInfoList, 1);
        this.validateLifecycleManagerState(mockInMemoryTierObjectStore, lifecycleManagerExpectedState);
        .colon.colon blobMetadata = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.BlobMetadata(this, 3L, new DateTime(curTime + 259200000L).dayOfMonth().get()), (List)Nil$.MODULE$);
        .colon.colon topicMetadataList = new .colon.colon((Object)new BackupObjectLifecycleManagerTestUtils.TopicMetadata(this, this.tp_2().topic(), ((TopicIdPartition)((AbstractLog)leader2Log.get()).topicIdPartition().get()).topicId().toString(), 0, TierTestUtils$.MODULE$.deletedSegments(ftps2, -1L), (List<BackupObjectLifecycleManagerTestUtils.BlobMetadata>)blobMetadata), (List)Nil$.MODULE$);
        BackupObjectLifecycleManagerTestUtils.BackupObjectsState backupObjectsState = new BackupObjectLifecycleManagerTestUtils.BackupObjectsState(this, (List<BackupObjectLifecycleManagerTestUtils.TopicMetadata>)topicMetadataList);
        this.validateBackupObjectsDeletionState(mockInMemoryTierObjectStore, lifecycleManagerState.latestDataFiles(0).latestFile(), lifecycleManagerState.latestDataFiles(0).date(), backupObjectsState);
        this.checkNonCurrentObjectExistence(deletedSegmentsTP2, (TopicIdPartition)ftps2.topicIdPartition().get(), (TierObjectStore)mockInMemoryTierObjectStore, true);
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @Timeout(value=60L)
    @ValueSource(strings={"zk", "kraft"})
    public void testCLMGetsAllTopicMetadata(String quorum) {
        LifecycleManager clm = this.lifecycleManager();
        Properties props = new Properties();
        props.setProperty("retention.ms", "3600000");
        String x$1 = this.topic_1();
        int x$3 = this.createTopic$default$2();
        int x$4 = this.createTopic$default$3();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        int topic1LeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(x$1, x$3, x$4, props, x$5, x$6).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(this.tp_1(), this.brokerForId(topic1LeaderId).toList());
        LogManager qual$1 = ((KafkaBroker)this.brokerForId(topic1LeaderId).get()).logManager();
        TopicPartition x$7 = this.tp_1();
        boolean x$8 = qual$1.getLog$default$2();
        Uuid topic1id = (Uuid)((AbstractLog)qual$1.getLog(x$7, x$8).get()).topicId().get();
        props.setProperty("retention.ms", "-1");
        String x$9 = this.topic_2();
        int x$11 = this.createTopic$default$2();
        int x$12 = this.createTopic$default$3();
        ListenerName x$13 = this.createTopic$default$5();
        Properties x$14 = this.createTopic$default$6();
        int topic2LeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(x$9, x$11, x$12, props, x$13, x$14).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(this.tp_2(), this.brokerForId(topic2LeaderId).toList());
        LogManager qual$2 = ((KafkaBroker)this.brokerForId(topic2LeaderId).get()).logManager();
        TopicPartition x$15 = this.tp_2();
        boolean x$16 = qual$2.getLog$default$2();
        Uuid topic2id = (Uuid)((AbstractLog)qual$2.getLog(x$15, x$16).get()).topicId().get();
        props.setProperty("cleanup.policy", "compact");
        String x$17 = this.topic_3();
        int x$19 = this.createTopic$default$2();
        int x$20 = this.createTopic$default$3();
        ListenerName x$21 = this.createTopic$default$5();
        Properties x$22 = this.createTopic$default$6();
        int topic3LeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(x$17, x$19, x$20, props, x$21, x$22).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(this.tp_3(), this.brokerForId(topic3LeaderId).toList());
        LogManager qual$3 = ((KafkaBroker)this.brokerForId(topic3LeaderId).get()).logManager();
        TopicPartition x$23 = this.tp_3();
        boolean x$24 = qual$3.getLog$default$2();
        Uuid topic3id = (Uuid)((AbstractLog)qual$3.getLog(x$23, x$24).get()).topicId().get();
        java.util.Map retentionConfigs = clm.getKafkaTopicRetentionMs();
        Assertions.assertTrue((retentionConfigs.size() > 0 ? 1 : 0) != 0);
        NameAndId topic1Info = new NameAndId(this.topic_1(), topic1id);
        NameAndId topic2Info = new NameAndId(this.topic_2(), topic2id);
        Predef$.MODULE$.assert(true);
        Assertions.assertTrue((retentionConfigs.containsKey(topic1Info) && BoxesRunTime.equals(retentionConfigs.get(topic1Info), (Object)BoxesRunTime.boxToInteger((int)3600000)) ? 1 : 0) != 0);
        Assertions.assertTrue((retentionConfigs.containsKey(topic2Info) && BoxesRunTime.equals(retentionConfigs.get(topic2Info), (Object)BoxesRunTime.boxToInteger((int)-1)) ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)retentionConfigs.containsKey(new NameAndId(this.topic_3(), topic3id)));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @Timeout(value=60L)
    @ValueSource(strings={"zk", "kraft"})
    public void testCLMConsumesDeletedSegments(String quorum) {
        Properties props = new Properties();
        props.put("segment.bytes", "2048");
        props.put("confluent.tier.local.hotset.ms", "10");
        props.put("confluent.tier.local.hotset.bytes", "0");
        props.put("file.delete.delay.ms", "10");
        String x$1 = this.tp_1().topic();
        int x$3 = this.createTopic$default$2();
        int x$4 = this.createTopic$default$3();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        int leaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(x$1, x$3, x$4, props, x$5, x$6).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(this.tp_1(), this.brokerForId(leaderId).toList());
        this.appendMessagesToLeaderAndWaitUntilTiered(this.tp_1(), leaderId, this.appendMessagesToLeaderAndWaitUntilTiered$default$3());
        long l = 500L;
        long waitUntilTrue_waitTimeMs = 50000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!this.isHotsetDeleted(this.tp_1(), leaderId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Waiting for hot set to reduce");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Option log = ((KafkaBroker)this.brokerForId(leaderId).get()).replicaManager().getLog(this.tp_1());
        ArrayList tierOffsets = new ArrayList();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.tierMetadataNumPartitionsProp()).foreach((Function1)(JFunction1.mcZI.sp & Serializable)i -> tierOffsets.add(Predef$.MODULE$.long2Long(0L)));
        SortedMap allTieredSegments = (SortedMap)SortedMap$.MODULE$.apply((Seq)Nil$.MODULE$, (Ordering)Ordering.Long$.MODULE$);
        Iterator tieredSegmentsIter = ((AbstractLog)log.get()).tieredLogSegments();
        while (tieredSegmentsIter.hasNext()) {
            TierLogSegment segment = (TierLogSegment)tieredSegmentsIter.next();
            allTieredSegments.put((Object)BoxesRunTime.boxToLong((long)segment.baseOffset()), (Object)segment);
        }
        LifecycleManager clm = this.lifecycleManager();
        FileTierPartitionState ftps1 = (FileTierPartitionState)((AbstractLog)log.get()).tierPartitionState();
        TierTopicReader tierTopicReader = clm.createTierTopicReader(tierOffsets);
        java.util.List deletedSegmentsAtCLM_1 = tierTopicReader.deletedSegments();
        long[] newTierOffsets = tierTopicReader.currentPositions();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), newTierOffsets.length).foreach((Function1 & Serializable)i -> tierOffsets.set(BoxesRunTime.unboxToInt((Object)i), Predef$.MODULE$.long2Long(newTierOffsets[BoxesRunTime.unboxToInt((Object)i)])));
        tierTopicReader.maybeCloseConsumer();
        Predef$.MODULE$.assert(deletedSegmentsAtCLM_1.isEmpty());
        long newRetentionBytes = ((AbstractLog)log.get()).size() - (this.getSizeOfTieredSegments((AbstractLog)log.get(), 3) + 1L);
        long newStartOffset = ((Tuple2)allTieredSegments.toList().apply(3))._1$mcJ$sp();
        this.changeTopicConfig("retention.bytes", Long.toString(newRetentionBytes), this.tp_1().topic());
        long l2 = 500L;
        long waitUntilTrue_waitTimeMs2 = 30000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!BackupObjectLifecycleManagerTests.$anonfun$testCLMConsumesDeletedSegments$5(log, newStartOffset)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Older segments did not delete per new retention size");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        TierTopicReader tierTopicReader2 = clm.createTierTopicReader(tierOffsets);
        Set<UUID> deletedSegmentsAtTPS = TierTestUtils$.MODULE$.deletedSegments(ftps1, -1L);
        java.util.List deletedSegmentsAtCLM = tierTopicReader2.deletedSegments();
        Predef$.MODULE$.assert(deletedSegmentsAtCLM.size() > 0 && deletedSegmentsAtCLM.size() == deletedSegmentsAtTPS.size());
        Predef$.MODULE$.assert(deletedSegmentsAtCLM.stream().allMatch(s -> deletedSegmentsAtTPS.contains(s.getObjectId())));
        scala.collection.mutable.Set deletedSegments = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Set liveSegments = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        for (Tuple2 segment : allTieredSegments) {
            if (segment._1$mcJ$sp() < newStartOffset) {
                deletedSegments.add((Object)((TierLogSegment)segment._2()).objectId());
                continue;
            }
            liveSegments.add((Object)((TierLogSegment)segment._2()).objectId());
        }
        tierTopicReader = clm.createTierTopicReader(tierOffsets);
        java.util.List deletedSegmentsAtCLM_2 = tierTopicReader.deletedSegments();
        tierTopicReader.maybeCloseConsumer();
        Predef$.MODULE$.assert(deletedSegmentsAtCLM_2.size() > 0);
        deletedSegmentsAtCLM_2.stream().forEach(s -> Predef$.MODULE$.assert(deletedSegments.contains((Object)s.getObjectId())));
        deletedSegmentsAtCLM_2.stream().forEach(s -> Assertions.assertFalse((boolean)liveSegments.contains((Object)s.getObjectId())));
    }

    public static final /* synthetic */ void $anonfun$testSegmentsToBeDeletedTodayGetsDeletedToday$1(Map x$3) {
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentsToBeDeletedTodayGetsDeletedToday$2(FileTierPartitionState ftps1$1) {
        return TierTestUtils$.MODULE$.deletedSegments(ftps1$1, -1L).size() >= 1;
    }

    public static final /* synthetic */ String $anonfun$testSegmentsToBeDeletedTodayGetsDeletedToday$3(BackupObjectLifecycleManagerTests $this, Option leader1Log$1) {
        return new StringBuilder(39).append("Segments deleted = ").append($this.getDeletedTieredSegments((AbstractLog)leader1Log$1.get()).size()).append(" Expected at-least 1").toString();
    }

    public static final /* synthetic */ void $anonfun$testSegmentsToBeDeletedTodayGetsDeletedToday$4(Map x$4) {
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentsToBeDeletedTodayGetsDeletedToday$5(FileTierPartitionState ftps2$1) {
        return TierTestUtils$.MODULE$.deletedSegments(ftps2$1, -1L).size() >= 1;
    }

    public static final /* synthetic */ String $anonfun$testSegmentsToBeDeletedTodayGetsDeletedToday$6() {
        return "Leader2 logs aren't deleted after retention bytes change";
    }

    public static final /* synthetic */ String $anonfun$testCLMConsumesDeletedSegments$2() {
        return "Waiting for hot set to reduce";
    }

    public static final /* synthetic */ boolean $anonfun$testCLMConsumesDeletedSegments$5(Option log$1, long newStartOffset$1) {
        return BoxesRunTime.equals(((AbstractLog)log$1.get()).tierPartitionState().startOffset().get(), (Object)BoxesRunTime.boxToLong((long)newStartOffset$1));
    }

    public static final /* synthetic */ String $anonfun$testCLMConsumesDeletedSegments$6() {
        return "Older segments did not delete per new retention size";
    }

    public BackupObjectLifecycleManagerTests() {
        this.topic_1 = "topic-1";
        this.topic_2 = "topic-2";
        this.topic_3 = "topic-3";
        this.numPartitions = 1;
    }
}

