/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.management;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.TierLogSegment;
import kafka.server.BaseRequestTest;
import kafka.server.HostedPartition;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.EpochEntry;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.SortedSet;
import scala.collection.mutable.SortedSet$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@Tag(value="bazel:shard_count:3")
@ScalaSignature(bytes="\u0006\u0005\t\u0005b\u0001\u0002\u0010 \u0001\u0019BQ!\f\u0001\u0005\u00029BQ!\r\u0001\u0005BIBq!\u000f\u0001C\u0002\u0013\u0005!\b\u0003\u0004G\u0001\u0001\u0006Ia\u000f\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0011\u0019!\u0006\u0001)A\u0005\u0013\"9Q\u000b\u0001b\u0001\n\u00031\u0006BB0\u0001A\u0003%q\u000bC\u0003a\u0001\u0011\u0005\u0013\rC\u0004h\u0001\t\u0007I\u0011\u00015\t\rE\u0004\u0001\u0015!\u0003j\u0011\u0015\u0011\b\u0001\"\u0011t\u0011\u001d\tI\u0001\u0001C!\u0003\u0017Aq!!\u0006\u0001\t\u0003\tY\u0001C\u0004\u0002\u0018\u0001!\t!!\u0007\t\u000f\u0005%\u0003\u0001\"\u0001\u0002L!9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0003bBA1\u0001\u0011\u0005\u00111\r\u0005\b\u0003[\u0002A\u0011AA8\u0011\u001d\tI\b\u0001C\u0001\u0003wBq!!\"\u0001\t\u0003\t9\tC\u0004\u0002\u0012\u0002!I!a%\t\u000f\u0005m\u0006\u0001\"\u0001\u0002>\"9\u0011q\u0019\u0001\u0005\n\u0005%\u0007bBAd\u0001\u0011%\u00111\u001b\u0005\b\u0003/\u0004A\u0011BAm\u0011\u001d\tI\u000f\u0001C\u0005\u0003WDq!!?\u0001\t\u0013\tY\u0010C\u0004\u0003\f\u0001!IA!\u0004\u00037QKWM]3e!\u0006\u0014H/\u001b;j_:\u0014VmY8wKJLH+Z:u\u0015\t\u0001\u0013%\u0001\u0006nC:\fw-Z7f]RT!AI\u0012\u0002\tQLWM\u001d\u0006\u0002I\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001(!\tA3&D\u0001*\u0015\tQ3%\u0001\u0004tKJ4XM]\u0005\u0003Y%\u0012qBQ1tKJ+\u0017/^3tiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\u0002\"\u0001\r\u0001\u000e\u0003}\t1B\u0019:pW\u0016\u00148i\\;oiV\t1\u0007\u0005\u00025o5\tQGC\u00017\u0003\u0015\u00198-\u00197b\u0013\tATGA\u0002J]R\f\u0011\u0002^8qS\u000et\u0015-\\3\u0016\u0003m\u0002\"\u0001P\"\u000f\u0005u\n\u0005C\u0001 6\u001b\u0005y$B\u0001!&\u0003\u0019a$o\\8u}%\u0011!)N\u0001\u0007!J,G-\u001a4\n\u0005\u0011+%AB*ue&twM\u0003\u0002Ck\u0005QAo\u001c9jG:\u000bW.\u001a\u0011\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\t\u0011\n\u0005\u0002K%6\t1J\u0003\u0002M\u001b\u000611m\\7n_:T!\u0001\n(\u000b\u0005=\u0003\u0016AB1qC\u000eDWMC\u0001R\u0003\ry'oZ\u0005\u0003'.\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\bu_BL7\rU1si&$\u0018n\u001c8!\u0003\u0015\u0001(o\u001c9t+\u00059\u0006C\u0001-^\u001b\u0005I&B\u0001.\\\u0003\u0011)H/\u001b7\u000b\u0003q\u000bAA[1wC&\u0011a,\u0017\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018A\u00029s_B\u001c\b%A\fce>\\WM\u001d)s_B,'\u000f^=Pm\u0016\u0014(/\u001b3fgR\u0011!-\u001a\t\u0003i\rL!\u0001Z\u001b\u0003\tUs\u0017\u000e\u001e\u0005\u0006M&\u0001\raV\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\u0018AB3ySR,G-F\u0001j!\tQw.D\u0001l\u0015\taW.\u0001\u0004bi>l\u0017n\u0019\u0006\u0003]f\u000b!bY8oGV\u0014(/\u001a8u\u0013\t\u00018NA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\bKbLG/\u001a3!\u0003\u0015\u0019X\r^+q)\t\u0011G\u000fC\u0003v\u0019\u0001\u0007a/\u0001\u0005uKN$\u0018J\u001c4p!\t9h0D\u0001y\u0015\tI(0A\u0002ba&T!a\u001f?\u0002\u000f),\b/\u001b;fe*\u0011Q\u0010U\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u007fb\u0014\u0001\u0002V3ti&sgm\u001c\u0015\u0004\u0019\u0005\r\u0001cA<\u0002\u0006%\u0019\u0011q\u0001=\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<o)\u0005\u0011\u0007fA\u0007\u0002\u0010A\u0019q/!\u0005\n\u0007\u0005M\u0001PA\u0005BMR,'/R1dQ\u0006q\u0001O]3qCJ,gi\u001c:UKN$\u0018a\f;fgR\u0014VmY8wKJL\u0018\t^+oG2,\u0017M\u001c'fC\u0012,'oV5uQ:{G)\u0019;b\u0003RdunY1m\u0019><Gc\u00012\u0002\u001c!1\u0011QD\bA\u0002m\na!];peVl\u0007fB\b\u0002\"\u00055\u0012q\u0006\t\u0005\u0003G\tI#\u0004\u0002\u0002&)\u0019\u0011q\u0005>\u0002\rA\f'/Y7t\u0013\u0011\tY#!\n\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0003oC6,\u0017EAA\u0019\u0003\tZH-[:qY\u0006Lh*Y7f{:Z\u0018M]4v[\u0016tGo],ji\"t\u0015-\\3t{\":q\"!\u000e\u0002B\u0005\r\u0003\u0003BA\u001c\u0003{i!!!\u000f\u000b\t\u0005m\u0012QE\u0001\taJ|g/\u001b3fe&!\u0011qHA\u001d\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\u0012\u0011QI\u0011\u0003\u0003\u000f\n!A_6\u0002\u007fQ,7\u000f\u001e*fG>4XM]=BiVs7\r\\3b]2+\u0017\rZ3s/&$\b\u000eT8dC2dUi\u0014'fgN$\u0006.\u00198MCN$H+[3sK\u0012|eMZ:fiR\u0019!-!\u0014\t\r\u0005u\u0001\u00031\u0001<Q\u001d\u0001\u0012\u0011EA\u0017\u0003_As\u0001EA\u001b\u0003\u0003\n\u0019\u0006\f\u0002\u0002F\u0005\u0001D/Z:u%\u0016\u001cwN^3ss\u0006#XK\\2mK\u0006tG*Z1eKJ<\u0016\u000e\u001e5BY2$\u0015\r^1Bi2{7-\u00197M_\u001e$2AYA-\u0011\u0019\ti\"\u0005a\u0001w!:\u0011#!\t\u0002.\u0005=\u0002fB\t\u00026\u0005\u0005\u0013q\f\u0017\u0003\u0003\u000b\nA\b^3tiJ+7m\u001c<fef\fE/\u00168dY\u0016\fg\u000eT3bI\u0016\u0014x+\u001b;i\u0019N{u\n\u001c3feRC\u0017M\u001c$jeN$H+[3sK\u0012|eMZ:fiR\u0019!-!\u001a\t\r\u0005u!\u00031\u0001<Q\u001d\u0011\u0012\u0011EA\u0017\u0003_AsAEA\u001b\u0003\u0003\nY\u0007\f\u0002\u0002F\u0005\u0019D/Z:u%\u0016\u001cwN^3ss\u0006#XK\\2mK\u0006tG*Z1eKJ<\u0016\u000e\u001e5ESZ,'oZ3oG\u0016\fE\u000fT8dC2dun\u001a\u000b\u0004E\u0006E\u0004BBA\u000f'\u0001\u00071\bK\u0004\u0014\u0003C\ti#a\f)\u000fM\t)$!\u0011\u0002x1\u0012\u0011QI\u00016i\u0016\u001cHOU3d_Z,'/_!u+:\u001cG.Z1o\u0019\u0016\fG-\u001a:XQ\u0016tgj\\*fO6,g\u000e\u001e%bg\n+WM\u001c+jKJ,G\rF\u0002c\u0003{Ba!!\b\u0015\u0001\u0004Y\u0004f\u0002\u000b\u0002\"\u00055\u0012q\u0006\u0015\b)\u0005U\u0012\u0011IABY\t\t)%A\u001fuKN$(+Z2pm\u0016\u0014\u00180\u0011;V]\u000edW-\u00198MK\u0006$WM\u001d$peR{\u0007/[2De\u0016\fG/\u001a3XSRDG+[3sS:<G)[:bE2,G\rF\u0002c\u0003\u0013Ca!!\b\u0016\u0001\u0004Y\u0004fB\u000b\u0002\"\u00055\u0012q\u0006\u0015\b+\u0005U\u0012\u0011IAHY\t\t)%A\buS\u0016\u0014Hj\\4TK\u001elWM\u001c;t)\u0011\t)*a-\u0011\r\u0005]\u0015\u0011UAT\u001d\u0011\tI*!(\u000f\u0007y\nY*C\u00017\u0013\r\ty*N\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019+!*\u0003\t1K7\u000f\u001e\u0006\u0004\u0003?+\u0004\u0003BAU\u0003_k!!a+\u000b\u0007\u000556%A\u0002m_\u001eLA!!-\u0002,\nqA+[3s\u0019><7+Z4nK:$\bbBAW-\u0001\u0007\u0011Q\u0017\t\u0005\u0003S\u000b9,\u0003\u0003\u0002:\u0006-&aC!cgR\u0014\u0018m\u0019;M_\u001e\f\u0001\t^3tiJ+7m\u001c<fef\fE/\u00168dY\u0016\fg\u000eT3bI\u0016\u0014x+\u001b;i)&,'/\u001a3ECR\f')\u001e;US\u0016\u0014\u0018N\\4TS:\u001cW\rR5tC\ndW\r\u001a\u000b\u0004E\u0006}\u0006BBA\u000f/\u0001\u00071\bK\u0004\u0018\u0003C\ti#a\f)\u000f]\t)$!\u0011\u0002F2\u0012\u0011QI\u0001\u0012G\"\fgnZ3U_BL7mQ8oM&<G#\u00022\u0002L\u0006=\u0007BBAg1\u0001\u00071(A\u0002lKfDa!!5\u0019\u0001\u0004Y\u0014!\u0002<bYV,Gc\u00012\u0002V\")Q+\u0007a\u0001/\u0006y1M]3bi\u0016$Vm\u001d;U_BL7\r\u0006\u0003\u0002\\\u0006\u001d\b#\u0003\u001b\u0002^N\n\toMAq\u0013\r\ty.\u000e\u0002\u0007)V\u0004H.\u001a\u001b\u0011\u0007!\n\u0019/C\u0002\u0002f&\u00121bS1gW\u0006\u0014%o\\6fe\")QK\u0007a\u0001/\u0006Y\u0012\r\u001d9f]\u0012lUm]:bO\u0016\u001c\u0018I\u001c3WKJLg-_*z]\u000e$rAYAw\u0003c\f)\u0010\u0003\u0004\u0002pn\u0001\raM\u0001\f]VlW*Z:tC\u001e,7\u000f\u0003\u0004\u0002tn\u0001\raM\u0001\tY\u0016\fG-\u001a:JI\"1\u0011q_\u000eA\u0002M\n!BZ8mY><XM]%e\u0003Q9\u0018-\u001b;G_JL5O\u001d+p\u0007\"\fgnZ3U_R)!-!@\u0003\u0002!9\u0011q \u000fA\u0002\u0005\u0005\u0018A\u00027fC\u0012,'\u000fC\u0004\u0003\u0004q\u0001\rA!\u0002\u0002\u0017\u0015D\b/Z2uK\u0012L5O\u001d\t\u0005y\t\u001d1'C\u0002\u0003\n\u0015\u00131aU3u\u0003a9\u0018-\u001b;G_J\u0014V\r\u001d7jG\u0006$vNQ3MK\u0006$WM\u001d\u000b\u0006E\n=!\u0011\u0003\u0005\u0006\u000fv\u0001\r!\u0013\u0005\b\u0005'i\u0002\u0019AAq\u0003%qWm\u001e'fC\u0012,'\u000fK\u0004\u0001\u0005/\t\tN!\b\u0011\u0007]\u0014I\"C\u0002\u0003\u001ca\u00141\u0001V1hC\t\u0011y\"A\ncCj,GNO:iCJ$wlY8v]RT4\u0007")
public class TieredPartitionRecoveryTest
extends BaseRequestTest {
    private final String topicName;
    private final TopicPartition topicPartition = new TopicPartition(this.topicName(), 0);
    private final Properties props = new Properties();
    private final AtomicBoolean exited;

    @Override
    public int brokerCount() {
        return 5;
    }

    public String topicName() {
        return this.topicName;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Properties props() {
        return this.props;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        this.serverConfig().stringPropertyNames().forEach(key -> properties.put(key, this.serverConfig().get(key)));
        properties.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "true");
    }

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        Exit.setExitProcedure((x$1, x$2) -> this.exited().set(true));
        super.setUp(testInfo);
        this.prepareForTest();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        Assertions.assertFalse((boolean)this.exited().get());
    }

    public void prepareForTest() {
        this.props().clear();
        this.props().put("confluent.tier.enable", "true");
        this.props().put("segment.bytes", "16384");
        this.props().put("confluent.tier.local.hotset.bytes", "16384");
        this.props().put("confluent.tier.local.hotset.ms", "-1");
        this.props().put("retention.bytes", "-1");
        this.props().put("unclean.leader.election.enable", "true");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testRecoveryAtUncleanLeaderWithNoDataAtLocalLog(String quorum) {
        void var3_3;
        void var4_4;
        void var5_5;
        Tuple4<Object, KafkaBroker, Object, KafkaBroker> tuple4 = this.createTestTopic(this.props());
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        int replica1Id = BoxesRunTime.unboxToInt((Object)tuple4._1());
        KafkaBroker replica1 = (KafkaBroker)tuple4._2();
        int replica2Id = BoxesRunTime.unboxToInt((Object)tuple4._3());
        this.killBrokerById((int)var5_5);
        this.waitForIsrToChangeTo((KafkaBroker)var4_4, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{var3_3}))));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 120000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithNoDataAtLocalLog$1(this, (KafkaBroker)var4_4)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Waiting for log to be clean");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int numMessages = 26000;
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), this.topicName(), numMessages, -1);
        AbstractLog log = (AbstractLog)var4_4.replicaManager().getLog(this.topicPartition()).get();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 120000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithNoDataAtLocalLog$3(this, log, numMessages)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Timeout waiting for all messages to be written");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        long expectedLogStartOffset = log.logStartOffset();
        long lastTieredOffset = ((TierLogSegment)this.tierLogSegments(log).last()).endOffset();
        this.killBrokerById((int)var3_3);
        this.restartDeadBrokerById((int)var5_5, this.restartDeadBrokerById$default$2());
        this.waitForReplicaToBeLeader(this.topicPartition(), this.brokerWithId((int)var5_5));
        AbstractLog log_2 = (AbstractLog)this.brokerWithId((int)var5_5).replicaManager().getLog(this.topicPartition()).get();
        Assertions.assertEquals((long)expectedLogStartOffset, (long)log_2.logStartOffset(), (String)"Post recovery, LogStartOffset does not match first tiered offset");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log_2.logEndOffset(), (String)"Post recovery, LogEndOffset does not match last tiered offset");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log_2.localLogStartOffset(), (String)"Post recovery, LocalLogStartOffset does not match last tiered offset");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log_2.localLogEndOffset(), (String)"Post recovery, LocalLogEndOffset does not match last tiered offset");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testRecoveryAtUncleanLeaderWithLocalLEOLessThanLastTieredOffset(String quorum) {
        void var4_4;
        void var5_5;
        void var3_3;
        Tuple4<Object, KafkaBroker, Object, KafkaBroker> tuple4 = this.createTestTopic(this.props());
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        int replica1Id = BoxesRunTime.unboxToInt((Object)tuple4._1());
        KafkaBroker replica1 = (KafkaBroker)tuple4._2();
        int replica2Id = BoxesRunTime.unboxToInt((Object)tuple4._3());
        int numMessages = 1000;
        this.appendMessagesAndVerifySync(numMessages, (int)var3_3, (int)var5_5);
        this.killBrokerById((int)var5_5);
        this.waitForIsrToChangeTo((KafkaBroker)var4_4, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{var3_3}))));
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), this.topicName(), numMessages, -1);
        AbstractLog log = (AbstractLog)var4_4.replicaManager().getLog(this.topicPartition()).get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 120000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithLocalLEOLessThanLastTieredOffset$1(this, log, numMessages)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timeout waiting for some segments to tier");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long firstTieredOffset = ((TierLogSegment)this.tierLogSegments(log).head()).baseOffset();
        long lastTieredOffset = ((TierLogSegment)this.tierLogSegments(log).last()).endOffset();
        this.killBrokerById((int)var3_3);
        this.restartDeadBrokerById((int)var5_5, this.restartDeadBrokerById$default$2());
        this.waitForReplicaToBeLeader(this.topicPartition(), this.brokerWithId((int)var5_5));
        AbstractLog log_2 = (AbstractLog)this.brokerWithId((int)var5_5).replicaManager().getLog(this.topicPartition()).get();
        Assertions.assertEquals((long)firstTieredOffset, (long)log_2.logStartOffset(), (String)"Post recovery, LogStartOffset does not match first tiered offset");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log_2.logEndOffset(), (String)"Post recovery, LogEndOffset does not match last tiered segment");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log_2.localLogStartOffset(), (String)"Post recovery, LocalLogStartOffset does not match last tiered segment");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log_2.localLogEndOffset(), (String)"Post recovery, LocalLogEndOffset does not match last tiered segment");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testRecoveryAtUncleanLeaderWithAllDataAtLocalLog(String quorum) {
        void var6_6;
        void var4_4;
        void var5_5;
        void var3_3;
        this.props().put("confluent.tier.local.hotset.bytes", "-1");
        this.props().put("confluent.tier.local.hotset.ms", "-1");
        this.props().put("retention.bytes", "-1");
        Tuple4<Object, KafkaBroker, Object, KafkaBroker> tuple4 = this.createTestTopic(this.props());
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        int replica1Id = BoxesRunTime.unboxToInt((Object)tuple4._1());
        KafkaBroker replica1 = (KafkaBroker)tuple4._2();
        int replica2Id = BoxesRunTime.unboxToInt((Object)tuple4._3());
        KafkaBroker replica2 = (KafkaBroker)tuple4._4();
        int numMessages = 10000;
        this.appendMessagesAndVerifySync(numMessages, (int)var3_3, (int)var5_5);
        AbstractLog log = (AbstractLog)var4_4.replicaManager().getLog(this.topicPartition()).get();
        long expectedLogStartOffset = log.logStartOffset();
        long expectedLogEndOffset = log.logEndOffset();
        long expectedLocalLogStartOffset = ((AbstractLog)var6_6.replicaManager().getLog(this.topicPartition()).get()).localLogStartOffset();
        this.killBrokerById((int)var5_5);
        this.waitForIsrToChangeTo((KafkaBroker)var4_4, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{var3_3}))));
        this.killBrokerById((int)var3_3);
        this.restartDeadBrokerById((int)var5_5, this.restartDeadBrokerById$default$2());
        this.waitForReplicaToBeLeader(this.topicPartition(), this.brokerWithId((int)var5_5));
        AbstractLog log_2 = (AbstractLog)this.brokerWithId((int)var5_5).replicaManager().getLog(this.topicPartition()).get();
        Assertions.assertEquals((long)expectedLogStartOffset, (long)log_2.logStartOffset(), (String)"Unexpected LogStartOffset after recovery");
        Assertions.assertEquals((long)expectedLogEndOffset, (long)log_2.logEndOffset(), (String)"Unexpected LogEndOffset after recovery");
        Assertions.assertEquals((long)expectedLocalLogStartOffset, (long)log_2.localLogStartOffset(), (String)"Unexpected LocalLogStartOffset after recovery");
        Assertions.assertEquals((long)expectedLogEndOffset, (long)log_2.localLogEndOffset(), (String)"Unexpected LocalLogEndOffset after recovery");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset(String quorum) {
        void var17_16;
        void var6_6;
        void var5_5;
        void var3_3;
        void var4_4;
        this.props().put("segment.bytes", "4096");
        this.props().put("confluent.tier.local.hotset.bytes", "40960");
        this.props().put("retention.bytes", "40960");
        this.props().put("file.delete.delay.ms", "100");
        Tuple4<Object, KafkaBroker, Object, KafkaBroker> tuple4 = this.createTestTopic(this.props());
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        int replica1Id = BoxesRunTime.unboxToInt((Object)tuple4._1());
        KafkaBroker replica1 = (KafkaBroker)tuple4._2();
        int replica2Id = BoxesRunTime.unboxToInt((Object)tuple4._3());
        KafkaBroker replica2 = (KafkaBroker)tuple4._4();
        AbstractLog log = (AbstractLog)var4_4.replicaManager().getLog(this.topicPartition()).get();
        int numMessages = 50;
        while (log.size() < 40960L) {
            this.appendMessagesAndVerifySync(numMessages, (int)var3_3, (int)var5_5);
        }
        long oldLocalLogStartOffsetFollower = ((AbstractLog)var6_6.replicaManager().getLog(this.topicPartition()).get()).localLogStartOffset();
        this.killBrokerById((int)var5_5);
        this.waitForIsrToChangeTo((KafkaBroker)var4_4, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{var3_3}))));
        this.props().clear();
        this.props().put("confluent.tier.local.hotset.bytes", "20480");
        this.props().put("retention.bytes", "20480");
        this.changeTopicConfig(this.props());
        SortedSet offsetAndSize = (SortedSet)SortedSet$.MODULE$.apply((Seq)Nil$.MODULE$, (Object)Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Int$.MODULE$));
        log.localLogSegments().forEach(segment -> offsetAndSize.add((Object)new Tuple2.mcJI.sp(segment.baseOffset(), segment.size())));
        this.tierLogSegments(log).foreach((Function1 & Serializable)segment -> BoxesRunTime.boxToBoolean((boolean)offsetAndSize.add((Object)new Tuple2.mcJI.sp(segment.baseOffset(), segment.size()))));
        long l = log.logEndOffset();
        Iterator it = offsetAndSize.toList().reverseIterator();
        for (int sizeInBytes = 0; sizeInBytes < 20480 && it.hasNext(); sizeInBytes += var17_16) {
            void var15_15;
            Tuple2 tuple2 = (Tuple2)it.next();
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            long baseOffset = tuple2._1$mcJ$sp();
            int segmentSize = tuple2._2$mcI$sp();
            l = var15_15;
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs = 120000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!(log.logStartOffset() == l && ((TierLogSegment)this.tierLogSegments(log).head()).baseOffset() == l)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for retention to complete");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long firstTieredOffset = ((TierLogSegment)this.tierLogSegments(log).head()).baseOffset();
        long expectedLogEndOffset = log.logEndOffset();
        long lastTieredOffset = ((TierLogSegment)this.tierLogSegments(log).last()).endOffset();
        this.killBrokerById((int)var3_3);
        this.restartDeadBrokerById((int)var5_5, this.restartDeadBrokerById$default$2());
        this.waitForReplicaToBeLeader(this.topicPartition(), this.brokerWithId((int)var5_5));
        AbstractLog log_2 = (AbstractLog)this.brokerWithId((int)var5_5).replicaManager().getLog(this.topicPartition()).get();
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs2 = 30000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$5(firstTieredOffset, log_2)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Post recovery, LogStartOffset does not match first tiered offset");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs3 = 30000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$7(log_2, oldLocalLogStartOffsetFollower)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"LocalLogStartOffset has not incremented to match first tiered offset");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        long l5 = 100L;
        long waitUntilTrue_waitTimeMs4 = 30000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$9(expectedLogEndOffset, log_2)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"Unexpected LogEndOffset after recovery");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        long l6 = 100L;
        long waitUntilTrue_waitTimeMs5 = 30000L;
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$11(firstTieredOffset, log_2)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)"Unexpected LocalLogStartOffset after recovery");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
        }
        long l7 = 100L;
        long waitUntilTrue_waitTimeMs6 = 30000L;
        long waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$13(log_2, lastTieredOffset)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime6 + waitUntilTrue_waitTimeMs6) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$14(log_2, lastTieredOffset));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs6), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testRecoveryAtUncleanLeaderWithDivergenceAtLocalLog(String quorum) {
        void var5_5;
        void var4_4;
        void var3_3;
        Tuple4<Object, KafkaBroker, Object, KafkaBroker> tuple4 = this.createTestTopic(this.props());
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        int replica1Id = BoxesRunTime.unboxToInt((Object)tuple4._1());
        KafkaBroker cfr_ignored_0 = (KafkaBroker)tuple4._2();
        int replica2Id = BoxesRunTime.unboxToInt((Object)tuple4._3());
        KafkaBroker replica2 = (KafkaBroker)tuple4._4();
        int numMessages = 5000;
        this.appendMessagesAndVerifySync(numMessages, (int)var3_3, (int)var4_4);
        this.killBrokerById((int)var3_3);
        this.waitForReplicaToBeLeader(this.topicPartition(), (KafkaBroker)var5_5);
        this.restartDeadBrokerById((int)var3_3, this.restartDeadBrokerById$default$2());
        this.waitForIsrToChangeTo((KafkaBroker)var5_5, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{var3_3, var4_4}))));
        this.appendMessagesAndVerifySync(numMessages, (int)var4_4, (int)var3_3);
        AbstractLog followerLog = (AbstractLog)this.brokerWithId((int)var3_3).replicaManager().getLog(this.topicPartition()).get();
        Buffer editedEpochEntries = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(((LeaderEpochFileCache)followerLog.leaderEpochCache().get()).epochEntries()).asScala().map((Function1 & Serializable)entry -> new EpochEntry(entry.epoch, entry.startOffset + 1L));
        ((LeaderEpochFileCache)followerLog.leaderEpochCache().get()).clearAndFlush();
        editedEpochEntries.foreach((Function1 & Serializable)entry -> {
            TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithDivergenceAtLocalLog$2(followerLog, entry);
            return BoxedUnit.UNIT;
        });
        AbstractLog leaderLog = (AbstractLog)var5_5.replicaManager().getLog(this.topicPartition()).get();
        long expectedLogStartOffset = leaderLog.logStartOffset();
        long lastTieredOffset = ((TierLogSegment)this.tierLogSegments(leaderLog).last()).endOffset();
        this.killBrokerById((int)var3_3);
        this.waitForIsrToChangeTo((KafkaBroker)var5_5, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{var4_4}))));
        this.killBrokerById((int)var4_4);
        this.restartDeadBrokerById((int)var3_3, this.restartDeadBrokerById$default$2());
        this.waitForReplicaToBeLeader(this.topicPartition(), this.brokerWithId((int)var3_3));
        AbstractLog log = (AbstractLog)this.brokerWithId((int)var3_3).replicaManager().getLog(this.topicPartition()).get();
        Assertions.assertEquals((long)expectedLogStartOffset, (long)log.logStartOffset(), (String)"Unexpected LogStartOffset after recovery");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log.logEndOffset(), (String)"Unexpected LogEndOffset after recovery");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log.localLogStartOffset(), (String)"Unexpected LocalLogStartOffset after recovery");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log.localLogEndOffset(), (String)"Unexpected LocalLogEndOffset after recovery");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testRecoveryAtUncleanLeaderWhenNoSegmentHasBeenTiered(String quorum) {
        void var3_3;
        void var4_4;
        void var5_5;
        Tuple4<Object, KafkaBroker, Object, KafkaBroker> tuple4 = this.createTestTopic(this.props());
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        int replica1Id = BoxesRunTime.unboxToInt((Object)tuple4._1());
        KafkaBroker replica1 = (KafkaBroker)tuple4._2();
        int replica2Id = BoxesRunTime.unboxToInt((Object)tuple4._3());
        this.killBrokerById((int)var5_5);
        this.waitForIsrToChangeTo((KafkaBroker)var4_4, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{var3_3}))));
        AbstractLog log = (AbstractLog)var4_4.replicaManager().getLog(this.topicPartition()).get();
        Predef$.MODULE$.assert(log.logStartOffset() == 0L && log.logEndOffset() == 0L && log.tierPartitionState().numSegments() == 0);
        this.killBrokerById((int)var3_3);
        this.restartDeadBrokerById((int)var5_5, this.restartDeadBrokerById$default$2());
        this.waitForReplicaToBeLeader(this.topicPartition(), this.brokerWithId((int)var5_5));
        AbstractLog log_2 = (AbstractLog)this.brokerWithId((int)var5_5).replicaManager().getLog(this.topicPartition()).get();
        Assertions.assertEquals((long)0L, (long)log_2.logStartOffset(), (String)"Post recovery, LogStartOffset does not match first tiered offset");
        Assertions.assertEquals((long)0L, (long)log_2.logEndOffset(), (String)"Post recovery, LogEndOffset does not match last tiered offset");
        Assertions.assertEquals((long)0L, (long)log_2.localLogStartOffset(), (String)"Post recovery, LocalLogStartOffset does not match last tiered offset");
        Assertions.assertEquals((long)0L, (long)log_2.localLogEndOffset(), (String)"Post recovery, LocalLogEndOffset does not match last tiered offset");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testRecoveryAtUncleanLeaderForTopicCreatedWithTieringDisabled(String quorum) {
        void var4_4;
        void var5_5;
        void var3_3;
        this.props().put("confluent.tier.enable", "false");
        Tuple4<Object, KafkaBroker, Object, KafkaBroker> tuple4 = this.createTestTopic(this.props());
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        int replica1Id = BoxesRunTime.unboxToInt((Object)tuple4._1());
        KafkaBroker replica1 = (KafkaBroker)tuple4._2();
        int replica2Id = BoxesRunTime.unboxToInt((Object)tuple4._3());
        int numMessages = 1000;
        AbstractLog log = (AbstractLog)((KafkaBroker)this.brokerForId((int)var3_3).get()).replicaManager().getLog(this.topicPartition()).get();
        AbstractLog followerLog = (AbstractLog)((KafkaBroker)this.brokerForId((int)var5_5).get()).replicaManager().getLog(this.topicPartition()).get();
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), this.topicName(), numMessages, -1);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 120000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderForTopicCreatedWithTieringDisabled$1(log, numMessages, followerLog)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timeout waiting for all messages to be written and synced");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long expectedLogStartOffset = followerLog.logStartOffset();
        long expectedLogEndOffset = followerLog.logEndOffset();
        this.killBrokerById((int)var5_5);
        this.waitForIsrToChangeTo((KafkaBroker)var4_4, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{var3_3}))));
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), this.topicName(), numMessages, -1);
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 120000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderForTopicCreatedWithTieringDisabled$3(log, numMessages)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Timeout waiting for all messages to be written");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        this.killBrokerById((int)var3_3);
        this.restartDeadBrokerById((int)var5_5, this.restartDeadBrokerById$default$2());
        this.waitForReplicaToBeLeader(this.topicPartition(), this.brokerWithId((int)var5_5));
        AbstractLog log_2 = (AbstractLog)this.brokerWithId((int)var5_5).replicaManager().getLog(this.topicPartition()).get();
        Assertions.assertEquals((long)expectedLogStartOffset, (long)log_2.logStartOffset(), (String)"Post recovery, LogStartOffset does not match first tiered offset");
        Assertions.assertEquals((long)expectedLogEndOffset, (long)log_2.logEndOffset(), (String)"Post recovery, LogEndOffset does not match last tiered segment");
        Assertions.assertEquals((long)expectedLogStartOffset, (long)log_2.localLogStartOffset(), (String)"Post recovery, LocalLogStartOffset does not match last tiered segment");
        Assertions.assertEquals((long)expectedLogEndOffset, (long)log_2.localLogEndOffset(), (String)"Post recovery, LocalLogEndOffset does not match last tiered segment");
    }

    private List<TierLogSegment> tierLogSegments(AbstractLog log) {
        return log.tieredLogSegments().toList();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk"})
    public void testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled(String quorum) {
        void var3_3;
        void var4_4;
        void var5_5;
        this.props().put("segment.bytes", "4096");
        this.props().put("confluent.tier.local.hotset.bytes", "4096");
        Tuple4<Object, KafkaBroker, Object, KafkaBroker> tuple4 = this.createTestTopic(this.props());
        if (tuple4 == null) {
            throw new MatchError(null);
        }
        int replica1Id = BoxesRunTime.unboxToInt((Object)tuple4._1());
        KafkaBroker replica1 = (KafkaBroker)tuple4._2();
        int replica2Id = BoxesRunTime.unboxToInt((Object)tuple4._3());
        this.killBrokerById((int)var5_5);
        this.waitForIsrToChangeTo((KafkaBroker)var4_4, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{var3_3}))));
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$1(this, (KafkaBroker)var4_4)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Waiting for log to be clean");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        AbstractLog log1 = (AbstractLog)var4_4.replicaManager().getLog(this.topicPartition()).get();
        int numMessages = 100;
        int n = 0;
        while (log1.numberOfSegments() < 4) {
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), this.topicName(), numMessages, -1);
            n += numMessages;
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 30000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!(log1.logEndOffset() == (long)n && log1.tierPartitionState().numSegments() >= log1.numberOfSegments() - 1 && log1.localLogStartOffset() > log1.logStartOffset())) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$4(log1));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        long expectedLogStartOffset = log1.logStartOffset();
        long lastTieredOffset = ((TierLogSegment)this.tierLogSegments(log1).last()).endOffset();
        this.changeTopicConfig("confluent.tier.enable", "false");
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 30000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$5(log1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Timed out waiting for tiering to disable");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        long log1LocalLogStartOffset = log1.localLogStartOffset();
        long log1LogEndOffset = log1.logEndOffset();
        this.killBrokerById((int)var3_3);
        this.restartDeadBrokerById((int)var5_5, this.restartDeadBrokerById$default$2());
        KafkaBroker replica2 = (KafkaBroker)this.brokerForId((int)var5_5).get();
        this.waitForReplicaToBeLeader(this.topicPartition(), replica2);
        AbstractLog log2 = (AbstractLog)replica2.replicaManager().getLog(this.topicPartition()).get();
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs4 = 30000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$7(log2)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"Timed out waiting for tiering to disable");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)expectedLogStartOffset, (long)log2.logStartOffset(), (String)"Post recovery, LogStartOffset does not match first tiered offset");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log2.logEndOffset(), (String)"Post recovery, LogEndOffset does not match last tiered offset");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log2.localLogStartOffset(), (String)"Post recovery, LocalLogStartOffset does not match last tiered offset");
        Assertions.assertEquals((long)(lastTieredOffset + 1L), (long)log2.localLogEndOffset(), (String)"Post recovery, LocalLogEndOffset does not match last tiered offset");
        long oldSize = log2.size();
        long targetEndOffset = log2.logEndOffset() * 2L;
        while (log2.logEndOffset() < targetEndOffset) {
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), this.topicName(), numMessages, -1);
        }
        long retentionBytes = log2.size() - oldSize;
        this.changeTopicConfig("retention.bytes", Long.toString(retentionBytes));
        LongRef size = LongRef.create((long)0L);
        LongRef startOffset = LongRef.create((long)((LogSegment)CollectionConverters$.MODULE$.CollectionHasAsScala(log2.localLogSegments()).asScala().toList().last()).baseOffset());
        CollectionConverters$.MODULE$.CollectionHasAsScala(log2.localLogSegments()).asScala().toList().reverse().foreach((Function1 & Serializable)seg -> {
            TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$9(size, retentionBytes, startOffset, seg);
            return BoxedUnit.UNIT;
        });
        long startOffsetAfterRetention = startOffset.elem;
        long l5 = 100L;
        long waitUntilTrue_waitTimeMs5 = 30000L;
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$10(log2, startOffsetAfterRetention)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$11(startOffsetAfterRetention, log2));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
        }
        long l6 = 100L;
        long waitUntilTrue_waitTimeMs6 = 30000L;
        long waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$12(log2)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime6 + waitUntilTrue_waitTimeMs6) {
                Assertions.fail((String)"Timed out waiting for tiered segments to delete");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs6), (long)waitUntilTrue_pause));
        }
        this.killBrokerById((int)var5_5);
        this.restartDeadBrokerById((int)var3_3, this.restartDeadBrokerById$default$2());
        this.waitForReplicaToBeLeader(this.topicPartition(), this.brokerWithId((int)var3_3));
        AbstractLog log3 = (AbstractLog)this.brokerWithId((int)var3_3).replicaManager().getLog(this.topicPartition()).get();
        long l7 = 100L;
        long waitUntilTrue_waitTimeMs7 = 30000L;
        long waitUntilTrue_startTime7 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$14(log1LocalLogStartOffset, log3)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime7 + waitUntilTrue_waitTimeMs7) {
                Assertions.fail((String)"Unexpected LogStartOffset");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs7), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)log1LogEndOffset, (long)log3.logEndOffset(), (String)"Unexpected LogEndOffset");
        Assertions.assertEquals((long)log1LocalLogStartOffset, (long)log3.localLogStartOffset(), (String)"Unexpected LocalLogStartOffset");
        Assertions.assertEquals((long)log1LogEndOffset, (long)log3.localLogEndOffset(), (String)"Unexpected LocalLogEndOffset");
        Predef$.MODULE$.assert(log3.tierPartitionState().numSegments() == 0);
    }

    private void changeTopicConfig(String key, String value) {
        AlterConfigOp alterConfigOp = new AlterConfigOp(new ConfigEntry(key, value), AlterConfigOp.OpType.SET);
        HashMap<ConfigResource, java.util.List<AlterConfigOp>> configs = new HashMap<ConfigResource, java.util.List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.topicName()), Collections.singletonList(alterConfigOp));
        this.createConfluentAdminClient(this.createConfluentAdminClient$default$1()).incrementalAlterConfigs(configs).all().get(5L, TimeUnit.SECONDS);
    }

    private void changeTopicConfig(Properties props) {
        ConfluentAdmin adminClient = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());
        TestUtils$.MODULE$.incrementalAlterTopicConfigs((Admin)adminClient, this.topicName(), props, AlterConfigOp.OpType.SET);
    }

    private Tuple4<Object, KafkaBroker, Object, KafkaBroker> createTestTopic(Properties props) {
        Map<Object, Object> partitionToLeaderMap = this.createTopic(this.topicName(), 1, 2, props, this.createTopic$default$5(), this.createTopic$default$6());
        this.waitUntilLogCreatedOnBrokers(this.topicPartition());
        int leaderId = BoxesRunTime.unboxToInt((Object)partitionToLeaderMap.apply((Object)BoxesRunTime.boxToInteger((int)this.topicPartition().partition())));
        KafkaBroker leader = (KafkaBroker)this.brokerForId(leaderId).get();
        int followerId = TestUtils$.MODULE$.findFollowerId(this.topicPartition(), (Iterable<KafkaBroker>)this.brokers());
        KafkaBroker follower = (KafkaBroker)this.brokerForId(followerId).get();
        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)leaderId), (Object)leader, (Object)BoxesRunTime.boxToInteger((int)followerId), (Object)follower);
    }

    /*
     * WARNING - void declaration
     */
    private void appendMessagesAndVerifySync(int numMessages, int leaderId, int followerId) {
        AbstractLog leaderLog = (AbstractLog)((KafkaBroker)this.brokerForId(leaderId).get()).replicaManager().getLog(this.topicPartition()).get();
        AbstractLog followerLog = (AbstractLog)((KafkaBroker)this.brokerForId(followerId).get()).replicaManager().getLog(this.topicPartition()).get();
        long currentEndOffset = leaderLog.logEndOffset();
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), this.topicName(), numMessages, -1);
        long l = 50L;
        long waitUntilTrue_waitTimeMs = 120000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$appendMessagesAndVerifySync$1(this, leaderLog, currentEndOffset, numMessages, followerLog)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$appendMessagesAndVerifySync$2(this, leaderLog, followerLog, currentEndOffset, numMessages));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void waitForIsrToChangeTo(KafkaBroker leader, Set<Object> expectedIsr) {
        Partition partition = leader.replicaManager().getPartitionOrException(this.topicPartition());
        long l = 50L;
        long waitUntilTrue_waitTimeMs = 150000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$waitForIsrToChangeTo$1(partition, expectedIsr)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$waitForIsrToChangeTo$2(expectedIsr, partition));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void waitForReplicaToBeLeader(TopicPartition topicPartition, KafkaBroker newLeader) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 120000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$waitForReplicaToBeLeader$1(newLeader, topicPartition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for partition object at new leader");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Partition partition = newLeader.replicaManager().getPartitionOrException(topicPartition);
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 120000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TieredPartitionRecoveryTest.$anonfun$waitForReplicaToBeLeader$3(partition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)TieredPartitionRecoveryTest.$anonfun$waitForReplicaToBeLeader$4(partition));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithNoDataAtLocalLog$1(TieredPartitionRecoveryTest $this, KafkaBroker replica1$1) {
        return !replica1$1.replicaManager().getPartitionOrException($this.topicPartition()).isUncleanLeader();
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithNoDataAtLocalLog$2() {
        return "Waiting for log to be clean";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithNoDataAtLocalLog$3(TieredPartitionRecoveryTest $this, AbstractLog log$1, int numMessages$1) {
        return log$1.logEndOffset() == (long)numMessages$1 && $this.tierLogSegments(log$1).size() >= log$1.numberOfSegments() - 1;
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithNoDataAtLocalLog$4() {
        return "Timeout waiting for all messages to be written";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithLocalLEOLessThanLastTieredOffset$1(TieredPartitionRecoveryTest $this, AbstractLog log$2, int numMessages$2) {
        return log$2.logEndOffset() == (long)(2 * numMessages$2) && $this.tierLogSegments(log$2).size() >= log$2.numberOfSegments() - 1;
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithLocalLEOLessThanLastTieredOffset$2() {
        return "Timeout waiting for some segments to tier";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$3(TieredPartitionRecoveryTest $this, AbstractLog log$3, LongRef newStartOffset$1) {
        return log$3.logStartOffset() == newStartOffset$1.elem && ((TierLogSegment)$this.tierLogSegments(log$3).head()).baseOffset() == newStartOffset$1.elem;
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$4() {
        return "Timed out waiting for retention to complete";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$5(long firstTieredOffset$1, AbstractLog log_2$1) {
        return firstTieredOffset$1 == log_2$1.logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$6() {
        return "Post recovery, LogStartOffset does not match first tiered offset";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$7(AbstractLog log_2$1, long oldLocalLogStartOffsetFollower$1) {
        return log_2$1.localLogStartOffset() > oldLocalLogStartOffsetFollower$1;
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$8() {
        return "LocalLogStartOffset has not incremented to match first tiered offset";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$9(long expectedLogEndOffset$1, AbstractLog log_2$1) {
        return expectedLogEndOffset$1 == log_2$1.logEndOffset();
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$10() {
        return "Unexpected LogEndOffset after recovery";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$11(long firstTieredOffset$1, AbstractLog log_2$1) {
        return firstTieredOffset$1 == log_2$1.localLogStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$12() {
        return "Unexpected LocalLogStartOffset after recovery";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$13(AbstractLog log_2$1, long lastTieredOffset$1) {
        return log_2$1.localLogEndOffset() >= lastTieredOffset$1;
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithLSOOlderThanFirstTieredOffset$14(AbstractLog log_2$1, long lastTieredOffset$1) {
        return new StringBuilder(72).append("LocalLogEndOffset ").append(log_2$1.localLogEndOffset()).append(" is lesser than the last tiered offset ").append(lastTieredOffset$1).append(" after recovery").toString();
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAtUncleanLeaderWithDivergenceAtLocalLog$2(AbstractLog followerLog$1, EpochEntry entry) {
        ((LeaderEpochFileCache)followerLog$1.leaderEpochCache().get()).assign(entry.epoch, entry.startOffset);
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderForTopicCreatedWithTieringDisabled$1(AbstractLog log$4, int numMessages$3, AbstractLog followerLog$2) {
        return log$4.logEndOffset() == (long)numMessages$3 && followerLog$2.logEndOffset() == (long)numMessages$3;
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderForTopicCreatedWithTieringDisabled$2() {
        return "Timeout waiting for all messages to be written and synced";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderForTopicCreatedWithTieringDisabled$3(AbstractLog log$4, int numMessages$3) {
        return log$4.logEndOffset() == (long)(2 * numMessages$3);
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderForTopicCreatedWithTieringDisabled$4() {
        return "Timeout waiting for all messages to be written";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$1(TieredPartitionRecoveryTest $this, KafkaBroker replica1$2) {
        return !replica1$2.replicaManager().getPartitionOrException($this.topicPartition()).isUncleanLeader();
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$2() {
        return "Waiting for log to be clean";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$3(AbstractLog log1$1, IntRef totalMessages$1) {
        return log1$1.logEndOffset() == (long)totalMessages$1.elem && log1$1.tierPartitionState().numSegments() >= log1$1.numberOfSegments() - 1 && log1$1.localLogStartOffset() > log1$1.logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$4(AbstractLog log1$1) {
        return new StringBuilder(59).append("Timeout waiting for all messages to be written and tiered ").append(log1$1.tierPartitionState().numSegments()).append(" ").append(log1$1.numberOfSegments()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$5(AbstractLog log1$1) {
        return !log1$1.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$6() {
        return "Timed out waiting for tiering to disable";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$7(AbstractLog log2$1) {
        return !log2$1.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$8() {
        return "Timed out waiting for tiering to disable";
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$9(LongRef size$1, long retentionBytes$1, LongRef startOffset$1, LogSegment seg) {
        if (size$1.elem < retentionBytes$1) {
            size$1.elem += (long)seg.size();
            startOffset$1.elem = seg.baseOffset();
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$10(AbstractLog log2$1, long startOffsetAfterRetention$1) {
        return log2$1.logStartOffset() == startOffsetAfterRetention$1;
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$11(long startOffsetAfterRetention$1, AbstractLog log2$1) {
        return new StringBuilder(67).append("Timed out waiting for logStartOffset to change (expected: ").append(startOffsetAfterRetention$1).append(" actual: ").append(log2$1.logStartOffset()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$12(AbstractLog log2$1) {
        return log2$1.tierPartitionState().numSegments() == 0;
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$13() {
        return "Timed out waiting for tiered segments to delete";
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$14(long log1LocalLogStartOffset$1, AbstractLog log3$1) {
        return log1LocalLogStartOffset$1 == log3$1.logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testRecoveryAtUncleanLeaderWithTieredDataButTieringSinceDisabled$15() {
        return "Unexpected LogStartOffset";
    }

    public static final /* synthetic */ boolean $anonfun$appendMessagesAndVerifySync$1(TieredPartitionRecoveryTest $this, AbstractLog leaderLog$1, long currentEndOffset$1, int numMessages$4, AbstractLog followerLog$3) {
        return leaderLog$1.logEndOffset() >= currentEndOffset$1 + (long)numMessages$4 && leaderLog$1.logEndOffset() == followerLog$3.logEndOffset() && $this.tierLogSegments(leaderLog$1).size() >= leaderLog$1.numberOfSegments() - 1;
    }

    public static final /* synthetic */ String $anonfun$appendMessagesAndVerifySync$2(TieredPartitionRecoveryTest $this, AbstractLog leaderLog$1, AbstractLog followerLog$3, long currentEndOffset$1, int numMessages$4) {
        return new StringBuilder(180).append("Timeout waiting for all messages to be written, synced and tiered.").append(" Leader logEndOffset ").append(leaderLog$1.logEndOffset()).append(" Follower logEndOffset ").append(followerLog$3.logEndOffset()).append(" Expected logEndOffset ").append(currentEndOffset$1 + (long)numMessages$4).append(" Tiered Segments ").append($this.tierLogSegments(leaderLog$1).size()).append(" Expected min tiered segments ").append(leaderLog$1.numberOfSegments() - 1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$waitForIsrToChangeTo$1(Partition partition$1, Set expectedIsr$1) {
        return partition$1.inSyncReplicaIds().equals((Object)expectedIsr$1);
    }

    public static final /* synthetic */ String $anonfun$waitForIsrToChangeTo$2(Set expectedIsr$1, Partition partition$1) {
        return new StringBuilder(51).append("Timeout waiting for ISR to change to ").append(expectedIsr$1).append(". Current Isr ").append(partition$1.inSyncReplicaIds()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$waitForReplicaToBeLeader$1(KafkaBroker newLeader$1, TopicPartition topicPartition$1) {
        HostedPartition hostedPartition = newLeader$1.replicaManager().getPartition(topicPartition$1);
        HostedPartition.None$ none$ = HostedPartition.None$.MODULE$;
        return hostedPartition == null || !hostedPartition.equals(none$);
    }

    public static final /* synthetic */ String $anonfun$waitForReplicaToBeLeader$2() {
        return "Timed out waiting for partition object at new leader";
    }

    public static final /* synthetic */ boolean $anonfun$waitForReplicaToBeLeader$3(Partition partition$2) {
        return partition$2.isLeader() && !partition$2.isUncleanLeader();
    }

    public static final /* synthetic */ String $anonfun$waitForReplicaToBeLeader$4(Partition partition$2) {
        return new StringBuilder(102).append("Timed out waiting for leader to change and log to be recovered, if needed. isLeader=").append(partition$2.isLeader()).append(", isUncleanLeader=").append(partition$2.isUncleanLeader()).toString();
    }

    public TieredPartitionRecoveryTest() {
        this.topicName = "tiered-topic";
        this.serverConfig().put(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), "mybucket");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.LogFlushSchedulerIntervalMsProp(), "10");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "10");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), "10");
        this.exited = new AtomicBoolean(false);
    }
}

