/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.raft;

import java.io.IOException;
import java.util.ArrayList;
import kafka.server.KafkaRaftServer;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.test.junit.RaftClusterInvocationContext;
import kafka.tier.raft.KRaftSnapshotObject;
import kafka.tier.raft.KRaftSnapshotObjectUtils;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.metadata.KRaftSnapshotMetadata;
import kafka.utils.TestUtils;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RecordsSnapshotReader;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Function0;

@ExtendWith(value={ClusterTestExtensions.class})
@ClusterTestDefaults(clusterType=Type.KRAFT, brokers=3, controllers=3)
@Tag(value="integration")
public class KRaftSnapshotManagerIntegrationTest {
    private final RaftClusterInvocationContext.RaftClusterInstance cluster;

    public KRaftSnapshotManagerIntegrationTest(RaftClusterInvocationContext.RaftClusterInstance cluster) {
        this.cluster = cluster;
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="confluent.tier.feature", value="true"), @ClusterConfigProperty(key="confluent.tier.enable", value="true"), @ClusterConfigProperty(key="confluent.tier.backend", value="mock"), @ClusterConfigProperty(key="confluent.cluster.metadata.snapshot.tier.upload.enable", value="true"), @ClusterConfigProperty(key="metadata.log.max.record.bytes.between.snapshots", value="10"), @ClusterConfigProperty(key="metadata.max.idle.interval.ms", value="0")})
    void testSnapshotUpload() throws InterruptedException {
        this.cluster.waitForReadyBrokers();
        TestUtils.waitUntilTrue((Function0<Object>)((Function0)() -> this.cluster.controllerServers().stream().allMatch(controllerServer -> controllerServer.sharedServer().raftManager().replicatedLog().latestSnapshotId().isPresent())), (Function0<String>)((Function0)() -> "Expected for every controller to generate a snapshot"), 15000L, 100L);
        ArrayList objectsMetadataList = new ArrayList();
        this.cluster.controllerServers().forEach(controllerServer -> {
            try (RecordsSnapshotReader reader = RecordsSnapshotReader.of((RawSnapshotReader)((RawSnapshotReader)controllerServer.sharedServer().raftManager().replicatedLog().latestSnapshot().get()), (RecordSerde)new MetadataRecordSerde(), (BufferSupplier)BufferSupplier.create(), (int)1, (boolean)true);){
                objectsMetadataList.add(new KRaftSnapshotMetadata(new KRaftSnapshotObject(KafkaRaftServer.MetadataTopicId(), KafkaRaftServer.MetadataPartition().partition(), this.cluster.clusterId(), controllerServer.config().nodeId(), reader.lastContainedLogTimestamp(), reader.snapshotId())));
            }
        });
        try (MockInMemoryTierObjectStore objectStore = new MockInMemoryTierObjectStore(Time.SYSTEM, new MockInMemoryTierObjectStoreConfig(this.cluster.clusterId(), Integer.valueOf(1)));){
            TestUtils.waitUntilTrue((Function0<Object>)((Function0)() -> objectsMetadataList.stream().allMatch(metadata -> {
                try {
                    return KRaftSnapshotObjectUtils.objectExists((TierObjectStore)objectStore, (KRaftSnapshotMetadata)metadata);
                }
                catch (IOException e) {
                    return false;
                }
            })), (Function0<String>)((Function0)() -> "Expected every controller snapshot to be present on object store"), 15000L, 100L);
        }
    }
}

