/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.raft;

import io.confluent.kafka.concurrent.EventExecutor;
import io.confluent.kafka.concurrent.MockEventExecutor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import kafka.server.KafkaRaftServer;
import kafka.tier.raft.KRaftSnapshotManager;
import kafka.tier.raft.KRaftSnapshotMetrics;
import kafka.tier.raft.KRaftSnapshotObject;
import kafka.tier.raft.KRaftSnapshotObjectUtils;
import kafka.tier.raft.KRaftSnapshotTestUtils;
import kafka.tier.raft.LocalSnapshotObject;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.metadata.KRaftSnapshotMetadata;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

final class KRaftSnapshotManagerTest {
    private MockTime time;
    private MockEventExecutor executor;
    private MockInMemoryTierObjectStore tierObjectStore;
    private Path tempDir = null;
    private File file;
    private Metrics metrics;
    private KRaftSnapshotMetrics raftSnapshotMetrics;
    private final LogContext logContext = new LogContext("kraft-snapshot-upload-test");
    private final String keyPrefix = "";
    private final String clusterId = "pkc-abc";
    private Function<TopicIdPartition, Optional<Path>> topicIdPath;
    private final Supplier<Boolean> deleteEnable = () -> true;
    private final Supplier<Long> retentionMs = () -> TimeUnit.DAYS.toMillis(7L);
    private KRaftSnapshotManager snapshotManager;
    private final TopicIdPartition metadataTpId = new TopicIdPartition(KafkaRaftServer.MetadataTopicId(), KafkaRaftServer.MetadataPartition());
    private final int epoch = 10;
    private final int nodeId = 2;
    private final OptionalInt nodeIdOpt = OptionalInt.of(2);
    private final OptionalLong hwm = OptionalLong.of(100L);
    private final long logStartOffset = 9L;
    private final long logEndOffset = 199L;
    private final OptionalInt leaderId = OptionalInt.of(1);
    private final Set<Integer> currentVoters = new HashSet<Integer>(Arrays.asList(1, 2, 3));
    private final long lastContainedLogTimestampMs = Time.SYSTEM.milliseconds();
    private final OffsetAndEpoch snapshotId1 = new OffsetAndEpoch(2524L, 78);
    private final OffsetAndEpoch snapshotId2 = new OffsetAndEpoch(this.snapshotId1.offset() - 1L, this.snapshotId1.epoch() - 1);

    KRaftSnapshotManagerTest() {
    }

    @BeforeEach
    void setUp() {
        this.time = new MockTime();
        this.executor = new MockEventExecutor(this.time);
        this.tierObjectStore = new MockInMemoryTierObjectStore((Time)this.time, new MockInMemoryTierObjectStoreConfig());
        this.tierObjectStore.clearForClusterId();
        this.metrics = new Metrics((Time)this.time);
        this.raftSnapshotMetrics = new KRaftSnapshotMetrics(this.metrics);
        this.tempDir = TestUtils.tempDirectory().toPath();
        this.file = KRaftSnapshotTestUtils.createSnapshot(this.tempDir, this.snapshotId1, this.lastContainedLogTimestampMs, (Time)this.time).toFile();
        KRaftSnapshotTestUtils.createSnapshot(this.tempDir, this.snapshotId2, this.lastContainedLogTimestampMs, (Time)this.time);
        this.topicIdPath = topicIdPartition -> Optional.of(this.tempDir);
    }

    @AfterEach
    void tearDown() throws Exception {
        CompletableFuture shutdown = this.executor.shutdown();
        Assertions.assertTrue((boolean)shutdown.isDone());
        Assertions.assertFalse((boolean)shutdown.isCancelled());
        Assertions.assertFalse((boolean)shutdown.isCompletedExceptionally());
        Utils.delete((File)this.tempDir.toFile());
        this.tierObjectStore.clearForClusterId();
        this.tierObjectStore.close();
        if (this.raftSnapshotMetrics != null) {
            this.raftSnapshotMetrics.close();
        }
        this.metrics.close();
    }

    @Test
    void testRemoteList() throws IOException {
        KRaftSnapshotObject uploadedObject = new KRaftSnapshotObject(this.metadataTpId.topicId(), this.metadataTpId.partition(), "pkc-abc", 2, 234L, new OffsetAndEpoch(567L, 89));
        KRaftSnapshotMetadata uploadedMetadata = new KRaftSnapshotMetadata(uploadedObject);
        KRaftSnapshotObjectUtils.putObject((TierObjectStore)this.tierObjectStore, (KRaftSnapshotMetadata)uploadedMetadata, (File)this.file);
        this.snapshotManager = KRaftSnapshotManager.create((EventExecutor)this.executor, (TierObjectStore)this.tierObjectStore, (KRaftSnapshotMetrics)this.raftSnapshotMetrics, (LogContext)this.logContext, this.topicIdPath, (String)"pkc-abc", (int)2, this.deleteEnable, this.retentionMs, (Time)this.time);
        this.executeAndVerifyContext(0, Optional.of(new TreeSet<KRaftSnapshotObject>(Collections.singletonList(uploadedObject))), false, 0, new TreeSet<LocalSnapshotObject>());
    }

    @Test
    void testListRemoteObjectsAreRetried() throws IOException {
        KRaftSnapshotObject uploadedObject = new KRaftSnapshotObject(this.metadataTpId.topicId(), this.metadataTpId.partition(), "pkc-abc", 2, this.lastContainedLogTimestampMs, new OffsetAndEpoch(567L, 89));
        KRaftSnapshotMetadata uploadedMetadata = new KRaftSnapshotMetadata(uploadedObject);
        KRaftSnapshotObject localObject = new KRaftSnapshotObject(this.metadataTpId.topicId(), this.metadataTpId.partition(), "pkc-abc", 2, this.lastContainedLogTimestampMs, this.snapshotId1);
        LocalSnapshotObject localSnapshotObject = new LocalSnapshotObject(localObject, this.metadataTpId);
        KRaftSnapshotObjectUtils.putObject((TierObjectStore)this.tierObjectStore, (KRaftSnapshotMetadata)uploadedMetadata, (File)this.file);
        this.snapshotManager = KRaftSnapshotManager.create((EventExecutor)this.executor, (TierObjectStore)this.tierObjectStore, (KRaftSnapshotMetrics)this.raftSnapshotMetrics, (LogContext)this.logContext, this.topicIdPath, (String)"pkc-abc", (int)2, this.deleteEnable, this.retentionMs, (Time)this.time);
        this.tierObjectStore.throwOnListCondition = () -> true;
        this.executeAndVerifyContext(1, Optional.empty(), false, 0, new TreeSet<LocalSnapshotObject>());
        long oneSecondMs = TimeUnit.SECONDS.toMillis(1L);
        this.time.sleep(oneSecondMs - 1L);
        Assertions.assertFalse((boolean)this.executor.poll());
        this.time.sleep(1L);
        this.executeAndVerifyContext(2, Optional.empty(), false, 0, new TreeSet<LocalSnapshotObject>());
        long twoSecondMs = TimeUnit.SECONDS.toMillis(2L);
        this.time.sleep(twoSecondMs);
        this.executeAndVerifyContext(3, Optional.empty(), false, 0, new TreeSet<LocalSnapshotObject>());
        this.snapshotManager.snapshotGenerated(this.metadataTpId, 10, this.nodeIdOpt, this.hwm, 9L, 199L, this.snapshotId1, this.leaderId, this.currentVoters);
        this.executeAndVerifyContext(3, Optional.empty(), false, 0, new TreeSet<LocalSnapshotObject>(Collections.singletonList(localSnapshotObject)));
        this.tierObjectStore.throwOnListCondition = () -> false;
        long threeSecondMs = TimeUnit.SECONDS.toMillis(3L);
        this.time.sleep(threeSecondMs);
        this.executeAndVerifyContext(0, Optional.of(new TreeSet<KRaftSnapshotObject>(Collections.singletonList(uploadedObject))), true, 0, new TreeSet<LocalSnapshotObject>(Collections.singletonList(localSnapshotObject)));
        this.executeAndVerifyContext(0, Optional.of(new TreeSet<KRaftSnapshotObject>(Arrays.asList(localObject, uploadedObject))), false, 0, new TreeSet<LocalSnapshotObject>());
        this.time.sleep(this.retentionMs.get().longValue());
        this.executeAndVerifyContext(0, Optional.of(new TreeSet<KRaftSnapshotObject>(Collections.singletonList(localObject))), false, 0, new TreeSet<LocalSnapshotObject>());
        this.executeAndVerifyContext(0, Optional.of(new TreeSet()), false, 0, new TreeSet<LocalSnapshotObject>());
    }

    @Test
    void testLocalUpload() {
        KRaftSnapshotObject localObject = new KRaftSnapshotObject(this.metadataTpId.topicId(), this.metadataTpId.partition(), "pkc-abc", 2, this.lastContainedLogTimestampMs, this.snapshotId1);
        LocalSnapshotObject localSnapshotObject = new LocalSnapshotObject(localObject, this.metadataTpId);
        this.snapshotManager = KRaftSnapshotManager.create((EventExecutor)this.executor, (TierObjectStore)this.tierObjectStore, (KRaftSnapshotMetrics)this.raftSnapshotMetrics, (LogContext)this.logContext, this.topicIdPath, (String)"pkc-abc", (int)2, this.deleteEnable, this.retentionMs, (Time)this.time);
        this.executeAndVerifyContext(0, Optional.of(new TreeSet()), false, 0, new TreeSet<LocalSnapshotObject>());
        this.snapshotManager.snapshotGenerated(this.metadataTpId, 10, this.nodeIdOpt, this.hwm, 9L, 199L, this.snapshotId1, this.leaderId, this.currentVoters);
        this.executeAndVerifyContext(0, Optional.of(new TreeSet()), true, 0, new TreeSet<LocalSnapshotObject>(Collections.singletonList(localSnapshotObject)));
        this.executeAndVerifyContext(0, Optional.of(new TreeSet<KRaftSnapshotObject>(Collections.singletonList(localObject))), false, 0, new TreeSet<LocalSnapshotObject>());
    }

    @Test
    void testLocalUploadsAreRetried() {
        KRaftSnapshotObject localObject = new KRaftSnapshotObject(this.metadataTpId.topicId(), this.metadataTpId.partition(), "pkc-abc", 2, this.lastContainedLogTimestampMs, this.snapshotId1);
        LocalSnapshotObject localSnapshotObject = new LocalSnapshotObject(localObject, this.metadataTpId);
        this.snapshotManager = KRaftSnapshotManager.create((EventExecutor)this.executor, (TierObjectStore)this.tierObjectStore, (KRaftSnapshotMetrics)this.raftSnapshotMetrics, (LogContext)this.logContext, this.topicIdPath, (String)"pkc-abc", (int)2, this.deleteEnable, this.retentionMs, (Time)this.time);
        this.executeAndVerifyContext(0, Optional.of(new TreeSet()), false, 0, new TreeSet<LocalSnapshotObject>());
        this.snapshotManager.snapshotGenerated(this.metadataTpId, 10, this.nodeIdOpt, this.hwm, 9L, 199L, this.snapshotId1, this.leaderId, this.currentVoters);
        this.executeAndVerifyContext(0, Optional.of(new TreeSet()), true, 0, new TreeSet<LocalSnapshotObject>(Collections.singletonList(localSnapshotObject)));
        this.tierObjectStore.throwOnCondition = (method, metadata, objectType) -> Objects.equals(method, "putObject");
        this.executeAndVerifyContext(0, Optional.of(new TreeSet()), true, 1, new TreeSet<LocalSnapshotObject>(Collections.singletonList(localSnapshotObject)));
        long oneSecondMs = TimeUnit.SECONDS.toMillis(1L);
        this.time.sleep(oneSecondMs - 1L);
        Assertions.assertFalse((boolean)this.executor.poll());
        this.time.sleep(1L);
        this.executeAndVerifyContext(0, Optional.of(new TreeSet()), true, 2, new TreeSet<LocalSnapshotObject>(Collections.singletonList(localSnapshotObject)));
        long twoSecondMs = TimeUnit.SECONDS.toMillis(2L);
        this.time.sleep(twoSecondMs);
        this.executeAndVerifyContext(0, Optional.of(new TreeSet()), true, 3, new TreeSet<LocalSnapshotObject>(Collections.singletonList(localSnapshotObject)));
        this.tierObjectStore.throwOnCondition = null;
        long threeSecondMs = TimeUnit.SECONDS.toMillis(3L);
        this.time.sleep(threeSecondMs);
        this.executeAndVerifyContext(0, Optional.of(new TreeSet<KRaftSnapshotObject>(Collections.singletonList(localObject))), false, 0, new TreeSet<LocalSnapshotObject>());
    }

    @Test
    void testSnapshotsAreNotReUploaded() throws IOException {
        KRaftSnapshotObject localObject = new KRaftSnapshotObject(this.metadataTpId.topicId(), this.metadataTpId.partition(), "pkc-abc", 2, this.lastContainedLogTimestampMs, this.snapshotId1);
        KRaftSnapshotMetadata localMetadata = new KRaftSnapshotMetadata(localObject);
        KRaftSnapshotObjectUtils.putObject((TierObjectStore)this.tierObjectStore, (KRaftSnapshotMetadata)localMetadata, (File)this.file);
        this.snapshotManager = KRaftSnapshotManager.create((EventExecutor)this.executor, (TierObjectStore)this.tierObjectStore, (KRaftSnapshotMetrics)this.raftSnapshotMetrics, (LogContext)this.logContext, this.topicIdPath, (String)"pkc-abc", (int)2, this.deleteEnable, this.retentionMs, (Time)this.time);
        this.executeAndVerifyContext(0, Optional.of(new TreeSet<KRaftSnapshotObject>(Collections.singletonList(localObject))), false, 0, new TreeSet<LocalSnapshotObject>());
        this.snapshotManager.snapshotGenerated(this.metadataTpId, 10, this.nodeIdOpt, this.hwm, 9L, 199L, this.snapshotId1, this.leaderId, this.currentVoters);
        this.executeAndVerifyContext(0, Optional.of(new TreeSet<KRaftSnapshotObject>(Collections.singletonList(localObject))), false, 0, new TreeSet<LocalSnapshotObject>());
        this.time.sleep(this.retentionMs.get().longValue());
        this.executeAndVerifyContext(0, Optional.of(new TreeSet()), false, 0, new TreeSet<LocalSnapshotObject>());
    }

    @Test
    void testLocalUploadLatestAvailable() {
        KRaftSnapshotObject localObject1 = new KRaftSnapshotObject(this.metadataTpId.topicId(), this.metadataTpId.partition(), "pkc-abc", 2, this.lastContainedLogTimestampMs, this.snapshotId1);
        LocalSnapshotObject localSnapshotObject1 = new LocalSnapshotObject(localObject1, this.metadataTpId);
        KRaftSnapshotObject localObject2 = new KRaftSnapshotObject(this.metadataTpId.topicId(), this.metadataTpId.partition(), "pkc-abc", 2, this.lastContainedLogTimestampMs, this.snapshotId2);
        LocalSnapshotObject localSnapshotObject2 = new LocalSnapshotObject(localObject2, this.metadataTpId);
        this.snapshotManager = KRaftSnapshotManager.create((EventExecutor)this.executor, (TierObjectStore)this.tierObjectStore, (KRaftSnapshotMetrics)this.raftSnapshotMetrics, (LogContext)this.logContext, this.topicIdPath, (String)"pkc-abc", (int)2, this.deleteEnable, this.retentionMs, (Time)this.time);
        this.executeAndVerifyContext(0, Optional.of(new TreeSet()), false, 0, new TreeSet<LocalSnapshotObject>());
        List<OffsetAndEpoch> snapshotIds = Arrays.asList(this.snapshotId1, this.snapshotId2);
        this.snapshotManager.nodeStartedUp(this.metadataTpId, 10, this.nodeIdOpt, this.hwm, 9L, 199L, new TreeSet<OffsetAndEpoch>(snapshotIds), this.leaderId, this.currentVoters);
        this.executeAndVerifyContext(0, Optional.of(new TreeSet()), true, 0, new TreeSet<LocalSnapshotObject>(Arrays.asList(localSnapshotObject1, localSnapshotObject2)));
        this.executeAndVerifyContext(0, Optional.of(new TreeSet<KRaftSnapshotObject>(Collections.singletonList(localObject1))), true, 0, new TreeSet<LocalSnapshotObject>(Collections.singletonList(localSnapshotObject2)));
        this.executeAndVerifyContext(0, Optional.of(new TreeSet<KRaftSnapshotObject>(Arrays.asList(localObject1, localObject2))), false, 0, new TreeSet<LocalSnapshotObject>());
        this.time.sleep(this.retentionMs.get().longValue());
        this.executeAndVerifyContext(0, Optional.of(new TreeSet<KRaftSnapshotObject>(Collections.singletonList(localObject2))), false, 0, new TreeSet<LocalSnapshotObject>());
        this.executeAndVerifyContext(0, Optional.of(new TreeSet()), false, 0, new TreeSet<LocalSnapshotObject>());
    }

    @Test
    void testLocalObjectEquals() {
        KRaftSnapshotObject localObject1 = new KRaftSnapshotObject(this.metadataTpId.topicId(), this.metadataTpId.partition(), "pkc-abc", 2, this.lastContainedLogTimestampMs, this.snapshotId1);
        LocalSnapshotObject localSnapshotObject1 = new LocalSnapshotObject(localObject1, this.metadataTpId);
        KRaftSnapshotObject localObject2 = new KRaftSnapshotObject(this.metadataTpId.topicId(), this.metadataTpId.partition(), "pkc-abc", 2, 0L, this.snapshotId2);
        LocalSnapshotObject localSnapshotObject2 = new LocalSnapshotObject(localObject2, this.metadataTpId);
        Assertions.assertNotEquals((Object)localObject1, (Object)localObject2);
        Assertions.assertNotEquals((Object)localSnapshotObject1, (Object)localSnapshotObject2);
    }

    @Test
    void testLocalUploadSkippedIfSnapshotFileIsCorrupted() throws IOException {
        KRaftSnapshotObject localObject = new KRaftSnapshotObject(this.metadataTpId.topicId(), this.metadataTpId.partition(), "pkc-abc", 2, this.lastContainedLogTimestampMs, this.snapshotId1);
        LocalSnapshotObject localSnapshotObject = new LocalSnapshotObject(localObject, this.metadataTpId);
        KRaftSnapshotTestUtils.corruptSnapshotFile(this.file, 1);
        this.snapshotManager = KRaftSnapshotManager.create((EventExecutor)this.executor, (TierObjectStore)this.tierObjectStore, (KRaftSnapshotMetrics)this.raftSnapshotMetrics, (LogContext)this.logContext, this.topicIdPath, (String)"pkc-abc", (int)2, this.deleteEnable, this.retentionMs, (Time)this.time);
        this.executeAndVerifyContext(0, Optional.of(new TreeSet()), false, 0, new TreeSet<LocalSnapshotObject>());
        this.snapshotManager.snapshotGenerated(this.metadataTpId, 10, this.nodeIdOpt, this.hwm, 9L, 199L, this.snapshotId1, this.leaderId, this.currentVoters);
        this.executeAndVerifyContext(0, Optional.of(new TreeSet()), true, 0, new TreeSet<LocalSnapshotObject>(Collections.singletonList(localSnapshotObject)));
        this.executeAndVerifyContext(0, Optional.of(new TreeSet()), false, 0, new TreeSet<LocalSnapshotObject>());
        Assertions.assertFalse((boolean)this.executor.poll());
    }

    private void executeAndVerifyContext(int remoteListRetries, Optional<SortedSet<KRaftSnapshotObject>> remoteObjects, boolean uploadScheduled, int remotePutRetries, SortedSet<LocalSnapshotObject> localObjects) {
        Assertions.assertTrue((boolean)this.executor.poll());
        Assertions.assertEquals((int)remoteListRetries, (int)this.snapshotManager.context.remoteListRetries);
        Assertions.assertEquals(remoteObjects, (Object)this.snapshotManager.context.remoteObjects);
        Assertions.assertEquals((Object)uploadScheduled, (Object)this.snapshotManager.context.uploadScheduled);
        Assertions.assertEquals((int)remotePutRetries, (int)this.snapshotManager.context.remotePutRetries);
        Assertions.assertEquals(localObjects, (Object)this.snapshotManager.context.localObjects);
        Assertions.assertEquals(remoteObjects, this.remoteState());
    }

    private Optional<Set<KRaftSnapshotObject>> remoteState() {
        if (((Boolean)this.tierObjectStore.throwOnListCondition.get()).booleanValue()) {
            return Optional.empty();
        }
        return Optional.of(KRaftSnapshotObjectUtils.listObjects((TierObjectStore)this.tierObjectStore, (boolean)false, (String)"").keySet());
    }
}

