/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.raft;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import kafka.tier.raft.KRaftSnapshotManager;
import kafka.tier.raft.KRaftSnapshotMetrics;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class KRaftSnapshotMetricsTest {
    private final Time time = new MockTime();
    private final Metrics metrics = new Metrics(this.time);
    private KRaftSnapshotMetrics snapshotMetrics;

    @BeforeEach
    void setUp() {
        this.snapshotMetrics = new KRaftSnapshotMetrics(this.metrics);
    }

    @AfterEach
    void tearDown() throws Exception {
        this.snapshotMetrics.close();
        Assertions.assertNull((Object)this.getMetric("metadata-upload-lag-ms"));
        Assertions.assertNull((Object)this.getMetric("metadata-error"));
        Assertions.assertNull((Object)this.getMetric("put-latency-ms-50-percentile"));
        Assertions.assertNull((Object)this.getMetric("put-latency-ms-90-percentile"));
        Assertions.assertNull((Object)this.getMetric("put-latency-ms-99-percentile"));
        Assertions.assertNull((Object)this.getMetric("delete-latency-ms-50-percentile"));
        Assertions.assertNull((Object)this.getMetric("delete-latency-ms-90-percentile"));
        Assertions.assertNull((Object)this.getMetric("delete-latency-ms-99-percentile"));
        Assertions.assertNull((Object)this.getMetric("snapshot-file-on-disk-corruption"));
        Assertions.assertNull((Object)this.getMetric("snapshot-file-on-network-corruption"));
        this.metrics.close();
    }

    @Test
    void testUpdateLastUploadMs() {
        Assertions.assertEquals((Object)-1.0, (Object)this.getMetric("metadata-upload-lag-ms").metricValue());
        this.snapshotMetrics.updateLastUploadMs(this.time.milliseconds());
        Assertions.assertEquals((Object)0.0, (Object)this.getMetric("metadata-upload-lag-ms").metricValue());
        long oneSecondMs = TimeUnit.SECONDS.toMillis(1L);
        this.time.sleep(oneSecondMs);
        Assertions.assertEquals((Object)1000.0, (Object)this.getMetric("metadata-upload-lag-ms").metricValue());
        this.snapshotMetrics.updateLastUploadMs(this.time.milliseconds());
        Assertions.assertEquals((Object)0.0, (Object)this.getMetric("metadata-upload-lag-ms").metricValue());
    }

    @Test
    void testUpdateError() {
        Assertions.assertEquals((Object)0.0, (Object)this.getMetric("metadata-error").metricValue());
        this.snapshotMetrics.updateError(true);
        Assertions.assertEquals((Object)1.0, (Object)this.getMetric("metadata-error").metricValue());
        this.snapshotMetrics.updateError(false);
        Assertions.assertEquals((Object)0.0, (Object)this.getMetric("metadata-error").metricValue());
    }

    @ParameterizedTest
    @ValueSource(strings={"put", "delete"})
    void testUpdateLatencies(String type) {
        String sensorPrefix;
        Sensor sensor;
        if (Objects.equals(type, "put")) {
            sensor = this.snapshotMetrics.putLatencySensor();
            sensorPrefix = "put-latency-ms";
        } else {
            sensor = this.snapshotMetrics.deleteLatencySensor();
            sensorPrefix = "delete-latency-ms";
        }
        for (int i = 1; i <= 100; ++i) {
            int latencySeconds = i <= 89 ? 1 : (i <= 98 ? 2 : 3);
            KRaftSnapshotManager.recordDuration((Sensor)sensor, () -> {
                this.time.sleep(TimeUnit.SECONDS.toMillis(latencySeconds));
                return null;
            }, (Time)this.time);
        }
        Assertions.assertEquals((Object)1000.0, (Object)this.getMetric(sensorPrefix + "-50-percentile").metricValue());
        Assertions.assertEquals((Object)2000.0, (Object)this.getMetric(sensorPrefix + "-90-percentile").metricValue());
        Assertions.assertEquals((Object)3000.0, (Object)this.getMetric(sensorPrefix + "-99-percentile").metricValue());
    }

    @Test
    void testIncrementOnDiskCorruption() {
        for (int i = 0; i < 10; ++i) {
            this.snapshotMetrics.incrementOnDiskCorruption();
        }
        Assertions.assertEquals((Object)10.0, (Object)this.getMetric("snapshot-file-on-disk-corruption").metricValue());
    }

    @Test
    void testIncrementOnNetworkCorruption() {
        for (int i = 0; i < 10; ++i) {
            this.snapshotMetrics.incrementOnNetworkCorruption();
        }
        Assertions.assertEquals((Object)10.0, (Object)this.getMetric("snapshot-file-on-network-corruption").metricValue());
    }

    private KafkaMetric getMetric(String name) {
        return (KafkaMetric)this.metrics.metrics().get(this.metrics.metricName(name, "raft-backup-metrics"));
    }
}

