/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.raft;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kafka.server.KafkaRaftServer;
import kafka.tier.raft.KRaftSnapshotObject;
import kafka.tier.raft.KRaftSnapshotObjectUtils;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.MockInMemoryTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.VersionInformation;
import kafka.tier.store.objects.metadata.KRaftSnapshotMetadata;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class KRaftSnapshotObjectUtilsTest {
    MockTime mockTime = new MockTime();
    MockInMemoryTierObjectStore tierObjectStore;
    String keyPrefix = "";
    String clusterId = "pkc-abc";
    TopicIdPartition metadataTpId = new TopicIdPartition(KafkaRaftServer.MetadataTopicId(), KafkaRaftServer.MetadataPartition());

    KRaftSnapshotObjectUtilsTest() {
    }

    @BeforeEach
    public void setUp() {
        this.tierObjectStore = new MockInMemoryTierObjectStore((Time)this.mockTime, new MockInMemoryTierObjectStoreConfig());
        this.tierObjectStore.clearForClusterId();
    }

    @AfterEach
    public void tearDown() {
        this.tierObjectStore.clearForClusterId();
        this.tierObjectStore.close();
    }

    @Test
    void testList() throws IOException {
        KRaftSnapshotObject snapshotObject = new KRaftSnapshotObject(this.metadataTpId.topicId(), this.metadataTpId.partition(), this.clusterId, 1, 234L, new OffsetAndEpoch(567L, 89));
        File file = TestUtils.tempFile();
        file.createNewFile();
        KRaftSnapshotMetadata metadata = new KRaftSnapshotMetadata(snapshotObject);
        KRaftSnapshotObjectUtils.putObject((TierObjectStore)this.tierObjectStore, (KRaftSnapshotMetadata)metadata, (File)file);
        Map objects = KRaftSnapshotObjectUtils.listObjects((TierObjectStore)this.tierObjectStore, (boolean)false, (String)this.keyPrefix);
        Assertions.assertEquals(new HashSet<KRaftSnapshotObject>(Collections.singletonList(snapshotObject)), objects.keySet());
        objects = KRaftSnapshotObjectUtils.listObjects((TierObjectStore)this.tierObjectStore, (boolean)false, (String)"randomPrefix");
        Assertions.assertEquals(new HashSet(Collections.emptyList()), objects.keySet());
    }

    @Test
    void testListByNode() throws IOException {
        int nodeId1 = 1;
        int nodeId2 = 2;
        KRaftSnapshotObject snapshotObjectNodeId1 = new KRaftSnapshotObject(this.metadataTpId.topicId(), this.metadataTpId.partition(), this.clusterId, nodeId1, 234L, new OffsetAndEpoch(567L, 89));
        KRaftSnapshotObject snapshotObjectNodeId2 = new KRaftSnapshotObject(this.metadataTpId.topicId(), this.metadataTpId.partition(), this.clusterId, nodeId2, 1L, new OffsetAndEpoch(23L, 45));
        KRaftSnapshotObject snapshotObjectNodeId2Another = new KRaftSnapshotObject(this.metadataTpId.topicId(), this.metadataTpId.partition(), this.clusterId, nodeId2, 12L, new OffsetAndEpoch(34L, 56));
        File file = TestUtils.tempFile();
        file.createNewFile();
        KRaftSnapshotMetadata metadata1 = new KRaftSnapshotMetadata(snapshotObjectNodeId1);
        KRaftSnapshotMetadata metadata2 = new KRaftSnapshotMetadata(snapshotObjectNodeId2);
        KRaftSnapshotMetadata metadata2Another = new KRaftSnapshotMetadata(snapshotObjectNodeId2Another);
        KRaftSnapshotObjectUtils.putObject((TierObjectStore)this.tierObjectStore, (KRaftSnapshotMetadata)metadata1, (File)file);
        KRaftSnapshotObjectUtils.putObject((TierObjectStore)this.tierObjectStore, (KRaftSnapshotMetadata)metadata2, (File)file);
        KRaftSnapshotObjectUtils.putObject((TierObjectStore)this.tierObjectStore, (KRaftSnapshotMetadata)metadata2Another, (File)file);
        Map objects = KRaftSnapshotObjectUtils.listObjects((TierObjectStore)this.tierObjectStore, (boolean)false, (String)this.keyPrefix);
        Assertions.assertEquals(new HashSet<KRaftSnapshotObject>(Arrays.asList(snapshotObjectNodeId1, snapshotObjectNodeId2, snapshotObjectNodeId2Another)), objects.keySet());
        objects = KRaftSnapshotObjectUtils.listObjectsByNode((TierObjectStore)this.tierObjectStore, (boolean)false, (String)this.keyPrefix, (Uuid)this.metadataTpId.topicId(), (int)this.metadataTpId.partition(), (String)this.clusterId, (int)nodeId1);
        Assertions.assertEquals(new HashSet<KRaftSnapshotObject>(Collections.singletonList(snapshotObjectNodeId1)), objects.keySet());
        objects = KRaftSnapshotObjectUtils.listObjectsByNode((TierObjectStore)this.tierObjectStore, (boolean)false, (String)this.keyPrefix, (Uuid)this.metadataTpId.topicId(), (int)this.metadataTpId.partition(), (String)this.clusterId, (int)nodeId2);
        Assertions.assertEquals(new HashSet<KRaftSnapshotObject>(Arrays.asList(snapshotObjectNodeId2, snapshotObjectNodeId2Another)), objects.keySet());
    }

    @Test
    void testGetVersion() throws IOException {
        KRaftSnapshotObject snapshotObject = new KRaftSnapshotObject(this.metadataTpId.topicId(), this.metadataTpId.partition(), this.clusterId, 1, 234L, new OffsetAndEpoch(567L, 89));
        File file = TestUtils.tempFile();
        file.createNewFile();
        KRaftSnapshotMetadata metadata = new KRaftSnapshotMetadata(snapshotObject);
        KRaftSnapshotObjectUtils.putObject((TierObjectStore)this.tierObjectStore, (KRaftSnapshotMetadata)metadata, (File)file);
        Map objects = KRaftSnapshotObjectUtils.listObjects((TierObjectStore)this.tierObjectStore, (boolean)true, (String)this.keyPrefix);
        Assertions.assertEquals(new HashSet<KRaftSnapshotObject>(Collections.singletonList(snapshotObject)), objects.keySet());
        VersionInformation versionInformation = (VersionInformation)((List)objects.values().iterator().next()).get(0);
        Assertions.assertDoesNotThrow(() -> KRaftSnapshotObjectUtils.getObject((TierObjectStore)this.tierObjectStore, (KRaftSnapshotMetadata)metadata, (VersionInformation)versionInformation));
        Assertions.assertDoesNotThrow(() -> KRaftSnapshotObjectUtils.getObject((TierObjectStore)this.tierObjectStore, (KRaftSnapshotMetadata)metadata, null));
    }

    @Test
    void testDelete() throws IOException {
        KRaftSnapshotObject snapshotObject = new KRaftSnapshotObject(this.metadataTpId.topicId(), this.metadataTpId.partition(), this.clusterId, 1, 234L, new OffsetAndEpoch(567L, 89));
        File file = TestUtils.tempFile();
        file.createNewFile();
        KRaftSnapshotMetadata metadata = new KRaftSnapshotMetadata(snapshotObject);
        KRaftSnapshotObjectUtils.putObject((TierObjectStore)this.tierObjectStore, (KRaftSnapshotMetadata)metadata, (File)file);
        Map objects = KRaftSnapshotObjectUtils.listObjects((TierObjectStore)this.tierObjectStore, (boolean)false, (String)this.keyPrefix);
        Assertions.assertEquals(new HashSet<KRaftSnapshotObject>(Collections.singletonList(snapshotObject)), objects.keySet());
        KRaftSnapshotObjectUtils.deleteObject((TierObjectStore)this.tierObjectStore, (KRaftSnapshotMetadata)metadata, (String)"randomPrefix");
        objects = KRaftSnapshotObjectUtils.listObjects((TierObjectStore)this.tierObjectStore, (boolean)false, (String)this.keyPrefix);
        Assertions.assertEquals(new HashSet<KRaftSnapshotObject>(Collections.singletonList(snapshotObject)), objects.keySet());
        KRaftSnapshotObjectUtils.deleteObject((TierObjectStore)this.tierObjectStore, (KRaftSnapshotMetadata)metadata, (String)this.keyPrefix);
        objects = KRaftSnapshotObjectUtils.listObjects((TierObjectStore)this.tierObjectStore, (boolean)false, (String)this.keyPrefix);
        Assertions.assertEquals(new HashSet(Collections.emptyList()), objects.keySet());
    }
}

