/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.raft;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.snapshot.FileRawSnapshotWriter;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.RecordsSnapshotWriter;
import org.apache.kafka.snapshot.Snapshots;
import org.junit.jupiter.api.Assertions;

public class KRaftSnapshotTestUtils {
    public static Path createSnapshot(Path tempDir, OffsetAndEpoch snapshotId, long lastContainedLogTimestampMs, Time time) {
        List<ApiMessageAndVersion> records = Arrays.asList(new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(10L), 0), new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(13L), 0), new ApiMessageAndVersion((ApiMessage)new RegisterBrokerRecord().setBrokerId(2).setBrokerEpoch(7L), 0), new ApiMessageAndVersion((ApiMessage)new TopicRecord().setName("topic").setTopicId(Uuid.randomUuid()), 0), new ApiMessageAndVersion((ApiMessage)new PartitionRecord().setTopicId(Uuid.randomUuid()).setPartitionId(0).setReplicas(Arrays.asList(0, 1, 2)).setIsr(Arrays.asList(0, 1, 2)).setLeader(0).setLeaderEpoch(1).setPartitionEpoch(0), 0), new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("").setName("min.insync.replicas").setValue("2"), 0), new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.TOPIC.id()).setResourceName("topic").setName("min.insync.replicas").setValue("1"), 0));
        FileRawSnapshotWriter snapshotWriter = FileRawSnapshotWriter.create((Path)tempDir, (OffsetAndEpoch)snapshotId, Optional.empty());
        try (RecordsSnapshotWriter writer = RecordsSnapshotWriter.createWithHeader((RawSnapshotWriter)snapshotWriter, (int)1024, (MemoryPool)MemoryPool.NONE, (Time)time, (long)lastContainedLogTimestampMs, (CompressionType)CompressionType.NONE, (RecordSerde)MetadataRecordSerde.INSTANCE);){
            writer.append(records);
            writer.freeze();
        }
        Assertions.assertEquals((long)lastContainedLogTimestampMs, (long)Snapshots.lastContainedLogTimestamp((Path)tempDir, (OffsetAndEpoch)snapshotId));
        return snapshotWriter.targetSnapshotPath();
    }

    public static void corruptSnapshotFile(File file, int bytesToCorruptFromEnd) throws IOException {
        int startIndex;
        boolean isWritable = file.canWrite();
        byte[] fileBytes = Files.readAllBytes(file.toPath());
        for (int i = startIndex = Math.max(0, fileBytes.length - bytesToCorruptFromEnd); i < fileBytes.length; ++i) {
            fileBytes[i] = ~fileBytes[i];
        }
        if (!isWritable) {
            file.setWritable(true);
        }
        Files.write(file.toPath(), fileBytes, new OpenOption[0]);
        file.setWritable(isWritable);
    }
}

