/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.snapshot;

import io.confluent.kafka.storage.checksum.Algorithm;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.UUID;
import kafka.log.LocalLog$;
import kafka.log.TierLogSegment;
import kafka.restore.snapshot.FtpsSnapshotMaterializer;
import kafka.server.Defaults$;
import kafka.server.ReplicaManager;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.AbstractTierSegmentMetadata;
import kafka.tier.domain.TierSegmentDeleteComplete;
import kafka.tier.domain.TierSegmentDeleteInitiate;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.OpaqueData;
import kafka.utils.CheckedFileIOTestUtils$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.ConfluentLogConfig;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tMa\u0001B\u001b7\u0001uBQ\u0001\u0012\u0001\u0005\u0002\u0015Cq\u0001\u0013\u0001C\u0002\u0013\u0005\u0011\n\u0003\u0004N\u0001\u0001\u0006IA\u0013\u0005\b\u001d\u0002\u0011\r\u0011\"\u0001J\u0011\u0019y\u0005\u0001)A\u0005\u0015\"9\u0001\u000b\u0001b\u0001\n\u0003I\u0005BB)\u0001A\u0003%!\nC\u0004S\u0001\t\u0007I\u0011A*\t\r]\u0003\u0001\u0015!\u0003U\u0011\u001dA\u0006A1A\u0005\u0002eCa!\u0018\u0001!\u0002\u0013Q\u0006b\u00020\u0001\u0005\u0004%\ta\u0018\u0005\u0007M\u0002\u0001\u000b\u0011\u00021\t\u000f\u001d\u0004!\u0019!C\u0001\u0013\"1\u0001\u000e\u0001Q\u0001\n)Cq!\u001b\u0001C\u0002\u0013\u0005!\u000e\u0003\u0004y\u0001\u0001\u0006Ia\u001b\u0005\bs\u0002\u0011\r\u0011\"\u0001{\u0011\u0019q\b\u0001)A\u0005w\"9q\u0010\u0001b\u0001\n\u0003I\u0006bBA\u0001\u0001\u0001\u0006IA\u0017\u0005\n\u0003\u0007\u0001!\u0019!C\u0001\u0003\u000bA\u0001\"!\u0004\u0001A\u0003%\u0011q\u0001\u0005\n\u0003\u001f\u0001!\u0019!C\u0001\u0003#A\u0001\"!\t\u0001A\u0003%\u00111\u0003\u0005\n\u0003G\u0001!\u0019!C\u0001\u0003#A\u0001\"!\n\u0001A\u0003%\u00111\u0003\u0005\n\u0003O\u0001!\u0019!C\u0001\u0003SA\u0001\"a\u000f\u0001A\u0003%\u00111\u0006\u0005\n\u0003{\u0001!\u0019!C\u0001\u0003\u007fA\u0001\"a\u0016\u0001A\u0003%\u0011\u0011\t\u0005\n\u00033\u0002!\u0019!C\u0001\u00037B\u0001\"!\u001a\u0001A\u0003%\u0011Q\f\u0005\n\u0003O\u0002!\u0019!C\u0001\u0003SB\u0001\"! \u0001A\u0003%\u00111\u000e\u0005\n\u0003\u007f\u0002!\u0019!C\u0001\u0003\u0003C\u0001\"a%\u0001A\u0003%\u00111\u0011\u0005\tG\u0002\u0011\r\u0011\"\u0001\u0002\u0016\"A\u0011Q\u0014\u0001!\u0002\u0013\t9\nC\u0005\u0002 \u0002\u0011\r\u0011\"\u0001\u0002\"\"A\u0011\u0011\u0016\u0001!\u0002\u0013\t\u0019\u000bC\u0005\u0002,\u0002\u0011\r\u0011\"\u0001\u0002.\"A\u0011Q\u0017\u0001!\u0002\u0013\ty\u000bC\u0005\u00028\u0002\u0011\r\u0011\"\u0001\u0002:\"A\u0011Q\u0019\u0001!\u0002\u0013\tY\fC\u0004\u0002H\u0002!\t!!3\t\u000f\u0005\u001d\b\u0001\"\u0001\u0002J\"9\u0011\u0011\u001f\u0001\u0005\u0002\u0005M\bbBA\u007f\u0001\u0011\u0005\u0011\u0011\u001a\u0005\b\u0005\u000f\u0001A\u0011AAe\u0011\u001d\u0011Y\u0001\u0001C\u0001\u0003\u0013DqAa\u0004\u0001\t\u0003\tIM\u0001\u000fGiB\u001c8K\\1qg\"|G/T1uKJL\u0017\r\\5{KJ$Vm\u001d;\u000b\u0005]B\u0014\u0001C:oCB\u001c\bn\u001c;\u000b\u0005eR\u0014\u0001\u0002;jKJT\u0011aO\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\b\u0005\u0002@\u00056\t\u0001IC\u0001B\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0005I\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0019\u0003\"a\u0012\u0001\u000e\u0003Y\nqb\u00195fG.\u001cX/\\#oC\ndW\rZ\u000b\u0002\u0015B\u0011qhS\u0005\u0003\u0019\u0002\u0013qAQ8pY\u0016\fg.\u0001\tdQ\u0016\u001c7n];n\u000b:\f'\r\\3eA\u0005q1m\\7qC\u000e$XI\\1cY\u0016$\u0017aD2p[B\f7\r^#oC\ndW\r\u001a\u0011\u0002\u001d\rdW-\u00198va\u0016s\u0017M\u00197fI\u0006y1\r\\3b]V\u0004XI\\1cY\u0016$\u0007%\u0001\bdY\u0016\fg.\u001e9EK2\f\u00170T:\u0016\u0003Q\u0003\"aP+\n\u0005Y\u0003%\u0001\u0002'p]\u001e\fqb\u00197fC:,\b\u000fR3mCfl5\u000fI\u0001\u0012G2,\u0017M\\;q\u0013:$XM\u001d<bY6\u001bX#\u0001.\u0011\u0005}Z\u0016B\u0001/A\u0005\rIe\u000e^\u0001\u0013G2,\u0017M\\;q\u0013:$XM\u001d<bY6\u001b\b%A\u0007dY\u0016\fg.\u001e9D_:4\u0017nZ\u000b\u0002AB\u0011\u0011\rZ\u0007\u0002E*\u00111\rO\u0001\u0006gR\fG/Z\u0005\u0003K\n\u0014q\u0004V5feB\u000b'\u000f^5uS>t7\u000b^1uK\u000ecW-\u00198va\u000e{gNZ5h\u00039\u0019G.Z1okB\u001cuN\u001c4jO\u0002\n\u0011\u0005^5feB\u000b'\u000f^5uS>t7\u000b^1uKNs\u0017\r]:i_R,e.\u00192mK\u0012\f!\u0005^5feB\u000b'\u000f^5uS>t7\u000b^1uKNs\u0017\r]:i_R,e.\u00192mK\u0012\u0004\u0013!E2iK\u000e\\7/^7BY\u001e|'/\u001b;i[V\t1\u000e\u0005\u0002mm6\tQN\u0003\u0002o_\u0006A1\r[3dWN,XN\u0003\u0002qc\u000691\u000f^8sC\u001e,'BA\u001es\u0015\t\u0019H/A\u0005d_:4G.^3oi*\tQ/\u0001\u0002j_&\u0011q/\u001c\u0002\n\u00032<wN]5uQ6\f!c\u00195fG.\u001cX/\\!mO>\u0014\u0018\u000e\u001e5nA\u0005\u00012/\u001e9fe\ncwnY6MK:<G\u000f[\u000b\u0002wB\u0011q\b`\u0005\u0003{\u0002\u0013Qa\u00155peR\f\u0011c];qKJ\u0014En\\2l\u0019\u0016tw\r\u001e5!\u0003!\u0011'o\\6fe&#\u0017!\u00032s_.,'/\u00133!\u0003\u001d1\u0017m\u0019;pef,\"!a\u0002\u0011\u0007\u0005\fI!C\u0002\u0002\f\t\u0014\u0011\u0004V5feB\u000b'\u000f^5uS>t7\u000b^1uK\u001a\u000b7\r^8ss\u0006Aa-Y2u_JL\b%A\u0005qCJ,g\u000e\u001e#jeV\u0011\u00111\u0003\t\u0005\u0003+\ti\"\u0004\u0002\u0002\u0018)\u0019Q/!\u0007\u000b\u0005\u0005m\u0011\u0001\u00026bm\u0006LA!a\b\u0002\u0018\t!a)\u001b7f\u0003)\u0001\u0018M]3oi\u0012K'\u000fI\u0001\u0004I&\u0014\u0018\u0001\u00023je\u0002\nAb\u001d8baNDw\u000e^:ESJ,\"!a\u000b\u0011\t\u00055\u0012qG\u0007\u0003\u0003_QA!!\r\u00024\u0005!a-\u001b7f\u0015\u0011\t)$!\u0007\u0002\u00079Lw.\u0003\u0003\u0002:\u0005=\"\u0001\u0002)bi\"\fQb\u001d8baNDw\u000e^:ESJ\u0004\u0013A\u0001;q+\t\t\t\u0005\u0005\u0003\u0002D\u0005MSBAA#\u0015\u0011\t9%!\u0013\u0002\r\r|W.\\8o\u0015\rY\u00141\n\u0006\u0005\u0003\u001b\ny%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003#\n1a\u001c:h\u0013\u0011\t)&!\u0012\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u0019A\u000f\u001d\u0011\u0002\tQ\u0004\u0018\u000eZ\u000b\u0003\u0003;\u0002B!a\u0018\u0002b5\t\u0001(C\u0002\u0002da\u0012\u0001\u0003V8qS\u000eLE\rU1si&$\u0018n\u001c8\u0002\u000bQ\u0004\u0018\u000e\u001a\u0011\u0002)1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m+\t\tY\u0007\u0005\u0003\u0002n\u0005eTBAA8\u0015\u0011\t\t(a\u001d\u0002\u00071|wM\u0003\u0003\u0002v\u0005]\u0014!C5oi\u0016\u0014h.\u00197t\u0015\r\u0001\u0018\u0011J\u0005\u0005\u0003w\nyG\u0001\u000bM_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\\\u0001\u0016Y><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7!\u0003\u0011!\u0018.\\3\u0016\u0005\u0005\r\u0005\u0003BAC\u0003\u001fk!!a\"\u000b\t\u0005%\u00151R\u0001\u0005kRLGN\u0003\u0003\u0002\u000e\u0006%\u0013AB:feZ,'/\u0003\u0003\u0002\u0012\u0006\u001d%\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0016\u0005\u0005]\u0005cA1\u0002\u001a&\u0019\u00111\u00142\u0003-\u0019KG.\u001a+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\faa\u001d;bi\u0016\u0004\u0013!\u00037pO\u000e{gNZ5h+\t\t\u0019\u000b\u0005\u0003\u0002n\u0005\u0015\u0016\u0002BAT\u0003_\u0012\u0011\u0002T8h\u0007>tg-[4\u0002\u00151|wmQ8oM&<\u0007%\u0001\nd_:4G.^3oi2{wmQ8oM&<WCAAX!\u0011\ti'!-\n\t\u0005M\u0016q\u000e\u0002\u0013\u0007>tg\r\\;f]RdunZ\"p]\u001aLw-A\nd_:4G.^3oi2{wmQ8oM&<\u0007%\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0016\u0005\u0005m\u0006\u0003BA_\u0003\u0003l!!a0\u000b\u0007\u00055%(\u0003\u0003\u0002D\u0006}&A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA\u0005)1/\u001a;vaR\u0011\u00111\u001a\t\u0004\u007f\u00055\u0017bAAh\u0001\n!QK\\5uQ\rq\u00131\u001b\t\u0005\u0003+\f\u0019/\u0004\u0002\u0002X*!\u0011\u0011\\An\u0003\r\t\u0007/\u001b\u0006\u0005\u0003;\fy.A\u0004kkBLG/\u001a:\u000b\t\u0005\u0005\u0018qJ\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003K\f9N\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012|wO\u001c\u0015\u0004_\u0005-\b\u0003BAk\u0003[LA!a<\u0002X\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u001dGJ,\u0017\r^3GiB\u001c8K\\1qg\"|GOQ=uK\n+hMZ3s)\t\t)\u0010\u0005\u0003\u0002x\u0006eXBAA\u001a\u0013\u0011\tY0a\r\u0003\u0015\tKH/\u001a\"vM\u001a,'/A\u0012uKN$h\t\u001e9t':\f\u0007o\u001d5pi6\u000bG/\u001a:jC2L'0\u001a:SKN$xN]3)\u0007E\u0012\t\u0001\u0005\u0003\u0002V\n\r\u0011\u0002\u0002B\u0003\u0003/\u0014A\u0001V3ti\u0006!D/Z:u\rR\u00048o\u00158baNDw\u000e^'bi\u0016\u0014\u0018.\u00197ju\u0016\u0014(+Z:u_J,\u0017I\u001a;fe6+H/\u0019;fIN#\u0018\r^3)\u0007I\u0012\t!\u0001\u001auKN$h\t\u001e9t':\f\u0007o\u001d5pi6\u000bG/\u001a:jC2L'0\u001a:J]Z\fG.\u001b3Vg\u0016\fe\r^3s\u00072,\u0017M\\;qQ\r\u0019$\u0011A\u0001)i\u0016\u001cHO\u0012;qgNs\u0017\r]:i_Rl\u0015\r^3sS\u0006d\u0017N_3s\u0013:4\u0018\r\\5e+N\fw-\u001a\u0015\u0004i\t\u0005\u0001")
public class FtpsSnapshotMaterializerTest {
    private final boolean checksumEnabled;
    private final boolean compactEnabled;
    private final boolean cleanupEnabled;
    private final long cleanupDelayMs = Defaults$.MODULE$.TierPartitionStateCleanupDelayMs();
    private final int cleanupIntervalMs;
    private final TierPartitionStateCleanupConfig cleanupConfig = new TierPartitionStateCleanupConfig(this.cleanupEnabled(), this.cleanupDelayMs(), (long)this.cleanupIntervalMs());
    private final boolean tierPartitionStateSnapshotEnabled;
    private final Algorithm checksumAlgorithm = CheckedFileIOTestUtils$.MODULE$.checksumAlgorithm(this.checksumEnabled());
    private final short superBlockLength = CheckedFileIOTestUtils$.MODULE$.superBlockLength(this.checksumEnabled());
    private final int brokerId;
    private final TierPartitionStateFactory factory = new TierPartitionStateFactory(true, this.checksumEnabled(), this.compactEnabled(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
    private final File parentDir = TestUtils.tempDirectory(null, null);
    private final File dir = TestUtils$.MODULE$.randomPartitionForTopicLogDir(this.parentDir(), "kafka");
    private final Path snapshotsDir = this.dir().toPath().resolve("snapshots");
    private final TopicPartition tp;
    private final TopicIdPartition tpid;
    private final LogDirFailureChannel logDirFailureChannel;
    private final MockTime time;
    private final FileTierPartitionState state;
    private final LogConfig logConfig;
    private final ConfluentLogConfig confluentLogConfig;
    private final ReplicaManager replicaManager;

    public boolean checksumEnabled() {
        return this.checksumEnabled;
    }

    public boolean compactEnabled() {
        return this.compactEnabled;
    }

    public boolean cleanupEnabled() {
        return this.cleanupEnabled;
    }

    public long cleanupDelayMs() {
        return this.cleanupDelayMs;
    }

    public int cleanupIntervalMs() {
        return this.cleanupIntervalMs;
    }

    public TierPartitionStateCleanupConfig cleanupConfig() {
        return this.cleanupConfig;
    }

    public boolean tierPartitionStateSnapshotEnabled() {
        return this.tierPartitionStateSnapshotEnabled;
    }

    public Algorithm checksumAlgorithm() {
        return this.checksumAlgorithm;
    }

    public short superBlockLength() {
        return this.superBlockLength;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public TierPartitionStateFactory factory() {
        return this.factory;
    }

    public File parentDir() {
        return this.parentDir;
    }

    public File dir() {
        return this.dir;
    }

    public Path snapshotsDir() {
        return this.snapshotsDir;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public TopicIdPartition tpid() {
        return this.tpid;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public MockTime time() {
        return this.time;
    }

    public FileTierPartitionState state() {
        return this.state;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public ConfluentLogConfig confluentLogConfig() {
        return this.confluentLogConfig;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    @BeforeEach
    public void setup() {
        this.state().setTopicId(this.tpid().topicId());
        this.state().setTieredPartitionRecoveryWorkflowCb(op -> {
            TestUtils$ debug_this = TestUtils$.MODULE$;
            if (debug_this.logger().underlying().isDebugEnabled()) {
                String msgWithLogIdent_msg = FtpsSnapshotMaterializerTest.$anonfun$setup$2(this, op);
                Object var3_3 = null;
                debug_this.logger().underlying().debug(Logging.msgWithLogIdent$((Logging)debug_this, (String)msgWithLogIdent_msg));
                return;
            }
        });
        this.state().beginCatchup();
        this.state().onCatchUpComplete();
        Mockito.when((Object)this.logConfig().confluentLogConfig()).thenReturn((Object)this.confluentLogConfig());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.confluentLogConfig().tierEnable())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        TierTestUtils$.MODULE$.initTierTopicOffset();
        Mockito.when((Object)this.replicaManager().liveLogDirs()).thenReturn((Object)new .colon.colon((Object)Paths.get("/tmp/ftpsSnapshotMaterializerTest", new String[0]).toFile(), (List)Nil$.MODULE$));
    }

    @AfterEach
    public void teardown() {
        this.state().close();
        this.dir().delete();
        this.parentDir().delete();
    }

    public ByteBuffer createFtpsSnapshotByteBuffer() {
        TierTopicInitLeader initLeader = new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0);
        UUID objectId1 = UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate1 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId1, 0L, 10L, 100L, 100L, 100, false, false, false, TierUploadType.Archive, new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(3))), OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete1 = new TierSegmentUploadComplete(this.tpid(), 0, objectId1, new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(3))));
        TierSegmentDeleteInitiate deleteInitiate1 = new TierSegmentDeleteInitiate(this.tpid(), 0, objectId1, new OffsetAndEpoch(3L, Optional.of(Predef$.MODULE$.int2Integer(3))));
        TierSegmentDeleteComplete deleteComplete1 = new TierSegmentDeleteComplete(this.tpid(), 0, objectId1, new OffsetAndEpoch(3L, Optional.of(Predef$.MODULE$.int2Integer(3))), this.time().milliseconds());
        UUID objectId2 = UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate2 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId2, 10L, 20L, 100L, 100L, 100, false, false, false, TierUploadType.Archive, new OffsetAndEpoch(4L, Optional.of(Predef$.MODULE$.int2Integer(3))), OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete2 = new TierSegmentUploadComplete(this.tpid(), 0, objectId2, new OffsetAndEpoch(5L, Optional.of(Predef$.MODULE$.int2Integer(5))));
        TierSegmentDeleteInitiate deleteInitiate2 = new TierSegmentDeleteInitiate(this.tpid(), 0, objectId2, new OffsetAndEpoch(6L, Optional.of(Predef$.MODULE$.int2Integer(5))));
        TierSegmentDeleteComplete deleteComplete2 = new TierSegmentDeleteComplete(this.tpid(), 0, objectId2, new OffsetAndEpoch(6L, Optional.of(Predef$.MODULE$.int2Integer(5))), this.time().milliseconds());
        ListBuffer currentTransitions = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractTierMetadata[]{initLeader, uploadInitiate1, uploadComplete1, uploadInitiate2, uploadComplete2, deleteInitiate1, deleteComplete1, deleteInitiate2, deleteComplete2})).foreach((Function1 & Serializable)transition -> {
            Assertions.assertEquals((Object)this.state().append(transition, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()), (Object)TierPartitionState.AppendResult.ACCEPTED);
            return (ListBuffer)currentTransitions.$plus$eq(transition);
        });
        Assertions.assertTrue((boolean)this.state().flush());
        return CheckedFileIOTestUtils$.MODULE$.readAllBytes(Paths.get(this.state().flushedPath(), new String[0]));
    }

    @Test
    public void testFtpsSnapshotMaterializerRestore() {
        ByteBuffer ftpsSnapshotByteBuffer = this.createFtpsSnapshotByteBuffer();
        Option ftpsSnapshotMaterializer = Option$.MODULE$.empty();
        try {
            ftpsSnapshotMaterializer = new Some((Object)new FtpsSnapshotMaterializer(this.replicaManager().liveLogDirs().toString()));
            FileTierPartitionState materializedFtps = ((FtpsSnapshotMaterializer)ftpsSnapshotMaterializer.get()).materializeFtpsFromSnapshot(this.state().topicPartition(), this.checksumAlgorithm(), ftpsSnapshotByteBuffer, this.logDirFailureChannel(), (Scheduler)this.time().scheduler, (Time)this.time());
            List segments = CollectionConverters$.MODULE$.IteratorHasAsScala(this.state().segments()).asScala().toList();
            Set deletedSegments = CollectionConverters$.MODULE$.SetHasAsScala(TierTestUtils$.MODULE$.deletedSegments(this.state(), -1L)).asScala().toSet();
            TierTestUtils$.MODULE$.verifyFtpsEntries(materializedFtps, (List<TierLogSegment>)segments, (Set<UUID>)deletedSegments, this.cleanupEnabled(), this.time().milliseconds());
        }
        finally {
            ftpsSnapshotMaterializer.foreach((Function1 & Serializable)x$1 -> {
                x$1.cleanup();
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testFtpsSnapshotMaterializerRestoreAfterMutatedState() {
        Option ftpsSnapshotMaterializer = Option$.MODULE$.empty();
        try {
            ftpsSnapshotMaterializer = new Some((Object)new FtpsSnapshotMaterializer(this.replicaManager().liveLogDirs().toString()));
            FileTierPartitionState materializedFtps = ((FtpsSnapshotMaterializer)ftpsSnapshotMaterializer.get()).materializeFtpsFromSnapshot(this.state().topicPartition(), this.checksumAlgorithm(), this.createFtpsSnapshotByteBuffer(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler, (Time)this.time());
            List segments = CollectionConverters$.MODULE$.IteratorHasAsScala(this.state().segments()).asScala().toList();
            Set deletedSegments = CollectionConverters$.MODULE$.SetHasAsScala(TierTestUtils$.MODULE$.deletedSegments(this.state(), -1L)).asScala().toSet();
            UUID objectId3 = UUID.randomUUID();
            TierSegmentUploadInitiate uploadInitiate3 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId3, 21L, 30L, 100L, 100L, 100, false, false, false, TierUploadType.Archive, new OffsetAndEpoch(9L, Optional.of(Predef$.MODULE$.int2Integer(3))), OpaqueData.ZEROED);
            TierSegmentUploadComplete uploadComplete3 = new TierSegmentUploadComplete(this.tpid(), 0, objectId3, new OffsetAndEpoch(10L, Optional.of(Predef$.MODULE$.int2Integer(5))));
            new .colon.colon((Object)uploadInitiate3, (List)new .colon.colon((Object)uploadComplete3, (List)Nil$.MODULE$)).foreach((Function1 & Serializable)transition -> {
                FtpsSnapshotMaterializerTest.$anonfun$testFtpsSnapshotMaterializerRestoreAfterMutatedState$1(this, transition);
                return BoxedUnit.UNIT;
            });
            Assertions.assertTrue((boolean)this.state().flush());
            Assertions.assertEquals((Object)this.state().status(), (Object)TierPartitionStatus.ONLINE);
            TierTestUtils$.MODULE$.verifyFtpsEntries(materializedFtps, (List<TierLogSegment>)segments, (Set<UUID>)deletedSegments, this.cleanupEnabled(), this.time().milliseconds());
        }
        finally {
            ftpsSnapshotMaterializer.foreach((Function1 & Serializable)x$2 -> {
                x$2.cleanup();
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testFtpsSnapshotMaterializerInvalidUseAfterCleanup() {
        ByteBuffer ftpsSnapshotByteBuffer = this.createFtpsSnapshotByteBuffer();
        ObjectRef ftpsSnapshotMaterializer = ObjectRef.create((Object)Option$.MODULE$.empty());
        try {
            ftpsSnapshotMaterializer.elem = new Some((Object)new FtpsSnapshotMaterializer(this.replicaManager().liveLogDirs().toString()));
            FileTierPartitionState materializedFtps = ((FtpsSnapshotMaterializer)((Option)ftpsSnapshotMaterializer.elem).get()).materializeFtpsFromSnapshot(this.state().topicPartition(), this.checksumAlgorithm(), ftpsSnapshotByteBuffer, this.logDirFailureChannel(), (Scheduler)this.time().scheduler, (Time)this.time());
            List segments = CollectionConverters$.MODULE$.IteratorHasAsScala(this.state().segments()).asScala().toList();
            Set deletedSegments = CollectionConverters$.MODULE$.SetHasAsScala(TierTestUtils$.MODULE$.deletedSegments(this.state(), -1L)).asScala().toSet();
            TierTestUtils$.MODULE$.verifyFtpsEntries(materializedFtps, (List<TierLogSegment>)segments, (Set<UUID>)deletedSegments, this.cleanupEnabled(), this.time().milliseconds());
            Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> ((FtpsSnapshotMaterializer)((Option)ftpsSnapshotMaterializer$1.elem).get()).materializeFtpsFromSnapshot(this.state().topicPartition(), this.checksumAlgorithm(), ftpsSnapshotByteBuffer, this.logDirFailureChannel(), (Scheduler)$this.time().scheduler, (Time)this.time()), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("FtpsSnapshotMaterializerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
        }
        finally {
            ((Option)ftpsSnapshotMaterializer.elem).foreach((Function1 & Serializable)x$3 -> {
                x$3.cleanup();
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testFtpsSnapshotMaterializerInvalidUsage() {
        ByteBuffer ftpsSnapshotByteBuffer = this.createFtpsSnapshotByteBuffer();
        ObjectRef ftpsSnapshotMaterializer = ObjectRef.create((Object)Option$.MODULE$.empty());
        try {
            ftpsSnapshotMaterializer.elem = new Some((Object)new FtpsSnapshotMaterializer(this.replicaManager().liveLogDirs().toString()));
            FileTierPartitionState materializedFtps = ((FtpsSnapshotMaterializer)((Option)ftpsSnapshotMaterializer.elem).get()).materializeFtpsFromSnapshot(this.state().topicPartition(), this.checksumAlgorithm(), ftpsSnapshotByteBuffer, this.logDirFailureChannel(), (Scheduler)this.time().scheduler, (Time)this.time());
            List segments = CollectionConverters$.MODULE$.IteratorHasAsScala(this.state().segments()).asScala().toList();
            Set deletedSegments = CollectionConverters$.MODULE$.SetHasAsScala(TierTestUtils$.MODULE$.deletedSegments(this.state(), -1L)).asScala().toSet();
            TierTestUtils$.MODULE$.verifyFtpsEntries(materializedFtps, (List<TierLogSegment>)segments, (Set<UUID>)deletedSegments, this.cleanupEnabled(), this.time().milliseconds());
            Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> ((FtpsSnapshotMaterializer)((Option)ftpsSnapshotMaterializer$2.elem).get()).materializeFtpsFromSnapshot(this.state().topicPartition(), this.checksumAlgorithm(), ftpsSnapshotByteBuffer, this.logDirFailureChannel(), (Scheduler)$this.time().scheduler, (Time)this.time()), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("FtpsSnapshotMaterializerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        }
        finally {
            ((Option)ftpsSnapshotMaterializer.elem).foreach((Function1 & Serializable)x$4 -> {
                x$4.cleanup();
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ String $anonfun$setup$2(FtpsSnapshotMaterializerTest $this, TierPartitionState.RecoveryOperation op$1) {
        return new StringBuilder(26).append("Received RecoveryOp: ").append(op$1).append(" for ").append($this.state().topicIdPartition().get()).toString();
    }

    public static final /* synthetic */ void $anonfun$testFtpsSnapshotMaterializerRestoreAfterMutatedState$1(FtpsSnapshotMaterializerTest $this, AbstractTierSegmentMetadata transition) {
        Assertions.assertEquals((Object)$this.state().append((AbstractTierMetadata)transition, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()), (Object)TierPartitionState.AppendResult.ACCEPTED);
    }

    public FtpsSnapshotMaterializerTest() {
        this.checksumEnabled = true;
        this.compactEnabled = true;
        this.cleanupEnabled = true;
        this.cleanupIntervalMs = 0;
        this.tierPartitionStateSnapshotEnabled = false;
        this.brokerId = 0;
        File parseTopicPartitionName_dir = this.dir();
        Object var1_1 = null;
        this.tp = LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir);
        this.tpid = new TopicIdPartition(this.tp().topic(), UUID.randomUUID(), this.tp().partition());
        this.logDirFailureChannel = new LogDirFailureChannel(5);
        this.time = new MockTime();
        this.state = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler, this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        this.logConfig = (LogConfig)Mockito.mock(LogConfig.class);
        this.confluentLogConfig = (ConfluentLogConfig)Mockito.mock(ConfluentLogConfig.class);
        this.replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    }
}

