/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.snapshot;

import io.confluent.kafka.storage.checksum.Algorithm;
import io.confluent.kafka.storage.checksum.CheckedFileIO;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.log.AbstractLog;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.state.BaseTierStateTest;
import kafka.tier.state.FileTierPartitionIterator;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.FileTierPartitionStateSnapshotObject;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;
import kafka.tier.store.objects.metadata.TierPartitionStateSnapshotMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0005\u0005Mf\u0001B\u0007\u000f\u0001UAQ\u0001\b\u0001\u0005\u0002uAq\u0001\t\u0001C\u0002\u0013E\u0011\u0005\u0003\u0004/\u0001\u0001\u0006IA\t\u0005\b_\u0001\u0011\r\u0011\"\u00011\u0011\u00199\u0004\u0001)A\u0005c!)\u0001\b\u0001C!s!)q\n\u0001C\u0001!\")Q\u000f\u0001C\u0005m\"9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0001bBA\u0010\u0001\u0011%\u0011\u0011\u0005\u0005\b\u0003\u001b\u0002A\u0011CA(\u0011\u001d\t)\n\u0001C\t\u0003/\u0013a\u0004V5feB\u000b'\u000f^5uS>t7\u000b^1uKNs\u0017\r]:i_R$Vm\u001d;\u000b\u0005=\u0001\u0012\u0001C:oCB\u001c\bn\u001c;\u000b\u0005E\u0011\u0012\u0001\u0002;jKJT\u0011aE\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\u0003\u0005\u0002\u001855\t\u0001D\u0003\u0002\u001a!\u0005)1\u000f^1uK&\u00111\u0004\u0007\u0002\u0012\u0005\u0006\u001cX\rV5feN#\u0018\r^3UKN$\u0018A\u0002\u001fj]&$h\bF\u0001\u001f!\ty\u0002!D\u0001\u000f\u0003\u0019)\u00070\u001b;fIV\t!\u0005\u0005\u0002$Y5\tAE\u0003\u0002&M\u00051\u0011\r^8nS\u000eT!a\n\u0015\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002*U\u0005!Q\u000f^5m\u0015\u0005Y\u0013\u0001\u00026bm\u0006L!!\f\u0013\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003\u001d)\u00070\u001b;fI\u0002\nQB\\;n!\u0006\u0014H/\u001b;j_:\u001cX#A\u0019\u0011\u0005I*T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\u0007%sG/\u0001\bok6\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002\u000bM,G/\u00169\u0015\u0005ij\u0004C\u0001\u001a<\u0013\ta4G\u0001\u0003V]&$\b\"\u0002 \u0007\u0001\u0004y\u0014\u0001\u0003;fgRLeNZ8\u0011\u0005\u0001KU\"A!\u000b\u0005\t\u001b\u0015aA1qS*\u0011A)R\u0001\bUV\u0004\u0018\u000e^3s\u0015\t1u)A\u0003kk:LGOC\u0001I\u0003\ry'oZ\u0005\u0003\u0015\u0006\u0013\u0001\u0002V3ti&sgm\u001c\u0015\u0003\r1\u0003\"\u0001Q'\n\u00059\u000b%A\u0003\"fM>\u0014X-R1dQ\u0006qB/Z:u)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$Xm\u00158baNDw\u000e\u001e\u000b\u0003uECQAU\u0004A\u0002M\u000ba!];peVl\u0007C\u0001+\\\u001d\t)\u0016\f\u0005\u0002Wg5\tqK\u0003\u0002Y)\u00051AH]8pizJ!AW\u001a\u0002\rA\u0013X\rZ3g\u0013\taVL\u0001\u0004TiJLgn\u001a\u0006\u00035NBCaB0fMB\u0011\u0001mY\u0007\u0002C*\u0011!mQ\u0001\u0007a\u0006\u0014\u0018-\\:\n\u0005\u0011\f'!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006!a.Y7fC\u00059\u0017AI>eSN\u0004H.Y=OC6,WPL>be\u001e,X.\u001a8ug^KG\u000f\u001b(b[\u0016\u001cX\u0010\u000b\u0003\bS>\u0004\bC\u00016n\u001b\u0005Y'B\u00017b\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018B\u00018l\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\u0012\u0011o]\u0011\u0002e\u0006\u0011!p[\u0011\u0002i\u0006)1N]1gi\u0006!3m\\7qCJ,7K\\1qg\"|G/\u00118e\r2,8\u000f[3e\rR\u00036+\u00128ue&,7\u000f\u0006\u0003;o\u00065\u0001\"\u0002=\t\u0001\u0004I\u0018a\u00044uaN4\u0015\u000e\\3DQ\u0006tg.\u001a7\u0011\u0007i\fI!D\u0001|\u0015\taX0\u0001\u0005dQ\u0016\u001c7n];n\u0015\tqx0A\u0004ti>\u0014\u0018mZ3\u000b\u0007M\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011!C2p]\u001adW/\u001a8u\u0015\t\t9!\u0001\u0002j_&\u0019\u00111B>\u0003\u001b\rCWmY6fI\u001aKG.Z%P\u0011\u0019\ty\u0001\u0003a\u0001s\u0006\u00192O\\1qg\"|GOR5mK\u000eC\u0017M\u001c8fY\u0006\u0011B/[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f)\u0011\t)\"a\u0007\u0011\u0007]\t9\"C\u0002\u0002\u001aa\u0011!\u0003V5feB\u000b'\u000f^5uS>t7\u000b^1uK\"1\u0011QD\u0005A\u0002E\n\u0001\u0002\\3bI\u0016\u0014\u0018\nZ\u0001\u0007O\u0016$Hj\\4\u0015\r\u0005\r\u0012QGA\u001c!\u0015\u0011\u0014QEA\u0015\u0013\r\t9c\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005-\u0012\u0011G\u0007\u0003\u0003[Q1!a\f\u0013\u0003\rawnZ\u0005\u0005\u0003g\tiCA\u0006BEN$(/Y2u\u0019><\u0007BBA\u000f\u0015\u0001\u0007\u0011\u0007C\u0004\u0002:)\u0001\r!a\u000f\u0002\u0005Q\u0004\b\u0003BA\u001f\u0003\u0013j!!a\u0010\u000b\t\u0005\u0005\u00131I\u0001\u0007G>lWn\u001c8\u000b\u0007M\t)EC\u0002\u0002H\u001d\u000ba!\u00199bG\",\u0017\u0002BA&\u0003\u007f\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\re_^tGn\\1e\rR\u00036k\u00158baNDw\u000e\u001e\"m_\n$B\"!\u0015\u0002b\u0005E\u0014QPAD\u0003\u0017\u0003B!a\u0015\u0002^5\u0011\u0011Q\u000b\u0006\u0005\u0003/\nI&\u0001\u0003gS2,'bAA.U\u0005\u0019a.[8\n\t\u0005}\u0013Q\u000b\u0002\u0005!\u0006$\b\u000eC\u0004\u0002d-\u0001\r!!\u001a\u0002\u0011=\u0014'n\u0015;pe\u0016\u0004B!a\u001a\u0002n5\u0011\u0011\u0011\u000e\u0006\u0004\u0003W\u0002\u0012!B:u_J,\u0017\u0002BA8\u0003S\u0012q\u0002V5fe>\u0013'.Z2u'R|'/\u001a\u0005\b\u0003gZ\u0001\u0019AA;\u0003A!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0002x\u0005eT\"\u0001\t\n\u0007\u0005m\u0004C\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]\"9\u0011qP\u0006A\u0002\u0005\u0005\u0015AD:oCB\u001c\bn\u001c;PE*,7\r\u001e\t\u0004/\u0005\r\u0015bAAC1\t!c)\u001b7f)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$Xm\u00158baNDw\u000e^(cU\u0016\u001cG\u000f\u0003\u0004\u0002\n.\u0001\raU\u0001\u0013I><h\u000e\\8bI\u0016$g)\u001b7f\u001d\u0006lW\rC\u0004\u0002\u000e.\u0001\r!a$\u0002\u0013\u0005dwm\u001c:ji\"l\u0007c\u0001>\u0002\u0012&\u0019\u00111S>\u0003\u0013\u0005cwm\u001c:ji\"l\u0017A\b;jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016\u001cf.\u00199tQ>$h*Y7f)!\tI*a'\u0002\u001e\u0006\u0005\u0006\u0003\u0002\u001a\u0002&MCq!a\u001b\r\u0001\u0004\t)\u0007\u0003\u0004\u0002 2\u0001\raU\u0001\bi>\u0004\u0018nY%e\u0011\u0019\t\u0019\u000b\u0004a\u0001'\u0006Q1O\\1qg\"|G/\u00133)\u000f\u0001\t9+!,\u00020B\u0019\u0001)!+\n\u0007\u0005-\u0016IA\u0002UC\u001e\fQA^1mk\u0016\f#!!-\u0002\u0017%tG/Z4sCRLwN\u001c")
public class TierPartitionStateSnapshotTest
extends BaseTierStateTest {
    private final AtomicBoolean exited = new AtomicBoolean(false);
    private final int numPartitions;

    public AtomicBoolean exited() {
        return this.exited;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        Exit.setExitProcedure((x$1, x$2) -> this.exited().set(true));
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), "mybucket");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateMetadataSnapshotsEnableProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierTopicDeleteCheckIntervalMsProp(), "5");
        this.serverConfig().put("confluent.checksum.enabled.files", "tierstate");
        super.setUp(testInfo);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTierPartitionStateSnapshot(String quorum) {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "4096");
        props.put("confluent.tier.local.hotset.ms", "1");
        int leaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(this.topicName(), this.numPartitions(), 1, props, this.createTopic$default$5(), this.createTopic$default$6()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(this.topicPartition());
        TopicIdPartition topicIdPartition = (TopicIdPartition)((AbstractLog)this.getLog(leaderId, this.topicPartition()).get()).topicIdPartition().get();
        Uuid topicId = topicIdPartition.kafkaTopicId();
        this.appendMessagesToLeaderAndWaitUntilTiered(leaderId, 2);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierPartitionStateSnapshotTest.$anonfun$testTierPartitionStateSnapshot$1(this, leaderId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Timed out waiting for the first FTPS snapshot to be taken");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        UUID snapshotId = this.tierPartitionState(leaderId).lastSnapshotId();
        Predef$.MODULE$.assert(this.tierPartitionState(leaderId).lastSnapshotId() != null, (Function0 & Serializable)() -> "FTPS header should have recorded the timestamp for last snapshot");
        TierObjectStore objStore = (TierObjectStore)((KafkaBroker)this.brokerForId(leaderId).get()).tierObjectStoreOpt().get();
        Option<String> snapshotFullName = this.tierPartitionStateSnapshotName(objStore, topicId.toString(), snapshotId.toString());
        Predef$.MODULE$.assert(snapshotFullName.isDefined(), (Function0 & Serializable)() -> "Snapshot file not present at the object store");
        String snapshotName = (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])((String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])((String)snapshotFullName.get()).split("/")))).split(new StringBuilder(4).append("_v0.").append(ObjectType.TIER_PARTITION_STATE_METADATA_SNAPSHOT.suffix()).toString())));
        FileTierPartitionStateSnapshotObject snapshotObject = FileTierPartitionStateSnapshotObject.decodeSnapshotName((String)snapshotName);
        Path downloadedSnapshotFilePath = this.downloadFTPSSnapshotBlob(objStore, topicIdPartition, snapshotObject, snapshotName, Algorithm.ADLER);
        String ftpsFileName = (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])this.tierPartitionState(leaderId).dir().list()), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)TierPartitionStateSnapshotTest.$anonfun$testTierPartitionStateSnapshot$5(f)))));
        CheckedFileIO ftpsFileChannel = CheckedFileIO.open((Path)Paths.get(this.tierPartitionState(leaderId).dir().getAbsolutePath(), ftpsFileName), (OpenOption[])new OpenOption[]{StandardOpenOption.READ});
        CheckedFileIO snapshotFileChannel = CheckedFileIO.open((Path)downloadedSnapshotFilePath, (OpenOption[])new OpenOption[]{StandardOpenOption.READ});
        this.compareSnapshotAndFlushedFTPSEntries(ftpsFileChannel, snapshotFileChannel);
        Assertions.assertTrue((boolean)ftpsFileChannel.validate(), (String)"FTPS file has invalid checksum");
        Assertions.assertTrue((boolean)snapshotFileChannel.validate(), (String)"Snapshot file has invalid checksum");
        ftpsFileChannel.close();
        snapshotFileChannel.close();
        Files.deleteIfExists(downloadedSnapshotFilePath);
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierPartitionStateSnapshotTest.$anonfun$testTierPartitionStateSnapshot$6(this, leaderId)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"Timed out waiting for snapshot Id to be committed");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        this.deleteTopic(this.topicName(), this.deleteTopic$default$2());
        String snapshotPrefix = new StringBuilder(4).append(TierObjectStore.DataTypePathPrefix.TIER_PARTITION_STATE_METADATA_SNAPSHOT.prefix()).append("/").append(topicId).append("/0/").toString();
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 30000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!TierPartitionStateSnapshotTest.$anonfun$testTierPartitionStateSnapshot$8(objStore, snapshotPrefix)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Timed out waiting for snapshots to be deleted");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
    }

    private void compareSnapshotAndFlushedFTPSEntries(CheckedFileIO ftpsFileChannel, CheckedFileIO snapshotFileChannel) {
        Optional ftpsFileIteratorOpt = FileTierPartitionState.iterator((TopicPartition)this.topicPartition(), (CheckedFileIO)ftpsFileChannel);
        Predef$.MODULE$.assert(ftpsFileIteratorOpt.isPresent());
        FileTierPartitionIterator ftpsFileIterator = (FileTierPartitionIterator)ftpsFileIteratorOpt.get();
        Optional snapshotFileIteratorOpt = FileTierPartitionState.iterator((TopicPartition)this.topicPartition(), (CheckedFileIO)snapshotFileChannel);
        Predef$.MODULE$.assert(snapshotFileIteratorOpt.isPresent());
        FileTierPartitionIterator snapshotFileIterator = (FileTierPartitionIterator)snapshotFileIteratorOpt.get();
        int count = 0;
        while (ftpsFileIterator.hasNext() && snapshotFileIterator.hasNext()) {
            TierObjectMetadata ftpsFileObjectMetadata = (TierObjectMetadata)ftpsFileIterator.next();
            TierObjectMetadata snapshotFileObjectMetadata = (TierObjectMetadata)snapshotFileIterator.next();
            boolean entriesAreSame = ftpsFileObjectMetadata.equals((Object)snapshotFileObjectMetadata);
            ++count;
            Predef$.MODULE$.assert(TierPartitionStateSnapshotTest.entriesMatched$1(entriesAreSame, snapshotFileIterator, ftpsFileObjectMetadata, snapshotFileObjectMetadata), (Function0 & Serializable)() -> new StringBuilder(88).append("Mismatch between tier metadata entries.\n").append("Entry at mutable file: ").append(ftpsFileObjectMetadata.toString()).append("\n").append("Entry at FTPS snapshot: ").append(snapshotFileObjectMetadata.toString()).toString());
        }
        System.out.println(new StringBuilder(27).append("Number of entries matched: ").append(count).toString());
    }

    public TierPartitionState tierPartitionState(int leaderId) {
        return ((AbstractLog)this.getLog(leaderId, this.topicPartition()).get()).tierPartitionState();
    }

    private Option<AbstractLog> getLog(int leaderId, TopicPartition tp) {
        return ((KafkaBroker)this.brokerForId(leaderId).get()).replicaManager().getLog(tp);
    }

    public Path downloadFTPSSnapshotBlob(TierObjectStore objStore, TopicIdPartition topicIdPartition, FileTierPartitionStateSnapshotObject snapshotObject, String downloadedFileName, Algorithm algorithm) {
        TierPartitionStateSnapshotMetadata metadata = new TierPartitionStateSnapshotMetadata(topicIdPartition, snapshotObject);
        InputStream stream = null;
        Path downloadedFtpsPath = TestUtils.tempFile((String)((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(downloadedFileName), '.')))), (String)new StringBuilder(19).append(".tierstate.snapshot").append(algorithm.suffix).toString()).toPath();
        try {
            try {
                stream = objStore.getObjectStoreFragment((ObjectStoreMetadata)metadata, FragmentType.TIER_PARTITION_STATE_METADATA_SNAPSHOT).getInputStream();
                Files.copy(stream, downloadedFtpsPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception exception) {
                Files.deleteIfExists(downloadedFtpsPath);
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        return downloadedFtpsPath;
    }

    public Option<String> tierPartitionStateSnapshotName(TierObjectStore store, String topicId, String snapshotId) {
        String snapshotPrefix = new StringBuilder(4).append(TierObjectStore.DataTypePathPrefix.TIER_PARTITION_STATE_METADATA_SNAPSHOT.prefix()).append("/").append(topicId).append("/0/").append(snapshotId).toString();
        None$ snapshotName = None$.MODULE$;
        Iterator iter = store.listObject(snapshotPrefix, false).keySet().iterator();
        if (iter.hasNext()) {
            snapshotName = new Some(iter.next());
        }
        return snapshotName;
    }

    public static final /* synthetic */ boolean $anonfun$testTierPartitionStateSnapshot$1(TierPartitionStateSnapshotTest $this, int leaderId$1) {
        return $this.tierPartitionState(leaderId$1).lastSnapshotTimestampMs() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testTierPartitionStateSnapshot$2() {
        return "Timed out waiting for the first FTPS snapshot to be taken";
    }

    public static final /* synthetic */ boolean $anonfun$testTierPartitionStateSnapshot$5(String f) {
        return f.contains("tierstate") && f.contains("mutable");
    }

    public static final /* synthetic */ boolean $anonfun$testTierPartitionStateSnapshot$6(TierPartitionStateSnapshotTest $this, int leaderId$1) {
        return $this.tierPartitionState(leaderId$1).lastCommittedSnapshotId() != null;
    }

    public static final /* synthetic */ String $anonfun$testTierPartitionStateSnapshot$7() {
        return "Timed out waiting for snapshot Id to be committed";
    }

    public static final /* synthetic */ boolean $anonfun$testTierPartitionStateSnapshot$8(TierObjectStore objStore$1, String snapshotPrefix$1) {
        return objStore$1.listObject(snapshotPrefix$1, false).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testTierPartitionStateSnapshot$9() {
        return "Timed out waiting for snapshots to be deleted";
    }

    private static final boolean entriesMatched$1(boolean entriesAreSame, FileTierPartitionIterator snapshotFileIterator, TierObjectMetadata ftpsFileObjectMetadata, TierObjectMetadata snapshotFileObjectMetadata) {
        if (entriesAreSame) {
            return true;
        }
        if (snapshotFileIterator.hasNext()) {
            return false;
        }
        if (ftpsFileObjectMetadata.objectId().equals(snapshotFileObjectMetadata.objectId()) && ftpsFileObjectMetadata.baseOffset() == snapshotFileObjectMetadata.baseOffset() && ftpsFileObjectMetadata.endOffset() == snapshotFileObjectMetadata.endOffset()) {
            TierObjectMetadata.State state = ftpsFileObjectMetadata.state();
            TierObjectMetadata.State state2 = snapshotFileObjectMetadata.state();
            if (state == null ? state2 != null : !state.equals(state2)) {
                return true;
            }
        }
        return false;
    }

    public TierPartitionStateSnapshotTest() {
        this.numPartitions = 1;
    }
}

