/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.snapshot;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kafka.cluster.Partition;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.tier.snapshot.TierTopicSnapshotCoordinator;
import kafka.tier.snapshot.TierTopicSnapshotCoordinator$;
import kafka.tier.store.TierObjectStore;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dd\u0001B\u000e\u001d\u0001\rBQA\u000b\u0001\u0005\u0002-BqA\f\u0001C\u0002\u0013\u0005q\u0006\u0003\u00049\u0001\u0001\u0006I\u0001\r\u0005\ns\u0001\u0001\r\u00111A\u0005\u0002iB\u0011\"\u0011\u0001A\u0002\u0003\u0007I\u0011\u0001\"\t\u0013!\u0003\u0001\u0019!A!B\u0013Y\u0004bB%\u0001\u0005\u0004%\tA\u0013\u0005\u0007\u001d\u0002\u0001\u000b\u0011B&\t\u000f=\u0003!\u0019!C\u0001!\"1!\f\u0001Q\u0001\nECqa\u0017\u0001C\u0002\u0013\u0005A\f\u0003\u0004k\u0001\u0001\u0006I!\u0018\u0005\bW\u0002\u0011\r\u0011\"\u0001m\u0011\u0019\u0011\b\u0001)A\u0005[\"91\u000f\u0001b\u0001\n\u0003!\bBB>\u0001A\u0003%Q\u000fC\u0004}\u0001\t\u0007I\u0011A?\t\u000f\u0005M\u0001\u0001)A\u0005}\"I\u0011Q\u0003\u0001C\u0002\u0013\u0005\u0011q\u0003\u0005\t\u0003W\u0001\u0001\u0015!\u0003\u0002\u001a!I\u0011Q\u0006\u0001C\u0002\u0013\u0005\u0011q\u0006\u0005\t\u0003s\u0001\u0001\u0015!\u0003\u00022!9\u00111\b\u0001\u0005\u0002\u0005u\u0002bBA+\u0001\u0011\u0005\u0011Q\b\u0005\b\u0003?\u0002A\u0011AA\u001f\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003{\u0011\u0001\u0005V5feR{\u0007/[2T]\u0006\u00048\u000f[8u\u0007>|'\u000fZ5oCR|'\u000fV3ti*\u0011QDH\u0001\tg:\f\u0007o\u001d5pi*\u0011q\u0004I\u0001\u0005i&,'OC\u0001\"\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0013\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tA\u0006\u0005\u0002.\u00015\tA$A\u0003qe>\u00048/F\u00011!\t\td'D\u00013\u0015\t\u0019D'\u0001\u0003vi&d'\"A\u001b\u0002\t)\fg/Y\u0005\u0003oI\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0003\u0019\u0001(o\u001c9tA\u000511m\u001c8gS\u001e,\u0012a\u000f\t\u0003y}j\u0011!\u0010\u0006\u0003}\u0001\naa]3sm\u0016\u0014\u0018B\u0001!>\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0015\r|gNZ5h?\u0012*\u0017\u000f\u0006\u0002D\rB\u0011Q\u0005R\u0005\u0003\u000b\u001a\u0012A!\u00168ji\"9q)BA\u0001\u0002\u0004Y\u0014a\u0001=%c\u000591m\u001c8gS\u001e\u0004\u0013A\u0004:fa2L7-Y'b]\u0006<WM]\u000b\u0002\u0017B\u0011A\bT\u0005\u0003\u001bv\u0012aBU3qY&\u001c\u0017-T1oC\u001e,'/A\bsKBd\u0017nY1NC:\fw-\u001a:!\u0003I!\u0018.\u001a:PE*,7\r^*u_J,w\n\u001d;\u0016\u0003E\u00032!\n*U\u0013\t\u0019fE\u0001\u0004PaRLwN\u001c\t\u0003+bk\u0011A\u0016\u0006\u0003/z\tQa\u001d;pe\u0016L!!\u0017,\u0003\u001fQKWM](cU\u0016\u001cGo\u0015;pe\u0016\f1\u0003^5fe>\u0013'.Z2u'R|'/Z(qi\u0002\nA\u0001^5nKV\tQ\f\u0005\u0002_Q6\tqL\u0003\u0002aC\u0006)Q\u000f^5mg*\u0011!mY\u0001\u0007G>lWn\u001c8\u000b\u0005\u0005\"'BA3g\u0003\u0019\t\u0007/Y2iK*\tq-A\u0002pe\u001eL!![0\u0003\tQKW.Z\u0001\u0006i&lW\rI\u0001\b[\u0016$(/[2t+\u0005i\u0007C\u00018q\u001b\u0005y'BA6b\u0013\t\txNA\u0004NKR\u0014\u0018nY:\u0002\u00115,GO]5dg\u0002\n\u0011\u0002]1si&$\u0018n\u001c8\u0016\u0003U\u0004\"A^=\u000e\u0003]T!\u0001\u001f\u0011\u0002\u000f\rdWo\u001d;fe&\u0011!p\u001e\u0002\n!\u0006\u0014H/\u001b;j_:\f!\u0002]1si&$\u0018n\u001c8!\u0003%\u0019G.^:uKJLE-F\u0001\u007f!\ry\u0018Q\u0002\b\u0005\u0003\u0003\tI\u0001E\u0002\u0002\u0004\u0019j!!!\u0002\u000b\u0007\u0005\u001d!%\u0001\u0004=e>|GOP\u0005\u0004\u0003\u00171\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0010\u0005E!AB*ue&twMC\u0002\u0002\f\u0019\n!b\u00197vgR,'/\u00133!\u0003\u0001Jg\u000e^3s\u0005J|7.\u001a:DY&,g\u000e^\"p]\u001aLwm]*vaBd\u0017.\u001a:\u0016\u0005\u0005e\u0001CB\u0019\u0002\u001cy\fy\"C\u0002\u0002\u001eI\u00121!T1q!\u0011\t\t#a\n\u000e\u0005\u0005\r\"bAA\u0013i\u0005!A.\u00198h\u0013\u0011\tI#a\t\u0003\r=\u0013'.Z2u\u0003\u0005Jg\u000e^3s\u0005J|7.\u001a:DY&,g\u000e^\"p]\u001aLwm]*vaBd\u0017.\u001a:!\u0003\t!\b/\u0006\u0002\u00022A!\u00111GA\u001b\u001b\u0005\t\u0017bAA\u001cC\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0001;qA\u0005)1/\u001a;VaR\t1\tK\u0002\u0018\u0003\u0003\u0002B!a\u0011\u0002R5\u0011\u0011Q\t\u0006\u0005\u0003\u000f\nI%A\u0002ba&TA!a\u0013\u0002N\u00059!.\u001e9ji\u0016\u0014(bAA(M\u0006)!.\u001e8ji&!\u00111KA#\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u001di\u0016\u001cHo\u00148FY\u0016\u001cG/[8o\u0003:$'+Z:jO:\fG/[8oQ\rA\u0012\u0011\f\t\u0005\u0003\u0007\nY&\u0003\u0003\u0002^\u0005\u0015#\u0001\u0002+fgR\fA\u0006^3ti\u001a{G\u000e\\8xKJtu.Q2uS>twJ\\#mK\u000e$\u0018n\u001c8B]\u0012\u0014Vm]5h]\u0006$\u0018n\u001c8)\u0007e\tI&A\buKN$(+Z2p]\u001aLw-\u001e:fQ\rQ\u0012\u0011\f")
public class TierTopicSnapshotCoordinatorTest {
    private final Properties props;
    private KafkaConfig config;
    private final ReplicaManager replicaManager;
    private final Option<TierObjectStore> tierObjectStoreOpt;
    private final Time time;
    private final Metrics metrics;
    private final Partition partition;
    private final String clusterId;
    private final Map<String, Object> interBrokerClientConfigsSupplier;
    private final TopicPartition tp;

    public Properties props() {
        return this.props;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public Option<TierObjectStore> tierObjectStoreOpt() {
        return this.tierObjectStoreOpt;
    }

    public Time time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public Partition partition() {
        return this.partition;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public Map<String, Object> interBrokerClientConfigsSupplier() {
        return this.interBrokerClientConfigsSupplier;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    @BeforeEach
    public void setUp() {
        this.props().setProperty(KafkaConfig$.MODULE$.TierFeatureProp(), Boolean.toString(true));
        this.props().setProperty(KafkaConfig$.MODULE$.TierTopicSnapshotsEnableProp(), Boolean.toString(true));
        this.interBrokerClientConfigsSupplier().put("bootstrap.servers", "localhost:80");
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(this.props()));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.partition().isLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(this.tp())).thenReturn((Object)package$.MODULE$.Right().apply((Object)this.partition()));
    }

    @Test
    public void testOnElectionAndResignation() {
        TierTopicSnapshotCoordinator coordinator = new TierTopicSnapshotCoordinator(this){

            public int localReplicaEpochIfLeader(int partition) {
                return 1;
            }
        };
        Assertions.assertTrue((boolean)coordinator.tierTopicSnapshotManager().isEmpty());
        coordinator.onElection(TierTopicSnapshotCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE() - 1);
        Assertions.assertTrue((boolean)coordinator.tierTopicSnapshotManager().isEmpty());
        coordinator.onElection(TierTopicSnapshotCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE());
        Assertions.assertTrue((boolean)coordinator.tierTopicSnapshotManager().isDefined());
        coordinator.onElection(TierTopicSnapshotCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE());
        Assertions.assertTrue((boolean)coordinator.tierTopicSnapshotManager().isDefined());
        coordinator.onResignation(TierTopicSnapshotCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE() - 1);
        Assertions.assertTrue((boolean)coordinator.tierTopicSnapshotManager().isDefined());
        coordinator.onResignation(TierTopicSnapshotCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE());
        Assertions.assertTrue((boolean)coordinator.tierTopicSnapshotManager().isEmpty());
    }

    @Test
    public void testFollowerNoActionOnElectionAndResignation() {
        TierTopicSnapshotCoordinator coordinator = new TierTopicSnapshotCoordinator(this){

            public int localReplicaEpochIfLeader(int partition) {
                return -1;
            }
        };
        Assertions.assertTrue((boolean)coordinator.tierTopicSnapshotManager().isEmpty());
        coordinator.onElection(TierTopicSnapshotCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE());
        Assertions.assertTrue((boolean)coordinator.tierTopicSnapshotManager().isEmpty());
        coordinator.onResignation(TierTopicSnapshotCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE());
        Assertions.assertTrue((boolean)coordinator.tierTopicSnapshotManager().isEmpty());
    }

    @Test
    public void testReconfigure() {
        this.props().setProperty(KafkaConfig$.MODULE$.TierTopicSnapshotsEnableProp(), Boolean.toString(true));
        KafkaConfig configEnabled = KafkaConfig$.MODULE$.fromProps(this.props());
        this.props().setProperty(KafkaConfig$.MODULE$.TierTopicSnapshotsEnableProp(), Boolean.toString(false));
        KafkaConfig configDisabled = KafkaConfig$.MODULE$.fromProps(this.props());
        TierTopicSnapshotCoordinator coordinator = new TierTopicSnapshotCoordinator(this){

            public int localReplicaEpochIfLeader(int partition) {
                return 1;
            }
        };
        Assertions.assertTrue((boolean)coordinator.tierTopicSnapshotManager().isEmpty());
        coordinator.reconfigure(configDisabled, configEnabled);
        Assertions.assertTrue((boolean)coordinator.tierTopicSnapshotManager().isDefined());
        coordinator.reconfigure(configEnabled, configEnabled);
        Assertions.assertTrue((boolean)coordinator.tierTopicSnapshotManager().isDefined());
        coordinator.reconfigure(configEnabled, configDisabled);
        Assertions.assertTrue((boolean)coordinator.tierTopicSnapshotManager().isEmpty());
        coordinator.reconfigure(configDisabled, configDisabled);
        Assertions.assertTrue((boolean)coordinator.tierTopicSnapshotManager().isEmpty());
    }

    public TierTopicSnapshotCoordinatorTest() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = TestUtils$.MODULE$.MockZkPort();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var21_10 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var22_13 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var23_16 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        this.props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, x$3, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        this.replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        this.tierObjectStoreOpt = new Some(Mockito.mock(TierObjectStore.class));
        this.time = Time.SYSTEM;
        this.metrics = new Metrics();
        this.partition = (Partition)Mockito.mock(Partition.class);
        this.clusterId = "Test";
        this.interBrokerClientConfigsSupplier = new HashMap<String, Object>();
        this.tp = new TopicPartition("_confluent-tier-state", TierTopicSnapshotCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE());
    }
}

