/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.snapshot;

import io.confluent.kafka.storage.cloud.EpochAndSeqNumber;
import io.confluent.kafka.storage.cloud.LinkedCloudObject;
import io.confluent.kafka.storage.cloud.SequencedObject;
import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.tier.domain.TierTopicPartitionSnapshot;
import kafka.tier.snapshot.TierTopicSnapshotManager;
import kafka.tier.snapshot.TierTopicSnapshotObject;
import kafka.tier.store.TierObjectStore;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.MockConsumer;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Md\u0001B\u000b\u0017\u0001uAQ\u0001\n\u0001\u0005\u0002\u0015Bq\u0001\u000b\u0001C\u0002\u0013%\u0011\u0006\u0003\u00041\u0001\u0001\u0006IA\u000b\u0005\nc\u0001\u0001\r\u00111A\u0005\u0002IB\u0011B\u000e\u0001A\u0002\u0003\u0007I\u0011A\u001c\t\u0013u\u0002\u0001\u0019!A!B\u0013\u0019\u0004b\u0002 \u0001\u0005\u0004%\ta\u0010\u0005\u0007\u0011\u0002\u0001\u000b\u0011\u0002!\t\u0013%\u0003\u0001\u0019!a\u0001\n\u0003Q\u0005\"C)\u0001\u0001\u0004\u0005\r\u0011\"\u0001S\u0011%!\u0006\u00011A\u0001B\u0003&1\nC\u0004V\u0001\t\u0007I\u0011\u0001,\t\r-\u0004\u0001\u0015!\u0003X\u0011%a\u0007\u00011AA\u0002\u0013\u0005Q\u000eC\u0005|\u0001\u0001\u0007\t\u0019!C\u0001y\"Ia\u0010\u0001a\u0001\u0002\u0003\u0006KA\u001c\u0005\u0007\u007f\u0002!\t!!\u0001\t\u000f\u0005u\u0001\u0001\"\u0001\u0002\u0002!9\u0011q\u0005\u0001\u0005\n\u0005%\u0002bBA$\u0001\u0011%\u0011\u0011\n\u0002\u001d)&,'\u000fV8qS\u000e\u001cf.\u00199tQ>$X*\u00198bO\u0016\u0014H+Z:u\u0015\t9\u0002$\u0001\u0005t]\u0006\u00048\u000f[8u\u0015\tI\"$\u0001\u0003uS\u0016\u0014(\"A\u000e\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\b\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00051\u0003CA\u0014\u0001\u001b\u00051\u0012a\u0005;jKJ|%M[3diN#xN]3N_\u000e\\W#\u0001\u0016\u0011\u0005-rS\"\u0001\u0017\u000b\u00055B\u0012!B:u_J,\u0017BA\u0018-\u0005=!\u0016.\u001a:PE*,7\r^*u_J,\u0017\u0001\u0006;jKJ|%M[3diN#xN]3N_\u000e\\\u0007%A\u0004nC:\fw-\u001a:\u0016\u0003M\u0002\"a\n\u001b\n\u0005U2\"\u0001\u0007+jKJ$v\u000e]5d':\f\u0007o\u001d5pi6\u000bg.Y4fe\u0006YQ.\u00198bO\u0016\u0014x\fJ3r)\tA4\b\u0005\u0002 s%\u0011!\b\t\u0002\u0005+:LG\u000fC\u0004=\u000b\u0005\u0005\t\u0019A\u001a\u0002\u0007a$\u0013'\u0001\u0005nC:\fw-\u001a:!\u0003\u0015\u0001(o\u001c9t+\u0005\u0001\u0005CA!G\u001b\u0005\u0011%BA\"E\u0003\u0011)H/\u001b7\u000b\u0003\u0015\u000bAA[1wC&\u0011qI\u0011\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018A\u00029s_B\u001c\b%\u0001\u0004d_:4\u0017nZ\u000b\u0002\u0017B\u0011AjT\u0007\u0002\u001b*\u0011aJG\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005Ak%aC&bM.\f7i\u001c8gS\u001e\f!bY8oM&<w\fJ3r)\tA4\u000bC\u0004=\u0015\u0005\u0005\t\u0019A&\u0002\u000f\r|gNZ5hA\u0005\u0001\u0013N\u001c;fe\n\u0013xn[3s\u00072LWM\u001c;D_:4\u0017nZ:TkB\u0004H.[3s+\u00059\u0006\u0003B!Y5\u0016L!!\u0017\"\u0003\u00075\u000b\u0007\u000f\u0005\u0002\\E:\u0011A\f\u0019\t\u0003;\u0002j\u0011A\u0018\u0006\u0003?r\ta\u0001\u0010:p_Rt\u0014BA1!\u0003\u0019\u0001&/\u001a3fM&\u00111\r\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0005\u0004\u0003C\u00014j\u001b\u00059'B\u00015E\u0003\u0011a\u0017M\\4\n\u0005)<'AB(cU\u0016\u001cG/A\u0011j]R,'O\u0011:pW\u0016\u00148\t\\5f]R\u001cuN\u001c4jON\u001cV\u000f\u001d9mS\u0016\u0014\b%A\u0006dY>,Hm\u00142kK\u000e$X#\u00018\u0011\u0005=LX\"\u00019\u000b\u0005E\u0014\u0018!B2m_V$'BA:u\u0003\u001d\u0019Ho\u001c:bO\u0016T!aG;\u000b\u0005Y<\u0018!C2p]\u001adW/\u001a8u\u0015\u0005A\u0018AA5p\u0013\tQ\bOA\tMS:\\W\rZ\"m_V$wJ\u00196fGR\fqb\u00197pk\u0012|%M[3di~#S-\u001d\u000b\u0003quDq\u0001P\b\u0002\u0002\u0003\u0007a.\u0001\u0007dY>,Hm\u00142kK\u000e$\b%A\u0003tKR,\u0006\u000fF\u00019Q\r\t\u0012Q\u0001\t\u0005\u0003\u000f\tI\"\u0004\u0002\u0002\n)!\u00111BA\u0007\u0003\r\t\u0007/\u001b\u0006\u0005\u0003\u001f\t\t\"A\u0004kkBLG/\u001a:\u000b\t\u0005M\u0011QC\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u0003/\t1a\u001c:h\u0013\u0011\tY\"!\u0003\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\nuKN$\u0018J\\5uS\u0006d\u0017N_1uS>t\u0007f\u0001\n\u0002\"A!\u0011qAA\u0012\u0013\u0011\t)#!\u0003\u0003\tQ+7\u000f^\u0001\u0006O\u0016$H\u000b\u001d\u000b\u0005\u0003W\ti\u0004\u0005\u0003\u0002.\u0005eRBAA\u0018\u0015\u0011\t\t$a\r\u0002\r\r|W.\\8o\u0015\rY\u0012Q\u0007\u0006\u0005\u0003o\t)\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003w\tyC\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000f\u0005}2\u00031\u0001\u0002B\u0005I\u0001/\u0019:uSRLwN\u001c\t\u0004?\u0005\r\u0013bAA#A\t\u0019\u0011J\u001c;\u0002\u001fQLWM\u001d+pa&\u001c'+Z2pe\u0012$b!a\u0013\u0002h\u0005%\u0004\u0003CA'\u0003/\nY&a\u0017\u000e\u0005\u0005=#\u0002BA)\u0003'\n\u0001bY8ogVlWM\u001d\u0006\u0005\u0003+\n\u0019$A\u0004dY&,g\u000e^:\n\t\u0005e\u0013q\n\u0002\u000f\u0007>t7/^7feJ+7m\u001c:e!\u0015y\u0012QLA1\u0013\r\ty\u0006\t\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004?\u0005\r\u0014bAA3A\t!!)\u001f;f\u0011\u001d\ty\u0004\u0006a\u0001\u0003\u0003Bq!a\u001b\u0015\u0001\u0004\ti'\u0001\u0004pM\u001a\u001cX\r\u001e\t\u0004?\u0005=\u0014bAA9A\t!Aj\u001c8h\u0001")
public class TierTopicSnapshotManagerTest {
    private final TierObjectStore tierObjectStoreMock = (TierObjectStore)Mockito.mock(TierObjectStore.class);
    private TierTopicSnapshotManager manager;
    private final Properties props;
    private KafkaConfig config;
    private final Map<String, Object> interBrokerClientConfigsSupplier;
    private LinkedCloudObject cloudObject;

    private TierObjectStore tierObjectStoreMock() {
        return this.tierObjectStoreMock;
    }

    public TierTopicSnapshotManager manager() {
        return this.manager;
    }

    public void manager_$eq(TierTopicSnapshotManager x$1) {
        this.manager = x$1;
    }

    public Properties props() {
        return this.props;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public Map<String, Object> interBrokerClientConfigsSupplier() {
        return this.interBrokerClientConfigsSupplier;
    }

    public LinkedCloudObject cloudObject() {
        return this.cloudObject;
    }

    public void cloudObject_$eq(LinkedCloudObject x$1) {
        this.cloudObject = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.props().setProperty(KafkaConfig$.MODULE$.TierFeatureProp(), Boolean.toString(true));
        this.props().setProperty(KafkaConfig$.MODULE$.TierTopicSnapshotsEnableProp(), Boolean.toString(true));
        this.interBrokerClientConfigsSupplier().put("bootstrap.servers", "localhost:80");
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(this.props()));
    }

    @Test
    public void testInitialization() {
        TierTopicSnapshotObject snapshotObject = new TierTopicSnapshotObject(123L, 456L, new EpochAndSeqNumber(2, 1L), new EpochAndSeqNumber(2, 0L));
        HashMap<TopicPartition, List<ConsumerRecord<byte[], byte[]>>> records = new HashMap<TopicPartition, List<ConsumerRecord<byte[], byte[]>>>(this){
            {
                this.put(new TopicPartition("_confluent-tier-state", 0), Arrays.asList($outer.kafka$tier$snapshot$TierTopicSnapshotManagerTest$$tierTopicRecord(0, 10L), $outer.kafka$tier$snapshot$TierTopicSnapshotManagerTest$$tierTopicRecord(0, 15L)));
                this.put(new TopicPartition("_confluent-tier-state", 1), Arrays.asList($outer.kafka$tier$snapshot$TierTopicSnapshotManagerTest$$tierTopicRecord(1, 11L)));
                this.put(new TopicPartition("_confluent-tier-state", 2), Arrays.asList($outer.kafka$tier$snapshot$TierTopicSnapshotManagerTest$$tierTopicRecord(2, 8L), $outer.kafka$tier$snapshot$TierTopicSnapshotManagerTest$$tierTopicRecord(2, 20L)));
            }
        };
        ConsumerRecords consumerRecords = new ConsumerRecords((Map)records);
        ArrayList offsets = new ArrayList(50);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 49).foreach((Function1)(JFunction1.mcZI.sp & Serializable)x$4 -> offsets.add(Predef$.MODULE$.long2Long(0L)));
        TierTopicPartitionSnapshot snapshot = new TierTopicPartitionSnapshot(Arrays.asList(consumerRecords), offsets);
        List<SequencedObject> objects = Arrays.asList(snapshotObject);
        SequencedObject arg = objects.get(0);
        MockConsumer mockConsumer = new MockConsumer(OffsetResetStrategy.LATEST);
        this.manager_$eq((TierTopicSnapshotManager)Mockito.spy((Object)new TierTopicSnapshotManager((Consumer)mockConsumer, this.tierObjectStoreMock(), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.short2Short((short)50), Predef$.MODULE$.long2Long(Duration.ofMinutes(5L).toMillis()), Predef$.MODULE$.long2Long(100L), Predef$.MODULE$.int2Integer(2), Time.SYSTEM, new Metrics())));
        ((TierTopicSnapshotManager)Mockito.doAnswer(x$5 -> snapshot).when((Object)this.manager())).snapshot(arg);
        ((TierTopicSnapshotManager)Mockito.doAnswer(x$6 -> objects).when((Object)this.manager())).latestSnapshots();
        this.manager().initialize();
        int getTp_partition = 0;
        Assertions.assertEquals((long)15L, (long)mockConsumer.position(new TopicPartition("_confluent-tier-state", getTp_partition)));
        int getTp_partition2 = 1;
        Assertions.assertEquals((long)11L, (long)mockConsumer.position(new TopicPartition("_confluent-tier-state", getTp_partition2)));
        int getTp_partition3 = 2;
        Assertions.assertEquals((long)20L, (long)mockConsumer.position(new TopicPartition("_confluent-tier-state", getTp_partition3)));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(3), 49).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> Assertions.assertEquals((long)0L, (long)mockConsumer.position(new TopicPartition("_confluent-tier-state", i))));
    }

    private TopicPartition getTp(int partition) {
        return new TopicPartition("_confluent-tier-state", partition);
    }

    public ConsumerRecord<byte[], byte[]> kafka$tier$snapshot$TierTopicSnapshotManagerTest$$tierTopicRecord(int partition, long offset) {
        return TierTopicPartitionSnapshot.makeTierTopicRecord((int)partition, (long)offset, (long)Time.SYSTEM.milliseconds(), (byte[])new byte[]{1}, (byte[])new byte[]{1}, (int)1);
    }

    public TierTopicSnapshotManagerTest() {
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = TestUtils$.MODULE$.MockZkPort();
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var21_10 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var22_13 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var23_16 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        this.props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, x$4, x$5, x$3, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        this.interBrokerClientConfigsSupplier = new HashMap<String, Object>();
    }
}

