/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.snapshot;

import io.confluent.kafka.storage.cloud.EpochAndSeqNumber;
import java.util.Calendar;
import java.util.TimeZone;
import kafka.tier.snapshot.TierTopicSnapshotObject;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.FragmentLocation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.TierTopicSnapshotMetadata;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000592A!\u0002\u0004\u0001\u001b!)A\u0003\u0001C\u0001+!)\u0001\u0004\u0001C\u00013!)!\u0006\u0001C\u00013!)A\u0006\u0001C\u00013\tYB+[3s)>\u0004\u0018nY*oCB\u001c\bn\u001c;PE*,7\r\u001e+fgRT!a\u0002\u0005\u0002\u0011Mt\u0017\r]:i_RT!!\u0003\u0006\u0002\tQLWM\u001d\u0006\u0002\u0017\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u0006\t\u0003/\u0001i\u0011AB\u0001)i\u0016\u001cH\u000fV5fe6+G/\u00193bi\u0006\u001cf.\u00199tQ>$\b+\u0019;i\u000b:\u001cw\u000eZ3EK\u000e|G-\u001a\u000b\u00025A\u0011qbG\u0005\u00039A\u0011A!\u00168ji\"\u0012!A\b\t\u0003?!j\u0011\u0001\t\u0006\u0003C\t\n1!\u00199j\u0015\t\u0019C%A\u0004kkBLG/\u001a:\u000b\u0005\u00152\u0013!\u00026v]&$(\"A\u0014\u0002\u0007=\u0014x-\u0003\u0002*A\t!A+Z:u\u0003Y!Xm\u001d;T]\u0006\u00048\u000f[8u\u000f\u0016$H)\u001b:OC6,\u0007FA\u0002\u001f\u0003]!Xm\u001d;PE*,7\r^*u_J,gI]8n!\u0006$\b\u000e\u000b\u0002\u0005=\u0001")
public class TierTopicSnapshotObjectTest {
    @Test
    public void testTierMetadataSnapshotPathEncodeDecode() {
        int startTimestampMs = 123;
        TierTopicSnapshotObject snapshotObject = new TierTopicSnapshotObject((long)startTimestampMs, 456L, new EpochAndSeqNumber(3, 0L), new EpochAndSeqNumber(2, 4L));
        TierTopicSnapshotMetadata metadata = new TierTopicSnapshotMetadata(snapshotObject);
        String keyPrefix = "bar";
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTimeInMillis(startTimestampMs);
        String fileName = new StringBuilder(8).append(Integer.toString(calendar.get(1))).append("/").append(Integer.toString(calendar.get(6))).append("/").append(Integer.toString(calendar.get(11))).append("/").append(Long.toString(metadata.snapshotObject().startTimestampMs())).append("_").append(Long.toString(metadata.snapshotObject().endTimestampMs())).append("_").append(Integer.toString(metadata.snapshotObject().currentEpochAndSeqNumber().epoch())).append("_").append(Long.toString(metadata.snapshotObject().currentEpochAndSeqNumber().seqNumber())).append("_").append(Integer.toString(metadata.snapshotObject().previousEpochAndSeqNumber().epoch())).append("_").append(Long.toString(metadata.snapshotObject().previousEpochAndSeqNumber().seqNumber())).toString();
        String expectedObjectStorePath = new StringBuilder(4).append(keyPrefix).append(TierObjectStore.DataTypePathPrefix.TIER_TOPIC_SNAPSHOT.prefix).append("/").append(fileName).append("_v").append(metadata.version()).append(".").append(ObjectType.TIER_TOPIC_SNAPSHOT.suffix()).toString();
        Assertions.assertEquals((int)0, (int)metadata.version());
        Assertions.assertEquals((Object)expectedObjectStorePath, (Object)((FragmentLocation)metadata.toFragmentLocation(keyPrefix, FragmentType.TIER_TOPIC_SNAPSHOT).get()).objectPath());
        TierTopicSnapshotObject decodedSnapshotObject = TierTopicSnapshotObject.decodeSnapshotName((String)fileName);
        Assertions.assertEquals((Object)snapshotObject, (Object)decodedSnapshotObject);
    }

    @Test
    public void testSnapshotGetDirName() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.set(2022, 10, 1, 19, 51);
        Assertions.assertEquals((Object)"2022/305/19", (Object)TierTopicSnapshotObject.getDirName((long)calendar.getTimeInMillis()));
    }

    @Test
    public void testObjectStoreFromPath() {
        TierTopicSnapshotObject snapshotObject = new TierTopicSnapshotObject(123L, 456L, new EpochAndSeqNumber(3, 0L), new EpochAndSeqNumber(2, 4L));
        TierTopicSnapshotMetadata metadata = new TierTopicSnapshotMetadata(snapshotObject);
        TierTopicSnapshotMetadata decodedMetadata = TierTopicSnapshotMetadata.fromPath((String)((FragmentLocation)metadata.toFragmentLocation("", FragmentType.TIER_TOPIC_SNAPSHOT).get()).objectPath());
        Assertions.assertEquals((Object)metadata, (Object)decodedMetadata);
        TierTopicSnapshotMetadata metadataDecodeFromPath = TierTopicSnapshotMetadata.fromPath((String)"5/2022/322/16/1668787289759_1668787573080_3478_230_3478_229_v0.tier-topic-snapshot");
        TierTopicSnapshotObject tierTopicSnapshotObject = new TierTopicSnapshotObject(1668787289759L, 1668787573080L, new EpochAndSeqNumber(3478, 230L), new EpochAndSeqNumber(3478, 229L));
        TierTopicSnapshotMetadata metadataDecodeFromSnapshotObject = new TierTopicSnapshotMetadata(tierTopicSnapshotObject);
        Assertions.assertEquals((Object)metadataDecodeFromPath, (Object)metadataDecodeFromSnapshotObject);
    }
}

