/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import io.confluent.kafka.storage.checksum.Algorithm;
import io.confluent.kafka.storage.checksum.CheckedFileIO;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import kafka.log.LocalLog$;
import kafka.log.MergedLog$;
import kafka.log.TierLogSegment;
import kafka.server.KafkaConfig$;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierCompactionCommitAndSwap;
import kafka.tier.domain.TierMetadataSnapshotUploadComplete;
import kafka.tier.domain.TierMetadataSnapshotUploadInitiate;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierSegmentDeleteComplete;
import kafka.tier.domain.TierSegmentDeleteInitiate;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.ChecksumUtils;
import kafka.tier.state.CompactStats;
import kafka.tier.state.FileTierPartitionIterator;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.FileTierPartitionStateSnapshotObject;
import kafka.tier.state.FileTierPartitionStateTest;
import kafka.tier.state.Header;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.SegmentState;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.OpaqueData;
import kafka.tier.tasks.snapshot.MetadataSnapshotTask$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Md\u0001\u0002\u0011\"\u0001!BQ!\f\u0001\u0005\u00029BQ\u0001\r\u0001\u0005BEBQ\u0001\u000f\u0001\u0005BEBQ!\u000f\u0001\u0005BEBQA\u000f\u0001\u0005BEBQa\u000f\u0001\u0005\nqBQ!\u0019\u0001\u0005B\tDQ\u0001\u001d\u0001\u0005\u0002\tDQA\u001d\u0001\u0005\u0002\tDQ\u0001\u001e\u0001\u0005\nUDa!a\u0006\u0001\t\u0003\u0011\u0007BBA\u000e\u0001\u0011\u0005!\r\u0003\u0004\u0002 \u0001!\tA\u0019\u0005\u0007\u0003G\u0001A\u0011\u00012\t\r\u0005\u001d\u0002\u0001\"\u0001c\u0011\u0019\tY\u0003\u0001C\u0001E\"1\u0011q\u0006\u0001\u0005\u0002\tDa!a\r\u0001\t\u0003\u0011\u0007BBA\u001c\u0001\u0011\u0005!\r\u0003\u0004\u0002<\u0001!\tA\u0019\u0005\u0007\u0003\u007f\u0001A\u0011\u00012\t\r\u0005\r\u0003\u0001\"\u0001c\u0011\u0019\t9\u0005\u0001C\u0001E\"1\u00111\n\u0001\u0005\u0002\tDa!a\u0014\u0001\t\u0003\u0011\u0007BBA*\u0001\u0011\u0005!\r\u0003\u0004\u0002X\u0001!\tA\u0019\u0005\u0007\u00037\u0002A\u0011\u00012\t\r\u0005}\u0003\u0001\"\u0001c\u0011\u0019\t\u0019\u0007\u0001C\u0001E\"9\u0011q\r\u0001\u0005\u0002\u0005%$\u0001\u000b$jY\u0016$\u0016.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^3D_6\u0004\u0018m\u0019;F]\u0006\u0014G.\u001a3UKN$(B\u0001\u0012$\u0003\u0015\u0019H/\u0019;f\u0015\t!S%\u0001\u0003uS\u0016\u0014(\"\u0001\u0014\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u000b\t\u0003U-j\u0011!I\u0005\u0003Y\u0005\u0012!DR5mKRKWM\u001d)beRLG/[8o'R\fG/\u001a+fgR\fa\u0001P5oSRtD#A\u0018\u0011\u0005)\u0002\u0011aD2iK\u000e\\7/^7F]\u0006\u0014G.\u001a3\u0016\u0003I\u0002\"a\r\u001c\u000e\u0003QR\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oQ\u0012qAQ8pY\u0016\fg.\u0001\bd_6\u0004\u0018m\u0019;F]\u0006\u0014G.\u001a3\u0002\u001d\rdW-\u00198va\u0016s\u0017M\u00197fI\u0006\tC/[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f':\f\u0007o\u001d5pi\u0016s\u0017M\u00197fI\u0006Y2m\\7qCJ,G+[3s'R\fG/\u001a$jY\u0016\u001c\b*\u001a7qKJ$\u0002\"\u0010!P)f[Vl\u0018\t\u0003gyJ!a\u0010\u001b\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0003\u001a\u0001\rAQ\u0001\r_2$\u0017\t\\4pe&$\b.\u001c\t\u0003\u00076k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000b\u0001b\u00195fG.\u001cX/\u001c\u0006\u0003\u000f\"\u000bqa\u001d;pe\u0006<WM\u0003\u0002'\u0013*\u0011!jS\u0001\nG>tg\r\\;f]RT\u0011\u0001T\u0001\u0003S>L!A\u0014#\u0003\u0013\u0005cwm\u001c:ji\"l\u0007\"\u0002)\u0007\u0001\u0004\t\u0016\u0001D8mIRKWM]#q_\u000eD\u0007CA\u001aS\u0013\t\u0019FGA\u0002J]RDQ!\u0016\u0004A\u0002Y\u000bAb\u001c7e\u000b:$wJ\u001a4tKR\u0004\"aM,\n\u0005a#$\u0001\u0002'p]\u001eDQA\u0017\u0004A\u0002\t\u000bAB\\3x\u00032<wN]5uQ6DQ\u0001\u0018\u0004A\u0002E\u000bAB\\3x)&,'/\u00129pG\"DQA\u0018\u0004A\u0002Y\u000bAB\\3x\u000b:$wJ\u001a4tKRDQ\u0001\u0019\u0004A\u0002I\naA]3tk2$\u0018!\u000b;fgRD\u0015M\u001c3mKNs\u0017\r]:i_R,\u0006\u000f\\8bI&s\u0017\u000e^5bi\u00164\u0015-\u001b7DCN,7\u000fF\u0001>Q\t9A\r\u0005\u0002f]6\taM\u0003\u0002hQ\u0006\u0019\u0011\r]5\u000b\u0005%T\u0017a\u00026va&$XM\u001d\u0006\u0003W2\fQA[;oSRT\u0011!\\\u0001\u0004_J<\u0017BA8g\u0005\u0011!Vm\u001d;\u00023Q,7\u000f^\"p[B\f'/\u001a+jKJ\u001cF/\u0019;f\r&dWm\u001d\u0015\u0003\u0011\u0011\fa\u0002^3tiB\u0013x\u000e]3si&,7\u000f\u000b\u0002\nI\u0006Q\u0001O]8qKJ$\u0018.Z:\u0015\u0005Yt\bCA<}\u001b\u0005A(BA={\u0003\u0011)H/\u001b7\u000b\u0003m\fAA[1wC&\u0011Q\u0010\u001f\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bBB@\u000b\u0001\u0004\t\t!\u0001\bdQ\u0016\u001c7n];n\u0007>tg-[4\u0011\t\u0005\r\u0011\u0011\u0003\b\u0005\u0003\u000b\ti\u0001E\u0002\u0002\bQj!!!\u0003\u000b\u0007\u0005-q%\u0001\u0004=e>|GOP\u0005\u0004\u0003\u001f!\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0014\u0005U!AB*ue&twMC\u0002\u0002\u0010Q\nA\u0005^3tiJ+\u0017\rZ,sSR,\u0007*Z1eKJ|e\u000e\\=XSRDW*[4sCRLwN\u001c\u0015\u0003\u0017\u0011\fA\u0003^3tiZ\u000bG.\u001b3bi\u0016\u001c\u0005.Z2lgVl\u0007F\u0001\u0007e\u00035!Xm\u001d;D_6\u0004\u0018m\u0019;fI\"\u0012Q\u0002Z\u0001\u0016i\u0016\u001cHoQ8na\u0006\u001cG/[8o\r\u0016t7-\u001b8hQ\tqA-A\u0011uKN$8i\\7qC\u000e$\u0018n\u001c8D_:\u001cWO\u001d:f]R$U\r\\3uS>t7\u000f\u000b\u0002\u0010I\u0006IC/Z:u\r\u0016t7-\u001a)sS>\u00148i\\7qC\u000e$X\rZ%oSRL\u0017\r^3XSRD7i\\7nSRD#\u0001\u00053\u0002WQ,7\u000f^\"p[B\f7\r^5p]V\u0003Hn\\1e\u0013:LG/[1uK\u000eC\u0017-\u001b8j]\u001e\u001cVoY2fgND#!\u00053\u0002\u007fQ,7\u000f^\"p[B\f7\r^5p]V\u0003Hn\\1e\u0013:LG/[1uK\u000eC\u0017-\u001b8j]\u001e\u0004&/\u001a<j_V\u001cxJ\u00196fGRLEMT8u\u000bb\u0004Xm\u0019;fI\"\u0012!\u0003Z\u0001@i\u0016\u001cHoQ8na\u0006\u001cG/[8o+Bdw.\u00193J]&$\u0018.\u0019;f\u0007\"\f\u0017N\\5oOB\u0013XM^5pkN|%M[3di&#gj\u001c;NCR\u001c\u0007.\u001b8hQ\t\u0019B-A\u0018uKN$X\u000b\u001d7pC\u0012Le.\u001b;jCR,7\t[1j]&tw-\u00169m_\u0006$G+\u001f9f\u001d>$X*\u0019;dQ&tw\r\u000b\u0002\u0015I\u00061D/Z:u\u0007>l\u0007/Y2uS>tW\u000b\u001d7pC\u0012\u001cu.\\7ji\u0006sGmU<ba\u001a+gnY5oOV\u0003Hn\\1e\u0013:LG/[1uK\"\u0012Q\u0003Z\u0001>i\u0016\u001cHoQ8na\u0006\u001cG/[8o+Bdw.\u00193D_6l\u0017\u000e^!oIN;\u0018\r],ji\"tuN\\#ySN$\u0018N\\4T_V\u00148-Z(cU\u0016\u001cGo\u001d\u0015\u0003-\u0011\fq\b^3ti\u000e{W\u000e]1di&|g.\u00169m_\u0006$7i\\7nSR\fe\u000eZ*xCB<\u0016\u000e\u001e5O_:\u001cuN\u001c;jOV|Wo]*pkJ\u001cWm\u00142kK\u000e$8\u000f\u000b\u0002\u0018I\u00061D/Z:u\u0007>l\u0007/Y2uS>tW\u000b\u001d7pC\u0012\u001cu.\\7ji\u0006sGmU<ba^KG\u000f[%na>\u001c8/\u001b2mK>3gm]3ug\"\u0012\u0001\u0004Z\u00010i\u0016\u001cHoQ8na\u0006\u001cG/[8o\u0007>lW.\u001b;B]\u0012\u001cv/\u00199XSRD7+\\1mY\u0016\u0014XI\u001c3PM\u001a\u001cX\r\u001e\u0015\u00033\u0011\f\u0011\u0006^3tiJ+Gn\\1eS:<g\t\u0016)T/&$\b.T5tg&twmQ8na\u0006\u001cGOR5fY\u0012\u001c\bF\u0001\u000ee\u0003y!Xm\u001d;GYV\u001c\b\u000eS3bI\u0016\u0014x+\u001b;i\u000bJ\u0014xN]*uCR,8\u000f\u000b\u0002\u001cI\u00069B/Z:u'R\fG/\u001a\"fM>\u0014X\rR3mKRLwN\u001c\u0015\u00039\u0011\f!\u0006^3tiJ+Gn\\1eS:<g\t\u0016)T/&$\b.T5tg&twm\u00158baNDw\u000e\u001e$jK2$7\u000f\u000b\u0002\u001eI\u0006!B/Z:u\u001b\u0016$\u0018\rZ1uCNs\u0017\r]:i_RD#A\b3\u0002\u001f\rDWmY6J]Z\f'/[1oiN$2!PA6\u0011\u0019\u0011s\u00041\u0001\u0002nA\u0019!&a\u001c\n\u0007\u0005E\u0014E\u0001\nUS\u0016\u0014\b+\u0019:uSRLwN\\*uCR,\u0007")
public class FileTierPartitionStateCompactEnabledTest
extends FileTierPartitionStateTest {
    @Override
    public boolean checksumEnabled() {
        return true;
    }

    @Override
    public boolean compactEnabled() {
        return true;
    }

    @Override
    public boolean cleanupEnabled() {
        return true;
    }

    @Override
    public boolean tierPartitionStateSnapshotEnabled() {
        return true;
    }

    private void compareTierStateFilesHelper(Algorithm oldAlgorithm, int oldTierEpoch, long oldEndOffset, Algorithm newAlgorithm, int newTierEpoch, long newEndOffset, boolean result) {
        Path oldPath = new File(new StringBuilder(8).append("testFile").append(oldAlgorithm.suffix).toString()).toPath();
        Path newPath = new File(new StringBuilder(8).append("testFile").append(newAlgorithm.suffix).toString()).toPath();
        this.writeHeader$1(oldPath, oldAlgorithm, oldTierEpoch, oldEndOffset);
        this.writeHeader$1(newPath, newAlgorithm, newTierEpoch, newEndOffset);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)result), (Object)BoxesRunTime.boxToBoolean((boolean)ChecksumUtils.compareTierStateFiles((Path)oldPath, (Path)newPath)));
        Files.delete(oldPath);
        Files.delete(newPath);
    }

    @Override
    @Test
    public void testHandleSnapshotUploadInitiateFailCases() {
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 1, UUID.randomUUID(), this.brokerId()), new OffsetAndEpoch(0L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        this.state().flush();
        this.state().beginCatchup();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierMetadataSnapshotUploadInitiate(this.tpid(), 1, UUID.randomUUID(), this.state().lastLocalMaterializedSrcOffsetAndEpoch(), this.brokerId()), new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(1)))));
        this.state().onCatchUpComplete();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierMetadataSnapshotUploadInitiate(this.tpid(), 1, UUID.randomUUID(), this.state().lastLocalMaterializedSrcOffsetAndEpoch(), this.brokerId()), new OffsetAndEpoch(2L, Optional.of(Predef$.MODULE$.int2Integer(1)))));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FENCED, (Object)this.state().append((AbstractTierMetadata)new TierMetadataSnapshotUploadInitiate(this.tpid(), 0, UUID.randomUUID(), this.state().lastLocalMaterializedSrcOffsetAndEpoch(), this.brokerId()), new OffsetAndEpoch(3L, Optional.of(Predef$.MODULE$.int2Integer(1)))));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FENCED, (Object)this.state().append((AbstractTierMetadata)new TierMetadataSnapshotUploadInitiate(this.tpid(), 1, UUID.randomUUID(), this.state().lastLocalMaterializedSrcOffsetAndEpoch(), this.brokerId() + 1), new OffsetAndEpoch(4L, Optional.of(Predef$.MODULE$.int2Integer(1)))));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierMetadataSnapshotUploadInitiate(this.tpid(), 2, UUID.randomUUID(), this.state().lastLocalMaterializedSrcOffsetAndEpoch(), this.brokerId()), new OffsetAndEpoch(5L, Optional.of(Predef$.MODULE$.int2Integer(1)))));
    }

    @Test
    public void testCompareTierStateFiles() {
        this.checkDifferentAlgorithmCombinations$1(3, 10L, 5, 20L, true);
        this.checkDifferentAlgorithmCombinations$1(3, 10L, 3, 20L, true);
        this.checkDifferentAlgorithmCombinations$1(5, 30L, 3, 20L, false);
    }

    @Test
    public void testProperties() {
        Assertions.assertThrows(ConfigException.class, () -> KafkaConfig$.MODULE$.fromProps(this.properties("none, tierstate")));
        Assertions.assertThrows(ConfigException.class, () -> KafkaConfig$.MODULE$.fromProps(this.properties("all, tierstate")));
        Assertions.assertThrows(ConfigException.class, () -> KafkaConfig$.MODULE$.fromProps(this.properties("all, none")));
        java.util.List checksumFiles = KafkaConfig$.MODULE$.fromProps(this.properties("tierstate")).confluentConfig().checksumEnabledFiles();
        Assertions.assertEquals((int)1, (int)checksumFiles.size());
        Assertions.assertTrue((boolean)checksumFiles.contains("tierstate"));
    }

    private Properties properties(String checksumConfig) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "somewhere", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1, false);
        props.put("confluent.checksum.enabled.files", checksumConfig);
        return props;
    }

    @Test
    public void testReadWriteHeaderOnlyWithMigration() {
        Path flushedPath = Paths.get(this.state().flushedPath(), new String[0]);
        Path adlerChecksumPath = CheckedFileIO.validPath((Algorithm)Algorithm.ADLER, (Path)flushedPath);
        Path nonChecksumPath = CheckedFileIO.validPath((Algorithm)Algorithm.NO_CHECKSUM, (Path)flushedPath);
        Assertions.assertTrue((boolean)Files.exists(adlerChecksumPath, new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.notExists(nonChecksumPath, new LinkOption[0]));
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 9, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertEquals((int)9, (int)this.state().tierEpoch());
        this.state().close();
        FileTierPartitionState reopenedState = (FileTierPartitionState)this.factory().initState(this.dir(), this.tp(), this.logConfig(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler, Predef$.MODULE$.boolean2Boolean(true), (Time)this.time());
        Assertions.assertTrue((boolean)Files.exists(adlerChecksumPath, new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.notExists(nonChecksumPath, new LinkOption[0]));
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)9, (int)reopenedState.tierEpoch());
        reopenedState.close();
        reopenedState = (FileTierPartitionState)this.factory().initState(this.dir(), this.tp(), this.logConfig(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler, Predef$.MODULE$.boolean2Boolean(false), (Time)this.time());
        Assertions.assertTrue((boolean)Files.notExists(adlerChecksumPath, new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.exists(nonChecksumPath, new LinkOption[0]));
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)9, (int)reopenedState.tierEpoch());
        reopenedState.close();
        reopenedState = (FileTierPartitionState)this.factory().initState(this.dir(), this.tp(), this.logConfig(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler, Predef$.MODULE$.boolean2Boolean(true), (Time)this.time());
        Assertions.assertTrue((boolean)Files.exists(adlerChecksumPath, new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.notExists(nonChecksumPath, new LinkOption[0]));
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)9, (int)reopenedState.tierEpoch());
        reopenedState.close();
    }

    @Test
    public void testValidateChecksum() {
        Assertions.assertTrue((boolean)this.state().validateChecksum());
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertTrue((boolean)this.state().validateChecksum());
        int numSegments = 200;
        int epoch = 0;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        IntRef size = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            this.uploadInitateAndComplete(epoch, UUID.randomUUID(), i * 2, i * 2 + 1, 100);
            size$1.elem += i;
        });
        Assertions.assertTrue((boolean)this.state().validateChecksum());
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertTrue((boolean)this.state().validateChecksum());
    }

    @Test
    public void testCompacted() {
        int numSegments = 20;
        int epoch = 0;
        IntRef offset = IntRef.create((int)0);
        File parentDir = TestUtils.tempDirectory(null, null);
        TestUtils$ randomPartitionLogDir_this = TestUtils$.MODULE$;
        Object var49_5 = null;
        File dir = randomPartitionLogDir_this.randomPartitionForTopicLogDir(parentDir, "kafka");
        TopicPartition tp = LocalLog$.MODULE$.parseTopicPartitionName(dir);
        TopicIdPartition tpid = new TopicIdPartition(tp.topic(), UUID.randomUUID(), tp.partition());
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(5);
        FileTierPartitionState state = new FileTierPartitionState(dir, logDirFailureChannel, tp, true, (Scheduler)this.time().scheduler, this.checksumEnabled(), true, (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        state.setTopicId(tpid.topicId());
        state.setTieredPartitionRecoveryWorkflowCb(op -> {
            TestUtils$ debug_this = TestUtils$.MODULE$;
            if (debug_this.logger().underlying().isDebugEnabled()) {
                String msgWithLogIdent_msg = FileTierPartitionStateCompactEnabledTest.$anonfun$testCompacted$2(op, state);
                Object var3_3 = null;
                debug_this.logger().underlying().debug(Logging.msgWithLogIdent$((Logging)debug_this, (String)msgWithLogIdent_msg));
                return;
            }
        });
        state.beginCatchup();
        state.onCatchUpComplete();
        ListBuffer rawObjectIds = new ListBuffer();
        state.append((AbstractTierMetadata)new TierTopicInitLeader(tpid, epoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            rawObjectIds.$plus$eq((Object)UUID.randomUUID());
            OffsetAndEpoch uploadStateOffset = state.lastLocalMaterializedSrcOffsetAndEpoch();
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state.append((AbstractTierMetadata)new TierSegmentUploadInitiate(tpid, epoch, (UUID)rawObjectIds.last(), (long)offset$1.elem, (long)(offset$1.elem + 1), 100L, (long)i, i, false, false, false, TierUploadType.Archive, uploadStateOffset, OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state.append((AbstractTierMetadata)new TierSegmentUploadComplete(tpid, epoch, (UUID)rawObjectIds.last(), uploadStateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            offset$1.elem += 2;
        });
        this.checkInvariants((TierPartitionState)state);
        int numSegmentsToCompact = 3;
        List segmentsToClean = CollectionConverters$.MODULE$.IteratorHasAsScala(state.segments()).asScala().take(numSegmentsToCompact).toList();
        Assertions.assertEquals((int)20, (int)CollectionConverters$.MODULE$.IteratorHasAsScala(state.segments()).asScala().size());
        java.util.Set compactedObjectIds = CollectionConverters$.MODULE$.SetHasAsJava((Set)segmentsToClean.map((Function1 & Serializable)x$1 -> x$1.metadata().objectId()).toSet()).asJava();
        long firstBatchTimestamp = 50L;
        UUID newObjectId = UUID.randomUUID();
        long newBaseOffset = ((TierLogSegment)segmentsToClean.head()).baseOffset();
        long newEndOffset = ((TierLogSegment)segmentsToClean.last()).endOffset();
        long newMaxTimestamp = BoxesRunTime.unboxToLong((Object)segmentsToClean.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.maxTimestamp())).max((Ordering)Ordering.Long$.MODULE$));
        int newSize = BoxesRunTime.unboxToInt((Object)segmentsToClean.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.size())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        OffsetAndEpoch compactInitiateStateOffset = state.lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((long)-1L, (long)state.compactDirtyStartOffset());
        TierSegmentUploadInitiate compactInitiate = new TierSegmentUploadInitiate(tpid, epoch, newObjectId, newBaseOffset, newEndOffset, newMaxTimestamp, firstBatchTimestamp, newSize, false, false, false, TierUploadType.Compaction, compactInitiateStateOffset, OpaqueData.ZEROED);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state.append((AbstractTierMetadata)compactInitiate, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((long)-1L, (long)state.compactDirtyStartOffset());
        this.checkInvariants((TierPartitionState)state);
        UUID completeMessageId = UUID.randomUUID();
        TierCompactionCommitAndSwap compactComplete = new TierCompactionCommitAndSwap(compactInitiate, completeMessageId, compactedObjectIds, newBaseOffset, newEndOffset, new CompactStats((long)newSize, (long)newSize, (long)newSize));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state.append((AbstractTierMetadata)compactComplete, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state.append((AbstractTierMetadata)compactComplete, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((long)6L, (long)state.compactDirtyStartOffset());
        this.checkInvariants((TierPartitionState)state);
        int numSegmentsAfter = numSegments - numSegmentsToCompact + 1;
        Assertions.assertEquals((int)numSegmentsAfter, (int)CollectionConverters$.MODULE$.IteratorHasAsScala(state.segments()).asScala().size());
        Assertions.assertEquals((long)50L, (long)((TierLogSegment)CollectionConverters$.MODULE$.IteratorHasAsScala(state.segments()).asScala().next()).firstBatchTimestamp());
        Assertions.assertEquals((Object)compactInitiate.messageId(), (Object)((TierLogSegment)state.metadata(0L).get()).objectId());
        Assertions.assertEquals((Object)compactInitiate.messageId(), (Object)((TierLogSegment)state.metadata(3L).get()).objectId());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsScala(compactedObjectIds).asScala().toSet(), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(state.compactedSegments()).asScala().map((Function1 & Serializable)x$4 -> x$4.objectId())).toSet());
        this.checkInvariants((TierPartitionState)state);
        CollectionConverters$.MODULE$.CollectionHasAsScala(state.compactedSegments()).asScala().foreach((Function1 & Serializable)deletableSegment -> {
            FileTierPartitionStateCompactEnabledTest.$anonfun$testCompacted$8(this, state, tpid, epoch, deletableSegment);
            return BoxedUnit.UNIT;
        });
        List segmentsToClean2 = CollectionConverters$.MODULE$.IteratorHasAsScala(state.segments()).asScala().slice(numSegmentsToCompact, numSegmentsToCompact + 2).toList();
        long firstBatchTimestamp2 = 50L;
        UUID newObjectId2 = UUID.randomUUID();
        long newBaseOffset2 = ((TierLogSegment)segmentsToClean2.head()).baseOffset();
        long newEndOffset2 = ((TierLogSegment)segmentsToClean2.last()).endOffset();
        long newMaxTimestamp2 = BoxesRunTime.unboxToLong((Object)segmentsToClean.map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.maxTimestamp())).max((Ordering)Ordering.Long$.MODULE$));
        int newSize2 = BoxesRunTime.unboxToInt((Object)segmentsToClean2.map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.size())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        OffsetAndEpoch compactInitiateStateOffset2 = state.lastLocalMaterializedSrcOffsetAndEpoch();
        TierSegmentUploadInitiate compactInitiate2 = new TierSegmentUploadInitiate(tpid, epoch, newObjectId2, newBaseOffset2, newEndOffset2, newMaxTimestamp2, firstBatchTimestamp2, newSize2, false, false, false, TierUploadType.Compaction, compactInitiateStateOffset2, OpaqueData.ZEROED);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state.append((AbstractTierMetadata)compactInitiate2, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((long)6L, (long)state.compactDirtyStartOffset());
        this.checkInvariants((TierPartitionState)state);
        TierTestUtils$.MODULE$.verifyFtpsEntries(state, null, null, this.cleanupEnabled(), this.time().milliseconds());
        List segments = CollectionConverters$.MODULE$.IteratorHasAsScala(state.segments()).asScala().toList();
        scala.collection.immutable.Set segmentsDeleted = CollectionConverters$.MODULE$.SetHasAsScala(TierTestUtils$.MODULE$.deletedSegments(state, -1L)).asScala().toSet();
        state.close();
        TierTestUtils$.MODULE$.verifyFtpsEntries(reopenedState, (List<TierLogSegment>)segments, (scala.collection.immutable.Set<UUID>)segmentsDeleted, this.cleanupEnabled(), this.time().milliseconds());
        try (FileTierPartitionState reopenedState = new FileTierPartitionState(dir, logDirFailureChannel, tp, true, (Scheduler)this.time().scheduler, false, this.compactEnabled(), (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());){
            reopenedState.checkInvariants();
            Assertions.assertEquals((int)numSegmentsAfter, (int)reopenedState.numSegments());
            Assertions.assertEquals((long)BoxesRunTime.unboxToInt((Object)CollectionConverters$.MODULE$.IteratorHasAsScala(reopenedState.segments()).asScala().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.size())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)), (long)reopenedState.totalSize());
            Assertions.assertEquals((long)50L, (long)((TierLogSegment)CollectionConverters$.MODULE$.IteratorHasAsScala(reopenedState.segments()).asScala().next()).firstBatchTimestamp());
            Assertions.assertEquals((long)6L, (long)reopenedState.compactDirtyStartOffset());
            java.util.Set compactedObjectIds2 = CollectionConverters$.MODULE$.SetHasAsJava((Set)segmentsToClean2.map((Function1 & Serializable)x$8 -> x$8.metadata().objectId()).toSet()).asJava();
            UUID completeMessageId2 = UUID.randomUUID();
            TierCompactionCommitAndSwap compactComplete2 = new TierCompactionCommitAndSwap(compactInitiate2, completeMessageId2, compactedObjectIds2, newBaseOffset2, newEndOffset2, new CompactStats((long)newSize2, (long)newSize2, (long)newSize2));
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)reopenedState.append((AbstractTierMetadata)compactComplete2, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            TierTestUtils$.MODULE$.verifyFtpsEntries(reopenedState, null, null, this.cleanupEnabled(), this.time().milliseconds());
            reopenedState.checkInvariants();
            Assertions.assertEquals((long)14L, (long)reopenedState.compactDirtyStartOffset());
            Assertions.assertEquals((Object)CollectionConverters$.MODULE$.SetHasAsScala(compactedObjectIds2).asScala().toSet(), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(reopenedState.compactedSegments()).asScala().map((Function1 & Serializable)x$9 -> x$9.objectId())).toSet());
        }
        state.close();
        dir.delete();
        parentDir.delete();
    }

    @Test
    public void testCompactionFencing() {
        int numSegments = 5;
        int epoch = 0;
        IntRef offset = IntRef.create((int)0);
        ListBuffer rawObjectIds = new ListBuffer();
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            rawObjectIds.$plus$eq((Object)UUID.randomUUID());
            OffsetAndEpoch uploadStateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, (UUID)rawObjectIds.last(), (long)offset$2.elem, (long)(offset$2.elem + 1), 100L, (long)i, i, false, false, false, TierUploadType.Archive, uploadStateOffset, OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, (UUID)rawObjectIds.last(), uploadStateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            offset$2.elem += 2;
        });
        this.checkInvariants((TierPartitionState)this.state());
        int numSegmentsToCompact = 3;
        List segmentsToClean = CollectionConverters$.MODULE$.IteratorHasAsScala(this.state().segments()).asScala().take(numSegmentsToCompact).toList();
        Assertions.assertEquals((int)numSegments, (int)CollectionConverters$.MODULE$.IteratorHasAsScala(this.state().segments()).asScala().size());
        long firstBatchTimestamp = 50L;
        UUID newObjectId = UUID.randomUUID();
        long newBaseOffset = ((TierLogSegment)segmentsToClean.head()).baseOffset();
        long newEndOffset = ((TierLogSegment)segmentsToClean.last()).endOffset();
        long newMaxTimestamp = BoxesRunTime.unboxToLong((Object)segmentsToClean.map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.maxTimestamp())).max((Ordering)Ordering.Long$.MODULE$));
        int newSize = BoxesRunTime.unboxToInt((Object)segmentsToClean.map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.size())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        OffsetAndEpoch compactInitiateStateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((long)-1L, (long)this.state().compactDirtyStartOffset());
        TierSegmentUploadInitiate compactInitiate = new TierSegmentUploadInitiate(this.tpid(), epoch, newObjectId, newBaseOffset, newEndOffset, newMaxTimestamp, firstBatchTimestamp, newSize, false, false, false, TierUploadType.Compaction, compactInitiateStateOffset, OpaqueData.ZEROED);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)compactInitiate, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch + 1, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertTrue((boolean)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this.state().fencedSegments()).asScala().map((Function1 & Serializable)x$12 -> x$12.objectId())).toSet().contains((Object)compactInitiate.messageId()), (String)"compact initial segment should have been fenced");
        Assertions.assertEquals((int)numSegments, (int)CollectionConverters$.MODULE$.IteratorHasAsScala(this.state().segments()).asScala().size());
    }

    @Test
    public void testCompactionConcurrentDeletions() {
        int numSegments = 5;
        int epoch = 0;
        IntRef offset = IntRef.create((int)0);
        ListBuffer rawObjectIds = new ListBuffer();
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            rawObjectIds.$plus$eq((Object)UUID.randomUUID());
            OffsetAndEpoch uploadStateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, (UUID)rawObjectIds.last(), (long)offset$3.elem, (long)(offset$3.elem + 1), 100L, (long)i, i, false, false, false, TierUploadType.Archive, uploadStateOffset, OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, (UUID)rawObjectIds.last(), uploadStateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            offset$3.elem += 2;
        });
        this.checkInvariants((TierPartitionState)this.state());
        int numSegmentsToCompact = 3;
        List segmentsToClean = CollectionConverters$.MODULE$.IteratorHasAsScala(this.state().segments()).asScala().take(numSegmentsToCompact).toList();
        Assertions.assertEquals((int)numSegments, (int)CollectionConverters$.MODULE$.IteratorHasAsScala(this.state().segments()).asScala().size());
        long firstBatchTimestamp = 50L;
        UUID newObjectId = UUID.randomUUID();
        long newBaseOffset = ((TierLogSegment)segmentsToClean.head()).baseOffset();
        long newEndOffset = ((TierLogSegment)segmentsToClean.last()).endOffset();
        long newMaxTimestamp = BoxesRunTime.unboxToLong((Object)segmentsToClean.map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.maxTimestamp())).max((Ordering)Ordering.Long$.MODULE$));
        int newSize = BoxesRunTime.unboxToInt((Object)segmentsToClean.map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.size())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        OffsetAndEpoch compactInitiateStateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((long)-1L, (long)this.state().compactDirtyStartOffset());
        TierSegmentUploadInitiate compactInitiate = new TierSegmentUploadInitiate(this.tpid(), epoch, newObjectId, newBaseOffset, newEndOffset, newMaxTimestamp, firstBatchTimestamp, newSize, false, false, false, TierUploadType.Compaction, compactInitiateStateOffset, OpaqueData.ZEROED);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)compactInitiate, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        TierLogSegment deletableSegment = (TierLogSegment)segmentsToClean.head();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), epoch, deletableSegment.objectId(), this.state().lastLocalMaterializedSrcOffsetAndEpoch()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteComplete(this.tpid(), epoch, deletableSegment.objectId(), this.state().lastLocalMaterializedSrcOffsetAndEpoch(), this.time().milliseconds()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        this.checkInvariants((TierPartitionState)this.state());
        UUID completeMessageId = UUID.randomUUID();
        TierCompactionCommitAndSwap compactComplete = new TierCompactionCommitAndSwap(compactInitiate, completeMessageId, CollectionConverters$.MODULE$.SetHasAsJava((Set)segmentsToClean.map((Function1 & Serializable)x$15 -> x$15.objectId()).toSet()).asJava(), newBaseOffset, newEndOffset, new CompactStats((long)newSize, (long)newSize, (long)newSize));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)compactComplete, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((long)-1L, (long)this.state().compactDirtyStartOffset());
        TierTestUtils$.MODULE$.verifyFtpsEntries(this.state(), null, null, this.cleanupEnabled(), this.time().milliseconds());
    }

    @Test
    public void testFencePriorCompactedInitiateWithCommit() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 50L, 10);
        UUID objectId2 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId2, 25L, 150L, 20);
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((long)30L, (long)this.state().totalSize());
        Assertions.assertEquals((long)-1L, (long)this.state().compactDirtyStartOffset());
        HashSet<UUID> compactedObjects = new HashSet<UUID>();
        compactedObjects.add(objectId1);
        compactedObjects.add(objectId2);
        OffsetAndEpoch stateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        UUID objectIdCompacted = UUID.randomUUID();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectIdCompacted, 0L, 50L, 100L, 100L, 10, false, false, false, TierUploadType.Compaction, stateOffset, OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierCompactionCommitAndSwap(this.tpid(), 0, stateOffset, UUID.randomUUID(), compactedObjects, new HashSet(), 0L, 150L, new CompactStats(30L, 10L, 30L)), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)objectIdCompacted, (Object)((TierLogSegment)CollectionConverters$.MODULE$.CollectionHasAsScala(this.state().fencedSegments()).asScala().head()).objectId());
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((long)151L, (long)this.state().compactDirtyStartOffset());
        Assertions.assertEquals((long)0L, (long)this.state().totalSize());
        this.deleteInitiateAndComplete(0, objectId1, this.time().milliseconds());
        this.deleteInitiateAndComplete(0, objectId2, this.time().milliseconds());
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((long)0L, (long)this.state().totalSize());
        TierTestUtils$.MODULE$.verifyFtpsEntries(this.state(), null, null, this.cleanupEnabled(), this.time().milliseconds());
    }

    @Test
    public void testCompactionUploadInitiateChainingSuccess() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        UUID objectId3 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 10L, 100);
        this.uploadInitateAndComplete(0, objectId2, 11L, 20L, 100);
        this.uploadInitateAndComplete(0, objectId3, 21L, 30L, 100);
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)3, (int)this.state().numSegments());
        HashSet<UUID> sourceObjects = new HashSet<UUID>();
        sourceObjects.add(objectId1);
        UUID objectId4 = UUID.randomUUID();
        UUID objectId5 = UUID.randomUUID();
        HashSet<UUID> destObjects = new HashSet<UUID>();
        destObjects.add(objectId4);
        destObjects.add(objectId5);
        CompactStats compactStats = new CompactStats(100L, 40L, 60L);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId4, Optional.empty(), 0L, 9L, 50L, 50L, 30, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), OpaqueData.ZEROED, Optional.empty()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId5, Optional.of(objectId4), 6L, 10L, 100L, 100L, 30, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), OpaqueData.ZEROED, Optional.empty()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierCompactionCommitAndSwap(this.tpid(), 0, this.currentStateOffset(), UUID.randomUUID(), sourceObjects, destObjects, 0L, 100L, compactStats), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)4, (int)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler, this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)4, (int)reopenedState.numSegments());
        reopenedState.close();
    }

    @Test
    public void testCompactionUploadInitiateChainingPreviousObjectIdNotExpected() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 300L, 500);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId2, Optional.of(objectId1), 11L, 20L, 200L, 200L, 100, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), OpaqueData.ZEROED, Optional.empty()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)1, (int)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler, this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertTrue((TierPartitionStatus.ERROR.equals(reopenedState.status()) ? 1 : 0) != 0);
        reopenedState.close();
    }

    @Test
    public void testCompactionUploadInitiateChainingPreviousObjectIdNotMatching() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        UUID objectId3 = UUID.randomUUID();
        UUID objectId4 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 300L, 500);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId2, Optional.empty(), 0L, 10L, 100L, 100L, 100, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), OpaqueData.ZEROED, Optional.empty()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId3, Optional.of(objectId4), 11L, 20L, 200L, 200L, 100, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), OpaqueData.ZEROED, Optional.empty()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)1, (int)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler, this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertTrue((TierPartitionStatus.ERROR.equals(reopenedState.status()) ? 1 : 0) != 0);
        reopenedState.close();
    }

    @Test
    public void testUploadInitiateChainingUploadTypeNotMatching() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId1, Optional.empty(), 0L, 10L, 100L, 100L, 100, false, false, false, TierUploadType.Archive, this.currentStateOffset(), OpaqueData.ZEROED, Optional.empty()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId2, Optional.of(objectId1), 0L, 10L, 100L, 100L, 100, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), OpaqueData.ZEROED, Optional.empty()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)0, (int)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler, this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertTrue((TierPartitionStatus.ERROR.equals(reopenedState.status()) ? 1 : 0) != 0);
        reopenedState.close();
    }

    @Test
    public void testCompactionUploadCommitAndSwapFencingUploadInitiate() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        UUID objectId3 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 10L, 100);
        this.uploadInitateAndComplete(0, objectId2, 11L, 20L, 100);
        this.uploadInitateAndComplete(0, objectId3, 21L, 30L, 100);
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)3, (int)this.state().numSegments());
        UUID objectId4 = UUID.randomUUID();
        UUID objectId5 = UUID.randomUUID();
        HashSet<UUID> sourceObjects = new HashSet<UUID>();
        sourceObjects.add(objectId1);
        new HashSet<UUID>().add(objectId4);
        CompactStats compactStats = new CompactStats(100L, 40L, 60L);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId4, Optional.empty(), 0L, 10L, 50L, 50L, 30, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), OpaqueData.ZEROED, Optional.empty()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        HashSet<UUID> destObjects2 = new HashSet<UUID>();
        destObjects2.add(objectId5);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId5, Optional.empty(), 0L, 10L, 50L, 50L, 30, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), OpaqueData.ZEROED, Optional.empty()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierCompactionCommitAndSwap(this.tpid(), 0, this.currentStateOffset(), UUID.randomUUID(), sourceObjects, destObjects2, 0L, 100L, compactStats), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)3, (int)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler, this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)3, (int)reopenedState.numSegments());
        reopenedState.close();
    }

    @Test
    public void testCompactionUploadCommitAndSwapWithNonExistingSourceObjects() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        UUID objectId3 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 10L, 100);
        this.uploadInitateAndComplete(0, objectId2, 11L, 20L, 100);
        this.uploadInitateAndComplete(0, objectId3, 21L, 30L, 100);
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)3, (int)this.state().numSegments());
        UUID objectId4 = UUID.randomUUID();
        HashSet<UUID> sourceObjects = new HashSet<UUID>();
        sourceObjects.add(objectId1);
        HashSet<UUID> destObjects = new HashSet<UUID>();
        destObjects.add(objectId4);
        CompactStats compactStats = new CompactStats(100L, 40L, 60L);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId4, Optional.empty(), 0L, 20L, 50L, 50L, 30, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), OpaqueData.ZEROED, Optional.empty()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().appendUnhandled((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), 0, objectId1, this.currentStateOffset()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertThrows(IllegalStateException.class, () -> this.state().appendUnhandled((AbstractTierMetadata)new TierCompactionCommitAndSwap(this.tpid(), 0, this.currentStateOffset(), UUID.randomUUID(), (java.util.Set)sourceObjects, (java.util.Set)destObjects, 0L, 100L, compactStats), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)2, (int)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler, this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)2, (int)reopenedState.numSegments());
        reopenedState.close();
    }

    @Test
    public void testCompactionUploadCommitAndSwapWithNonContiguousSourceObjects() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        UUID objectId3 = UUID.randomUUID();
        UUID objectId4 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 10L, 100);
        this.uploadInitateAndComplete(0, objectId2, 11L, 20L, 100);
        this.uploadInitateAndComplete(0, objectId3, 21L, 30L, 100);
        this.uploadInitateAndComplete(0, objectId4, 31L, 40L, 100);
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)4, (int)this.state().numSegments());
        UUID objectId5 = UUID.randomUUID();
        HashSet<UUID> sourceObjects = new HashSet<UUID>();
        sourceObjects.add(objectId1);
        sourceObjects.add(objectId2);
        sourceObjects.add(objectId4);
        HashSet<UUID> destObjects = new HashSet<UUID>();
        destObjects.add(objectId5);
        CompactStats compactStats = new CompactStats(100L, 40L, 60L);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId5, Optional.empty(), 0L, 40L, 50L, 50L, 30, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), OpaqueData.ZEROED, Optional.empty()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertThrows(IllegalStateException.class, () -> this.state().appendUnhandled((AbstractTierMetadata)new TierCompactionCommitAndSwap(this.tpid(), 0, this.currentStateOffset(), UUID.randomUUID(), (java.util.Set)sourceObjects, (java.util.Set)destObjects, 0L, 100L, compactStats), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)4, (int)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler, this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)4, (int)reopenedState.numSegments());
        reopenedState.close();
    }

    @Test
    public void testCompactionUploadCommitAndSwapWithImpossibleOffsets() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        UUID objectId3 = UUID.randomUUID();
        UUID objectId4 = UUID.randomUUID();
        UUID objectId5 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 10L, 100);
        this.uploadInitateAndComplete(0, objectId2, 11L, 20L, 100);
        this.uploadInitateAndComplete(0, objectId3, 21L, 30L, 100);
        this.uploadInitateAndComplete(0, objectId4, 31L, 40L, 100);
        this.uploadInitateAndComplete(0, objectId5, 41L, 50L, 100);
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)5, (int)this.state().numSegments());
        HashSet<UUID> sourceObjects = new HashSet<UUID>();
        sourceObjects.add(objectId1);
        sourceObjects.add(objectId2);
        sourceObjects.add(objectId3);
        sourceObjects.add(objectId4);
        UUID objectId6 = UUID.randomUUID();
        HashSet<UUID> destObjects = new HashSet<UUID>();
        destObjects.add(objectId6);
        CompactStats compactStats = new CompactStats(100L, 40L, 60L);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId6, Optional.empty(), 0L, 41L, 50L, 50L, 30, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), OpaqueData.ZEROED, Optional.empty()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertThrows(IllegalStateException.class, () -> this.state().appendUnhandled((AbstractTierMetadata)new TierCompactionCommitAndSwap(this.tpid(), 0, this.currentStateOffset(), UUID.randomUUID(), (java.util.Set)sourceObjects, (java.util.Set)destObjects, 0L, 100L, compactStats), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)5, (int)this.state().numSegments());
        this.state().close();
        FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler, this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)5, (int)reopenedState.numSegments());
        reopenedState.close();
    }

    @Test
    public void testCompactionCommitAndSwapWithSmallerEndOffset() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectId1 = UUID.randomUUID();
        UUID objectId2 = UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 10L, 100);
        this.uploadInitateAndComplete(0, objectId2, 11L, 20L, 100);
        UUID objectId3 = UUID.randomUUID();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId3, Optional.empty(), 0L, 15L, 100L, 100L, 30, false, false, false, TierUploadType.Compaction, this.currentStateOffset(), OpaqueData.ZEROED, Optional.empty()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        this.state().flush();
        this.state().close();
        FileTierPartitionState reopenedState1 = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler, this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        Assertions.assertEquals((int)2, (int)reopenedState1.numSegments());
        HashSet<UUID> sourceObjects = new HashSet<UUID>();
        sourceObjects.add(objectId1);
        sourceObjects.add(objectId2);
        HashSet<UUID> destObjects = new HashSet<UUID>();
        destObjects.add(objectId3);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)reopenedState1.append((AbstractTierMetadata)new TierCompactionCommitAndSwap(this.tpid(), 0, this.currentStateOffset(), UUID.randomUUID(), sourceObjects, destObjects, 0L, 100L, CompactStats.EMPTY), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        SegmentState segment3 = (SegmentState)CollectionConverters$.MODULE$.ListHasAsScala(reopenedState1.segmentInMemoryMetadataRange(0L, 250L)).asScala().last();
        Assertions.assertEquals((Object)objectId3, (Object)segment3.objectId());
        Assertions.assertEquals((long)15L, (long)segment3.endOffset());
        CollectionConverters$.MODULE$.CollectionHasAsScala(reopenedState1.compactedSegments()).asScala().foreach((Function1 & Serializable)deletableSegment -> {
            FileTierPartitionStateCompactEnabledTest.$anonfun$testCompactionCommitAndSwapWithSmallerEndOffset$1(this, reopenedState1, deletableSegment);
            return BoxedUnit.UNIT;
        });
        UUID objectId4 = UUID.randomUUID();
        this.uploadInitateAndComplete(reopenedState1, 0, objectId4, 18L, 30L, 100, this.compactEnabled());
        reopenedState1.flush();
        reopenedState1.close();
        FileTierPartitionState reopenedState2 = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler, this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        Assertions.assertEquals((int)2, (int)reopenedState2.numSegments());
        Assertions.assertEquals((long)30L, (long)reopenedState2.endOffset());
        Assertions.assertEquals((long)30L, (long)reopenedState2.dataEndOffset());
        SegmentState segment4 = (SegmentState)CollectionConverters$.MODULE$.ListHasAsScala(reopenedState2.segmentInMemoryMetadataRange(0L, 30L)).asScala().last();
        Assertions.assertEquals((Object)objectId4, (Object)segment4.objectId());
        Assertions.assertEquals((long)21L, (long)segment4.baseOffset());
        Assertions.assertEquals((long)18L, (long)segment4.keyBaseOffset());
        Assertions.assertEquals((long)30L, (long)segment4.endOffset());
        HashSet<UUID> sourceObjects2 = new HashSet<UUID>();
        sourceObjects2.add(objectId3);
        sourceObjects2.add(objectId4);
        UUID objectId5 = UUID.randomUUID();
        this.compactionInitiateCommitAndSwap(reopenedState2, 0, UUID.randomUUID(), objectId5, sourceObjects2, 0L, 30L, 60, CompactStats.EMPTY);
        Assertions.assertTrue((boolean)reopenedState2.flush());
        Assertions.assertEquals((int)1, (int)reopenedState2.numSegments());
        reopenedState2.close();
        FileTierPartitionState reopenedState3 = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler, this.checksumEnabled(), this.compactEnabled(), (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        Assertions.assertEquals((int)1, (int)reopenedState3.numSegments());
        reopenedState3.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReloadingFTPSWithMissingCompactFields() {
        void randomPartitionLogDir_parentDir;
        File file = this.parentDir();
        TestUtils$ randomPartitionLogDir_this = TestUtils$.MODULE$;
        Object var15_2 = null;
        file = null;
        File dir2 = randomPartitionLogDir_this.randomPartitionForTopicLogDir((File)randomPartitionLogDir_parentDir, "kafka");
        TopicPartition tp2 = LocalLog$.MODULE$.parseTopicPartitionName(dir2);
        TopicIdPartition tpid2 = new TopicIdPartition(tp2.topic(), UUID.randomUUID(), tp2.partition());
        byte fileVersion = 8;
        FileTierPartitionState ftps = new FileTierPartitionState(dir2, this.logDirFailureChannel(), tp2, true, fileVersion, (Scheduler)this.time().scheduler, this.checksumEnabled(), false, (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        ftps.setTopicId(tpid2.topicId());
        ftps.beginCatchup();
        ftps.onCatchUpComplete();
        ftps.append((AbstractTierMetadata)new TierTopicInitLeader(tpid2, 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        this.snapshotInitiateAndComplete(ftps, 0, UUID.randomUUID(), 123L, this.snapshotInitiateAndComplete$default$5());
        this.uploadInitateAndComplete(ftps, 0, UUID.randomUUID(), 0L, 10L, 100, false);
        this.uploadInitateAndComplete(ftps, 0, UUID.randomUUID(), 11L, 20L, 100, false);
        this.snapshotInitiateAndComplete(ftps, 0, UUID.randomUUID(), 456L, this.snapshotInitiateAndComplete$default$5());
        ftps.flush();
        Optional header = FileTierPartitionState.readHeader((CheckedFileIO)ftps.checkedFileIO());
        FileTierPartitionIterator iterator = new FileTierPartitionIterator(tpid2, ftps.checkedFileIO(), ((Header)header.get()).size());
        TierObjectMetadata metadata1 = (TierObjectMetadata)iterator.next();
        Assertions.assertEquals((long)0L, (long)metadata1.baseOffset());
        Assertions.assertEquals((long)10L, (long)metadata1.endOffset());
        Assertions.assertFalse((boolean)metadata1.hasVirtualOffset());
        Assertions.assertFalse((boolean)metadata1.hasStateBeforeDeletion());
        TierObjectMetadata metadata2 = (TierObjectMetadata)iterator.next();
        Assertions.assertEquals((long)11L, (long)metadata2.baseOffset());
        Assertions.assertEquals((long)20L, (long)metadata2.endOffset());
        Assertions.assertFalse((boolean)metadata2.hasVirtualOffset());
        Assertions.assertFalse((boolean)metadata2.hasStateBeforeDeletion());
        Assertions.assertFalse((boolean)iterator.hasNext());
        ftps.close();
        FileTierPartitionState ftps2 = new FileTierPartitionState(dir2, this.logDirFailureChannel(), tp2, true, (Scheduler)this.time().scheduler, this.checksumEnabled(), true, (Time)this.time(), this.cleanupConfig(), this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        ftps2.flush();
        Optional header2 = FileTierPartitionState.readHeader((CheckedFileIO)ftps2.checkedFileIO());
        FileTierPartitionIterator iterator2 = new FileTierPartitionIterator(tpid2, ftps2.checkedFileIO(), ((Header)header2.get()).size());
        TierObjectMetadata metadata3 = (TierObjectMetadata)iterator2.next();
        Assertions.assertEquals((long)0L, (long)metadata3.baseOffset());
        Assertions.assertEquals((long)10L, (long)metadata3.endOffset());
        Assertions.assertTrue((boolean)metadata3.hasVirtualOffset());
        Assertions.assertTrue((boolean)metadata3.hasStateBeforeDeletion());
        TierObjectMetadata metadata4 = (TierObjectMetadata)iterator2.next();
        Assertions.assertEquals((long)11L, (long)metadata4.baseOffset());
        Assertions.assertEquals((long)20L, (long)metadata4.endOffset());
        Assertions.assertTrue((boolean)metadata4.hasVirtualOffset());
        Assertions.assertTrue((boolean)metadata4.hasStateBeforeDeletion());
        Assertions.assertFalse((boolean)iterator2.hasNext());
        ftps2.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFlushHeaderWithErrorStatus() {
        void flushedFilePath_checksumAlgorithm;
        void flushedFilePath_checksumAlgorithm2;
        void flushedFilePath_checksumAlgorithm3;
        void flushedFilePath_checksumAlgorithm4;
        void randomPartitionLogDir_parentDir;
        File file = this.parentDir();
        TestUtils$ randomPartitionLogDir_this = TestUtils$.MODULE$;
        Object var29_2 = null;
        file = null;
        File dir2 = randomPartitionLogDir_this.randomPartitionForTopicLogDir((File)randomPartitionLogDir_parentDir, "kafka");
        TopicPartition tp2 = LocalLog$.MODULE$.parseTopicPartitionName(dir2);
        TopicIdPartition tpid2 = new TopicIdPartition(tp2.topic(), UUID.randomUUID(), tp2.partition());
        byte fileVersion = 8;
        TierPartitionStateCleanupConfig cleanupConfig = new TierPartitionStateCleanupConfig(false, this.cleanupDelayMs(), (long)this.cleanupIntervalMs());
        FileTierPartitionState ftps = new FileTierPartitionState(dir2, this.logDirFailureChannel(), tp2, true, fileVersion, (Scheduler)this.time().scheduler, this.checksumEnabled(), false, (Time)this.time(), cleanupConfig, this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        ftps.setTopicId(tpid2.topicId());
        ftps.beginCatchup();
        ftps.onCatchUpComplete();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)ftps.append((AbstractTierMetadata)new TierTopicInitLeader(tpid2, 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        this.snapshotInitiateAndComplete(ftps, 0, UUID.randomUUID(), 123L, this.snapshotInitiateAndComplete$default$5());
        this.uploadInitateAndComplete(ftps, 0, UUID.randomUUID(), 0L, 10L, 100, false);
        this.uploadInitateAndComplete(ftps, 0, UUID.randomUUID(), 11L, 20L, 100, false);
        this.snapshotInitiateAndComplete(ftps, 0, UUID.randomUUID(), 456L, this.snapshotInitiateAndComplete$default$5());
        ftps.flush();
        long origHeaderSize = ((Header)FileTierPartitionState.readHeader((CheckedFileIO)ftps.checkedFileIO()).get()).size();
        FileTierPartitionIterator iterator = new FileTierPartitionIterator(tpid2, ftps.checkedFileIO(), origHeaderSize);
        TierObjectMetadata metadata1 = (TierObjectMetadata)iterator.next();
        Assertions.assertEquals((long)0L, (long)metadata1.baseOffset());
        Assertions.assertEquals((long)10L, (long)metadata1.endOffset());
        Assertions.assertFalse((boolean)metadata1.hasVirtualOffset());
        Assertions.assertFalse((boolean)metadata1.hasStateBeforeDeletion());
        TierObjectMetadata metadata2 = (TierObjectMetadata)iterator.next();
        Assertions.assertEquals((long)11L, (long)metadata2.baseOffset());
        Assertions.assertEquals((long)20L, (long)metadata2.endOffset());
        Assertions.assertFalse((boolean)metadata2.hasVirtualOffset());
        Assertions.assertFalse((boolean)metadata2.hasStateBeforeDeletion());
        Assertions.assertFalse((boolean)iterator.hasNext());
        ftps.close();
        Algorithm algorithm = this.checksumAlgorithm();
        String flushedFilePath_basePath = ftps.basePath();
        Object var31_14 = null;
        algorithm = null;
        long origFlushedFileSize = FileTierPartitionState.StateFileType.FLUSHED.filePath(flushedFilePath_basePath, (Algorithm)flushedFilePath_checksumAlgorithm4).toFile().length();
        FileTierPartitionState ftps2 = new FileTierPartitionState(dir2, this.logDirFailureChannel(), tp2, true, (Scheduler)this.time().scheduler, this.checksumEnabled(), true, (Time)this.time(), cleanupConfig, this.tierPartitionStateSnapshotEnabled(), this.brokerId());
        OffsetAndEpoch nextOffsetAndEpoch = new OffsetAndEpoch(20L, Optional.of(Predef$.MODULE$.int2Integer(5)));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)ftps2.append((AbstractTierMetadata)new TierTopicInitLeader(tpid2, 1, UUID.randomUUID(), 0), nextOffsetAndEpoch));
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)ftps2.status());
        Assertions.assertEquals((Object)nextOffsetAndEpoch, (Object)ftps2.lastLocalMaterializedSrcOffsetAndEpoch());
        Algorithm algorithm2 = this.checksumAlgorithm();
        String flushedFilePath_basePath2 = ftps2.basePath();
        Object var33_19 = null;
        algorithm2 = null;
        long newFlushedFileSizeBeforeFlush = FileTierPartitionState.StateFileType.FLUSHED.filePath(flushedFilePath_basePath2, (Algorithm)flushedFilePath_checksumAlgorithm3).toFile().length();
        Assertions.assertEquals((long)origFlushedFileSize, (long)newFlushedFileSizeBeforeFlush);
        OffsetAndEpoch invalidOffsetAndEpoch = new OffsetAndEpoch(19L, Optional.of(Predef$.MODULE$.int2Integer(6)));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)ftps2.append((AbstractTierMetadata)new TierTopicInitLeader(tpid2, 1, UUID.randomUUID(), 0), invalidOffsetAndEpoch));
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)ftps2.status());
        FileTierPartitionIterator iterator2 = new FileTierPartitionIterator(tpid2, ftps2.checkedFileIO(), ((Header)FileTierPartitionState.readHeader((CheckedFileIO)ftps2.checkedFileIO()).get()).size());
        TierObjectMetadata metadata3 = (TierObjectMetadata)iterator2.next();
        Assertions.assertEquals((long)0L, (long)metadata3.baseOffset());
        Assertions.assertEquals((long)10L, (long)metadata3.endOffset());
        Assertions.assertTrue((boolean)metadata3.hasVirtualOffset());
        Assertions.assertTrue((boolean)metadata3.hasStateBeforeDeletion());
        TierObjectMetadata metadata4 = (TierObjectMetadata)iterator2.next();
        Assertions.assertEquals((long)11L, (long)metadata4.baseOffset());
        Assertions.assertEquals((long)20L, (long)metadata4.endOffset());
        Assertions.assertTrue((boolean)metadata4.hasVirtualOffset());
        Assertions.assertTrue((boolean)metadata4.hasStateBeforeDeletion());
        Assertions.assertFalse((boolean)iterator2.hasNext());
        ftps2.flush();
        Algorithm algorithm3 = this.checksumAlgorithm();
        String flushedFilePath_basePath3 = ftps2.basePath();
        Object var35_26 = null;
        algorithm3 = null;
        Assertions.assertTrue((FileTierPartitionState.StateFileType.FLUSHED.filePath(flushedFilePath_basePath3, (Algorithm)flushedFilePath_checksumAlgorithm2).toFile().length() > newFlushedFileSizeBeforeFlush ? 1 : 0) != 0);
        Algorithm algorithm4 = this.checksumAlgorithm();
        String flushedFilePath_basePath4 = ftps2.basePath();
        Object var37_28 = null;
        algorithm4 = null;
        CheckedFileIO newFlushedFileChannel = CheckedFileIO.open((Path)FileTierPartitionState.StateFileType.FLUSHED.filePath(flushedFilePath_basePath4, (Algorithm)flushedFilePath_checksumAlgorithm), (OpenOption[])new OpenOption[]{StandardOpenOption.READ});
        Optional header2 = FileTierPartitionState.readHeader((CheckedFileIO)newFlushedFileChannel);
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)((Header)header2.get()).status());
        Assertions.assertEquals((Object)invalidOffsetAndEpoch, (Object)((Header)header2.get()).errorOffsetAndEpoch());
        long newHeaderSize = ((Header)header2.get()).size();
        Assertions.assertTrue((newHeaderSize > origHeaderSize ? 1 : 0) != 0);
        FileTierPartitionIterator iterator3 = new FileTierPartitionIterator(tpid2, newFlushedFileChannel, newHeaderSize);
        TierObjectMetadata metadata5 = (TierObjectMetadata)iterator3.next();
        Assertions.assertEquals((long)0L, (long)metadata5.baseOffset());
        Assertions.assertEquals((long)10L, (long)metadata5.endOffset());
        Assertions.assertFalse((boolean)metadata5.hasVirtualOffset());
        Assertions.assertTrue((boolean)metadata5.hasStateBeforeDeletion());
        TierObjectMetadata metadata6 = (TierObjectMetadata)iterator3.next();
        Assertions.assertEquals((long)11L, (long)metadata6.baseOffset());
        Assertions.assertEquals((long)20L, (long)metadata6.endOffset());
        Assertions.assertFalse((boolean)metadata6.hasVirtualOffset());
        Assertions.assertTrue((boolean)metadata6.hasStateBeforeDeletion());
        Assertions.assertFalse((boolean)iterator3.hasNext());
        newFlushedFileChannel.close();
        ftps2.close();
    }

    @Test
    public void testStateBeforeDeletion() {
        Assumptions.assumeTrue((boolean)this.compactEnabled());
        int tierEpoch = 0;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), tierEpoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        UUID objectUploadComplete = UUID.randomUUID();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), tierEpoch, objectUploadComplete, 0L, 1L, 100L, 10L, 10, false, false, false, TierUploadType.Archive, this.state().lastLocalMaterializedSrcOffsetAndEpoch(), OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), tierEpoch, objectUploadComplete, this.state().lastLocalMaterializedSrcOffsetAndEpoch()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Optional segmentState = this.state().previousMetadataBeforeOffset(100L);
        Assertions.assertEquals((Object)TierObjectMetadata.State.INVALID, (Object)((SegmentState)segmentState.get()).stateBeforeDeletion());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), tierEpoch, objectUploadComplete, this.state().lastLocalMaterializedSrcOffsetAndEpoch()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        segmentState = this.state().previousMetadataBeforeOffset(100L);
        Assertions.assertEquals((Object)objectUploadComplete, (Object)((SegmentState)segmentState.get()).objectId());
        Assertions.assertEquals((Object)TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, (Object)((SegmentState)segmentState.get()).stateBeforeDeletion());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteComplete(this.tpid(), tierEpoch, objectUploadComplete, this.state().lastLocalMaterializedSrcOffsetAndEpoch(), 100L), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        UUID objectFenced = UUID.randomUUID();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), tierEpoch, objectFenced, 2L, 3L, 100L, 10L, 10, false, false, false, TierUploadType.Archive, this.state().lastLocalMaterializedSrcOffsetAndEpoch(), OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), ++tierEpoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), tierEpoch, objectFenced, this.state().lastLocalMaterializedSrcOffsetAndEpoch()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        segmentState = this.state().previousMetadataBeforeOffset(100L);
        Assertions.assertEquals((Object)objectFenced, (Object)((SegmentState)segmentState.get()).objectId());
        Assertions.assertEquals((Object)TierObjectMetadata.State.SEGMENT_FENCED, (Object)((SegmentState)segmentState.get()).stateBeforeDeletion());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteComplete(this.tpid(), tierEpoch, objectFenced, this.state().lastLocalMaterializedSrcOffsetAndEpoch(), 100L), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReloadingFTPSWithMissingSnapshotFields() {
        void randomPartitionLogDir_parentDir;
        File file = this.parentDir();
        TestUtils$ randomPartitionLogDir_this = TestUtils$.MODULE$;
        Object var8_2 = null;
        file = null;
        File dir2 = randomPartitionLogDir_this.randomPartitionForTopicLogDir((File)randomPartitionLogDir_parentDir, "kafka");
        TopicPartition tp2 = LocalLog$.MODULE$.parseTopicPartitionName(dir2);
        TopicIdPartition tpid2 = new TopicIdPartition(tp2.topic(), UUID.randomUUID(), tp2.partition());
        byte fileVersion = 8;
        FileTierPartitionState ftps = new FileTierPartitionState(dir2, this.logDirFailureChannel(), tp2, true, fileVersion, (Scheduler)this.time().scheduler, this.checksumEnabled(), true, (Time)this.time(), this.cleanupConfig(), false, this.brokerId());
        ftps.setTopicId(tpid2.topicId());
        ftps.beginCatchup();
        ftps.onCatchUpComplete();
        ftps.append((AbstractTierMetadata)new TierTopicInitLeader(tpid2, 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        this.uploadInitateAndComplete(ftps, 0, UUID.randomUUID(), 0L, 10L, 100, true);
        this.uploadInitateAndComplete(ftps, 0, UUID.randomUUID(), 11L, 20L, 100, true);
        ftps.flush();
        Optional header = FileTierPartitionState.readHeader((CheckedFileIO)ftps.checkedFileIO());
        Assertions.assertEquals((Object)Header.SNAPSHOT_ID_EMPTY, (Object)((Header)header.get()).lastSnapshotId());
        Assertions.assertEquals((long)-1L, (long)((Header)header.get()).lastSnapshotTimestampMs());
        FileTierPartitionStateCompactEnabledTest.verifyEntries$1(new FileTierPartitionIterator(tpid2, ftps.checkedFileIO(), ((Header)header.get()).size()));
        UUID snapshotId = UUID.randomUUID();
        ftps = new FileTierPartitionState(dir2, this.logDirFailureChannel(), tp2, true, (Scheduler)this.time().scheduler, this.checksumEnabled(), true, (Time)this.time(), this.cleanupConfig(), true, this.brokerId());
        this.snapshotInitiateAndComplete(ftps, 0, UUID.randomUUID(), 123L, this.snapshotInitiateAndComplete$default$5());
        this.snapshotInitiateAndComplete(ftps, 0, snapshotId, 456L, this.snapshotInitiateAndComplete$default$5());
        ftps.flush();
        header = FileTierPartitionState.readHeader((CheckedFileIO)ftps.checkedFileIO());
        Assertions.assertEquals((Object)snapshotId, (Object)((Header)header.get()).lastSnapshotId());
        Assertions.assertEquals((long)456L, (long)((Header)header.get()).lastSnapshotTimestampMs());
        FileTierPartitionStateCompactEnabledTest.verifyEntries$1(new FileTierPartitionIterator(tpid2, ftps.checkedFileIO(), ((Header)header.get()).size()));
        ftps.close();
        ftps = new FileTierPartitionState(dir2, this.logDirFailureChannel(), tp2, true, (Scheduler)this.time().scheduler, this.checksumEnabled(), true, (Time)this.time(), this.cleanupConfig(), false, this.brokerId());
        this.snapshotInitiateAndComplete(ftps, 0, UUID.randomUUID(), 789L, false);
        ftps.flush();
        header = FileTierPartitionState.readHeader((CheckedFileIO)ftps.checkedFileIO());
        Assertions.assertEquals((Object)snapshotId, (Object)((Header)header.get()).lastSnapshotId());
        Assertions.assertEquals((long)456L, (long)((Header)header.get()).lastSnapshotTimestampMs());
        FileTierPartitionStateCompactEnabledTest.verifyEntries$1(new FileTierPartitionIterator(tpid2, ftps.checkedFileIO(), ((Header)header.get()).size()));
        ftps.close();
        ftps = new FileTierPartitionState(dir2, this.logDirFailureChannel(), tp2, true, fileVersion, (Scheduler)this.time().scheduler, this.checksumEnabled(), true, (Time)this.time(), this.cleanupConfig(), false, this.brokerId());
        ftps.flush();
        header = FileTierPartitionState.readHeader((CheckedFileIO)ftps.checkedFileIO());
        Assertions.assertEquals((Object)Header.SNAPSHOT_ID_EMPTY, (Object)((Header)header.get()).lastSnapshotId());
        Assertions.assertEquals((long)-1L, (long)((Header)header.get()).lastSnapshotTimestampMs());
        FileTierPartitionStateCompactEnabledTest.verifyEntries$1(new FileTierPartitionIterator(tpid2, ftps.checkedFileIO(), ((Header)header.get()).size()));
        ftps.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMetadataSnapshot() {
        void var7_7;
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        UUID snapshotId = UUID.randomUUID();
        OffsetAndEpoch stateOffset = this.currentStateOffset();
        TierMetadataSnapshotUploadInitiate snapshotUploadInitiate = new TierMetadataSnapshotUploadInitiate(this.tpid(), 0, snapshotId, stateOffset, 0);
        UUID segmentId = UUID.randomUUID();
        TierSegmentUploadInitiate segmentUploadInitiate = new TierSegmentUploadInitiate(this.tpid(), 0, segmentId, Optional.empty(), 0L, 100L, this.time().milliseconds(), 0L, 100, true, false, false, TierUploadType.Archive, stateOffset, OpaqueData.ZEROED, Optional.empty());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)segmentUploadInitiate, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)snapshotUploadInitiate, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Tuple2 tuple2 = (Tuple2)MetadataSnapshotTask$.MODULE$.searchSnapshotByUuid(snapshotId, this.snapshotsDir()).get();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        FileTierPartitionStateSnapshotObject metadata = (FileTierPartitionStateSnapshotObject)tuple2._2();
        TierMetadataSnapshotUploadComplete snapshotUploadComplete = new TierMetadataSnapshotUploadComplete(snapshotUploadInitiate, (FileTierPartitionStateSnapshotObject)var7_7, Optional.empty());
        OffsetAndEpoch expectedLastLocalMaterializedOffsetAndEpochBeforeSnapshot = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)snapshotUploadComplete, expectedLastLocalMaterializedOffsetAndEpochBeforeSnapshot));
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.state().status());
        File tmpProducerSnapshotFile = LogFileUtils.producerSnapshotFile((File)this.snapshotsDir().toFile(), (long)0L);
        File tmpTierStateFile = MergedLog$.MODULE$.tierStateFile(this.snapshotsDir().toFile(), 0L, "");
        Files.createFile(tmpProducerSnapshotFile.toPath(), new FileAttribute[0]);
        Files.createFile(tmpTierStateFile.toPath(), new FileAttribute[0]);
        this.state().close();
        TierPartitionState reopenedState = this.factory().initState(this.dir(), this.tp(), this.logConfig(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler, (Time)this.time());
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)reopenedState.status());
        Assertions.assertEquals((int)0, (int)reopenedState.tierEpoch());
        Assertions.assertEquals((Object)expectedLastLocalMaterializedOffsetAndEpochBeforeSnapshot, (Object)reopenedState.lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((long)var7_7.snapshotTimestampMs(), (long)reopenedState.lastSnapshotTimestampMs());
        Assertions.assertEquals((Object)snapshotId, (Object)reopenedState.lastSnapshotId());
        reopenedState.close();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)MetadataSnapshotTask$.MODULE$.searchSnapshotByUuid(snapshotId, this.snapshotsDir()));
        Assertions.assertTrue((boolean)tmpProducerSnapshotFile.exists());
        Assertions.assertTrue((boolean)tmpTierStateFile.exists());
    }

    public void checkInvariants(TierPartitionState state) {
        Assertions.assertEquals((long)BoxesRunTime.unboxToInt((Object)CollectionConverters$.MODULE$.IteratorHasAsScala(state.segments()).asScala().map((Function1 & Serializable)x$16 -> BoxesRunTime.boxToInteger((int)x$16.size())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)), (long)state.totalSize());
        List objectIds = CollectionConverters$.MODULE$.IteratorHasAsScala(state.segments()).asScala().map((Function1 & Serializable)x$17 -> x$17.objectId()).toList();
        Assertions.assertTrue((boolean)objectIds.toSet().intersect((Set)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(state.compactedSegments()).asScala().map((Function1 & Serializable)x$18 -> x$18.objectId())).toSet()).isEmpty(), (String)"No compacted segment should be in segments list");
        Assertions.assertEquals((int)objectIds.size(), (int)objectIds.toSet().size(), (String)"segments should not be contained in log view twice");
    }

    private static final short superBlockLen$1(Algorithm algorithm) {
        Algorithm algorithm2 = algorithm;
        Algorithm algorithm3 = Algorithm.ADLER;
        if (!(algorithm2 != null ? !algorithm2.equals(algorithm3) : algorithm3 != null)) {
            return 512;
        }
        return 0;
    }

    private final Header header$1(int tierEpoch, long endOffset) {
        return new Header(this.tpid().topicId(), this.state().version(), tierEpoch, TierPartitionStatus.INIT, -1L, endOffset, OffsetAndEpoch.EMPTY, OffsetAndEpoch.EMPTY, OffsetAndEpoch.EMPTY, OffsetAndEpoch.EMPTY, this.cleanupEnabled(), false, -1L, Header.SNAPSHOT_ID_EMPTY);
    }

    private final void writeHeader$1(Path path, Algorithm algorithm, int tierEpoch, long endOffset) {
        short superBlockLength = FileTierPartitionStateCompactEnabledTest.superBlockLen$1(algorithm);
        Files.deleteIfExists(path);
        CheckedFileIO.create((Path)path, (Algorithm)algorithm, (short)superBlockLength);
        CheckedFileIO channel = CheckedFileIO.open((Path)path, (boolean)true, (OpenOption[])new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE});
        FileTierPartitionState.writeHeader((CheckedFileIO)channel, (Header)this.header$1(tierEpoch, endOffset));
        channel.flush();
        Assertions.assertEquals((int)tierEpoch, (int)((Header)FileTierPartitionState.readHeader((CheckedFileIO)channel).get()).tierEpoch());
        channel.close();
    }

    private final void checkDifferentAlgorithmCombinations$1(int oldTierEpoch, long oldEndOffset, int newTierEpoch, long newEndOffset, boolean result) {
        new .colon.colon((Object)new Tuple2((Object)Algorithm.ADLER, (Object)Algorithm.NO_CHECKSUM), (List)new .colon.colon((Object)new Tuple2((Object)Algorithm.NO_CHECKSUM, (Object)Algorithm.ADLER), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)algo -> {
            this.compareTierStateFilesHelper((Algorithm)algo._1(), oldTierEpoch, oldEndOffset, (Algorithm)algo._2(), newTierEpoch, newEndOffset, result);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ String $anonfun$testCompacted$2(TierPartitionState.RecoveryOperation op$1, FileTierPartitionState state$1) {
        return new StringBuilder(26).append("Received RecoveryOp: ").append(op$1).append(" for ").append(state$1.topicIdPartition().get()).toString();
    }

    public static final /* synthetic */ void $anonfun$testCompacted$8(FileTierPartitionStateCompactEnabledTest $this, FileTierPartitionState state$1, TopicIdPartition tpid$1, int epoch$2, TierLogSegment deletableSegment) {
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state$1.append((AbstractTierMetadata)new TierSegmentDeleteInitiate(tpid$1, epoch$2, deletableSegment.objectId(), state$1.lastLocalMaterializedSrcOffsetAndEpoch()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        $this.checkInvariants((TierPartitionState)state$1);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state$1.append((AbstractTierMetadata)new TierSegmentDeleteComplete(tpid$1, epoch$2, deletableSegment.objectId(), state$1.lastLocalMaterializedSrcOffsetAndEpoch(), $this.time().milliseconds()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        $this.checkInvariants((TierPartitionState)state$1);
    }

    public static final /* synthetic */ void $anonfun$testCompactionCommitAndSwapWithSmallerEndOffset$1(FileTierPartitionStateCompactEnabledTest $this, FileTierPartitionState reopenedState1$1, TierLogSegment deletableSegment) {
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)reopenedState1$1.append((AbstractTierMetadata)new TierSegmentDeleteInitiate($this.tpid(), 0, deletableSegment.objectId(), reopenedState1$1.lastLocalMaterializedSrcOffsetAndEpoch()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        $this.checkInvariants((TierPartitionState)reopenedState1$1);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)reopenedState1$1.append((AbstractTierMetadata)new TierSegmentDeleteComplete($this.tpid(), 0, deletableSegment.objectId(), reopenedState1$1.lastLocalMaterializedSrcOffsetAndEpoch(), $this.time().milliseconds()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        $this.checkInvariants((TierPartitionState)reopenedState1$1);
    }

    private static final void verifyEntries$1(FileTierPartitionIterator iterator) {
        TierObjectMetadata metadata = (TierObjectMetadata)iterator.next();
        Assertions.assertEquals((long)0L, (long)metadata.baseOffset());
        Assertions.assertEquals((long)10L, (long)metadata.endOffset());
        metadata = (TierObjectMetadata)iterator.next();
        Assertions.assertEquals((long)11L, (long)metadata.baseOffset());
        Assertions.assertEquals((long)20L, (long)metadata.endOffset());
        Assertions.assertFalse((boolean)iterator.hasNext());
    }
}

