/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import com.google.common.io.ByteStreams;
import io.confluent.kafka.storage.checksum.Algorithm;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Properties;
import java.util.UUID;
import kafka.log.AbstractLog;
import kafka.log.TierLogSegment;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierPartitionFence;
import kafka.tier.domain.TierPartitionForceRestore;
import kafka.tier.domain.TierPartitionUnfreezeLogStartOffset;
import kafka.tier.state.BaseTierStateTest;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.SegmentAndMetadataLayout;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;
import kafka.tier.store.objects.metadata.TierStateRestoreSnapshotMetadata;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.topic.TierTopic;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015d\u0001\u0002\u0010 \u0001\u0019BQa\u000b\u0001\u0005\u00021BQA\f\u0001\u0005B=BqA\u000e\u0001A\u0002\u0013%q\u0007C\u0004<\u0001\u0001\u0007I\u0011\u0002\u001f\t\r\t\u0003\u0001\u0015)\u00039\u0011\u001d\u0019\u0005\u00011A\u0005\n]Bq\u0001\u0012\u0001A\u0002\u0013%Q\t\u0003\u0004H\u0001\u0001\u0006K\u0001\u000f\u0005\b\u0011\u0002\u0001\r\u0011\"\u00038\u0011\u001dI\u0005\u00011A\u0005\n)Ca\u0001\u0014\u0001!B\u0013A\u0004bB'\u0001\u0001\u0004%IA\u0014\u0005\b9\u0002\u0001\r\u0011\"\u0003^\u0011\u0019y\u0006\u0001)Q\u0005\u001f\"9\u0001\r\u0001b\u0001\n\u0013\t\u0007B\u00026\u0001A\u0003%!\rC\u0004l\u0001\t\u0007I\u0011B1\t\r1\u0004\u0001\u0015!\u0003c\u0011\u001di\u0007A1A\u0005\n\u0005DaA\u001c\u0001!\u0002\u0013\u0011\u0007bB8\u0001\u0005\u0004%I!\u0019\u0005\u0007a\u0002\u0001\u000b\u0011\u00022\t\u000fE\u0004\u0001\u0019!C\u0005e\"9a\u0010\u0001a\u0001\n\u0013y\bbBA\u0002\u0001\u0001\u0006Ka\u001d\u0005\b\u0003\u000b\u0001A\u0011AA\u0004\u0011\u001d\t9\u0005\u0001C\u0005\u0003\u0013Bq!!\u0016\u0001\t\u0013\t9\u0006C\u0004\u0002\\\u0001!I!!\u0018\u0003WI+7\u000f^8sK2{wm\u0015;beR|eMZ:fiB{7\u000f\u001e*fG>4XM]=PM\u0012\u000bG/\u0019+fgRT!\u0001I\u0011\u0002\u000bM$\u0018\r^3\u000b\u0005\t\u001a\u0013\u0001\u0002;jKJT\u0011\u0001J\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0005\u0005\u0002)S5\tq$\u0003\u0002+?\t\t\")Y:f)&,'o\u0015;bi\u0016$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005i\u0003C\u0001\u0015\u0001\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0016\u0003A\u0002\"!\r\u001b\u000e\u0003IR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\u00121!\u00138u\u0003EyG\u000e\u001a'pON#\u0018M\u001d;PM\u001a\u001cX\r^\u000b\u0002qA\u0011\u0011'O\u0005\u0003uI\u0012A\u0001T8oO\u0006)r\u000e\u001c3M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;`I\u0015\fHCA\u001fA!\t\td(\u0003\u0002@e\t!QK\\5u\u0011\u001d\tE!!AA\u0002a\n1\u0001\u001f\u00132\u0003IyG\u000e\u001a'pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0011\u0002\u001f=dG\rT8h\u000b:$wJ\u001a4tKR\f1c\u001c7e\u0019><WI\u001c3PM\u001a\u001cX\r^0%KF$\"!\u0010$\t\u000f\u0005;\u0011\u0011!a\u0001q\u0005\u0001r\u000e\u001c3M_\u001e,e\u000eZ(gMN,G\u000fI\u0001\u0012]\u0016<Hj\\4Ti\u0006\u0014Ho\u00144gg\u0016$\u0018!\u00068fo2{wm\u0015;beR|eMZ:fi~#S-\u001d\u000b\u0003{-Cq!\u0011\u0006\u0002\u0002\u0003\u0007\u0001(\u0001\noK^dunZ*uCJ$xJ\u001a4tKR\u0004\u0013\u0001\u00064jeN$8+Z4nK:$X*\u001a;bI\u0006$\u0018-F\u0001P!\r\t\u0004KU\u0005\u0003#J\u0012aa\u00149uS>t\u0007CA*[\u001b\u0005!&BA+W\u0003!iW\r^1eCR\f'BA,Y\u0003\u001dy'M[3diNT!!W\u0011\u0002\u000bM$xN]3\n\u0005m#&aE(cU\u0016\u001cGo\u0015;pe\u0016lU\r^1eCR\f\u0017\u0001\u00074jeN$8+Z4nK:$X*\u001a;bI\u0006$\u0018m\u0018\u0013fcR\u0011QH\u0018\u0005\b\u00036\t\t\u00111\u0001P\u0003U1\u0017N]:u'\u0016<W.\u001a8u\u001b\u0016$\u0018\rZ1uC\u0002\nac\u00197p]\u0016$g)\u001b:tiN+w-\\3oi\u001aKG.Z\u000b\u0002EB\u00111\r[\u0007\u0002I*\u0011QMZ\u0001\u0003S>T\u0011aZ\u0001\u0005U\u00064\u0018-\u0003\u0002jI\n!a)\u001b7f\u0003]\u0019Gn\u001c8fI\u001aK'o\u001d;TK\u001elWM\u001c;GS2,\u0007%A\u0011dY>tW\r\u001a$jeN$8+Z4nK:$xJ\u001a4tKRLe\u000eZ3y\r&dW-\u0001\u0012dY>tW\r\u001a$jeN$8+Z4nK:$xJ\u001a4tKRLe\u000eZ3y\r&dW\rI\u0001%G2|g.\u001a3GSJ\u001cHoU3h[\u0016tG\u000fV5nKN$\u0018-\u001c9J]\u0012,\u0007PR5mK\u0006)3\r\\8oK\u00124\u0015N]:u'\u0016<W.\u001a8u)&lWm\u001d;b[BLe\u000eZ3y\r&dW\rI\u0001\u0014G2|g.\u001a3US\u0016\u00148\u000b^1uK\u001aKG.Z\u0001\u0015G2|g.\u001a3US\u0016\u00148\u000b^1uK\u001aKG.\u001a\u0011\u00025QLWM\u001d)beRLG/[8o'R\fG/\u001a$jY\u0016\u0004\u0016\r\u001e5\u0016\u0003M\u0004\"\u0001^>\u000f\u0005UL\bC\u0001<3\u001b\u00059(B\u0001=&\u0003\u0019a$o\\8u}%\u0011!PM\u0001\u0007!J,G-\u001a4\n\u0005ql(AB*ue&twM\u0003\u0002{e\u0005qB/[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\r&dW\rU1uQ~#S-\u001d\u000b\u0004{\u0005\u0005\u0001bB!\u0019\u0003\u0003\u0005\ra]\u0001\u001ci&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$XMR5mKB\u000bG\u000f\u001b\u0011\u0002WQ,7\u000f\u001e*fgR|'/\u001a'pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e)pgR\u0014VmY8wKJLxJ\u001a#bi\u0006$2!PA\u0005\u0011\u0019\tYA\u0007a\u0001g\u00061\u0011/^8sk6DsAGA\b\u0003O\tI\u0003\u0005\u0003\u0002\u0012\u0005\rRBAA\n\u0015\u0011\t)\"a\u0006\u0002\rA\f'/Y7t\u0015\u0011\tI\"a\u0007\u0002\u000f),\b/\u001b;fe*!\u0011QDA\u0010\u0003\u0015QWO\\5u\u0015\t\t\t#A\u0002pe\u001eLA!!\n\u0002\u0014\t\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u0003\u0003W\t!e\u001f3jgBd\u0017-\u001f(b[\u0016lhf_1sOVlWM\u001c;t/&$\bNT1nKNl\bf\u0002\u000e\u00020\u0005m\u0012Q\b\t\u0005\u0003c\t9$\u0004\u0002\u00024)!\u0011QGA\n\u0003!\u0001(o\u001c<jI\u0016\u0014\u0018\u0002BA\u001d\u0003g\u00111BV1mk\u0016\u001cv.\u001e:dK\u000691\u000f\u001e:j]\u001e\u001cH\u0006BA \u0003\u0007\n#!!\u0011\u0002\u0005i\\\u0017EAA#\u0003\u0015Y'/\u00194u\u00031\"W\r\\3uK\u001aK'o\u001d;US\u0016\u0014X\rZ*fO6,g\u000e^!oIZ\u000bG.\u001b3bi\u0016tUm^(gMN,G\u000fF\u0003>\u0003\u0017\ny\u0005\u0003\u0004\u0002Nm\u0001\r\u0001M\u0001\u0007Y\u0016\fG-\u001a:\t\u000f\u0005E3\u00041\u0001\u0002T\u0005Yam\u001c7m_^,'o\u00149u!\r\t\u0004\u000bM\u0001,E\u0006\u001c7.\u001e9GSJ\u001cHoU3h[\u0016tG/\u00118e)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$XMR5mKR\u0019Q(!\u0017\t\r\u00055C\u00041\u00011\u0003U\u0011XmY8wKJdunZ*uCJ$xJ\u001a4tKR$R!PA0\u0003CBa!!\u0014\u001e\u0001\u0004\u0001\u0004BBA2;\u0001\u0007\u0001'\u0001\u0005g_2dwn^3s\u0001")
public class RestoreLogStartOffsetPostRecoveryOfDataTest
extends BaseTierStateTest {
    private long oldLogStartOffset = 0L;
    private long oldLogEndOffset = 0L;
    private long newLogStartOffset = 0L;
    private Option<ObjectStoreMetadata> firstSegmentMetadata = None$.MODULE$;
    private final File clonedFirstSegmentFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
    private final File clonedFirstSegmentOffsetIndexFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
    private final File clonedFirstSegmentTimestampIndexFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
    private final File clonedTierStateFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
    private String tierPartitionStateFilePath = "";

    @Override
    public int brokerCount() {
        return 3;
    }

    private long oldLogStartOffset() {
        return this.oldLogStartOffset;
    }

    private void oldLogStartOffset_$eq(long x$1) {
        this.oldLogStartOffset = x$1;
    }

    private long oldLogEndOffset() {
        return this.oldLogEndOffset;
    }

    private void oldLogEndOffset_$eq(long x$1) {
        this.oldLogEndOffset = x$1;
    }

    private long newLogStartOffset() {
        return this.newLogStartOffset;
    }

    private void newLogStartOffset_$eq(long x$1) {
        this.newLogStartOffset = x$1;
    }

    private Option<ObjectStoreMetadata> firstSegmentMetadata() {
        return this.firstSegmentMetadata;
    }

    private void firstSegmentMetadata_$eq(Option<ObjectStoreMetadata> x$1) {
        this.firstSegmentMetadata = x$1;
    }

    private File clonedFirstSegmentFile() {
        return this.clonedFirstSegmentFile;
    }

    private File clonedFirstSegmentOffsetIndexFile() {
        return this.clonedFirstSegmentOffsetIndexFile;
    }

    private File clonedFirstSegmentTimestampIndexFile() {
        return this.clonedFirstSegmentTimestampIndexFile;
    }

    private File clonedTierStateFile() {
        return this.clonedTierStateFile;
    }

    private String tierPartitionStateFilePath() {
        return this.tierPartitionStateFilePath;
    }

    private void tierPartitionStateFilePath_$eq(String x$1) {
        this.tierPartitionStateFilePath = x$1;
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testRestoreLogStartOffsetPostRecoveryOfData(String quorum) {
        void var4_4;
        void var3_3;
        Tuple2<Object, Object> tuple2 = this.createTopicAndGetReplicas();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int replica1 = tuple2._1$mcI$sp();
        int replica2 = tuple2._2$mcI$sp();
        this.appendMessagesAndWaitUntilTieredAndSynced((int)var3_3, (int)var4_4);
        this.waitForHotSetRetentionToKickIn((List<Object>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{var3_3, var4_4}))));
        this.fetchTieredAndLocalDataAndValidate((int)var3_3, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var4_4)));
        this.backupFirstSegmentAndTierPartitionStateFile((int)var3_3);
        this.deleteFirstTieredSegmentAndValidateNewOffset((int)var3_3, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var4_4)));
        this.fetchTieredAndLocalDataAndValidate((int)var3_3, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var4_4)));
        this.recoverLogStartOffset((int)var3_3, (int)var4_4);
        this.fetchTieredAndLocalDataAndValidate((int)var3_3, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var4_4)));
        this.deleteFirstTieredSegmentAndValidateNewOffset((int)var3_3, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var4_4)));
        this.appendMessagesAndWaitUntilTieredAndSynced((int)var3_3, (int)var4_4);
        this.fetchTieredAndLocalDataAndValidate((int)var3_3, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var4_4)));
        this.switchLeader((int)var3_3, (int)var4_4);
        this.deleteFirstTieredSegmentAndValidateNewOffset((int)var4_4, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var3_3)));
        this.appendMessagesAndWaitUntilTieredAndSynced((int)var4_4, (int)var3_3);
        this.fetchTieredAndLocalDataAndValidate((int)var4_4, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var3_3)));
        int replica3 = this.addReplicaToAssignment((int)var4_4);
        ((KafkaBroker)this.brokerForId((int)var3_3).get()).shutdown();
        ((KafkaBroker)this.brokerForId((int)var3_3).get()).awaitShutdown();
        this.switchLeader((int)var4_4, replica3);
        this.deleteFirstTieredSegmentAndValidateNewOffset(replica3, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var4_4)));
        this.appendMessagesAndWaitUntilTieredAndSynced(replica3, (int)var4_4);
        this.fetchTieredAndLocalDataAndValidate(replica3, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var4_4)));
    }

    /*
     * WARNING - void declaration
     */
    private void deleteFirstTieredSegmentAndValidateNewOffset(int leader, Option<Object> followerOpt) {
        AbstractLog leaderLog = (AbstractLog)((KafkaBroker)this.brokerForId(leader).get()).replicaManager().getLog(this.topicPartition()).get();
        String oldRetentionBytes = this.getTopicConfig(this.topicPartition().topic()).get("retention.bytes").value();
        Iterator segments = leaderLog.tierPartitionState().segments();
        Assertions.assertTrue((boolean)segments.hasNext());
        long newRetentionSize = leaderLog.size() - (long)((TierLogSegment)segments.next()).size();
        segments = leaderLog.tierPartitionState().segments();
        this.newLogStartOffset_$eq(((TierLogSegment)segments.next()).endOffset() + 1L);
        this.changeTopicConfig("retention.bytes", Long.toString(newRetentionSize), this.changeTopicConfig$default$3());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$deleteFirstTieredSegmentAndValidateNewOffset$1(this, leaderLog)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$deleteFirstTieredSegmentAndValidateNewOffset$2(this, leaderLog));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)this.newLogStartOffset(), (long)leaderLog.logStartOffset());
        if (followerOpt.isDefined()) {
            AbstractLog followerLog = (AbstractLog)((KafkaBroker)this.brokerForId(BoxesRunTime.unboxToInt((Object)followerOpt.get())).get()).replicaManager().getLog(this.topicPartition()).get();
            long l2 = 100L;
            long waitUntilTrue_waitTimeMs2 = 60000L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$deleteFirstTieredSegmentAndValidateNewOffset$3(this, followerLog)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                    Assertions.fail((String)RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$deleteFirstTieredSegmentAndValidateNewOffset$4(this, leaderLog));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
            }
            long l3 = 100L;
            long waitUntilTrue_waitTimeMs3 = 60000L;
            long waitUntilTrue_startTime3 = System.currentTimeMillis();
            while (!RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$deleteFirstTieredSegmentAndValidateNewOffset$5(this, followerLog)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                    Assertions.fail((String)RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$deleteFirstTieredSegmentAndValidateNewOffset$6(this, followerLog));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
            }
        }
        this.changeTopicConfig("retention.bytes", oldRetentionBytes, this.changeTopicConfig$default$3());
    }

    private void backupFirstSegmentAndTierPartitionStateFile(int leader) {
        ReplicaManager leaderReplicaManager = ((KafkaBroker)this.brokerForId(leader).get()).replicaManager();
        AbstractLog leaderLog = (AbstractLog)leaderReplicaManager.getLog(this.topicPartition()).get();
        this.oldLogStartOffset_$eq(leaderLog.logStartOffset());
        this.oldLogEndOffset_$eq(leaderLog.logEndOffset());
        Iterator segments = leaderLog.tierPartitionState().segments();
        Assertions.assertTrue((boolean)segments.hasNext());
        TierLogSegment firstSegment = (TierLogSegment)segments.next();
        this.firstSegmentMetadata_$eq((Option<ObjectStoreMetadata>)new Some((Object)new ObjectMetadata(firstSegment.metadata().topicIdPartition(), firstSegment.objectId(), leaderLog.tierPartitionState().tierEpoch(), firstSegment.baseOffset(), firstSegment.metadata().hasAbortedTxns(), firstSegment.metadata().hasProducerState(), firstSegment.metadata().hasEpochState(), firstSegment.metadata().opaqueData(), (SegmentAndMetadataLayout)firstSegment.metadata().segmentAndMetadataLayout().orElse(null))));
        TierObjectStore objectStore = (TierObjectStore)leaderReplicaManager.tierReplicaComponents().logComponents().objectStoreOpt().get();
        ByteStreams.copy((InputStream)objectStore.getObjectStoreFragment((ObjectStoreMetadata)this.firstSegmentMetadata().get(), FragmentType.SEGMENT).getInputStream(), (OutputStream)new FileOutputStream(this.clonedFirstSegmentFile()));
        ByteStreams.copy((InputStream)objectStore.getObjectStoreFragment((ObjectStoreMetadata)this.firstSegmentMetadata().get(), FragmentType.OFFSET_INDEX).getInputStream(), (OutputStream)new FileOutputStream(this.clonedFirstSegmentOffsetIndexFile()));
        ByteStreams.copy((InputStream)objectStore.getObjectStoreFragment((ObjectStoreMetadata)this.firstSegmentMetadata().get(), FragmentType.TIMESTAMP_INDEX).getInputStream(), (OutputStream)new FileOutputStream(this.clonedFirstSegmentTimestampIndexFile()));
        FileTierPartitionState fileTierPartitionState = (FileTierPartitionState)leaderLog.tierPartitionState();
        fileTierPartitionState.flush();
        this.tierPartitionStateFilePath_$eq(fileTierPartitionState.flushedPath());
        ByteStreams.copy((InputStream)new FileInputStream(this.tierPartitionStateFilePath()), (OutputStream)new FileOutputStream(this.clonedTierStateFile()));
    }

    /*
     * WARNING - void declaration
     */
    private void recoverLogStartOffset(int leader, int follower) {
        Producer tierProducer = RecoveryUtils.createTierTopicProducer((Properties)this.producerConfig(), (String)"RestoreLogStartOffsetPostRecoveryOfData");
        String tierTopicName = TierTopic.topicName((String)this.serverConfig().getProperty(KafkaConfig$.MODULE$.TierMetadataNamespaceProp()));
        int numTierTopicPartitions = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(this.serverConfig().getProperty(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp())));
        ReplicaManager leaderReplicaManager = ((KafkaBroker)this.brokerForId(leader).get()).replicaManager();
        AbstractLog leaderLog = (AbstractLog)leaderReplicaManager.getLog(this.topicPartition()).get();
        TierPartitionState leaderTierPartitionState = leaderLog.tierPartitionState();
        AbstractLog followerLog = (AbstractLog)((KafkaBroker)this.brokerForId(follower).get()).replicaManager().getLog(this.topicPartition()).get();
        TierPartitionState followerTierPartitionState = followerLog.tierPartitionState();
        TopicIdPartition topicIdPartition = (TopicIdPartition)leaderTierPartitionState.topicIdPartition().get();
        TierPartitionFence fencingEvent = new TierPartitionFence(topicIdPartition, UUID.randomUUID(), true);
        RecoveryUtils.injectTierTopicEvent((Producer)tierProducer, (AbstractTierMetadata)fencingEvent, (String)tierTopicName, (int)numTierTopicPartitions);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs = 30000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$recoverLogStartOffset$1(leaderTierPartitionState)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$recoverLogStartOffset$2(leaderTierPartitionState));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs2 = 30000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$recoverLogStartOffset$3(followerTierPartitionState)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$recoverLogStartOffset$4(leaderTierPartitionState));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs3 = 30000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!leaderLog.isFrozenLogStartOffsetState()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)"Timed out waiting for freezing log start offset on the leader after fencing.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs4 = 30000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!followerLog.isFrozenLogStartOffsetState()) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)"Timed out waiting for freezing log start offset on the follower after fencing.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)this.newLogStartOffset(), (long)leaderLog.logStartOffset());
        Assertions.assertEquals((long)this.newLogStartOffset(), (long)followerLog.logStartOffset());
        Assertions.assertEquals((long)this.oldLogEndOffset(), (long)leaderLog.logEndOffset());
        Assertions.assertEquals((long)this.oldLogEndOffset(), (long)followerLog.logEndOffset());
        TierObjectStore objectStore = (TierObjectStore)leaderReplicaManager.tierReplicaComponents().logComponents().objectStoreOpt().get();
        objectStore.putObject((ObjectStoreMetadata)this.firstSegmentMetadata().get(), this.clonedFirstSegmentFile(), ObjectType.SEGMENT);
        objectStore.putObject((ObjectStoreMetadata)this.firstSegmentMetadata().get(), this.clonedFirstSegmentOffsetIndexFile(), ObjectType.OFFSET_INDEX);
        objectStore.putObject((ObjectStoreMetadata)this.firstSegmentMetadata().get(), this.clonedFirstSegmentTimestampIndexFile(), ObjectType.TIMESTAMP_INDEX);
        OffsetAndEpoch restoreOffsetAndEpoch = leaderTierPartitionState.lastLocalMaterializedSrcOffsetAndEpoch();
        TierPartitionForceRestore restoreEvent = new TierPartitionForceRestore(topicIdPartition, UUID.randomUUID(), this.oldLogStartOffset(), this.oldLogEndOffset(), restoreOffsetAndEpoch, "", Predef$.MODULE$.boolean2Boolean(true), Predef$.MODULE$.Byte2byte(Algorithm.NO_CHECKSUM.id));
        TierStateRestoreSnapshotMetadata restoreMetadata = new TierStateRestoreSnapshotMetadata(restoreEvent);
        objectStore.putObject((ObjectStoreMetadata)restoreMetadata, this.clonedTierStateFile(), ObjectType.TIER_STATE_SNAPSHOT);
        RecoveryUtils.injectTierTopicEvent((Producer)tierProducer, (AbstractTierMetadata)restoreEvent, (String)tierTopicName, (int)numTierTopicPartitions);
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs5 = 30000L;
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$recoverLogStartOffset$9(this, leaderLog)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$recoverLogStartOffset$10(this, leaderLog));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), (long)waitUntilTrue_pause));
        }
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs6 = 30000L;
        long waitUntilTrue_startTime6 = System.currentTimeMillis();
        while (!RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$recoverLogStartOffset$11(this, followerLog)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime6 + waitUntilTrue_waitTimeMs6) {
                Assertions.fail((String)RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$recoverLogStartOffset$12(this, leaderLog));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs6), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)TierPartitionStatus.FROZEN_LOG_START_OFFSET, (Object)leaderTierPartitionState.status());
        Assertions.assertEquals((Object)TierPartitionStatus.FROZEN_LOG_START_OFFSET, (Object)followerTierPartitionState.status());
        Assertions.assertTrue((boolean)leaderLog.isFrozenLogStartOffsetState());
        Assertions.assertTrue((boolean)followerLog.isFrozenLogStartOffsetState());
        Assertions.assertEquals((long)this.oldLogEndOffset(), (long)leaderLog.logEndOffset());
        Assertions.assertEquals((long)this.oldLogEndOffset(), (long)followerLog.logEndOffset());
        TierPartitionUnfreezeLogStartOffset unfreezeMetadata = new TierPartitionUnfreezeLogStartOffset(topicIdPartition, UUID.randomUUID());
        RecoveryUtils.injectTierTopicEvent((Producer)tierProducer, (AbstractTierMetadata)unfreezeMetadata, (String)tierTopicName, (int)numTierTopicPartitions);
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs7 = 30000L;
        long waitUntilTrue_startTime7 = System.currentTimeMillis();
        while (!RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$recoverLogStartOffset$13(leaderTierPartitionState)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime7 + waitUntilTrue_waitTimeMs7) {
                Assertions.fail((String)RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$recoverLogStartOffset$14(leaderTierPartitionState));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs7), (long)waitUntilTrue_pause));
        }
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs8 = 30000L;
        long waitUntilTrue_startTime8 = System.currentTimeMillis();
        while (!RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$recoverLogStartOffset$15(followerTierPartitionState)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime8 + waitUntilTrue_waitTimeMs8) {
                Assertions.fail((String)RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$recoverLogStartOffset$16(leaderTierPartitionState));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs8), (long)waitUntilTrue_pause));
        }
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs9 = 30000L;
        long waitUntilTrue_startTime9 = System.currentTimeMillis();
        while (!RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$recoverLogStartOffset$17(leaderLog)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime9 + waitUntilTrue_waitTimeMs9) {
                Assertions.fail((String)"Timed out waiting for unfreezing log start offset on the leader after fencing.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs9), (long)waitUntilTrue_pause));
        }
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs10 = 30000L;
        long waitUntilTrue_startTime10 = System.currentTimeMillis();
        while (!RestoreLogStartOffsetPostRecoveryOfDataTest.$anonfun$recoverLogStartOffset$19(followerLog)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime10 + waitUntilTrue_waitTimeMs10) {
                Assertions.fail((String)"Timed out waiting for unfreezing log start offset on the follower after fencing.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs10), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)this.oldLogStartOffset(), (long)leaderLog.logStartOffset());
        Assertions.assertEquals((long)this.oldLogStartOffset(), (long)followerLog.logStartOffset());
        Assertions.assertEquals((long)this.oldLogEndOffset(), (long)leaderLog.logEndOffset());
        Assertions.assertEquals((long)this.oldLogEndOffset(), (long)followerLog.logEndOffset());
        tierProducer.close();
    }

    public static final /* synthetic */ boolean $anonfun$deleteFirstTieredSegmentAndValidateNewOffset$1(RestoreLogStartOffsetPostRecoveryOfDataTest $this, AbstractLog leaderLog$1) {
        return BoxesRunTime.equals(leaderLog$1.tierPartitionState().startOffset().get(), (Object)BoxesRunTime.boxToLong((long)$this.newLogStartOffset()));
    }

    public static final /* synthetic */ String $anonfun$deleteFirstTieredSegmentAndValidateNewOffset$2(RestoreLogStartOffsetPostRecoveryOfDataTest $this, AbstractLog leaderLog$1) {
        return new StringBuilder(96).append("Timed out waiting for records being deleted. Leader's tierPartitionState.StartOffset: ").append(leaderLog$1.tierPartitionState().startOffset().get()).append(" expected ").append($this.newLogStartOffset()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$deleteFirstTieredSegmentAndValidateNewOffset$3(RestoreLogStartOffsetPostRecoveryOfDataTest $this, AbstractLog followerLog$1) {
        return BoxesRunTime.equals(followerLog$1.tierPartitionState().startOffset().get(), (Object)BoxesRunTime.boxToLong((long)$this.newLogStartOffset()));
    }

    public static final /* synthetic */ String $anonfun$deleteFirstTieredSegmentAndValidateNewOffset$4(RestoreLogStartOffsetPostRecoveryOfDataTest $this, AbstractLog leaderLog$1) {
        return new StringBuilder(98).append("Timed out waiting for records being deleted. Follower's tierPartitionState.StartOffset: ").append(leaderLog$1.tierPartitionState().startOffset().get()).append(" expected ").append($this.newLogStartOffset()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$deleteFirstTieredSegmentAndValidateNewOffset$5(RestoreLogStartOffsetPostRecoveryOfDataTest $this, AbstractLog followerLog$1) {
        return $this.newLogStartOffset() == followerLog$1.logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$deleteFirstTieredSegmentAndValidateNewOffset$6(RestoreLogStartOffsetPostRecoveryOfDataTest $this, AbstractLog followerLog$1) {
        return new StringBuilder(108).append("Timed out waiting for follower's log start offset to catch up: Follower logStartOffset: ").append(followerLog$1.logStartOffset()).append(" ").append(" expected offset = ").append($this.newLogStartOffset()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$recoverLogStartOffset$1(TierPartitionState leaderTierPartitionState$1) {
        return TierPartitionStatus.FROZEN_LOG_START_OFFSET.equals(leaderTierPartitionState$1.status());
    }

    public static final /* synthetic */ String $anonfun$recoverLogStartOffset$2(TierPartitionState leaderTierPartitionState$1) {
        return new StringBuilder(111).append("Timed out waiting for tier partition state status after fencing. Leader's tierPartitionState.status: ").append(leaderTierPartitionState$1.status()).append(" expected ").append(TierPartitionStatus.FROZEN_LOG_START_OFFSET).toString();
    }

    public static final /* synthetic */ boolean $anonfun$recoverLogStartOffset$3(TierPartitionState followerTierPartitionState$1) {
        return TierPartitionStatus.FROZEN_LOG_START_OFFSET.equals(followerTierPartitionState$1.status());
    }

    public static final /* synthetic */ String $anonfun$recoverLogStartOffset$4(TierPartitionState leaderTierPartitionState$1) {
        return new StringBuilder(113).append("Timed out waiting for tier partition state status after fencing. Follower's tierPartitionState.status: ").append(leaderTierPartitionState$1.status()).append(" expected ").append(TierPartitionStatus.FROZEN_LOG_START_OFFSET).toString();
    }

    public static final /* synthetic */ boolean $anonfun$recoverLogStartOffset$5(AbstractLog leaderLog$2) {
        return leaderLog$2.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$recoverLogStartOffset$6() {
        return "Timed out waiting for freezing log start offset on the leader after fencing.";
    }

    public static final /* synthetic */ boolean $anonfun$recoverLogStartOffset$7(AbstractLog followerLog$2) {
        return followerLog$2.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$recoverLogStartOffset$8() {
        return "Timed out waiting for freezing log start offset on the follower after fencing.";
    }

    public static final /* synthetic */ boolean $anonfun$recoverLogStartOffset$9(RestoreLogStartOffsetPostRecoveryOfDataTest $this, AbstractLog leaderLog$2) {
        return $this.oldLogStartOffset() == leaderLog$2.logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$recoverLogStartOffset$10(RestoreLogStartOffsetPostRecoveryOfDataTest $this, AbstractLog leaderLog$2) {
        return new StringBuilder(103).append("Timed out waiting for updated log start offset after force restore. Leader's logStartOffset: ").append(leaderLog$2.logStartOffset()).append(" expected ").append($this.oldLogStartOffset()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$recoverLogStartOffset$11(RestoreLogStartOffsetPostRecoveryOfDataTest $this, AbstractLog followerLog$2) {
        return $this.oldLogStartOffset() == followerLog$2.logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$recoverLogStartOffset$12(RestoreLogStartOffsetPostRecoveryOfDataTest $this, AbstractLog leaderLog$2) {
        return new StringBuilder(105).append("Timed out waiting for updated log start offset after force restore. Follower's logStartOffset: ").append(leaderLog$2.logStartOffset()).append(" expected ").append($this.oldLogStartOffset()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$recoverLogStartOffset$13(TierPartitionState leaderTierPartitionState$1) {
        return TierPartitionStatus.ONLINE.equals(leaderTierPartitionState$1.status());
    }

    public static final /* synthetic */ String $anonfun$recoverLogStartOffset$14(TierPartitionState leaderTierPartitionState$1) {
        return new StringBuilder(112).append("Timed out waiting for tier partition state status after unfreeze. Leader's tierPartitionState.status: ").append(leaderTierPartitionState$1.status()).append(" expected ").append(TierPartitionStatus.ONLINE).toString();
    }

    public static final /* synthetic */ boolean $anonfun$recoverLogStartOffset$15(TierPartitionState followerTierPartitionState$1) {
        return TierPartitionStatus.ONLINE.equals(followerTierPartitionState$1.status());
    }

    public static final /* synthetic */ String $anonfun$recoverLogStartOffset$16(TierPartitionState leaderTierPartitionState$1) {
        return new StringBuilder(114).append("Timed out waiting for tier partition state status after unfreeze. Follower's tierPartitionState.status: ").append(leaderTierPartitionState$1.status()).append(" expected ").append(TierPartitionStatus.ONLINE).toString();
    }

    public static final /* synthetic */ boolean $anonfun$recoverLogStartOffset$17(AbstractLog leaderLog$2) {
        return !leaderLog$2.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$recoverLogStartOffset$18() {
        return "Timed out waiting for unfreezing log start offset on the leader after fencing.";
    }

    public static final /* synthetic */ boolean $anonfun$recoverLogStartOffset$19(AbstractLog followerLog$2) {
        return !followerLog$2.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$recoverLogStartOffset$20() {
        return "Timed out waiting for unfreezing log start offset on the follower after fencing.";
    }
}

