/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import kafka.tier.state.SegmentAndMetadataLayout;
import kafka.tier.state.SegmentAndMetadataLayoutTest;
import kafka.tier.store.objects.FragmentDescriptionWrapper;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ForAll;
import net.jqwik.api.Property;
import net.jqwik.api.Provide;
import net.jqwik.api.Tag;
import net.jqwik.api.constraints.Size;
import net.jqwik.api.constraints.UniqueElements;

@Tag(value="propertybased")
public class SegmentAndMetadataLayoutPropertyTest {
    private static final byte MAX_FRAGMENT_TYPE_BYTE = Arrays.stream(FragmentType.values()).map(FragmentType::getByte).max(Byte::compare).get();

    @Provide
    private Arbitrary<FragmentType> fragmentType() {
        return Arbitraries.of(FragmentType.class);
    }

    private Arbitrary<ObjectType> objectStoreObjectType() {
        return Arbitraries.of(ObjectType.class);
    }

    private Arbitrary<Integer> fragmentSize() {
        return Arbitraries.integers().between(0, Integer.MAX_VALUE);
    }

    private List<FragmentDescriptionWrapper> randomFragmentDescriptionsList(List<FragmentType> fragmentTypes) {
        int numFragmentsUploaded = fragmentTypes.size();
        List objectTypes = (List)this.objectStoreObjectType().list().ofSize(numFragmentsUploaded).sample();
        List fragmentSizes = (List)this.fragmentSize().list().ofSize(numFragmentsUploaded).sample();
        ArrayList<Long> filePositions = new ArrayList<Long>();
        HashMap<ObjectType, Long> filePositionsPerObjectType = new HashMap<ObjectType, Long>();
        for (int i = 0; i < numFragmentsUploaded; ++i) {
            ObjectType objectType = (ObjectType)objectTypes.get(i);
            int fragmentSize = (Integer)fragmentSizes.get(i);
            filePositions.add(filePositionsPerObjectType.getOrDefault(objectType, 0L));
            long updatedFilePosition = filePositionsPerObjectType.getOrDefault(objectType, 0L) + (long)fragmentSize;
            filePositionsPerObjectType.put(objectType, updatedFilePosition);
        }
        ArrayList<FragmentDescriptionWrapper> fragmentDescriptionsList = new ArrayList<FragmentDescriptionWrapper>();
        for (int i = 0; i < fragmentTypes.size(); ++i) {
            fragmentDescriptionsList.add(new FragmentDescriptionWrapper(fragmentTypes.get(i), (ObjectType)objectTypes.get(i), ((Long)filePositions.get(i)).longValue(), ((Integer)fragmentSizes.get(i)).intValue()));
        }
        return fragmentDescriptionsList;
    }

    @Property(tries=10000)
    public void testCreateSegmentAndMetadataLayoutForValidFragmentDescriptionList(@ForAll @Size(min=1, max=7) @UniqueElements @Size(min=1, max=7) @UniqueElements List<@ValidFragmentTypes FragmentType> fragmentTypes) {
        List<FragmentDescriptionWrapper> fragmentDescriptionsList = this.randomFragmentDescriptionsList(fragmentTypes);
        SegmentAndMetadataLayout segmentAndMetadataLayout = new SegmentAndMetadataLayout(fragmentDescriptionsList);
        SegmentAndMetadataLayoutTest.validateSegmentAndMetadataLayoutAgainstFragmentDescriptionList(segmentAndMetadataLayout, fragmentDescriptionsList);
        SegmentAndMetadataLayoutTest.validateFragmentsListsEqualToSourceListWithoutOrdering(segmentAndMetadataLayout, fragmentDescriptionsList);
    }

    @Target(value={ElementType.ANNOTATION_TYPE, ElementType.PARAMETER, ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Provide(value="FragmentType")
    public static @interface ValidFragmentTypes {
    }
}

