/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.SegmentAndMetadataLayout;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.objects.FragmentDescriptionWrapper;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SegmentAndMetadataLayoutTest {
    private SegmentAndMetadataLayout segmentAndMetadataLayout;
    private static final TopicIdPartition TOPIC_ID_PARTITION = new TopicIdPartition("test-topic", UUID.randomUUID(), 0);
    private static final int TIER_EPOCH = 0;
    private static final UUID OBJECT_ID = UUID.randomUUID();
    private static final Optional<UUID> PREVIOUS_OBJECT_ID = Optional.empty();
    private static final long BASE_OFFSET = 0L;
    private static final long END_OFFSET = 100L;
    private static final long MAX_TIMESTAMP = 20000L;
    private static final long FIRST_BATCH_TIMESTAMP = 10000L;
    private static final int SIZE = 100000000;
    private static final OffsetAndEpoch STATE_OFFSET = new OffsetAndEpoch(1000L, Optional.of(2));
    private final List<FragmentDescriptionWrapper> filePerFragmentList = Arrays.asList(new FragmentDescriptionWrapper(FragmentType.SEGMENT, ObjectType.SEGMENT, 0L, 100000000), new FragmentDescriptionWrapper(FragmentType.OFFSET_INDEX, ObjectType.OFFSET_INDEX, 0L, 1000), new FragmentDescriptionWrapper(FragmentType.TIMESTAMP_INDEX, ObjectType.TIMESTAMP_INDEX, 0L, 2000), new FragmentDescriptionWrapper(FragmentType.TRANSACTION_INDEX, ObjectType.TRANSACTION_INDEX, 0L, 500), new FragmentDescriptionWrapper(FragmentType.PRODUCER_STATE, ObjectType.PRODUCER_STATE, 0L, 1200), new FragmentDescriptionWrapper(FragmentType.EPOCH_STATE, ObjectType.EPOCH_STATE, 0L, 20));
    private final List<FragmentDescriptionWrapper> oneFileForAllFragmentsList = Arrays.asList(new FragmentDescriptionWrapper(FragmentType.HEADER, ObjectType.SEGMENT_WITH_METADATA, 0L, 1), new FragmentDescriptionWrapper(FragmentType.PRODUCER_STATE, ObjectType.SEGMENT_WITH_METADATA, 1L, 10), new FragmentDescriptionWrapper(FragmentType.EPOCH_STATE, ObjectType.SEGMENT_WITH_METADATA, 11L, 100), new FragmentDescriptionWrapper(FragmentType.TRANSACTION_INDEX, ObjectType.SEGMENT_WITH_METADATA, 111L, 1000), new FragmentDescriptionWrapper(FragmentType.OFFSET_INDEX, ObjectType.SEGMENT_WITH_METADATA, 1111L, 10000), new FragmentDescriptionWrapper(FragmentType.TIMESTAMP_INDEX, ObjectType.SEGMENT_WITH_METADATA, 11111L, 100000), new FragmentDescriptionWrapper(FragmentType.SEGMENT, ObjectType.SEGMENT_WITH_METADATA, 111111L, 100000000));
    private final List<List<FragmentDescriptionWrapper>> layoutsToTry = Arrays.asList(this.filePerFragmentList, this.oneFileForAllFragmentsList);

    @Test
    public void testCreateSegmentAndMetadataLayoutForSingleFilePerFragmentLayout() {
        this.segmentAndMetadataLayout = new SegmentAndMetadataLayout(this.filePerFragmentList);
        SegmentAndMetadataLayoutTest.validateSegmentAndMetadataLayoutAgainstFragmentDescriptionList(this.segmentAndMetadataLayout, this.filePerFragmentList);
        SegmentAndMetadataLayoutTest.validateFragmentsListsEqualToSourceListWithoutOrdering(this.segmentAndMetadataLayout, this.filePerFragmentList);
    }

    @Test
    public void testCreateSegmentAndMetadataLayoutForOneFileForAllFragmentsLayouts() {
        this.segmentAndMetadataLayout = new SegmentAndMetadataLayout(this.oneFileForAllFragmentsList);
        SegmentAndMetadataLayoutTest.validateSegmentAndMetadataLayoutAgainstFragmentDescriptionList(this.segmentAndMetadataLayout, this.oneFileForAllFragmentsList);
        SegmentAndMetadataLayoutTest.validateFragmentsListsEqualToSourceListWithoutOrdering(this.segmentAndMetadataLayout, this.oneFileForAllFragmentsList);
    }

    @Test
    public void testConstructorFailsOnInvalidMetadataLayoutInput() {
        List<FragmentDescriptionWrapper> invalidFragmentDescriptionListStartsAtNonzero = Arrays.asList(new FragmentDescriptionWrapper(FragmentType.HEADER, ObjectType.SEGMENT_WITH_METADATA, 1L, 1), new FragmentDescriptionWrapper(FragmentType.PRODUCER_STATE, ObjectType.SEGMENT_WITH_METADATA, 2L, 10), new FragmentDescriptionWrapper(FragmentType.EPOCH_STATE, ObjectType.SEGMENT_WITH_METADATA, 12L, 100), new FragmentDescriptionWrapper(FragmentType.TRANSACTION_INDEX, ObjectType.SEGMENT_WITH_METADATA, 112L, 1000), new FragmentDescriptionWrapper(FragmentType.OFFSET_INDEX, ObjectType.SEGMENT_WITH_METADATA, 1112L, 10000), new FragmentDescriptionWrapper(FragmentType.TIMESTAMP_INDEX, ObjectType.SEGMENT_WITH_METADATA, 11112L, 100000), new FragmentDescriptionWrapper(FragmentType.SEGMENT, ObjectType.SEGMENT_WITH_METADATA, 111112L, 100000000));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new SegmentAndMetadataLayout(invalidFragmentDescriptionListStartsAtNonzero));
        List<FragmentDescriptionWrapper> invalidFragmentDescriptionListGapBetweenFragments = Arrays.asList(new FragmentDescriptionWrapper(FragmentType.HEADER, ObjectType.SEGMENT_WITH_METADATA, 0L, 1), new FragmentDescriptionWrapper(FragmentType.PRODUCER_STATE, ObjectType.SEGMENT_WITH_METADATA, 2L, 10), new FragmentDescriptionWrapper(FragmentType.EPOCH_STATE, ObjectType.SEGMENT_WITH_METADATA, 12L, 100), new FragmentDescriptionWrapper(FragmentType.TRANSACTION_INDEX, ObjectType.SEGMENT_WITH_METADATA, 112L, 1000), new FragmentDescriptionWrapper(FragmentType.OFFSET_INDEX, ObjectType.SEGMENT_WITH_METADATA, 1112L, 10000), new FragmentDescriptionWrapper(FragmentType.TIMESTAMP_INDEX, ObjectType.SEGMENT_WITH_METADATA, 11112L, 100000), new FragmentDescriptionWrapper(FragmentType.SEGMENT, ObjectType.SEGMENT_WITH_METADATA, 111112L, 100000000));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new SegmentAndMetadataLayout(invalidFragmentDescriptionListGapBetweenFragments));
        List<FragmentDescriptionWrapper> invalidFragmentDescriptionListRepeatedFragment = Arrays.asList(new FragmentDescriptionWrapper(FragmentType.SEGMENT, ObjectType.SEGMENT, 0L, 100000000), new FragmentDescriptionWrapper(FragmentType.OFFSET_INDEX, ObjectType.OFFSET_INDEX, 0L, 1000), new FragmentDescriptionWrapper(FragmentType.TIMESTAMP_INDEX, ObjectType.TIMESTAMP_INDEX, 0L, 2000), new FragmentDescriptionWrapper(FragmentType.TRANSACTION_INDEX, ObjectType.TRANSACTION_INDEX, 0L, 500), new FragmentDescriptionWrapper(FragmentType.PRODUCER_STATE, ObjectType.PRODUCER_STATE, 0L, 1200), new FragmentDescriptionWrapper(FragmentType.EPOCH_STATE, ObjectType.EPOCH_STATE, 0L, 20), new FragmentDescriptionWrapper(FragmentType.EPOCH_STATE, ObjectType.SEGMENT_WITH_METADATA, 0L, 20));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new SegmentAndMetadataLayout(invalidFragmentDescriptionListRepeatedFragment));
        List<FragmentDescriptionWrapper> invalidFragmentDescriptionNegativeSize = Arrays.asList(new FragmentDescriptionWrapper(FragmentType.SEGMENT, ObjectType.SEGMENT, 0L, 100000000), new FragmentDescriptionWrapper(FragmentType.OFFSET_INDEX, ObjectType.OFFSET_INDEX, 0L, 1000), new FragmentDescriptionWrapper(FragmentType.TIMESTAMP_INDEX, ObjectType.TIMESTAMP_INDEX, 0L, 2000), new FragmentDescriptionWrapper(FragmentType.TRANSACTION_INDEX, ObjectType.TRANSACTION_INDEX, 0L, 500), new FragmentDescriptionWrapper(FragmentType.PRODUCER_STATE, ObjectType.PRODUCER_STATE, 0L, 1200), new FragmentDescriptionWrapper(FragmentType.EPOCH_STATE, ObjectType.EPOCH_STATE, 0L, 20), new FragmentDescriptionWrapper(FragmentType.EPOCH_STATE, ObjectType.SEGMENT_WITH_METADATA, 0L, -20));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new SegmentAndMetadataLayout(invalidFragmentDescriptionNegativeSize));
    }

    @Test
    public void testSerializeLayoutToSegmentUploadInitiateEventAndThenDeserialize() {
        for (List<FragmentDescriptionWrapper> fragmentDescriptionsList : this.layoutsToTry) {
            this.segmentAndMetadataLayout = new SegmentAndMetadataLayout(fragmentDescriptionsList);
            TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(TOPIC_ID_PARTITION, 0, OBJECT_ID, PREVIOUS_OBJECT_ID, 0L, 100L, 20000L, 10000L, 100000000, true, true, true, TierUploadType.Archive, STATE_OFFSET, OpaqueData.ZEROED, Optional.of(fragmentDescriptionsList));
            Optional reSerializedMetadataLayout = uploadInitiate.segmentAndMetadataLayout();
            Assertions.assertTrue((boolean)reSerializedMetadataLayout.isPresent());
            Assertions.assertEquals((Object)this.segmentAndMetadataLayout, reSerializedMetadataLayout.get());
        }
    }

    @Test
    public void testSerializeUploadInitiateEventWithNoSegmentAndMetadataLayoutPresent() {
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(TOPIC_ID_PARTITION, 0, OBJECT_ID, PREVIOUS_OBJECT_ID, 0L, 100L, 20000L, 10000L, 100000000, true, true, true, TierUploadType.Archive, STATE_OFFSET, OpaqueData.ZEROED, Optional.empty());
        Assertions.assertTrue((!uploadInitiate.segmentAndMetadataLayout().isPresent() ? 1 : 0) != 0);
    }

    static void validateFragmentsListsEqualToSourceListWithoutOrdering(SegmentAndMetadataLayout segmentAndMetadataLayout, List<FragmentDescriptionWrapper> sourceList) {
        List fragmentDescriptionList = segmentAndMetadataLayout.fragmentDescriptionsList();
        Assertions.assertTrue((boolean)fragmentDescriptionList.containsAll(sourceList), (String)"Not all elements of original FragmentDescription list are contained in list returned by segmentAndMetadataLayout");
        Assertions.assertTrue((boolean)sourceList.containsAll(fragmentDescriptionList), (String)"List returned by segmentAndMetadataLayout contains elements not in original FragmentDescription list");
    }

    static void validateSegmentAndMetadataLayoutAgainstFragmentDescriptionList(SegmentAndMetadataLayout segmentAndMetadataLayout, List<FragmentDescriptionWrapper> fragmentDescriptionsList) {
        for (FragmentDescriptionWrapper expectedFragmentDescription : fragmentDescriptionsList) {
            FragmentType fragmentType = expectedFragmentDescription.fragmentType();
            Optional actualFragmentDescriptionOpt = segmentAndMetadataLayout.getSegmentFragmentDescription(fragmentType);
            Assertions.assertTrue((boolean)actualFragmentDescriptionOpt.isPresent(), (String)String.format("Fragment type %s not found in segmentAndMetadataLayout despite being present in flat buffer input.", fragmentType.name()));
            FragmentDescriptionWrapper actualFragmentDescription = (FragmentDescriptionWrapper)actualFragmentDescriptionOpt.get();
            Assertions.assertEquals((Object)expectedFragmentDescription, (Object)actualFragmentDescription);
        }
    }
}

