/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.storage.blob.BlobAsyncClient;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobContainerClientBuilder;
import com.azure.storage.blob.BlobServiceAsyncClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobDownloadAsyncResponse;
import com.azure.storage.blob.models.BlobErrorCode;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.DownloadRetryOptions;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.blob.specialized.BlobAsyncClientBase;
import com.azure.storage.blob.specialized.BlobClientBase;
import com.azure.storage.blob.specialized.BlockBlobAsyncClient;
import com.azure.storage.blob.specialized.BlockBlobClient;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import kafka.tier.TopicIdPartition;
import kafka.tier.exceptions.TierObjectStoreFatalException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.AzureBlockBlobTierObjectStore;
import kafka.tier.store.AzureBlockBlobTierObjectStoreConfig;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;
import kafka.utils.Throttler;
import org.apache.directory.api.util.IOUtils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Ea\u0001\u0002\f\u0018\u0001yAQ!\n\u0001\u0005\u0002\u0019Bq!\u000b\u0001C\u0002\u0013\u0005!\u0006\u0003\u00043\u0001\u0001\u0006Ia\u000b\u0005\bg\u0001\u0001\r\u0011\"\u00015\u0011\u001dA\u0004\u00011A\u0005\u0002eBaa\u0010\u0001!B\u0013)\u0004\"\u0003!\u0001\u0001\u0004\u0005\r\u0011\"\u0001B\u0011%)\u0005\u00011AA\u0002\u0013\u0005a\tC\u0005I\u0001\u0001\u0007\t\u0011)Q\u0005\u0005\")\u0011\n\u0001C\u0001\u0015\")\u0001\f\u0001C\u0001\u0015\")Q\f\u0001C\u0001\u0015\")q\f\u0001C\u0001\u0015\")\u0011\r\u0001C\u0001\u0015\")1\r\u0001C\u0001\u0015\")Q\r\u0001C\u0001\u0015\")q\r\u0001C\u0001\u0015\")\u0011\u000e\u0001C\u0001\u0015\")1\u000e\u0001C\u0001Y\"1\u0011\u0011\u0002\u0001\u0005\u0002)Ca!!\u0004\u0001\t\u0003Q%!I!{kJ,'\t\\8dW\ncwN\u0019+jKJ|%M[3diN#xN]3UKN$(B\u0001\r\u001a\u0003\u0015\u0019Ho\u001c:f\u0015\tQ2$\u0001\u0003uS\u0016\u0014(\"\u0001\u000f\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\b\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00059\u0003C\u0001\u0015\u0001\u001b\u00059\u0012\u0001C7fi\u0006$\u0017\r^1\u0016\u0003-\u0002\"\u0001\f\u0019\u000e\u00035R!!\u000b\u0018\u000b\u0005=:\u0012aB8cU\u0016\u001cGo]\u0005\u0003c5\u0012ab\u00142kK\u000e$X*\u001a;bI\u0006$\u0018-A\u0005nKR\fG-\u0019;bA\u000511m\u001c8gS\u001e,\u0012!\u000e\t\u0003QYJ!aN\f\u0003G\u0005SXO]3CY>\u001c7N\u00117pERKWM](cU\u0016\u001cGo\u0015;pe\u0016\u001cuN\u001c4jO\u0006Q1m\u001c8gS\u001e|F%Z9\u0015\u0005ij\u0004C\u0001\u0011<\u0013\ta\u0014E\u0001\u0003V]&$\bb\u0002 \u0006\u0003\u0003\u0005\r!N\u0001\u0004q\u0012\n\u0014aB2p]\u001aLw\rI\u0001\f_\nTWm\u0019;Ti>\u0014X-F\u0001C!\tA3)\u0003\u0002E/\ti\u0012I_;sK\ncwnY6CY>\u0014G+[3s\u001f\nTWm\u0019;Ti>\u0014X-A\bpE*,7\r^*u_J,w\fJ3r)\tQt\tC\u0004?\u0011\u0005\u0005\t\u0019\u0001\"\u0002\u0019=\u0014'.Z2u'R|'/\u001a\u0011\u0002\u000bM,G/\u001e9\u0015\u0003iB#A\u0003'\u0011\u000553V\"\u0001(\u000b\u0005=\u0003\u0016aA1qS*\u0011\u0011KU\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0019F+A\u0003kk:LGOC\u0001V\u0003\ry'oZ\u0005\u0003/:\u0013!BQ3g_J,W)Y2i\u00035!Xm\u001d;HKR|%M[3di\"\u00121B\u0017\t\u0003\u001bnK!\u0001\u0018(\u0003\tQ+7\u000f^\u0001\u0013i\u0016\u001cHoR3u\u001f\nTWm\u0019;Bgft7\r\u000b\u0002\r5\u00061C/Z:u\u000f\u0016$xJ\u00196fGR4\u0015-\u001b7t/\",gn\u00142kK\u000e$\u0018j\u001d(pi\u001a{WO\u001c3)\u00055Q\u0016a\u000b;fgR<U\r^(cU\u0016\u001cGOR1jYN<\u0006.\u001a8PE*,7\r^%t\u001d>$hi\\;oI\u0006\u001b\u0018P\\2)\u00059Q\u0016!\t;fgR<U\r^(cU\u0016\u001cGO\u00117pEN#xN]1hK\u0016C8-\u001a9uS>t\u0007FA\b[\u0003\u0019\"Xm\u001d;HKR|%M[3di\ncwNY*u_J\fw-Z#yG\u0016\u0004H/[8o\u0003NLhn\u0019\u0015\u0003!i\u000bQ\u0004^3ti\u001e+Go\u00142kK\u000e$(+\u001e8uS6,W\t_2faRLwN\u001c\u0015\u0003#i\u000b!\u0005^3ti\u001e+Go\u00142kK\u000e$(+\u001e8uS6,W\t_2faRLwN\\!ts:\u001c\u0007F\u0001\n[\u00039!Xm\u001d;QkR\u001cVmZ7f]R$\"AO7\t\u000b9\u001c\u0002\u0019A8\u0002\u0017%\u001cH\u000b\u001b:piRdW\r\u001a\t\u0003AAL!!]\u0011\u0003\u000f\t{w\u000e\\3b]\"\u00121c\u001d\t\u0003i^l\u0011!\u001e\u0006\u0003mB\u000ba\u0001]1sC6\u001c\u0018B\u0001=v\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f\u001e\u0015\u0007'i\f\t!a\u0001\u0011\u0005mtX\"\u0001?\u000b\u0005u,\u0018\u0001\u00039s_ZLG-\u001a:\n\u0005}d(a\u0003,bYV,7k\\;sG\u0016\f\u0001BY8pY\u0016\fgn\u001d\u0017\u0005\u0003\u000b\t9!G\u0001\u00023\u0005\u0001\u0011!\u0005;fgR$U\r\\3uKN+w-\\3oi\"\u0012ACW\u0001(i\u0016\u001cH\u000fR3mKR,7+Z4nK:$x\u000b[3o\u00032dg)\u001b7fg\u0006\u0013X\r\u0015:fg\u0016tG\u000f\u000b\u0002\u00165\u0002")
public class AzureBlockBlobTierObjectStoreTest {
    private final ObjectMetadata metadata = new ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, OpaqueData.ZEROED, null);
    private AzureBlockBlobTierObjectStoreConfig config = AzureBlockBlobTierObjectStoreConfig.createWithEmptyClusterIdBrokerId(Optional.empty(), Optional.empty(), (String)"bucket", (String)"prefix", (int)0);
    private AzureBlockBlobTierObjectStore objectStore;

    public ObjectMetadata metadata() {
        return this.metadata;
    }

    public AzureBlockBlobTierObjectStoreConfig config() {
        return this.config;
    }

    public void config_$eq(AzureBlockBlobTierObjectStoreConfig x$1) {
        this.config = x$1;
    }

    public AzureBlockBlobTierObjectStore objectStore() {
        return this.objectStore;
    }

    public void objectStore_$eq(AzureBlockBlobTierObjectStore x$1) {
        this.objectStore = x$1;
    }

    @BeforeEach
    public void setup() {
        BlobServiceClient serviceClient = new BlobServiceClientBuilder().connectionString("DefaultEndpointsProtocol=https;AccountName=name;AccountKey=key").buildClient();
        BlobServiceAsyncClient serviceAsyncClient = (BlobServiceAsyncClient)Mockito.mock(BlobServiceAsyncClient.class);
        BlobContainerClient containerClient = new BlobContainerClientBuilder().endpoint("https://azure-storage-non-existent.com").buildClient();
        BlobContainerAsyncClient containerAsyncClient = (BlobContainerAsyncClient)Mockito.mock(BlobContainerAsyncClient.class);
        this.objectStore_$eq((AzureBlockBlobTierObjectStore)Mockito.spy((Object)new AzureBlockBlobTierObjectStore(this.config(), serviceClient, containerClient, serviceAsyncClient, containerAsyncClient)));
    }

    @Test
    public void testGetObject() {
        ((AzureBlockBlobTierObjectStore)Mockito.doAnswer(arg_0 -> AzureBlockBlobTierObjectStoreTest.$anonfun$testGetObject$1(new ByteArrayInputStream("test stream data".getBytes()), arg_0)).when((Object)this.objectStore())).getInputStreamFromBlobClient((BlobClient)ArgumentMatchers.any(BlobClient.class), (BlobRange)ArgumentMatchers.any(BlobRange.class));
        TierObjectStoreResponse response = this.objectStore().getObjectStoreFragment((ObjectStoreMetadata)this.metadata(), FragmentType.SEGMENT);
        Assertions.assertEquals((Object)"test stream data", (Object)IOUtils.toString((InputStream)response.getInputStream(), (Charset)Charset.defaultCharset()));
    }

    @Test
    public void testGetObjectAsync() {
        BlobAsyncClient blobAsyncClient = (BlobAsyncClient)Mockito.mock(BlobAsyncClient.class);
        ((BlobContainerAsyncClient)Mockito.doAnswer(x$3 -> blobAsyncClient).when((Object)this.objectStore().blobContainerAsyncClient)).getBlobAsyncClient(ArgumentMatchers.anyString());
        BlockBlobAsyncClient blockBlobAsyncClient = (BlockBlobAsyncClient)Mockito.mock(BlockBlobAsyncClient.class);
        ((BlobAsyncClient)Mockito.doAnswer(x$4 -> blockBlobAsyncClient).when((Object)blobAsyncClient)).getBlockBlobAsyncClient();
        String testData = "test stream data";
        ArrayList<ByteBuffer> list = new ArrayList<ByteBuffer>();
        list.add(ByteBuffer.wrap(testData.getBytes()));
        Flux singleFlux = Flux.fromIterable(list);
        ((BlobAsyncClientBase)Mockito.doAnswer(arg_0 -> AzureBlockBlobTierObjectStoreTest.$anonfun$testGetObjectAsync$3(Mono.just((Object)new BlobDownloadAsyncResponse(null, 200, null, singleFlux, null)), arg_0)).when((Object)blockBlobAsyncClient)).downloadStreamWithResponse((BlobRange)ArgumentMatchers.any(BlobRange.class), (DownloadRetryOptions)ArgumentMatchers.eq(null), (BlobRequestConditions)ArgumentMatchers.any(BlobRequestConditions.class), ArgumentMatchers.anyBoolean());
        TierObjectStoreResponse response0 = (TierObjectStoreResponse)this.objectStore().getObjectStoreFragmentAsync((ObjectStoreMetadata)this.metadata(), FragmentType.SEGMENT).get();
        Assertions.assertEquals((Object)testData, (Object)IOUtils.toString((InputStream)response0.getInputStream(), (Charset)Charset.defaultCharset()));
        list.clear();
        list.add(ByteBuffer.wrap("test ".getBytes()));
        list.add(ByteBuffer.wrap("stream ".getBytes()));
        list.add(ByteBuffer.wrap("data".getBytes()));
        Flux multiFlux = Flux.fromIterable(list);
        ((BlobAsyncClientBase)Mockito.doAnswer(arg_0 -> AzureBlockBlobTierObjectStoreTest.$anonfun$testGetObjectAsync$4(Mono.just((Object)new BlobDownloadAsyncResponse(null, 200, null, multiFlux, null)), arg_0)).when((Object)blockBlobAsyncClient)).downloadStreamWithResponse((BlobRange)ArgumentMatchers.any(BlobRange.class), (DownloadRetryOptions)ArgumentMatchers.eq(null), (BlobRequestConditions)ArgumentMatchers.any(BlobRequestConditions.class), ArgumentMatchers.anyBoolean());
        TierObjectStoreResponse response1 = (TierObjectStoreResponse)this.objectStore().getObjectStoreFragmentAsync((ObjectStoreMetadata)this.metadata(), FragmentType.SEGMENT).get();
        Assertions.assertEquals((Object)testData, (Object)IOUtils.toString((InputStream)response1.getInputStream(), (Charset)Charset.defaultCharset()));
    }

    @Test
    public void testGetObjectFailsWhenObjectIsNotFound() {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set(HttpHeaderName.fromString((String)"x-ms-error-code"), BlobErrorCode.BLOB_NOT_FOUND.toString());
        HttpResponse httpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        BlobStorageException exception = new BlobStorageException("Blob not found", httpResponse, new Object());
        Mockito.when((Object)httpResponse.getHeaders()).thenReturn((Object)httpHeaders);
        ((AzureBlockBlobTierObjectStore)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)this.objectStore())).getInputStreamFromBlobClient((BlobClient)ArgumentMatchers.any(BlobClient.class), (BlobRange)ArgumentMatchers.any(BlobRange.class));
        Assertions.assertThrows(TierObjectStoreFatalException.class, () -> this.objectStore().getObjectStoreFragment((ObjectStoreMetadata)this.metadata(), FragmentType.SEGMENT));
    }

    @Test
    public void testGetObjectFailsWhenObjectIsNotFoundAsync() {
        BlobAsyncClient blobAsyncClient = (BlobAsyncClient)Mockito.mock(BlobAsyncClient.class);
        ((BlobContainerAsyncClient)Mockito.doAnswer(x$7 -> blobAsyncClient).when((Object)this.objectStore().blobContainerAsyncClient)).getBlobAsyncClient(ArgumentMatchers.anyString());
        BlockBlobAsyncClient blockBlobAsyncClient = (BlockBlobAsyncClient)Mockito.mock(BlockBlobAsyncClient.class);
        ((BlobAsyncClient)Mockito.doAnswer(x$8 -> blockBlobAsyncClient).when((Object)blobAsyncClient)).getBlockBlobAsyncClient();
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set(HttpHeaderName.fromString((String)"x-ms-error-code"), BlobErrorCode.BLOB_NOT_FOUND.toString());
        HttpResponse httpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        BlobStorageException exception = new BlobStorageException("Blob not found", httpResponse, new Object());
        Mockito.when((Object)httpResponse.getHeaders()).thenReturn((Object)httpHeaders);
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally((Throwable)exception);
        ((BlobAsyncClientBase)Mockito.doAnswer(arg_0 -> AzureBlockBlobTierObjectStoreTest.$anonfun$testGetObjectFailsWhenObjectIsNotFoundAsync$3(Mono.fromFuture(future), arg_0)).when((Object)blockBlobAsyncClient)).downloadStreamWithResponse((BlobRange)ArgumentMatchers.any(BlobRange.class), (DownloadRetryOptions)ArgumentMatchers.eq(null), (BlobRequestConditions)ArgumentMatchers.any(BlobRequestConditions.class), ArgumentMatchers.anyBoolean());
        try {
            this.objectStore().getObjectStoreFragmentAsync((ObjectStoreMetadata)this.metadata(), FragmentType.SEGMENT).get();
            return;
        }
        catch (Throwable e) {
            Assertions.assertTrue((boolean)(e instanceof ExecutionException));
            Throwable child = e.getCause();
            Assertions.assertTrue((boolean)(child instanceof TierObjectStoreFatalException));
            Assertions.assertEquals((Object)exception, (Object)child.getCause());
            return;
        }
    }

    @Test
    public void testGetObjectBlobStorageException() {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set(HttpHeaderName.fromString((String)"x-ms-error-code"), BlobErrorCode.INTERNAL_ERROR.toString());
        HttpResponse httpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        BlobStorageException exception = new BlobStorageException("Internal Error", httpResponse, new Object());
        Mockito.when((Object)httpResponse.getHeaders()).thenReturn((Object)httpHeaders);
        ((AzureBlockBlobTierObjectStore)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)this.objectStore())).getInputStreamFromBlobClient((BlobClient)ArgumentMatchers.any(BlobClient.class), (BlobRange)ArgumentMatchers.any(BlobRange.class));
        Assertions.assertThrows(TierObjectStoreRetriableException.class, () -> this.objectStore().getObjectStoreFragment((ObjectStoreMetadata)this.metadata(), FragmentType.SEGMENT));
    }

    @Test
    public void testGetObjectBlobStorageExceptionAsync() {
        BlobAsyncClient blobAsyncClient = (BlobAsyncClient)Mockito.mock(BlobAsyncClient.class);
        ((BlobContainerAsyncClient)Mockito.doAnswer(x$10 -> blobAsyncClient).when((Object)this.objectStore().blobContainerAsyncClient)).getBlobAsyncClient(ArgumentMatchers.anyString());
        BlockBlobAsyncClient blockBlobAsyncClient = (BlockBlobAsyncClient)Mockito.mock(BlockBlobAsyncClient.class);
        ((BlobAsyncClient)Mockito.doAnswer(x$11 -> blockBlobAsyncClient).when((Object)blobAsyncClient)).getBlockBlobAsyncClient();
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set(HttpHeaderName.fromString((String)"x-ms-error-code"), BlobErrorCode.INTERNAL_ERROR.toString());
        HttpResponse httpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
        BlobStorageException exception = new BlobStorageException("Internal Error", httpResponse, new Object());
        Mockito.when((Object)httpResponse.getHeaders()).thenReturn((Object)httpHeaders);
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally((Throwable)exception);
        ((BlobAsyncClientBase)Mockito.doAnswer(arg_0 -> AzureBlockBlobTierObjectStoreTest.$anonfun$testGetObjectBlobStorageExceptionAsync$3(Mono.fromFuture(future), arg_0)).when((Object)blockBlobAsyncClient)).downloadStreamWithResponse((BlobRange)ArgumentMatchers.any(BlobRange.class), (DownloadRetryOptions)ArgumentMatchers.eq(null), (BlobRequestConditions)ArgumentMatchers.any(BlobRequestConditions.class), ArgumentMatchers.anyBoolean());
        try {
            this.objectStore().getObjectStoreFragmentAsync((ObjectStoreMetadata)this.metadata(), FragmentType.SEGMENT).get();
            return;
        }
        catch (Throwable e) {
            Assertions.assertTrue((boolean)(e instanceof ExecutionException));
            Throwable child = e.getCause();
            Assertions.assertTrue((boolean)(child instanceof TierObjectStoreRetriableException));
            Assertions.assertEquals((Object)exception, (Object)child.getCause());
            return;
        }
    }

    @Test
    public void testGetObjectRuntimeException() {
        RuntimeException exception = new RuntimeException();
        ((AzureBlockBlobTierObjectStore)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)this.objectStore())).getInputStreamFromBlobClient((BlobClient)ArgumentMatchers.any(BlobClient.class), (BlobRange)ArgumentMatchers.any(BlobRange.class));
        Assertions.assertThrows(TierObjectStoreRetriableException.class, () -> this.objectStore().getObjectStoreFragment((ObjectStoreMetadata)this.metadata(), FragmentType.SEGMENT));
    }

    @Test
    public void testGetObjectRuntimeExceptionAsync() {
        BlobAsyncClient blobAsyncClient = (BlobAsyncClient)Mockito.mock(BlobAsyncClient.class);
        ((BlobContainerAsyncClient)Mockito.doAnswer(x$13 -> blobAsyncClient).when((Object)this.objectStore().blobContainerAsyncClient)).getBlobAsyncClient(ArgumentMatchers.anyString());
        BlockBlobAsyncClient blockBlobAsyncClient = (BlockBlobAsyncClient)Mockito.mock(BlockBlobAsyncClient.class);
        ((BlobAsyncClient)Mockito.doAnswer(x$14 -> blockBlobAsyncClient).when((Object)blobAsyncClient)).getBlockBlobAsyncClient();
        RuntimeException exception = new RuntimeException();
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(exception);
        ((BlobAsyncClientBase)Mockito.doAnswer(arg_0 -> AzureBlockBlobTierObjectStoreTest.$anonfun$testGetObjectRuntimeExceptionAsync$3(Mono.fromFuture(future), arg_0)).when((Object)blockBlobAsyncClient)).downloadStreamWithResponse((BlobRange)ArgumentMatchers.any(BlobRange.class), (DownloadRetryOptions)ArgumentMatchers.eq(null), (BlobRequestConditions)ArgumentMatchers.any(BlobRequestConditions.class), ArgumentMatchers.anyBoolean());
        try {
            this.objectStore().getObjectStoreFragmentAsync((ObjectStoreMetadata)this.metadata(), FragmentType.SEGMENT).get();
            return;
        }
        catch (Throwable e) {
            Assertions.assertTrue((boolean)(e instanceof ExecutionException));
            Throwable child = e.getCause();
            Assertions.assertTrue((boolean)(child instanceof TierObjectStoreRetriableException));
            Assertions.assertEquals((Object)exception, (Object)child.getCause());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testPutSegment(boolean isThrottled) {
        void tempFile_contents;
        void tempFile_suffix;
        void tempFile_contents2;
        void tempFile_suffix2;
        void tempFile_contents3;
        void tempFile_suffix3;
        BlobServiceClient blobServiceClient = (BlobServiceClient)Mockito.mock(BlobServiceClient.class);
        BlobContainerClient blobContainerClient = (BlobContainerClient)Mockito.mock(BlobContainerClient.class);
        BlobServiceAsyncClient blobServiceAsyncClient = (BlobServiceAsyncClient)Mockito.mock(BlobServiceAsyncClient.class);
        BlobContainerAsyncClient blobContainerAsyncClient = (BlobContainerAsyncClient)Mockito.mock(BlobContainerAsyncClient.class);
        AzureBlockBlobTierObjectStore objectStore = new AzureBlockBlobTierObjectStore(this.config(), blobServiceClient, blobContainerClient, blobServiceAsyncClient, blobContainerAsyncClient);
        BlobClient blobClient = (BlobClient)Mockito.mock(BlobClient.class);
        Mockito.when((Object)blobContainerClient.getBlobClient((String)ArgumentMatchers.any())).thenReturn((Object)blobClient);
        ((BlobClient)Mockito.doNothing().when((Object)blobClient)).uploadFromFile((String)ArgumentMatchers.any(), (ParallelTransferOptions)ArgumentMatchers.any(), (BlobHttpHeaders)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (AccessTier)ArgumentMatchers.any(), (BlobRequestConditions)ArgumentMatchers.any(), (Duration)ArgumentMatchers.any());
        BlockBlobClient blockBlobClient = (BlockBlobClient)Mockito.mock(BlockBlobClient.class);
        Mockito.when((Object)blobClient.getBlockBlobClient()).thenReturn((Object)blockBlobClient);
        Mockito.when((Object)blockBlobClient.uploadWithResponse((InputStream)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (BlobHttpHeaders)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (AccessTier)ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (BlobRequestConditions)ArgumentMatchers.any(), (Duration)ArgumentMatchers.any(), (Context)ArgumentMatchers.any())).thenReturn(Mockito.mock(Response.class));
        String string = "abcd";
        String string2 = ObjectType.SEGMENT.suffix();
        String tempFile_prefix = "test";
        Object var12_11 = null;
        string2 = null;
        string = null;
        File segFile = TestUtils.tempFile((String)tempFile_prefix, (String)tempFile_suffix3, (String)tempFile_contents3);
        String string3 = "abcd";
        String string4 = ObjectType.OFFSET_INDEX.suffix();
        String tempFile_prefix2 = "test";
        Object var15_15 = null;
        string4 = null;
        string3 = null;
        File offsetIndexFile = TestUtils.tempFile((String)tempFile_prefix2, (String)tempFile_suffix2, (String)tempFile_contents2);
        String string5 = "abcd";
        String string6 = ObjectType.TIMESTAMP_INDEX.suffix();
        String tempFile_prefix3 = "test";
        Object var18_19 = null;
        string6 = null;
        string5 = null;
        File timeStampIndexFile = TestUtils.tempFile((String)tempFile_prefix3, (String)tempFile_suffix, (String)tempFile_contents);
        objectStore.putSegment(this.metadata(), segFile, offsetIndexFile, timeStampIndexFile, Optional.empty(), Optional.empty(), Optional.empty(), isThrottled ? Optional.of(Mockito.mock(Throttler.class)) : Optional.empty());
        if (isThrottled) {
            ((BlockBlobClient)Mockito.verify((Object)blockBlobClient, (VerificationMode)Mockito.times((int)3))).uploadWithResponse((InputStream)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()), (BlobHttpHeaders)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (AccessTier)ArgumentMatchers.any(), (byte[])ArgumentMatchers.any(), (BlobRequestConditions)ArgumentMatchers.any(), (Duration)ArgumentMatchers.any(), (Context)ArgumentMatchers.any());
        } else {
            ((BlobClient)Mockito.verify((Object)blobClient, (VerificationMode)Mockito.times((int)3))).uploadFromFile((String)ArgumentMatchers.any(), (ParallelTransferOptions)ArgumentMatchers.any(), (BlobHttpHeaders)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (AccessTier)ArgumentMatchers.any(), (BlobRequestConditions)ArgumentMatchers.any(), (Duration)ArgumentMatchers.any());
        }
        segFile.delete();
        offsetIndexFile.delete();
        timeStampIndexFile.delete();
    }

    @Test
    public void testDeleteSegment() {
        BlobServiceClient blobServiceClient = (BlobServiceClient)Mockito.mock(BlobServiceClient.class);
        BlobContainerClient blobContainerClient = (BlobContainerClient)Mockito.mock(BlobContainerClient.class);
        BlobServiceAsyncClient blobServiceAsyncClient = (BlobServiceAsyncClient)Mockito.mock(BlobServiceAsyncClient.class);
        BlobContainerAsyncClient blobContainerAsyncClient = (BlobContainerAsyncClient)Mockito.mock(BlobContainerAsyncClient.class);
        AzureBlockBlobTierObjectStore objectStore = new AzureBlockBlobTierObjectStore(this.config(), blobServiceClient, blobContainerClient, blobServiceAsyncClient, blobContainerAsyncClient);
        BlobClient blobClient = (BlobClient)Mockito.mock(BlobClient.class);
        Mockito.when((Object)blobContainerClient.getBlobClient((String)ArgumentMatchers.any())).thenReturn((Object)blobClient);
        ((BlobClientBase)Mockito.doNothing().when((Object)blobClient)).delete();
        objectStore.deleteSegment(this.metadata());
        ((BlobClientBase)Mockito.verify((Object)blobClient, (VerificationMode)Mockito.times((int)3))).delete();
    }

    @Test
    public void testDeleteSegmentWhenAllFilesArePresent() {
        ObjectMetadata metadataWithAllFiles = new ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, true, true, true, OpaqueData.ZEROED, null);
        BlobServiceClient blobServiceClient = (BlobServiceClient)Mockito.mock(BlobServiceClient.class);
        BlobContainerClient blobContainerClient = (BlobContainerClient)Mockito.mock(BlobContainerClient.class);
        BlobServiceAsyncClient blobServiceAsyncClient = (BlobServiceAsyncClient)Mockito.mock(BlobServiceAsyncClient.class);
        BlobContainerAsyncClient blobContainerAsyncClient = (BlobContainerAsyncClient)Mockito.mock(BlobContainerAsyncClient.class);
        AzureBlockBlobTierObjectStore objectStore = new AzureBlockBlobTierObjectStore(this.config(), blobServiceClient, blobContainerClient, blobServiceAsyncClient, blobContainerAsyncClient);
        BlobClient blobClient = (BlobClient)Mockito.mock(BlobClient.class);
        Mockito.when((Object)blobContainerClient.getBlobClient((String)ArgumentMatchers.any())).thenReturn((Object)blobClient);
        ((BlobClientBase)Mockito.doNothing().when((Object)blobClient)).delete();
        objectStore.deleteSegment(metadataWithAllFiles);
        ((BlobClientBase)Mockito.verify((Object)blobClient, (VerificationMode)Mockito.times((int)6))).delete();
    }

    public static final /* synthetic */ ByteArrayInputStream $anonfun$testGetObject$1(ByteArrayInputStream inputStream$1, InvocationOnMock x$2) {
        return inputStream$1;
    }

    public static final /* synthetic */ Mono $anonfun$testGetObjectAsync$3(Mono mono0$1, InvocationOnMock x$5) {
        return mono0$1;
    }

    public static final /* synthetic */ Mono $anonfun$testGetObjectAsync$4(Mono mono1$1, InvocationOnMock x$6) {
        return mono1$1;
    }

    public static final /* synthetic */ Mono $anonfun$testGetObjectFailsWhenObjectIsNotFoundAsync$3(Mono mono$1, InvocationOnMock x$9) {
        return mono$1;
    }

    public static final /* synthetic */ Mono $anonfun$testGetObjectBlobStorageExceptionAsync$3(Mono mono$2, InvocationOnMock x$12) {
        return mono$2;
    }

    public static final /* synthetic */ Mono $anonfun$testGetObjectRuntimeExceptionAsync$3(Mono mono$3, InvocationOnMock x$15) {
        return mono$3;
    }
}

