/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import com.google.cloud.ReadChannel;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.CopyWriter;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.KeyTemplates;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.aead.AeadConfig;
import io.confluent.kafka.storage.checksum.ChecksumStore;
import io.confluent.kafka.storage.checksum.ChecksumStoreReaderWriter;
import io.confluent.kafka.storage.checksum.E2EChecksumProtectedObjectType;
import io.confluent.kafka.storage.checksum.E2EChecksumStore;
import io.confluent.kafka.storage.checksum.E2EChecksumStoreConfig;
import io.confluent.kafka.storage.checksum.E2EChecksumUtils;
import io.confluent.kafka.storage.tier.TierBackend;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.exceptions.E2EChecksumInvalidException;
import kafka.tier.exceptions.TierObjectStoreFatalException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.GcsTierObjectStore;
import kafka.tier.store.GcsTierObjectStoreConfig;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.VersionInformation;
import kafka.tier.store.encryption.EncryptionKeyManager;
import kafka.tier.store.encryption.KeyContext;
import kafka.tier.store.encryption.KeySha;
import kafka.tier.store.objects.FragmentLocation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tmf\u0001B\u001f?\u0001\u0015CQ\u0001\u0014\u0001\u0005\u00025Cq\u0001\u0015\u0001C\u0002\u0013\u0005\u0011\u000b\u0003\u0004`\u0001\u0001\u0006IA\u0015\u0005\bA\u0002\u0011\r\u0011\"\u0001b\u0011\u0019i\u0007\u0001)A\u0005E\"9a\u000e\u0001b\u0001\n\u0003y\u0007BB:\u0001A\u0003%\u0001\u000fC\u0004u\u0001\t\u0007I\u0011A;\t\re\u0004\u0001\u0015!\u0003w\u0011\u001dQ\bA1A\u0005\u0002mDq!a\u0002\u0001A\u0003%A\u0010C\u0005\u0002\n\u0001\u0011\r\u0011\"\u0001\u0002\f!A\u0011Q\u0004\u0001!\u0002\u0013\ti\u0001C\u0005\u0002 \u0001\u0011\r\u0011\"\u0001\u0002\"!A\u0011q\u0006\u0001!\u0002\u0013\t\u0019\u0003C\u0005\u00022\u0001\u0011\r\u0011\"\u0001\u00024!A\u0011Q\t\u0001!\u0002\u0013\t)\u0004C\u0005\u0002H\u0001\u0011\r\u0011\"\u0001\u0002J!A\u0011\u0011\u000f\u0001!\u0002\u0013\tY\u0005C\u0005\u0002t\u0001\u0011\r\u0011\"\u0001\u0002J!A\u0011Q\u000f\u0001!\u0002\u0013\tY\u0005C\u0005\u0002x\u0001\u0001\r\u0011\"\u0001\u0002z!I\u0011\u0011\u0013\u0001A\u0002\u0013\u0005\u00111\u0013\u0005\t\u0003?\u0003\u0001\u0015)\u0003\u0002|!I\u0011\u0011\u0015\u0001C\u0002\u0013\u0005\u00111\u0015\u0005\t\u0003k\u0003\u0001\u0015!\u0003\u0002&\"I\u0011q\u0017\u0001C\u0002\u0013\u0005\u00111\u0015\u0005\t\u0003s\u0003\u0001\u0015!\u0003\u0002&\"9\u00111\u0018\u0001\u0005\u0002\u0005u\u0006bBAk\u0001\u0011\u0005\u0011Q\u0018\u0005\b\u0003?\u0004A\u0011AA_\u0011\u001d\t\u0019\u000f\u0001C\u0001\u0003{Cq!a:\u0001\t\u0003\ti\fC\u0004\u0002l\u0002!\t!!0\t\u000f\u0005=\b\u0001\"\u0001\u0002>\"9\u00111\u001f\u0001\u0005\u0002\u0005u\u0006bBA|\u0001\u0011\u0005\u0011Q\u0018\u0005\b\u0003w\u0004A\u0011AA_\u0011\u001d\ty\u0010\u0001C\u0001\u0003{CqAa\u0001\u0001\t\u0003\ti\fC\u0004\u0003\b\u0001!\t!!0\t\u000f\t-\u0001\u0001\"\u0001\u0002>\"9!q\u0002\u0001\u0005\u0002\u0005u\u0006b\u0002B\n\u0001\u0011\u0005\u0011Q\u0018\u0005\b\u0005/\u0001A\u0011AA_\u0011\u001d\u0011Y\u0002\u0001C\u0001\u0003{CqAa\b\u0001\t\u0003\ti\fC\u0004\u0003$\u0001!\t!!0\t\u000f\t\u001d\u0002\u0001\"\u0001\u0002>\"9!1\u0006\u0001\u0005\u0002\u0005u\u0006b\u0002B\u0018\u0001\u0011\u0005\u0011Q\u0018\u0005\b\u0005g\u0001A\u0011AA_\u0011\u001d\u00119\u0004\u0001C\u0001\u0003{CqAa\u000f\u0001\t\u0003\tiL\u0002\u0004\u0003@\u0001\u0001!\u0011\t\u0005\u000b\u0005g:$Q1A\u0005\u0002\tU\u0004B\u0003B?o\t\u0005\t\u0015!\u0003\u0003x!1Aj\u000eC\u0001\u0005\u007fBqAa\"8\t\u0003\u0012I\tC\u0004\u0003\u0016^\"\tAa&\u0003-\u001d\u001b7\u000fV5fe>\u0013'.Z2u'R|'/\u001a+fgRT!a\u0010!\u0002\u000bM$xN]3\u000b\u0005\u0005\u0013\u0015\u0001\u0002;jKJT\u0011aQ\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\t\u0005\u0002H\u00156\t\u0001JC\u0001J\u0003\u0015\u00198-\u00197b\u0013\tY\u0005J\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00039\u0003\"a\u0014\u0001\u000e\u0003y\n\u0001\"\\8dWRKW.Z\u000b\u0002%B\u00111+X\u0007\u0002)*\u0011QKV\u0001\u0005kRLGN\u0003\u0002X1\u000611/\u001a:wKJT!aQ-\u000b\u0005i[\u0016AB1qC\u000eDWMC\u0001]\u0003\ry'oZ\u0005\u0003=R\u0013\u0001\"T8dWRKW.Z\u0001\n[>\u001c7\u000eV5nK\u0002\nqa\u001d;pe\u0006<W-F\u0001c!\t\u00197.D\u0001e\u0015\t\u0001WM\u0003\u0002gO\u0006)1\r\\8vI*\u0011\u0001.[\u0001\u0007O>|w\r\\3\u000b\u0003)\f1aY8n\u0013\taGMA\u0004Ti>\u0014\u0018mZ3\u0002\u0011M$xN]1hK\u0002\naAY;dW\u0016$X#\u00019\u0011\u0005\r\f\u0018B\u0001:e\u0005\u0019\u0011UoY6fi\u00069!-^2lKR\u0004\u0013AB2p]\u001aLw-F\u0001w!\tyu/\u0003\u0002y}\tAriY:US\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f\u0007>tg-[4\u0002\u000f\r|gNZ5hA\u0005AQ.\u001a;bI\u0006$\u0018-F\u0001}!\ri\u00181A\u0007\u0002}*\u0011!p \u0006\u0004\u0003\u0003q\u0014aB8cU\u0016\u001cGo]\u0005\u0004\u0003\u000bq(AD(cU\u0016\u001cG/T3uC\u0012\fG/Y\u0001\n[\u0016$\u0018\rZ1uC\u0002\n\u0001\u0002^3ti\u001aKG.Z\u000b\u0003\u0003\u001b\u0001B!a\u0004\u0002\u001a5\u0011\u0011\u0011\u0003\u0006\u0005\u0003'\t)\"\u0001\u0002j_*\u0011\u0011qC\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001c\u0005E!\u0001\u0002$jY\u0016\f\u0011\u0002^3ti\u001aKG.\u001a\u0011\u0002\u0005\t\u0014WCAA\u0012!\u0011\t)#a\u000b\u000e\u0005\u0005\u001d\"\u0002BA\u0015\u0003+\t1A\\5p\u0013\u0011\ti#a\n\u0003\u0015\tKH/\u001a\"vM\u001a,'/A\u0002cE\u0002\n\u0011\"\\1ti\u0016\u00148*Z=\u0016\u0005\u0005U\u0002\u0003BA\u001c\u0003\u0003j!!!\u000f\u000b\t\u0005m\u0012QH\u0001\u0005i&t7NC\u0002\u0002@\u001d\faa\u0019:zaR|\u0017\u0002BA\"\u0003s\u0011A!Q3bI\u0006QQ.Y:uKJ\\U-\u001f\u0011\u0002/\tdwNY,sSR,w\n\u001d;j_:\u001cx+\u001b;i\u0007J\u001cWCAA&!\u0019\ti%!\u0018\u0002d9!\u0011qJA-\u001d\u0011\t\t&a\u0016\u000e\u0005\u0005M#bAA+\t\u00061AH]8pizJ\u0011!S\u0005\u0004\u00037B\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003?\n\tG\u0001\u0003MSN$(bAA.\u0011B!\u0011QMA6\u001d\r\u0019\u0017qM\u0005\u0004\u0003S\"\u0017aB*u_J\fw-Z\u0005\u0005\u0003[\nyGA\bCY>\u0014wK]5uK>\u0003H/[8o\u0015\r\tI\u0007Z\u0001\u0019E2|'m\u0016:ji\u0016|\u0005\u000f^5p]N<\u0016\u000e\u001e5De\u000e\u0004\u0013A\u00072m_\n<&/\u001b;f\u001fB$\u0018n\u001c8t/&$\bn\\;u\u0007J\u001c\u0017a\u00072m_\n<&/\u001b;f\u001fB$\u0018n\u001c8t/&$\bn\\;u\u0007J\u001c\u0007%A\u0007dQ\u0016\u001c7n];n'R|'/Z\u000b\u0003\u0003w\u0002B!! \u0002\u000e6\u0011\u0011q\u0010\u0006\u0005\u0003\u0003\u000b\u0019)\u0001\u0005dQ\u0016\u001c7n];n\u0015\r\u0001\u0017Q\u0011\u0006\u0004\u0007\u0006\u001d%\u0002BAE\u0003\u0017\u000b\u0011bY8oM2,XM\u001c;\u000b\u0005\u0005M\u0011\u0002BAH\u0003\u007f\u0012\u0001#\u0012\u001aF\u0007\",7m[:v[N#xN]3\u0002#\rDWmY6tk6\u001cFo\u001c:f?\u0012*\u0017\u000f\u0006\u0003\u0002\u0016\u0006m\u0005cA$\u0002\u0018&\u0019\u0011\u0011\u0014%\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003;;\u0012\u0011!a\u0001\u0003w\n1\u0001\u001f\u00132\u00039\u0019\u0007.Z2lgVl7\u000b^8sK\u0002\n\u0011c\u0011*D?\u0012+e)Q+M)~3\u0016\tT+F+\t\t)\u000b\u0005\u0003\u0002(\u0006=f\u0002BAU\u0003W\u00032!!\u0015I\u0013\r\ti\u000bS\u0001\u0007!J,G-\u001a4\n\t\u0005E\u00161\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u00055\u0006*\u0001\nD%\u000e{F)\u0012$B+2#vLV!M+\u0016\u0003\u0013aC\"S\u0007~\u000btLV!M+\u0016\u000bAb\u0011*D?Fzf+\u0011'V\u000b\u0002\nQa]3ukB$\"!!&)\u0007u\t\t\r\u0005\u0003\u0002D\u0006EWBAAc\u0015\u0011\t9-!3\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002L\u00065\u0017a\u00026va&$XM\u001d\u0006\u0004\u0003\u001f\\\u0016!\u00026v]&$\u0018\u0002BAj\u0003\u000b\u0014!BQ3g_J,W)Y2i\u00035!Xm\u001d;TS:<G.\u001a)vi\"\u001aa$!7\u0011\t\u0005\r\u00171\\\u0005\u0005\u0003;\f)M\u0001\u0003UKN$\u0018!\u0006;fgR\u001c%kQ,ji\"\u001c\u0016N\\4mK\nKH/\u001a\u0015\u0004?\u0005e\u0017\u0001\u0006;fgR\u001c%kQ,ji\"lU\u000f\u001c;j\u0005f$X\rK\u0002!\u00033\fa\u0005^3ti\u000e\u00136iV5uQ6+H\u000e^5CsR,\u0017I\u001c3O_:TVM]8Q_NLG/[8oQ\r\t\u0013\u0011\\\u0001\u001di\u0016\u001cHoU5oO2,\u0007+\u001e;XSRD\u0017IY8si\u0016$G\u000b\u001f8tQ\r\u0011\u0013\u0011\\\u0001%i\u0016\u001cHoU5oO2,\u0007+\u001e;Qe>$WoY3s'R\fG/Z#q_\u000eD7\u000b^1uK\"\u001a1%!7\u0002)Q,7\u000f\u001e#fY\u0016$X-\u00117m'V\u001c7-Z:tQ\r!\u0013\u0011\\\u0001!i\u0016\u001cH\u000fR3mKR,\u0017\t\u001c7Tk\u000e\u001cWm]:XSRD\u0017\t\u001c7GS2,7\u000fK\u0002&\u00033\f\u0001\u0005^3ti\u0012+G.\u001a;f'>lWMR1jY\u0016$w)\u001a;Fq\u000e,\u0007\u000f^5p]\"\u001aa%!7\u0002EQ,7\u000f\u001e#fY\u0016$XmU8nK\u001a\u000b\u0017\u000e\\3e\u000f\u0016$hj\\#yG\u0016\u0004H/[8oQ\r9\u0013\u0011\\\u00013i\u0016\u001cH/\u00128def\u0004H/\u001a3GKR\u001c\u0007nV5uQ:{WI\\2ssB$\u0018n\u001c8LKfl\u0015M\\1hKJ$\u0006N]8xg\"\u001a\u0001&!7\u0002sQ,7\u000f^$dgRKWM](cU\u0016\u001cGo\u0015;pe\u0016\u001cuN\\:ueV\u001cG\u000f\u00165s_^\u001cx+\u001b;i\u0013:4\u0018\r\\5e\u0017\u0016L8i\u001c8gS\u001eD3!KAm\u0003)\"Xm\u001d;Qe\u0016\u0004\b+\u001e;TK\u001elWM\u001c;XSRDWI\\2ssB$\u0018n\u001c8LKfl\u0015M\\1hKJD3AKAm\u00035\"Xm\u001d;Qe\u0016\u0004\b+\u001e;TK\u001elWM\u001c;XSRDw.\u001e;F]\u000e\u0014\u0018\u0010\u001d;j_:\\U-_'b]\u0006<WM\u001d\u0015\u0004W\u0005e\u0017\u0001\r;fgR,en\u0019:zaR,GmU3h[\u0016tGOU3bIV\u001bXm]#oGJL\b\u000f^5p].+\u00170T1oC\u001e,'\u000fK\u0002-\u00033\fq\u0004^3ti\u0016s7M]=qi\u0016$'+Z1e%\u00164'/Z:iKN\u001c\u0015m\u00195fQ\ri\u0013\u0011\\\u0001\u0012i\u0016\u001cH/\u00128def\u0004H/\u001a3QkR\u001c\bf\u0001\u0018\u0002Z\u0006yB/Z:u\u000b:\u001c'/\u001f9uK\u0012\u0004V\u000f^%o\u001b\u0016lwN]=TK\u001elWM\u001c;)\u0007=\nI.\u0001\u000euKN$XI\\2ssB$X\r\u001a*fgR|'/\u001a\"z\u0007>\u0004\u0018\u0010K\u00021\u00033\fq\u0005^3tiB+HoU3h[\u0016tGoV5uQ\u000e\u00138-\u00128bE2,GMR8s\u00032dg)\u001b7fg\"\u001a\u0011'!7\u0002OQ,7\u000f\u001e)viN+w-\\3oi^KG\u000f[\"sG\u0016s\u0017M\u00197fI\u001a{'\u000fV<p\r&dWm\u001d\u0015\u0004e\u0005e\u0017A\n;fgR\u0004V\u000f^*fO6,g\u000e^,ji\"\u001c%oY#oC\ndW\r\u001a$pe>sWMR5mK\"\u001a1'!7\u0002GQ,7\u000f\u001e)viN+w-\\3oi^CWM\\\"iK\u000e\\7/^7Jg&sg/\u00197jI\"\u001aA'!7\u0002EQ,7\u000f\u001e)viN+w-\\3oi^CWM\\\"iK\u000e\\7/^7NSNl\u0017\r^2iQ\r)\u0014\u0011\\\u0001+i\u0016\u001cH\u000fU;u\u0013:lU-\\8ssN+w-\\3oi^CWM\\\"iK\u000e\\7/^7NSNl\u0017\r^2iQ\r1\u0014\u0011\u001c\u0002$\u000f\u000e\u001c8\u000b^8sC\u001e,7i\u001c9z%\u0016\fX/Z:u\u001fB$\u0018n\u001c8t\u001b\u0006$8\r[3s+\u0011\u0011\u0019E!\u0019\u0014\u000b]\u0012)E!\u0015\u0011\t\t\u001d#QJ\u0007\u0003\u0005\u0013RAAa\u0013\u0002\u0016\u0005!A.\u00198h\u0013\u0011\u0011yE!\u0013\u0003\r=\u0013'.Z2u!\u0019\u0011\u0019F!\u0017\u0003^5\u0011!Q\u000b\u0006\u0004\u0005/Z\u0016aB7pG.LGo\\\u0005\u0005\u00057\u0012)FA\bBe\u001e,X.\u001a8u\u001b\u0006$8\r[3s!\u0011\u0011yF!\u0019\r\u0001\u00119!1M\u001cC\u0002\t\u0015$!\u0001+\u0012\t\t\u001d$Q\u000e\t\u0004\u000f\n%\u0014b\u0001B6\u0011\n9aj\u001c;iS:<\u0007cA$\u0003p%\u0019!\u0011\u000f%\u0003\u0007\u0005s\u00170A\u0006d_BL(+Z9vKN$XC\u0001B<!\u0011\t)G!\u001f\n\t\tm\u0014q\u000e\u0002\f\u0007>\u0004\u0018PU3rk\u0016\u001cH/\u0001\u0007d_BL(+Z9vKN$\b\u0005\u0006\u0003\u0003\u0002\n\u0015\u0005#\u0002BBo\tuS\"\u0001\u0001\t\u000f\tM$\b1\u0001\u0003x\u00059Q.\u0019;dQ\u0016\u001cH\u0003\u0002BF\u0005#\u00032a\u0012BG\u0013\r\u0011y\t\u0013\u0002\b\u0005>|G.Z1o\u0011\u001d\u0011\u0019j\u000fa\u0001\u0005;\n\u0001\"\u0019:hk6,g\u000e^\u0001\u0012_B$\u0018n\u001c8MSN$X*\u0019;dQ\u0016\u001cHC\u0002BF\u00053\u0013i\u000bC\u0004\u0003\u001cr\u0002\rA!(\u0002\u0017=\u0004H/[8o\u0019&\u001cH/\r\u0019\u0005\u0005?\u0013I\u000b\u0005\u0004\u0003\"\n\u0015&qU\u0007\u0003\u0005GS1!VA\u000b\u0013\u0011\tyFa)\u0011\t\t}#\u0011\u0016\u0003\r\u0005W\u0013I*!A\u0001\u0002\u000b\u0005!Q\r\u0002\u0004?\u0012\n\u0004b\u0002BXy\u0001\u0007!\u0011W\u0001\f_B$\u0018n\u001c8MSN$(\u0007\r\u0003\u00034\n]\u0006C\u0002BQ\u0005K\u0013)\f\u0005\u0003\u0003`\t]F\u0001\u0004B]\u0005[\u000b\t\u0011!A\u0003\u0002\t\u0015$aA0%e\u0001")
public class GcsTierObjectStoreTest {
    private final MockTime mockTime = new MockTime();
    private final Storage storage = (Storage)Mockito.mock(Storage.class);
    private final Bucket bucket = (Bucket)Mockito.mock(Bucket.class);
    private final GcsTierObjectStoreConfig config = GcsTierObjectStoreConfig.createWithEmptyClusterIdBrokerId((String)"bucket", (String)"prefix", (String)"region", (Integer)Predef$.MODULE$.int2Integer(10240), (String)"path", null, null);
    private final ObjectMetadata metadata = new ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, OpaqueData.ZEROED, null);
    private final File testFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
    private final ByteBuffer bb = ByteBuffer.allocate(0);
    private final Aead masterKey;
    private final List<Storage.BlobWriteOption> blobWriteOptionsWithCrc;
    private final List<Storage.BlobWriteOption> blobWriteOptionsWithoutCrc;
    private E2EChecksumStore checksumStore;
    private final String CRC_DEFAULT_VALUE;
    private final String CRC_1_VALUE;

    public MockTime mockTime() {
        return this.mockTime;
    }

    public Storage storage() {
        return this.storage;
    }

    public Bucket bucket() {
        return this.bucket;
    }

    public GcsTierObjectStoreConfig config() {
        return this.config;
    }

    public ObjectMetadata metadata() {
        return this.metadata;
    }

    public File testFile() {
        return this.testFile;
    }

    public ByteBuffer bb() {
        return this.bb;
    }

    public Aead masterKey() {
        return this.masterKey;
    }

    public List<Storage.BlobWriteOption> blobWriteOptionsWithCrc() {
        return this.blobWriteOptionsWithCrc;
    }

    public List<Storage.BlobWriteOption> blobWriteOptionsWithoutCrc() {
        return this.blobWriteOptionsWithoutCrc;
    }

    public E2EChecksumStore checksumStore() {
        return this.checksumStore;
    }

    public void checksumStore_$eq(E2EChecksumStore x$1) {
        this.checksumStore = x$1;
    }

    public String CRC_DEFAULT_VALUE() {
        return this.CRC_DEFAULT_VALUE;
    }

    public String CRC_1_VALUE() {
        return this.CRC_1_VALUE;
    }

    @BeforeEach
    public void setup() {
        Mockito.when((Object)this.storage().get(ArgumentMatchers.anyString(), new Storage.BucketGetOption[]{(Storage.BucketGetOption)ArgumentMatchers.any(Storage.BucketGetOption.class)})).thenReturn((Object)this.bucket());
        Mockito.when((Object)this.storage().writer((BlobInfo)ArgumentMatchers.any(BlobInfo.class), (Storage.BlobWriteOption[])ArgumentMatchers.any(Storage.BlobWriteOption[].class))).thenReturn(Mockito.mock(WriteChannel.class));
        Mockito.when((Object)this.storage().copy((Storage.CopyRequest)ArgumentMatchers.any(Storage.CopyRequest.class))).thenReturn(Mockito.mock(CopyWriter.class));
        Mockito.when((Object)this.bucket().getLocation()).thenReturn((Object)"REGION");
    }

    @Test
    public void testSinglePut() {
        new GcsTierObjectStore(this.storage(), null, this.config(), Optional.of(this.checksumStore())).putSegment(this.metadata(), this.testFile(), this.testFile(), this.testFile(), Optional.empty(), Optional.empty(), Optional.empty());
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)3))).writer((BlobInfo)ArgumentMatchers.any(BlobInfo.class), new Storage.BlobWriteOption[]{(Storage.BlobWriteOption)ArgumentMatchers.eq((Object)Storage.BlobWriteOption.doesNotExist())});
    }

    @Test
    public void testCRCWithSingleByte() {
        ByteBuffer buffer = ByteBuffer.allocate(5);
        buffer.put((byte)1);
        buffer.flip();
        Assertions.assertEquals((Object)"oBbQUg==", (Object)E2EChecksumUtils.compute32BitBase64Crc32c((ByteBuffer)buffer));
    }

    @Test
    public void testCRCWithMultiByte() {
        ByteBuffer buffer = ByteBuffer.allocate(5);
        buffer.put(new byte[]{1, 2, 3});
        buffer.flip();
        Assertions.assertEquals((Object)"8TDyHg==", (Object)E2EChecksumUtils.compute32BitBase64Crc32c((ByteBuffer)buffer));
    }

    @Test
    public void testCRCWithMultiByteAndNonZeroPosition() {
        ByteBuffer buffer = ByteBuffer.allocate(10);
        buffer.put(new byte[]{6, 5, 4, 1, 2, 3});
        buffer.flip();
        buffer.position(3);
        Assertions.assertEquals((Object)"8TDyHg==", (Object)E2EChecksumUtils.compute32BitBase64Crc32c((ByteBuffer)buffer));
    }

    @Test
    public void testSinglePutWithAbortedTxns() {
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), null, this.config(), Optional.of(this.checksumStore()));
        ArgumentCaptor capturedBlobInfos = ArgumentCaptor.forClass(BlobInfo.class);
        ArgumentCaptor capturedOption = ArgumentCaptor.forClass(Storage.BlobWriteOption.class);
        objectStore.putSegment(this.metadata(), this.testFile(), this.testFile(), this.testFile(), Optional.empty(), Optional.of(this.bb()), Optional.empty());
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)4))).writer((BlobInfo)capturedBlobInfos.capture(), new Storage.BlobWriteOption[]{(Storage.BlobWriteOption)capturedOption.capture()});
        List captureds = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(capturedBlobInfos.getAllValues()).asScala().map((Function1 & Serializable)x$1 -> x$1)).map((Function1 & Serializable)x$2 -> x$2.getCrc32c())).toList();
        Assertions.assertEquals((Object)new .colon.colon(null, (List)new .colon.colon(null, (List)new .colon.colon(null, (List)new .colon.colon((Object)this.CRC_DEFAULT_VALUE(), (List)Nil$.MODULE$)))), (Object)captureds);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Storage.BlobWriteOption[]{Storage.BlobWriteOption.crc32cMatch(), Storage.BlobWriteOption.doesNotExist()})), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(capturedOption.getAllValues()).asScala().map((Function1 & Serializable)x$3 -> x$3)).toSet());
    }

    @Test
    public void testSinglePutProducerStateEpochState() {
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), null, this.config(), Optional.of(this.checksumStore()));
        ArgumentCaptor capturedBlobInfos = ArgumentCaptor.forClass(BlobInfo.class);
        ArgumentCaptor capturedOption = ArgumentCaptor.forClass(Storage.BlobWriteOption.class);
        objectStore.putSegment(this.metadata(), this.testFile(), this.testFile(), this.testFile(), Optional.of(this.testFile()), Optional.empty(), Optional.of(this.bb()));
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)5))).writer((BlobInfo)capturedBlobInfos.capture(), new Storage.BlobWriteOption[]{(Storage.BlobWriteOption)capturedOption.capture()});
        List captureds = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(capturedBlobInfos.getAllValues()).asScala().map((Function1 & Serializable)x$4 -> x$4)).map((Function1 & Serializable)x$5 -> x$5.getCrc32c())).toList();
        Assertions.assertEquals((Object)new .colon.colon(null, (List)new .colon.colon(null, (List)new .colon.colon(null, (List)new .colon.colon(null, (List)new .colon.colon((Object)this.CRC_DEFAULT_VALUE(), (List)Nil$.MODULE$))))), (Object)captureds);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Storage.BlobWriteOption[]{Storage.BlobWriteOption.crc32cMatch(), Storage.BlobWriteOption.doesNotExist()})), (Object)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(capturedOption.getAllValues()).asScala().map((Function1 & Serializable)x$6 -> x$6)).toSet());
    }

    @Test
    public void testDeleteAllSuccess() {
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), null, this.config(), Optional.of(this.checksumStore()));
        ArrayList<Boolean> deleteResult = new ArrayList<Boolean>();
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(true));
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(true));
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(true));
        Mockito.when((Object)this.storage().delete((Iterable)ArgumentMatchers.any(ArrayList.class))).thenReturn(deleteResult);
        objectStore.deleteSegment(this.metadata());
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)0))).get((BlobId)ArgumentMatchers.any(BlobId.class));
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)1))).delete((Iterable)ArgumentMatchers.any(ArrayList.class));
    }

    @Test
    public void testDeleteAllSuccessWithAllFiles() {
        ObjectMetadata metadataWithAllFiles = new ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, true, true, true, OpaqueData.ZEROED, null);
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), null, this.config(), Optional.of(this.checksumStore()));
        ArrayList<Boolean> deleteResult = new ArrayList<Boolean>();
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(true));
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(true));
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(true));
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(true));
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(true));
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(true));
        Mockito.when((Object)this.storage().delete((Iterable)ArgumentMatchers.any(ArrayList.class))).thenReturn(deleteResult);
        objectStore.deleteSegment(metadataWithAllFiles);
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)0))).get((BlobId)ArgumentMatchers.any(BlobId.class));
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)1))).delete((Iterable)ArgumentMatchers.any(ArrayList.class));
    }

    @Test
    public void testDeleteSomeFailedGetException() {
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), null, this.config(), Optional.of(this.checksumStore()));
        ArrayList<Boolean> deleteResult = new ArrayList<Boolean>();
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(true));
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(false));
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(true));
        Mockito.when((Object)this.storage().delete((Iterable)ArgumentMatchers.any(ArrayList.class))).thenReturn(deleteResult);
        Blob blob = (Blob)Mockito.mock(Blob.class);
        Mockito.when((Object)this.storage().get((BlobId)ArgumentMatchers.any(BlobId.class))).thenReturn((Object)blob);
        try {
            objectStore.deleteSegment(this.metadata());
        }
        catch (TierObjectStoreRetriableException tierObjectStoreRetriableException) {
            ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)1))).get((BlobId)ArgumentMatchers.any(BlobId.class));
            ((BlobInfo)Mockito.verify((Object)blob, (VerificationMode)Mockito.atLeastOnce())).getBlobId();
            return;
        }
        Assertions.fail((String)"TierObjectStoreRetriableException should have been thrown when attempting to delete segments");
    }

    @Test
    public void testDeleteSomeFailedGetNoException() {
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), null, this.config(), Optional.of(this.checksumStore()));
        ArrayList<Boolean> deleteResult = new ArrayList<Boolean>();
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(true));
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(false));
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(false));
        Mockito.when((Object)this.storage().delete((Iterable)ArgumentMatchers.any(ArrayList.class))).thenReturn(deleteResult);
        Mockito.when((Object)this.storage().get((BlobId)ArgumentMatchers.any(BlobId.class))).thenReturn(null);
        objectStore.deleteSegment(this.metadata());
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)2))).get((BlobId)ArgumentMatchers.any(BlobId.class));
    }

    @Test
    public void testEncryptedFetchWithNoEncryptionKeyManagerThrows() {
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), null, this.config(), Optional.of(this.checksumStore()));
        ObjectMetadata metadata = new ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, OpaqueData.fromByteArray((byte[])"foo".getBytes()), null);
        Assertions.assertThrows(TierObjectStoreFatalException.class, () -> objectStore.getObjectStoreFragment((ObjectStoreMetadata)metadata, FragmentType.SEGMENT));
    }

    @Test
    public void testGcsTierObjectStoreConstructThrowsWithInvalidKeyConfig() {
        GcsTierObjectStoreConfig config = GcsTierObjectStoreConfig.createWithEmptyClusterIdBrokerId((String)"bucket", (String)"prefix", (String)"region", (Integer)Predef$.MODULE$.int2Integer(10240), (String)"path", (String)"invalid", (Duration)Duration.ofSeconds(30L));
        Assertions.assertThrows(TierObjectStoreFatalException.class, () -> new GcsTierObjectStore((Time)this.mockTime(), null, config, Optional.of(this.checksumStore())));
    }

    @Test
    public void testPrepPutSegmentWithEncryptionKeyManager() {
        EncryptionKeyManager encryptionKeyManager = new EncryptionKeyManager((Time)this.mockTime(), null, this.masterKey(), Duration.ofSeconds(30L));
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), encryptionKeyManager, this.config(), Optional.of(this.checksumStore()));
        OpaqueData opaqueData1 = objectStore.prepPutSegment();
        OpaqueData opaqueData2 = objectStore.prepPutSegment();
        Assertions.assertTrue((boolean)Arrays.equals(opaqueData1.intoByteArray(), opaqueData2.intoByteArray()));
        this.mockTime().sleep(31000L);
        Assertions.assertFalse((boolean)Arrays.equals(opaqueData1.intoByteArray(), objectStore.prepPutSegment().intoByteArray()));
    }

    @Test
    public void testPrepPutSegmentWithoutEncryptionKeyManager() {
        Assertions.assertTrue((boolean)Arrays.equals(new GcsTierObjectStore(this.storage(), null, this.config(), Optional.of(this.checksumStore())).prepPutSegment().intoByteArray(), OpaqueData.ZEROED.intoByteArray()));
    }

    @Test
    public void testEncryptedSegmentReadUsesEncryptionKeyManager() {
        CollectionConverters$.MODULE$.SetHasAsScala(TierObjectStore.getObjectTypesPerSegment()).asScala().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)GcsTierObjectStoreTest.$anonfun$testEncryptedSegmentReadUsesEncryptionKeyManager$1(check$ifrefutable$1))).foreach((Function1 & Serializable)objectType -> {
            GcsTierObjectStoreTest.$anonfun$testEncryptedSegmentReadUsesEncryptionKeyManager$2(this, objectType);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testEncryptedReadRefreshesCache() {
        CollectionConverters$.MODULE$.SetHasAsScala(TierObjectStore.getObjectTypesPerSegment()).asScala().withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)GcsTierObjectStoreTest.$anonfun$testEncryptedReadRefreshesCache$1(check$ifrefutable$2))).foreach((Function1 & Serializable)objectType -> {
            GcsTierObjectStoreTest.$anonfun$testEncryptedReadRefreshesCache$2(this, objectType);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testEncryptedPuts() {
        EncryptionKeyManager encryptionKeyManager = new EncryptionKeyManager((Time)this.mockTime(), null, this.masterKey(), Duration.ofSeconds(30L));
        KeySha keySha = encryptionKeyManager.activeKeySha();
        OpaqueData opaqueData = OpaqueData.fromByteArray((byte[])keySha.toRawBytes());
        KeyContext expectedKeyContext = encryptionKeyManager.keyContext(keySha);
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), encryptionKeyManager, this.config(), Optional.of(this.checksumStore()));
        ObjectMetadata metadata = new ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, opaqueData, null);
        objectStore.putSegment(metadata, this.testFile(), this.testFile(), this.testFile(), Optional.empty(), Optional.empty(), Optional.empty());
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)1))).writer((BlobInfo)ArgumentMatchers.any(), new Storage.BlobWriteOption[]{(Storage.BlobWriteOption)ArgumentMatchers.eq((Object)Storage.BlobWriteOption.encryptionKey((String)expectedKeyContext.cleartextDataKey.base64Encoded())), (Storage.BlobWriteOption)ArgumentMatchers.eq((Object)Storage.BlobWriteOption.doesNotExist())});
    }

    @Test
    public void testEncryptedPutInMemorySegment() {
        EncryptionKeyManager encryptionKeyManager = new EncryptionKeyManager((Time)this.mockTime(), null, this.masterKey(), Duration.ofSeconds(30L));
        KeySha keySha = encryptionKeyManager.activeKeySha();
        OpaqueData opaqueData = OpaqueData.fromByteArray((byte[])keySha.toRawBytes());
        KeyContext expectedKeyContext = encryptionKeyManager.keyContext(keySha);
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), encryptionKeyManager, this.config(), Optional.of(this.checksumStore()));
        ObjectMetadata metadata = new ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, opaqueData, null);
        objectStore.putInMemorySegment(metadata, this.testFile(), this.testFile(), this.testFile(), Optional.empty(), Optional.empty(), Optional.empty());
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)1))).writer((BlobInfo)ArgumentMatchers.any(), new Storage.BlobWriteOption[]{(Storage.BlobWriteOption)ArgumentMatchers.eq((Object)Storage.BlobWriteOption.encryptionKey((String)expectedKeyContext.cleartextDataKey.base64Encoded())), (Storage.BlobWriteOption)ArgumentMatchers.eq((Object)Storage.BlobWriteOption.doesNotExist())});
    }

    @Test
    public void testEncryptedRestoreByCopy() {
        EncryptionKeyManager encryptionKeyManager = new EncryptionKeyManager((Time)this.mockTime(), null, this.masterKey(), Duration.ofSeconds(30L));
        KeySha keySha = encryptionKeyManager.activeKeySha();
        OpaqueData opaqueData = OpaqueData.fromByteArray((byte[])keySha.toRawBytes());
        String dataKeyBase64 = encryptionKeyManager.keyContext((KeySha)keySha).cleartextDataKey.base64Encoded();
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), encryptionKeyManager, this.config(), Optional.of(this.checksumStore()));
        ObjectMetadata metadata = new ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, opaqueData, null);
        String versionId = "1234";
        String bucketName = "bucket";
        String segmentPath = ((FragmentLocation)metadata.toFragmentLocation("", FragmentType.SEGMENT).get()).objectPath();
        BlobId source = BlobId.of((String)bucketName, (String)segmentPath, (Long)Predef$.MODULE$.long2Long(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(versionId))));
        BlobId target = BlobId.of((String)bucketName, (String)segmentPath);
        Storage.BlobTargetOption targetOption = Storage.BlobTargetOption.encryptionKey((String)dataKeyBase64);
        Storage.CopyRequest copyRequest = Storage.CopyRequest.newBuilder().setSource(source).setSourceOptions(new Storage.BlobSourceOption[]{Storage.BlobSourceOption.decryptionKey((String)dataKeyBase64)}).setTarget(target, new Storage.BlobTargetOption[]{targetOption}).build();
        objectStore.restoreObjectByCopy(metadata, segmentPath, new VersionInformation(versionId));
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)1))).copy((Storage.CopyRequest)ArgumentMatchers.argThat(new GcsStorageCopyRequestOptionsMatcher(this, copyRequest)));
        String indexFilePath = ((FragmentLocation)metadata.toFragmentLocation("", FragmentType.OFFSET_INDEX).get()).objectPath();
        BlobId source2 = BlobId.of((String)bucketName, (String)indexFilePath, (Long)Predef$.MODULE$.long2Long(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(versionId))));
        BlobId target2 = BlobId.of((String)bucketName, (String)indexFilePath);
        Storage.CopyRequest copyRequest2 = Storage.CopyRequest.newBuilder().setSource(source2).setTarget(target2).build();
        objectStore.restoreObjectByCopy(metadata, indexFilePath, new VersionInformation(versionId));
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)1))).copy((Storage.CopyRequest)ArgumentMatchers.argThat(new GcsStorageCopyRequestOptionsMatcher(this, copyRequest2)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPutSegmentWithCrcEnabledForAllFiles() {
        void tempFile_suffix;
        void tempFile_suffix2;
        void tempFile_suffix3;
        void tempFile_suffix4;
        this.checksumStore_$eq(new E2EChecksumStore(new E2EChecksumStoreConfig(TierBackend.GCS, Arrays.asList(E2EChecksumProtectedObjectType.getAllValues()), 1000L), Time.SYSTEM, (ChecksumStoreReaderWriter)Mockito.mock(ChecksumStoreReaderWriter.class), new Metrics()));
        ChecksumStore store = this.checksumStore().store();
        String string = ".tmp";
        String tempFile_prefix = E2EChecksumProtectedObjectType.SEGMENT.suffix();
        Object var17_3 = null;
        string = null;
        File segFile = TestUtils.tempFile((String)tempFile_prefix, (String)tempFile_suffix4);
        String string2 = ".tmp";
        String tempFile_prefix2 = E2EChecksumProtectedObjectType.OFFSET_INDEX.suffix();
        Object var19_6 = null;
        string2 = null;
        File offsetIndexFile = TestUtils.tempFile((String)tempFile_prefix2, (String)tempFile_suffix3);
        String string3 = ".tmp";
        String tempFile_prefix3 = E2EChecksumProtectedObjectType.TIMESTAMP_INDEX.suffix();
        Object var21_9 = null;
        string3 = null;
        File timeStampIndexFile = TestUtils.tempFile((String)tempFile_prefix3, (String)tempFile_suffix2);
        String string4 = ".tmp";
        String tempFile_prefix4 = E2EChecksumProtectedObjectType.PRODUCER_STATE.suffix();
        Object var23_12 = null;
        string4 = null;
        File producerStateSnapshotFile = TestUtils.tempFile((String)tempFile_prefix4, (String)tempFile_suffix);
        String segCrcEntryKey = segFile.getAbsolutePath();
        String offsetCrcEntryKey = offsetIndexFile.getAbsolutePath();
        String timestampCrcEntryKey = timeStampIndexFile.getAbsolutePath();
        String producerStateSnapshotEntryKey = producerStateSnapshotFile.getAbsolutePath();
        store.initializeEntry(segCrcEntryKey);
        store.initializeEntry(offsetCrcEntryKey);
        store.initializeEntry(timestampCrcEntryKey);
        store.initializeEntry(producerStateSnapshotEntryKey);
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), null, this.config(), Optional.of(this.checksumStore()));
        ArgumentCaptor blobInfos = ArgumentCaptor.forClass(BlobInfo.class);
        ArgumentCaptor writeOptions = ArgumentCaptor.forClass(Storage.BlobWriteOption[].class);
        objectStore.putSegment(this.metadata(), segFile, offsetIndexFile, timeStampIndexFile, Optional.of(producerStateSnapshotFile), Optional.empty(), Optional.empty());
        Assertions.assertFalse((boolean)store.get(segCrcEntryKey).isPresent());
        Assertions.assertFalse((boolean)store.get(offsetCrcEntryKey).isPresent());
        Assertions.assertFalse((boolean)store.get(timestampCrcEntryKey).isPresent());
        Assertions.assertFalse((boolean)store.get(producerStateSnapshotEntryKey).isPresent());
        int noOfWriterCalls = 4;
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)noOfWriterCalls))).writer((BlobInfo)blobInfos.capture(), (Storage.BlobWriteOption[])writeOptions.capture());
        List blobInfoList = TierTestUtils$.MODULE$.getAllCapturedValuesAsList(blobInfos);
        List writeOptionList = (List)TierTestUtils$.MODULE$.getAllCapturedValuesAsList(writeOptions).flatten((Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs));
        ObjectRef expectedWriteOptionsList = ObjectRef.create((Object)package$.MODULE$.List().empty());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), noOfWriterCalls).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            String blobName = ((BlobInfo)blobInfoList.apply(i)).getName();
            String crc = ((BlobInfo)blobInfoList.apply(i)).getCrc32c();
            String crcInMetadata = (String)((BlobInfo)blobInfoList.apply(i)).getMetadata().get("crc32c");
            Assertions.assertEquals((Object)crc, (Object)crcInMetadata);
            if (blobName.contains(E2EChecksumProtectedObjectType.SEGMENT.suffix()) || blobName.contains(E2EChecksumProtectedObjectType.OFFSET_INDEX.suffix()) || blobName.contains(E2EChecksumProtectedObjectType.TIMESTAMP_INDEX.suffix()) || blobName.contains(E2EChecksumProtectedObjectType.PRODUCER_STATE.suffix())) {
                Assertions.assertEquals((Object)this.CRC_DEFAULT_VALUE(), (Object)crc);
                expectedWriteOptionsList$1.elem = (List)((List)expectedWriteOptionsList$1.elem).$plus$plus(this.blobWriteOptionsWithCrc());
                return;
            }
            Assertions.assertEquals(null, (Object)crc);
            expectedWriteOptionsList$1.elem = (List)((List)expectedWriteOptionsList$1.elem).$plus$plus(this.blobWriteOptionsWithoutCrc());
        });
        Assertions.assertEquals((Object)((List)expectedWriteOptionsList.elem), (Object)writeOptionList);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPutSegmentWithCrcEnabledForTwoFiles() {
        void tempFile_suffix;
        void tempFile_suffix2;
        void tempFile_suffix3;
        this.checksumStore_$eq(new E2EChecksumStore(new E2EChecksumStoreConfig(TierBackend.GCS, Arrays.asList(E2EChecksumProtectedObjectType.OFFSET_INDEX.suffix(), E2EChecksumProtectedObjectType.TIMESTAMP_INDEX.suffix()), 1000L), Time.SYSTEM, (ChecksumStoreReaderWriter)Mockito.mock(ChecksumStoreReaderWriter.class), new Metrics()));
        ChecksumStore store = this.checksumStore().store();
        String string = ".tmp";
        String tempFile_prefix = E2EChecksumProtectedObjectType.SEGMENT.suffix();
        Object var14_3 = null;
        string = null;
        File segFile = TestUtils.tempFile((String)tempFile_prefix, (String)tempFile_suffix3);
        String string2 = ".tmp";
        String tempFile_prefix2 = E2EChecksumProtectedObjectType.OFFSET_INDEX.suffix();
        Object var16_6 = null;
        string2 = null;
        File offsetIndexFile = TestUtils.tempFile((String)tempFile_prefix2, (String)tempFile_suffix2);
        String string3 = ".tmp";
        String tempFile_prefix3 = E2EChecksumProtectedObjectType.TIMESTAMP_INDEX.suffix();
        Object var18_9 = null;
        string3 = null;
        File timeStampIndexFile = TestUtils.tempFile((String)tempFile_prefix3, (String)tempFile_suffix);
        String offsetCrcEntryKey = offsetIndexFile.getAbsolutePath();
        String timestampCrcEntryKey = timeStampIndexFile.getAbsolutePath();
        store.initializeEntry(offsetCrcEntryKey);
        store.initializeEntry(timestampCrcEntryKey);
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), null, this.config(), Optional.of(this.checksumStore()));
        ArgumentCaptor blobInfos = ArgumentCaptor.forClass(BlobInfo.class);
        ArgumentCaptor writeOptions = ArgumentCaptor.forClass(Storage.BlobWriteOption[].class);
        objectStore.putSegment(this.metadata(), segFile, offsetIndexFile, timeStampIndexFile, Optional.of(this.testFile()), Optional.empty(), Optional.empty());
        Assertions.assertFalse((boolean)store.get(offsetCrcEntryKey).isPresent());
        Assertions.assertFalse((boolean)store.get(timestampCrcEntryKey).isPresent());
        int noOfWriterCalls = 4;
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)noOfWriterCalls))).writer((BlobInfo)blobInfos.capture(), (Storage.BlobWriteOption[])writeOptions.capture());
        List blobInfoList = TierTestUtils$.MODULE$.getAllCapturedValuesAsList(blobInfos);
        List writeOptionList = (List)TierTestUtils$.MODULE$.getAllCapturedValuesAsList(writeOptions).flatten((Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs));
        ObjectRef expectedWriteOptionsList = ObjectRef.create((Object)package$.MODULE$.List().empty());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), noOfWriterCalls).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            String blobName = ((BlobInfo)blobInfoList.apply(i)).getName();
            String crc = ((BlobInfo)blobInfoList.apply(i)).getCrc32c();
            String crcInMetadata = (String)((BlobInfo)blobInfoList.apply(i)).getMetadata().get("crc32c");
            Assertions.assertEquals((Object)crc, (Object)crcInMetadata);
            if (blobName.contains(E2EChecksumProtectedObjectType.OFFSET_INDEX.suffix()) || blobName.contains(E2EChecksumProtectedObjectType.TIMESTAMP_INDEX.suffix())) {
                Assertions.assertEquals((Object)this.CRC_DEFAULT_VALUE(), (Object)crc);
                expectedWriteOptionsList$2.elem = (List)((List)expectedWriteOptionsList$2.elem).$plus$plus(this.blobWriteOptionsWithCrc());
                return;
            }
            Assertions.assertEquals(null, (Object)crc);
            expectedWriteOptionsList$2.elem = (List)((List)expectedWriteOptionsList$2.elem).$plus$plus(this.blobWriteOptionsWithoutCrc());
        });
        Assertions.assertEquals((Object)((List)expectedWriteOptionsList.elem), (Object)writeOptionList);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPutSegmentWithCrcEnabledForOneFile() {
        void tempFile_suffix;
        void tempFile_suffix2;
        void tempFile_suffix3;
        this.checksumStore_$eq(new E2EChecksumStore(new E2EChecksumStoreConfig(TierBackend.GCS, Arrays.asList(E2EChecksumProtectedObjectType.SEGMENT.suffix()), 1000L), Time.SYSTEM, (ChecksumStoreReaderWriter)Mockito.mock(ChecksumStoreReaderWriter.class), new Metrics()));
        ChecksumStore store = this.checksumStore().store();
        String string = ".tmp";
        String tempFile_prefix = E2EChecksumProtectedObjectType.SEGMENT.suffix();
        Object var18_3 = null;
        string = null;
        File segFile = TestUtils.tempFile((String)tempFile_prefix, (String)tempFile_suffix3);
        String string2 = ".tmp";
        String tempFile_prefix2 = E2EChecksumProtectedObjectType.OFFSET_INDEX.suffix();
        Object var20_6 = null;
        string2 = null;
        File offsetIndexFile = TestUtils.tempFile((String)tempFile_prefix2, (String)tempFile_suffix2);
        String string3 = ".tmp";
        String tempFile_prefix3 = E2EChecksumProtectedObjectType.TIMESTAMP_INDEX.suffix();
        Object var22_9 = null;
        string3 = null;
        File timeStampIndexFile = TestUtils.tempFile((String)tempFile_prefix3, (String)tempFile_suffix);
        String segCrcEntryKey = segFile.getAbsolutePath();
        store.initializeEntry(segCrcEntryKey);
        EncryptionKeyManager encryptionKeyManager = new EncryptionKeyManager((Time)this.mockTime(), null, this.masterKey(), Duration.ofSeconds(30L));
        KeySha keySha = encryptionKeyManager.activeKeySha();
        OpaqueData opaqueData = OpaqueData.fromByteArray((byte[])keySha.toRawBytes());
        KeyContext expectedKeyContext = encryptionKeyManager.keyContext(keySha);
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), encryptionKeyManager, this.config(), Optional.of(this.checksumStore()));
        ObjectMetadata metadata = new ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, opaqueData, null);
        ArgumentCaptor blobInfos = ArgumentCaptor.forClass(BlobInfo.class);
        ArgumentCaptor writeOptions = ArgumentCaptor.forClass(Storage.BlobWriteOption[].class);
        objectStore.putSegment(metadata, segFile, offsetIndexFile, timeStampIndexFile, Optional.of(this.testFile()), Optional.empty(), Optional.empty());
        Assertions.assertFalse((boolean)store.get(segCrcEntryKey).isPresent());
        int noOfWriterCalls = 4;
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)noOfWriterCalls))).writer((BlobInfo)blobInfos.capture(), (Storage.BlobWriteOption[])writeOptions.capture());
        List blobInfoList = TierTestUtils$.MODULE$.getAllCapturedValuesAsList(blobInfos);
        List writeOptionList = (List)TierTestUtils$.MODULE$.getAllCapturedValuesAsList(writeOptions).flatten((Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs));
        ObjectRef expectedWriteOptionsList = ObjectRef.create((Object)package$.MODULE$.List().empty());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), noOfWriterCalls).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            String blobName = ((BlobInfo)blobInfoList.apply(i)).getName();
            String crc = ((BlobInfo)blobInfoList.apply(i)).getCrc32c();
            String crcInMetadata = (String)((BlobInfo)blobInfoList.apply(i)).getMetadata().get("crc32c");
            Assertions.assertEquals((Object)crc, (Object)crcInMetadata);
            if (blobName.contains(E2EChecksumProtectedObjectType.SEGMENT.suffix())) {
                Assertions.assertEquals((Object)this.CRC_DEFAULT_VALUE(), (Object)crc);
                expectedWriteOptionsList$3.elem = (List)((List)expectedWriteOptionsList$3.elem).$colon$plus((Object)Storage.BlobWriteOption.encryptionKey((String)expectedKeyContext$1.cleartextDataKey.base64Encoded()));
                expectedWriteOptionsList$3.elem = (List)((List)expectedWriteOptionsList$3.elem).$plus$plus(this.blobWriteOptionsWithCrc());
                return;
            }
            Assertions.assertEquals(null, (Object)crc);
            expectedWriteOptionsList$3.elem = (List)((List)expectedWriteOptionsList$3.elem).$plus$plus(this.blobWriteOptionsWithoutCrc());
        });
        Assertions.assertEquals((Object)((List)expectedWriteOptionsList.elem), (Object)writeOptionList);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPutSegmentWhenChecksumIsInvalid() {
        void tempFile_suffix;
        void tempFile_suffix2;
        void tempFile_suffix3;
        this.checksumStore_$eq(new E2EChecksumStore(new E2EChecksumStoreConfig(TierBackend.GCS, Arrays.asList(E2EChecksumProtectedObjectType.getAllValues()), 1000L), Time.SYSTEM, (ChecksumStoreReaderWriter)Mockito.mock(ChecksumStoreReaderWriter.class), new Metrics()));
        ChecksumStore store = this.checksumStore().store();
        String string = ".tmp";
        String tempFile_prefix = E2EChecksumProtectedObjectType.SEGMENT.suffix();
        Object var14_3 = null;
        string = null;
        File segFile = TestUtils.tempFile((String)tempFile_prefix, (String)tempFile_suffix3);
        String string2 = ".tmp";
        String tempFile_prefix2 = E2EChecksumProtectedObjectType.OFFSET_INDEX.suffix();
        Object var16_6 = null;
        string2 = null;
        File offsetIndexFile = TestUtils.tempFile((String)tempFile_prefix2, (String)tempFile_suffix2);
        String string3 = ".tmp";
        String tempFile_prefix3 = E2EChecksumProtectedObjectType.TIMESTAMP_INDEX.suffix();
        Object var18_9 = null;
        string3 = null;
        File timeStampIndexFile = TestUtils.tempFile((String)tempFile_prefix3, (String)tempFile_suffix);
        String offsetCrcEntryKey = offsetIndexFile.getAbsolutePath();
        String timestampCrcEntryKey = timeStampIndexFile.getAbsolutePath();
        store.initializeEntry(offsetCrcEntryKey);
        store.initializeEntry(timestampCrcEntryKey);
        store.update(offsetCrcEntryKey, 1);
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), null, this.config(), Optional.of(this.checksumStore()));
        ArgumentCaptor blobInfos = ArgumentCaptor.forClass(BlobInfo.class);
        ArgumentCaptor writeOptions = ArgumentCaptor.forClass(Storage.BlobWriteOption[].class);
        objectStore.putSegment(this.metadata(), segFile, offsetIndexFile, timeStampIndexFile, Optional.of(this.testFile()), Optional.empty(), Optional.empty());
        Assertions.assertFalse((boolean)store.get(offsetCrcEntryKey).isPresent());
        Assertions.assertFalse((boolean)store.get(timestampCrcEntryKey).isPresent());
        int noOfWriterCalls = 4;
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)noOfWriterCalls))).writer((BlobInfo)blobInfos.capture(), (Storage.BlobWriteOption[])writeOptions.capture());
        List blobInfoList = TierTestUtils$.MODULE$.getAllCapturedValuesAsList(blobInfos);
        List writeOptionList = (List)TierTestUtils$.MODULE$.getAllCapturedValuesAsList(writeOptions).flatten((Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs));
        ObjectRef expectedWriteOptionsList = ObjectRef.create((Object)package$.MODULE$.List().empty());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), noOfWriterCalls).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            String blobName = ((BlobInfo)blobInfoList.apply(i)).getName();
            String crc = ((BlobInfo)blobInfoList.apply(i)).getCrc32c();
            String crcInMetadata = (String)((BlobInfo)blobInfoList.apply(i)).getMetadata().get("crc32c");
            Assertions.assertEquals((Object)crc, (Object)crcInMetadata);
            if (blobName.contains(E2EChecksumProtectedObjectType.SEGMENT.suffix())) {
                Assertions.assertEquals(null, (Object)crc);
                expectedWriteOptionsList$4.elem = (List)((List)expectedWriteOptionsList$4.elem).$plus$plus(this.blobWriteOptionsWithoutCrc());
                return;
            }
            if (blobName.contains(E2EChecksumProtectedObjectType.OFFSET_INDEX.suffix())) {
                Assertions.assertEquals((Object)this.CRC_1_VALUE(), (Object)crc);
                expectedWriteOptionsList$4.elem = (List)((List)expectedWriteOptionsList$4.elem).$plus$plus(this.blobWriteOptionsWithCrc());
                return;
            }
            if (blobName.contains(E2EChecksumProtectedObjectType.TIMESTAMP_INDEX.suffix())) {
                Assertions.assertEquals((Object)this.CRC_DEFAULT_VALUE(), (Object)crc);
                expectedWriteOptionsList$4.elem = (List)((List)expectedWriteOptionsList$4.elem).$plus$plus(this.blobWriteOptionsWithCrc());
                return;
            }
            if (blobName.contains(E2EChecksumProtectedObjectType.PRODUCER_STATE.suffix())) {
                Assertions.assertEquals(null, (Object)crc);
                expectedWriteOptionsList$4.elem = (List)((List)expectedWriteOptionsList$4.elem).$plus$plus(this.blobWriteOptionsWithoutCrc());
                return;
            }
        });
        Assertions.assertEquals((Object)((List)expectedWriteOptionsList.elem), (Object)writeOptionList);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPutSegmentWhenChecksumMismatch() {
        void tempFile_suffix;
        void tempFile_suffix2;
        void tempFile_suffix3;
        this.checksumStore_$eq(new E2EChecksumStore(new E2EChecksumStoreConfig(TierBackend.GCS, Arrays.asList(E2EChecksumProtectedObjectType.getAllValues()), 1000L), Time.SYSTEM, (ChecksumStoreReaderWriter)Mockito.mock(ChecksumStoreReaderWriter.class), new Metrics()));
        ChecksumStore store = this.checksumStore().store();
        String string = ".tmp";
        String tempFile_prefix = E2EChecksumProtectedObjectType.SEGMENT.suffix();
        Object var9_3 = null;
        string = null;
        File segFile = TestUtils.tempFile((String)tempFile_prefix, (String)tempFile_suffix3);
        String string2 = ".tmp";
        String tempFile_prefix2 = E2EChecksumProtectedObjectType.OFFSET_INDEX.suffix();
        Object var11_6 = null;
        string2 = null;
        File offsetIndexFile = TestUtils.tempFile((String)tempFile_prefix2, (String)tempFile_suffix2);
        String string3 = ".tmp";
        String tempFile_prefix3 = E2EChecksumProtectedObjectType.TIMESTAMP_INDEX.suffix();
        Object var13_9 = null;
        string3 = null;
        File timeStampIndexFile = TestUtils.tempFile((String)tempFile_prefix3, (String)tempFile_suffix);
        String segCrcEntryKey = segFile.getAbsolutePath();
        String offsetCrcEntryKey = offsetIndexFile.getAbsolutePath();
        String timestampCrcEntryKey = timeStampIndexFile.getAbsolutePath();
        store.initializeEntry(segCrcEntryKey);
        store.initializeEntry(offsetCrcEntryKey);
        store.initializeEntry(timestampCrcEntryKey);
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), null, this.config(), Optional.of(this.checksumStore()));
        Mockito.when((Object)this.storage().writer((BlobInfo)ArgumentMatchers.any(), new Storage.BlobWriteOption[]{(Storage.BlobWriteOption)ArgumentMatchers.any()})).thenThrow(new Throwable[]{new StorageException(400, "Provided CRC32C <OUR_CRC> doesn't match calculated CRC32C <ACTUAL_CRC>")});
        Assertions.assertThrows(E2EChecksumInvalidException.class, () -> objectStore.putSegment(this.metadata(), segFile, offsetIndexFile, timeStampIndexFile, Optional.of(this.testFile()), Optional.empty(), Optional.empty()));
        Assertions.assertFalse((boolean)store.get(segCrcEntryKey).isPresent());
        Assertions.assertFalse((boolean)store.get(offsetCrcEntryKey).isPresent());
        Assertions.assertFalse((boolean)store.get(timestampCrcEntryKey).isPresent());
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)1))).writer((BlobInfo)ArgumentMatchers.any(), new Storage.BlobWriteOption[]{(Storage.BlobWriteOption)ArgumentMatchers.any()});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPutInMemorySegmentWhenChecksumMismatch() {
        void tempFile_suffix;
        void tempFile_suffix2;
        void tempFile_suffix3;
        this.checksumStore_$eq(new E2EChecksumStore(new E2EChecksumStoreConfig(TierBackend.GCS, Arrays.asList(E2EChecksumProtectedObjectType.getAllValues()), 1000L), Time.SYSTEM, (ChecksumStoreReaderWriter)Mockito.mock(ChecksumStoreReaderWriter.class), new Metrics()));
        ChecksumStore store = this.checksumStore().store();
        String string = ".tmp";
        String tempFile_prefix = E2EChecksumProtectedObjectType.SEGMENT.suffix();
        Object var9_3 = null;
        string = null;
        File segFile = TestUtils.tempFile((String)tempFile_prefix, (String)tempFile_suffix3);
        String string2 = ".tmp";
        String tempFile_prefix2 = E2EChecksumProtectedObjectType.OFFSET_INDEX.suffix();
        Object var11_6 = null;
        string2 = null;
        File offsetIndexFile = TestUtils.tempFile((String)tempFile_prefix2, (String)tempFile_suffix2);
        String string3 = ".tmp";
        String tempFile_prefix3 = E2EChecksumProtectedObjectType.TIMESTAMP_INDEX.suffix();
        Object var13_9 = null;
        string3 = null;
        File timeStampIndexFile = TestUtils.tempFile((String)tempFile_prefix3, (String)tempFile_suffix);
        String segCrcEntryKey = segFile.getAbsolutePath();
        String offsetCrcEntryKey = offsetIndexFile.getAbsolutePath();
        String timestampCrcEntryKey = timeStampIndexFile.getAbsolutePath();
        store.initializeEntry(segCrcEntryKey);
        store.initializeEntry(offsetCrcEntryKey);
        store.initializeEntry(timestampCrcEntryKey);
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), null, this.config(), Optional.of(this.checksumStore()));
        Mockito.when((Object)this.storage().writer((BlobInfo)ArgumentMatchers.any(BlobInfo.class), (Storage.BlobWriteOption[])ArgumentMatchers.any(Storage.BlobWriteOption[].class))).thenThrow(new Throwable[]{new StorageException(400, "Provided CRC32C <OUR_CRC> doesn't match calculated CRC32C <ACTUAL_CRC>")});
        Assertions.assertThrows(E2EChecksumInvalidException.class, () -> objectStore.putInMemorySegment(this.metadata(), segFile, offsetIndexFile, timeStampIndexFile, Optional.empty(), Optional.empty(), Optional.empty()));
        Assertions.assertFalse((boolean)store.get(segCrcEntryKey).isPresent());
        Assertions.assertFalse((boolean)store.get(offsetCrcEntryKey).isPresent());
        Assertions.assertFalse((boolean)store.get(timestampCrcEntryKey).isPresent());
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)1))).writer((BlobInfo)ArgumentMatchers.any(), (Storage.BlobWriteOption[])ArgumentMatchers.any(Storage.BlobWriteOption[].class));
    }

    public static final /* synthetic */ boolean $anonfun$testEncryptedSegmentReadUsesEncryptionKeyManager$1(ObjectType check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ void $anonfun$testEncryptedSegmentReadUsesEncryptionKeyManager$2(GcsTierObjectStoreTest $this, ObjectType objectType) {
        FragmentType fragmentType = (FragmentType)objectType.getDesignatedFragmentType().get();
        EncryptionKeyManager encryptionKeyManager = new EncryptionKeyManager((Time)$this.mockTime(), null, $this.masterKey(), Duration.ofSeconds(30L));
        KeySha keySha = encryptionKeyManager.activeKeySha();
        OpaqueData opaqueData = OpaqueData.fromByteArray((byte[])keySha.toRawBytes());
        KeyContext expectedKeyContext = encryptionKeyManager.keyContext(keySha);
        GcsTierObjectStore objectStore = new GcsTierObjectStore($this.storage(), encryptionKeyManager, $this.config(), Optional.of($this.checksumStore()));
        ObjectMetadata metadata = new ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, opaqueData, null);
        ReadChannel reader = (ReadChannel)Mockito.mock(ReadChannel.class);
        if (fragmentType.equals((Object)FragmentType.SEGMENT)) {
            Mockito.when((Object)$this.storage().reader((BlobId)ArgumentMatchers.any(), (Storage.BlobSourceOption[])ArgumentMatchers.any())).thenReturn((Object)reader);
        } else {
            Mockito.when((Object)$this.storage().reader((BlobId)ArgumentMatchers.any(), new Storage.BlobSourceOption[0])).thenReturn((Object)reader);
        }
        objectStore.getObjectStoreFragment((ObjectStoreMetadata)metadata, fragmentType);
        if (fragmentType.equals((Object)FragmentType.SEGMENT)) {
            ((Storage)Mockito.verify((Object)$this.storage(), (VerificationMode)Mockito.times((int)1))).reader((BlobId)ArgumentMatchers.any(), new Storage.BlobSourceOption[]{(Storage.BlobSourceOption)ArgumentMatchers.eq((Object)Storage.BlobSourceOption.decryptionKey((String)expectedKeyContext.cleartextDataKey.base64Encoded()))});
        } else {
            ((Storage)Mockito.verify((Object)$this.storage(), (VerificationMode)Mockito.never())).reader((BlobId)ArgumentMatchers.any(), new Storage.BlobSourceOption[]{(Storage.BlobSourceOption)ArgumentMatchers.eq((Object)Storage.BlobSourceOption.decryptionKey((String)expectedKeyContext.cleartextDataKey.base64Encoded()))});
        }
        Mockito.reset((Object[])new Storage[]{$this.storage()});
        $this.setup();
    }

    public static final /* synthetic */ boolean $anonfun$testEncryptedReadRefreshesCache$1(ObjectType check$ifrefutable$2) {
        return check$ifrefutable$2 != null;
    }

    public static final /* synthetic */ void $anonfun$testEncryptedReadRefreshesCache$2(GcsTierObjectStoreTest $this, ObjectType objectType) {
        FragmentType fragmentType = (FragmentType)objectType.getDesignatedFragmentType().get();
        EncryptionKeyManager encryptionKeyManager = new EncryptionKeyManager((Time)$this.mockTime(), null, $this.masterKey(), Duration.ofSeconds(30L));
        KeySha keySha = encryptionKeyManager.activeKeySha();
        OpaqueData opaqueData = OpaqueData.fromByteArray((byte[])keySha.toRawBytes());
        KeyContext expectedKeyContext = encryptionKeyManager.keyContext(keySha);
        GcsTierObjectStore objectStore = new GcsTierObjectStore($this.storage(), encryptionKeyManager, $this.config(), Optional.of($this.checksumStore()));
        encryptionKeyManager.clear();
        ObjectMetadata metadata = new ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, opaqueData, null);
        Blob blob = (Blob)Mockito.mock(Blob.class);
        Mockito.when((Object)$this.storage().get((BlobId)ArgumentMatchers.any(), new Storage.BlobGetOption[]{(Storage.BlobGetOption)ArgumentMatchers.eq((Object)Storage.BlobGetOption.fields((Storage.BlobField[])new Storage.BlobField[]{Storage.BlobField.METADATA}))})).thenReturn((Object)blob);
        Mockito.when((Object)blob.getMetadata()).thenReturn((Object)expectedKeyContext.metadata);
        ReadChannel reader = (ReadChannel)Mockito.mock(ReadChannel.class);
        if (fragmentType.equals((Object)FragmentType.SEGMENT)) {
            Mockito.when((Object)$this.storage().reader((BlobId)ArgumentMatchers.any(), new Storage.BlobSourceOption[]{(Storage.BlobSourceOption)ArgumentMatchers.any()})).thenReturn((Object)reader);
        } else {
            Mockito.when((Object)$this.storage().reader((BlobId)ArgumentMatchers.any(), new Storage.BlobSourceOption[0])).thenReturn((Object)reader);
        }
        objectStore.getObjectStoreFragment((ObjectStoreMetadata)metadata, fragmentType);
        if (fragmentType.equals((Object)FragmentType.SEGMENT)) {
            ((Storage)Mockito.verify((Object)$this.storage(), (VerificationMode)Mockito.times((int)1))).reader((BlobId)ArgumentMatchers.any(), new Storage.BlobSourceOption[]{(Storage.BlobSourceOption)ArgumentMatchers.eq((Object)Storage.BlobSourceOption.decryptionKey((String)expectedKeyContext.cleartextDataKey.base64Encoded()))});
            ((Storage)Mockito.verify((Object)$this.storage(), (VerificationMode)Mockito.times((int)1))).get((BlobId)ArgumentMatchers.any(), new Storage.BlobGetOption[]{(Storage.BlobGetOption)ArgumentMatchers.eq((Object)Storage.BlobGetOption.fields((Storage.BlobField[])new Storage.BlobField[]{Storage.BlobField.METADATA}))});
        } else {
            ((Storage)Mockito.verify((Object)$this.storage(), (VerificationMode)Mockito.never())).reader((BlobId)ArgumentMatchers.any(), new Storage.BlobSourceOption[]{(Storage.BlobSourceOption)ArgumentMatchers.eq((Object)Storage.BlobSourceOption.decryptionKey((String)expectedKeyContext.cleartextDataKey.base64Encoded()))});
            ((Storage)Mockito.verify((Object)$this.storage(), (VerificationMode)Mockito.never())).get((BlobId)ArgumentMatchers.any(), new Storage.BlobGetOption[]{(Storage.BlobGetOption)ArgumentMatchers.eq((Object)Storage.BlobGetOption.fields((Storage.BlobField[])new Storage.BlobField[]{Storage.BlobField.METADATA}))});
        }
        Mockito.reset((Object[])new Storage[]{$this.storage()});
        $this.setup();
    }

    public GcsTierObjectStoreTest() {
        AeadConfig.register();
        this.masterKey = (Aead)KeysetHandle.generateNew((KeyTemplate)KeyTemplates.get((String)"AES256_GCM_RAW")).getPrimitive(Aead.class);
        this.blobWriteOptionsWithCrc = new .colon.colon((Object)Storage.BlobWriteOption.doesNotExist(), (List)new .colon.colon((Object)Storage.BlobWriteOption.crc32cMatch(), (List)Nil$.MODULE$));
        this.blobWriteOptionsWithoutCrc = new .colon.colon((Object)Storage.BlobWriteOption.doesNotExist(), (List)Nil$.MODULE$);
        this.checksumStore = TestUtils$.MODULE$.createChecksumStore(TierBackend.GCS);
        this.CRC_DEFAULT_VALUE = "AAAAAA==";
        this.CRC_1_VALUE = "ugzIxA==";
    }

    public class GcsStorageCopyRequestOptionsMatcher<T>
    implements ArgumentMatcher<T> {
        private final Storage.CopyRequest copyRequest;
        public final /* synthetic */ GcsTierObjectStoreTest $outer;

        public Class<?> type() {
            return super.type();
        }

        public Storage.CopyRequest copyRequest() {
            return this.copyRequest;
        }

        public boolean matches(T argument) {
            Storage.CopyRequest other = (Storage.CopyRequest)argument;
            return this.optionListMatches(this.copyRequest().getSourceOptions(), other.getSourceOptions()) && this.optionListMatches(this.copyRequest().getTargetOptions(), other.getTargetOptions());
        }

        public boolean optionListMatches(java.util.List<?> optionList1, java.util.List<?> optionList2) {
            if (optionList1 == null && optionList2 == null) {
                return true;
            }
            if (optionList1 == null) {
                return false;
            }
            if (optionList2 == null) {
                return false;
            }
            if (optionList1.size() != optionList2.size()) {
                return false;
            }
            return optionList1.containsAll(optionList2);
        }

        public /* synthetic */ GcsTierObjectStoreTest kafka$tier$store$GcsTierObjectStoreTest$GcsStorageCopyRequestOptionsMatcher$$$outer() {
            return this.$outer;
        }

        public GcsStorageCopyRequestOptionsMatcher(GcsTierObjectStoreTest $outer, Storage.CopyRequest copyRequest) {
            this.copyRequest = copyRequest;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

