/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkBaseException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbstractPutObjectRequest;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import io.confluent.kafka.storage.checksum.ChecksumStore;
import io.confluent.kafka.storage.checksum.ChecksumStoreReaderWriter;
import io.confluent.kafka.storage.checksum.E2EChecksumProtectedObjectType;
import io.confluent.kafka.storage.checksum.E2EChecksumStore;
import io.confluent.kafka.storage.checksum.E2EChecksumStoreConfig;
import io.confluent.kafka.storage.checksum.E2EChecksumUtils;
import io.confluent.kafka.storage.tier.TierBackend;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.exceptions.E2EChecksumInvalidException;
import kafka.tier.exceptions.TierObjectStoreFatalException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.state.SegmentAndMetadataLayout;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.S3TierObjectStore;
import kafka.tier.store.S3TierObjectStoreConfig;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.objects.FragmentDescriptionWrapper;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;
import kafka.utils.TestUtils$;
import kafka.utils.Throttler;
import org.apache.directory.api.util.IOUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.Int$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.exception.RetryableException;
import software.amazon.awssdk.core.internal.async.ByteArrayAsyncResponseTransformer;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;

@ScalaSignature(bytes="\u0006\u0005\t]b\u0001B\u00181\u0001]BQA\u0010\u0001\u0005\u0002}BqA\u0011\u0001C\u0002\u0013\u00051\t\u0003\u0004M\u0001\u0001\u0006I\u0001\u0012\u0005\b\u001b\u0002\u0011\r\u0011\"\u0001O\u0011\u0019I\u0006\u0001)A\u0005\u001f\"9!\f\u0001b\u0001\n\u0003q\u0005BB.\u0001A\u0003%q\nC\u0004]\u0001\t\u0007I\u0011\u0001(\t\ru\u0003\u0001\u0015!\u0003P\u0011\u001dq\u0006A1A\u0005\u00029Caa\u0018\u0001!\u0002\u0013y\u0005b\u00021\u0001\u0005\u0004%\tA\u0014\u0005\u0007C\u0002\u0001\u000b\u0011B(\t\u000f\t\u0004!\u0019!C\u0001G\"1\u0001\u000f\u0001Q\u0001\n\u0011Dq!\u001d\u0001C\u0002\u0013\u0005!\u000f\u0003\u0004\u0000\u0001\u0001\u0006Ia\u001d\u0005\n\u0003\u0003\u0001!\u0019!C\u0001\u0003\u0007A\u0001\"a\u0003\u0001A\u0003%\u0011Q\u0001\u0005\n\u0003\u001b\u0001!\u0019!C\u0001\u0003\u001fA\u0001\"!\b\u0001A\u0003%\u0011\u0011\u0003\u0005\n\u0003?\u0001!\u0019!C\u0001\u0003CA\u0001\"!\r\u0001A\u0003%\u00111\u0005\u0005\n\u0003g\u0001\u0001\u0019!C\u0001\u0003kA\u0011\"a\u0014\u0001\u0001\u0004%\t!!\u0015\t\u0011\u0005u\u0003\u0001)Q\u0005\u0003oAq!a\u0018\u0001\t\u0003\t\t\u0007C\u0004\u0002~\u0001!\t!!\u0019\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002b!9\u00111\u0012\u0001\u0005\u0002\u0005\u0005\u0004bBAH\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0003'\u0003A\u0011AA1\u0011\u001d\t9\n\u0001C\u0001\u0003CBq!a'\u0001\t\u0003\t\t\u0007C\u0004\u0002 \u0002!\t!!)\t\u000f\u0005E\u0007\u0001\"\u0001\u0002b!9\u0011Q\u001b\u0001\u0005\u0002\u0005\u0005\u0004bBAm\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0003;\u0004A\u0011AA1\u0011\u001d\t\t\u000f\u0001C\u0001\u0003CBq!!:\u0001\t\u0003\t9\u000fC\u0004\u0002t\u0002!\t!!\u0019\t\u000f\u0005]\b\u0001\"\u0001\u0002b!9\u00111 \u0001\u0005\u0002\u0005\u0005\u0004bBA\u0000\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0005\u0007\u0001A\u0011\u0002B\u0003\u0005U\u00196\u0007V5fe>\u0013'.Z2u'R|'/\u001a+fgRT!!\r\u001a\u0002\u000bM$xN]3\u000b\u0005M\"\u0014\u0001\u0002;jKJT\u0011!N\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\b\u0005\u0002:y5\t!HC\u0001<\u0003\u0015\u00198-\u00197b\u0013\ti$H\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0003\"!\u0011\u0001\u000e\u0003A\nQb\u0011*DgI\u001au\fS#B\t\u0016\u0013V#\u0001#\u0011\u0005\u0015SU\"\u0001$\u000b\u0005\u001dC\u0015\u0001\u00027b]\u001eT\u0011!S\u0001\u0005U\u00064\u0018-\u0003\u0002L\r\n11\u000b\u001e:j]\u001e\fab\u0011*DgI\u001au\fS#B\t\u0016\u0013\u0006%A\tD%\u000e{F)\u0012$B+2#vLV!M+\u0016+\u0012a\u0014\t\u0003!^s!!U+\u0011\u0005IST\"A*\u000b\u0005Q3\u0014A\u0002\u001fs_>$h(\u0003\u0002Wu\u00051\u0001K]3eK\u001aL!a\u0013-\u000b\u0005YS\u0014AE\"S\u0007~#UIR!V\u0019R{f+\u0011'V\u000b\u0002\nA#\u0012-Q\u000b\u000e#V\tR0T\u000b\u001ekUI\u0014+`\u0007J\u001b\u0015!F#Y!\u0016\u001bE+\u0012#`'\u0016;U*\u0012(U?\u000e\u00136\tI\u0001\u001a\u000bb\u0003Vi\u0011+F\t~{eIR*F)~Ke\nR#Y?\u000e\u00136)\u0001\u000eF1B+5\tV#E?>3eiU#U?&sE)\u0012-`\u0007J\u001b\u0005%A\fF1B+5\tV#E?RKU*R0J\u001d\u0012+\u0005lX\"S\u0007\u0006AR\t\u0017)F\u0007R+Ei\u0018+J\u001b\u0016{\u0016J\u0014#F1~\u001b%k\u0011\u0011\u00027\u0015C\u0006+R\"U\u000b\u0012{\u0006KU(E+\u000e+%kX*U\u0003R+ul\u0011*D\u0003q)\u0005\fU#D)\u0016#u\f\u0015*P\tV\u001bUIU0T)\u0006#ViX\"S\u0007\u0002\naa\u00197jK:$X#\u00013\u0011\u0005\u0015tW\"\u00014\u000b\u0005\u001dD\u0017AA:4\u0015\tI'.\u0001\u0005tKJ4\u0018nY3t\u0015\tYG.A\u0005b[\u0006TxN\\1xg*\tQ.A\u0002d_6L!a\u001c4\u0003\u0011\u0005k\u0017M_8o'N\nqa\u00197jK:$\b%A\u0006bgft7m\u00117jK:$X#A:\u0011\u0005QlX\"A;\u000b\u0005\u001d4(BA5x\u0015\tA\u00180\u0001\u0004boN\u001cHm\u001b\u0006\u0003un\fa!Y7bu>t'\"\u0001?\u0002\u0011M|g\r^<be\u0016L!A`;\u0003\u001bM\u001b\u0014i]=oG\u000ec\u0017.\u001a8u\u00031\t7/\u001f8d\u00072LWM\u001c;!\u0003\u0019\u0019wN\u001c4jOV\u0011\u0011Q\u0001\t\u0004\u0003\u0006\u001d\u0011bAA\u0005a\t92k\r+jKJ|%M[3diN#xN]3D_:4\u0017nZ\u0001\bG>tg-[4!\u0003!!Xm\u001d;GS2,WCAA\t!\u0011\t\u0019\"!\u0007\u000e\u0005\u0005U!bAA\f\u0011\u0006\u0011\u0011n\\\u0005\u0005\u00037\t)B\u0001\u0003GS2,\u0017!\u0003;fgR4\u0015\u000e\\3!\u0003!iW\r^1eCR\fWCAA\u0012!\u0011\t)#!\f\u000e\u0005\u0005\u001d\"\u0002BA\u0010\u0003SQ1!a\u000b1\u0003\u001dy'M[3diNLA!a\f\u0002(\tqqJ\u00196fGRlU\r^1eCR\f\u0017!C7fi\u0006$\u0017\r^1!\u00035\u0019\u0007.Z2lgVl7\u000b^8sKV\u0011\u0011q\u0007\t\u0005\u0003s\tY%\u0004\u0002\u0002<)!\u0011QHA \u0003!\u0019\u0007.Z2lgVl'\u0002BA!\u0003\u0007\nqa\u001d;pe\u0006<WMC\u00026\u0003\u000bRA!a\u0012\u0002J\u0005I1m\u001c8gYV,g\u000e\u001e\u0006\u0003\u0003/IA!!\u0014\u0002<\t\u0001RIM#DQ\u0016\u001c7n];n'R|'/Z\u0001\u0012G\",7m[:v[N#xN]3`I\u0015\fH\u0003BA*\u00033\u00022!OA+\u0013\r\t9F\u000f\u0002\u0005+:LG\u000fC\u0005\u0002\\e\t\t\u00111\u0001\u00028\u0005\u0019\u0001\u0010J\u0019\u0002\u001d\rDWmY6tk6\u001cFo\u001c:fA\u0005)1/\u001a;vaR\u0011\u00111\u000b\u0015\u00047\u0005\u0015\u0004\u0003BA4\u0003sj!!!\u001b\u000b\t\u0005-\u0014QN\u0001\u0004CBL'\u0002BA8\u0003c\nqA[;qSR,'O\u0003\u0003\u0002t\u0005U\u0014!\u00026v]&$(BAA<\u0003\ry'oZ\u0005\u0005\u0003w\nIG\u0001\u0006CK\u001a|'/Z#bG\"\fq\u0007^3tiRC\u0017\r\u001e)s_B,'/\u0012:s_JL5OU3ukJtW\r\u001a$pe&s7m\u001c:sK\u000e$(+Z4j_:\u001cV\r\u001e;j]\u001e\u001c\bf\u0001\u000f\u0002\u0002B!\u0011qMAB\u0013\u0011\t))!\u001b\u0003\tQ+7\u000f^\u0001\u000ei\u0016\u001cHoU5oO2,\u0007+\u001e;)\u0007u\t\t)\u0001\u000fuKN$8+\u001b8hY\u0016\u0004V\u000f^,ji\"\f%m\u001c:uK\u0012$\u0006P\\:)\u0007y\t\t)\u0001\u0013uKN$8+\u001b8hY\u0016\u0004V\u000f\u001e)s_\u0012,8-\u001a:Ti\u0006$X-\u00129pG\"\u001cF/\u0019;fQ\ry\u0012\u0011Q\u0001\u0011i\u0016\u001cH/\u0012=qK\u000e$()^2lKRD3\u0001IAA\u0003E!Xm\u001d;EK2,G/Z*fO6,g\u000e\u001e\u0015\u0004C\u0005\u0005\u0015!\b;fgR$U\r\\3uKN+w-\\3oi^KG\u000f[!mY\u001aKG.Z:)\u0007\t\n\t)A\u0014uKN$\b+\u001e;TK\u001elWM\u001c;XSRD7I]2F]\u0006\u0014G.\u001a3G_J\fE\u000e\u001c$jY\u0016\u001cH\u0003BA*\u0003GCq!!*$\u0001\u0004\t9+A\u0006jgRC'o\u001c;uY\u0016$\u0007cA\u001d\u0002*&\u0019\u00111\u0016\u001e\u0003\u000f\t{w\u000e\\3b]\"\u001a1%a,\u0011\t\u0005E\u0016qW\u0007\u0003\u0003gSA!!.\u0002n\u00051\u0001/\u0019:b[NLA!!/\u00024\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;)\u000f\r\ni,!3\u0002LB!\u0011qXAc\u001b\t\t\tM\u0003\u0003\u0002D\u0006M\u0016\u0001\u00039s_ZLG-\u001a:\n\t\u0005\u001d\u0017\u0011\u0019\u0002\f-\u0006dW/Z*pkJ\u001cW-\u0001\u0005c_>dW-\u00198tY\u0011\ti-a4\u001a\u0003\u0005I\u0012\u0001A\u0001(i\u0016\u001cH\u000fU;u'\u0016<W.\u001a8u/&$\bn\u0011:d\u000b:\f'\r\\3e\r>\u0014Hk^8GS2,7\u000fK\u0002%\u0003\u0003\u000ba\u0005^3tiB+HoU3h[\u0016tGoV5uQ\u000e\u00138-\u00128bE2,GMR8s\u001f:,g)\u001b7fQ\r)\u0013\u0011Q\u0001$i\u0016\u001cH\u000fU;u'\u0016<W.\u001a8u/\",gn\u00115fG.\u001cX/\\%t\u0013:4\u0018\r\\5eQ\r1\u0013\u0011Q\u0001#i\u0016\u001cH\u000fU;u'\u0016<W.\u001a8u/\",gn\u00115fG.\u001cX/\\'jg6\fGo\u00195)\u0007\u001d\n\t)\u0001\u0016uKN$\b+\u001e;J]6+Wn\u001c:z'\u0016<W.\u001a8u/\",gn\u00115fG.\u001cX/\\'jg6\fGo\u00195)\u0007!\n\t)A\u0007uKN$x)\u001a;PE*,7\r\u001e\u000b\u0005\u0003'\nI\u000fC\u0004\u0002l&\u0002\r!a*\u0002#\u0005\u001c\u0018P\\2GKR\u001c\u0007.\u00128bE2,G\rK\u0002*\u0003_Cs!KA_\u0003\u0013\f\t\u0010\f\u0003\u0002N\u0006=\u0017A\u0007;fgR<U\r^(cU\u0016\u001cGo\u00117jK:$h)Y5mkJ,\u0007f\u0001\u0016\u0002\u0002\u0006qB/Z:u\u000f\u0016$xJ\u00196fGRtuN\\\"mS\u0016tGOR1jYV\u0014Xm\u001d\u0015\u0004W\u0005\u0005\u0015!\t;fgR<U\r^#naRLhI]1h[\u0016tG/\u00138F[B$\u0018p\u00142kK\u000e$\bf\u0001\u0017\u0002\u0002\u0006\u0011D/Z:u%\u00164'/Z:i\u0007J,G-\u001a8uS\u0006d7/\u00114uKJ\u001c6'\u0012=qSJ,G\rV8lK:,\u0005pY3qi&|g\u000eK\u0002.\u0003\u0003\u000b1\b];u'\u0016<W.\u001a8u\u0003:$7\t[3dW\u001a{'/\u0012=qK\u000e$X\rZ#yG\u0016\u0004H/[8o\u0003:$'+\u001a4sKND7I]3eK:$\u0018.\u00197t)1\t\u0019Fa\u0002\u0003\u0012\tM!q\u0003B\u0014\u0011\u001d\u0011IA\fa\u0001\u0005\u0017\t1b\u001c2kK\u000e$8\u000b^8sKB\u0019\u0011I!\u0004\n\u0007\t=\u0001GA\tTgQKWM](cU\u0016\u001cGo\u0015;pe\u0016Dq!a\b/\u0001\u0004\t\u0019\u0003C\u0004\u0003\u00169\u0002\r!!\u0005\u0002\u0017M,w-\\3oi\u0012\u000bG/\u0019\u0005\b\u00053q\u0003\u0019\u0001B\u000e\u0003M\u0019'/\u001a3f]RL\u0017\r\\:Qe>4\u0018\u000eZ3s!\u0011\u0011iBa\t\u000e\u0005\t}!b\u0001B\u0011U\u0006!\u0011-\u001e;i\u0013\u0011\u0011)Ca\b\u0003-\u0005;6k\u0011:fI\u0016tG/[1mgB\u0013xN^5eKJDqA!\u000b/\u0001\u0004\u0011Y#A\tfqB,7\r^3e\u000bb\u001cW\r\u001d;j_:\u0004BA!\f\u000345\u0011!q\u0006\u0006\u0004\u0005c1\u0017!B7pI\u0016d\u0017\u0002\u0002B\u001b\u0005_\u0011\u0011#Q7bu>t7kM#yG\u0016\u0004H/[8o\u0001")
public class S3TierObjectStoreTest {
    private final String CRC32C_HEADER;
    private final String CRC_DEFAULT_VALUE;
    private final String EXPECTED_SEGMENT_CRC;
    private final String EXPECTED_OFFSET_INDEX_CRC;
    private final String EXPECTED_TIME_INDEX_CRC;
    private final String EXPECTED_PRODUCER_STATE_CRC;
    private final AmazonS3 client = (AmazonS3)Mockito.mock(AmazonS3.class);
    private final S3AsyncClient asyncClient = (S3AsyncClient)Mockito.mock(S3AsyncClient.class);
    private final S3TierObjectStoreConfig config = S3TierObjectStoreConfig.createWithEmptyClusterIdBrokerId((String)"bucket", (String)"region", (String)"credFilePath", (String)"endpoint", (String)"signer", (String)"sseAlgorithm", (String)"", (Integer)Predef$.MODULE$.int2Integer(0), (String)"", (String)"", (Boolean)Predef$.MODULE$.boolean2Boolean(false), (String)"myuserprefix", (String)SslConfigs.DEFAULT_SSL_PROTOCOL, (String)SslConfigs.DEFAULT_SSL_ENABLED_PROTOCOLS, null, null, null, null, null, null, null, null, null);
    private final File testFile = TestUtils.tempFile((String)"kafka", (String)".tmp");
    private final ObjectMetadata metadata = new ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, OpaqueData.ZEROED, null);
    private E2EChecksumStore checksumStore = TestUtils$.MODULE$.createChecksumStore();

    public String CRC32C_HEADER() {
        return this.CRC32C_HEADER;
    }

    public String CRC_DEFAULT_VALUE() {
        return this.CRC_DEFAULT_VALUE;
    }

    public String EXPECTED_SEGMENT_CRC() {
        return this.EXPECTED_SEGMENT_CRC;
    }

    public String EXPECTED_OFFSET_INDEX_CRC() {
        return this.EXPECTED_OFFSET_INDEX_CRC;
    }

    public String EXPECTED_TIME_INDEX_CRC() {
        return this.EXPECTED_TIME_INDEX_CRC;
    }

    public String EXPECTED_PRODUCER_STATE_CRC() {
        return this.EXPECTED_PRODUCER_STATE_CRC;
    }

    public AmazonS3 client() {
        return this.client;
    }

    public S3AsyncClient asyncClient() {
        return this.asyncClient;
    }

    public S3TierObjectStoreConfig config() {
        return this.config;
    }

    public File testFile() {
        return this.testFile;
    }

    public ObjectMetadata metadata() {
        return this.metadata;
    }

    public E2EChecksumStore checksumStore() {
        return this.checksumStore;
    }

    public void checksumStore_$eq(E2EChecksumStore x$1) {
        this.checksumStore = x$1;
    }

    @BeforeEach
    public void setup() {
        Mockito.when((Object)this.client().getBucketLocation("bucket")).thenReturn((Object)"region");
    }

    @Test
    public void testThatProperErrorIsReturnedForIncorrectRegionSettings() {
        Assertions.assertEquals((Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            S3TierObjectStoreConfig config = S3TierObjectStoreConfig.createWithEmptyClusterIdBrokerId((String)"bucket", (String)"invalid-region", (String)"credFilePath", (String)"endpoint", (String)"signer", (String)"sseAlgorithm", (String)"", (Integer)Predef$.MODULE$.int2Integer(0), (String)"", (String)"", (Boolean)Predef$.MODULE$.boolean2Boolean(false), (String)"myuserprefix", (String)SslConfigs.DEFAULT_SSL_PROTOCOL, (String)SslConfigs.DEFAULT_SSL_ENABLED_PROTOCOLS, null, null, null, null, null, null, null, null, null);
            new S3TierObjectStore(config, Optional.of(this.checksumStore()));
        })).getMessage(), (Object)"Configured confluent.tier.s3.region 'invalid-region' is not known");
        Assertions.assertEquals((Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            S3TierObjectStoreConfig config = S3TierObjectStoreConfig.createWithEmptyClusterIdBrokerId((String)"bucket", (String)"", (String)"credFilePath", (String)"endpoint", (String)"signer", (String)"sseAlgorithm", (String)"", (Integer)Predef$.MODULE$.int2Integer(0), (String)"", (String)"", (Boolean)Predef$.MODULE$.boolean2Boolean(false), (String)"myuserprefix", (String)SslConfigs.DEFAULT_SSL_PROTOCOL, (String)SslConfigs.DEFAULT_SSL_ENABLED_PROTOCOLS, null, null, null, null, null, null, null, null, null);
            new S3TierObjectStore(config, Optional.of(this.checksumStore()));
        })).getMessage(), (Object)"Configured confluent.tier.s3.region '' is not known");
        Assertions.assertEquals((Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            S3TierObjectStoreConfig config = S3TierObjectStoreConfig.createWithEmptyClusterIdBrokerId((String)"bucket", null, (String)"credFilePath", (String)"endpoint", (String)"signer", (String)"sseAlgorithm", (String)"", (Integer)Predef$.MODULE$.int2Integer(0), (String)"", (String)"", (Boolean)Predef$.MODULE$.boolean2Boolean(false), (String)"myuserprefix", (String)SslConfigs.DEFAULT_SSL_PROTOCOL, (String)SslConfigs.DEFAULT_SSL_ENABLED_PROTOCOLS, null, null, null, null, null, null, null, null, null);
            new S3TierObjectStore(config, Optional.of(this.checksumStore()));
        })).getMessage(), (Object)"Configured confluent.tier.s3.region 'null' is not known");
    }

    @Test
    public void testSinglePut() {
        int segmentSize = 100;
        AmazonS3 client = (AmazonS3)Mockito.mock(AmazonS3.class);
        Mockito.when((Object)client.getBucketLocation("bucket")).thenReturn((Object)"region");
        S3TierObjectStoreConfig config = S3TierObjectStoreConfig.createWithEmptyClusterIdBrokerId((String)"bucket", (String)"region", (String)"credFilePath", (String)"endpoint", (String)"signer", (String)"sseAlgorithm", (String)"", (Integer)Predef$.MODULE$.int2Integer(0), (String)"", (String)"", (Boolean)Predef$.MODULE$.boolean2Boolean(false), (String)"myuserprefix", (String)SslConfigs.DEFAULT_SSL_PROTOCOL, (String)SslConfigs.DEFAULT_SSL_ENABLED_PROTOCOLS, null, null, null, null, null, null, null, null, null);
        S3TierObjectStore objectStore = new S3TierObjectStore(client, null, config, Optional.empty());
        ObjectMetadata metadata = new ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, OpaqueData.ZEROED, null);
        File segmentData = (File)Mockito.mock(File.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)segmentData.length())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(segmentSize)));
        objectStore.putSegment(metadata, segmentData, null, null, Optional.empty(), Optional.empty(), Optional.empty());
        ((AmazonS3)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)3))).putObject((PutObjectRequest)ArgumentMatchers.any());
    }

    @Test
    public void testSinglePutWithAbortedTxns() {
        int segmentSize = 100;
        AmazonS3 client = (AmazonS3)Mockito.mock(AmazonS3.class);
        Mockito.when((Object)client.getBucketLocation("bucket")).thenReturn((Object)"region");
        S3TierObjectStoreConfig config = S3TierObjectStoreConfig.createWithEmptyClusterIdBrokerId((String)"bucket", (String)"region", (String)"credFilePath", (String)"endpoint", (String)"signer", (String)"sseAlgorithm", (String)"", (Integer)Predef$.MODULE$.int2Integer(0), (String)"", (String)"", (Boolean)Predef$.MODULE$.boolean2Boolean(false), (String)"myuserprefix", (String)SslConfigs.DEFAULT_SSL_PROTOCOL, (String)SslConfigs.DEFAULT_SSL_ENABLED_PROTOCOLS, null, null, null, null, null, null, null, null, null);
        S3TierObjectStore objectStore = new S3TierObjectStore(client, null, config, Optional.empty());
        ObjectMetadata metadata = new ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, true, false, false, OpaqueData.ZEROED, null);
        File segmentData = (File)Mockito.mock(File.class);
        ArgumentCaptor captor = ArgumentCaptor.forClass(PutObjectRequest.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)segmentData.length())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(segmentSize)));
        ByteBuffer abortedTxnBuffer = AbortedTxn.toByteBuffer((long)0L, (long)0L, (long)10L, (long)11L);
        objectStore.putSegment(metadata, segmentData, null, null, Optional.empty(), Optional.of(abortedTxnBuffer), Optional.empty());
        ((AmazonS3)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)4))).putObject((PutObjectRequest)captor.capture());
        TierTestUtils$.MODULE$.getAllCapturedValuesAsList(captor).foreach((Function1 & Serializable)request -> {
            S3TierObjectStoreTest.$anonfun$testSinglePutWithAbortedTxns$1(this, abortedTxnBuffer, request);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testSinglePutProducerStateEpochState() {
        int segmentSize = 100;
        AmazonS3 client = (AmazonS3)Mockito.mock(AmazonS3.class);
        Mockito.when((Object)client.getBucketLocation("bucket")).thenReturn((Object)"region");
        S3TierObjectStoreConfig config = S3TierObjectStoreConfig.createWithEmptyClusterIdBrokerId((String)"bucket", (String)"region", (String)"credFilePath", (String)"endpoint", (String)"signer", (String)"sseAlgorithm", (String)"", (Integer)Predef$.MODULE$.int2Integer(0), (String)"", (String)"", (Boolean)Predef$.MODULE$.boolean2Boolean(false), (String)"myuserprefix", (String)SslConfigs.DEFAULT_SSL_PROTOCOL, (String)SslConfigs.DEFAULT_SSL_ENABLED_PROTOCOLS, null, null, null, null, null, null, null, null, null);
        S3TierObjectStore objectStore = new S3TierObjectStore(client, null, config, Optional.empty());
        ObjectMetadata metadata = new ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, true, true, true, OpaqueData.ZEROED, null);
        File segmentData = (File)Mockito.mock(File.class);
        ArgumentCaptor captor = ArgumentCaptor.forClass(PutObjectRequest.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)segmentData.length())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(segmentSize)));
        int producerIndexLength = 100;
        ByteBuffer producerIndexBuf = ByteBuffer.allocate(producerIndexLength);
        producerIndexBuf.limit(producerIndexLength);
        int epochLength = 100;
        ByteBuffer epochBuf = ByteBuffer.allocate(epochLength);
        epochBuf.limit(epochLength);
        objectStore.putSegment(metadata, segmentData, null, null, Optional.of(segmentData), Optional.of(producerIndexBuf), Optional.of(epochBuf));
        ((AmazonS3)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)6))).putObject((PutObjectRequest)captor.capture());
        Assertions.assertEquals((long)producerIndexLength, (long)((AbstractPutObjectRequest)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(captor.getAllValues()).asScala().map((Function1 & Serializable)x$1 -> x$1)).find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)S3TierObjectStoreTest.$anonfun$testSinglePutProducerStateEpochState$2(x$2))).get()).getMetadata().getContentLength());
    }

    @Test
    public void testExpectBucket() {
        AmazonS3 s3Client = (AmazonS3)Mockito.mock(AmazonS3.class);
        Mockito.when((Object)s3Client.getBucketLocation("bucket")).thenReturn((Object)"region");
        S3TierObjectStoreConfig s3Config = S3TierObjectStoreConfig.createWithEmptyClusterIdBrokerId((String)"bucket", (String)"region", (String)"credFilePath", (String)"endpoint", (String)"signer", (String)"sseAlgorithm", (String)"", (Integer)Predef$.MODULE$.int2Integer(0), (String)"", (String)"", (Boolean)Predef$.MODULE$.boolean2Boolean(false), (String)"myuserprefix", (String)SslConfigs.DEFAULT_SSL_PROTOCOL, (String)SslConfigs.DEFAULT_SSL_ENABLED_PROTOCOLS, null, null, null, null, null, null, null, null, null);
        try {
            new S3TierObjectStore(s3Client, null, s3Config, Optional.of(this.checksumStore()));
        }
        catch (TierObjectStoreFatalException e) {
            Assertions.fail((String)new StringBuilder(97).append("Threw a TierObjectStoreFatalException when building S3TierObjectStore for S3 Bucket.\n Exception: ").append(e.getMessage()).toString());
        }
        catch (Exception e) {
            Assertions.fail((String)new StringBuilder(89).append("Threw an unexpected Exception when building S3TierObjectStore for S3 Bucket.\n Exception: ").append(e.getMessage()).toString());
        }
        AmazonS3 onPremClient = (AmazonS3)Mockito.mock(AmazonS3.class);
        Mockito.when((Object)onPremClient.getBucketLocation("bucket")).thenThrow(new Throwable[]{new AmazonS3Exception("Access Denied")});
        S3TierObjectStoreConfig onPremConfig = S3TierObjectStoreConfig.createWithEmptyClusterIdBrokerId((String)"bucket", (String)"region", (String)"credFilePath", (String)"onpremEndpoint", (String)"signer", (String)"sseAlgorithm", (String)"", (Integer)Predef$.MODULE$.int2Integer(0), (String)"", (String)"", (Boolean)Predef$.MODULE$.boolean2Boolean(false), (String)"myuserprefix", (String)SslConfigs.DEFAULT_SSL_PROTOCOL, (String)SslConfigs.DEFAULT_SSL_ENABLED_PROTOCOLS, null, null, null, null, null, null, null, null, null);
        try {
            new S3TierObjectStore(onPremClient, null, onPremConfig, Optional.of(this.checksumStore()));
        }
        catch (TierObjectStoreFatalException e) {
            Assertions.fail((String)new StringBuilder(102).append("Threw a TierObjectStoreFatalException when building S3TierObjectStore for On-Prem Bucket.\n Exception: ").append(e.getMessage()).toString());
            return;
        }
        catch (Exception e) {
            Assertions.fail((String)new StringBuilder(94).append("Threw an unexpected Exception when building S3TierObjectStore for On-Prem Bucket.\n Exception: ").append(e.getMessage()).toString());
        }
    }

    @Test
    public void testDeleteSegment() {
        new S3TierObjectStore(this.client(), null, this.config(), Optional.empty()).deleteSegment(this.metadata());
        ArgumentCaptor captor = ArgumentCaptor.forClass(DeleteObjectsRequest.class);
        ((AmazonS3)Mockito.verify((Object)this.client(), (VerificationMode)Mockito.times((int)1))).deleteObjects((DeleteObjectsRequest)captor.capture());
        List requests = TierTestUtils$.MODULE$.getAllCapturedValuesAsList(captor);
        Assertions.assertEquals((int)1, (int)requests.size());
        Assertions.assertEquals((int)3, (int)((DeleteObjectsRequest)requests.head()).getKeys().size());
    }

    @Test
    public void testDeleteSegmentWithAllFiles() {
        S3TierObjectStore objectStore = new S3TierObjectStore(this.client(), null, this.config(), Optional.empty());
        ObjectMetadata metadataWithAllFiles = new ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, true, true, true, OpaqueData.ZEROED, null);
        objectStore.deleteSegment(metadataWithAllFiles);
        ArgumentCaptor captor = ArgumentCaptor.forClass(DeleteObjectsRequest.class);
        ((AmazonS3)Mockito.verify((Object)this.client(), (VerificationMode)Mockito.times((int)1))).deleteObjects((DeleteObjectsRequest)captor.capture());
        List requests = TierTestUtils$.MODULE$.getAllCapturedValuesAsList(captor);
        Assertions.assertEquals((int)1, (int)requests.size());
        Assertions.assertEquals((int)6, (int)((DeleteObjectsRequest)requests.head()).getKeys().size());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testPutSegmentWithCrcEnabledForAllFiles(boolean isThrottled) {
        this.checksumStore_$eq(new E2EChecksumStore(new E2EChecksumStoreConfig(TierBackend.S3, Arrays.asList(E2EChecksumProtectedObjectType.getAllValues()), 1000L), Time.SYSTEM, (ChecksumStoreReaderWriter)Mockito.mock(ChecksumStoreReaderWriter.class), new Metrics()));
        ChecksumStore store = this.checksumStore().store();
        Optional throttlerOpt = OptionConverters$.MODULE$.toJava((Option)(isThrottled ? new Some(Mockito.mock(Throttler.class)) : None$.MODULE$));
        File segFile = TestUtils.tempFile((String)E2EChecksumProtectedObjectType.SEGMENT.suffix(), (String)".tmp", (String)"abcd");
        long segFileSize = segFile.length();
        File offsetIndexFile = TestUtils.tempFile((String)E2EChecksumProtectedObjectType.OFFSET_INDEX.suffix(), (String)".tmp", (String)"adsad");
        long offsetIndexFileSize = offsetIndexFile.length();
        File timeStampIndexFile = TestUtils.tempFile((String)E2EChecksumProtectedObjectType.TIMESTAMP_INDEX.suffix(), (String)".tmp", (String)"adaddd");
        long timeStampIndexFileSize = timeStampIndexFile.length();
        File producerStateSnapshotFile = TestUtils.tempFile((String)E2EChecksumProtectedObjectType.PRODUCER_STATE.suffix(), (String)".tmp", (String)"adaddd");
        long producerStateSnapshotFileSize = producerStateSnapshotFile.length();
        String segCrcEntryKey = segFile.getAbsolutePath();
        String offsetCrcEntryKey = offsetIndexFile.getAbsolutePath();
        String timestampCrcEntryKey = timeStampIndexFile.getAbsolutePath();
        String producerStateCrcEntryKey = producerStateSnapshotFile.getAbsolutePath();
        store.initializeEntry(segCrcEntryKey);
        store.initializeEntry(offsetCrcEntryKey);
        store.initializeEntry(timestampCrcEntryKey);
        store.initializeEntry(producerStateCrcEntryKey);
        store.update(segCrcEntryKey, 1);
        store.update(offsetCrcEntryKey, 2);
        store.update(timestampCrcEntryKey, 3);
        store.update(producerStateCrcEntryKey, 4);
        new S3TierObjectStore(this.client(), null, this.config(), Optional.of(this.checksumStore())).putSegment(this.metadata(), segFile, offsetIndexFile, timeStampIndexFile, Optional.of(producerStateSnapshotFile), Optional.empty(), Optional.empty(), throttlerOpt);
        ArgumentCaptor captor = ArgumentCaptor.forClass(PutObjectRequest.class);
        ((AmazonS3)Mockito.verify((Object)this.client(), (VerificationMode)Mockito.times((int)4))).putObject((PutObjectRequest)captor.capture());
        Assertions.assertFalse((boolean)store.get(segCrcEntryKey).isPresent());
        Assertions.assertFalse((boolean)store.get(offsetCrcEntryKey).isPresent());
        Assertions.assertFalse((boolean)store.get(timestampCrcEntryKey).isPresent());
        TierTestUtils$.MODULE$.getAllCapturedValuesAsList(captor).foreach((Function1 & Serializable)request -> {
            S3TierObjectStoreTest.$anonfun$testPutSegmentWithCrcEnabledForAllFiles$1(this, isThrottled, segFileSize, offsetIndexFileSize, timeStampIndexFileSize, producerStateSnapshotFileSize, request);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPutSegmentWithCrcEnabledForTwoFiles() {
        void tempFile_contents;
        void tempFile_suffix;
        void tempFile_contents2;
        void tempFile_suffix2;
        void tempFile_suffix3;
        this.checksumStore_$eq(new E2EChecksumStore(new E2EChecksumStoreConfig(TierBackend.S3, Arrays.asList(E2EChecksumProtectedObjectType.OFFSET_INDEX.suffix(), E2EChecksumProtectedObjectType.TIMESTAMP_INDEX.suffix()), 1000L), Time.SYSTEM, (ChecksumStoreReaderWriter)Mockito.mock(ChecksumStoreReaderWriter.class), new Metrics()));
        ChecksumStore store = this.checksumStore().store();
        String string = ".tmp";
        String tempFile_prefix = E2EChecksumProtectedObjectType.SEGMENT.suffix();
        Object var8_3 = null;
        string = null;
        File segFile = TestUtils.tempFile((String)tempFile_prefix, (String)tempFile_suffix3);
        String string2 = "adaa";
        String string3 = ".tmp";
        String tempFile_prefix2 = E2EChecksumProtectedObjectType.OFFSET_INDEX.suffix();
        Object var10_7 = null;
        string3 = null;
        string2 = null;
        File offsetIndexFile = TestUtils.tempFile((String)tempFile_prefix2, (String)tempFile_suffix2, (String)tempFile_contents2);
        String string4 = "kgkj";
        String string5 = ".tmp";
        String tempFile_prefix3 = E2EChecksumProtectedObjectType.TIMESTAMP_INDEX.suffix();
        Object var13_11 = null;
        string5 = null;
        string4 = null;
        File timeStampIndexFile = TestUtils.tempFile((String)tempFile_prefix3, (String)tempFile_suffix, (String)tempFile_contents);
        String offsetCrcEntryKey = offsetIndexFile.getAbsolutePath();
        String timestampCrcEntryKey = timeStampIndexFile.getAbsolutePath();
        store.initializeEntry(offsetCrcEntryKey);
        store.initializeEntry(timestampCrcEntryKey);
        store.update(offsetCrcEntryKey, 2);
        store.update(timestampCrcEntryKey, 3);
        new S3TierObjectStore(this.client(), null, this.config(), Optional.of(this.checksumStore())).putSegment(this.metadata(), segFile, offsetIndexFile, timeStampIndexFile, Optional.empty(), Optional.empty(), Optional.empty());
        ArgumentCaptor captor = ArgumentCaptor.forClass(PutObjectRequest.class);
        ((AmazonS3)Mockito.verify((Object)this.client(), (VerificationMode)Mockito.times((int)3))).putObject((PutObjectRequest)captor.capture());
        Assertions.assertFalse((boolean)store.get(offsetCrcEntryKey).isPresent());
        Assertions.assertFalse((boolean)store.get(timestampCrcEntryKey).isPresent());
        TierTestUtils$.MODULE$.getAllCapturedValuesAsList(captor).foreach((Function1 & Serializable)request -> {
            S3TierObjectStoreTest.$anonfun$testPutSegmentWithCrcEnabledForTwoFiles$1(this, request);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPutSegmentWithCrcEnabledForOneFile() {
        void tempFile_suffix;
        void tempFile_suffix2;
        void tempFile_contents;
        void tempFile_suffix3;
        this.checksumStore_$eq(new E2EChecksumStore(new E2EChecksumStoreConfig(TierBackend.S3, Arrays.asList(E2EChecksumProtectedObjectType.SEGMENT.suffix()), 1000L), Time.SYSTEM, (ChecksumStoreReaderWriter)Mockito.mock(ChecksumStoreReaderWriter.class), new Metrics()));
        ChecksumStore store = this.checksumStore().store();
        String string = "asas";
        String string2 = ".tmp";
        String tempFile_prefix = E2EChecksumProtectedObjectType.SEGMENT.suffix();
        Object var7_4 = null;
        string2 = null;
        string = null;
        File segFile = TestUtils.tempFile((String)tempFile_prefix, (String)tempFile_suffix3, (String)tempFile_contents);
        String string3 = ".tmp";
        String tempFile_prefix2 = E2EChecksumProtectedObjectType.OFFSET_INDEX.suffix();
        Object var10_7 = null;
        string3 = null;
        File offsetIndexFile = TestUtils.tempFile((String)tempFile_prefix2, (String)tempFile_suffix2);
        String string4 = ".tmp";
        String tempFile_prefix3 = E2EChecksumProtectedObjectType.TIMESTAMP_INDEX.suffix();
        Object var12_10 = null;
        string4 = null;
        File timeStampIndexFile = TestUtils.tempFile((String)tempFile_prefix3, (String)tempFile_suffix);
        String segCrcEntryKey = segFile.getAbsolutePath();
        store.initializeEntry(segCrcEntryKey);
        store.update(segCrcEntryKey, 1);
        new S3TierObjectStore(this.client(), null, this.config(), Optional.of(this.checksumStore())).putSegment(this.metadata(), segFile, offsetIndexFile, timeStampIndexFile, Optional.empty(), Optional.empty(), Optional.empty());
        ArgumentCaptor captor = ArgumentCaptor.forClass(PutObjectRequest.class);
        ((AmazonS3)Mockito.verify((Object)this.client(), (VerificationMode)Mockito.times((int)3))).putObject((PutObjectRequest)captor.capture());
        Assertions.assertFalse((boolean)store.get(segCrcEntryKey).isPresent());
        TierTestUtils$.MODULE$.getAllCapturedValuesAsList(captor).foreach((Function1 & Serializable)request -> {
            S3TierObjectStoreTest.$anonfun$testPutSegmentWithCrcEnabledForOneFile$1(this, request);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPutSegmentWhenChecksumIsInvalid() {
        void tempFile_suffix;
        void tempFile_contents;
        void tempFile_suffix2;
        void tempFile_suffix3;
        this.checksumStore_$eq(new E2EChecksumStore(new E2EChecksumStoreConfig(TierBackend.S3, Arrays.asList(E2EChecksumProtectedObjectType.getAllValues()), 1000L), Time.SYSTEM, (ChecksumStoreReaderWriter)Mockito.mock(ChecksumStoreReaderWriter.class), new Metrics()));
        ChecksumStore store = this.checksumStore().store();
        String string = ".tmp";
        String tempFile_prefix = E2EChecksumProtectedObjectType.SEGMENT.suffix();
        Object var8_3 = null;
        string = null;
        File segFile = TestUtils.tempFile((String)tempFile_prefix, (String)tempFile_suffix3);
        String string2 = "random";
        String string3 = ".tmp";
        String tempFile_prefix2 = E2EChecksumProtectedObjectType.OFFSET_INDEX.suffix();
        Object var10_7 = null;
        string3 = null;
        string2 = null;
        File offsetIndexFile = TestUtils.tempFile((String)tempFile_prefix2, (String)tempFile_suffix2, (String)tempFile_contents);
        String string4 = ".tmp";
        String tempFile_prefix3 = E2EChecksumProtectedObjectType.TIMESTAMP_INDEX.suffix();
        Object var13_10 = null;
        string4 = null;
        File timeStampIndexFile = TestUtils.tempFile((String)tempFile_prefix3, (String)tempFile_suffix);
        String offsetCrcEntryKey = offsetIndexFile.getAbsolutePath();
        String timestampCrcEntryKey = timeStampIndexFile.getAbsolutePath();
        store.initializeEntry(offsetCrcEntryKey);
        store.initializeEntry(timestampCrcEntryKey);
        store.update(offsetCrcEntryKey, 1);
        new S3TierObjectStore(this.client(), null, this.config(), Optional.of(this.checksumStore())).putSegment(this.metadata(), segFile, offsetIndexFile, timeStampIndexFile, Optional.empty(), Optional.empty(), Optional.empty());
        Assertions.assertFalse((boolean)store.get(offsetCrcEntryKey).isPresent());
        Assertions.assertFalse((boolean)store.get(timestampCrcEntryKey).isPresent());
        ArgumentCaptor captor = ArgumentCaptor.forClass(PutObjectRequest.class);
        ((AmazonS3)Mockito.verify((Object)this.client(), (VerificationMode)Mockito.times((int)3))).putObject((PutObjectRequest)captor.capture());
        TierTestUtils$.MODULE$.getAllCapturedValuesAsList(captor).foreach((Function1 & Serializable)request -> {
            S3TierObjectStoreTest.$anonfun$testPutSegmentWhenChecksumIsInvalid$1(this, request);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPutSegmentWhenChecksumMismatch() {
        void tempFile_suffix;
        void tempFile_suffix2;
        void tempFile_suffix3;
        this.checksumStore_$eq(new E2EChecksumStore(new E2EChecksumStoreConfig(TierBackend.S3, Arrays.asList(E2EChecksumProtectedObjectType.getAllValues()), 1000L), Time.SYSTEM, (ChecksumStoreReaderWriter)Mockito.mock(ChecksumStoreReaderWriter.class), new Metrics()));
        ChecksumStore store = this.checksumStore().store();
        String string = ".tmp";
        String tempFile_prefix = E2EChecksumProtectedObjectType.SEGMENT.suffix();
        Object var10_3 = null;
        string = null;
        File segFile = TestUtils.tempFile((String)tempFile_prefix, (String)tempFile_suffix3);
        String string2 = ".tmp";
        String tempFile_prefix2 = E2EChecksumProtectedObjectType.OFFSET_INDEX.suffix();
        Object var12_6 = null;
        string2 = null;
        File offsetIndexFile = TestUtils.tempFile((String)tempFile_prefix2, (String)tempFile_suffix2);
        String string3 = ".tmp";
        String tempFile_prefix3 = E2EChecksumProtectedObjectType.TIMESTAMP_INDEX.suffix();
        Object var14_9 = null;
        string3 = null;
        File timeStampIndexFile = TestUtils.tempFile((String)tempFile_prefix3, (String)tempFile_suffix);
        String segCrcEntryKey = segFile.getAbsolutePath();
        String offsetCrcEntryKey = offsetIndexFile.getAbsolutePath();
        String timestampCrcEntryKey = timeStampIndexFile.getAbsolutePath();
        store.initializeEntry(segCrcEntryKey);
        store.initializeEntry(offsetCrcEntryKey);
        store.initializeEntry(timestampCrcEntryKey);
        S3TierObjectStore objectStore = new S3TierObjectStore(this.client(), null, this.config(), Optional.of(this.checksumStore()));
        AmazonS3Exception e = new AmazonS3Exception("The CRC32C you specified did not match the calculated checksum.");
        e.setErrorCode("BadDigest");
        Mockito.when((Object)this.client().putObject((PutObjectRequest)ArgumentMatchers.any())).thenThrow(new Throwable[]{e});
        Assertions.assertThrows(E2EChecksumInvalidException.class, () -> objectStore.putSegment(this.metadata(), segFile, offsetIndexFile, timeStampIndexFile, Optional.empty(), Optional.empty(), Optional.empty()));
        Assertions.assertFalse((boolean)store.get(segCrcEntryKey).isPresent());
        Assertions.assertFalse((boolean)store.get(offsetCrcEntryKey).isPresent());
        Assertions.assertFalse((boolean)store.get(timestampCrcEntryKey).isPresent());
        ((AmazonS3)Mockito.verify((Object)this.client(), (VerificationMode)Mockito.times((int)1))).putObject((PutObjectRequest)ArgumentMatchers.any());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPutInMemorySegmentWhenChecksumMismatch() {
        void tempFile_suffix;
        void tempFile_suffix2;
        void tempFile_suffix3;
        this.checksumStore_$eq(new E2EChecksumStore(new E2EChecksumStoreConfig(TierBackend.S3, Arrays.asList(E2EChecksumProtectedObjectType.getAllValues()), 1000L), Time.SYSTEM, (ChecksumStoreReaderWriter)Mockito.mock(ChecksumStoreReaderWriter.class), new Metrics()));
        ChecksumStore store = this.checksumStore().store();
        String string = ".tmp";
        String tempFile_prefix = E2EChecksumProtectedObjectType.SEGMENT.suffix();
        Object var10_3 = null;
        string = null;
        File segFile = TestUtils.tempFile((String)tempFile_prefix, (String)tempFile_suffix3);
        String string2 = ".tmp";
        String tempFile_prefix2 = E2EChecksumProtectedObjectType.OFFSET_INDEX.suffix();
        Object var12_6 = null;
        string2 = null;
        File offsetIndexFile = TestUtils.tempFile((String)tempFile_prefix2, (String)tempFile_suffix2);
        String string3 = ".tmp";
        String tempFile_prefix3 = E2EChecksumProtectedObjectType.TIMESTAMP_INDEX.suffix();
        Object var14_9 = null;
        string3 = null;
        File timeStampIndexFile = TestUtils.tempFile((String)tempFile_prefix3, (String)tempFile_suffix);
        String segCrcEntryKey = segFile.getAbsolutePath();
        String offsetCrcEntryKey = offsetIndexFile.getAbsolutePath();
        String timestampCrcEntryKey = timeStampIndexFile.getAbsolutePath();
        store.initializeEntry(segCrcEntryKey);
        store.initializeEntry(offsetCrcEntryKey);
        store.initializeEntry(timestampCrcEntryKey);
        S3TierObjectStore objectStore = new S3TierObjectStore(this.client(), null, this.config(), Optional.of(this.checksumStore()));
        AmazonS3Exception e = new AmazonS3Exception("The CRC32C you specified did not match the calculated checksum.");
        e.setErrorCode("BadDigest");
        Mockito.when((Object)this.client().putObject((PutObjectRequest)ArgumentMatchers.any())).thenThrow(new Throwable[]{e});
        Assertions.assertThrows(E2EChecksumInvalidException.class, () -> objectStore.putInMemorySegment(this.metadata(), segFile, offsetIndexFile, timeStampIndexFile, Optional.empty(), Optional.empty(), Optional.empty()));
        Assertions.assertFalse((boolean)store.get(segCrcEntryKey).isPresent());
        Assertions.assertFalse((boolean)store.get(offsetCrcEntryKey).isPresent());
        Assertions.assertFalse((boolean)store.get(timestampCrcEntryKey).isPresent());
        ((AmazonS3)Mockito.verify((Object)this.client(), (VerificationMode)Mockito.times((int)1))).putObject((PutObjectRequest)ArgumentMatchers.any());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testGetObject(boolean asyncFetchEnabled) {
        TierObjectStoreResponse tierObjectStoreResponse;
        S3TierObjectStore objectStore = new S3TierObjectStore(this.client(), Optional.of(this.asyncClient()), null, this.config(), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(Option$.MODULE$.empty())));
        String responseStr = "test stream data";
        if (asyncFetchEnabled) {
            ((S3AsyncClient)Mockito.doAnswer(arg_0 -> S3TierObjectStoreTest.$anonfun$testGetObject$1(ResponseBytes.fromByteArray((Object)Mockito.mock(GetObjectResponse.class), (byte[])responseStr.getBytes()), arg_0)).when((Object)this.asyncClient())).getObject((software.amazon.awssdk.services.s3.model.GetObjectRequest)ArgumentMatchers.any(software.amazon.awssdk.services.s3.model.GetObjectRequest.class), (AsyncResponseTransformer)ArgumentMatchers.any(ByteArrayAsyncResponseTransformer.class));
            tierObjectStoreResponse = (TierObjectStoreResponse)objectStore.getObjectStoreFragmentAsync((ObjectStoreMetadata)this.metadata(), FragmentType.SEGMENT).get();
        } else {
            S3Object s3Object = (S3Object)Mockito.mock(S3Object.class);
            ((AmazonS3)Mockito.doAnswer(x$6 -> s3Object).when((Object)this.client())).getObject((GetObjectRequest)ArgumentMatchers.any(GetObjectRequest.class));
            ((S3Object)Mockito.doAnswer(x$7 -> new S3ObjectInputStream((InputStream)new ByteArrayInputStream(responseStr.getBytes()), (HttpRequestBase)Mockito.mock(HttpRequestBase.class))).when((Object)s3Object)).getObjectContent();
            com.amazonaws.services.s3.model.ObjectMetadata s3ObjectMetadata = (com.amazonaws.services.s3.model.ObjectMetadata)Mockito.mock(com.amazonaws.services.s3.model.ObjectMetadata.class);
            ((S3Object)Mockito.doAnswer(x$8 -> s3ObjectMetadata).when((Object)s3Object)).getObjectMetadata();
            ((com.amazonaws.services.s3.model.ObjectMetadata)Mockito.doAnswer(x$9 -> BoxesRunTime.boxToLong((long)responseStr.length())).when((Object)s3ObjectMetadata)).getContentLength();
            tierObjectStoreResponse = objectStore.getObjectStoreFragment((ObjectStoreMetadata)this.metadata(), FragmentType.SEGMENT);
        }
        TierObjectStoreResponse response = tierObjectStoreResponse;
        Assertions.assertEquals((Object)responseStr, (Object)IOUtils.toString((InputStream)response.getInputStream(), (Charset)Charset.defaultCharset()));
        if (!asyncFetchEnabled) {
            S3TierObjectStore objectStore1 = new S3TierObjectStore(this.client(), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(Option$.MODULE$.empty())), null, this.config(), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(Option$.MODULE$.empty())));
            Assertions.assertEquals((Object)responseStr, (Object)IOUtils.toString((InputStream)((TierObjectStoreResponse)objectStore1.getObjectStoreFragmentAsync((ObjectStoreMetadata)this.metadata(), FragmentType.SEGMENT).get()).getInputStream(), (Charset)Charset.defaultCharset()));
            return;
        }
    }

    @Test
    public void testGetObjectClientFailure() {
        S3TierObjectStore objectStore = new S3TierObjectStore(this.client(), Optional.of(this.asyncClient()), null, this.config(), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(Option$.MODULE$.empty())));
        ((AmazonS3)Mockito.doThrow((Throwable[])new Throwable[]{new AmazonClientException("client error")}).when((Object)this.client())).getObject((GetObjectRequest)ArgumentMatchers.any(GetObjectRequest.class));
        Assertions.assertThrows(TierObjectStoreRetriableException.class, () -> objectStore.getObjectStoreFragment((ObjectStoreMetadata)this.metadata(), FragmentType.SEGMENT));
        CompletableFuture failedFuture = new CompletableFuture();
        failedFuture.completeExceptionally((Throwable)RetryableException.create((String)"client error"));
        ((S3AsyncClient)Mockito.doAnswer(x$10 -> failedFuture).when((Object)this.asyncClient())).getObject((software.amazon.awssdk.services.s3.model.GetObjectRequest)ArgumentMatchers.any(software.amazon.awssdk.services.s3.model.GetObjectRequest.class), (AsyncResponseTransformer)ArgumentMatchers.any(ByteArrayAsyncResponseTransformer.class));
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> objectStore.getObjectStoreFragmentAsync((ObjectStoreMetadata)this.metadata(), FragmentType.SEGMENT).get())).getCause() instanceof TierObjectStoreRetriableException));
    }

    @Test
    public void testGetObjectNonClientFailures() {
        S3TierObjectStore objectStore = new S3TierObjectStore(this.client(), Optional.of(this.asyncClient()), null, this.config(), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(Option$.MODULE$.empty())));
        ((AmazonS3)Mockito.doThrow((Throwable[])new Throwable[]{(Throwable)Mockito.mock(SdkBaseException.class)}).when((Object)this.client())).getObject((GetObjectRequest)ArgumentMatchers.any(GetObjectRequest.class));
        Assertions.assertThrows(TierObjectStoreFatalException.class, () -> objectStore.getObjectStoreFragment((ObjectStoreMetadata)this.metadata(), FragmentType.SEGMENT));
        CompletableFuture failedFuture = new CompletableFuture();
        failedFuture.completeExceptionally((Throwable)Mockito.mock(NoSuchKeyException.class));
        ((S3AsyncClient)Mockito.doAnswer(x$11 -> failedFuture).when((Object)this.asyncClient())).getObject((software.amazon.awssdk.services.s3.model.GetObjectRequest)ArgumentMatchers.any(software.amazon.awssdk.services.s3.model.GetObjectRequest.class), (AsyncResponseTransformer)ArgumentMatchers.any(ByteArrayAsyncResponseTransformer.class));
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> objectStore.getObjectStoreFragmentAsync((ObjectStoreMetadata)this.metadata(), FragmentType.SEGMENT).get())).getCause() instanceof TierObjectStoreFatalException));
    }

    @Test
    public void testGetEmptyFragmentInEmptyObject() {
        S3TierObjectStore objectStore = new S3TierObjectStore(this.client(), Optional.of(this.asyncClient()), null, this.config(), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(Option$.MODULE$.empty())));
        int segmentSize = 100;
        TopicIdPartition tpid = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        java.util.List segmentAndMetadataLayout = FragmentDescriptionWrapper.createFragmentDescriptionsListWithOneFilePerFragment((TopicIdPartition)tpid, (int)segmentSize, (long)0L, (long)0L, (int)0, (int)0, (long)0L);
        ObjectMetadata metadata = new ObjectMetadata(tpid, UUID.randomUUID(), 0, 0L, true, true, true, OpaqueData.ZEROED, new SegmentAndMetadataLayout(segmentAndMetadataLayout));
        File segmentData = (File)Mockito.mock(File.class);
        ArgumentCaptor captor = ArgumentCaptor.forClass(PutObjectRequest.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)segmentData.length())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(segmentSize)));
        ByteBuffer emptyBuffer = ByteBuffer.wrap(new byte[0]);
        objectStore.putSegment(metadata, segmentData, null, null, Optional.empty(), Optional.of(emptyBuffer), Optional.empty());
        ((AmazonS3)Mockito.verify((Object)this.client(), (VerificationMode)Mockito.times((int)4))).putObject((PutObjectRequest)captor.capture());
        com.amazonaws.services.s3.model.ObjectMetadata objectMetadata = (com.amazonaws.services.s3.model.ObjectMetadata)Mockito.mock(com.amazonaws.services.s3.model.ObjectMetadata.class);
        Mockito.when((Object)this.client().getObjectMetadata(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)objectMetadata);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)objectMetadata.getContentLength())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        InputStream txnIndexInputStream = objectStore.getObjectStoreFragment((ObjectStoreMetadata)metadata, FragmentType.TRANSACTION_INDEX).getInputStream();
        Assertions.assertEquals((int)0, (int)txnIndexInputStream.available());
        AmazonServiceException ex = (AmazonServiceException)Mockito.mock(AmazonServiceException.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)ex.getStatusCode())).thenReturn((Object)BoxesRunTime.boxToInteger((int)404));
        Mockito.when((Object)this.client().getObjectMetadata(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenThrow(new Throwable[]{ex});
        Assertions.assertThrows(TierObjectStoreRetriableException.class, () -> objectStore.getObjectStoreFragment((ObjectStoreMetadata)metadata, FragmentType.TRANSACTION_INDEX));
    }

    @Test
    public void testRefreshCredentialsAfterS3ExpiredTokenException() {
        AWSCredentialsProvider credentialsProvider = (AWSCredentialsProvider)Mockito.mock(AWSCredentialsProvider.class);
        S3TierObjectStore objectStore = new S3TierObjectStore(this.client(), credentialsProvider, this.config(), Optional.empty());
        AmazonS3Exception expiredTokenException = (AmazonS3Exception)Mockito.mock(AmazonS3Exception.class);
        Mockito.when((Object)expiredTokenException.getErrorCode()).thenReturn((Object)"ExpiredToken");
        Mockito.when((Object)this.client().putObject((PutObjectRequest)ArgumentMatchers.any())).thenThrow(new Throwable[]{expiredTokenException});
        int segmentSize = 100;
        ObjectMetadata metadata = new ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, OpaqueData.ZEROED, null);
        File segmentData = (File)Mockito.mock(File.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)segmentData.length())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(segmentSize)));
        this.putSegmentAndCheckForExpectedExceptionAndRefreshCredentials(objectStore, metadata, segmentData, credentialsProvider, expiredTokenException);
        Mockito.clearInvocations((Object[])new AWSCredentialsProvider[]{credentialsProvider});
        credentialsProvider.refresh();
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new RuntimeException("lol AWS has a bug that caused an exception :P")});
        this.putSegmentAndCheckForExpectedExceptionAndRefreshCredentials(objectStore, metadata, segmentData, credentialsProvider, expiredTokenException);
    }

    private void putSegmentAndCheckForExpectedExceptionAndRefreshCredentials(S3TierObjectStore objectStore, ObjectMetadata metadata, File segmentData, AWSCredentialsProvider credentialsProvider, AmazonS3Exception expectedException) {
        try {
            objectStore.putSegment(metadata, segmentData, null, null, Optional.empty(), Optional.empty(), Optional.empty());
            return;
        }
        catch (TierObjectStoreRetriableException e) {
            Assertions.assertEquals((Object)expectedException, (Object)e.getCause(), (String)new StringBuilder(43).append("Unexpected S3 exception during putSegment: ").append((Object)e).toString());
            ((AWSCredentialsProvider)Mockito.verify((Object)credentialsProvider, (VerificationMode)Mockito.times((int)1))).refresh();
            return;
        }
        catch (Throwable e) {
            Assertions.fail((String)new StringBuilder(48).append("Unexpected exception during call to putSegment: ").append(e).toString());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testSinglePutWithAbortedTxns$1(S3TierObjectStoreTest $this, ByteBuffer abortedTxnBuffer$1, PutObjectRequest request) {
        String key = request.getKey();
        Object crc = request.getMetadata().getRawMetadata().get($this.CRC32C_HEADER());
        if (key.contains(E2EChecksumProtectedObjectType.TRANSACTION_INDEX.suffix())) {
            Assertions.assertEquals((Object)E2EChecksumUtils.compute32BitBase64Crc32c((ByteBuffer)abortedTxnBuffer$1), crc);
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testSinglePutProducerStateEpochState$2(PutObjectRequest x$2) {
        return x$2.getKey().contains(".transaction-index");
    }

    public static final /* synthetic */ void $anonfun$testPutSegmentWithCrcEnabledForAllFiles$1(S3TierObjectStoreTest $this, boolean isThrottled$1, long segFileSize$1, long offsetIndexFileSize$1, long timeStampIndexFileSize$1, long producerStateSnapshotFileSize$1, PutObjectRequest request) {
        String key = request.getKey();
        Object crc = request.getMetadata().getRawMetadataValue($this.CRC32C_HEADER());
        if (key.contains(E2EChecksumProtectedObjectType.SEGMENT.suffix())) {
            Assertions.assertEquals((Object)$this.EXPECTED_SEGMENT_CRC(), (Object)crc);
            Assertions.assertEquals((long)(isThrottled$1 ? segFileSize$1 : 0L), (long)request.getMetadata().getContentLength());
            return;
        }
        if (key.contains(E2EChecksumProtectedObjectType.OFFSET_INDEX.suffix())) {
            Assertions.assertEquals((Object)$this.EXPECTED_OFFSET_INDEX_CRC(), (Object)crc);
            Assertions.assertEquals((long)(isThrottled$1 ? offsetIndexFileSize$1 : 0L), (long)request.getMetadata().getContentLength());
            return;
        }
        if (key.contains(E2EChecksumProtectedObjectType.TIMESTAMP_INDEX.suffix())) {
            Assertions.assertEquals((Object)$this.EXPECTED_TIME_INDEX_CRC(), (Object)crc);
            Assertions.assertEquals((long)(isThrottled$1 ? timeStampIndexFileSize$1 : 0L), (long)request.getMetadata().getContentLength());
            return;
        }
        if (key.contains(E2EChecksumProtectedObjectType.PRODUCER_STATE.suffix())) {
            Assertions.assertEquals((Object)$this.EXPECTED_PRODUCER_STATE_CRC(), (Object)crc);
            Assertions.assertEquals((long)(isThrottled$1 ? producerStateSnapshotFileSize$1 : 0L), (long)request.getMetadata().getContentLength());
            return;
        }
        Assertions.assertEquals(null, (Object)crc);
    }

    public static final /* synthetic */ void $anonfun$testPutSegmentWithCrcEnabledForTwoFiles$1(S3TierObjectStoreTest $this, PutObjectRequest request) {
        String key = request.getKey();
        Object crc = request.getMetadata().getRawMetadata().get($this.CRC32C_HEADER());
        if (key.contains(E2EChecksumProtectedObjectType.SEGMENT.suffix())) {
            Assertions.assertEquals(null, crc);
            return;
        }
        if (key.contains(E2EChecksumProtectedObjectType.OFFSET_INDEX.suffix())) {
            Assertions.assertEquals((Object)$this.EXPECTED_OFFSET_INDEX_CRC(), crc);
            return;
        }
        if (key.contains(E2EChecksumProtectedObjectType.TIMESTAMP_INDEX.suffix())) {
            Assertions.assertEquals((Object)$this.EXPECTED_TIME_INDEX_CRC(), crc);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testPutSegmentWithCrcEnabledForOneFile$1(S3TierObjectStoreTest $this, PutObjectRequest request) {
        String key = request.getKey();
        Object crc = request.getMetadata().getRawMetadata().get($this.CRC32C_HEADER());
        if (key.contains(E2EChecksumProtectedObjectType.SEGMENT.suffix())) {
            Assertions.assertEquals((Object)$this.EXPECTED_SEGMENT_CRC(), crc);
            return;
        }
        Assertions.assertEquals(null, crc);
    }

    public static final /* synthetic */ void $anonfun$testPutSegmentWhenChecksumIsInvalid$1(S3TierObjectStoreTest $this, PutObjectRequest request) {
        String key = request.getKey();
        Object crc = request.getMetadata().getRawMetadata().get($this.CRC32C_HEADER());
        if (key.contains(E2EChecksumProtectedObjectType.SEGMENT.suffix())) {
            Assertions.assertEquals(null, crc);
            return;
        }
        if (key.contains(E2EChecksumProtectedObjectType.OFFSET_INDEX.suffix())) {
            Assertions.assertEquals((Object)$this.EXPECTED_SEGMENT_CRC(), crc);
            return;
        }
        if (key.contains(E2EChecksumProtectedObjectType.TIMESTAMP_INDEX.suffix())) {
            Assertions.assertEquals((Object)$this.CRC_DEFAULT_VALUE(), crc);
            return;
        }
    }

    public static final /* synthetic */ CompletableFuture $anonfun$testGetObject$1(ResponseBytes responseBytes$1, InvocationOnMock x$5) {
        return CompletableFuture.completedFuture(responseBytes$1);
    }

    public S3TierObjectStoreTest() {
        this.CRC32C_HEADER = "x-amz-checksum-crc32c";
        this.CRC_DEFAULT_VALUE = "AAAAAA==";
        this.EXPECTED_SEGMENT_CRC = "ugzIxA==";
        this.EXPECTED_OFFSET_INDEX_CRC = "qVw7MA==";
        this.EXPECTED_TIME_INDEX_CRC = "Wze4Mw==";
        this.EXPECTED_PRODUCER_STATE_CRC = "j/3c2A==";
    }
}

