/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import java.io.File;
import java.io.IOException;
import kafka.tier.store.ThrottledFileInputStream;
import kafka.utils.TestUtils;
import kafka.utils.Throttler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ThrottledFileInputStreamTest {
    @Test
    public void testThrottledFileInputStream() throws IOException {
        File file = TestUtils.tempFile("throttledFileInputStreamTestFile", ".tmp", "0123456789");
        Throttler throttler = (Throttler)Mockito.mock(Throttler.class);
        Mockito.when((Object)throttler.maybeThrottle(ArgumentMatchers.anyDouble())).thenReturn((Object)1L);
        try (ThrottledFileInputStream throttledFileInputStream = new ThrottledFileInputStream(file, throttler);){
            throttledFileInputStream.read();
            ((Throttler)Mockito.verify((Object)throttler, (VerificationMode)Mockito.times((int)1))).maybeThrottle(1.0);
            int read2 = throttledFileInputStream.read(new byte[5]);
            Assertions.assertEquals((int)5, (int)read2);
            ((Throttler)Mockito.verify((Object)throttler, (VerificationMode)Mockito.times((int)1))).maybeThrottle(5.0);
            int read3 = throttledFileInputStream.read(new byte[10], 0, 10);
            Assertions.assertEquals((int)4, (int)read3);
            ((Throttler)Mockito.verify((Object)throttler, (VerificationMode)Mockito.times((int)1))).maybeThrottle(4.0);
            int read4 = throttledFileInputStream.read(new byte[5]);
            Assertions.assertEquals((int)-1, (int)read4);
            ((Throttler)Mockito.verify((Object)throttler, (VerificationMode)Mockito.times((int)3))).maybeThrottle(ArgumentMatchers.anyDouble());
        }
        file.delete();
    }
}

