/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kafka.tier.TopicIdPartition;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreMetricsEnabled;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.VersionInformation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import scala.Function1;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005%a\u0001\u0002\f\u0018\u0001yAQ!\n\u0001\u0005\u0002\u0019Bq!\u000b\u0001A\u0002\u0013\u0005!\u0006C\u00048\u0001\u0001\u0007I\u0011\u0001\u001d\t\ry\u0002\u0001\u0015)\u0003,\u0011\u001dy\u0004\u00011A\u0005\u0002\u0001Cq\u0001\u0012\u0001A\u0002\u0013\u0005Q\t\u0003\u0004H\u0001\u0001\u0006K!\u0011\u0005\b\u0011\u0002\u0001\r\u0011\"\u0001J\u0011\u001di\u0005\u00011A\u0005\u00029Ca\u0001\u0015\u0001!B\u0013Q\u0005bB)\u0001\u0005\u0004%\tA\u0015\u0005\u0007-\u0002\u0001\u000b\u0011B*\t\u000f]\u0003!\u0019!C\u00011\"1\u0001\r\u0001Q\u0001\neCq!\u0019\u0001C\u0002\u0013\u0005!\r\u0003\u0004l\u0001\u0001\u0006Ia\u0019\u0005\u0006Y\u0002!\t!\u001c\u0005\u0006s\u0002!\t!\u001c\u0005\u0006}\u0002!\t!\u001c\u0005\u0007\u0003\u0003\u0001A\u0011A7\t\r\u0005\u0015\u0001\u0001\"\u0001n\u0005\u0005\"\u0016.\u001a:PE*,7\r^*u_J,W*\u001a;sS\u000e\u001cXI\\1cY\u0016$G+Z:u\u0015\tA\u0012$A\u0003ti>\u0014XM\u0003\u0002\u001b7\u0005!A/[3s\u0015\u0005a\u0012!B6bM.\f7\u0001A\n\u0003\u0001}\u0001\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001(!\tA\u0003!D\u0001\u0018\u0003\u001diW\r\u001e:jGN,\u0012a\u000b\t\u0003YUj\u0011!\f\u0006\u0003S9R!a\f\u0019\u0002\r\r|W.\\8o\u0015\ta\u0012G\u0003\u00023g\u00051\u0011\r]1dQ\u0016T\u0011\u0001N\u0001\u0004_J<\u0017B\u0001\u001c.\u0005\u001diU\r\u001e:jGN\f1\"\\3ue&\u001c7o\u0018\u0013fcR\u0011\u0011\b\u0010\t\u0003AiJ!aO\u0011\u0003\tUs\u0017\u000e\u001e\u0005\b{\r\t\t\u00111\u0001,\u0003\rAH%M\u0001\t[\u0016$(/[2tA\u0005YqN\u00196fGR\u001cFo\u001c:f+\u0005\t\u0005C\u0001\u0015C\u0013\t\u0019uCA\u000eN_\u000e\\\u0017J\\'f[>\u0014\u0018\u0010V5fe>\u0013'.Z2u'R|'/Z\u0001\u0010_\nTWm\u0019;Ti>\u0014Xm\u0018\u0013fcR\u0011\u0011H\u0012\u0005\b{\u0019\t\t\u00111\u0001B\u00031y'M[3diN#xN]3!\u0003eiW\r\u001e:jGN,e.\u00192mK\u0012|%M[3diN#xN]3\u0016\u0003)\u0003\"\u0001K&\n\u00051;\"!\b+jKJ|%M[3diN#xN]3NKR\u0014\u0018nY:F]\u0006\u0014G.\u001a3\u0002;5,GO]5dg\u0016s\u0017M\u00197fI>\u0013'.Z2u'R|'/Z0%KF$\"!O(\t\u000fuJ\u0011\u0011!a\u0001\u0015\u0006QR.\u001a;sS\u000e\u001cXI\\1cY\u0016$wJ\u00196fGR\u001cFo\u001c:fA\u0005A!/Z:q_:\u001cX-F\u0001T!\tAC+\u0003\u0002V/\t9B+[3s\u001f\nTWm\u0019;Ti>\u0014XMU3ta>t7/Z\u0001\ne\u0016\u001c\bo\u001c8tK\u0002\n\u0001\"\\3uC\u0012\fG/Y\u000b\u00023B\u0011!LX\u0007\u00027*\u0011q\u000b\u0018\u0006\u0003;^\tqa\u001c2kK\u000e$8/\u0003\u0002`7\nqqJ\u00196fGRlU\r^1eCR\f\u0017!C7fi\u0006$\u0017\r^1!\u0003\u0011!\u0018.\\3\u0016\u0003\r\u0004\"\u0001Z5\u000e\u0003\u0015T!AZ4\u0002\tU$\u0018\u000e\u001c\u0006\u0003QB\naa]3sm\u0016\u0014\u0018B\u00016f\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013!B:fiV\u0004H#A\u001d)\u0005Ey\u0007C\u00019x\u001b\u0005\t(B\u0001:t\u0003\r\t\u0007/\u001b\u0006\u0003iV\fqA[;qSR,'O\u0003\u0002wg\u0005)!.\u001e8ji&\u0011\u00010\u001d\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017!\u0005;fgR,\u0006\u000f\\8bI6+GO]5dg\"\u0012!c\u001f\t\u0003arL!!`9\u0003\tQ+7\u000f^\u0001\u0011i\u0016\u001cHOR3uG\"lU\r\u001e:jGND#aE>\u0002+Q,7\u000f\u001e$fi\u000eDW*\u001a;sS\u000e\u001c\u0018i]=oG\"\u0012Ac_\u0001\u0013i\u0016\u001cH\u000fT1uK:\u001c\u00170T3ue&\u001c7\u000f\u000b\u0002\u0016w\u0002")
public class TierObjectStoreMetricsEnabledTest {
    private Metrics metrics = null;
    private MockInMemoryTierObjectStore objectStore = null;
    private TierObjectStoreMetricsEnabled metricsEnabledObjectStore = null;
    private final TierObjectStoreResponse response = (TierObjectStoreResponse)Mockito.mock(TierObjectStoreResponse.class);
    private final ObjectMetadata metadata = new ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, OpaqueData.ZEROED, null);
    private final MockTime time = new MockTime(100L, 1000L);

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public MockInMemoryTierObjectStore objectStore() {
        return this.objectStore;
    }

    public void objectStore_$eq(MockInMemoryTierObjectStore x$1) {
        this.objectStore = x$1;
    }

    public TierObjectStoreMetricsEnabled metricsEnabledObjectStore() {
        return this.metricsEnabledObjectStore;
    }

    public void metricsEnabledObjectStore_$eq(TierObjectStoreMetricsEnabled x$1) {
        this.metricsEnabledObjectStore = x$1;
    }

    public TierObjectStoreResponse response() {
        return this.response;
    }

    public ObjectMetadata metadata() {
        return this.metadata;
    }

    public MockTime time() {
        return this.time;
    }

    @BeforeEach
    public void setup() {
        this.metrics_$eq(new Metrics());
        this.objectStore_$eq((MockInMemoryTierObjectStore)Mockito.mock(MockInMemoryTierObjectStore.class));
        this.metricsEnabledObjectStore_$eq(new TierObjectStoreMetricsEnabled((TierObjectStore)this.objectStore(), this.metrics(), (Time)this.time()));
    }

    @Test
    public void testUploadMetrics() {
        MetricName segmentUploadedTotal = new MetricName("SegmentObjectsUploadedTotal", "TierObjectStore", "", Collections.emptyMap());
        File file = new File("/tmp/tmp");
        Optional<ByteBuffer> bb = Optional.of(ByteBuffer.wrap("test".getBytes()));
        Optional emptyBb = Optional.empty();
        double expected = 0.0;
        this.metricsEnabledObjectStore().putSegment(this.metadata(), file, file, file, Optional.empty(), emptyBb, emptyBb);
        expected += (double)3;
        this.metricsEnabledObjectStore().putSegment(this.metadata(), file, file, file, Optional.of(file), bb, bb);
        expected += (double)6;
        this.metricsEnabledObjectStore().putInMemorySegment(this.metadata(), file, file, file, emptyBb, emptyBb, emptyBb);
        expected += (double)3;
        this.metricsEnabledObjectStore().putInMemorySegment(this.metadata(), file, file, file, bb, bb, bb);
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)(expected += (double)6)), (Object)this.metrics().metric(segmentUploadedTotal).metricValue());
    }

    @Test
    public void testFetchMetrics() {
        MetricName segmentFetchedTotal = new MetricName("SegmentFetchedTotal", "TierObjectStore", "", Collections.emptyMap());
        MetricName offsetIndexFetchedTotal = new MetricName("OffsetIndexFetchedTotal", "TierObjectStore", "", Collections.emptyMap());
        MetricName timestampIndexFetchedTotal = new MetricName("TimestampIndexFetchedTotal", "TierObjectStore", "", Collections.emptyMap());
        MetricName transactionIndexFetchedTotal = new MetricName("TransactionIndexFetchedTotal", "TierObjectStore", "", Collections.emptyMap());
        MetricName producerStateFetchedTotal = new MetricName("ProducerStateFetchedTotal", "TierObjectStore", "", Collections.emptyMap());
        MetricName epochStateFetchedTotal = new MetricName("EpochStateFetchedTotal", "TierObjectStore", "", Collections.emptyMap());
        MetricName tierStateFetchedTotal = new MetricName("TierStateFetchedTotal", "TierObjectStore", "", Collections.emptyMap());
        Mockito.when((Object)this.objectStore().getObjectStoreFragment((ObjectStoreMetadata)ArgumentMatchers.any(), (FragmentType)ArgumentMatchers.any(), (Long)ArgumentMatchers.any(), (Long)ArgumentMatchers.any())).thenReturn((Object)this.response());
        this.metricsEnabledObjectStore().getObjectStoreFragment((ObjectStoreMetadata)this.metadata(), FragmentType.SEGMENT, Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.long2Long(0L));
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.metrics().metric(segmentFetchedTotal).metricValue());
        this.metricsEnabledObjectStore().getObjectStoreFragment((ObjectStoreMetadata)this.metadata(), FragmentType.OFFSET_INDEX, Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.long2Long(0L));
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.metrics().metric(offsetIndexFetchedTotal).metricValue());
        this.metricsEnabledObjectStore().getObjectStoreFragment((ObjectStoreMetadata)this.metadata(), FragmentType.TIMESTAMP_INDEX, Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.long2Long(0L));
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.metrics().metric(timestampIndexFetchedTotal).metricValue());
        this.metricsEnabledObjectStore().getObjectStoreFragment((ObjectStoreMetadata)this.metadata(), FragmentType.TRANSACTION_INDEX, Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.long2Long(0L));
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.metrics().metric(transactionIndexFetchedTotal).metricValue());
        this.metricsEnabledObjectStore().getObjectStoreFragment((ObjectStoreMetadata)this.metadata(), FragmentType.PRODUCER_STATE, Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.long2Long(0L));
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.metrics().metric(producerStateFetchedTotal).metricValue());
        this.metricsEnabledObjectStore().getObjectStoreFragment((ObjectStoreMetadata)this.metadata(), FragmentType.EPOCH_STATE, Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.long2Long(0L));
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.metrics().metric(epochStateFetchedTotal).metricValue());
        this.metricsEnabledObjectStore().getObjectStoreFragment((ObjectStoreMetadata)this.metadata(), FragmentType.TIER_STATE_SNAPSHOT, Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.long2Long(0L));
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.metrics().metric(tierStateFetchedTotal).metricValue());
    }

    @Test
    public void testFetchMetricsAsync() {
        MetricName segmentFetchedTotal = new MetricName("SegmentFetchedTotal", "TierObjectStore", "", Collections.emptyMap());
        MetricName offsetIndexFetchedTotal = new MetricName("OffsetIndexFetchedTotal", "TierObjectStore", "", Collections.emptyMap());
        MetricName timestampIndexFetchedTotal = new MetricName("TimestampIndexFetchedTotal", "TierObjectStore", "", Collections.emptyMap());
        MetricName transactionIndexFetchedTotal = new MetricName("TransactionIndexFetchedTotal", "TierObjectStore", "", Collections.emptyMap());
        MetricName producerStateFetchedTotal = new MetricName("ProducerStateFetchedTotal", "TierObjectStore", "", Collections.emptyMap());
        MetricName epochStateFetchedTotal = new MetricName("EpochStateFetchedTotal", "TierObjectStore", "", Collections.emptyMap());
        MetricName tierStateFetchedTotal = new MetricName("TierStateFetchedTotal", "TierObjectStore", "", Collections.emptyMap());
        Mockito.when((Object)this.objectStore().getObjectStoreFragmentAsync((ObjectStoreMetadata)ArgumentMatchers.any(), (FragmentType)ArgumentMatchers.any(), (Long)ArgumentMatchers.any(), (Long)ArgumentMatchers.any())).thenReturn(CompletableFuture.completedFuture(this.response()));
        this.metricsEnabledObjectStore().getObjectStoreFragmentAsync((ObjectStoreMetadata)this.metadata(), FragmentType.SEGMENT, Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.long2Long(0L));
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.metrics().metric(segmentFetchedTotal).metricValue());
        this.metricsEnabledObjectStore().getObjectStoreFragmentAsync((ObjectStoreMetadata)this.metadata(), FragmentType.OFFSET_INDEX, Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.long2Long(0L));
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.metrics().metric(offsetIndexFetchedTotal).metricValue());
        this.metricsEnabledObjectStore().getObjectStoreFragmentAsync((ObjectStoreMetadata)this.metadata(), FragmentType.TIMESTAMP_INDEX, Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.long2Long(0L));
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.metrics().metric(timestampIndexFetchedTotal).metricValue());
        this.metricsEnabledObjectStore().getObjectStoreFragmentAsync((ObjectStoreMetadata)this.metadata(), FragmentType.TRANSACTION_INDEX, Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.long2Long(0L));
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.metrics().metric(transactionIndexFetchedTotal).metricValue());
        this.metricsEnabledObjectStore().getObjectStoreFragmentAsync((ObjectStoreMetadata)this.metadata(), FragmentType.PRODUCER_STATE, Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.long2Long(0L));
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.metrics().metric(producerStateFetchedTotal).metricValue());
        this.metricsEnabledObjectStore().getObjectStoreFragmentAsync((ObjectStoreMetadata)this.metadata(), FragmentType.EPOCH_STATE, Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.long2Long(0L));
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.metrics().metric(epochStateFetchedTotal).metricValue());
        this.metricsEnabledObjectStore().getObjectStoreFragmentAsync((ObjectStoreMetadata)this.metadata(), FragmentType.TIER_STATE_SNAPSHOT, Predef$.MODULE$.long2Long(0L), Predef$.MODULE$.long2Long(0L));
        Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)this.metrics().metric(tierStateFetchedTotal).metricValue());
    }

    @Test
    public void testLatencyMetrics() {
        MetricName getLatency50Percentile = new MetricName("GetLatency50Percentile", "TierObjectStore", "", Collections.emptyMap());
        MetricName getLatency90Percentile = new MetricName("GetLatency90Percentile", "TierObjectStore", "", Collections.emptyMap());
        MetricName getLatency99Percentile = new MetricName("GetLatency99Percentile", "TierObjectStore", "", Collections.emptyMap());
        MetricName putLatency50Percentile = new MetricName("PutLatency50Percentile", "TierObjectStore", "", Collections.emptyMap());
        MetricName putLatency90Percentile = new MetricName("PutLatency90Percentile", "TierObjectStore", "", Collections.emptyMap());
        MetricName putLatency99Percentile = new MetricName("PutLatency99Percentile", "TierObjectStore", "", Collections.emptyMap());
        MetricName deleteLatency50Percentile = new MetricName("DeleteLatency50Percentile", "TierObjectStore", "", Collections.emptyMap());
        MetricName deleteLatency90Percentile = new MetricName("DeleteLatency90Percentile", "TierObjectStore", "", Collections.emptyMap());
        MetricName deleteLatency99Percentile = new MetricName("DeleteLatency99Percentile", "TierObjectStore", "", Collections.emptyMap());
        File file = new File("/tmp/tmp");
        double latencyDeltaMs = 0.1;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            IntRef sleepTimeInMillisecond = IntRef.create((int)0);
            sleepTimeInMillisecond.elem = i <= 89 ? 0 : (i <= 98 ? 5 : 10);
            ((MockInMemoryTierObjectStore)Mockito.doAnswer(x$1 -> {
                TierObjectStoreMetricsEnabledTest.$anonfun$testLatencyMetrics$2(this, sleepTimeInMillisecond, x$1);
                return BoxedUnit.UNIT;
            }).when((Object)this.objectStore())).putSegment((ObjectMetadata)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (File)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any(), (Optional)ArgumentMatchers.any());
            ((TierObjectStore)Mockito.doAnswer(x$2 -> {
                this.time().sleep((long)sleepTimeInMillisecond$1.elem);
                return this.response();
            }).when((Object)this.objectStore())).getObjectStoreFragment((ObjectStoreMetadata)ArgumentMatchers.any(), (FragmentType)ArgumentMatchers.any(), (Long)ArgumentMatchers.any(), (Long)ArgumentMatchers.any(), (VersionInformation)ArgumentMatchers.any());
            ((MockInMemoryTierObjectStore)Mockito.doAnswer(x$3 -> {
                TierObjectStoreMetricsEnabledTest.$anonfun$testLatencyMetrics$4(this, sleepTimeInMillisecond, x$3);
                return BoxedUnit.UNIT;
            }).when((Object)this.objectStore())).deleteSegment((ObjectMetadata)ArgumentMatchers.any());
            this.metricsEnabledObjectStore().putSegment(this.metadata(), file, file, file, Optional.empty(), Optional.empty(), Optional.empty());
            this.metricsEnabledObjectStore().getObjectStoreFragment((ObjectStoreMetadata)this.metadata(), FragmentType.SEGMENT);
            this.metricsEnabledObjectStore().deleteSegment(this.metadata());
        });
        Assertions.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)this.metrics().metric(putLatency50Percentile).metricValue()), (double)latencyDeltaMs);
        Assertions.assertEquals((double)5.0, (double)BoxesRunTime.unboxToDouble((Object)this.metrics().metric(putLatency90Percentile).metricValue()), (double)latencyDeltaMs);
        Assertions.assertEquals((double)10.0, (double)BoxesRunTime.unboxToDouble((Object)this.metrics().metric(putLatency99Percentile).metricValue()), (double)latencyDeltaMs);
        Assertions.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)this.metrics().metric(getLatency50Percentile).metricValue()), (double)latencyDeltaMs);
        Assertions.assertEquals((double)5.0, (double)BoxesRunTime.unboxToDouble((Object)this.metrics().metric(getLatency90Percentile).metricValue()), (double)latencyDeltaMs);
        Assertions.assertEquals((double)10.0, (double)BoxesRunTime.unboxToDouble((Object)this.metrics().metric(getLatency99Percentile).metricValue()), (double)latencyDeltaMs);
        Assertions.assertEquals((double)0.0, (double)BoxesRunTime.unboxToDouble((Object)this.metrics().metric(deleteLatency50Percentile).metricValue()), (double)latencyDeltaMs);
        Assertions.assertEquals((double)5.0, (double)BoxesRunTime.unboxToDouble((Object)this.metrics().metric(deleteLatency90Percentile).metricValue()), (double)latencyDeltaMs);
        Assertions.assertEquals((double)10.0, (double)BoxesRunTime.unboxToDouble((Object)this.metrics().metric(deleteLatency99Percentile).metricValue()), (double)latencyDeltaMs);
    }

    public static final /* synthetic */ void $anonfun$testLatencyMetrics$2(TierObjectStoreMetricsEnabledTest $this, IntRef sleepTimeInMillisecond$1, InvocationOnMock x$1) {
        $this.time().sleep((long)sleepTimeInMillisecond$1.elem);
    }

    public static final /* synthetic */ void $anonfun$testLatencyMetrics$4(TierObjectStoreMetricsEnabledTest $this, IntRef sleepTimeInMillisecond$1, InvocationOnMock x$3) {
        $this.time().sleep((long)sleepTimeInMillisecond$1.elem);
    }
}

