/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import io.confluent.kafka.storage.checksum.ChecksumStore;
import io.confluent.kafka.storage.checksum.E2EChecksumProtectedObjectType;
import io.confluent.kafka.storage.checksum.E2EChecksumStore;
import java.io.File;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierUploadType;
import kafka.tier.state.SegmentState;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.TierObjectStoreUtils;
import kafka.tier.store.objects.FragmentLocation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005-2A\u0001B\u0003\u0001\u0019!)1\u0003\u0001C\u0001)!)q\u0003\u0001C\u00011!)\u0011\u0006\u0001C\u00011\tAB+[3s\u001f\nTWm\u0019;Ti>\u0014X-\u0016;jYN$Vm\u001d;\u000b\u0005\u00199\u0011!B:u_J,'B\u0001\u0005\n\u0003\u0011!\u0018.\u001a:\u000b\u0003)\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u001bA\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"A\u0003\u0002+Q,7\u000f^&fsB\u000bG\u000f[$f]\u0016\u0014\u0018\r^5p]R\t\u0011\u0004\u0005\u0002\u000f5%\u00111d\u0004\u0002\u0005+:LG\u000f\u000b\u0002\u0003;A\u0011adJ\u0007\u0002?)\u0011\u0001%I\u0001\u0004CBL'B\u0001\u0012$\u0003\u001dQW\u000f]5uKJT!\u0001J\u0013\u0002\u000b),h.\u001b;\u000b\u0003\u0019\n1a\u001c:h\u0013\tAsD\u0001\u0003UKN$\u0018!\u0007;fgR\u0004vn\u001d;QkR\u001cVmZ7f]R\u001cE.Z1okBD#aA\u000f")
public class TierObjectStoreUtilsTest {
    @Test
    public void testKeyPathGeneration() {
        UUID topicId = UUID.fromString("43aeca7f-a684-4b60-bff8-9b3b783691bb");
        String objectIdBase64 = "X01VqsZfTgK0OOTmQrur6g";
        TopicIdPartition topicIdPartition = new TopicIdPartition("foo", topicId, 0);
        UUID objectId = CoreUtils$.MODULE$.uuidFromBase64(objectIdBase64);
        SegmentState metadata = new SegmentState(0, objectId, 50L, 50L, 100L, 100L, 100L, 100, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, false, false, false, TierUploadType.Archive, OpaqueData.ZEROED, TierObjectMetadata.State.INVALID, 99999L, Optional.empty());
        Assertions.assertEquals((Object)"0/X01VqsZfTgK0OOTmQrur6g/Q67Kf6aES2C_-Js7eDaRuw/0/00000000000000000050_0_v0.segment", (Object)((FragmentLocation)new ObjectMetadata(topicIdPartition, metadata).toFragmentLocation("", FragmentType.SEGMENT).get()).objectPath());
        Assertions.assertEquals((Object)"0/X01VqsZfTgK0OOTmQrur6g/Q67Kf6aES2C_-Js7eDaRuw/0/00000000000000000040_0_v0.epoch-state", (Object)((FragmentLocation)new ObjectMetadata(topicIdPartition, new SegmentState(0, objectId, 50L, 40L, 100L, 100L, 100L, 100, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, false, false, false, TierUploadType.Archive, OpaqueData.ZEROED, TierObjectMetadata.State.INVALID, 99999L, Optional.empty())).toFragmentLocation("", FragmentType.EPOCH_STATE).get()).objectPath(), (String)"overlapping segment with differing virtual offset to key offset should use correct object store key");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPostPutSegmentCleanup() {
        void tempFile_suffix;
        void tempFile_suffix2;
        void tempFile_suffix3;
        void tempFile_suffix4;
        E2EChecksumStore checksumStore = TestUtils$.MODULE$.createChecksumStore();
        ChecksumStore store = checksumStore.store();
        String string = ".tmp";
        String tempFile_prefix = E2EChecksumProtectedObjectType.SEGMENT.suffix();
        Object var7_4 = null;
        string = null;
        File segFile = TestUtils.tempFile((String)tempFile_prefix, (String)tempFile_suffix4);
        String string2 = ".tmp";
        String tempFile_prefix2 = E2EChecksumProtectedObjectType.OFFSET_INDEX.suffix();
        Object var9_7 = null;
        string2 = null;
        File offsetIndexFile = TestUtils.tempFile((String)tempFile_prefix2, (String)tempFile_suffix3);
        String string3 = ".tmp";
        String tempFile_prefix3 = E2EChecksumProtectedObjectType.TIMESTAMP_INDEX.suffix();
        Object var11_10 = null;
        string3 = null;
        File timeStampIndexFile = TestUtils.tempFile((String)tempFile_prefix3, (String)tempFile_suffix2);
        String string4 = ".tmp";
        String tempFile_prefix4 = E2EChecksumProtectedObjectType.PRODUCER_STATE.suffix();
        Object var13_13 = null;
        string4 = null;
        File producerStateSnapshotFile = TestUtils.tempFile((String)tempFile_prefix4, (String)tempFile_suffix);
        store.initializeEntry(segFile.getAbsolutePath());
        store.initializeEntry(offsetIndexFile.getAbsolutePath());
        store.initializeEntry(timeStampIndexFile.getAbsolutePath());
        store.initializeEntry(producerStateSnapshotFile.getAbsolutePath());
        TierObjectStoreUtils.postPutSegmentCleanup((E2EChecksumStore)checksumStore, (File)segFile, (File)offsetIndexFile, (File)timeStampIndexFile, Optional.of(producerStateSnapshotFile));
        Assertions.assertFalse((boolean)store.get(segFile.getAbsolutePath()).isPresent());
        Assertions.assertFalse((boolean)store.get(offsetIndexFile.getAbsolutePath()).isPresent());
        Assertions.assertFalse((boolean)store.get(timeStampIndexFile.getAbsolutePath()).isPresent());
        Assertions.assertFalse((boolean)store.get(producerStateSnapshotFile.getAbsolutePath()).isPresent());
    }
}

