/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.objects;

import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.store.objects.FragmentDescriptionWrapper;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FragmentDescriptionWrapperTest {
    private static final TopicIdPartition TOPIC_ID_PARTITION = new TopicIdPartition("test-topic", UUID.randomUUID(), 0);

    @Test
    public void testCreateFragmentDescriptionsListFailsIfSizesAboveIntMax() {
        long invalidOffsetIndexSize = 0x80000000L;
        long invalidTimestampIndexSize = 0x80000000L;
        long invalidProducerStateSize = 0x80000000L;
        Assertions.assertThrows(IllegalArgumentException.class, () -> FragmentDescriptionWrapper.createFragmentDescriptionsListWithOneFilePerFragment((TopicIdPartition)TOPIC_ID_PARTITION, (int)100, (long)invalidOffsetIndexSize, (long)100L, (int)100, (int)100, (long)100L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FragmentDescriptionWrapper.createFragmentDescriptionsListWithOneFilePerFragment((TopicIdPartition)TOPIC_ID_PARTITION, (int)100, (long)100L, (long)invalidTimestampIndexSize, (int)100, (int)100, (long)100L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> FragmentDescriptionWrapper.createFragmentDescriptionsListWithOneFilePerFragment((TopicIdPartition)TOPIC_ID_PARTITION, (int)100, (long)100L, (long)100L, (int)100, (int)100, (long)invalidProducerStateSize));
    }

    @Test
    public void testFragmentDescriptionWrapperProperlySerializesMetadataAndInitialBufferSizeIsLargeEnough() {
        int filePosition = 100;
        int size = 2000;
        FragmentDescriptionWrapper fragmentDescriptionWrapper = new FragmentDescriptionWrapper(FragmentType.SEGMENT, ObjectType.SEGMENT, (long)filePosition, size);
        Assertions.assertEquals((Object)FragmentType.SEGMENT, (Object)fragmentDescriptionWrapper.fragmentType());
        Assertions.assertEquals((Object)ObjectType.SEGMENT, (Object)fragmentDescriptionWrapper.objectType());
        Assertions.assertEquals((long)filePosition, (long)fragmentDescriptionWrapper.filePosition());
        Assertions.assertEquals((int)size, (int)fragmentDescriptionWrapper.size());
        Assertions.assertEquals((int)48, (int)fragmentDescriptionWrapper.underlyingBufferSize(), (String)"FragmentDescriptionWrapper uses an initial buffer size that is too small for the underlying FlatBuffer object, causing an unneccesary buffer re-size to take place.");
    }
}

