/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.objects;

import kafka.tier.store.objects.FragmentLocation;
import kafka.tier.store.objects.ObjectType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FragmentLocationTest {
    private static final String OBJECT_PATH = "/path/to/object.segment";
    private static final ObjectType OBJECT_TYPE = ObjectType.SEGMENT;
    private static final long START_BYTE_OFFSET = 5L;
    private static final long END_BYTE_OFFSET_EXCLUSIVE = 10L;
    private static final long FRAGMENT_SIZE = 5L;

    @Test
    public void testFragmentLocationConstructorThrowsOnIllegalArguments() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new FragmentLocation(OBJECT_PATH, OBJECT_TYPE, 10L, Long.valueOf(9L)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new FragmentLocation(OBJECT_PATH, OBJECT_TYPE, -1L, Long.valueOf(10L)));
        String invalidObjectPath = "/path/to/object.segment.illegal-suffix-that-doesnt-match-object-type";
        Assertions.assertThrows(IllegalArgumentException.class, () -> new FragmentLocation(invalidObjectPath, OBJECT_TYPE));
    }

    @Test
    public void testObjectPathConstructorCorrectlyFillsInDefaultValues() {
        FragmentLocation location = new FragmentLocation(OBJECT_PATH, OBJECT_TYPE);
        Assertions.assertEquals((long)0L, (long)location.startByteOffset());
        Assertions.assertFalse((boolean)location.endByteOffsetExclusive().isPresent());
    }

    @Test
    public void testToByteOffsetStartInObject() {
        FragmentLocation location = new FragmentLocation(OBJECT_PATH, OBJECT_TYPE, 5L, Long.valueOf(10L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> location.toByteOffsetStartInObject(Long.valueOf(-1L)));
        Assertions.assertEquals((long)5L, (long)location.toByteOffsetStartInObject(null));
        Assertions.assertEquals((long)5L, (long)location.toByteOffsetStartInObject(Long.valueOf(0L)));
        Assertions.assertEquals((long)7L, (long)location.toByteOffsetStartInObject(Long.valueOf(2L)));
        Assertions.assertEquals((long)10L, (long)location.toByteOffsetStartInObject(Long.valueOf(5L)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> location.toByteOffsetStartInObject(Long.valueOf(105L)));
        FragmentLocation emptyFragment = new FragmentLocation(OBJECT_PATH, OBJECT_TYPE, 5L, Long.valueOf(5L));
        Assertions.assertEquals((long)5L, (long)emptyFragment.toByteOffsetStartInObject(null));
        Assertions.assertEquals((long)5L, (long)emptyFragment.toByteOffsetStartInObject(Long.valueOf(0L)));
        Assertions.assertThrows(IllegalArgumentException.class, () -> emptyFragment.toByteOffsetStartInObject(Long.valueOf(1L)));
    }

    @Test
    public void testToByteOffsetEndExclusiveInObject() {
        FragmentLocation location = new FragmentLocation(OBJECT_PATH, OBJECT_TYPE, 5L, Long.valueOf(10L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> location.toByteOffsetEndExclusiveInObject(Long.valueOf(-1L)));
        Assertions.assertEquals((long)10L, (Long)location.toByteOffsetEndExclusiveInObject(null));
        Assertions.assertEquals((long)10L, (Long)location.toByteOffsetEndExclusiveInObject(Long.valueOf(5L)));
        Assertions.assertEquals((long)8L, (Long)location.toByteOffsetEndExclusiveInObject(Long.valueOf(3L)));
        Assertions.assertEquals((long)10L, (Long)location.toByteOffsetEndExclusiveInObject(Long.valueOf(6L)));
        Assertions.assertEquals((long)10L, (Long)location.toByteOffsetEndExclusiveInObject(Long.valueOf(105L)));
        FragmentLocation emptyFragment = new FragmentLocation(OBJECT_PATH, OBJECT_TYPE, 5L, Long.valueOf(5L));
        Assertions.assertEquals((long)5L, (Long)emptyFragment.toByteOffsetEndExclusiveInObject(null));
        Assertions.assertEquals((long)5L, (Long)emptyFragment.toByteOffsetEndExclusiveInObject(Long.valueOf(0L)));
        Assertions.assertEquals((long)5L, (Long)emptyFragment.toByteOffsetEndExclusiveInObject(Long.valueOf(1L)));
    }
}

